/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.bubbleBundle;

import com.ibm.rave.bundles.components.BackgroundComponentImpl;
import com.ibm.rave.bundles.components.ComponentConfiguration;
import com.ibm.rave.bundles.components.FilterComponentImpl;
import com.ibm.rave.bundles.components.PackedBubbleComponentImpl;
import com.ibm.rave.bundles.components.PointComponentImpl;
import com.ibm.rave.bundles.data.HierarchyBundleDatum;
import com.ibm.rave.bundles.data.PointDataUtilities;
import com.ibm.rave.bundles.views.BundleView;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.behavior.Zoom;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.color.RGB;
import com.ibm.rave.core.event.Event;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.internal.css.CSSUtil;
import com.ibm.rave.core.layout.AbstractPackLayout;
import com.ibm.rave.core.layout.PackNode;
import com.ibm.rave.core.layout.hierarchy.HierarchyNode;
import com.ibm.rave.core.nativeImpl.EventQueue;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.scales.LinearScale;
import com.ibm.rave.core.scales.OrdinalScale;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.SelectorEventListener;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.util.Runnable;
import com.ibm.rave.ext.layout.bubble.BubbleLayout;
import com.ibm.rave.library.action.ActionOperation;
import com.ibm.rave.library.action.BundleUtils;
import com.ibm.rave.library.action.internal.ActionImpl;
import com.ibm.rave.library.datamodel.DataModel;
import com.ibm.rave.library.datamodel.DataSet;
import com.ibm.rave.library.datamodel.DataSlotEntry;
import com.ibm.rave.library.framework.CoordinateScale;
import com.ibm.rave.library.framework.internal.BundleContext;
import com.ibm.rave.library.framework.internal.CoordinateScaleImpl;
import com.ibm.rave.library.framework.internal.HierarchyUtility;
import com.ibm.rave.library.framework.internal.ScaleManager;
import com.ibm.rave.library.palette.Palette;
import java.util.List;

public class BubbleView
extends BundleView {
    private static final double ZERO_SUB_REDUCTION_FACTOR = 4.0;
    private static final double ZERO_SUB_MAX_VALUE = 2.0;
    @InlineStringConstant
    private static final String DATAMODEL_TABULAR = "tabular";
    @InlineStringConstant
    private static final String DATASET_DATA = "data";
    @InlineStringConstant
    private static final String DATASLOT_X = "x";
    @InlineStringConstant
    private static final String DATASLOT_Y = "y";
    @InlineStringConstant
    private static final String DATASLOT_SIZE = "size";
    @InlineStringConstant
    private static final String DATASLOT_COLOR = "color";
    @InlineStringConstant
    private static final String DATASLOT_LABEL = "label";
    @InlineStringConstant
    private static final String DATASLOT_KEY = "key";
    @InlineStringConstant
    private static final String DATASLOT_CHILDREN = "children";
    @InlineStringConstant
    private static final String SYMBOL_SHAPE = "symbolShape";
    @InlineStringConstant
    private static final String ITEM_COLOR_ID = "itemColor";
    @InlineStringConstant
    private static final String LABEL_DISPLAY = "itemLabel.display";
    @InlineStringConstant
    private static final String LABEL_FONTSTYLE = "labelstyle.font";
    @InlineStringConstant
    private static final String PACKED_BUBBLE_NEGATIVE_VALUE_DISPLAY = "packedBubbleNegativeValueDisplay";
    @InlineStringConstant
    private static final String LABEL_OVERLAP = "itemLabel.overlap";
    @InlineStringConstant
    private static final String LAYOUT_PACKLAYOUT = "PackLayout";
    @InlineStringConstant
    private static final String LAYOUT_BUBBLELAYOUT = "BubbleLayout";
    private boolean clicked = false;
    private boolean lastWasPacked = false;
    private Object handle;
    private PointComponentImpl _pointComponent = null;
    private PackedBubbleComponentImpl _packedBubbleComponent = null;
    private FilterComponentImpl _filter;
    private List<PointDataUtilities.PointDatum> _scatterplotData;
    CoordinateScaleImpl independentScale;
    CoordinateScaleImpl dependentScale;
    private AbstractScale<?, ?> zoomXScale;
    private AbstractScale<?, ?> zoomYScale;
    private boolean scatter;
    private HierarchyUtility.HUResult _hierarchyData;
    private Object zoomendedTimer;
    private static final SingleValueFunction<Object, Object> NOACCESSOR = new SingleValueFunction<Object, Object>(){

        public Object getValue(Object arg0) {
            return null;
        }
    };

    BubbleView(BundleContext context) {
        super(context);
    }

    @Override
    protected boolean isAxesManagerRequired() {
        return true;
    }

    @Override
    public void setup() {
        super.setup();
        this._pointComponent = new PointComponentImpl();
        this._pointComponent.independentAccessor(PointDataUtilities.X_ACCESSOR).dependentAccessor(PointDataUtilities.Y_ACCESSOR);
        this._packedBubbleComponent = new PackedBubbleComponentImpl();
        this._filter = new FilterComponentImpl(this.context.instanceId() + "drop_shadow");
        final BubbleView self = this;
        OMap style = new OMap();
        style.put((Object)"stroke-width", (Object)"0px");
        BundleUtils.setupDefaultActions((BundleContext)this.context, (String)".chart .element-shape", (OMap)style);
        ActionImpl zoomScatter = this.context.actions.action("zoom");
        zoomScatter.setBindFn(new BundleUtils.BindingOperation(){

            public void call() {
                if (self.scatter) {
                    self.context.node.selectAll(".chart").call((RunFunction)((Zoom)self.context.actions.action("zoom").get("zoom")), new Object[0]);
                }
            }
        });
        final ActionImpl zoomAction = (ActionImpl)self.context.actions.action("zoomPackedBubble").setOperation(new ActionOperation(){

            public void call(Object ... args) {
                self._packedBubbleComponent.clickAction(args[0]);
            }
        });
        zoomAction.setBindFn(new BundleUtils.BindingOperation(){

            public void call() {
                self.context.node.selectAll(".element-shape.packed-bubble-parent, .element-shape.packed-bubble-child").on("dblclick.default", (SelectorEventListener)new SelectorEventListener<Event>(){

                    public void onEvent(SceneNode context1, Object data, int index, int groupIndex, Event event) {
                        zoomAction.call(new Object[]{data});
                    }
                });
            }
        });
        final ActionImpl toggleSelectionAction = this.context.actions.action("toggleSelect");
        final ActionImpl deselectAllAction = this.context.actions.action("deselectAll");
        SelectorEventListener<Event> toggleSelectionListener = new SelectorEventListener<Event>(){

            public void onEvent(SceneNode context1, Object data, int index, int groupIndex, Event event) {
                final SceneNode selected = context1;
                if (self.clicked) {
                    self.clicked = false;
                    EventQueue.clearTimeout((Object)self.handle);
                } else {
                    self.clicked = true;
                    self.handle = EventQueue.setTimeout((Runnable)new Runnable(){

                        public void run() {
                            self.clicked = false;
                            if (selected.containsClass("packed-bubble-parent")) {
                                deselectAllAction.call(new Object[]{self.context.node.selectAll(".chart .element-shape")});
                            } else {
                                toggleSelectionAction.call(new Object[]{Rave.select((SceneNode)selected), self.context.node.selectAll(".chart .element-shape").filter("*:not(.packed-bubble-parent)")});
                            }
                        }
                    }, (int)200);
                }
            }
        };
        toggleSelectionAction.setBindFn(new BundleUtils.BindingOperation((SelectorEventListener)toggleSelectionListener){
            final /* synthetic */ SelectorEventListener val$toggleSelectionListener;
            {
                this.val$toggleSelectionListener = selectorEventListener;
            }

            public void call() {
                self.context.node.selectAll(".chart .element-shape").on("click.default", this.val$toggleSelectionListener).on("touchstart.default", this.val$toggleSelectionListener);
            }
        });
    }

    public void draw() {
        if (this.isUpdateNothing()) {
            return;
        }
        this.preDraw("g.vizlibrary-bubble");
        if (!this.validateDataModel("g.element-group", "g.axis")) {
            return;
        }
        if (this.updateType == 0) {
            this.context.actions.action("deselectAll").call(new Object[]{this.context.node.selectAll(".element-group .element-shape")});
        }
        this.setBorder("symbol.borderWidth", "symbol.borderColor");
        int duration = this.getEffectDuration("");
        this.setBackgroundProperties(this._layoutComponent.chartRect(), duration);
        DataSet dataSet = this.dataModel.dataset(DATASET_DATA);
        if (DATAMODEL_TABULAR.equals(this.dataModel.getDescriptor().id())) {
            DataSlotEntry xDataSlotEntry = dataSet.slot(DATASLOT_X).entry();
            DataSlotEntry yDataSlotEntry = dataSet.slot(DATASLOT_Y).entry();
            boolean bl = this.scatter = BubbleView.accessorOf((DataSlotEntry)xDataSlotEntry) != null || BubbleView.accessorOf((DataSlotEntry)yDataSlotEntry) != null;
            if (this.scatter) {
                this.drawScatterplot(this._chart, this.dataModel, duration);
            } else {
                this.drawTabularPackedBubble(this._chart, dataSet, duration);
            }
        } else {
            this.scatter = false;
            this.drawHierarchicalPackedBubble(this._chart, dataSet, duration);
        }
        this.setShadow();
        this.resetUpdate();
    }

    public CoordinateScale getCoordinateScale(String role) {
        if ("ROLE_X1".equals(role)) {
            return this.independentScale;
        }
        if ("ROLE_Y1".equals(role)) {
            return this.dependentScale;
        }
        return null;
    }

    private void setShadow() {
        String drop_shadow = ObjectConverter.asString((Object)this.context.getPropertyValue("shadow.style"));
        Object[] style = CSSUtil.parseShadowStyle((Object)drop_shadow);
        if (style != null) {
            this._filter.setDropshadow(this.context.convertCSSSizeToPixels(style[0]), this.context.convertCSSSizeToPixels(style[1]), this.context.convertCSSSizeToPixels(style[2]), (RGB)style[3]);
            this.context.node.select((Object)"defs").call((RunFunction)this._filter, new Object[0]);
        }
        boolean enabled = style != null && this.getBooleanProperty("shadow.display");
        this.applyShadow(this.context.node.select((Object)"g.element-group").selectAll("path.element-shape"), enabled, drop_shadow);
        this.applyShadow(this.context.node.selectAll("path.packed-bubble-parent"), false, null);
        this.applyShadow(this.context.node.select((Object)"g.legendGroup").selectAll("path.legendShape"), enabled, drop_shadow);
    }

    private void applyShadow(Selector s, boolean enabled, String drop_shadow) {
        s.attr("filter", enabled ? "url(#" + this._filter.getId() + ")" : null).property("_rave_drop_shadow", (Object)(enabled ? drop_shadow : null));
    }

    private void drawScatterplot(final Selector chart, DataModel dataModel, int inDuration) {
        boolean legendVisibilityChanged;
        this.lastWasPacked = false;
        int duration = inDuration;
        String effect = this.getStringProperty("effect.name");
        if (effect == null || "none".equals(effect)) {
            duration = 0;
        }
        DataSet dataSet = dataModel.dataset(DATASET_DATA);
        DataSlotEntry xDataSlotEntry = dataSet.slot(DATASLOT_X).entry();
        DataSlotEntry yDataSlotEntry = dataSet.slot(DATASLOT_Y).entry();
        DataSlotEntry colorDataSlotEntry = dataSet.slot(DATASLOT_COLOR).entry();
        DataSlotEntry sizeDataSlotEntry = dataSet.slot(DATASLOT_SIZE).entry();
        if (colorDataSlotEntry == null) {
            String label = null;
            if (xDataSlotEntry != null && xDataSlotEntry.label() != null) {
                label = xDataSlotEntry.label();
            }
            if (yDataSlotEntry != null && yDataSlotEntry.label() != null) {
                String string = label = label == null ? yDataSlotEntry.label() : label + ", " + yDataSlotEntry.label();
            }
            if (sizeDataSlotEntry != null && sizeDataSlotEntry.label() != null) {
                label = label == null ? sizeDataSlotEntry.label() : label + ", " + sizeDataSlotEntry.label();
            }
            dataSet.slot(DATASLOT_COLOR).overrideLabel(label);
        }
        SingleValueFunction xAccessor = BubbleView.accessorOf((DataSlotEntry)xDataSlotEntry);
        SingleValueFunction yAccessor = BubbleView.accessorOf((DataSlotEntry)yDataSlotEntry);
        ArrayEx originalData = ObjectConverter.listToArray((List)((List)dataSet.data()));
        this._scatterplotData = PointDataUtilities.buildPoints((List<Object>)originalData, (SingleValueFunction<Object, Object>)xAccessor, (SingleValueFunction<Object, Object>)BubbleView.domainCheckerOf((List)originalData, (DataSlotEntry)xDataSlotEntry), (SingleValueFunction<Object, Object>)yAccessor, (SingleValueFunction<Object, Object>)BubbleView.domainCheckerOf((List)originalData, (DataSlotEntry)yDataSlotEntry));
        double glyphSize1 = Math.abs(ObjectConverter.toDouble((Object)this.context.getPropertyValue("sizeScale.first")));
        double glyphSize2 = Math.abs(ObjectConverter.toDouble((Object)this.context.getPropertyValue("sizeScale.second")));
        List domain = ScaleManager.numericDomain((List)originalData, (DataSlotEntry)sizeDataSlotEntry);
        LinearScale sizeScale = domain != null ? Rave.scale.linear().domain(domain).range((List)new ArrayEx(new Object[]{glyphSize1, glyphSize2})) : null;
        Palette colorPalette = this.getPalette();
        colorPalette.setData(dataSet, DATASLOT_COLOR);
        colorPalette.setAccessor(BubbleView.originalDatumAccessor((SingleValueFunction)dataSet.slot(DATASLOT_COLOR).entry()));
        colorPalette.setNullColor(ObjectConverter.asString((Object)this.context.getPropertyValue("color.null")));
        boolean showLegend = this.isShowLegend();
        boolean bl = legendVisibilityChanged = this._legends.anyVisible() != showLegend;
        if (legendVisibilityChanged) {
            this.updateType = 1;
        }
        OrdinalScale swatchSizeColors = null;
        if (sizeScale != null) {
            double minValue = ObjectConverter.toDouble(domain.get(0));
            double maxValue = ObjectConverter.toDouble(domain.get(1));
            String nullColor = ObjectConverter.asString((Object)this.context.getPropertyValue("color.null"));
            swatchSizeColors = Rave.scale.ordinal().domain((List)new ArrayEx(new Object[]{minValue, maxValue})).range((List)new ArrayEx(new Object[]{nullColor}));
        }
        String legendPosition = this.getLegendPosition();
        String symbol = this.getStringProperty(SYMBOL_SHAPE);
        this._legends.position(legendPosition).transition(!"none".equals(effect), duration).setPreExecute(this.context.getPreExecute()).visible(0, showLegend).selector(0, this.context.node.selectAll("g.legendColor")).palette(0, colorPalette).shape(0, symbol).title(0, this.context.getDataSlotLabel("legend.title", colorDataSlotEntry)).titleFill(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fill"))).titleFontSize(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontsize"))).titleFontFamily(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontfamily"))).setDataSlot(0, colorDataSlotEntry).visible(1, showLegend && sizeScale != null).selector(1, this.context.node.selectAll("g.legendSize")).scale(1, (AbstractScale<?, ?>)swatchSizeColors).swatchSize(1, new ValueFunction<Object, Object>((AbstractScale)sizeScale){
            final /* synthetic */ AbstractScale val$sizeScale;
            {
                this.val$sizeScale = abstractScale;
            }

            public Object getValue(Object context, Object _data, int index, int groupIndex) {
                return ObjectConverter.toDouble((Object)this.val$sizeScale.getValue(null, _data, index, groupIndex));
            }
        }).shape(1, "circle").setDataSlot(1, sizeDataSlotEntry);
        boolean transpose = this.getBooleanProperty("transpose");
        if (this.updateType <= 1) {
            boolean isLegendLeftOrRight;
            this.independentScale = ScaleManager.makeCoordinateScale((List)originalData, (DataSlotEntry)xDataSlotEntry);
            this.dependentScale = ScaleManager.makeCoordinateScale((List)originalData, (DataSlotEntry)yDataSlotEntry);
            Number subDomainDivisionY = yDataSlotEntry == null ? (Number)null : (Number)yDataSlotEntry.subDomainDivision();
            Double scaleDivisionY = subDomainDivisionY == null ? null : Double.valueOf(ObjectConverter.toDouble((Object)subDomainDivisionY));
            Number subDomainDivisionX = xDataSlotEntry == null ? (Number)null : (Number)xDataSlotEntry.subDomainDivision();
            Double scaleDivisionX = subDomainDivisionX == null ? null : Double.valueOf(ObjectConverter.toDouble((Object)subDomainDivisionX));
            this._axes.visible(true).duration(duration).transpose(transpose).scale(0, this.independentScale).scale(2, this.dependentScale).setDataSlot(0, xDataSlotEntry).setDataSlot(2, yDataSlotEntry).useDefaultSelectors().useDefaultX1Properties(true).useDefaultY1Properties(true).scaleTickMagnitude(2, scaleDivisionY).scaleTickMagnitude(0, scaleDivisionX).setTickFormatter(0, xDataSlotEntry).setTickFormatter(2, yDataSlotEntry);
            this.prepareLayoutComponent();
            this.prepareLayoutSizables(this._layoutComponent, false, true, true, false, this._legends.anyVisible());
            boolean bl2 = isLegendLeftOrRight = "left".equals(legendPosition) || "right".equals(legendPosition);
            if (isLegendLeftOrRight) {
                this._legends.preLayout(this._layoutComponent, false);
                this._axes.preLayout(this._layoutComponent, false, 0.1, 0.05, 0, 0.1, 0.0, 0);
            } else {
                this._axes.preLayout(this._layoutComponent, true, 0.1, 0.05, 0, 0.1, 0.0, 0);
                this._legends.preLayout(this._layoutComponent, true);
            }
            this._layoutComponent.layout();
            legendPosition = this._layoutComponent.legendPosition();
            this._axes.useBoundsFromLayout(this._layoutComponent).setScaleRanges(0.1, 0.05, 0);
            double pixels = 2.0 + Math.sqrt(Math.max(glyphSize1, glyphSize2));
            if (this.independentScale != null) {
                this.independentScale.expandZeroExtent(false);
                this.independentScale.expandPixels(pixels, false);
                if (this.getBooleanProperty("axis.x.scale.nice")) {
                    this.independentScale.nice((Number)scaleDivisionX);
                }
                if (this.getBooleanProperty("axis.x.scale.includeZero")) {
                    this.independentScale.includeZero();
                }
                if (transpose) {
                    this.zoomYScale = this.independentScale.scale().copy();
                } else {
                    this.zoomXScale = this.independentScale.scale().copy();
                }
            }
            if (this.dependentScale != null) {
                this.dependentScale.expandZeroExtent(false);
                this.dependentScale.expandPixels(pixels, false);
                if (this.getBooleanProperty("axis.y.scale.nice")) {
                    this.dependentScale.nice((Number)scaleDivisionY);
                }
                if (this.getBooleanProperty("axis.y.scale.includeZero")) {
                    this.dependentScale.includeZero();
                }
                if (transpose) {
                    this.zoomXScale = this.dependentScale.scale().copy();
                } else {
                    this.zoomYScale = this.dependentScale.scale().copy();
                }
            }
            this.resetZoom();
            this._legends.rectangle(this._layoutComponent.legendRect());
        }
        RectStruct elementRect = this._layoutComponent.elementRect();
        this._clip.clipRect(elementRect).applyTo(chart.select((Object)".content")).run((Selection<?>)this.context.node.select((Object)"defs"), new Object[0]);
        chart.select((Object)"rect.background.elements").attr(DATASLOT_X, (Object)elementRect.x).attr(DATASLOT_Y, (Object)elementRect.y).attr("width", (Object)elementRect.width).attr("height", (Object)elementRect.height);
        CoordinateScaleImpl xScale = this.independentScale;
        CoordinateScaleImpl yScale = this.dependentScale;
        if (transpose) {
            xScale = this.dependentScale;
            yScale = this.independentScale;
        }
        DataSlotEntry keyDataSlotEntry = dataSet.slot(DATASLOT_KEY).entry();
        DataSlotEntry labelDataSlotEntry = dataSet.slot(DATASLOT_LABEL).entry();
        ((PointComponentImpl)this._pointComponent.data(this._scatterplotData.toArray()).key((SingleValueFunction<Object, Object>)BubbleView.originalDatumAccessor((SingleValueFunction)BubbleView.accessorOf((DataSlotEntry)keyDataSlotEntry)))).sizeAccessor((SingleValueFunction<Object, Object>)BubbleView.originalDatumAccessor((SingleValueFunction)BubbleView.accessorOf((DataSlotEntry)sizeDataSlotEntry))).labelAccessor((SingleValueFunction<Object, Object>)BubbleView.originalDatumAccessor((SingleValueFunction)BubbleView.accessorOf((DataSlotEntry)labelDataSlotEntry)));
        ((PointComponentImpl)this._pointComponent.bounds(elementRect).independentScale(this.independentScale).dependentScale(this.dependentScale).transpose(transpose).colorPalette(colorPalette).sizeScale((AbstractScale<?, ?>)sizeScale).effect(effect).labelFont(this.getBackgroundConstrastLabelStyle()).labelFormatter((ValueFunction<Object, String>)this.context.getCustomFormatterForElementLabels(labelDataSlotEntry)).labelContrast(this.getBooleanProperty("contrast.label.color")).labelShadow(this.getBooleanProperty("label.shadow")).setPreExecute(this.context.getPreExecute())).defaultSize(glyphSize2).symbol(symbol).itemOverlap(this.getBooleanProperty(LABEL_OVERLAP)).itemLabel(this.getBooleanProperty(LABEL_DISPLAY)).itemLabelPosition(new ValueFunction<Object, Integer>(){

            public Integer getValue(Object context, Object data, int index, int groupIndex) {
                return 5;
            }
        }).borderWidth(this.context.convertCSSSizeToPixels(this.context.getPropertyValue("symbol.borderWidth"))).borderColor(ObjectConverter.asString((Object)this.context.getPropertyValue("symbol.borderColor")));
        if (this.updateType <= 2) {
            String ops = this.getStringProperty("zoom");
            if (xScale != null && (ops.equals("all") || ops.equals(DATASLOT_X))) {
                xScale.scale().domain(this.zoomXScale.domain());
            }
            if (yScale != null && (ops.equals("all") || ops.equals(DATASLOT_Y))) {
                yScale.scale().domain(this.zoomYScale.domain());
            }
            final BubbleView self = this;
            final Zoom zoom = (Zoom)this.context.actions.action("zoom").get("zoom");
            ComponentConfiguration.configureZoom(chart, zoom, xScale, yScale, null, null, null, elementRect, this._zoomP, this._zoomS, ops, new RunFunction<SceneNode>(){

                public Object run(SceneNode context1, Object ... args) {
                    chart.selectAll("g.elements").call((RunFunction)self._pointComponent, new Object[0]);
                    self._axes.redraw(true);
                    zoom.on("zoomend.hideLabels", (RunFunction)new RunFunction<SceneNode>(){

                        public Object run(SceneNode context, Object ... args) {
                            if (self._axes.hideAnyPanZoom()) {
                                if (self.zoomendedTimer != null) {
                                    EventQueue.clearTimeout((Object)self.zoomendedTimer);
                                }
                                self.zoomendedTimer = EventQueue.setTimeout((Runnable)new Runnable(){

                                    public void run() {
                                        self.zoomendedTimer = null;
                                        self._axes.redraw(false);
                                    }
                                }, (int)300);
                            }
                            return null;
                        }
                    });
                    return chart;
                }
            });
        }
        if (this.updateType <= 3) {
            chart.selectAll("g.elements").transition().duration((Object)duration).call((RunFunction)this._pointComponent, new Object[0]);
            this._axes.visible(true).duration(duration).useDefaultSelectors().useDefaultX1Properties(true).useDefaultY1Properties(true).setTickFormatter(0, xDataSlotEntry).setTickFormatter(2, yDataSlotEntry);
            this._axes.draw();
            this._legends.draw();
        }
        chart.selectAll(".element-shape").classed("bundle-shape", true);
        chart.selectAll(".legendShape").classed("bundle-shape", true);
    }

    @Override
    protected int getLegendCount() {
        return 2;
    }

    private void drawHierarchicalPackedBubble(Selector chart, DataSet dataSet, int duration) {
        if (this.updateType == 0) {
            HierarchyUtility builder = new HierarchyUtility((HierarchyUtility.HUFactory)new HierarchyUtility.HUFactory<PackNode>(){

                public PackNode make() {
                    return new PackNode();
                }
            });
            this._hierarchyData = builder.buildHierarchy(dataSet.data(), BubbleView.accessorOf((DataSlotEntry)dataSet.slot(DATASLOT_CHILDREN).entry()), BubbleView.accessorOf((DataSlotEntry)dataSet.slot(DATASLOT_SIZE).entry()), 1.0);
        }
        this.renderPackedBubble(chart, dataSet, duration, false);
    }

    private void drawTabularPackedBubble(Selector chart, DataSet dataSet, int duration) {
        if (this.updateType == 0) {
            HierarchyUtility builder = new HierarchyUtility((HierarchyUtility.HUFactory)new HierarchyUtility.HUFactory<PackNode>(){

                public PackNode make() {
                    return new PackNode();
                }
            });
            this._hierarchyData = builder.buildTabular((List)ObjectConverter.listToArray((List)((List)dataSet.data())), BubbleView.accessorOf((DataSlotEntry)dataSet.slot(DATASLOT_SIZE).entry()), 1.0);
        }
        this.renderPackedBubble(chart, dataSet, duration, true);
    }

    private void renderPackedBubble(final Selector chart, DataSet dataSet, int duration, boolean tabular) {
        this.independentScale = null;
        this.dependentScale = null;
        this.context.actions.action("zoom").getUnBind().call();
        int _duration = duration;
        String effect = this.getStringProperty("effect.name");
        if (effect == null || "none".equals(effect)) {
            _duration = 0;
        }
        if (!this.lastWasPacked) {
            chart.selectAll("path.element-shape").remove();
            chart.selectAll("text.element-label").remove();
            this.lastWasPacked = true;
        }
        this._axes.visible(false).draw();
        final int colorLevel = this.getIntProperty(ITEM_COLOR_ID);
        final DataSlotEntry colorAccessor = dataSet.slot(DATASLOT_COLOR).entry();
        SingleValueFunction<Object, Object> colorDataAccessor = this.colorAccessor(colorLevel, (SingleValueFunction<Object, Object>)colorAccessor);
        boolean legendDisplay = this.isShowLegend();
        String legendPosition = this.getLegendPosition();
        Palette colorPalette = this.getPalette();
        this._legends.position(legendPosition).transition(!"none".equals(effect), _duration).setPreExecute(this.context.getPreExecute()).visible(0, legendDisplay).selector(0, this.context.node.selectAll("g.legendColor")).palette(0, colorPalette).shape(0, "circle").title(0, this.context.getDataSlotLabel("legend.title", colorAccessor)).titleFill(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fill"))).titleFontSize(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontsize"))).titleFontFamily(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontfamily"))).setDataSlot(0, colorAccessor).visible(1, false);
        final boolean showNegatives = this.getBooleanProperty(PACKED_BUBBLE_NEGATIVE_VALUE_DISPLAY);
        List domain = null;
        if (colorAccessor != null) {
            SingleValueFunction<Object, Object> domainColorDataAccessor = new SingleValueFunction<Object, Object>(){

                public Object getValue(Object data) {
                    double dValue;
                    Object value;
                    PackNode d = (PackNode)data;
                    if (d.children != null) {
                        return null;
                    }
                    for (int i = 0; i < d.depth - colorLevel; ++i) {
                        d = (PackNode)d.parent;
                    }
                    Object object = value = d.data == null ? null : colorAccessor.getValue(d.data);
                    if (!showNegatives && value != null && (dValue = ObjectConverter.toDouble((Object)value)) < 0.0) {
                        value = null;
                    }
                    return value;
                }
            };
            domain = colorAccessor.domain();
            if (domain == null) {
                boolean isNumeric = "numeric".equals(colorAccessor.type());
                String type = isNumeric ? "numeric" : "string";
                boolean sort = isNumeric;
                domain = ScaleManager.ordinalDomainWithValueFunction((List)this._hierarchyData._nodes, (String)type, (SingleValueFunction)domainColorDataAccessor, (boolean)sort);
            }
        }
        colorPalette.setData(domain, dataSet, DATASLOT_COLOR);
        colorPalette.setAccessor(colorDataAccessor);
        colorPalette.setNullColor(ObjectConverter.asString((Object)this.context.getPropertyValue("color.null")));
        this.prepareLayoutComponent();
        this.prepareLayoutSizables(this._layoutComponent, false, false, false, false, legendDisplay);
        this._legends.preLayout(this._layoutComponent);
        this._layoutComponent.layout();
        legendPosition = this._layoutComponent.legendPosition();
        this._legends.position(legendPosition);
        Object pack = LAYOUT_BUBBLELAYOUT.equals(this.getStringProperty("pack")) ? (BubbleLayout)Rave.layout.extension("bubble") : Rave.layout.pack();
        RectStruct chartRect = this._layoutComponent.chartRect();
        pack.sort(null);
        pack.size(new double[]{chartRect.width - 2.0, chartRect.height - 2.0});
        ArrayEx<PackNode> nodes = this._hierarchyData._root != null ? this.packNodes((AbstractPackLayout<?>)pack, dataSet) : new ArrayEx<PackNode>();
        ArrayEx mappedNodes = nodes.map((ArrayEx.ArrayValueFunction)new ArrayEx.ArrayValueFunction<PackNode, HierarchyBundleDatum<PackNode>>(){

            public HierarchyBundleDatum<PackNode> getValue(PackNode currentValue, int index, ArrayEx<PackNode> array) {
                HierarchyBundleDatum<PackNode> d = new HierarchyBundleDatum<PackNode>();
                d._hierarchyNode = currentValue;
                return d;
            }
        });
        DataSlotEntry labelEntry = dataSet.slot(DATASLOT_LABEL).entry();
        this._clip.clipRect(chartRect).run((Selection<?>)this.context.node.select((Object)"defs"), new Object[0]);
        this._legends.rectangle(this._layoutComponent.legendRect());
        ((PackedBubbleComponentImpl)((PackedBubbleComponentImpl)this._packedBubbleComponent.data((ArrayEx<? extends Object>)mappedNodes).colorPalette(colorPalette).duration(_duration).bounds(chartRect).hideRoot(tabular).sizeAccessor((SingleValueFunction<Object, Object>)BubbleView.originalDatumAccessor((SingleValueFunction)BubbleView.accessorOf((DataSlotEntry)dataSet.slot(DATASLOT_SIZE).entry()))).labelAccessor(this.labelAccessor((SingleValueFunction<Object, Object>)labelEntry)).labelFont(ObjectConverter.asString((Object)this.context.getPropertyValue(LABEL_FONTSTYLE))).labelFormatter((ValueFunction<Object, String>)this.context.getCustomFormatterForElementLabels(labelEntry)).labelContrast(this.getBooleanProperty("contrast.label.color")).labelShadow(this.getBooleanProperty("label.shadow")).key((SingleValueFunction<Object, Object>)BubbleView.originalDatumAccessor((SingleValueFunction)BubbleView.accessorOf((DataSlotEntry)dataSet.slot(DATASLOT_KEY).entry())))).packNodeAccessor(new SingleValueFunction<PackNode, Object>(){

            public PackNode getValue(Object data) {
                return (PackNode)((HierarchyBundleDatum)data)._hierarchyNode;
            }
        }).setPreExecute(this.context.getPreExecute())).itemLabel(this.getBooleanProperty(LABEL_DISPLAY)).clipItemLabels(true).borderWidth(this.context.convertCSSSizeToPixels(this.context.getPropertyValue("symbol.borderWidth"))).borderColor(ObjectConverter.asString((Object)this.context.getPropertyValue("symbol.borderColor")));
        ((BackgroundComponentImpl)this._backgroundComponent.setPreExecute(this.context.getPreExecute())).rect(chartRect).backgroundColor((String)this.context.getPropertyValue("background.elements.color"));
        this.context.node.selectAll("rect.background.elements").transition().duration((Object)duration).call((RunFunction)this._backgroundComponent, new Object[0]);
        chart.selectAll("g.elements").transition().duration((Object)_duration).call((RunFunction)this._packedBubbleComponent, new Object[0]);
        this._legends.draw();
        ComponentConfiguration.configureZoom(chart, null, null, null, null, null, null, chartRect, this._zoomP, this._zoomS, "none", new RunFunction<SceneNode>(){

            public Object run(SceneNode context1, Object ... args) {
                return chart;
            }
        });
    }

    private ArrayEx<PackNode> packNodes(AbstractPackLayout<?> pack, DataSet dataSet) {
        boolean showNegatives = this.getBooleanProperty(PACKED_BUBBLE_NEGATIVE_VALUE_DISPLAY);
        double domainMin = Double.NaN;
        double domainMax = Double.NaN;
        List domain = null;
        DataSlotEntry sizeEntry = dataSet.slot(DATASLOT_SIZE).entry();
        if (sizeEntry != null) {
            domain = sizeEntry.domain();
        }
        if (domain != null && domain.size() == 2) {
            domainMin = ObjectConverter.toDouble(domain.get(0));
            domainMax = ObjectConverter.toDouble(domain.get(1));
        }
        ArrayEx zeroValuedNodes = new ArrayEx();
        PackNode clonedRoot = this.cloneNode(null, (PackNode)this._hierarchyData._root, showNegatives, (ArrayEx<PackNode>)zeroValuedNodes, null, domainMin, domainMax);
        double[] lowestValue = new double[]{Double.MAX_VALUE};
        this.processTree((PackNode)this._hierarchyData._root, clonedRoot, showNegatives, (ArrayEx<PackNode>)zeroValuedNodes, lowestValue, domainMin, domainMax);
        if (zeroValuedNodes.size() > 0) {
            double low = Math.min(lowestValue[0] / 4.0, 2.0);
            for (PackNode zeroNode : zeroValuedNodes) {
                zeroNode.value = low;
            }
        }
        ArrayEx nodes = pack.create((HierarchyNode)clonedRoot);
        return nodes;
    }

    private void processTree(PackNode node, PackNode clonedNode, boolean showNegatives, ArrayEx<PackNode> zeroValuedNodes, double[] lowestValue, double domainMin, double domainMax) {
        if (node.children != null) {
            for (PackNode child : node.children) {
                PackNode clonedChild = this.cloneNode(clonedNode, child, showNegatives, zeroValuedNodes, lowestValue, domainMin, domainMax);
                if (clonedChild == null) continue;
                if (clonedNode.children == null) {
                    clonedNode.children = new ArrayEx();
                }
                clonedNode.children.add((Object)clonedChild);
                this.processTree(child, clonedChild, showNegatives, zeroValuedNodes, lowestValue, domainMin, domainMax);
            }
        }
    }

    private PackNode cloneNode(PackNode clonedParentNode, PackNode node, boolean showNegatives, ArrayEx<PackNode> zeroValuedNodes, double[] lowestValue, double domainMin, double domainMax) {
        if (!showNegatives && node.value < 0.0) {
            return null;
        }
        PackNode clone = new PackNode();
        clone.data = node.data;
        clone.depth = node.depth;
        clone.parent = clonedParentNode;
        clone.value = Math.abs(node.value);
        if (!Double.isNaN(domainMin) && node.value < domainMin) {
            clone.value = Math.abs(domainMin);
        }
        if (!Double.isNaN(domainMax) && node.value > domainMax) {
            clone.value = Math.abs(domainMax);
        }
        if (clone.value == 0.0) {
            zeroValuedNodes.add((Object)clone);
        } else if (lowestValue != null && clone.value < lowestValue[0]) {
            lowestValue[0] = clone.value;
        }
        return clone;
    }

    protected int requireUpdate(String property) {
        DataModel dataModel = this.context.dataModel();
        if (DATAMODEL_TABULAR.equals(dataModel.getDescriptor().id())) {
            if (property.equals(ITEM_COLOR_ID)) {
                return 4;
            }
        } else {
            if (property.equals("sizeScale.first") || property.equals("sizeScale.second")) {
                return 4;
            }
            if (property.equals("transpose") || property.equals(SYMBOL_SHAPE)) {
                return 4;
            }
            if (property.equals("axis.x.title.text") || property.equals("axis.x.title.display")) {
                return 4;
            }
            if (property.equals("axis.y.title.text") || property.equals("axis.y.title.display")) {
                return 4;
            }
            if (property.equals("axis.x.title.style.fill") || property.equals("axis.x.line.style.stroke") || property.equals("axis.x.labels.style.fill") || property.equals("axis.y.title.style.fill") || property.equals("axis.y.line.style.stroke") || property.equals("axis.y.labels.style.fill")) {
                return 4;
            }
            if (property.equals("axis.y.gridlines.style.stroke") || property.equals("axis.x.gridlines.style.stroke") || property.equals("axis.y.gridlines.display") || property.equals("axis.x.gridlines.display") || property.equals("axis.y.gridlines.style.stroke-dasharray") || property.equals("axis.x.gridlines.style.stroke-dasharray")) {
                return 4;
            }
            if (property.equals("zoom")) {
                return 4;
            }
        }
        return super.requireUpdate(property);
    }

    private ValueFunction<Object, Object> labelAccessor(final SingleValueFunction<Object, Object> labelAccessor) {
        if (labelAccessor == null) {
            return null;
        }
        return new ValueFunction<Object, Object>(){

            public Object getValue(Object context1, Object data, int index, int gindex) {
                PackNode d = (PackNode)((HierarchyBundleDatum)data)._hierarchyNode;
                if (d.data == null || d.children != null) {
                    return null;
                }
                return ObjectConverter.asString((Object)labelAccessor.getValue(d.data));
            }
        };
    }

    private SingleValueFunction<Object, Object> colorAccessor(final int colorLevel, final SingleValueFunction<Object, Object> colorAccessor) {
        if (colorAccessor == null) {
            return null;
        }
        return new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                PackNode d = (PackNode)((HierarchyBundleDatum)data)._hierarchyNode;
                if (d.children != null) {
                    return null;
                }
                for (int i = 0; i < d.depth - colorLevel; ++i) {
                    d = (PackNode)d.parent;
                }
                return d.data == null ? null : colorAccessor.getValue(d.data);
            }
        };
    }

    @Override
    protected String[] getGroupStructure() {
        return new String[]{"defs", "g.vizlibrary vizlibrary-bubble", "(", "rect.background chart", "g.chart", "(", "g.content", "(", "rect.background elements", "g.gridlines", "(", "g.grid left", "g.grid bottom", ")", "g.elements", "(", "g.element-group", "g.element-label-group", ")", ")", "g.axes", "(", "g.axes-layout", "g.axisTransform left", "g.axisTransform bottom", ")", ")", "g.legends", "(", "g.legends-layout", "g.legendColor", "g.legendSize", ")", ")"};
    }
}

