/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.bulletBundle;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.bundles.components.BulletComponentDataUtilities;
import com.ibm.rave.bundles.components.BulletComponentImpl;
import com.ibm.rave.bundles.views.BundleView;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.internal.nativeImpl.Lang;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.util.Comparator;
import com.ibm.rave.library.action.BundleUtils;
import com.ibm.rave.library.datamodel.DataSet;
import com.ibm.rave.library.datamodel.DataSlotEntry;
import com.ibm.rave.library.framework.internal.BundleContext;
import com.ibm.rave.library.framework.internal.CoordinateScaleImpl;
import com.ibm.rave.library.framework.internal.OrdinalCoordinateScale;
import com.ibm.rave.library.palette.Palette;
import com.ibm.rave.library.palette.internal.ConditionalPalette;
import java.util.List;

public class BulletBundleView
extends BundleView {
    private BulletComponentImpl _bulletComponent = null;
    private static final String MIN_SLOT = "min";
    private static final String MID_SLOT = "mid";
    private static final String MAX_SLOT = "max";
    private static final String ACTUAL_SLOT = "actual";
    private static final String FORECAST_SLOT = "forecast";
    private static final String PREVIOUS_SLOT = "previous";
    private static final String GOAL_SLOT = "goal";
    private static final String SUBTITLE_SLOT = "subtitle";
    private static final String TITLE_SLOT = "title";
    private static final String GOOD_COLOR = "color.good";
    private static final String SATISFACTORY_COLOR = "color.satisfactory";
    private static final String UNSATISFACTORY_COLOR = "color.unsatisfactory";
    private static final String ACTUAL_COLOR = "color.actual";
    private static final String FORECAST_COLOR = "color.forecast";
    private static final String MARKER_COLOR = "color.marker";
    private static final String CATEGORY_HEIGHT = "bullet.categoryHeight";
    private static final String BULLET_SIZE = "bullet.size";
    private static final String BULLET_MARKER_SIZE = "bullet.markerSize";
    private static final String STAGGER = "effect.delay";
    private static final String TITLE_FONT_SIZE = "axis.title.fontsize";
    private static final String TITLE_FONT_FAMILY = "axis.title.fontfamily";
    private static final String TITLE_COLOR = "axis.title.color";
    private static final String TITLE_VISIBLE = "axis.independent.titleDisplay";
    private static final String AXIS_NICE = "axis.independent.nice";
    private static final String AXIS_LINE_COLOR = "axis.line.color";
    private static final String AXIS_LABEL_COLOR = "axis.label.color";
    private static final String AXIS_LABEL_WRAP = "axis.label.wrap";
    private static final String BULLET_DATASET = "bulletData";
    private int _duration = 0;
    private ArrayEx<ArrayEx<BulletComponentDataUtilities.RangeStruct>> _processedRangesInfoArray;
    private ArrayEx<ArrayEx<BulletComponentDataUtilities.RangeStruct>> _processedMeasuresInfoArray;
    static final String PADDING = "padding.name";
    static final String RANGES_INFO_RANGES = "rangesLabelsAndColors.ranges";
    static final String RANGES_INFO_COLORS_AND_LABELS = "rangesLabelsAndColors.colorsAndLabels";

    BulletBundleView(BundleContext context) {
        super(context);
    }

    @Override
    public void setup() {
        super.setup();
        this._bulletComponent = new BulletComponentImpl();
        OMap style = new OMap();
        style.put((Object)"stroke-width", (Object)"0px");
        BundleUtils.setupDefaultActions((BundleContext)this.context, (String)".bulletContent rect", (OMap)style);
    }

    public void draw() {
        if (this.isUpdateNothing()) {
            return;
        }
        this.preDraw("g.vizlibrary-bullet");
        if (!this.validateDataModel(new String[0])) {
            return;
        }
        DataSet dataSet = this.dataModel.dataset(BULLET_DATASET);
        DataSlotEntry titleDataAccessor = dataSet.slot(TITLE_SLOT).entry();
        DataSlotEntry subtitleDataAccessor = dataSet.slot(SUBTITLE_SLOT).entry();
        final DataSlotEntry minDataAccessor = dataSet.slot(MIN_SLOT).entry();
        final DataSlotEntry midDataAccessor = dataSet.slot(MID_SLOT).entry();
        final DataSlotEntry maxDataAccessor = dataSet.slot(MAX_SLOT).entry();
        final DataSlotEntry actualDataAccessor = dataSet.slot(ACTUAL_SLOT).entry();
        final DataSlotEntry forecastDataAccessor = dataSet.slot(FORECAST_SLOT).entry();
        final DataSlotEntry previousDataAccessor = dataSet.slot(PREVIOUS_SLOT).entry();
        final DataSlotEntry goalDataAccessor = dataSet.slot(GOAL_SLOT).entry();
        ArrayEx data = ObjectConverter.listToArray((List)((List)dataSet.data()));
        JSONObject colorMap = new JSONObject();
        colorMap.put((Object)"rangeMin", this.context.properties.property(UNSATISFACTORY_COLOR).value());
        colorMap.put((Object)"rangeMid", this.context.properties.property(SATISFACTORY_COLOR).value());
        colorMap.put((Object)"rangeMax", this.context.properties.property(GOOD_COLOR).value());
        colorMap.put((Object)"Actualmeasure", this.context.properties.property(ACTUAL_COLOR).value());
        colorMap.put((Object)"Forecastmeasure", this.context.properties.property(FORECAST_COLOR).value());
        colorMap.put((Object)"Marker", this.context.properties.property(MARKER_COLOR).value());
        this.processRangeInfo(colorMap, (ArrayEx<Object>)data);
        JSONObject jsonPalette2 = new JSONObject();
        jsonPalette2.put((Object)"id", (Object)"ConditionalPalette");
        jsonPalette2.put((Object)"label", (Object)"Conditional Palette");
        jsonPalette2.put((Object)"description", (Object)"Conditional Palette");
        jsonPalette2.put((Object)"icon", (Object)"someicon");
        jsonPalette2.put((Object)"fillType", (Object)"conditional");
        JSONArray fills = new JSONArray();
        jsonPalette2.put((Object)"fills", (Object)fills);
        for (Object objKey : colorMap.keySet()) {
            JSONObject fill = new JSONObject();
            fill.put((Object)"fill", colorMap.get(objKey));
            JSONArray values = new JSONArray();
            String key = ObjectConverter.asString(objKey).replace("range", "").replace("measure", "");
            values.add((Object)key);
            fill.put((Object)"values", (Object)values);
            fills.add((Object)fill);
        }
        ConditionalPalette colorPalette = new ConditionalPalette(jsonPalette2);
        boolean useLegend = this.isShowLegend();
        String legendPosition = this.getLegendPosition();
        this._legends.visible(useLegend).position(legendPosition).setPreExecute(this.context.getPreExecute()).selector(0, this.context.node.selectAll("g.legend")).palette(0, (Palette)colorPalette).shape(0, "square").title(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.title"))).titleFill(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fill"))).titleFontSize(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontsize"))).titleFontFamily(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontfamily"))).formatterList(0, (ArrayEx<DataSlotEntry>)new ArrayEx(), "none", null);
        this.prepareLayoutComponent();
        this.prepareLayoutSizables(this._layoutComponent, false, false, false, false, useLegend);
        this._legends.preLayout(this._layoutComponent);
        this._layoutComponent.layout();
        legendPosition = this._layoutComponent.legendPosition();
        RectStruct elementRect = this._layoutComponent.elementRect();
        RectStruct legendRect = this._layoutComponent.legendRect();
        String effect = this.getStringProperty("effect.name");
        this._duration = this.getEffectDuration(effect);
        this._clip.clipRect(elementRect).applyTo(this._chart.select((Object)".content")).run((Selection<?>)this.context.node.select((Object)"defs").transition().duration((Object)this._duration), new Object[0]);
        this._bulletComponent.width(elementRect.width).height(elementRect.height).x(elementRect.x).y(elementRect.y);
        int duration = ObjectConverter.toInt((Object)this.context.getPropertyValue("effect.duration"));
        int categoryHeight = ObjectConverter.toInt((Object)this.context.getPropertyValue(CATEGORY_HEIGHT));
        categoryHeight = categoryHeight <= 100 ? categoryHeight : 100;
        int bulletSize = ObjectConverter.toInt((Object)this.context.getPropertyValue(BULLET_SIZE));
        bulletSize = bulletSize <= 100 ? bulletSize : 100;
        int bulletMarkerSize = ObjectConverter.toInt((Object)this.context.getPropertyValue(BULLET_MARKER_SIZE));
        bulletMarkerSize = bulletMarkerSize <= 100 ? bulletMarkerSize : 100;
        this.setBackgroundProperties(elementRect, duration);
        ArrayEx yDomain = new ArrayEx(0);
        for (int i = 0; i < data.size(); ++i) {
            yDomain.add((Object)i);
        }
        OrdinalCoordinateScale dependentScale = OrdinalCoordinateScale.create((List)yDomain);
        dependentScale.range(0.0, elementRect.height, Double.valueOf(0.1), Double.valueOf(0.0));
        OMap axisColors = new OMap();
        axisColors.put((Object)"axisLineColor", (Object)ObjectConverter.asString((Object)this.context.getPropertyValue(AXIS_LINE_COLOR)));
        axisColors.put((Object)"labelColor", (Object)ObjectConverter.asString((Object)this.context.getPropertyValue(AXIS_LABEL_COLOR)));
        OMap axisTitleStyle = new OMap();
        axisTitleStyle.put((Object)"titleColor", this.context.getPropertyValue(TITLE_COLOR));
        axisTitleStyle.put((Object)"titleFont", this.context.getPropertyValue(TITLE_FONT_FAMILY));
        axisTitleStyle.put((Object)"titleFontSize", this.context.getPropertyValue(TITLE_FONT_SIZE));
        axisTitleStyle.put((Object)"titleVisible", this.context.getPropertyValue(TITLE_VISIBLE));
        this._bulletComponent.data(data.toArray()).titleDataAccessor((SingleValueFunction<Object, Object>)titleDataAccessor.accessor()).subtitleDataAccessor((SingleValueFunction<Object, Object>)subtitleDataAccessor.accessor()).rangesDataAccessor(new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return new ArrayEx(new Object[]{minDataAccessor.getValue(data), midDataAccessor.getValue(data), maxDataAccessor.getValue(data)});
            }
        }).markersDataAccessor(new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return new ArrayEx(new Object[]{previousDataAccessor.getValue(data), goalDataAccessor.getValue(data)});
            }
        }).measuresDataAccessor(new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return new ArrayEx(new Object[]{actualDataAccessor.getValue(data), forecastDataAccessor.getValue(data)});
            }
        }).dependentScale((CoordinateScaleImpl)dependentScale, ObjectConverter.toBoolean((Object)this.context.getPropertyValue(AXIS_NICE))).colorPalette((Palette)colorPalette).rangesInfo(this._processedRangesInfoArray).measuresInfo(this._processedMeasuresInfoArray).duration(duration).categoryHeight(categoryHeight).bulletSize(bulletSize).bulletMarkerSize(bulletMarkerSize).stagger((Boolean)this.context.getPropertyValue(STAGGER)).showAxisLine((Boolean)this.context.getPropertyValue("axis.independent.visible.line")).showTicks((Boolean)this.context.getPropertyValue("axis.independent.visible.ticks")).showLabel((Boolean)this.context.getPropertyValue("axis.independent.visible.tickLabels")).axisColors((OMap<String, String>)axisColors).axisTitleStyles((OMap<String, Object>)axisTitleStyle).transition(!"none".equals(effect)).wrapAxisLabels((Boolean)this.context.getPropertyValue(AXIS_LABEL_WRAP));
        this._chart.selectAll("g.element-group").transition().duration((Object)this._duration).call((RunFunction)this._bulletComponent, new Object[0]);
        this._legends.transition(!"none".equals(effect), duration).rectangle(legendRect).draw();
    }

    private void processRangeInfo(JSONObject colorMap, ArrayEx<Object> data) {
        this._processedRangesInfoArray = new ArrayEx();
        this._processedMeasuresInfoArray = new ArrayEx();
        ArrayEx<Object> rangesArray = data;
        for (int i = 0; i < rangesArray.size(); ++i) {
            ArrayEx rangeStructs = new ArrayEx();
            ArrayEx measureStructs = new ArrayEx();
            JSONObject bulletData = (JSONObject)rangesArray.get(i);
            for (Object objKey : bulletData.keySet()) {
                String key = ObjectConverter.asString(objKey);
                key = key.substring(0, 1).toUpperCase() + key.substring(1);
                BulletComponentDataUtilities.RangeStruct struct = new BulletComponentDataUtilities.RangeStruct();
                struct.label = key;
                struct.color = ObjectConverter.toString((Object)colorMap.get((Object)key));
                if (colorMap.containsKey((Object)("range" + key))) {
                    struct.color = ObjectConverter.toString((Object)colorMap.get((Object)("range" + key)));
                    struct.value = ObjectConverter.asDouble((Object)((JSONObject)data.get(i)).get((Object)key.toLowerCase()));
                    rangeStructs.add((Object)struct);
                }
                if (!colorMap.containsKey((Object)(key + "measure"))) continue;
                struct.color = ObjectConverter.toString((Object)colorMap.get((Object)(key + "measure")));
                struct.value = ObjectConverter.asDouble((Object)((JSONObject)data.get(i)).get((Object)key.toLowerCase()));
                if (struct.value == null) continue;
                measureStructs.add((Object)struct);
            }
            rangeStructs = rangeStructs.slice().sort((Comparator)new Comparator<BulletComponentDataUtilities.RangeStruct>(){

                public int compare(BulletComponentDataUtilities.RangeStruct a, BulletComponentDataUtilities.RangeStruct b) {
                    return Lang.lessThan((Object)b.value, (Object)a.value) ? -1 : (Lang.greaterThan((Object)b.value, (Object)a.value) ? 1 : 0);
                }
            });
            measureStructs = measureStructs.slice().sort((Comparator)new Comparator<BulletComponentDataUtilities.RangeStruct>(){

                public int compare(BulletComponentDataUtilities.RangeStruct a, BulletComponentDataUtilities.RangeStruct b) {
                    return Lang.lessThan((Object)b.value, (Object)a.value) ? -1 : (Lang.greaterThan((Object)b.value, (Object)a.value) ? 1 : 0);
                }
            });
            this._processedRangesInfoArray.add((Object)rangeStructs);
            this._processedMeasuresInfoArray.add((Object)measureStructs);
        }
    }

    @Override
    protected String[] getGroupStructure() {
        return new String[]{"defs", "g.vizlibrary vizlibrary-bullet", "(", "rect.background chart", "g.chart", "(", "g.content", "(", "rect.background elements", "g.elements", "(", "g.element-group", "(", "g.bullet-elements", ")", ")", ")", ")", "g.legends", "(", "g.legends-layout", "g.legend", ")", ")"};
    }
}

