/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.chordBundle;

import com.ibm.rave.bundles.components.ChordComponentImpl;
import com.ibm.rave.bundles.views.BundleView;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.event.Event;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.SelectorEventListener;
import com.ibm.rave.library.action.BundleUtils;
import com.ibm.rave.library.action.internal.ActionImpl;
import com.ibm.rave.library.action.internal.OperationsUtil;
import com.ibm.rave.library.datamodel.DataSet;
import com.ibm.rave.library.datamodel.DataSlotEntry;
import com.ibm.rave.library.framework.internal.BundleContext;
import com.ibm.rave.library.palette.Palette;
import java.util.ArrayList;
import java.util.List;

public class ChordBundleView
extends BundleView {
    private static final String CHORDDIAGRAM_DATA_GROUPS = "group";
    private static final String CHORDDIAGRAM_DATA_CHORDS = "chord";
    private static final OMap<String, Object> chordsOriginalStyle = ChordBundleView.initChordsOriginalStyle();
    private static final OMap<String, Object> groupsOriginalStyle = ChordBundleView.initGroupsOriginalStyle();
    private ChordComponentImpl _chordComponent = null;
    static final String LEGEND_POSITION = "legend.position";
    private static final int CHORDS_LEGEND = 1;
    static final String CHORDS_LEGEND_DISPLAY = "legend.chords.display";
    static final String CHORDS_LEGEND_TITLE = "legend.chords.title";
    static final String CHORDS_LEGEND_TITLESTYLE_FONT = "legend.chords.titlestyle.font";
    static final String CHORDS_LEGEND_TITLESTYLE_FILL = "legend.chords.titlestyle.fill";
    static final String CHORDS_LEGEND_TITLESTYLE_FONTSIZE = "legend.chords.titlestyle.fontsize";
    static final String CHORDS_LEGEND_TITLESTYLE_FONTFAMILY = "legend.chords.titlestyle.fontfamily";
    static final String CHORDS_LEGEND_ENTRYSTYLE_FONT = "legend.chords.entrystyle.font";
    private static final int GROUPS_LEGEND = 0;
    static final String GROUPS_LEGEND_DISPLAY = "legend.groups.display";
    static final String GROUPS_LEGEND_TITLE = "legend.groups.title";
    static final String GROUPS_LEGEND_TITLESTYLE_FONT = "legend.groups.titlestyle.font";
    static final String GROUPS_LEGEND_TITLESTYLE_FILL = "legend.groups.titlestyle.fill";
    static final String GROUPS_LEGEND_TITLESTYLE_FONTSIZE = "legend.groups.titlestyle.fontsize";
    static final String GROUPS_LEGEND_TITLESTYLE_FONTFAMILY = "legend.groups.titlestyle.fontfamily";
    static final String GROUPS_LEGEND_ENTRYSTYLE_FONT = "legend.groups.entrystyle.font";
    static final String CHORDS_COLOR_PALETTE = "color.chords.palette";
    static final String GROUP_COLOR_PALETTE = "color.groups.palette";
    static final String TICK_LINES = "ticklines";
    static final String TICK_VALUES = "tickvalues";
    static final String TICK_STEP_ADJUSTER = "tickStepAdjuster";
    static final String TICK_TEXT_FREQUENCY = "tickTextFrequency";
    static final String TICK_SUFFIX = "tickSuffix";
    static final String TICK_VALUE_DIVIDER = "tickValueDivider";
    static final String TICKSTYLE_FONT = "tickstyle.font";
    static final String LABELSTYLE_FONT = "labelstyle.font";
    private RectStruct chartRect;
    private RectStruct legendRect;
    private DataSlotEntry sourceLabelDataAccessor;
    private DataSlotEntry sourceValueDataAccessor;
    private DataSlotEntry targetLabelDataAccessor;
    private DataSlotEntry targetValueDataAccessor;
    private DataSlotEntry chordColorDataAccessor;
    private DataSlotEntry groupColorDataAccessor;
    private DataSlotEntry groupLabelDataAccessor;
    private ArrayEx<Object> chorddata;
    private ArrayEx<Object> groupData;

    private static OMap<String, Object> initChordsOriginalStyle() {
        OMap map = new OMap();
        map.put((Object)"stroke-width", (Object)"0px");
        map.put((Object)"opacity", (Object)0.8);
        return map;
    }

    private static OMap<String, Object> initGroupsOriginalStyle() {
        OMap map = new OMap();
        map.put((Object)"opacity", (Object)"1");
        map.put((Object)"stroke", null);
        return map;
    }

    ChordBundleView(BundleContext context) {
        super(context);
    }

    @Override
    public void setup() {
        super.setup();
        final ChordBundleView self = this;
        this._chordComponent = ChordComponentImpl.create();
        final ActionImpl unHighlightAction = this.context.actions.action("unhighlight");
        unHighlightAction.setOperation(OperationsUtil.chordUnhighlight(chordsOriginalStyle, groupsOriginalStyle));
        SelectorEventListener<Event> unHighlightActionEventListener = new SelectorEventListener<Event>(){

            public void onEvent(SceneNode context1, Object data, int index, int groupIndex, Event event) {
                unHighlightAction.call(new Object[]{Rave.select((SceneNode)context1), self.context.node.selectAll(".chart .chord"), self.context.node.selectAll(".chart .groupPath")});
            }
        };
        unHighlightAction.setBindFn(BundleUtils.bindOrUnbindActionFunctionCreater((BundleContext)this.context, (String)".chart .groupPath", (String[])new String[]{"mouseout.default"}, (SelectorEventListener)unHighlightActionEventListener));
        unHighlightAction.setUnbindFn(BundleUtils.bindOrUnbindActionFunctionCreater((BundleContext)this.context, (String)".chart .groupPath", (String[])new String[]{"mouseout.default"}, null));
        final ActionImpl highlightAction = this.context.actions.action("highlight");
        highlightAction.setOperation(OperationsUtil.chordHighlight());
        SelectorEventListener<Event> highlightActionEventListener = new SelectorEventListener<Event>(){

            public void onEvent(SceneNode context1, Object data, int index, int groupIndex, Event event) {
                highlightAction.call(new Object[]{Rave.select((SceneNode)context1), self.context.node.selectAll(".chart .chord"), self.context.node.selectAll(".chart .groupPath")});
            }
        };
        highlightAction.setBindFn(BundleUtils.bindOrUnbindActionFunctionCreater((BundleContext)this.context, (String)".chart .groupPath", (String[])new String[]{"mouseenter.default"}, (SelectorEventListener)highlightActionEventListener));
        highlightAction.setUnbindFn(BundleUtils.bindOrUnbindActionFunctionCreater((BundleContext)this.context, (String)".chart .groupPath", (String[])new String[]{"mouseenter.default"}, null));
        final ActionImpl deselectAllAction = this.context.actions.action("deselectAll");
        deselectAllAction.setOperation(OperationsUtil.chordDeselectAll(chordsOriginalStyle, groupsOriginalStyle));
        SelectorEventListener<Event> deselectAllEventListener = new SelectorEventListener<Event>(){

            public void onEvent(SceneNode context1, Object data, int index, int groupIndex, Event event) {
                deselectAllAction.call(new Object[]{self.context.node.selectAll(".chart .element-shape")});
            }
        };
        deselectAllAction.setBindFn(BundleUtils.bindOrUnbindActionFunctionCreater((BundleContext)this.context, (String)".background", (String[])new String[]{"click.default", "touchstart.default"}, (SelectorEventListener)deselectAllEventListener));
        deselectAllAction.setUnbindFn(BundleUtils.bindOrUnbindActionFunctionCreater((BundleContext)this.context, (String)".background", (String[])new String[]{"click.default", "touchstart.default"}, null));
        final ActionImpl toggleSelectionAction = (ActionImpl)this.context.actions.action("toggleSelect").setOperation(OperationsUtil.chordToggle(chordsOriginalStyle, groupsOriginalStyle));
        SelectorEventListener<Event> toggleSelectionListener = new SelectorEventListener<Event>(){

            public void onEvent(SceneNode context1, Object data, int index, int groupIndex, Event event) {
                toggleSelectionAction.call(new Object[]{Rave.select((SceneNode)context1), self.context.node.selectAll(".chart .element-shape")});
            }
        };
        toggleSelectionAction.setBindFn(BundleUtils.bindOrUnbindActionFunctionCreater((BundleContext)this.context, (String)".chart .chord", (String[])new String[]{"click.default", "touchstart.default"}, (SelectorEventListener)toggleSelectionListener));
        toggleSelectionAction.setUnbindFn(BundleUtils.bindOrUnbindActionFunctionCreater((BundleContext)this.context, (String)".chart .chord", (String[])new String[]{"click.default", "touchstart.default"}, null));
    }

    @Override
    protected int getLegendCount() {
        return 2;
    }

    @Override
    protected boolean isZoomSupported() {
        return false;
    }

    public void draw() {
        String groupEntryString;
        String groupTitleString;
        String chordEntryString;
        if (this.isUpdateNothing()) {
            return;
        }
        this.preDraw("g.vizlibrary-chorddiagram");
        if (!this.validateDataModel(new String[0])) {
            return;
        }
        DataSet chordDataSet = this.dataModel.dataset(CHORDDIAGRAM_DATA_CHORDS);
        DataSet groupDataSet = this.dataModel.dataset(CHORDDIAGRAM_DATA_GROUPS);
        if (this.updateType == 0) {
            this.sourceLabelDataAccessor = chordDataSet.slot("source").entry();
            this.sourceValueDataAccessor = chordDataSet.slot("sourceValue").entry();
            this.targetLabelDataAccessor = chordDataSet.slot("target").entry();
            this.targetValueDataAccessor = chordDataSet.slot("targetValue").entry();
            this.chordColorDataAccessor = chordDataSet.slot("color").entry();
            this.groupColorDataAccessor = groupDataSet.slot("color").entry();
            this.groupLabelDataAccessor = groupDataSet.slot("label").entry();
            this.chorddata = ObjectConverter.listToArray((List)((List)chordDataSet.data()));
            this.groupData = ObjectConverter.listToArray((List)((List)groupDataSet.data()));
            this.context.actions.action("deselectAll").call(new Object[]{this.context.node.selectAll(".chart .element-shape")});
        }
        Palette chordColorPalette = null;
        if (this.chordColorDataAccessor != null) {
            chordColorPalette = this.getPalette(CHORDS_COLOR_PALETTE);
            chordColorPalette.setData(chordDataSet, "color");
        }
        Palette groupColorPalette = this.getPalette(GROUP_COLOR_PALETTE);
        groupColorPalette.setData(groupDataSet, "color");
        if (this.groupData != null && this.groupData.length() > 0) {
            groupColorPalette.setAccessor((SingleValueFunction)this.groupColorDataAccessor);
        }
        if (this.groupData == null && groupDataSet != null) {
            ArrayList<Object> sources = new ArrayList<Object>();
            ChordBundleView.prepareSourcesList(sources, (SingleValueFunction<Object, Object>)this.sourceLabelDataAccessor.accessor(), this.chorddata.toArray());
            groupColorPalette.setData(sources, groupDataSet, "color");
        }
        String effect = this.getStringProperty("effect.name");
        int duration = this.getEffectDuration(effect);
        boolean useChordsLegend = this.getBooleanProperty(CHORDS_LEGEND_DISPLAY);
        boolean useGroupsLegend = this.getBooleanProperty(GROUPS_LEGEND_DISPLAY);
        boolean useLegend = useChordsLegend || useGroupsLegend;
        double padding = 40.0;
        String legendPosition = this.getLegendPosition();
        String chordTitleString = ObjectConverter.asString((Object)this.context.getPropertyValue(CHORDS_LEGEND_TITLESTYLE_FONT));
        if (chordTitleString != null) {
            this._legends.titleFont(1, chordTitleString);
        }
        if ((chordEntryString = ObjectConverter.asString((Object)this.context.getPropertyValue(CHORDS_LEGEND_ENTRYSTYLE_FONT))) != null) {
            this._legends.entryFont(1, chordEntryString);
        }
        if ((groupTitleString = ObjectConverter.asString((Object)this.context.getPropertyValue(GROUPS_LEGEND_TITLESTYLE_FONT))) != null) {
            this._legends.titleFont(0, groupTitleString);
        }
        if ((groupEntryString = ObjectConverter.asString((Object)this.context.getPropertyValue(GROUPS_LEGEND_ENTRYSTYLE_FONT))) != null) {
            this._legends.entryFont(0, groupEntryString);
        }
        this._legends.position(legendPosition).transition(!"none".equals(effect), duration).setPreExecute(this.context.getPreExecute()).visible(0, useGroupsLegend).selector(0, this.context.node.selectAll("g.legend2")).palette(0, groupColorPalette).shape(0, "square").title(0, this.context.getDataSlotLabel(GROUPS_LEGEND_TITLE, this.groupColorDataAccessor)).titleFill(0, ObjectConverter.asString((Object)this.context.getPropertyValue(GROUPS_LEGEND_TITLESTYLE_FILL))).titleFontSize(0, ObjectConverter.asString((Object)this.context.getPropertyValue(GROUPS_LEGEND_TITLESTYLE_FONTSIZE))).titleFontFamily(0, ObjectConverter.asString((Object)this.context.getPropertyValue(GROUPS_LEGEND_TITLESTYLE_FONTFAMILY))).setDataSlot(0, this.groupColorDataAccessor).visible(1, useChordsLegend).selector(1, this.context.node.selectAll("g.legend1")).palette(1, chordColorPalette).shape(1, "square").title(1, this.context.getDataSlotLabel(CHORDS_LEGEND_TITLE, this.chordColorDataAccessor)).titleFill(1, ObjectConverter.asString((Object)this.context.getPropertyValue(CHORDS_LEGEND_TITLESTYLE_FILL))).titleFontSize(1, ObjectConverter.asString((Object)this.context.getPropertyValue(CHORDS_LEGEND_TITLESTYLE_FONTSIZE))).titleFontFamily(1, ObjectConverter.asString((Object)this.context.getPropertyValue(CHORDS_LEGEND_TITLESTYLE_FONTFAMILY))).setDataSlot(1, this.chordColorDataAccessor);
        if (this.updateType <= 1) {
            this.prepareLayoutComponent();
            this.prepareLayoutSizables(this._layoutComponent, false, false, false, false, useLegend);
            this._legends.preLayout(this._layoutComponent);
            this._layoutComponent.layout();
            legendPosition = this._layoutComponent.legendPosition();
            this._legends.position(legendPosition);
            this.chartRect = this._layoutComponent.elementRect();
            this.legendRect = this._layoutComponent.legendRect();
            this._clip.clipRect(this.chartRect).applyTo(this._chart.select((Object)".content")).run((Selection<?>)this.context.node.select((Object)"defs").transition().duration((Object)duration), new Object[0]);
            this._legends.rectangle(this.legendRect);
        }
        this._chordComponent.groupColorAccessor(this.groupColorDataAccessor != null ? this.groupColorDataAccessor.accessor() : null);
        this._chordComponent.setChordColorAccessor(this.chordColorDataAccessor != null ? this.chordColorDataAccessor.accessor() : null);
        this._chordComponent.groupLabelAccessor((SingleValueFunction<Object, Object>)this.groupLabelDataAccessor.accessor()).groupDataSet(groupDataSet);
        this._chordComponent.chordsOriginalStyle(chordsOriginalStyle).groupsOriginalStyle(groupsOriginalStyle);
        this._chordComponent.padding(padding).setSourceIdAccessor((SingleValueFunction<Object, Object>)this.sourceLabelDataAccessor.accessor()).setSourceValueAccessor((SingleValueFunction<Object, Object>)this.sourceValueDataAccessor.accessor()).setTargetIdAccessor((SingleValueFunction<Object, Object>)this.targetLabelDataAccessor.accessor()).setTargetValueAccessor((SingleValueFunction<Object, Object>)this.targetValueDataAccessor.accessor()).tickFont(ObjectConverter.asString((Object)this.context.getPropertyValue(TICKSTYLE_FONT))).labelFont(ObjectConverter.asString((Object)this.context.getPropertyValue(LABELSTYLE_FONT))).enableTickLines(this.getBooleanProperty(TICK_LINES)).enableTickText(this.getBooleanProperty(TICK_VALUES)).tickStepAdjuster(ObjectConverter.asDouble((Object)this.context.properties.property(TICK_STEP_ADJUSTER).value())).tickTextFrequencyAdjuster(ObjectConverter.asDouble((Object)this.context.properties.property(TICK_TEXT_FREQUENCY).value())).tickSuffixModifier(this.getStringProperty(TICK_SUFFIX)).tickValueDivider(ObjectConverter.asDouble((Object)this.context.properties.property(TICK_VALUE_DIVIDER).value())).width(this.chartRect.width).height(this.chartRect.height).x(this.chartRect.x).y(this.chartRect.y).chordsColorPalette(chordColorPalette).groupsColorPalette(groupColorPalette).chordData(this.chorddata.toArray()).groupData(this.groupData != null ? this.groupData.toArray() : null);
        this._chart.selectAll("g.element-group").transition().duration((Object)duration).call((RunFunction)this._chordComponent, new Object[0]);
        this.setBackgroundProperties(this.chartRect, duration);
        this._legends.draw();
        this.resetUpdate();
    }

    private static void prepareSourcesList(List<Object> sources, SingleValueFunction<Object, Object> sourceIdAccessor, Object[] data) {
        for (Object d : data) {
            if (sources.contains(sourceIdAccessor.getValue(d))) continue;
            sources.add(sourceIdAccessor.getValue(d));
        }
    }

    protected int requireUpdate(String property) {
        if (property.equals(CHORDS_LEGEND_TITLE) && !this.getBooleanProperty(CHORDS_LEGEND_DISPLAY)) {
            return 4;
        }
        if (property.equals(GROUPS_LEGEND_TITLE) && !this.getBooleanProperty(GROUPS_LEGEND_DISPLAY)) {
            return 4;
        }
        if (property.equals(LEGEND_POSITION) && !this.getBooleanProperty(CHORDS_LEGEND_DISPLAY) && !this.getBooleanProperty(GROUPS_LEGEND_DISPLAY)) {
            return 4;
        }
        if ((property.equals(TICK_SUFFIX) || property.equals(TICK_TEXT_FREQUENCY) || property.equals(TICK_VALUE_DIVIDER)) && !this.getBooleanProperty(TICK_VALUES)) {
            return 4;
        }
        return super.requireUpdate(property);
    }

    @Override
    protected String[] getGroupStructure() {
        return new String[]{"defs", "g.vizlibrary vizlibrary-chorddiagram", "(", "rect.background chart", "g.chart", "(", "g.content", "(", "rect.background elements", "g.elements", "(", "g.element-group", "(", "g.group-elements", "g.chord-elements", "g.tick-elements", ")", ")", ")", ")", "g.legends", "(", "g.legends-layout", "g.legend1", "g.legend2", ")", ")"};
    }
}

