/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.columnBundle;

import com.ibm.rave.bundles.components.AxesManager;
import com.ibm.rave.bundles.components.ComponentConfiguration;
import com.ibm.rave.bundles.components.IntervalComponentImpl;
import com.ibm.rave.bundles.components.IntervalDataUtilities;
import com.ibm.rave.bundles.views.AbstractColumnView;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.behavior.Zoom;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.EventQueue;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.util.Runnable;
import com.ibm.rave.library.action.BundleUtils;
import com.ibm.rave.library.action.internal.OperationsUtil;
import com.ibm.rave.library.datamodel.DataSet;
import com.ibm.rave.library.datamodel.DataSlotEntry;
import com.ibm.rave.library.framework.CoordinateScale;
import com.ibm.rave.library.framework.internal.BundleContext;
import com.ibm.rave.library.framework.internal.CoordinateScaleImpl;
import com.ibm.rave.library.framework.internal.LinearCoordinateScale;
import com.ibm.rave.library.framework.internal.ScaleManager;
import com.ibm.rave.library.framework.internal.TimeCoordinateScale;
import com.ibm.rave.library.palette.Palette;
import java.util.List;

public class ColumnView
extends AbstractColumnView {
    @InlineStringConstant
    private static final String DATASLOT_KEY = "key";
    SingleValueFunction<Object, Object> _colorAccessor;
    private ArrayEx<Object> _data;
    private ArrayEx<IntervalDataUtilities.IntervalData> intervalData;
    private CoordinateScaleImpl _independentScale;
    private CoordinateScaleImpl _dependentScale;
    private boolean _wasClustered;
    private boolean _wasStacked;
    private DataSlotEntry userKey = null;
    private AbstractScale<?, ?> zoomXScale;
    private AbstractScale<?, ?> zoomYScale;
    private Object zoomendedTimer;

    protected ColumnView(BundleContext context) {
        super(context);
        this._intervalComponent = null;
        this._colorAccessor = null;
        this._data = null;
    }

    @Override
    protected boolean isAxesManagerRequired() {
        return true;
    }

    @Override
    public void setup() {
        super.setup();
        OMap style = new OMap();
        style.put((Object)"stroke-width", (Object)"0px");
        BundleUtils.setupDefaultActions((BundleContext)this.context, (String)".chart .element-shape", (OMap)style);
        this.context.actions.action("select").setOperation(OperationsUtil.select());
        this.context.actions.action("deselect").setOperation(OperationsUtil.deselect());
        this._colorAccessor = new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return ((IntervalDataUtilities.IntervalData)data).color;
            }
        };
        this._wasClustered = false;
        this._wasStacked = false;
    }

    public void draw() {
        CoordinateScaleImpl yScale;
        CoordinateScaleImpl xScale;
        boolean legendVisibilityChanged;
        Palette colorPalette;
        if (this.isUpdateNothing()) {
            return;
        }
        if (this.context.getPrerenderCallback() != null) {
            this.context.getPrerenderCallback().callback();
        }
        this.preDraw("g.vizlibrary-column");
        this.setBorder("column.borderWidth", "column.borderColor");
        if (!this.validateDataModel("g.element-group", "g.grid", "g.axis")) {
            return;
        }
        String effect = this.getStringProperty("effect.name");
        int duration = this.getEffectDuration(effect);
        DataSet dataSet = this.dataModel.dataset("data");
        boolean transpose = this.getBooleanProperty("transpose");
        if (this.updateType == 0) {
            this._data = ObjectConverter.listToArray((List)((List)dataSet.data()));
            this.intervalData = this.makeData(this.dataModel, this._data);
            this.userKey = dataSet.slot(DATASLOT_KEY).entry();
            this.context.actions.action("deselectAll").call(new Object[]{this.context.node.selectAll(".chart .element-shape")});
        }
        DataSlotEntry xDataSlotEntry = dataSet.slot("x").entry();
        DataSlotEntry yDataSlotEntry = dataSet.slot("y").entry();
        DataSlotEntry colorDataSlotEntry = dataSet.slot("color").entry();
        if (colorDataSlotEntry == null && yDataSlotEntry != null) {
            dataSet.slot("color").overrideLabel(yDataSlotEntry.label());
        }
        if ((colorPalette = this.getPalette()) != null) {
            colorPalette.setData(dataSet, "color");
            colorPalette.setAccessor(this._colorAccessor);
            colorPalette.setNullColor(this.getStringProperty("color.null"));
        }
        boolean showLegend = this.isShowLegend();
        boolean bl = legendVisibilityChanged = this._legends.anyVisible() != showLegend;
        if (legendVisibilityChanged) {
            this.updateType = 1;
        }
        String legendPosition = this.getLegendPosition();
        this._legends.visible(showLegend).position(legendPosition).transition(!"none".equals(effect), duration).setPreExecute(this.context.getPreExecute()).selector(0, this.context.node.selectAll("g.legend")).palette(0, colorPalette).shape(0, "square").title(0, this.context.getDataSlotLabel("legend.title", colorDataSlotEntry)).titleFill(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fill"))).titleFontSize(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontsize"))).titleFontFamily(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontfamily"))).setDataSlot(0, colorDataSlotEntry);
        boolean stacked100 = "Stacked100".equals(this.getStringProperty("data.handling"));
        if (this.updateType <= 1) {
            boolean isLegendLeftOrRight;
            this._independentScale = this.makeIndependentScale(dataSet);
            this._dependentScale = this.makeDependentScale(dataSet, (List<IntervalDataUtilities.IntervalData>)this.intervalData);
            Number subDomainDivisionY = yDataSlotEntry.subDomainDivision();
            Double scaleDivisionY = subDomainDivisionY == null ? null : Double.valueOf(ObjectConverter.toDouble((Object)subDomainDivisionY));
            this._axes.visible(true).duration(duration).transpose(transpose).scale(0, this._independentScale).scale(2, this._dependentScale).setDataSlot(0, xDataSlotEntry).setDataSlot(2, yDataSlotEntry).useDefaultSelectors().useDefaultX1Properties(true).useDefaultY1Properties(true).scaleTickMagnitude(2, scaleDivisionY).setTickFormatter(0, xDataSlotEntry).setTickFormatterList(2, (ArrayEx<DataSlotEntry>)new ArrayEx((Object[])new DataSlotEntry[]{yDataSlotEntry}), stacked100 ? "percent" : "none", stacked100 ? AxesManager.percentFormat(0) : null);
            this.prepareLayoutComponent();
            this.prepareLayoutSizables(this._layoutComponent, false, true, true, false, this._legends.anyVisible());
            boolean bl2 = isLegendLeftOrRight = "left".equals(legendPosition) || "right".equals(legendPosition);
            if (isLegendLeftOrRight) {
                this._legends.preLayout(this._layoutComponent, false);
                this._axes.preLayout(this._layoutComponent, false, 0.1, 0.05, 0, 0.1, 0.05, 0);
            } else {
                this._axes.preLayout(this._layoutComponent, true, 0.1, 0.05, 0, 0.1, 0.05, 0);
                this._legends.preLayout(this._layoutComponent, true);
            }
            this._layoutComponent.layout();
            legendPosition = this._layoutComponent.legendPosition();
            this._legends.position(legendPosition);
            this._axes.useBoundsFromLayout(this._layoutComponent).setScaleRanges(0.1, 0.05, 0);
            if (this._independentScale != null) {
                double csize = this.getCSSSizeToPixelNumber("column.size");
                this._independentScale.setWidth(csize);
                this._independentScale.applyWidth(this.getBooleanProperty("column.applysize"));
                this._independentScale.expandZeroExtent(false);
                this._independentScale.expandPixels(csize / 2.0 + 1.0, false);
                if (this.getBooleanProperty("axis.x.scale.nice")) {
                    this._independentScale.nice();
                }
                if (this.getBooleanProperty("axis.x.scale.includeZero")) {
                    this._independentScale.includeZero();
                }
                if (transpose) {
                    this.zoomYScale = this._independentScale.scale().copy();
                } else {
                    this.zoomXScale = this._independentScale.scale().copy();
                }
            }
            if (this._dependentScale != null) {
                boolean isStacked;
                double domainmax = ObjectConverter.toDouble(this._dependentScale.scale().domain().get(1));
                if (this.getBooleanProperty("axis.y.scale.includeZero")) {
                    this._dependentScale.includeZero();
                }
                this._dependentScale.expandZeroExtent(true);
                if (this.getBooleanProperty("axis.y.scale.nice")) {
                    this._dependentScale.nice((Number)scaleDivisionY);
                }
                String dataHandling = this.getStringProperty("data.handling");
                boolean bl3 = isStacked = colorDataSlotEntry != null && ("Stacked".equals(dataHandling) || "Stacked100".equals(dataHandling));
                if (this.getBooleanProperty("data.label.display") && !isStacked) {
                    List niceScaleDomain = this._dependentScale.scale().domain();
                    List range = this._dependentScale.scale().range();
                    Double dependentScaleLengthPx = Math.abs(ObjectConverter.toDouble(range.get(1)) - ObjectConverter.toDouble(range.get(0)));
                    double pixelPerUnit = dependentScaleLengthPx / Math.abs(ObjectConverter.toDouble(niceScaleDomain.get(1)) - ObjectConverter.toDouble(niceScaleDomain.get(0)));
                    double padding = Math.abs(ObjectConverter.toDouble(niceScaleDomain.get(1)) - ObjectConverter.toDouble((double)domainmax)) * pixelPerUnit;
                    int paddingNeeded = 20;
                    if (transpose && (double)(ObjectConverter.toString((Object)domainmax).length() * 12) < dependentScaleLengthPx / 4.0) {
                        paddingNeeded = ObjectConverter.toString((Object)domainmax).length() * 12;
                    }
                    this._dependentScale.expandPixels(padding < (double)paddingNeeded ? (double)paddingNeeded - padding : 2.0, true);
                } else {
                    this._dependentScale.expandPixels(2.0, true);
                }
                if (transpose) {
                    this.zoomXScale = this._dependentScale.scale().copy();
                } else {
                    this.zoomYScale = this._dependentScale.scale().copy();
                }
            }
            this.resetZoom();
        }
        RectStruct chartRect = this._layoutComponent.elementRect();
        this._legends.rectangle(this._layoutComponent.legendRect());
        this._clip.clipRect(chartRect).applyTo(this._chart.select((Object)".content")).run((Selection<?>)this.context.node.select((Object)"defs").transition().duration((Object)duration), new Object[0]);
        this._chart.select((Object)"rect.background.elements").attr("x", (Object)chartRect.x).attr("y", (Object)chartRect.y).attr("width", (Object)chartRect.width).attr("height", (Object)chartRect.height);
        if (transpose) {
            xScale = this._dependentScale;
            yScale = this._independentScale;
        } else {
            xScale = this._independentScale;
            yScale = this._dependentScale;
        }
        this.setBackgroundProperties(chartRect, duration);
        this.configureDataLabels(dataSet, colorDataSlotEntry);
        ((IntervalComponentImpl)((IntervalComponentImpl)((IntervalComponentImpl)this._intervalComponent.data(this.intervalData.toArray()).key((SingleValueFunction<Object, Object>)ColumnView.originalDatumAccessor(this.userKey != null ? this.userKey.accessor() : null))).independentScale(this._independentScale).dependentScale(this._dependentScale).transpose(transpose).colorPalette(colorPalette).specialTransition(this.getSpecialTransition(transpose, colorDataSlotEntry)).delay(this.delayFunction(duration, this._independentScale)).setPreExecute(this.context.getPreExecute())).setRenderCallback(this.context.getRenderCallback())).borderWidth(this.context.convertCSSSizeToPixels(this.context.getPropertyValue("column.borderWidth"))).borderColor(ObjectConverter.asString((Object)this.context.getPropertyValue("column.borderColor"))).bounds(this._layoutComponent.elementRect());
        Selector intervalUpdate = this._chart.selectAll("g.elements");
        if (this.updateType <= 1) {
            intervalUpdate = intervalUpdate.transition().duration((Object)duration);
        }
        intervalUpdate.call((RunFunction)this._intervalComponent, new Object[0]);
        this._axes.useDefaultX1Properties(true);
        this._axes.useDefaultY1Properties(true);
        this._axes.setTickFormatter(0, xDataSlotEntry);
        this._axes.setTickFormatterList(2, (ArrayEx<DataSlotEntry>)new ArrayEx((Object[])new DataSlotEntry[]{yDataSlotEntry}), stacked100 ? "percent" : "none", stacked100 ? AxesManager.percentFormat(0) : null);
        this._axes.draw();
        this._legends.draw();
        if (this.updateType <= 2) {
            String ops = this.getStringProperty("zoom");
            if (xScale != null && (ops.equals("all") || ops.equals("x"))) {
                xScale.scale().domain(this.zoomXScale.domain());
            }
            if (yScale != null && (ops.equals("all") || ops.equals("y"))) {
                yScale.scale().domain(this.zoomYScale.domain());
            }
            final ColumnView self = this;
            final Zoom zoom = (Zoom)this.context.actions.action("zoom").get("zoom");
            ComponentConfiguration.configureZoom(this._chart, zoom, xScale, yScale, null, null, null, chartRect, this._zoomP, this._zoomS, this.getStringProperty("zoom"), new RunFunction<SceneNode>(){

                public Object run(SceneNode node, Object ... args) {
                    self._intervalComponent.specialTransition(null);
                    self._chart.selectAll("g.elements").call((RunFunction)self._intervalComponent, new Object[0]);
                    self._axes.redraw(true);
                    zoom.on("zoomend.hideLabels", (RunFunction)new RunFunction<SceneNode>(){

                        public Object run(SceneNode context, Object ... args) {
                            if (self._axes.hideAnyPanZoom()) {
                                if (self.zoomendedTimer != null) {
                                    EventQueue.clearTimeout((Object)self.zoomendedTimer);
                                }
                                self.zoomendedTimer = EventQueue.setTimeout((Runnable)new Runnable(){

                                    public void run() {
                                        self.zoomendedTimer = null;
                                        self._axes.redraw(false);
                                    }
                                }, (int)300);
                            }
                            return null;
                        }
                    });
                    return self._chart;
                }
            });
        }
        this.resetUpdate();
        this._chart.selectAll(".element-shape").classed("bundle-shape", true);
        this._chart.selectAll(".legendShape").classed("bundle-shape", true);
        if (this.context.getPostrenderCallback() != null) {
            this.context.getPostrenderCallback().callback();
        }
    }

    public CoordinateScale getCoordinateScale(String role) {
        if ("ROLE_X1".equals(role)) {
            return this._independentScale;
        }
        if ("ROLE_Y1".equals(role)) {
            return this._dependentScale;
        }
        return null;
    }

    private ValueFunction<Object, Number> delayFunction(int duration, final CoordinateScaleImpl independentScale) {
        double rmax;
        double rmin;
        List range;
        if (duration > 0 && independentScale != null && this.getBooleanProperty("effect.delay") && (range = independentScale.scale().range()) != null && range.size() > 1 && (rmin = ObjectConverter.toDouble(range.get(0))) != (rmax = ObjectConverter.toDouble(range.get(range.size() - 1)))) {
            final double scaling = (double)duration / (rmax - rmin);
            return new ValueFunction<Object, Number>(){

                public Number getValue(Object context, Object data, int index, int groupIndex) {
                    return (ObjectConverter.toDouble((Object)independentScale.center(((IntervalDataUtilities.IntervalData)data).ind1)) - rmin) * scaling;
                }
            };
        }
        return null;
    }

    private CoordinateScaleImpl makeIndependentScale(DataSet dataSet) {
        DataSlotEntry xAccessor = dataSet.slot("x").entry();
        if (xAccessor == null) {
            return null;
        }
        DataSlotEntry colorAccessor = dataSet.slot("color").entry();
        if (colorAccessor != null && "Clustered".equals(this.getStringProperty("data.handling"))) {
            return ScaleManager.makeClusteredScale(this._data, (List)new ArrayEx((Object[])new DataSlotEntry[]{xAccessor, colorAccessor}));
        }
        CoordinateScaleImpl scale = ScaleManager.makeCoordinateScale(this._data, (DataSlotEntry)xAccessor);
        return scale;
    }

    private CoordinateScaleImpl makeDependentScale(DataSet dataSet, List<IntervalDataUtilities.IntervalData> data) {
        List domain = dataSet.slot("y").entry().domain();
        if (domain != null) {
            return LinearCoordinateScale.create((List)domain);
        }
        final DataSlotEntry yStart = dataSet.slot("yStart").entry();
        Object omax = Rave.max(data, (ValueFunction)new ValueFunction<List<?>, Number>(){

            public Number getValue(List<?> ctxt, Object data, int ix, int gix) {
                double dep1 = ObjectConverter.toDouble((Object)((IntervalDataUtilities.IntervalData)data).dep1);
                double dep2 = ObjectConverter.toDouble((Object)((IntervalDataUtilities.IntervalData)data).dep2);
                return yStart != null || dep1 != 0.0 ? Math.max(dep1, dep2) : dep2;
            }
        });
        if (omax == null) {
            return null;
        }
        Object omin = Rave.min(data, (ValueFunction)new ValueFunction<List<?>, Number>(){

            public Number getValue(List<?> ctxt, Object data, int ix, int gix) {
                double dep1 = ObjectConverter.toDouble((Object)((IntervalDataUtilities.IntervalData)data).dep1);
                double dep2 = ObjectConverter.toDouble((Object)((IntervalDataUtilities.IntervalData)data).dep2);
                return yStart != null || dep1 != 0.0 ? Math.min(dep1, dep2) : dep2;
            }
        });
        DataSlotEntry ySlot = dataSet.slot("y").entry();
        if ("date".equals(ySlot.type())) {
            return TimeCoordinateScale.create((List)new ArrayEx(new Object[]{ObjectConverter.toDate((Object)omin), ObjectConverter.toDate((Object)omax)}));
        }
        return LinearCoordinateScale.create((List)new ArrayEx(new Object[]{omin, omax}));
    }

    private String getSpecialTransition(boolean transpose, DataSlotEntry colorAccessor) {
        boolean isStacked;
        String result = null;
        String handling = this.getStringProperty("data.handling");
        boolean isClustered = colorAccessor != null && "Clustered".equals(handling);
        boolean bl = isStacked = "Stacked".equals(handling) || "Stacked100".equals(handling);
        if (this._wasClustered && isStacked) {
            result = transpose ? "YX_CTS" : "XY_CTS";
        } else if (this._wasStacked && isClustered) {
            result = transpose ? "XY_STC" : "YX_STC";
        }
        this._wasClustered = isClustered;
        this._wasStacked = isStacked;
        return result;
    }

    protected int requireUpdate(String property) {
        return super.requireUpdate(property);
    }

    @Override
    protected String[] getGroupStructure() {
        return new String[]{"defs", "g.vizlibrary vizlibrary-column", "(", "rect.background chart", "g.chart", "(", "g.content", "(", "rect.background elements", "g.gridlines", "(", "g.grid left", "g.grid bottom", ")", "g.elements", "(", "g.element-group", "g.element-label-group", ")", ")", "g.axes", "(", "g.axes-layout", "g.axisTransform left", "g.axisTransform bottom", ")", "g.axis-callout", ")", "g.legends", "(", "g.legends-layout", "g.legend", ")", ")"};
    }
}

