/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.components;

import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.library.framework.internal.CoordinateScaleImpl;
import java.util.ArrayList;
import java.util.List;

public class AlignAxisTicksComponent {
    private static final int LINEAR_DEFAULT_TICKS = 10;

    public static void alignAxisScales(CoordinateScaleImpl scale1, CoordinateScaleImpl scale2) {
        if (scale1.isLinear() && scale2.isLinear()) {
            AlignAxisTicksComponent.alignScaleZero(scale1, scale2);
            double count1 = AlignAxisTicksComponent.alignScale(scale1, null);
            double count2 = AlignAxisTicksComponent.alignScale(scale2, null);
            if (count1 > count2) {
                AlignAxisTicksComponent.alignScale(scale2, count1);
            } else if (count1 < count2) {
                AlignAxisTicksComponent.alignScale(scale1, count2);
            }
        }
    }

    protected static void alignScaleZero(CoordinateScaleImpl scale1, CoordinateScaleImpl scale2) {
        ArrayEx extent1 = AbstractScale.scaleExtent((List)scale1.scale().domain());
        ArrayEx extent2 = AbstractScale.scaleExtent((List)scale2.scale().domain());
        double min1 = ObjectConverter.toDouble((Object)extent1.get(0));
        double min2 = ObjectConverter.toDouble((Object)extent2.get(0));
        if (min1 >= 0.0 && min2 >= 0.0) {
            return;
        }
        double max1 = ObjectConverter.toDouble((Object)extent1.get(1));
        double max2 = ObjectConverter.toDouble((Object)extent2.get(1));
        if (max1 <= 0.0 && max2 <= 0.0) {
            return;
        }
        double ratio1 = 0.0;
        double ratio2 = 0.0;
        if (min1 < 0.0) {
            ratio1 = max1 / Math.abs(min1);
            if (min2 < 0.0) {
                ratio2 = max2 / Math.abs(min2);
                if (ratio1 > ratio2) {
                    extent2.set(1, (Object)(Math.abs(min2) * ratio1));
                }
                if (ratio2 > ratio1) {
                    extent1.set(1, (Object)(Math.abs(min1) * ratio2));
                }
            } else if (ratio1 > 0.0) {
                extent2.set(0, (Object)(-max2 / ratio1));
            } else {
                ratio1 = Math.abs(min1) / max2;
                ratio1 = ratio1 > 4.0 ? 4.0 : ratio1;
                ratio1 = ratio1 < 0.25 ? 0.25 : ratio1;
                extent1.set(1, (Object)(-min1 / ratio1));
                extent2.set(0, (Object)(-max2 * ratio1));
            }
        } else if (min2 < 0.0) {
            if (max2 > 0.0) {
                ratio2 = max2 / Math.abs(min2);
                extent1.set(0, (Object)(-max1 / ratio2));
            } else {
                ratio2 = Math.abs(min2) / max1;
                ratio2 = ratio2 > 4.0 ? 4.0 : ratio2;
                ratio2 = ratio2 < 0.25 ? 0.25 : ratio2;
                extent2.set(1, (Object)(-min2 / ratio2));
                extent1.set(0, (Object)(-max1 * ratio2));
            }
        }
        ArrayList<Object> exList = new ArrayList<Object>();
        exList.add(0, extent2.get(0));
        exList.add(1, extent2.get(1));
        scale2.scale().domain(exList);
        exList.clear();
        exList.add(0, extent1.get(0));
        exList.add(1, extent1.get(1));
        scale1.scale().domain(exList);
    }

    protected static double alignScale(CoordinateScaleImpl coordScale, Double tickCount) {
        double step;
        double m = 10.0;
        ArrayEx extent = AbstractScale.scaleExtent((List)coordScale.scale().domain());
        double span = ObjectConverter.toDouble((Object)extent.get(1)) - ObjectConverter.toDouble((Object)extent.get(0));
        double err = m / span * (step = Math.pow(10.0, Math.floor(Math.log(span / m) / Math.log(10.0))));
        if (err <= 0.15) {
            step *= 10.0;
        } else if (err <= 0.35) {
            step *= 5.0;
        } else if (err <= 0.75) {
            step *= 2.0;
        }
        double min = ObjectConverter.toDouble((Object)extent.get(0));
        double max = ObjectConverter.toDouble((Object)extent.get(1));
        double numSteps = (max - min) / step;
        if (tickCount != null && numSteps < tickCount) {
            double negSteps = 0.0;
            if (min < 0.0) {
                negSteps = Math.abs(min) / step;
            }
            double posSteps = max / step;
            negSteps = negSteps * tickCount / numSteps;
            posSteps = posSteps * tickCount / numSteps;
            ArrayList<Double> exList = new ArrayList<Double>();
            exList.add(0, -negSteps * step);
            exList.add(1, posSteps * step);
            coordScale.scale().domain(exList);
            numSteps = tickCount;
        }
        return numSteps;
    }
}

