/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.components;

import com.ibm.rave.bundles.component.AreaComponent;
import com.ibm.rave.bundles.components.AbstractPathComponent;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.svg.AreaPathGenerator;
import com.ibm.rave.library.framework.internal.CoordinateScaleImpl;
import com.ibm.rave.library.palette.Palette;

public class AreaComponentImpl
extends AbstractPathComponent<AreaComponentImpl>
implements AreaComponent {
    private Object[] _data = null;
    private SingleValueFunction<Object, Object> _pointsAccessor = new SingleValueFunction<Object, Object>(){

        public Object getValue(Object data) {
            return ((OMap)data).get((Object)"points");
        }
    };
    private SingleValueFunction<Object, Object> _groupAccessor = new SingleValueFunction<Object, Object>(){

        public Object getValue(Object data) {
            return ((OMap)data).get((Object)"group");
        }
    };
    private SingleValueFunction<Object, Object> _independentAccessor = new SingleValueFunction<Object, Object>(){

        public Object getValue(Object data) {
            return ((ArrayEx)data).get(0);
        }
    };
    private CoordinateScaleImpl _independentScale;
    private SingleValueFunction<Object, Object> _dependentAccessor;
    private CoordinateScaleImpl _dependentScale;
    private SingleValueFunction<Object, Object> _dependentY0Accessor;
    private SingleValueFunction<Object, Object> _definedAccessor;
    private Palette _colorPalette;
    private double _areaOpacity;
    private String _borderColor;
    private String _borderWidth;
    private boolean _isStacked;
    private boolean _transpose;
    private String _effect;

    public AreaComponentImpl() {
        final AreaComponentImpl self = this;
        this._dependentAccessor = new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                if (self._isStacked) {
                    return ObjectConverter.toDouble((Object)((ArrayEx)data).get(1)) + ObjectConverter.toDouble((Object)((ArrayEx)data).get(2));
                }
                return ((ArrayEx)data).get(1);
            }
        };
        this._dependentY0Accessor = new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return ((ArrayEx)data).get(2);
            }
        };
        this._definedAccessor = new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return ((ArrayEx)data).get(1) != null && ((ArrayEx)data).get(0) != null;
            }
        };
        this._independentScale = null;
        this._dependentScale = null;
        this._colorPalette = null;
        this._borderColor = null;
        this._borderWidth = null;
        this._transpose = false;
        this._effect = null;
        this._interpolateMode = null;
        this._previousInterpolateMode = null;
        this._areaOpacity = 1.0;
    }

    @Override
    public String type() {
        return "AreaComponent";
    }

    @Override
    protected void execute(Selector g) {
        this.preExecute();
        if (this._data == null || this._pointsAccessor == null || this._independentAccessor == null || this._independentScale == null || this._dependentAccessor == null || this._dependentScale == null) {
            g.selectAll("*").remove();
            return;
        }
        final AreaComponentImpl self = this;
        ValueFunction<Object, Object> independent = new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return self._independentScale.center(self._independentAccessor.getValue(data));
            }
        };
        ValueFunction<Object, Object> dependent = new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return self._dependentScale.center(self._dependentAccessor.getValue(data));
            }
        };
        ValueFunction<Object, Object> baselineStacked = new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return self._dependentScale.center(self._dependentY0Accessor.getValue(data));
            }
        };
        ValueFunction<Object, Object> baselineSimple = new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return self._dependentScale.center((Object)0);
            }
        };
        ValueFunction<Object, Boolean> definedAccessorY = new ValueFunction<Object, Boolean>(){

            public Boolean getValue(Object context, Object data, int index, int groupIndex) {
                return ObjectConverter.toBoolean((Object)self._definedAccessor.getValue(data));
            }
        };
        final AreaPathGenerator area = Rave.svg.area.getValue();
        if (this._transpose) {
            area.x1((ValueFunction)dependent).y((ValueFunction)independent).x0((ValueFunction)(this._isStacked ? baselineStacked : baselineSimple));
        } else {
            area.x((ValueFunction)independent).y1((ValueFunction)dependent).y0((ValueFunction)(this._isStacked ? baselineStacked : baselineSimple));
        }
        area.defined((ValueFunction)definedAccessorY);
        area.interpolate(this._interpolateMode);
        ValueFunction<Object, String> areaFunction = new ValueFunction<Object, String>(){

            public String getValue(Object context, Object d, int index, int groupIndex) {
                return area.create(context, (ArrayEx)self._pointsAccessor.getValue(d));
            }
        };
        Selector areas = g.selectAll("path.element-shape").data(this._data, (ValueFunction)new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return self._groupAccessor.getValue(data);
            }
        });
        areas.exit().remove();
        Selector enter = areas.enter();
        enter = enter.insert("path", "path").attr("class", (Object)"element-shape").style("fill", (ValueFunction)this._colorPalette).style("stroke", (Object)(this._borderColor != null ? this._borderColor : this._colorPalette)).style("stroke-width", (Object)(this._borderWidth != null ? this._borderWidth : "0px"));
        if ("fromBase".equals(this._effect)) {
            ValueFunction<Object, Object> dependentZero = new ValueFunction<Object, Object>(){

                public Object getValue(Object context, Object data, int index, int groupIndex) {
                    return self._dependentScale.center((Object)0.0);
                }
            };
            final AreaPathGenerator areaEnter = Rave.svg.area.getValue();
            if (this._transpose) {
                areaEnter.x1((ValueFunction)dependentZero).y((ValueFunction)independent).x0((ValueFunction)dependentZero);
            } else {
                areaEnter.x((ValueFunction)independent).y1((ValueFunction)dependentZero).y0((ValueFunction)dependentZero);
            }
            areaEnter.defined((ValueFunction)definedAccessorY);
            areaEnter.interpolate(this._interpolateMode);
            enter.attr("d", (ValueFunction)new ValueFunction<Object, String>(){

                public String getValue(Object context, Object d, int index, int groupIndex) {
                    return areaEnter.create(context, (ArrayEx)self._pointsAccessor.getValue(d));
                }
            });
        } else {
            enter.attr("d", (ValueFunction)areaFunction);
        }
        Selection areasUpdate = Rave.transition((Selection)areas).style("fill", (ValueFunction)this._colorPalette).style("opacity", (Object)this._areaOpacity);
        this.updateBorder(areasUpdate, this._borderWidth, this._borderColor);
        this.updatePath(areasUpdate, areaFunction);
        this._effect = null;
    }

    public AreaComponentImpl data(Object[] data) {
        this._data = data;
        return this;
    }

    public AreaComponentImpl pointsAccessor(SingleValueFunction<Object, Object> pointsAccessor) {
        this._pointsAccessor = pointsAccessor;
        return this;
    }

    public AreaComponentImpl groupAccessor(SingleValueFunction<Object, Object> groupAccessor) {
        this._groupAccessor = groupAccessor;
        return this;
    }

    public AreaComponentImpl independentAccessor(SingleValueFunction<Object, Object> independentAccessor) {
        this._independentAccessor = independentAccessor;
        return this;
    }

    public AreaComponentImpl independentScale(CoordinateScaleImpl independentScale) {
        this._independentScale = independentScale;
        return this;
    }

    public AreaComponentImpl dependentAccessor(SingleValueFunction<Object, Object> dependentAccessor) {
        this._dependentAccessor = dependentAccessor;
        return this;
    }

    public AreaComponentImpl dependentY0Accessor(SingleValueFunction<Object, Object> dependentY0Accessor) {
        this._dependentY0Accessor = dependentY0Accessor;
        return this;
    }

    public AreaComponentImpl dependentScale(CoordinateScaleImpl dependentScale) {
        this._dependentScale = dependentScale;
        return this;
    }

    public AreaComponentImpl definedAccessor(SingleValueFunction<Object, Object> definedAccessor) {
        this._definedAccessor = definedAccessor;
        return this;
    }

    public AreaComponentImpl colorPalette(Palette colorPalette) {
        this._colorPalette = colorPalette;
        return this;
    }

    @Override
    public AreaComponent borderColor(String borderColor) {
        this._borderColor = borderColor;
        return this;
    }

    @Override
    public AreaComponent borderWidth(String borderWidth) {
        this._borderWidth = borderWidth;
        return this;
    }

    @Override
    public AreaComponent chartOpacity(double opacity) {
        this._areaOpacity = opacity;
        return this;
    }

    public AreaComponentImpl transpose(boolean transpose) {
        this._transpose = transpose;
        return this;
    }

    public AreaComponentImpl effect(String effect) {
        this._effect = effect;
        return this;
    }

    public AreaComponentImpl stack(boolean stacked) {
        this._isStacked = stacked;
        return this;
    }

    @Override
    public AreaComponent interpolate(String mode) {
        this._interpolateMode = mode;
        return this;
    }
}

