/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.components;

import com.ibm.rave.bundles.components.AxisComponentImpl;
import com.ibm.rave.bundles.components.ChartLayoutComponentImpl;
import com.ibm.rave.bundles.components.ClipPathComponentImpl;
import com.ibm.rave.bundles.components.GridComponentImpl;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.geom.RaveRect;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.util.Comparator;
import com.ibm.rave.library.datamodel.DataSlotEntry;
import com.ibm.rave.library.framework.internal.AbstractView;
import com.ibm.rave.library.framework.internal.BundleContext;
import com.ibm.rave.library.framework.internal.CoordinateScaleImpl;
import java.util.List;

public class AxesManager {
    private final BundleContext _context;
    private boolean _firstDraw = false;
    private boolean _visible = true;
    private int _duration = 0;
    private Selector _defs = null;
    private boolean _transpose = false;
    private boolean _swapX = false;
    private boolean _swapY = false;
    public static final int X1 = 0;
    public static final int X2 = 1;
    public static final int Y1 = 2;
    public static final int Y2 = 3;
    private static final String[] ROLES = new String[]{"ROLE_X1", "ROLE_X2", "ROLE_Y1", "ROLE_Y2"};
    private static final String[] ROLE_FORMATTERS = new String[]{"ROLE_X1", "ROLE_X2", "ROLE_Y1", "ROLE_Y2"};
    private final CoordinateScaleImpl[] _scales = new CoordinateScaleImpl[4];
    private final boolean[] _suppressPanLabels = new boolean[4];
    private final boolean[] _drawAxisLabels = new boolean[4];
    private final AxisComponentImpl[] _axisComponents = new AxisComponentImpl[4];
    private final Selector[] _lastAxisDrawSelectors = new Selector[4];
    private final GridComponentImpl[] _gridComponents = new GridComponentImpl[4];
    private final Selector[] _lastGridDrawSelectors = new Selector[4];
    private final AxisComponentImpl _clearAxis = new AxisComponentImpl();
    private final GridComponentImpl _clearGrid = new GridComponentImpl();
    public static final int BOTTOM = 0;
    public static final int TOP = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    private static final String[] ORIENTATIONS = new String[]{"bottom", "top", "left", "right"};
    private static final String[] FORMATTERS = new String[]{"bottom", "top", "left", "right"};
    private final Selector[] _axisSelectors = new Selector[4];
    private final Selector[] _gridSelectors = new Selector[4];
    private final RectStruct[] _axisRects = new RectStruct[4];
    private RectStruct _elementRect = new RectStruct(0.0, 0.0, 0.0, 0.0);
    private final boolean[] _lastAxisDrew = new boolean[4];
    private final boolean[] _lastGridDrew = new boolean[4];
    private ArrayEx<ArrayEx<DataSlotEntry>> _dataSlotEntries = new ArrayEx();
    private boolean _layoutInProgress = false;
    private int[] _layoutAxisOrder = new int[4];
    double _layoutMaxWidth = 0.0;
    double _layoutMaxHeight = 0.0;
    private double _xPadding;
    private double _xOuterPadding;
    private double _yPadding;
    private double _yOuterPadding;
    private int _xPixelPad;
    private int _yPixelPad;
    boolean _preventStaggerRotate45 = false;

    public AxesManager(BundleContext context) {
        this._context = context;
        for (int i = 0; i < 4; ++i) {
            this._scales[i] = null;
            this._suppressPanLabels[i] = false;
            this._axisComponents[i] = null;
            this._lastAxisDrawSelectors[i] = null;
            this._gridComponents[i] = null;
            this._lastGridDrawSelectors[i] = null;
            this._axisSelectors[i] = null;
            this._gridSelectors[i] = null;
            this._axisRects[i] = new RectStruct(0.0, 0.0, 0.0, 0.0);
            this._lastAxisDrew[i] = false;
            this._lastGridDrew[i] = false;
            this._dataSlotEntries.set(i, (Object)new ArrayEx());
        }
    }

    public AxesManager preLayout(ChartLayoutComponentImpl layoutComponent, boolean axesBeforeLegend, double xPadding, double xOuterPadding, int xPixelPad, double yPadding, double yOuterPadding, int yPixelPad) {
        int position;
        this._xPadding = xPadding;
        this._xOuterPadding = xOuterPadding;
        this._xPixelPad = xPixelPad;
        this._yPadding = yPadding;
        this._yOuterPadding = yOuterPadding;
        this._yPixelPad = yPixelPad;
        this._layoutInProgress = true;
        int layoutDuration = this._duration;
        this._duration = 0;
        String[] children = new String[]{"g.layoutAxis-bottom", "g.layoutAxis-top", "g.layoutAxis-left", "g.layoutAxis-right", "g.layoutGrid-bottom", "g.layoutGrid-top", "g.layoutGrid-left", "g.layoutGrid-right"};
        AbstractView.createGroupStructure((Selector)this._context.node.select((Object)"g.axes-layout"), (String[])children);
        Selector[] layoutAxisSelectors = new Selector[4];
        Selector[] layoutGridSelectors = new Selector[4];
        boolean[] layoutLastAxisDrew = new boolean[4];
        for (int position2 = 0; position2 < 4; ++position2) {
            if (this._axisComponents[position2] != null) {
                this._axisComponents[position2].preLayout();
            }
            layoutAxisSelectors[position2] = this._axisSelectors[position2];
            layoutGridSelectors[position2] = this._gridSelectors[position2];
            layoutLastAxisDrew[position2] = this._lastAxisDrew[position2];
            if (this._axisSelectors[position2] != null) {
                this.axisSelector(position2, this._context.node.select((Object)("g.layoutAxis-" + ORIENTATIONS[position2])));
            }
            if (this._gridSelectors[position2] == null) continue;
            this.gridSelector(position2, this._context.node.select((Object)("g.layoutGrid-" + ORIENTATIONS[position2])));
        }
        layoutComponent.preLayout(axesBeforeLegend, true);
        AxesManager.setRect(this._elementRect, layoutComponent.elementRect());
        int countHorz = 0;
        int countVert = 0;
        ArrayEx axes = new ArrayEx();
        for (position = 0; position < 4; ++position) {
            boolean isHorz;
            int role = this.positionToRole(position);
            boolean bl = isHorz = position == 1 || position == 0;
            if (this._axisSelectors[position] != null && this._scales[role] != null) {
                int score;
                if (isHorz) {
                    ++countHorz;
                } else {
                    ++countVert;
                }
                if (this._scales[role].isOrdinal() || this._scales[role].isClustered()) {
                    score = isHorz ? 4 : 2;
                    axes.add((Object)new AxisLayout(position, score));
                    continue;
                }
                score = isHorz ? 3 : 1;
                axes.add((Object)new AxisLayout(position, score));
                continue;
            }
            axes.add((Object)new AxisLayout(position, 5));
        }
        axes.sort((Comparator)new Comparator<AxisLayout>(){

            public int compare(AxisLayout a1, AxisLayout a2) {
                int a1value = a1.score;
                int a2value = a2.score;
                return a1value < a2value ? -1 : (a1value > a2value ? 1 : 0);
            }
        });
        this._layoutAxisOrder = new int[4];
        for (int i = 0; i < 4; ++i) {
            this._layoutAxisOrder[i] = ((AxisLayout)axes.get((int)i)).position;
        }
        this._layoutMaxWidth = this._elementRect.width * (countVert > 1 ? 0.5 : 0.4);
        this._layoutMaxHeight = this._elementRect.height * (countHorz > 1 ? 0.5 : 0.4);
        for (int index = 0; index < 4; ++index) {
            int position3 = this._layoutAxisOrder[index];
            AxesManager.setRect(this._axisRects[position3], this._elementRect);
        }
        this.draw();
        this._duration = layoutDuration;
        this._context.node.select((Object)"g.axes-layout").selectAll("*").remove();
        for (position = 0; position < 4; ++position) {
            this._lastAxisDrew[position] = layoutLastAxisDrew[position];
            this._axisSelectors[position] = layoutAxisSelectors[position];
            this._gridSelectors[position] = layoutGridSelectors[position];
        }
        this._layoutInProgress = false;
        return this;
    }

    private int getPositionToDraw(int index) {
        return this._layoutInProgress ? this._layoutAxisOrder[index] : index;
    }

    private void preDrawAxis(int index) {
        if (this._layoutInProgress) {
            int position = this._layoutAxisOrder[index];
            int role = this.positionToRole(position);
            if (role == 0 || role == 1) {
                this.setScaleRangePadded(this._scales[role], false, this._xPadding, this._xOuterPadding, this._xPixelPad);
            } else {
                this.setScaleRangePadded(this._scales[role], true, this._yPadding, this._yOuterPadding, this._yPixelPad);
            }
            this._axisComponents[role].allowAutomaticAxisLayoutToChangeOrientation(true);
        }
    }

    private void postDrawAxis(int index) {
        if (this._layoutInProgress) {
            int position = this._layoutAxisOrder[index];
            int role = this.positionToRole(position);
            AxisComponentImpl axis = this._axisComponents[role];
            double size = axis.getPreferredSize();
            if (position == 1 || position == 0) {
                if (size > this._layoutMaxHeight) {
                    size = this._layoutMaxHeight;
                }
                this._elementRect.height -= size;
                if (position == 1) {
                    this._elementRect.y += size;
                }
            } else {
                if (size > this._layoutMaxWidth) {
                    size = this._layoutMaxWidth;
                }
                this._elementRect.width -= size;
                if (position == 2) {
                    this._elementRect.x += size;
                }
            }
            this._axisComponents[role].allowAutomaticAxisLayoutToChangeOrientation(false);
        }
    }

    public void draw() {
        for (int role = 0; role < 4; ++role) {
            this._lastAxisDrawSelectors[role] = null;
            this._lastGridDrawSelectors[role] = null;
        }
        for (int index = 0; index < 4; ++index) {
            int position = this.getPositionToDraw(index);
            int role = this.positionToRole(position);
            if (!this._visible || this._axisSelectors[position] == null || this._scales[role] == null) {
                this.clearAxis(position);
                this.clearGrid(position);
                continue;
            }
            this.preDrawAxis(index);
            this.drawAxis(position, role);
            this.postDrawAxis(index);
            if (this._gridSelectors[position] == null) continue;
            this.drawGrid(position, role);
        }
        this._firstDraw = false;
    }

    public boolean hideAnyPanZoom() {
        return this._suppressPanLabels[0] || this._suppressPanLabels[1] || this._suppressPanLabels[2] || this._suppressPanLabels[3];
    }

    public void redraw(boolean panning) {
        for (int role = 0; role < 4; ++role) {
            if (this._axisComponents[role] != null && this._lastAxisDrawSelectors[role] != null) {
                this._axisComponents[role].displayTickLabels(this._drawAxisLabels[role]);
                this._axisComponents[role].showPanZoomTickLabels(!panning || !this._suppressPanLabels[role]);
                boolean isAllow = this._axisComponents[role].isAllowAutomaticAxisLayoutToChangeOrientation();
                this._axisComponents[role].allowAutomaticAxisLayoutToChangeOrientation(false);
                this._lastAxisDrawSelectors[role].call((RunFunction)this._axisComponents[role], new Object[0]);
                this._axisComponents[role].allowAutomaticAxisLayoutToChangeOrientation(isAllow);
            }
            if (this._gridComponents[role] == null || this._lastGridDrawSelectors[role] == null) continue;
            this._lastGridDrawSelectors[role].call((RunFunction)this._gridComponents[role], new Object[0]);
        }
    }

    public void preventStaggerRotate45(boolean preventStaggerRotate45) {
        this._preventStaggerRotate45 = preventStaggerRotate45;
    }

    private void drawAxis(int position, int role) {
        String allowRotate45ID;
        String allowStaggerID;
        String layoutModeID;
        Selector axisGroup;
        this._lastAxisDrawSelectors[role] = axisGroup = this._axisSelectors[position];
        AxisComponentImpl comp = this.axisComponent(role);
        String string = role == 2 ? "axis.y.labels.layoutMode" : (layoutModeID = role == 3 ? "axis.y2.labels.layoutMode" : "axis.x.labels.layoutMode");
        String string2 = role == 2 ? "axis.y.labels.allowStagger" : (allowStaggerID = role == 3 ? "axis.y2.labels.allowStagger" : "axis.x.labels.allowStagger");
        String string3 = role == 2 ? "axis.y.labels.allowRotate45" : (allowRotate45ID = role == 3 ? "axis.y2.labels.allowRotate45" : "axis.x.labels.allowRotate45");
        String allowRotate90ID = role == 2 ? "axis.y.labels.allowRotate90" : (role == 3 ? "axis.y2.labels.allowRotate90" : "axis.x.labels.allowRotate90");
        String layoutMode = ObjectConverter.toString((Object)this._context.getPropertyValue(layoutModeID));
        boolean allowStagger = !this._preventStaggerRotate45 && ObjectConverter.toBoolean((Object)this._context.getPropertyValue(allowStaggerID));
        boolean allowRotate45 = !this._preventStaggerRotate45 && ObjectConverter.toBoolean((Object)this._context.getPropertyValue(allowRotate45ID));
        boolean allowRotate90 = ObjectConverter.toBoolean((Object)this._context.getPropertyValue(allowRotate90ID));
        String textTruncateIndicator = ObjectConverter.asString((Object)this._context.getPropertyValue("axis.labels.truncationText"));
        RectStruct axisBounds = this._axisRects[position];
        String orient = ORIENTATIONS[position];
        double[] transform = AxisComponentImpl.getTranslation(axisBounds, orient);
        String axisTransform = "translate(" + transform[0] + "," + transform[1] + ")";
        ((AxisComponentImpl)comp.scale(this._scales[role]).setRole(ROLES[role]).bounds(axisBounds).elementRect(this._elementRect).orient(orient).layoutMode(layoutMode).allowStagger(allowStagger).allowRotate45(allowRotate45).allowRotate90(allowRotate90).setPreExecute(this._context.getPreExecute())).textTruncateIndicator(textTruncateIndicator);
        this._drawAxisLabels[role] = comp._displayTickLabels;
        Selector axisGroupUpdate = axisGroup;
        if (this._duration > 0 && !this._firstDraw && this._lastAxisDrew[position]) {
            axisGroupUpdate = axisGroup.transition().duration((Object)this._duration);
        }
        axisGroupUpdate.attr("transform", (Object)axisTransform);
        axisGroupUpdate.call((RunFunction)comp, new Object[0]);
        ArrayEx dataSlotEntryList = (ArrayEx)this._dataSlotEntries.get(role);
        axisGroup.selectAll(".axis-title").property("dataSlots", (Object)dataSlotEntryList);
        this._lastAxisDrew[position] = comp.renderedShapes();
        if (this._defs != null) {
            RectStruct clipRect;
            ClipPathComponentImpl clipAxis = new ClipPathComponentImpl(this._context.instanceId() + "clip" + orient);
            Selector text = axisGroup.append("text").text((Object)"000,000");
            RaveRect bbox = text.node().getBBox();
            double w = bbox.width;
            double h = bbox.height;
            text.remove();
            if (position == 0 || position == 1) {
                double leftEdge = axisBounds.x + transform[0] * -1.0;
                double rightEdge = leftEdge + axisBounds.width;
                if (!this._scales[role].isOrdinal() && !this._scales[role].isClustered()) {
                    double numericLeftEdge = this._elementRect.x - w + transform[0] * -1.0;
                    double numericRightEdge = numericLeftEdge + this._elementRect.width + w * 2.0;
                    if (numericLeftEdge < leftEdge) {
                        leftEdge = numericLeftEdge;
                    }
                    if (numericRightEdge > rightEdge) {
                        rightEdge = numericRightEdge;
                    }
                }
                clipRect = new RectStruct(leftEdge, axisBounds.y + transform[1] * -1.0, rightEdge - leftEdge, axisBounds.height);
            } else {
                clipRect = new RectStruct(axisBounds.x + transform[0] * -1.0, this._elementRect.y - h / 2.0 + transform[1] * -1.0, axisBounds.width, this._elementRect.height + h);
            }
            clipAxis.clipRect(clipRect).applyTo(axisGroup.select((Object)(".axis." + orient))).run((Selection<?>)this._defs, new Object[0]);
        }
    }

    private void clearAxis(int position) {
        if (this._axisSelectors[position] != null) {
            this._clearAxis.scale(null);
            this._axisSelectors[position].call((RunFunction)this._clearAxis, new Object[0]);
        }
        this._lastAxisDrew[position] = false;
    }

    private void drawGrid(int position, int role) {
        Selector gridGroup;
        this._lastGridDrawSelectors[role] = gridGroup = this._gridSelectors[position];
        GridComponentImpl comp = this.gridComponent(role);
        RectStruct axisBounds = this._axisRects[position];
        String orient = ORIENTATIONS[position];
        double[] transform = AxisComponentImpl.getTranslation(axisBounds, orient);
        String axisTransform = "translate(" + transform[0] + "," + transform[1] + ")";
        ((GridComponentImpl)comp.setRole(ROLES[role]).orient(orient).setPreExecute(this._context.getPreExecute())).bounds(this._elementRect).axis(this._axisComponents[role].axis());
        if (this._duration <= 0 || this._firstDraw || !this._lastAxisDrew[position]) {
            gridGroup.attr("transform", (Object)axisTransform).call((RunFunction)comp, new Object[0]);
        } else {
            gridGroup.transition().duration((Object)this._duration).attr("transform", (Object)axisTransform).call((RunFunction)comp, new Object[0]);
        }
        this._lastGridDrew[position] = comp.renderedShapes();
    }

    private void clearGrid(int position) {
        if (this._gridSelectors[position] != null) {
            this._clearGrid.axis(null);
            this._gridSelectors[position].call((RunFunction)this._clearGrid, new Object[0]);
        }
        this._lastGridDrew[position] = false;
    }

    public final AxesManager visible(boolean visible) {
        this._visible = visible;
        return this;
    }

    public final AxesManager duration(int duration) {
        this._duration = duration;
        return this;
    }

    public final AxesManager transpose(boolean transpose) {
        this._transpose = transpose;
        return this;
    }

    public final AxesManager swapX(boolean swapX) {
        this._swapX = swapX;
        return this;
    }

    public final AxesManager swapY(boolean swapY) {
        this._swapY = swapY;
        return this;
    }

    public AxesManager scale(int role, CoordinateScaleImpl scale) {
        this._scales[role] = scale;
        return this;
    }

    public AxesManager suppressPanLabels(int role, boolean suppressLabels) {
        this._suppressPanLabels[role] = suppressLabels;
        return this;
    }

    public AxisComponentImpl axisComponent(int role) {
        if (this._axisComponents[role] == null) {
            this._axisComponents[role] = new AxisComponentImpl();
        }
        return this._axisComponents[role];
    }

    public GridComponentImpl gridComponent(int role) {
        if (this._gridComponents[role] == null) {
            this._gridComponents[role] = new GridComponentImpl();
        }
        return this._gridComponents[role];
    }

    public AxesManager defsSelector(Selector defs) {
        this._defs = AxesManager.checkSelector(defs);
        return this;
    }

    public AxesManager axisSelector(int position, Selector axisGroup) {
        this._axisSelectors[position] = AxesManager.checkSelector(axisGroup);
        return this;
    }

    public AxesManager gridSelector(int position, Selector gridGroup) {
        this._gridSelectors[position] = AxesManager.checkSelector(gridGroup);
        return this;
    }

    private static Selector checkSelector(Selector s) {
        return s != null && !s.empty() ? s : null;
    }

    public AxesManager elementRect(RectStruct elementRect) {
        AxesManager.setRect(this._elementRect, elementRect);
        return this;
    }

    public AxesManager axisRect(int position, RectStruct axisRect) {
        AxesManager.setRect(this._axisRects[position], axisRect);
        return this;
    }

    private static void setRect(RectStruct target, RectStruct source) {
        if (source != null) {
            target.x = source.x;
            target.y = source.y;
            target.width = source.width;
            target.height = source.height;
        } else {
            target.x = 0.0;
            target.y = 0.0;
            target.width = 0.0;
            target.height = 0.0;
        }
    }

    public AxesManager useDefaultSelectors() {
        this.defsSelector(this._context.node.select((Object)"defs"));
        this.axisSelector(0, this._context.node.select((Object)"g.axisTransform.bottom"));
        this.axisSelector(1, this._context.node.select((Object)"g.axisTransform.top"));
        this.axisSelector(2, this._context.node.select((Object)"g.axisTransform.left"));
        this.axisSelector(3, this._context.node.select((Object)"g.axisTransform.right"));
        this.gridSelector(0, this._context.node.select((Object)"g.grid.bottom"));
        this.gridSelector(1, this._context.node.select((Object)"g.grid.top"));
        this.gridSelector(2, this._context.node.select((Object)"g.grid.left"));
        this.gridSelector(3, this._context.node.select((Object)"g.grid.right"));
        return this;
    }

    public AxesManager useBoundsFromLayout(ChartLayoutComponentImpl layoutInfo) {
        AxesManager.setRect(this._elementRect, layoutInfo.elementRect());
        AxesManager.setRect(this._axisRects[0], layoutInfo.bottomRect());
        AxesManager.setRect(this._axisRects[1], layoutInfo.topRect());
        AxesManager.setRect(this._axisRects[2], layoutInfo.leftRect());
        AxesManager.setRect(this._axisRects[3], layoutInfo.rightRect());
        return this;
    }

    public AxesManager useDefaultX1Properties(boolean setGridParameters) {
        this.axisComponent(0).padding(16).displayAxisTitle(ObjectConverter.toBoolean((Object)this._context.getPropertyValue("axis.x.title.display"))).axisTitle(this._context.getDataSlotLabel("axis.x.title.text", (ArrayEx)this._dataSlotEntries.get(0))).displayAxisLine(ObjectConverter.toBoolean((Object)this._context.getPropertyValue("axis.x.line.display"))).lineColor(ObjectConverter.asString((Object)this._context.getPropertyValue("axis.x.line.style.stroke"))).displayTicks(ObjectConverter.toBoolean((Object)this._context.getPropertyValue("axis.x.ticks.display"))).tickColor(ObjectConverter.asString((Object)this._context.getPropertyValue("axis.x.ticks.style.stroke"))).displayTickLabels(ObjectConverter.toBoolean((Object)this._context.getPropertyValue("axis.x.labels.display")));
        String titleFontStyle = ObjectConverter.asString((Object)this._context.getPropertyValue("axis.x.title.style.font"));
        String labelFontStyle = ObjectConverter.asString((Object)this._context.getPropertyValue("axis.x.labels.style.font"));
        if (labelFontStyle != null && labelFontStyle.length() > 0) {
            this.axisComponent(0).labelStyle(labelFontStyle);
        } else {
            this.axisComponent(0).labelStyle(ObjectConverter.asString((Object)this._context.getPropertyValue("axis.x.labels.style.fill")), ObjectConverter.asString((Object)this._context.getPropertyValue("axis.x.labels.style.font-size")), ObjectConverter.asString((Object)this._context.getPropertyValue("axis.x.labels.style.font-family")));
        }
        if (titleFontStyle != null && titleFontStyle.length() > 0) {
            this.axisComponent(0).titleStyle(titleFontStyle);
        } else {
            this.axisComponent(0).titleStyle(ObjectConverter.asString((Object)this._context.getPropertyValue("axis.x.title.style.fill")), ObjectConverter.asString((Object)this._context.getPropertyValue("axis.x.title.style.font-size")), ObjectConverter.asString((Object)this._context.getPropertyValue("axis.x.title.style.font-family")));
        }
        if (setGridParameters) {
            this.gridComponent(0).displayGridlines(ObjectConverter.toBoolean((Object)this._context.getPropertyValue("axis.x.gridlines.display"))).gridlineStyle(ObjectConverter.asString((Object)this._context.getPropertyValue("axis.x.gridlines.style.stroke")), ObjectConverter.asString((Object)this._context.getPropertyValue("axis.x.gridlines.style.stroke-dasharray")));
        }
        this.suppressPanLabels(0, ObjectConverter.toBoolean((Object)this._context.getPropertyValue("axis.x.labels.zoomPan")));
        return this;
    }

    public AxesManager useDefaultY1Properties(boolean setGridParameters) {
        this.axisComponent(2).padding(16).displayAxisTitle(ObjectConverter.toBoolean((Object)this._context.getPropertyValue("axis.y.title.display"))).axisTitle(this._context.getDataSlotLabel("axis.y.title.text", (ArrayEx)this._dataSlotEntries.get(2))).displayAxisLine(ObjectConverter.toBoolean((Object)this._context.getPropertyValue("axis.y.line.display"))).lineColor(ObjectConverter.asString((Object)this._context.getPropertyValue("axis.y.line.style.stroke"))).displayTicks(ObjectConverter.toBoolean((Object)this._context.getPropertyValue("axis.y.ticks.display"))).tickColor(ObjectConverter.asString((Object)this._context.getPropertyValue("axis.y.ticks.style.stroke"))).displayTickLabels(ObjectConverter.toBoolean((Object)this._context.getPropertyValue("axis.y.labels.display")));
        String titleFontStyle = ObjectConverter.asString((Object)this._context.getPropertyValue("axis.y.title.style.font"));
        String labelFontStyle = ObjectConverter.asString((Object)this._context.getPropertyValue("axis.y.labels.style.font"));
        if (labelFontStyle != null && labelFontStyle.length() > 0) {
            this.axisComponent(2).labelStyle(labelFontStyle);
        } else {
            this.axisComponent(2).labelStyle(ObjectConverter.asString((Object)this._context.getPropertyValue("axis.y.labels.style.fill")), ObjectConverter.asString((Object)this._context.getPropertyValue("axis.y.labels.style.font-size")), ObjectConverter.asString((Object)this._context.getPropertyValue("axis.y.labels.style.font-family")));
        }
        if (titleFontStyle != null && titleFontStyle.length() > 0) {
            this.axisComponent(2).titleStyle(titleFontStyle);
        } else {
            this.axisComponent(2).titleStyle(ObjectConverter.asString((Object)this._context.getPropertyValue("axis.y.title.style.fill")), ObjectConverter.asString((Object)this._context.getPropertyValue("axis.y.title.style.font-size")), ObjectConverter.asString((Object)this._context.getPropertyValue("axis.y.title.style.font-family")));
        }
        if (setGridParameters) {
            this.gridComponent(2).displayGridlines(ObjectConverter.toBoolean((Object)this._context.getPropertyValue("axis.y.gridlines.display"))).gridlineStyle(ObjectConverter.asString((Object)this._context.getPropertyValue("axis.y.gridlines.style.stroke")), ObjectConverter.asString((Object)this._context.getPropertyValue("axis.y.gridlines.style.stroke-dasharray")));
        }
        this.suppressPanLabels(2, ObjectConverter.toBoolean((Object)this._context.getPropertyValue("axis.y.labels.zoomPan")));
        return this;
    }

    public AxesManager useDefaultY2Properties(boolean setGridParameters) {
        this.axisComponent(3).padding(16).displayAxisTitle(ObjectConverter.toBoolean((Object)this._context.getPropertyValue("axis.y2.title.display"))).axisTitle(this._context.getDataSlotLabel("axis.y2.title.text", (ArrayEx)this._dataSlotEntries.get(3))).displayAxisLine(ObjectConverter.toBoolean((Object)this._context.getPropertyValue("axis.y2.line.display"))).lineColor(ObjectConverter.asString((Object)this._context.getPropertyValue("axis.y2.line.style.stroke"))).displayTicks(ObjectConverter.toBoolean((Object)this._context.getPropertyValue("axis.y2.ticks.display"))).tickColor(ObjectConverter.asString((Object)this._context.getPropertyValue("axis.y2.ticks.style.stroke"))).displayTickLabels(ObjectConverter.toBoolean((Object)this._context.getPropertyValue("axis.y2.labels.display")));
        String titleFontStyle = ObjectConverter.asString((Object)this._context.getPropertyValue("axis.y2.title.style.font"));
        String labelFontStyle = ObjectConverter.asString((Object)this._context.getPropertyValue("axis.y2.labels.style.font"));
        if (labelFontStyle != null && labelFontStyle.length() > 0) {
            this.axisComponent(3).labelStyle(labelFontStyle);
        } else {
            this.axisComponent(3).labelStyle(ObjectConverter.asString((Object)this._context.getPropertyValue("axis.y2.labels.style.fill")), ObjectConverter.asString((Object)this._context.getPropertyValue("axis.y2.labels.style.font-size")), ObjectConverter.asString((Object)this._context.getPropertyValue("axis.y2.labels.style.font-family")));
        }
        if (titleFontStyle != null && titleFontStyle.length() > 0) {
            this.axisComponent(3).titleStyle(titleFontStyle);
        } else {
            this.axisComponent(3).titleStyle(ObjectConverter.asString((Object)this._context.getPropertyValue("axis.y2.title.style.fill")), ObjectConverter.asString((Object)this._context.getPropertyValue("axis.y2.title.style.font-size")), ObjectConverter.asString((Object)this._context.getPropertyValue("axis.y2.title.style.font-family")));
        }
        if (setGridParameters) {
            this.gridComponent(3).displayGridlines(ObjectConverter.toBoolean((Object)this._context.getPropertyValue("axis.y2.gridlines.display"))).gridlineStyle(ObjectConverter.asString((Object)this._context.getPropertyValue("axis.y2.gridlines.style.stroke")), ObjectConverter.asString((Object)this._context.getPropertyValue("axis.y2.gridlines.style.stroke-dasharray")));
        }
        this.suppressPanLabels(3, ObjectConverter.toBoolean((Object)this._context.getPropertyValue("axis.y2.labels.zoomPan")));
        return this;
    }

    public AxesManager setTickFormatterList(int role, ArrayEx<DataSlotEntry> entries, String format, ValueFunction<Object, String> defaultFunction) {
        String fmtRole;
        switch (role) {
            case 2: {
                fmtRole = "ROLE_Y1";
                break;
            }
            case 1: {
                fmtRole = "ROLE_X2";
                break;
            }
            case 3: {
                fmtRole = "ROLE_Y2";
                break;
            }
            default: {
                fmtRole = "ROLE_X1";
            }
        }
        ValueFunction fmt = this._context.getCustomFormatterWithFlag(new String[]{ROLE_FORMATTERS[role], FORMATTERS[this.roleToPosition(role)], "axis", "all"}, BundleContext.makeCustomFormatInfo((String)"axis-label", (String)fmtRole, (String)format, entries), defaultFunction, false);
        this.axisComponent(role).tickFormat((ValueFunction<Object, String>)fmt);
        ValueFunction simplefmt = this._context.getCustomFormatterWithFlag(new String[]{ROLE_FORMATTERS[role], FORMATTERS[this.roleToPosition(role)], "axis", "all"}, BundleContext.makeCustomFormatInfo((String)"axis-label", (String)fmtRole, (String)format, entries), defaultFunction, true);
        this.axisComponent(role).simplifiedTickFormat((ValueFunction<Object, String>)simplefmt);
        return this;
    }

    public AxesManager setTickFormatter(int role, DataSlotEntry entry) {
        ArrayEx entries = new ArrayEx();
        if (entry != null) {
            entries.add((Object)entry);
        }
        return this.setTickFormatterList(role, (ArrayEx<DataSlotEntry>)entries, "none", null);
    }

    public AxesManager setScaleRanges(Double padding, Double outerPadding, int pixelPad) {
        this.setIndependentScaleRanges(padding, outerPadding, pixelPad);
        this.setDependentScaleRanges(padding, outerPadding, pixelPad);
        return this;
    }

    public AxesManager setIndependentScaleRanges(Double padding, Double outerPadding, int pixelPad) {
        this.setScaleRangePadded(this._scales[0], false, padding, outerPadding, pixelPad);
        this.setScaleRangePadded(this._scales[1], false, padding, outerPadding, pixelPad);
        return this;
    }

    public AxesManager setDependentScaleRanges(Double padding, Double outerPadding, int pixelPad) {
        this.setScaleRangePadded(this._scales[2], true, padding, outerPadding, pixelPad);
        this.setScaleRangePadded(this._scales[3], true, padding, outerPadding, pixelPad);
        return this;
    }

    public AxesManager setDataSlot(int role, DataSlotEntry slot) {
        this.setDataSlot(role, (List<DataSlotEntry>)new ArrayEx((Object[])new DataSlotEntry[]{slot}));
        return this;
    }

    public AxesManager setDataSlot(int role, List<DataSlotEntry> slots) {
        if (role < 4 && role >= 0) {
            ((ArrayEx)this._dataSlotEntries.get(role)).clear();
            if (slots != null) {
                for (DataSlotEntry slot : slots) {
                    ((ArrayEx)this._dataSlotEntries.get(role)).push((Object[])new DataSlotEntry[]{slot});
                }
            }
        }
        return this;
    }

    void setScaleRangePadded(CoordinateScaleImpl scale, boolean dependent, Double padding, Double outerPadding, int pixelPad) {
        if (scale != null) {
            double max;
            double min;
            if (dependent == this._transpose) {
                min = this._elementRect.x + (double)pixelPad;
                max = this._elementRect.x + this._elementRect.width - (double)pixelPad;
            } else if (scale.isContinuous()) {
                min = this._elementRect.y + this._elementRect.height - (double)pixelPad;
                max = this._elementRect.y + (double)pixelPad;
            } else {
                min = this._elementRect.y + (double)pixelPad;
                max = this._elementRect.y + this._elementRect.height - (double)pixelPad;
            }
            scale.range(min, max, padding, outerPadding);
        }
    }

    public static final ValueFunction<Object, String> percentFormat(int n) {
        String digits = "." + n + "f";
        final ValueFunction format = Rave.format.create(digits);
        return new ValueFunction<Object, String>(){

            public String getValue(Object ctx, Object value, int ix, int gix) {
                return (String)format.getValue(null, value, 0, 0) + "%";
            }
        };
    }

    private int positionToRole(int position) {
        int r = position;
        if (this._transpose) {
            r = (r + 2) % 4;
        }
        if (this._swapX && r < 2) {
            r = 1 - r;
        }
        if (this._swapY && r > 1) {
            r = 5 - r;
        }
        return r;
    }

    private int roleToPosition(int role) {
        int p = role;
        if (this._swapX && role < 2) {
            p = 1 - p;
        }
        if (this._swapY && p > 1) {
            p = 5 - p;
        }
        if (this._transpose) {
            p = (p + 2) % 4;
        }
        return p;
    }

    public AxesManager scaleTickMagnitude(int role, Double tickMagnitude) {
        this.axisComponent(role).scaleTickMagnitude(tickMagnitude);
        return this;
    }

    private static class AxisLayout {
        public int position;
        public int score;

        AxisLayout(int position, int score) {
            this.position = position;
            this.score = score;
        }
    }
}

