/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.components;

import com.ibm.rave.bundles.components.BundleComponentImpl;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.RaveRect;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.CallbackFunction;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.svg.LinePathGenerator;
import com.ibm.rave.ext.text.nativeImpl.FontChecker;
import com.ibm.rave.library.framework.internal.CoordinateScaleImpl;

public final class AxisCalloutImpl
extends BundleComponentImpl<AxisCalloutImpl> {
    private Object _datum = null;
    private CoordinateScaleImpl _x = null;
    private CoordinateScaleImpl _y = null;
    private SingleValueFunction<Object, Object> _xAccessor = X_ACCESSOR;
    private SingleValueFunction<Object, Object> _yAccessor = Y_ACCESSOR;
    private boolean _xVisible = true;
    private boolean _yVisible = true;
    private Double _xPos = 0.0;
    private Double _yPos = 0.0;
    private String _xSide = "bottom";
    private String _ySide = "left";
    private double _xLeft = 0.0;
    private double _xRight = 0.0;
    private double _yBottom = 0.0;
    private double _yTop = 0.0;
    public static final ValueFunction<Object, String> _defaultFormatter = Rave.format.create(".2f");
    private ValueFunction<Object, String> _calloutFormatter = null;
    private String _clipId = null;
    private static final SingleValueFunction<Object, Object> X_ACCESSOR = new SingleValueFunction<Object, Object>(){

        public Object getValue(Object d) {
            return ((OMap)d).get((Object)"x");
        }
    };
    private static final SingleValueFunction<Object, Object> Y_ACCESSOR = new SingleValueFunction<Object, Object>(){

        public Object getValue(Object d) {
            return ((OMap)d).get((Object)"y");
        }
    };
    private static final String CALLOUT = "callout";
    private static final String CALLOUT_SELECTOR = ".callout";
    private static final String CALLOUT_LABEL = "label";
    private static final String CALLOUT_LABEL_SELECTOR = ".label";
    private static final double PAD = 8.0;
    private static final double ARROW_SIZE = 5.0;
    private static final LinePathGenerator pGen = Rave.svg.line.create().x((ValueFunction)new ValueFunction<Object, Object>(){

        public Object getValue(Object context, Object data, int index, int groupIndex) {
            return ((ArrayEx)data).get(0);
        }
    }).y((ValueFunction)new ValueFunction<Object, Object>(){

        public Object getValue(Object context, Object data, int index, int groupIndex) {
            return ((ArrayEx)data).get(1);
        }
    });

    public static AxisCalloutImpl create() {
        return new AxisCalloutImpl();
    }

    @Override
    public String type() {
        return "AxisCalloutComponent";
    }

    @Override
    protected void execute(Selector g) {
        Number y;
        Number x;
        Object yVal;
        final AxisCalloutImpl self = this;
        ArrayEx calloutData = new ArrayEx();
        final Object xVal = this._datum != null ? this._xAccessor.getValue(this._datum) : null;
        Object object = yVal = this._datum != null ? this._yAccessor.getValue(this._datum) : null;
        if (this._x != null && xVal != null) {
            if (this._xVisible) {
                OMap xDatum = new OMap();
                xDatum.put((Object)"value", xVal);
                xDatum.put((Object)"side", (Object)this._xSide);
                calloutData.add((Object)xDatum);
            }
            x = this._x.center(xVal);
        } else {
            x = this._xPos;
        }
        if (this._y != null && yVal != null) {
            if (this._yVisible) {
                OMap yDatum = new OMap();
                yDatum.put((Object)"value", yVal);
                yDatum.put((Object)"side", (Object)this._ySide);
                calloutData.add((Object)yDatum);
            }
            y = this._y.center(yVal);
        } else {
            y = this._yPos;
        }
        Selector callouts = g.selectAll(CALLOUT_SELECTOR).data(calloutData.toArray());
        Selector calloutsEnter = callouts.enter().append("g").classed(CALLOUT, true).style("opacity", (Object)1.0E-6);
        Rave.transition((Selection)callouts.exit()).style("opacity", (Object)1.0E-6).remove();
        calloutsEnter.each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode context, Object data, int index, int groupIndex) {
                String side = ObjectConverter.toString((Object)((OMap)data).get((Object)"side"));
                Selector calloutEnter = Rave.select((SceneNode)context);
                calloutEnter.append("line");
                calloutEnter.append("g").classed(AxisCalloutImpl.CALLOUT_LABEL, true);
                Selector lineEnter = calloutEnter.select((Object)"line");
                Selector labelEnter = calloutEnter.select((Object)AxisCalloutImpl.CALLOUT_LABEL_SELECTOR);
                labelEnter.append("path");
                labelEnter.append("text");
                Selector textEnter = labelEnter.select((Object)"text");
                lineEnter.attr("x1", (Object)x).attr("y1", (Object)y).attr("x2", (Object)x).attr("y2", (Object)y);
                labelEnter.attr("transform", (Object)self.labelTransform(side, x, y));
                AxisCalloutImpl.textProperties(textEnter, side);
            }
        });
        callouts.each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode context, Object data, int index, int groupIndex) {
                String side = ObjectConverter.toString((Object)((OMap)data).get((Object)"side"));
                boolean orientY = "left".equals(side) || "right".equals(side);
                Selector callout = Rave.select((SceneNode)context);
                Selection calloutUpdate = Rave.transition((Selection)callout).style("opacity", (Object)1);
                Selector line = callout.select((Object)"line");
                Selector path = callout.select((Object)AxisCalloutImpl.CALLOUT_LABEL_SELECTOR).select((Object)"path");
                Selection lineUpdate = calloutUpdate.select((Object)"line");
                Selection labelUpdate = calloutUpdate.select((Object)AxisCalloutImpl.CALLOUT_LABEL_SELECTOR);
                line.attr("clip-path", (Object)("url(" + self._clipId + ")"));
                lineUpdate.attr("x1", (Object)x).attr("y1", (Object)y).attr("x2", (Object)(orientY ? (Number)("left".equals(side) ? self._xLeft : self._xRight) : (Number)x)).attr("y2", (Object)(orientY ? (Number)y : (Number)("bottom".equals(side) ? self._yBottom : self._yTop)));
                labelUpdate.attr("transform", (Object)self.labelTransform(side, x, y));
                FontChecker fontChecker = (FontChecker)Rave.capabilities.extension("fontchecker");
                Selector labelText = callout.select((Object)AxisCalloutImpl.CALLOUT_LABEL_SELECTOR).select((Object)"text").text((Object)self.valueToString(self.valueToString(orientY ? yVal : xVal, false), false)).call((RunFunction)fontChecker, new Object[0]);
                path.datum((Object)AxisCalloutImpl.buildPlaquePath(labelText.node().getBBox(), side)).attr("d", (ValueFunction)pGen);
            }
        });
    }

    private String labelTransform(String side, Number x, Number y) {
        double tx = 0.0;
        double ty = 0.0;
        if ("left".equals(side)) {
            tx = this._xLeft;
            ty = y == null ? 0.0 : y.doubleValue();
        } else if ("right".equals(side)) {
            tx = this._xRight;
            ty = y == null ? 0.0 : y.doubleValue();
        } else if ("bottom".equals(side)) {
            tx = x == null ? 0.0 : x.doubleValue();
            ty = this._yBottom;
        } else if ("top".equals(side)) {
            tx = x == null ? 0.0 : x.doubleValue();
            ty = this._yTop;
        }
        return "translate(" + tx + "," + ty + ")";
    }

    private static void textProperties(Selector text, String side) {
        String dx = null;
        String y = null;
        String textAnchor = "middle";
        if ("left".equals(side)) {
            dx = "-7px";
            textAnchor = "end";
        } else if ("right".equals(side)) {
            dx = "7px";
            textAnchor = "start";
        } else if ("bottom".equals(side)) {
            y = "15px";
        } else if ("top".equals(side)) {
            y = "-15px";
        }
        text.attr("dx", (Object)dx).attr("dy", (Object)"0.3em").attr("y", (Object)y).attr("text-anchor", (Object)textAnchor);
    }

    private String valueToString(Object v, boolean inArray) {
        if (v instanceof ArrayEx) {
            ArrayEx a = (ArrayEx)v;
            int size = a.size();
            String s = "";
            for (int i = 0; i < size; ++i) {
                s = s + this.valueToString(a.get(i), true);
                if (i >= size - 1) continue;
                s = s + ",";
            }
            return s;
        }
        if (!inArray && v instanceof Number) {
            return this._calloutFormatter == null ? (String)_defaultFormatter.getValue(null, v, 0, 0) : (String)this._calloutFormatter.getValue(null, v, 0, 0);
        }
        return ObjectConverter.toString((Object)v);
    }

    @SwiftMethodOverload(skipParameters={1})
    public AxisCalloutImpl datum(Object d) {
        this._datum = d;
        return this;
    }

    public AxisCalloutImpl x(CoordinateScaleImpl scale) {
        this._x = scale;
        return this;
    }

    public AxisCalloutImpl x(Double p) {
        this._x = null;
        this._xPos = p;
        return this;
    }

    public AxisCalloutImpl y(CoordinateScaleImpl scale) {
        this._y = scale;
        return this;
    }

    public AxisCalloutImpl y(Double p) {
        this._y = null;
        this._yPos = p;
        return this;
    }

    public AxisCalloutImpl xAccessor(SingleValueFunction f) {
        this._xAccessor = f;
        return this;
    }

    public AxisCalloutImpl yAccessor(SingleValueFunction f) {
        this._yAccessor = f;
        return this;
    }

    @SwiftMethodOverload(overloads={"Bool"})
    public AxisCalloutImpl xVisible(Object visible) {
        this._xVisible = ObjectConverter.toBoolean((Object)visible);
        return this;
    }

    @SwiftMethodOverload(overloads={"Bool"})
    public AxisCalloutImpl yVisible(Object visible) {
        this._yVisible = ObjectConverter.toBoolean((Object)visible);
        return this;
    }

    public AxisCalloutImpl xSide(String xSide) {
        if ("top".equals(xSide) || "bottom".equals(xSide)) {
            this._xSide = xSide;
        }
        return this;
    }

    public AxisCalloutImpl ySide(String ySide) {
        if ("left".equals(ySide) || "right".equals(ySide)) {
            this._ySide = ySide;
        }
        return this;
    }

    public AxisCalloutImpl baseHorizontal(double left, double right) {
        this._xLeft = left;
        this._xRight = right;
        return this;
    }

    public AxisCalloutImpl baseVertical(double top, double bottom) {
        this._yTop = top;
        this._yBottom = bottom;
        return this;
    }

    public AxisCalloutImpl calloutFormat(ValueFunction<Object, String> format) {
        this._calloutFormatter = format;
        return this;
    }

    public AxisCalloutImpl clip(String selectorQuery) {
        this._clipId = selectorQuery;
        return this;
    }

    private AxisCalloutImpl() {
    }

    private static ArrayEx<ArrayEx<Double>> buildPlaquePath(RaveRect textBounds, String side) {
        ArrayEx points = new ArrayEx();
        double x0 = textBounds.x - 8.0;
        double xc = textBounds.x + textBounds.width / 2.0;
        double x1 = textBounds.x + textBounds.width + 8.0;
        double y0 = textBounds.y - 8.0;
        double yc = textBounds.y + textBounds.height / 2.0;
        double y1 = textBounds.y + textBounds.height + 8.0;
        points.push((Object[])new ArrayEx[]{new ArrayEx((Object[])new Double[]{x0, y0})});
        if ("bottom".equals(side)) {
            points.push((Object[])new ArrayEx[]{new ArrayEx((Object[])new Double[]{xc - 5.0, y0})});
            points.push((Object[])new ArrayEx[]{new ArrayEx((Object[])new Double[]{xc, y0 - 5.0})});
            points.push((Object[])new ArrayEx[]{new ArrayEx((Object[])new Double[]{xc + 5.0, y0})});
        }
        points.push((Object[])new ArrayEx[]{new ArrayEx((Object[])new Double[]{x1, y0})});
        if ("left".equals(side)) {
            points.push((Object[])new ArrayEx[]{new ArrayEx((Object[])new Double[]{x1, yc - 5.0})});
            points.push((Object[])new ArrayEx[]{new ArrayEx((Object[])new Double[]{x1 + 5.0, yc})});
            points.push((Object[])new ArrayEx[]{new ArrayEx((Object[])new Double[]{x1, yc + 5.0})});
        }
        points.push((Object[])new ArrayEx[]{new ArrayEx((Object[])new Double[]{x1, y1})});
        if ("top".equals(side)) {
            points.push((Object[])new ArrayEx[]{new ArrayEx((Object[])new Double[]{xc + 5.0, y1})});
            points.push((Object[])new ArrayEx[]{new ArrayEx((Object[])new Double[]{xc, y0 + 5.0})});
            points.push((Object[])new ArrayEx[]{new ArrayEx((Object[])new Double[]{xc - 5.0, y1})});
        }
        points.push((Object[])new ArrayEx[]{new ArrayEx((Object[])new Double[]{x0, y1})});
        if ("right".equals(side)) {
            points.push((Object[])new ArrayEx[]{new ArrayEx((Object[])new Double[]{x0, yc + 5.0})});
            points.push((Object[])new ArrayEx[]{new ArrayEx((Object[])new Double[]{x0 - 5.0, yc})});
            points.push((Object[])new ArrayEx[]{new ArrayEx((Object[])new Double[]{x0, yc - 5.0})});
        }
        points.push((Object[])new ArrayEx[]{new ArrayEx((Object[])new Double[]{x0, y0})});
        return points;
    }
}

