/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.components;

import com.ibm.rave.bundles.component.AxisComponent;
import com.ibm.rave.bundles.component.ChartLayoutSizable;
import com.ibm.rave.bundles.components.BundleComponentImpl;
import com.ibm.rave.bundles.utilities.BundleLabelDropper;
import com.ibm.rave.bundles.utilities.FontPropertyParser;
import com.ibm.rave.bundles.utilities.TextCrossfader;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.geom.Dim;
import com.ibm.rave.core.geom.RaveRect;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.timer.TimerEvent;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.CallbackFunction;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.SelectorGroup;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.svg.AbstractTickHandler;
import com.ibm.rave.core.svg.Axis;
import com.ibm.rave.core.transition.Transition;
import com.ibm.rave.ext.text.nativeImpl.FontChecker;
import com.ibm.rave.ext.text.wrap.TextFlow;
import com.ibm.rave.library.action.BundleUtils;
import com.ibm.rave.library.framework.internal.CoordinateScaleImpl;
import java.util.List;

public class AxisComponentImpl
extends BundleComponentImpl<AxisComponentImpl>
implements AxisComponent,
ChartLayoutSizable {
    @InlineStringConstant
    private static final String VISIBILITY = "visibility";
    @InlineStringConstant
    private static final String HIDDEN = "hidden";
    @InlineStringConstant
    public static final String LABEL_HIDDEN_FLAG = "__tickLabelHidden__";
    @InlineStringConstant
    public static final String PANZOOM_HIDDEN_FLAG = "__panZoomHidden__";
    @InlineStringConstant
    public static final String HIDDEN_COUNT = "__hiddenCount__";
    @InlineStringConstant
    public static final double PREFERRED_SPACE_PER_TICK = 20.0;
    @InlineStringConstant
    public static final double PREFERRED_TICK_COUNT = 10.0;
    @InlineStringConstant
    public static final double TICK_PADDING = 10.0;
    @InlineStringConstant
    private static final double HORIZONTAL_WEIGHT = 1.1;
    private Axis _axis;
    private String _role;
    private CoordinateScaleImpl _scale;
    private String _orient;
    private RectStruct _bounds;
    private RectStruct _elementRect;
    public boolean _displayAxisTitle;
    public String _axisTitle;
    public OMap<String, Object> _titleStyle;
    public boolean _displayAxisLine;
    public String _lineColor;
    public boolean _displayTicks;
    public String _tickColor;
    public boolean _displayTickLabels;
    public boolean _showPanZoomTickLabels;
    public OMap<String, Object> _labelStyle;
    boolean _rotateLabels;
    ArrayEx<NodeIndex> _staggerRotate45Nodes;
    double _staggerCellWidth;
    SceneNode _staggerFirstNode;
    SceneNode _staggerLastNode;
    boolean _staggerAlignFirstAtStart;
    boolean _staggerAlignLastAtEnd;
    int _layoutTimerId = 0;
    private double _layoutTitleSize = 0.0;
    private double _layoutLabelSize = 0.0;
    private double _layoutLabelHeight = 0.0;
    private double _layoutAverageDigitWidth = 0.0;
    private double _layoutSpillOver = 0.0;
    private ValueFunction<Object, String> _tickFormat;
    public boolean _hideOverlappingLabels;
    private final BundleLabelDropper _dropOverlap;
    private boolean _pendingLabelTimer;
    int _padding;
    private boolean _renderedShapes;
    private final TextFlow _textFlow;
    private final FontChecker _fontChecker;
    private static final int AUTOMODE = -1;
    private static final int HORIZONTAL = 0;
    private static final int ROTATE90 = 1;
    private static final int ROTATE45 = 2;
    private static final int STAGGER = 3;
    private static final double TEXTFLOW_SPACING = 1.2;
    @InlineStringConstant
    public static final String BOTTOM_ORIENTATION = "bottom";
    @InlineStringConstant
    public static final String TOP_ORIENTATION = "top";
    @InlineStringConstant
    public static final String LEFT_ORIENTATION = "left";
    @InlineStringConstant
    public static final String RIGHT_ORIENTATION = "right";
    private final RunFunction<Selection<?>> _axisLineProperties;
    private final RunFunction<Selection<?>> _axisTickProperties;
    private final RunFunction<Selection<?>> _axisTickLabelProperties;
    private final CallbackFunction<SceneNode> _displayHideLabels;
    private final CallbackFunction<SceneNode> _panZoomLabels;
    private final AxisTickHandler _tickHandler;
    private String _textTruncationIndicator;
    private int _layoutMode;
    private boolean _allowAutoAxisLayoutToChangeOrientaiton;
    private int _lastAutomaticAxisLayoutOrientation;
    private boolean _allowStagger;
    private boolean _allowRotate45;
    private boolean _allowRotate90;
    private ValueFunction<Object, String> _simplifiedTickFormat;
    private Double _tickMagnitude;

    public AxisComponentImpl() {
        final AxisComponentImpl self = this;
        this._axisLineProperties = new RunFunction<Selection<?>>(){

            public Object run(Selection<?> ticks, Object ... args) {
                Selection line = ticks.selectAll("path.domain");
                if (self._lineColor != null) {
                    line.style("stroke", (Object)self._lineColor);
                }
                if (self._displayAxisLine) {
                    line.attr(AxisComponentImpl.VISIBILITY, null);
                } else {
                    line.attr(AxisComponentImpl.VISIBILITY, (Object)AxisComponentImpl.HIDDEN);
                }
                return null;
            }
        };
        this._axisTickProperties = new RunFunction<Selection<?>>(){

            public Object run(Selection<?> ticks, Object ... args) {
                Selection tickLines = ticks.selectAll("line");
                if (self._displayTicks) {
                    tickLines.attr(AxisComponentImpl.VISIBILITY, null);
                } else {
                    tickLines.attr(AxisComponentImpl.VISIBILITY, (Object)AxisComponentImpl.HIDDEN);
                }
                if (self._lineColor != null) {
                    tickLines.style("stroke", (Object)self._tickColor);
                }
                return null;
            }
        };
        this._axisTickLabelProperties = new RunFunction<Selection<?>>(){

            public Object run(Selection<?> ticks, Object ... args) {
                Selection labels = ticks.selectAll("text");
                labels.each(self._displayHideLabels);
                labels.each(self._panZoomLabels);
                labels.style(self._labelStyle);
                self._axis.ticksHandler(null);
                return null;
            }
        };
        this._displayHideLabels = new CallbackFunction<SceneNode>(){

            public void run(SceneNode context, Object obj, int group, int index) {
                if (self._displayTickLabels) {
                    if (context.hasProperty(AxisComponentImpl.LABEL_HIDDEN_FLAG)) {
                        context.removeProperty(AxisComponentImpl.LABEL_HIDDEN_FLAG);
                        int count = ObjectConverter.toInt((Object)context.getProperty(AxisComponentImpl.HIDDEN_COUNT));
                        if (count <= 1) {
                            context.removeProperty(AxisComponentImpl.HIDDEN_COUNT);
                            context.removeAttribute(AxisComponentImpl.VISIBILITY);
                        } else {
                            context.setProperty(AxisComponentImpl.HIDDEN_COUNT, (Object)(count - 1));
                        }
                    }
                } else if (!context.hasProperty(AxisComponentImpl.LABEL_HIDDEN_FLAG)) {
                    context.setAttribute(AxisComponentImpl.VISIBILITY, (Object)AxisComponentImpl.HIDDEN);
                    context.setProperty(AxisComponentImpl.LABEL_HIDDEN_FLAG, (Object)AxisComponentImpl.HIDDEN);
                    int count = ObjectConverter.toInt((Object)context.getProperty(AxisComponentImpl.HIDDEN_COUNT));
                    context.setProperty(AxisComponentImpl.HIDDEN_COUNT, (Object)(count + 1));
                }
            }
        };
        this._panZoomLabels = new CallbackFunction<SceneNode>(){

            public void run(SceneNode context, Object obj, int group, int index) {
                if (self._showPanZoomTickLabels) {
                    if (context.hasProperty(AxisComponentImpl.PANZOOM_HIDDEN_FLAG)) {
                        context.removeProperty(AxisComponentImpl.PANZOOM_HIDDEN_FLAG);
                        int count = ObjectConverter.toInt((Object)context.getProperty(AxisComponentImpl.HIDDEN_COUNT));
                        if (count <= 1) {
                            context.removeProperty(AxisComponentImpl.HIDDEN_COUNT);
                            context.removeAttribute(AxisComponentImpl.VISIBILITY);
                        } else {
                            context.setProperty(AxisComponentImpl.HIDDEN_COUNT, (Object)(count - 1));
                        }
                    }
                } else if (!context.hasProperty(AxisComponentImpl.PANZOOM_HIDDEN_FLAG)) {
                    context.setAttribute(AxisComponentImpl.VISIBILITY, (Object)AxisComponentImpl.HIDDEN);
                    context.setProperty(AxisComponentImpl.PANZOOM_HIDDEN_FLAG, (Object)AxisComponentImpl.HIDDEN);
                    int count = ObjectConverter.toInt((Object)context.getProperty(AxisComponentImpl.HIDDEN_COUNT));
                    context.setProperty(AxisComponentImpl.HIDDEN_COUNT, (Object)(count + 1));
                }
            }
        };
        this._tickHandler = new AxisTickHandler(this._axisTickLabelProperties, this._axisTickProperties);
        this._textTruncationIndicator = null;
        this._layoutMode = -1;
        this._allowAutoAxisLayoutToChangeOrientaiton = true;
        this._lastAutomaticAxisLayoutOrientation = -1;
        this._allowStagger = false;
        this._allowRotate45 = false;
        this._allowRotate90 = false;
        this._simplifiedTickFormat = null;
        this._tickMagnitude = null;
        this._axis = null;
        this._role = null;
        this._scale = null;
        this._orient = BOTTOM_ORIENTATION;
        this._bounds = null;
        this._displayAxisTitle = true;
        this._axisTitle = null;
        this._titleStyle = new OMap();
        this._displayAxisLine = true;
        this._lineColor = null;
        this._displayTicks = true;
        this._tickColor = null;
        this._displayTickLabels = true;
        this._labelStyle = new OMap();
        this._rotateLabels = false;
        this._hideOverlappingLabels = true;
        this._dropOverlap = new BundleLabelDropper();
        this._tickFormat = null;
        this._showPanZoomTickLabels = true;
        this._pendingLabelTimer = false;
        this._padding = 16;
        this._textFlow = (TextFlow)Rave.capabilities.extension("textflow");
        this._fontChecker = (FontChecker)Rave.capabilities.extension("fontchecker");
        this._renderedShapes = false;
    }

    @Override
    public String type() {
        return "AxisComponent";
    }

    @Override
    public String role() {
        return this._role;
    }

    @Override
    protected void execute(Selector g) {
        this.preExecute();
        if (this._scale == null) {
            g.selectAll("*").remove();
            this._renderedShapes = false;
            return;
        }
        this._renderedShapes = true;
        if (this._scale.isOrdinal() || this._scale.isClustered()) {
            this._hideOverlappingLabels = false;
            this._rotateLabels = true;
        } else {
            this._hideOverlappingLabels = true;
            this._rotateLabels = true;
        }
        this.drawTitle(g);
        this.drawAxis(g);
        this.handleAxisText(g);
        this.drawTitle(g);
    }

    private void handleAxisText(Selector g) {
        this.stopLabelDroppingUpdate();
        double duration = 0.0;
        double delay = 0.0;
        Selection g2 = Rave.transition((Selection)g);
        if (g2.isTransition()) {
            Transition t2 = (Transition)g2;
            duration = t2.duration();
            delay = t2.delay();
        }
        Selector axisSelector = g.selectAll("g.axis");
        Selector labels = axisSelector.selectAll("g.tick").filter(BundleUtils.notExit).selectAll("text");
        FontChecker fontChecker = (FontChecker)Rave.capabilities.extension("fontchecker");
        labels.style(this._labelStyle);
        if (fontChecker != null) {
            labels.call((RunFunction)fontChecker, new Object[0]);
        }
        int mode = this._allowAutoAxisLayoutToChangeOrientaiton ? this.determineWhichAutoMode(g) : this._lastAutomaticAxisLayoutOrientation;
        this.configureStaggerData(g, mode);
        this.handleLabelsRotationAndPosition(g, labels, mode);
        this.hashingNumericScales(labels, this.labelExtent(g), mode);
        if (duration == 0.0) {
            this.doLabelWrapping(g, mode);
            this.handleLabelsRotationAndPosition(g, labels, mode);
        }
        this._lastAutomaticAxisLayoutOrientation = mode;
        if (!this._scale.isOrdinal() && !this._scale.isClustered()) {
            boolean isHorizontal = this._orient.equals(BOTTOM_ORIENTATION) || this._orient.equals(TOP_ORIENTATION);
            Selector tick = axisSelector.append("g").classed("tick", true);
            Selector tickText = tick.append("text");
            if (labels.size() == 0) {
                AbstractScale.TickFormatValueFunction tickFunc;
                Object singleValue = this._scale.scale().domain().get(0);
                ValueFunction formatter = this._tickFormat;
                if (formatter == null && (tickFunc = this._scale.scale().tickFormat) != null) {
                    formatter = tickFunc.getValue(new Object[]{singleValue});
                }
                SceneNode node = (SceneNode)((SelectorGroup)tickText.get(0)).get(0);
                String stringValue = formatter != null ? (String)formatter.getValue((Object)node, singleValue, 0, 0) : ObjectConverter.toString(singleValue);
                tickText.text((Object)stringValue);
                RaveRect dim = node.getBBox();
                double d = this._layoutLabelSize = isHorizontal ? dim.height : dim.width;
                if (!isHorizontal || mode != 0) {
                    tickText.text((Object)".0");
                    this._layoutLabelSize += node.getBBox().width;
                }
            }
            if (!isHorizontal || mode != 0) {
                tickText.text((Object)".0");
                SceneNode node = (SceneNode)((SelectorGroup)tickText.get(0)).get(0);
                RaveRect dim = node.getBBox();
                this._layoutAverageDigitWidth = dim.width;
            }
            tick.remove();
        }
        if (this._hideOverlappingLabels && duration > 0.0) {
            this.updateLabelDropping(labels, duration, delay);
        }
        if (duration > 0.0) {
            this.doLabelWrappingAfterAnimation(g, labels, mode, duration, delay);
        }
        if (!this._displayTickLabels) {
            this._layoutLabelSize = 0.0;
            this._layoutAverageDigitWidth = 0.0;
        }
    }

    private void handleLabelsRotationAndPosition(Selector g, Selector labels, int mode) {
        if (mode == 2 || mode == 1) {
            if (this._orient.equals(BOTTOM_ORIENTATION)) {
                this.rotateLabels(g, labels, "end", mode);
            } else if (this._orient.equals(TOP_ORIENTATION)) {
                this.rotateLabels(g, labels, "start", mode);
            } else {
                this.rotateLabels(g, labels, "middle", mode);
            }
        } else if (this._orient.equals(BOTTOM_ORIENTATION) || this._orient.equals(TOP_ORIENTATION)) {
            this.rotateLabels(g, labels, "middle", mode);
        } else if (this._orient.equals(RIGHT_ORIENTATION)) {
            this.rotateLabels(g, labels, "start", mode);
        } else {
            this.rotateLabels(g, labels, "end", mode);
        }
    }

    private void hashingNumericScales(Selector labels, Dim extent, int mode) {
        if (labels == null || extent == null) {
            return;
        }
        if (!this._scale.isOrdinal() && !this._scale.isClustered()) {
            boolean isHorizontal = this._orient.equals(BOTTOM_ORIENTATION) || this._orient.equals(TOP_ORIENTATION);
            double tickSpace = mode == 1 ? extent.getHeight() : extent.getWidth();
            this._textTruncationIndicator = "";
            this._layoutLabelSize = 0.0;
            for (int i = 0; i < labels.size(); ++i) {
                double size;
                SceneNode node = (SceneNode)((SelectorGroup)labels.get(i)).get(0);
                RaveRect dim = node.getBBox();
                double width = dim.width;
                double height = dim.height;
                double d = size = !isHorizontal || mode == 1 ? width : height;
                if (size > this._layoutLabelSize) {
                    this._layoutLabelSize = size;
                }
                if (!(width >= tickSpace)) continue;
                if (this._simplifiedTickFormat != null) {
                    String newText = (String)this._simplifiedTickFormat.getValue(null, node.getData(), 0, 0);
                    if (newText != null) {
                        node.setText(newText);
                    }
                    if (!(node.getBBox().width >= tickSpace)) continue;
                    node.setText(this.stringOfSize(node.getText().length(), "#"));
                    continue;
                }
                node.setText(this.stringOfSize(node.getText().length(), "#"));
            }
        }
    }

    private String stringOfSize(int size, String ch) {
        String returnString = "";
        for (int i = 0; i < size; ++i) {
            returnString = returnString + ch;
        }
        return returnString;
    }

    private void configureStaggerData(Selector g, int mode) {
        if (mode == 3 || mode == 2) {
            Dim horizontalDimensions = this.labelExtent(g);
            double cellWidth = horizontalDimensions.getWidth();
            Selector axisSelector = g.selectAll("g.axis");
            Selector labels = axisSelector.selectAll("text");
            List domain = this._scale.scale().domain();
            ValueFunction originalDataLabelAccessor = this._scale.originalDomainLabelAccessor();
            this._staggerRotate45Nodes = new ArrayEx();
            this._staggerFirstNode = null;
            this._staggerLastNode = null;
            for (int i = 0; i < labels.size(); ++i) {
                SceneNode node = (SceneNode)((SelectorGroup)labels.get(0)).get(i);
                if (!this.isValid(node.getData())) continue;
                int domainIndex = -1;
                if (mode == 3) {
                    String domainLabel = this._tickFormat == null ? node.getText() : (String)originalDataLabelAccessor.getValue((Object)node, node.getData(), 0, 0);
                    for (int index = 0; index < domain.size(); ++index) {
                        if (!domain.get(index).toString().equals(domainLabel)) continue;
                        domainIndex = index;
                        break;
                    }
                }
                this._staggerRotate45Nodes.add((Object)new NodeIndex(node, domainIndex));
                if (domainIndex == 0) {
                    this._staggerFirstNode = node;
                }
                if (domainIndex != domain.size() - 1) continue;
                this._staggerLastNode = node;
            }
            this._staggerCellWidth = cellWidth * 2.0;
            boolean bl = this._staggerFirstNode != null ? this._staggerFirstNode.getBBox().width > cellWidth : (this._staggerAlignFirstAtStart = false);
            this._staggerAlignLastAtEnd = this._staggerLastNode != null ? this._staggerLastNode.getBBox().width > cellWidth : false;
        }
    }

    private int getStaggerIndex(SceneNode node) {
        for (int index = 0; index < this._staggerRotate45Nodes.size(); ++index) {
            if (!((NodeIndex)this._staggerRotate45Nodes.get(index)).contains(node)) continue;
            int domainIndex = ((NodeIndex)this._staggerRotate45Nodes.get(index)).getIndex();
            return domainIndex == -1 ? 0 : domainIndex;
        }
        return -1;
    }

    private int getStaggerCount() {
        List domain = this._scale.scale().domain();
        return domain.size();
    }

    private int determineWhichAutoMode(Selector g) {
        boolean isHorizontal = this._orient.equals(BOTTOM_ORIENTATION) || this._orient.equals(TOP_ORIENTATION);
        Selector axisSelector = g.selectAll("g.axis");
        Selector labels = axisSelector.selectAll("text");
        Dim dim = this.labelExtent(g);
        double cellWidth = dim.getWidth();
        double cellWidth90 = dim.getHeight();
        double layoutLabelHeight = 0.0;
        double layoutLabelWidth = 0.0;
        double horizontalScore = 0.0;
        double staggerScore = 0.0;
        double rotate45Score = 0.0;
        double rotate90Score = 0.0;
        ArrayEx validNodes = new ArrayEx();
        for (int i = 0; i < labels.size(); ++i) {
            SceneNode node = (SceneNode)((SelectorGroup)labels.get(0)).get(i);
            if (!this.isValid(node.getData())) continue;
            validNodes.add((Object)node);
        }
        int labelCount = validNodes.size();
        if (!this._scale.isOrdinal() && !this._scale.isClustered()) {
            int mode = 0;
            if (isHorizontal) {
                mode = this._layoutMode == 1 ? 1 : 0;
                Selector tick = axisSelector.append("g").classed("tick", true);
                Selector tickText = tick.append("text");
                tickText.style(this._labelStyle);
                tickText.text((Object)",0");
                SceneNode node = (SceneNode)((SelectorGroup)tickText.get(0)).get(0);
                double zeroWidth = node.getBBox().width;
                tick.remove();
                double widestLabel = 0.0;
                for (int i = 0; i < labelCount; ++i) {
                    node = (SceneNode)validNodes.get(i);
                    RaveRect nodeRect = node.getBBox();
                    if (nodeRect.width > widestLabel) {
                        widestLabel = nodeRect.width;
                    }
                    if (!(nodeRect.height > this._layoutLabelHeight)) continue;
                    this._layoutLabelHeight = nodeRect.height;
                }
                this._layoutSpillOver = mode == 1 ? this._layoutLabelHeight / 2.0 : (widestLabel += zeroWidth) / 2.0 + 2.0;
            } else {
                for (int i = 0; i < labelCount; ++i) {
                    SceneNode node = (SceneNode)validNodes.get(i);
                    RaveRect nodeRect = node.getBBox();
                    if (!(nodeRect.height > this._layoutLabelHeight)) continue;
                    this._layoutLabelHeight = nodeRect.height;
                }
                this._layoutSpillOver = this._layoutLabelHeight / 2.0;
            }
            return mode;
        }
        ValueFunction originalDataLabelAccessor = this._scale.originalDomainLabelAccessor();
        boolean staggerStringsWontMatch = this._tickFormat != null && originalDataLabelAccessor == null;
        boolean calcStagger = (this._allowStagger && this._layoutMode == -1 || this._layoutMode == 3) && !staggerStringsWontMatch;
        boolean calcRotate45 = this._allowRotate45 && this._layoutMode == -1 || this._layoutMode == 2;
        boolean calcRotate90 = this._allowRotate90 && this._layoutMode == -1 || this._layoutMode == 1;
        double spaceFor45Label = 0.0;
        for (int i = 0; i < labelCount; ++i) {
            SceneNode node = (SceneNode)validNodes.get(i);
            RaveRect nodeRect = node.getBBox();
            layoutLabelHeight = nodeRect.height;
            double labelWidth = nodeRect.width;
            if (labelWidth > layoutLabelWidth) {
                layoutLabelWidth = labelWidth;
            }
            horizontalScore += labelWidth <= cellWidth ? 1.0 : cellWidth / labelWidth;
            if (!isHorizontal) continue;
            if (calcStagger) {
                double spaceForLabel = cellWidth * 2.0;
                if (i == 0 && i == labelCount - 1) {
                    spaceForLabel *= 0.5;
                } else if (i == 0 || i == labelCount - 1) {
                    spaceForLabel *= 0.75;
                }
                staggerScore += labelWidth <= spaceForLabel ? 1.0 : spaceForLabel / labelWidth;
            }
            if (calcRotate45) {
                double space;
                if (spaceFor45Label == 0.0) {
                    spaceFor45Label = cellWidth90 / 0.7071 - layoutLabelHeight;
                }
                rotate45Score += labelWidth <= (space = this.calculate45DegreeSpace(node, spaceFor45Label)) ? 1.0 : space / labelWidth;
            }
            if (!calcRotate90) continue;
            rotate90Score += labelWidth <= cellWidth90 ? 1.0 : cellWidth90 / labelWidth;
        }
        int mode = 0;
        if (this._layoutMode == -1) {
            if (isHorizontal && this._allowStagger) {
                horizontalScore *= 1.1;
                staggerScore *= 1.1;
            }
            if (staggerScore > horizontalScore && staggerScore >= rotate45Score && staggerScore >= rotate90Score) {
                mode = 3;
            } else if (rotate45Score > horizontalScore && rotate45Score >= rotate90Score) {
                mode = 2;
            } else if (rotate90Score > horizontalScore) {
                mode = 1;
            }
        } else {
            mode = this._layoutMode == 3 && staggerStringsWontMatch || !isHorizontal ? 0 : this._layoutMode;
        }
        if (isHorizontal) {
            switch (mode) {
                case 3: {
                    this._layoutLabelSize = layoutLabelHeight * 2.0;
                    break;
                }
                case 2: {
                    this._layoutLabelSize = (layoutLabelWidth + layoutLabelHeight) * 0.7071;
                    break;
                }
                case 1: {
                    this._layoutLabelSize = layoutLabelWidth;
                    break;
                }
                default: {
                    this._layoutLabelSize = layoutLabelHeight;
                    break;
                }
            }
        } else {
            this._layoutLabelSize = layoutLabelWidth;
        }
        this._layoutLabelHeight = layoutLabelHeight;
        return mode;
    }

    private double calculate45DegreeSpace(SceneNode node, double maxWidth) {
        int indexOfComma;
        String tfmString;
        int indexOfTrans;
        double width = maxWidth;
        Object tfm = node.getParentNode().getAttribute("transform");
        if (tfm != null && (indexOfTrans = (tfmString = tfm.toString()).indexOf("translate(")) != -1 && (indexOfComma = tfmString.indexOf(",", indexOfTrans += 10)) != -1) {
            String xAmount = tfmString.substring(indexOfTrans, indexOfComma);
            double xLabelPos = ObjectConverter.toDouble((Object)xAmount);
            double width45Degrees = node.getBBox().width;
            double xLabelWidth = width45Degrees * 0.7071;
            boolean isBottom = this._orient.equals(BOTTOM_ORIENTATION);
            if (isBottom) {
                if ((xLabelPos -= node.getBBox().height / 4.0) - xLabelWidth < this._bounds.x) {
                    xLabelWidth = xLabelPos - this._bounds.x;
                    width = xLabelWidth / 0.7071;
                }
            } else if (xLabelPos + xLabelWidth > this._bounds.x + this._bounds.width) {
                xLabelWidth = this._bounds.x + this._bounds.width - xLabelPos;
                width = xLabelWidth / 0.7071;
            }
            if (width > maxWidth) {
                width = maxWidth;
            }
        }
        return width;
    }

    private void rotateLabels(Selector g, Selector labels, String textAnchor, final int mode) {
        if (this._rotateLabels) {
            final AxisComponentImpl self = this;
            ValueFunction<SceneNode, String> positioning = new ValueFunction<SceneNode, String>(){

                @SwiftMethodOverload(skipParameters={1})
                public String getValue(SceneNode context, Object data, int index, int groupIndex) {
                    double x = 0.0;
                    double y = 0.0;
                    int rotation_cy = 0;
                    boolean isBottom = self._orient.equals(AxisComponentImpl.BOTTOM_ORIENTATION);
                    if (mode == 3) {
                        int cellIndex = self.getStaggerIndex(context);
                        if (cellIndex != -1) {
                            if (cellIndex % 2 == 1) {
                                double staggerDirection = isBottom ? 1.0 : -1.0;
                                y += self._layoutLabelHeight * staggerDirection;
                            }
                            if (cellIndex == 0 && self._staggerAlignFirstAtStart) {
                                x -= self._staggerCellWidth / 4.0;
                            } else if (cellIndex == self.getStaggerCount() - 1 && self._staggerAlignLastAtEnd) {
                                x += self._staggerCellWidth / 4.0;
                            }
                        }
                    } else if (mode == 2) {
                        x = isBottom ? (x -= self._layoutLabelHeight) : (x += self._layoutLabelHeight / 2.0);
                    } else if (mode == 1) {
                        if (isBottom) {
                            x -= context.getBBox().height / 2.0 + self._layoutLabelHeight / 4.0;
                            rotation_cy = (int)((double)(self._padding / 4) + self._axis.tickSize());
                        } else {
                            x -= context.getBBox().height / 2.0 - self._layoutLabelHeight;
                            rotation_cy = (int)(-((double)(self._padding / 4) + self._axis.tickSize()));
                        }
                    }
                    double rotationDegrees = mode == 1 ? -90.0 : (mode == 2 ? -45.0 : 0.0);
                    return "translate(" + x + "," + y + ") rotate(" + rotationDegrees + ",0," + rotation_cy + ")";
                }
            };
            labels.attr("transform", (ValueFunction)positioning).style("text-anchor", (Object)textAnchor);
            if (mode == 3) {
                if (this._staggerAlignFirstAtStart) {
                    this._staggerFirstNode.setStyle("text-anchor", (Object)"start");
                }
                if (this._staggerAlignLastAtEnd) {
                    this._staggerLastNode.setStyle("text-anchor", (Object)"end");
                }
            }
        }
    }

    @Override
    public Axis axis() {
        return this._axis;
    }

    private void drawAxis(Selector g) {
        Selector axisSelector = g.selectAll("g.axis").data(new Object[]{0});
        axisSelector.enter().append("g").classed("axis", true).classed(this._orient, true);
        if (this._axis == null) {
            this._axis = new Axis();
        }
        if (this._hideOverlappingLabels) {
            this._textFlow.valignment(TOP_ORIENTATION).dropTextOnFail(false);
        }
        this._axis.ticksHandler((AbstractTickHandler)this._tickHandler);
        this._axis.orient(this._orient);
        this._axis.tickFormat(this._tickFormat);
        this._axis.tickPadding((Object)10.0);
        if (this._scale.isOrdinal() || this._scale.isClustered()) {
            boolean isHorizontal;
            double labelHeight = 20.0;
            boolean bl = isHorizontal = this._orient.equals(BOTTOM_ORIENTATION) || this._orient.equals(TOP_ORIENTATION);
            if (isHorizontal) {
                labelHeight /= 0.7071;
            }
            List range = this._scale.scale().rangeExtent.getValue();
            double extent = ObjectConverter.toDouble(range.get(1)) - ObjectConverter.toDouble(range.get(0));
            this._axis.ticks(new Object[]{extent / labelHeight});
        } else if (this._tickMagnitude == null) {
            this._axis.ticks(new Object[]{10.0});
        } else {
            this._axis.ticks(new Object[]{10.0, this._scale.scale().getTickFormat(), this._tickMagnitude});
        }
        AbstractScale s = this._scale.scale();
        if (this._scale.originalDomain() != null) {
            AbstractScale sOrdinal = s.copy();
            sOrdinal.domain(this._scale.originalDomain());
            s = sOrdinal;
            final AxisComponentImpl self = this;
            final ValueFunction originalDataLabelAccessor = self._scale.originalDomainLabelAccessor();
            Object tickFormatter = originalDataLabelAccessor != null ? (this._tickFormat != null ? new ValueFunction<Object, String>(){

                @SwiftMethodOverload(skipParameters={1})
                public String getValue(Object context, Object data, int index, int groupIndex) {
                    return (String)self._tickFormat.getValue(context, originalDataLabelAccessor.getValue(context, data, index, groupIndex), index, groupIndex);
                }
            } : originalDataLabelAccessor) : this._tickFormat;
            this._axis.tickFormat(tickFormatter);
        }
        this._axis.scale(s);
        axisSelector.call((RunFunction)this._axis, new Object[0]);
        Selection g2 = Rave.transition((Selection)axisSelector);
        if (!g2.isTransition()) {
            axisSelector.selectAll("text").call((RunFunction)this._dropOverlap, new Object[]{this._hideOverlappingLabels});
        }
        axisSelector.selectAll("path.domain").classed("axis-line", true);
        axisSelector.selectAll("g.tick line").classed("axis-tick", true);
        if (this._fontChecker != null) {
            axisSelector.selectAll("g.tick text").classed("axis-label", true).call((RunFunction)this._fontChecker, new Object[0]);
        } else {
            axisSelector.selectAll("g.tick text").classed("axis-label", true);
        }
        axisSelector.call(this._axisLineProperties, new Object[0]);
    }

    private void drawTitle(Selector g) {
        if (!this._displayAxisTitle || this._axisTitle == null || this._axisTitle.trim().length() == 0 || this._bounds == null) {
            g.selectAll("text.axis-title." + this._orient).remove();
            return;
        }
        double x = 0.0;
        double y = 0.0;
        String dy = "";
        String transform = null;
        if (TOP_ORIENTATION.equals(this._orient)) {
            x = this._elementRect.x + this._elementRect.width / 2.0;
            y = -this._bounds.height + (double)(this._padding / 4);
            dy = "0.75em";
        } else if (BOTTOM_ORIENTATION.equals(this._orient)) {
            x = this._elementRect.x + this._elementRect.width / 2.0;
            y = this._bounds.height - (double)(this._padding / 4);
            dy = "-0.25em";
        } else if (LEFT_ORIENTATION.equals(this._orient)) {
            x = -this._elementRect.y - this._elementRect.height / 2.0;
            y = -this._bounds.width + (double)(this._padding / 4);
            dy = "0.75em";
            transform = "rotate(-90)";
        } else {
            x = this._elementRect.y + this._elementRect.height / 2.0;
            y = -this._bounds.width + (double)(this._padding / 4);
            dy = "0.75em";
            transform = "rotate(90)";
        }
        Selector tmp = g.append("text").attr("class", (Object)("axis-title " + this._orient));
        Object fillOpacity = tmp.style("fill-opacity");
        tmp.remove();
        Selector label = g.selectAll("text.axis-title." + this._orient);
        if (label.size() == 0) {
            ((Selector)label.data(new Object[]{0}).enter().append("text").attr("class", (Object)("axis-title " + this._orient)).style("text-anchor", (Object)"middle").attr("x", (Object)x).attr("y", (Object)y).attr("transform", (Object)transform).attr("dy", (Object)dy).style(this._titleStyle)).text((Object)this._axisTitle);
            if (this._fontChecker != null) {
                g.selectAll("text.axis-title." + this._orient).call((RunFunction)this._fontChecker, new Object[0]);
            }
        }
        TextCrossfader.textCrossFade(Rave.transition((Selection)label), label.text(), this._axisTitle, fillOpacity, 0.25).style("text-anchor", (Object)"middle").attr("x", (Object)x).attr("y", (Object)y).attr("transform", (Object)transform).attr("dy", (Object)dy).style(this._titleStyle);
    }

    private AbstractScale getUnZoomedScale(AbstractScale scale) {
        AbstractScale s = scale.copy();
        if (s.getZoomTransform() != null) {
            s.getZoomTransform().zoomTransform((Number)1, (Number)0);
        }
        return s;
    }

    private boolean isValid(Object data) {
        AbstractScale s = this.getUnZoomedScale(this._axis.scale());
        double v = ObjectConverter.toDouble((Object)s.getValue(null, data, 0, 0));
        List range = this._axis.scale().range();
        if (this._axis.scale().range().contains(v)) {
            return true;
        }
        if (((Number)range.get(0)).doubleValue() < v && v < ((Number)range.get(1)).doubleValue()) {
            return true;
        }
        return ((Number)range.get(0)).doubleValue() > v && v > ((Number)range.get(1)).doubleValue();
    }

    private void doLabelWrapping(Selector g, final int mode) {
        if (this._displayTickLabels) {
            boolean allowWrap;
            Dim d;
            this._textFlow.valignment(TOP_ORIENTATION);
            if (!this._hideOverlappingLabels) {
                this._textFlow.dropTextOnFail(true);
            }
            if ((d = this.labelExtent(g)) == null || d.getWidth() < 0.0 || d.getHeight() < 0.0) {
                return;
            }
            int w = ObjectConverter.toInt((Object)d.getWidth());
            int h = ObjectConverter.toInt((Object)d.getHeight());
            if (mode == 2) {
                w = (int)(d.getHeight() / 0.7071 - this._layoutLabelHeight);
                h = (int)(this._layoutLabelHeight / 0.7071);
            } else if (mode == 1) {
                int tmp = w;
                w = h;
                h = tmp;
            }
            boolean bl = allowWrap = mode == 1;
            if (this._scale.isOrdinal() || this._scale.isClustered()) {
                boolean isHorizontal;
                int hActual = ObjectConverter.toInt((Object)(this._layoutLabelHeight * 1.2));
                if (hActual > h) {
                    h = hActual;
                }
                boolean bl2 = isHorizontal = this._orient.equals(BOTTOM_ORIENTATION) || this._orient.equals(TOP_ORIENTATION);
                if (mode == 0 && !isHorizontal) {
                    allowWrap = true;
                }
            }
            final AxisComponentImpl self = this;
            final int cellWidth = w;
            final int cellHeight = h;
            this._textFlow.wrap(allowWrap).truncate(true).textTruncateIndicator(this._textTruncationIndicator != null ? this._textTruncationIndicator : "...").spacing(1.2).extent((ValueFunction)new ValueFunction<SceneNode, Dim>(){

                public Dim getValue(SceneNode context, Object data, int index, int groupIndex) {
                    int cellIndex;
                    int width = cellWidth;
                    int height = cellHeight;
                    if (mode == 2) {
                        int cellIndex2 = self.getStaggerIndex(context);
                        if (cellIndex2 != -1) {
                            width = (int)self.calculate45DegreeSpace(context, cellWidth);
                        }
                    } else if (mode == 3 && (cellIndex = self.getStaggerIndex(context)) != -1) {
                        width = cellIndex == 0 && cellIndex == self.getStaggerCount() - 1 ? cellWidth : (cellIndex == 0 || cellIndex == self.getStaggerCount() - 1 ? cellWidth * 3 / 2 : cellWidth * 2);
                        height = cellHeight / 2;
                    }
                    return new Dim((double)width, (double)height);
                }
            });
            g.selectAll("g.tick > text").call((RunFunction)this._textFlow, new Object[0]);
        }
    }

    public Dim labelExtent(Selector g) {
        boolean isHorizontal = this._orient.equals(BOTTOM_ORIENTATION) || this._orient.equals(TOP_ORIENTATION);
        double w = this._bounds.width;
        double h = this._bounds.height;
        if (this._scale.scale().rangeBand != null) {
            double rangeBandValue = ObjectConverter.toDouble((Object)this._scale.scale().rangeBand.getValue());
            if (isHorizontal) {
                w = rangeBandValue;
            } else {
                h = rangeBandValue;
            }
        }
        this.calcTitleExtent(g);
        if (isHorizontal) {
            h -= this._axis.tickSize();
            h -= (double)(this._padding / 2);
            if (this._layoutTitleSize != 0.0) {
                h -= this._layoutTitleSize;
                h -= (double)(this._padding / 2);
            }
        } else {
            w -= this._axis.tickSize();
            w -= (double)(this._padding / 2);
            if (this._layoutTitleSize != 0.0) {
                w -= this._layoutTitleSize;
                w -= (double)(this._padding / 2);
            }
        }
        return new Dim(w, h);
    }

    private void calcTitleExtent(Selector g) {
        this._layoutTitleSize = 0.0;
        Selector title = g.selectAll("text.axis-title");
        if (title.size() > 0) {
            double textHeight;
            this._layoutTitleSize = textHeight = ((SceneNode)((SelectorGroup)title.get((int)0)).get((int)0)).getBBox().height;
        }
    }

    public static double[] getTranslation(RectStruct bounds, String orient) {
        if (LEFT_ORIENTATION.equals(orient)) {
            return new double[]{bounds.x + bounds.width, 0.0};
        }
        if (RIGHT_ORIENTATION.equals(orient)) {
            return new double[]{bounds.x, 0.0};
        }
        if (TOP_ORIENTATION.equals(orient)) {
            return new double[]{0.0, bounds.y + bounds.height};
        }
        return new double[]{0.0, bounds.y};
    }

    public AxisComponentImpl setRole(String role) {
        this._role = role;
        return this;
    }

    public AxisComponent scaleTickMagnitude(Double tickMagnitude) {
        this._tickMagnitude = tickMagnitude;
        return this;
    }

    public AxisComponentImpl scale(CoordinateScaleImpl scale) {
        this._scale = scale != null ? scale : null;
        return this;
    }

    public AxisComponentImpl orient(String orient) {
        if (LEFT_ORIENTATION.equals(orient) || BOTTOM_ORIENTATION.equals(orient) || RIGHT_ORIENTATION.equals(orient) || TOP_ORIENTATION.equals(orient)) {
            this._orient = orient;
            if (this._role == null) {
                this._role = LEFT_ORIENTATION.equals(orient) ? "ROLE_Y1" : (BOTTOM_ORIENTATION.equals(orient) ? "ROLE_X1" : (RIGHT_ORIENTATION.equals(orient) ? "ROLE_Y2" : "ROLE_X2"));
            }
        }
        return this;
    }

    public String orient() {
        return this._orient;
    }

    public AxisComponentImpl bounds(RectStruct bounds) {
        this._bounds = bounds;
        return this;
    }

    public AxisComponentImpl elementRect(RectStruct elementRect) {
        this._elementRect = elementRect;
        return this;
    }

    @Override
    public AxisComponent tickFormat(ValueFunction<Object, String> tickFormat) {
        this._tickFormat = tickFormat;
        return this;
    }

    @Override
    public ValueFunction<Object, String> tickFormat() {
        return this._tickFormat;
    }

    public AxisComponent simplifiedTickFormat(ValueFunction<Object, String> tickFormat) {
        this._simplifiedTickFormat = tickFormat;
        return this;
    }

    public ValueFunction<Object, String> simplifiedTickFormat() {
        return this._simplifiedTickFormat;
    }

    @Override
    public AxisComponent displayAxisTitle(boolean displayAxisTitle) {
        this._displayAxisTitle = displayAxisTitle;
        return this;
    }

    @Override
    public AxisComponent displayAxisLine(boolean displayAxisLine) {
        this._displayAxisLine = displayAxisLine;
        return this;
    }

    @Override
    public AxisComponent displayTicks(boolean displayTicks) {
        this._displayTicks = displayTicks;
        return this;
    }

    @Override
    public AxisComponent displayTickLabels(boolean displayTickLabels) {
        this._displayTickLabels = displayTickLabels;
        return this;
    }

    public AxisComponentImpl allowAutomaticAxisLayoutToChangeOrientation(boolean state) {
        this._allowAutoAxisLayoutToChangeOrientaiton = state;
        return this;
    }

    public boolean isAllowAutomaticAxisLayoutToChangeOrientation() {
        return this._allowAutoAxisLayoutToChangeOrientaiton;
    }

    @Override
    public AxisComponent showPanZoomTickLabels(boolean showPanZoomTickLabels) {
        this._showPanZoomTickLabels = showPanZoomTickLabels;
        return this;
    }

    @Override
    public AxisComponent axisTitle(String axisTitle) {
        this._axisTitle = axisTitle;
        return this;
    }

    @Override
    public AxisComponent axisColor(String axisColor) {
        this._lineColor = axisColor;
        this._tickColor = axisColor;
        return this;
    }

    @Override
    public AxisComponent lineColor(String lineColor) {
        this._lineColor = lineColor;
        return this;
    }

    @Override
    public AxisComponent tickColor(String tickColor) {
        this._tickColor = tickColor;
        return this;
    }

    @Override
    public AxisComponent labelColor(String labelColor) {
        this._labelStyle.put((Object)"fill", (Object)labelColor);
        return this;
    }

    @Override
    public AxisComponent labelStyle(String fill, String fontSize, String fontFamily) {
        this._labelStyle.put((Object)"fill", (Object)fill);
        this._labelStyle.put((Object)"font-size", (Object)fontSize);
        this._labelStyle.put((Object)"font-family", (Object)fontFamily);
        return this;
    }

    @Override
    public AxisComponent titleColor(String titleColor) {
        this._titleStyle.put((Object)"fill", (Object)titleColor);
        return this;
    }

    @Override
    public AxisComponent titleStyle(String fill, String fontSize, String fontFamily) {
        this._titleStyle.put((Object)"fill", (Object)fill);
        this._titleStyle.put((Object)"font-size", (Object)fontSize);
        this._titleStyle.put((Object)"font-family", (Object)fontFamily);
        return this;
    }

    public AxisComponentImpl padding(int padding) {
        this._padding = padding;
        return this;
    }

    public AxisComponentImpl layoutMode(String layoutMode) {
        this._layoutMode = -1;
        if (layoutMode != null) {
            if (layoutMode.equals("horizontal")) {
                this._layoutMode = 0;
            } else if (layoutMode.equals("stagger")) {
                this._layoutMode = 3;
            } else if (layoutMode.equals("rotate45")) {
                this._layoutMode = 2;
            } else if (layoutMode.equals("rotate90")) {
                this._layoutMode = 1;
            }
        }
        return this;
    }

    public AxisComponentImpl allowStagger(boolean allow) {
        this._allowStagger = allow;
        return this;
    }

    public AxisComponentImpl allowRotate45(boolean allow) {
        this._allowRotate45 = allow;
        return this;
    }

    public AxisComponentImpl allowRotate90(boolean allow) {
        this._allowRotate90 = allow;
        return this;
    }

    boolean renderedShapes() {
        return this._renderedShapes;
    }

    @Override
    public AxisComponent labelStyle(String fontStyle) {
        this._labelStyle = FontPropertyParser.parseCSSFont(fontStyle);
        return this;
    }

    @Override
    public AxisComponent titleStyle(String fontStyle) {
        this._titleStyle = FontPropertyParser.parseCSSFont(fontStyle);
        return this;
    }

    private boolean isAxisSwapped() {
        return !((!this._role.equals("ROLE_Y1") && !this._role.equals("ROLE_Y2") || !this._orient.equals(TOP_ORIENTATION) && !this._orient.equals(BOTTOM_ORIENTATION)) && (!this._role.equals("ROLE_X1") && !this._role.equals("ROLE_X2") || !this._orient.equals(RIGHT_ORIENTATION) && !this._orient.equals(LEFT_ORIENTATION)));
    }

    @Override
    public AxisComponent textTruncateIndicator(String indicator) {
        this._textTruncationIndicator = indicator;
        return this;
    }

    private void stopLabelDroppingUpdate() {
        this._pendingLabelTimer = false;
    }

    private void updateLabelDropping(final Selector labels, double duration, double delay) {
        final AxisComponentImpl self = this;
        final double start = delay + duration;
        TimerEvent labelCollideCallback = new TimerEvent(){

            public boolean run(double elapsed) {
                if (!self._pendingLabelTimer) {
                    return true;
                }
                labels.call((RunFunction)self._dropOverlap, new Object[]{self._hideOverlappingLabels});
                if (elapsed >= start) {
                    self._pendingLabelTimer = false;
                    return true;
                }
                return false;
            }
        };
        if (duration > 0.0) {
            this._pendingLabelTimer = true;
            Rave.timer.addEvent(labelCollideCallback, start);
        }
    }

    private void doLabelWrappingAfterAnimation(final Selector g, final Selector labels, final int mode, double duration, double delay) {
        ++this._layoutTimerId;
        final int timerId = this._layoutTimerId;
        final AxisComponentImpl self = this;
        TimerEvent wrapCallback = new TimerEvent(){

            public boolean run(double elapsed) {
                if (self._layoutTimerId == timerId) {
                    self.doLabelWrapping(g, mode);
                    self.handleLabelsRotationAndPosition(g, labels, mode);
                }
                return true;
            }
        };
        Rave.timer.addEvent(wrapCallback, delay + duration);
    }

    public void preLayout() {
        this._layoutTitleSize = 0.0;
        this._layoutLabelSize = 0.0;
        this._layoutLabelHeight = 0.0;
        this._layoutAverageDigitWidth = 0.0;
        this._layoutSpillOver = 0.0;
    }

    @Override
    public int getSizableType() {
        return this._scale.isOrdinal() || this._scale.isClustered() ? 1 : 0;
    }

    @Override
    public String getSizableOrientation() {
        return this._orient;
    }

    @Override
    public double getPreferredSize() {
        double layoutPaddingSize = 0.0;
        if (this._axis != null) {
            layoutPaddingSize = this._axis.tickSize();
            if (this._layoutLabelSize != 0.0) {
                layoutPaddingSize += (double)(this._padding / 2);
            }
            if (this._layoutTitleSize != 0.0) {
                layoutPaddingSize += (double)(this._padding / 2);
            }
        }
        return this._layoutLabelSize + this._layoutAverageDigitWidth + this._layoutTitleSize + layoutPaddingSize + 2.0;
    }

    @Override
    public double getSpillOverSize() {
        return this._layoutSpillOver;
    }

    private class AxisTickHandler
    extends AbstractTickHandler {
        private final RunFunction<Selection<?>> _label;
        private final RunFunction<Selection<?>> _tick;

        AxisTickHandler(RunFunction<Selection<?>> label, RunFunction<Selection<?>> tick) {
            this._label = label;
            this._tick = tick;
        }

        public Object run(Object context, Object ... args) {
            this.handle((Selection)args[0]);
            return null;
        }

        public void handle(Selection<?> ticks) {
            ticks.call(this._tick, new Object[0]);
            ticks.call(this._label, new Object[0]);
        }
    }

    private static class NodeIndex {
        private SceneNode _node;
        private int _domainIndex;

        public NodeIndex(SceneNode node, int domainIndex) {
            this._node = node;
            this._domainIndex = domainIndex;
        }

        public boolean contains(SceneNode node) {
            return node == this._node;
        }

        public int getIndex() {
            return this._domainIndex;
        }
    }
}

