/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.components;

import com.ibm.rave.bundles.component.BoxplotComponent;
import com.ibm.rave.bundles.components.KeyedBundleComponentImpl;
import com.ibm.rave.bundles.components.StyleStructs;
import com.ibm.rave.bundles.data.BoxplotDatum;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.CallbackFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.library.framework.internal.BundleContext;
import com.ibm.rave.library.framework.internal.CoordinateScaleImpl;
import com.ibm.rave.library.palette.Palette;

public class BoxplotComponentImpl
extends KeyedBundleComponentImpl<BoxplotComponentImpl>
implements BoxplotComponent {
    public static final double BOXPLOT_OUTLIER_MAX_RADIUS = 4.0;
    private final BundleContext _context;
    private ArrayEx<BoxplotDatum> _data;
    private CoordinateScaleImpl _xScale;
    private CoordinateScaleImpl _yScale;
    private SingleValueFunction<Object, Object> _originalDataYAccessor;
    private Palette _colorPalette;
    private SingleValueFunction<Object, Object> _originalDataColorAccessor;
    private String _effect;
    private int _duration;
    private double _boxplotSize;
    private boolean _dataChanged;
    private final StyleStructs.ShapeStyle _boxStyle;
    private final StyleStructs.LineStyle _whiskerStyle;
    private final StyleStructs.LineStyle _medianStyle;
    private final StyleStructs.LineStyle _meanStyle;
    private final StyleStructs.ShapeStyle _outlierStyle;
    private final StyleStructs.ShapeStyle _extremeStyle;
    private final ValueFunction<Object, Object> _boxplotDatumKeyAccessor;
    @InlineStringConstant
    private static final String BOXPLOT_ELEMENT = "boxplot-element";
    @InlineStringConstant
    private static final String BOXPLOT_BOXCONTAINER = "boxplot-boxcontainer";
    @InlineStringConstant
    private static final String BOXPLOT_BOX = "boxplot-box";
    @InlineStringConstant
    private static final String BOXPLOT_WHISKER = "boxplot-whisker";
    @InlineStringConstant
    private static final String BOXPLOT_MEDIAN = "boxplot-median";
    @InlineStringConstant
    private static final String BOXPLOT_MEAN = "boxplot-mean";
    @InlineStringConstant
    private static final String BOXPLOT_POINT = "boxplot-point";
    @InlineStringConstant
    private static final String BOXPLOT_OUTLIER_POINT = "boxplot-outlier-point";
    @InlineStringConstant
    private static final String BOXPLOT_EXTREME_POINT = "boxplot-extreme-point";
    @InlineStringConstant
    private static final String BOXPLOT_WHISKER_UL = "boxplot-upperwhiskerline";
    @InlineStringConstant
    private static final String BOXPLOT_WHISKER_UB = "boxplot-upperwhiskerbar";
    @InlineStringConstant
    private static final String BOXPLOT_WHISKER_LL = "boxplot-lowerwhiskerline";
    @InlineStringConstant
    private static final String BOXPLOT_WHISKER_LB = "boxplot-lowerwhiskerbar";
    @InlineStringConstant
    private static final String ORIGINAL_FILL = "__rave_originalstyle_fill";
    @InlineStringConstant
    private static final String ORIGINAL_STROKE = "__rave_originalstyle_stroke";
    @InlineStringConstant
    private static final String ORIGINAL_STROKEWIDTH = "__rave_originalstyle_strokewidth";
    @InlineStringConstant
    private static final String ORIGINAL_DASHARRAY = "__rave_originalstyle_strokedasharray";
    @InlineStringConstant
    private static final String ORIGINAL_OPACITY = "__rave_originalstyle_opacity";
    @InlineStringConstant
    private static final String HIGHLIGHT_PROPERTY = "__rave_highlight";
    @InlineStringConstant
    private static final String SELECTION_PROPERTY = "__rave_selection";
    @InlineStringConstant
    private static final String SELECTION_SELECTED = "1";
    @InlineStringConstant
    private static final String SELECTION_UNSELECTED = "0";

    public BoxplotComponentImpl(BundleContext context) {
        this._context = context;
        this._data = null;
        this._xScale = null;
        this._yScale = null;
        this._originalDataYAccessor = null;
        this._colorPalette = null;
        this._originalDataColorAccessor = null;
        this._effect = "none";
        this._duration = 0;
        this._dataChanged = false;
        this._boxStyle = new StyleStructs.ShapeStyle();
        this._whiskerStyle = new StyleStructs.LineStyle();
        this._medianStyle = new StyleStructs.LineStyle();
        this._meanStyle = new StyleStructs.LineStyle();
        this._outlierStyle = new StyleStructs.ShapeStyle();
        this._extremeStyle = new StyleStructs.ShapeStyle();
        this._boxplotDatumKeyAccessor = new ValueFunction<Object, Object>(){

            @SwiftMethodOverload(skipParameters={1})
            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return ((BoxplotDatum)data).key();
            }
        };
    }

    @Override
    public String type() {
        return "BoxplotComponent";
    }

    public final BoxplotComponentImpl data(ArrayEx<BoxplotDatum> data) {
        this._data = data;
        this._dataChanged = true;
        return this;
    }

    public final BoxplotComponentImpl xScale(CoordinateScaleImpl xScale) {
        this._xScale = xScale;
        return this;
    }

    public final BoxplotComponentImpl yScale(CoordinateScaleImpl yScale) {
        this._yScale = yScale;
        return this;
    }

    public final BoxplotComponentImpl yAccessor(SingleValueFunction<Object, Object> yAccessor) {
        this._originalDataYAccessor = yAccessor;
        return this;
    }

    public final BoxplotComponentImpl colorAccessor(SingleValueFunction<Object, Object> colorAccessor) {
        this._originalDataColorAccessor = colorAccessor;
        return this;
    }

    public final BoxplotComponentImpl colorPalette(Palette colorPalette) {
        this._colorPalette = colorPalette;
        return this;
    }

    public final BoxplotComponentImpl effect(String effect) {
        this._effect = effect;
        return this;
    }

    public final BoxplotComponentImpl duration(int duration) {
        this._duration = duration > 0 ? duration : 0;
        return this;
    }

    public final BoxplotComponentImpl boxplotSize(double boxplotSize) {
        this._boxplotSize = Math.max(2.0, boxplotSize);
        return this;
    }

    public final BoxplotComponentImpl boxStyle(String fill, String stroke, String strokeWidth) {
        this._boxStyle._fill = fill;
        this._boxStyle._stroke = stroke;
        this._boxStyle._strokeWidth = strokeWidth;
        return this;
    }

    public final BoxplotComponentImpl whiskerStyle(String stroke, String strokeWidth) {
        this._whiskerStyle._stroke = stroke;
        this._whiskerStyle._strokeWidth = strokeWidth;
        return this;
    }

    public final BoxplotComponentImpl medianStyle(String stroke, String strokeWidth) {
        this._medianStyle._stroke = stroke;
        this._medianStyle._strokeWidth = strokeWidth;
        return this;
    }

    public final BoxplotComponentImpl meanStyle(String stroke, String strokeWidth) {
        this._meanStyle._stroke = stroke;
        this._meanStyle._strokeWidth = strokeWidth;
        return this;
    }

    public final BoxplotComponentImpl outlierStyle(String fill, String stroke, String strokeWidth) {
        this._outlierStyle._fill = fill;
        this._outlierStyle._stroke = stroke;
        this._outlierStyle._strokeWidth = strokeWidth;
        return this;
    }

    public final BoxplotComponentImpl extremeStyle(String fill, String stroke, String strokeWidth) {
        this._extremeStyle._fill = fill;
        this._extremeStyle._stroke = stroke;
        this._extremeStyle._strokeWidth = strokeWidth;
        return this;
    }

    @Override
    protected void execute(Selector g) {
        this.preExecute();
        if (this._data == null || this._xScale == null || this._yScale == null || this._originalDataYAccessor == null) {
            g.selectAll("g.boxplot-element").remove();
            return;
        }
        Selector boxplotGroups = g.selectAll("g.boxplot-element").data(this._data, this._boxplotDatumKeyAccessor);
        boxplotGroups.exit().remove();
        this.enterBoxplotGroups(boxplotGroups.enter());
        this.updateBoxplotGroups(boxplotGroups);
        this._dataChanged = false;
        this._duration = 0;
    }

    private void enterBoxplotGroups(Selector groups) {
        final BoxplotComponentImpl self = this;
        final boolean grow = "grow".equals(this._effect) && this._duration > 0;
        groups.append("g").attr("class", (Object)BOXPLOT_ELEMENT).each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode node, Object data, int index, int groupIndex) {
                Selector g = Rave.select((SceneNode)node);
                BoxplotDatum d = (BoxplotDatum)data;
                Selector c = g.append("g").classed(BoxplotComponentImpl.BOXPLOT_BOXCONTAINER, true);
                c.append("rect").classed("element-shape", true).classed(BoxplotComponentImpl.BOXPLOT_BOX, true);
                c.append("line").classed("element-shape", true).classed(BoxplotComponentImpl.BOXPLOT_WHISKER, true).classed(BoxplotComponentImpl.BOXPLOT_WHISKER_UB, true);
                c.append("line").classed("element-shape", true).classed(BoxplotComponentImpl.BOXPLOT_WHISKER, true).classed(BoxplotComponentImpl.BOXPLOT_WHISKER_UL, true);
                c.append("line").classed("element-shape", true).classed(BoxplotComponentImpl.BOXPLOT_WHISKER, true).classed(BoxplotComponentImpl.BOXPLOT_WHISKER_LL, true);
                c.append("line").classed("element-shape", true).classed(BoxplotComponentImpl.BOXPLOT_WHISKER, true).classed(BoxplotComponentImpl.BOXPLOT_WHISKER_LB, true);
                c.append("line").classed("element-shape", true).classed(BoxplotComponentImpl.BOXPLOT_MEDIAN, true);
                c.append("path").classed("element-shape", true).classed(BoxplotComponentImpl.BOXPLOT_MEAN, true);
                self.updateOutliers(g, d);
                self.setStyleProperties(g, d);
                self.updateBoxplot((Selection<?>)g, d, grow);
            }
        });
    }

    private void updateBoxplotGroups(Selector groups) {
        final BoxplotComponentImpl self = this;
        final boolean grow = this._duration > 0 && "grow".equals(this._effect);
        final boolean doTransition = this._duration > 0 && !"none".equals(this._effect);
        groups.each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode node, Object data, int index, int groupIndex) {
                Selector g = Rave.select((SceneNode)node);
                BoxplotDatum d = (BoxplotDatum)data;
                self.updateOutliers(g, d);
                self.setStyleProperties(g, d);
                if (grow) {
                    self.updateBoxplot((Selection<?>)g, d, grow);
                }
                self.updateBoxplot((Selection<?>)(doTransition ? g.transition().duration((Object)self._duration) : g), d, false);
            }
        });
    }

    final void updateOutliers(Selector g, BoxplotDatum d) {
        final BoxplotComponentImpl self = this;
        Selector outliers = g.selectAll("circle.boxplot-point").data(d.outliers(), this.getKey());
        outliers.enter().append("circle").classed("element-shape", true).classed(BOXPLOT_POINT, true);
        outliers.exit().remove();
        final double lowerExtreme = d.lowerExtreme();
        final double upperExtreme = d.upperExtremum();
        g.selectAll("circle.boxplot-point").classed(BOXPLOT_OUTLIER_POINT, (ValueFunction)new ValueFunction<Object, Boolean>(){

            @SwiftMethodOverload(skipParameters={1})
            public Boolean getValue(Object context, Object data, int index, int groupIndex) {
                double yv = ObjectConverter.toDouble((Object)self._originalDataYAccessor.getValue(data));
                return !(yv < lowerExtreme) && !(yv > upperExtreme);
            }
        }).classed(BOXPLOT_EXTREME_POINT, (ValueFunction)new ValueFunction<Object, Boolean>(){

            @SwiftMethodOverload(skipParameters={1})
            public Boolean getValue(Object context, Object data, int index, int groupIndex) {
                double yv = ObjectConverter.toDouble((Object)self._originalDataYAccessor.getValue(data));
                return yv < lowerExtreme || yv > upperExtreme;
            }
        });
    }

    final void updateBoxplot(Selection<?> g, BoxplotDatum d, boolean grow) {
        final BoxplotComponentImpl self = this;
        g.attr("transform", (Object)("translate(" + this._xScale.center(d.x()) + ",0)"));
        double median = this._yScale.center((Object)d.median()).doubleValue();
        double lowerFence = grow ? median : this._yScale.center((Object)d.lowerFence()).doubleValue();
        double lowerHinge = grow ? median : this._yScale.center((Object)d.lowerHinge()).doubleValue();
        double mean = grow ? median : this._yScale.center((Object)d.mean()).doubleValue();
        double upperHinge = grow ? median : this._yScale.center((Object)d.upperHinge()).doubleValue();
        double upperFence = grow ? median : this._yScale.center((Object)d.upperFence()).doubleValue();
        double rectHalfWidth = this._boxplotSize / 2.0;
        double whiskerHalfWidth = 0.8 * rectHalfWidth;
        double medianHalfWidth = rectHalfWidth - 1.0;
        double meanHalfWidth = Math.min(6.0, rectHalfWidth);
        double outlierRadius = Math.min(4.0, rectHalfWidth);
        Selection s = g.select((Object)"rect.boxplot-box");
        s.attr("x", (Object)(-rectHalfWidth)).attr("y", (Object)Math.min(lowerHinge, upperHinge)).attr("width", (Object)(2.0 * rectHalfWidth)).attr("height", (Object)Math.abs(upperHinge - lowerHinge));
        s = g.select((Object)"line.boxplot-upperwhiskerbar");
        s.attr("x1", (Object)(-whiskerHalfWidth)).attr("x2", (Object)whiskerHalfWidth).attr("y1", (Object)upperFence).attr("y2", (Object)upperFence);
        s = g.select((Object)"line.boxplot-upperwhiskerline");
        s.attr("x1", (Object)0).attr("x2", (Object)0).attr("y1", (Object)upperHinge).attr("y2", (Object)upperFence);
        s = g.select((Object)"line.boxplot-lowerwhiskerbar");
        s.attr("x1", (Object)(-whiskerHalfWidth)).attr("x2", (Object)whiskerHalfWidth).attr("y1", (Object)lowerFence).attr("y2", (Object)lowerFence);
        s = g.select((Object)"line.boxplot-lowerwhiskerline");
        s.attr("x1", (Object)0).attr("x2", (Object)0).attr("y1", (Object)lowerHinge).attr("y2", (Object)lowerFence);
        s = g.selectAll("line.boxplot-whisker");
        s = g.select((Object)"line.boxplot-median");
        s.attr("x1", (Object)(-medianHalfWidth)).attr("x2", (Object)medianHalfWidth).attr("y1", (Object)median).attr("y2", (Object)median);
        s = g.select((Object)"path.boxplot-mean");
        s.attr("d", (Object)("M" + -meanHalfWidth + "," + mean + "L" + meanHalfWidth + "," + mean + "M0," + (mean - meanHalfWidth) + "L0," + (mean + meanHalfWidth)));
        s = g.selectAll("circle.boxplot-point");
        s.attr("cx", (Object)0).attr("cy", (Object)0).attr("r", (Object)outlierRadius);
        if (grow) {
            s.attr("transform", (Object)("translate(0," + median + ")"));
        } else {
            s.attr("transform", (ValueFunction)new ValueFunction<Object, Object>(){

                @SwiftMethodOverload(skipParameters={1})
                public Object getValue(Object context, Object data, int index, int groupIndex) {
                    return "translate(0," + ObjectConverter.toDouble((Object)self._yScale.center(self._originalDataYAccessor.getValue(data))) + ")";
                }
            });
        }
        this.applyShapeStyles(g.selectAll(".element-shape"));
    }

    final void setStyleProperties(Selector g, BoxplotDatum d) {
        if (this._dataChanged) {
            g.selectAll("*").property(HIGHLIGHT_PROPERTY, null).property(SELECTION_PROPERTY, null);
        }
        Object color = "#4b8400";
        if (this._colorPalette != null) {
            if (this._originalDataColorAccessor != null) {
                this._colorPalette.setAccessor(this._originalDataColorAccessor);
                color = this._colorPalette.getValue(null, d.originalDataList().get(0), 0, 0);
            } else {
                color = this._colorPalette.getValue(null, null, 0, 0);
            }
        }
        this.setShapeStyleProperties(g.select((Object)"rect.boxplot-box"), this._boxStyle, color, color);
        this.setLineStyleProperties(g.selectAll("line.boxplot-whisker"), this._whiskerStyle, color);
        this.setLineStyleProperties(g.select((Object)"line.boxplot-median"), this._medianStyle, null);
        this.setLineStyleProperties(g.select((Object)"path.boxplot-mean"), this._meanStyle, null);
        this.setShapeStyleProperties(g.selectAll("circle.boxplot-outlier-point"), this._outlierStyle, null, color);
        this.setShapeStyleProperties(g.selectAll("circle.boxplot-extreme-point"), this._extremeStyle, color, color);
    }

    final void setShapeStyleProperties(Selector g, StyleStructs.ShapeStyle style, Object fill, Object stroke) {
        g.property(ORIGINAL_FILL, style._fill != null ? style._fill : fill).property(ORIGINAL_STROKE, style._stroke != null ? style._stroke : stroke).property(ORIGINAL_STROKEWIDTH, (Object)style._strokeWidth).property(ORIGINAL_OPACITY, null);
    }

    final void setLineStyleProperties(Selector g, StyleStructs.LineStyle style, Object stroke) {
        g.property(ORIGINAL_FILL, null).property(ORIGINAL_STROKE, style._stroke != null ? style._stroke : stroke).property(ORIGINAL_STROKEWIDTH, (Object)style._strokeWidth).property(ORIGINAL_OPACITY, null);
    }

    public final void highlight(Selector s) {
        final BoxplotComponentImpl self = this;
        s.each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode node, Object data, int index, int groupIndex) {
                SceneNode shape = self.logicalShape(node);
                if (shape != null && shape.getProperty(BoxplotComponentImpl.HIGHLIGHT_PROPERTY) == null) {
                    self.updateSelectionState(shape, BoxplotComponentImpl.HIGHLIGHT_PROPERTY, BoxplotComponentImpl.SELECTION_SELECTED);
                }
            }
        });
    }

    public final void unhighlight(Selector s) {
        final BoxplotComponentImpl self = this;
        s.each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode node, Object data, int index, int groupIndex) {
                SceneNode shape = self.logicalShape(node);
                if (shape != null && shape.getProperty(BoxplotComponentImpl.HIGHLIGHT_PROPERTY) != null) {
                    self.updateSelectionState(shape, BoxplotComponentImpl.HIGHLIGHT_PROPERTY, null);
                }
            }
        });
    }

    public final void toggleSelect(Selector s) {
        final BoxplotComponentImpl self = this;
        s.each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode node, Object data, int index, int groupIndex) {
                SceneNode shape = self.logicalShape(node);
                if (shape != null) {
                    self.updateSelectionState(shape, BoxplotComponentImpl.SELECTION_PROPERTY, BoxplotComponentImpl.SELECTION_SELECTED.equals(shape.getProperty(BoxplotComponentImpl.SELECTION_PROPERTY)) ? BoxplotComponentImpl.SELECTION_UNSELECTED : BoxplotComponentImpl.SELECTION_SELECTED);
                }
            }
        });
        Selector all = this._context.node.selectAll(".boxplot-boxcontainer, .boxplot-point");
        all.each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode target, Object data, int index, int groupIndex) {
                if (target.getProperty(BoxplotComponentImpl.SELECTION_PROPERTY) == null) {
                    self.updateSelectionState(target, BoxplotComponentImpl.SELECTION_PROPERTY, BoxplotComponentImpl.SELECTION_UNSELECTED);
                }
            }
        });
    }

    public final void deselectAll(Selector s) {
        final BoxplotComponentImpl self = this;
        Selector all = this._context.node.selectAll(".boxplot-boxcontainer, .boxplot-point");
        all.each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode target, Object data, int index, int groupIndex) {
                if (target.getProperty(BoxplotComponentImpl.SELECTION_PROPERTY) != null) {
                    self.updateSelectionState(target, BoxplotComponentImpl.SELECTION_PROPERTY, null);
                }
            }
        });
    }

    final SceneNode logicalShape(SceneNode node) {
        if (node == null) {
            return null;
        }
        if (node.containsClass(BOXPLOT_POINT)) {
            return node;
        }
        SceneNode parent = node.getParentNode();
        if (parent != null && parent.containsClass(BOXPLOT_BOXCONTAINER)) {
            return parent;
        }
        return null;
    }

    final void updateSelectionState(SceneNode node, final String property, final String value) {
        node.setProperty(property, (Object)value);
        if (node.containsClass(BOXPLOT_BOXCONTAINER)) {
            final BoxplotComponentImpl self = this;
            Rave.select((SceneNode)node).selectAll(".element-shape").each((CallbackFunction)new CallbackFunction<SceneNode>(){

                public void run(SceneNode child, Object data, int index, int groupIndex) {
                    self.updateSelectionState(child, property, value);
                }
            });
        } else {
            this.applyShapeStyles((Selection<?>)Rave.select((SceneNode)node));
        }
    }

    final void applyShapeStyles(Selection<?> s) {
        final BoxplotComponentImpl self = this;
        s.style("fill", (ValueFunction)new ValueFunction<SceneNode, Object>(){

            @SwiftMethodOverload(skipParameters={1})
            public Object getValue(SceneNode node, Object data, int index, int groupIndex) {
                return self.shapeFill(node);
            }
        }).style("stroke", (ValueFunction)new ValueFunction<SceneNode, Object>(){

            @SwiftMethodOverload(skipParameters={1})
            public Object getValue(SceneNode node, Object data, int index, int groupIndex) {
                return self.shapeStroke(node);
            }
        }).style("stroke-width", (ValueFunction)new ValueFunction<SceneNode, Object>(){

            @SwiftMethodOverload(skipParameters={1})
            public Object getValue(SceneNode node, Object data, int index, int groupIndex) {
                return self.shapeStrokeWidth(node);
            }
        }).style("opacity", (ValueFunction)new ValueFunction<SceneNode, Object>(){

            @SwiftMethodOverload(skipParameters={1})
            public Object getValue(SceneNode node, Object data, int index, int groupIndex) {
                return self.shapeOpacity(node);
            }
        });
    }

    final Object shapeFill(SceneNode node) {
        Object fill = node.getProperty(ORIGINAL_FILL);
        if ((node.getProperty(HIGHLIGHT_PROPERTY) != null || SELECTION_SELECTED.equals(node.getProperty(SELECTION_PROPERTY))) && (node.containsClass(BOXPLOT_BOX) || node.containsClass(BOXPLOT_EXTREME_POINT))) {
            return Rave.rgb((Object)fill).brighter(0.2).toString();
        }
        return fill;
    }

    final Object shapeStroke(SceneNode node) {
        Object stroke = node.getProperty(ORIGINAL_STROKE);
        if ((node.getProperty(HIGHLIGHT_PROPERTY) != null || SELECTION_SELECTED.equals(node.getProperty(SELECTION_PROPERTY))) && (node.containsClass(BOXPLOT_BOX) || node.containsClass(BOXPLOT_WHISKER) || node.containsClass(BOXPLOT_POINT))) {
            return Rave.rgb((Object)stroke).darker(0.3).toString();
        }
        return stroke;
    }

    final Object shapeStrokeWidth(SceneNode node) {
        if ((node.getProperty(HIGHLIGHT_PROPERTY) != null || SELECTION_SELECTED.equals(node.getProperty(SELECTION_PROPERTY))) && (node.containsClass(BOXPLOT_BOX) || node.containsClass(BOXPLOT_WHISKER) || node.containsClass(BOXPLOT_POINT))) {
            return "2px";
        }
        return node.getProperty(ORIGINAL_STROKEWIDTH);
    }

    final Object shapeOpacity(SceneNode node) {
        if (SELECTION_UNSELECTED.equals(node.getProperty(SELECTION_PROPERTY))) {
            return 0.3;
        }
        return node.getProperty(ORIGINAL_OPACITY);
    }
}

