/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.components;

import com.ibm.rave.bundles.components.BulletComponentDataUtilities;
import com.ibm.rave.bundles.components.KeyedBundleComponentImpl;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.LinearScale;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.CallbackFunction;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.transition.Transition;
import com.ibm.rave.ext.text.nativeImpl.FontChecker;
import com.ibm.rave.ext.text.wrap.TextFlow;
import com.ibm.rave.library.framework.internal.CoordinateScaleImpl;
import com.ibm.rave.library.palette.Palette;
import java.util.List;

public class BulletComponentImpl
extends KeyedBundleComponentImpl<BulletComponentImpl> {
    private Object[] _data = null;
    private boolean _transition = false;
    private int _duration = 30;
    boolean reverse = false;
    private double _width = 0.0;
    private double _height = 0.0;
    private SingleValueFunction<Object, Object> _titleDataAccessor = null;
    private SingleValueFunction<Object, Object> _subtitleDataAccessor = null;
    private SingleValueFunction<Object, Object> _markersDataAccessor = null;
    private SingleValueFunction<Object, Object> _measuresDataAccessor = null;
    private SingleValueFunction<Object, Object> _rangesDataAccessor = null;
    public ValueFunction<SceneNode, ArrayEx<Object>> _ranges = null;
    public ValueFunction<SceneNode, ArrayEx<Object>> _markers = null;
    ValueFunction<SceneNode, ArrayEx<BulletComponentDataUtilities.RangeStruct>> _measures = null;
    public ValueFunction<SceneNode, ArrayEx<BulletComponentDataUtilities.RangeStruct>> _ranges2 = null;
    private boolean _wrapLabels;
    private TextFlow _textFlow;
    private static final double AXIS_LABEL_EXTENT_CONSTANT = 50.0;
    private static final double TEXTFLOW_SPACING = 1.2;
    private int _topMargin = 5;
    private int _rightMargin = 40;
    private int _bottomMargin = 20;
    private int _leftMargin = 120;
    ValueFunction<Object, String> _tickFormat = null;
    private CoordinateScaleImpl _dependentScale = null;
    private CoordinateScaleImpl _previousDependentScale = null;
    private Palette _colorPalette = null;
    protected String _primaryColor = "black";
    private ValueFunction<Object, Object> _shapeColor = this.shapeColor();
    private Double _rangeHeight = 0.0;
    private int _categoryHeight = 0;
    private int _bulletSize = 100;
    private int _bulletMarkerSize = 50;
    private boolean _stagger = true;
    private boolean _showAxisLine = true;
    private boolean _showLabels = true;
    private boolean _showTicks = true;
    private OMap<String, String> _axisColors = new OMap();
    private OMap<String, Object> _axisTitleStyles = new OMap();
    private double _x = 0.0;
    private double _y = 0.0;
    private ArrayEx<ArrayEx<BulletComponentDataUtilities.RangeStruct>> _processedRangesInfoArray = new ArrayEx();
    private ArrayEx<ArrayEx<BulletComponentDataUtilities.RangeStruct>> _processedMeasuresInfoArray = new ArrayEx();

    @Override
    public String type() {
        return "BulletComponent";
    }

    @Override
    protected void execute(Selector g) {
        this._textFlow = (TextFlow)Rave.capabilities.extension("textflow");
        this._ranges2 = this.bulletRanges2();
        this._markers = this.bulletMarkers();
        this._measures = this.bulletMeasures2();
        this._rightMargin = ObjectConverter.toInt((Object)(this._width * 0.1));
        this._leftMargin = ObjectConverter.toInt((Object)(this._width * 0.3));
        this._width = this._width - (double)this._leftMargin - (double)this._rightMargin;
        this._height = this._height - (double)this._topMargin - (double)this._bottomMargin;
        final BulletComponentImpl self = this;
        FontChecker fontChecker = (FontChecker)Rave.capabilities.extension("fontchecker");
        Rave.transition((Selection)g, (String)"container.transition").attr("transform", (Object)("translate(" + this._x + "," + this._y + ")"));
        Selector bullets = g.selectAll(".bullet-elements").selectAll(".bullet").data(this._data);
        Rave.transition((Selection)bullets.exit(), (String)"bulletExit.transition").attr("opacity", (Object)0).remove();
        Selector bulletsEnter = bullets.enter().append("g").attr("class", (Object)"bullet").attr("transform", (ValueFunction)new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return "translate(" + self._leftMargin + "," + self._dependentScale.lower((Object)index) + ")";
            }
        }).attr("opacity", (Object)0);
        Selector bulletContent = bulletsEnter.append("g").attr("class", (Object)"bulletContent");
        Selector bulletTextContent = bulletContent.append("g").attr("class", (Object)"bulletTextContent").style("text-anchor", (Object)"end").attr("transform", (ValueFunction)new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return "translate(-6," + self._dependentScale.width() * 0.6 / 2.0 + ")";
            }
        });
        Rave.transition((Selection)bullets, (String)"bullets.transition").attr("transform", (ValueFunction)new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return "translate(" + self._leftMargin + "," + self._dependentScale.lower((Object)index) + ")";
            }
        }).attr("width", (Object)(this._width + (double)this._leftMargin + (double)this._rightMargin)).attr("opacity", (Object)1).selectAll(".bulletContent").attr("height", (Object)self._dependentScale.width());
        this.chartBuilder(bullets, bulletContent);
        Selector title = bulletTextContent.append("text").attr("class", (Object)"title");
        Selector subtitle = bulletTextContent.append("text").attr("class", (Object)"subtitle");
        if (ObjectConverter.toBoolean((Object)self._axisTitleStyles.get((Object)"titleVisible"))) {
            title.style("fill", self._axisTitleStyles.get((Object)"titleColor")).style("fontfamily", self._axisTitleStyles.get((Object)"titleFont")).style("fontSize", self._axisTitleStyles.get((Object)"titleFontSize"));
            subtitle.style("fill", self._axisTitleStyles.get((Object)"titleColor")).style("font-family", self._axisTitleStyles.get((Object)"titleFont")).style("font-size", self._axisTitleStyles.get((Object)"titleFontSize"));
            if (bulletTextContent.append("title").size() == 0) {
                g.selectAll(".bulletTextContent").append("text").attr("class", (Object)"title");
            }
            if (bulletTextContent.append("subtitle").size() == 0) {
                g.selectAll(".bulletTextContent").append("text").attr("class", (Object)"subtitle");
            }
            bullets.select((Object)".title").text((ValueFunction)new ValueFunction<Object, Object>(){

                public Object getValue(Object context, Object data, int index, int groupIndex) {
                    return self._titleDataAccessor.getValue(data);
                }
            }).style("fill", self._axisTitleStyles.get((Object)"titleColor")).style("font-family", self._axisTitleStyles.get((Object)"titleFont")).style("font-size", self._axisTitleStyles.get((Object)"titleFontSize")).call((RunFunction)fontChecker, new Object[0]);
            bullets.select((Object)".subtitle").attr("dy", (Object)"1em").text((ValueFunction)new ValueFunction<Object, Object>(){

                public Object getValue(Object context, Object data, int index, int groupIndex) {
                    return self._subtitleDataAccessor.getValue(data);
                }
            }).style("fill", self._axisTitleStyles.get((Object)"titleColor")).style("font-family", self._axisTitleStyles.get((Object)"titleFont")).style("font-size", self._axisTitleStyles.get((Object)"titleFontSize")).call((RunFunction)fontChecker, new Object[0]);
        } else {
            g.selectAll(".title").remove();
            g.selectAll(".subtitle").remove();
        }
        if (self._wrapLabels) {
            this.doLabelWrapping(bullets.select((Object)".bulletContent"));
        }
    }

    private void chartBuilder(Selector bullets, Selector bulletsEnter) {
        final BulletComponentImpl self = this;
        Rave.transition((Selection)bullets.select((Object)".bulletContent"), (String)"bulletContent.transition").each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode context, Object data, int index, int groupIndex) {
                ValueFunction format;
                ArrayEx markerz = ((ArrayEx)self._markers.getValue((Object)context, data, index, groupIndex)).slice().sort(Rave.descending);
                Selector g = Rave.select((SceneNode)context);
                ArrayEx rangez2 = (ArrayEx)self._ranges2.getValue((Object)context, data, index, groupIndex);
                ArrayEx measurez = (ArrayEx)self._measures.getValue((Object)context, data, index, groupIndex);
                Object max = Rave.max((List)new ArrayEx(new Object[]{((BulletComponentDataUtilities.RangeStruct)rangez2.get((int)0)).value, markerz.get(0), ((BulletComponentDataUtilities.RangeStruct)measurez.get((int)0)).value}));
                LinearScale x1 = Rave.scale.linear().domain((List)new ArrayEx(new Object[]{0, max})).range((List)(self.reverse ? new ArrayEx(new Object[]{self._width, 0}) : new ArrayEx(new Object[]{0, self._width})));
                LinearScale x0 = context.getProperty("__chart__") == null ? Rave.scale.linear().domain((List)new ArrayEx(new Object[]{0, Double.POSITIVE_INFINITY})).range((List)x1.range()) : (LinearScale)context.getProperty("__chart__");
                context.setProperty("__chart__", (Object)x1);
                ValueFunction w0 = self.bulletWidth(x0);
                ValueFunction w1 = self.bulletWidth1(x1);
                ValueFunction wr0 = self.bulletRangeWidth(x0);
                ValueFunction wr1 = self.bulletRangeWidth1(x1);
                self._rangeHeight = self._dependentScale.width() * 0.6;
                Selector range = g.selectAll("rect.range").data(rangez2.toArray());
                range.enter().append("rect").attr("width", (Object)0).attr("y", (Object)(self._rangeHeight / 2.0 - 0.5 * self._rangeHeight * (double)self._bulletSize / 100.0)).attr("height", (Object)(self._rangeHeight * (double)self._bulletSize / 100.0)).attr("class", (ValueFunction)new ValueFunction<Object, Object>(){

                    public Object getValue(Object context, Object data, int index, int groupIndex) {
                        return "range s" + index;
                    }
                }).style("stroke", self.rangeShapeColor()).style("fill", self.rangeShapeColor());
                Rave.transition((Selection)range.exit(), (String)"rangeExit.transition").attr("width", wr0).attr("y", (Object)(self._rangeHeight / 2.0 * (double)(1 - self._bulletSize / 100))).attr("height", (Object)(self._rangeHeight * (double)self._bulletSize / 100.0)).attr("x", self.reverse ? x0 : Integer.valueOf(0)).remove();
                Rave.transition((Selection)range, (String)"range.transition").attr("x", self.reverse ? x1 : Integer.valueOf(0)).attr("width", wr1).attr("y", (Object)(self._rangeHeight / 2.0 - 0.5 * self._rangeHeight * (double)self._bulletSize / 100.0)).attr("height", (Object)(self._rangeHeight * (double)self._bulletSize / 100.0)).style("fill", self.rangeShapeColor()).style("stroke", self.rangeShapeColor());
                Selector measure = g.selectAll("rect.measure").data(measurez.toArray());
                measure.enter().append("rect").attr("width", (Object)0).attr("class", (ValueFunction)new ValueFunction<Object, Object>(){

                    public Object getValue(Object context, Object data, int index, int groupIndex) {
                        return "measure s" + index;
                    }
                }).style("stroke", self.rangeShapeColor()).style("fill", self.rangeShapeColor());
                Double height = self._rangeHeight * (double)self._categoryHeight / 100.0 * (double)self._bulletSize / 100.0;
                Double y = self._rangeHeight / 2.0 - 0.5 * (self._rangeHeight * (double)self._categoryHeight / 100.0) * (double)self._bulletSize / 100.0;
                Rave.transition((Selection)measure.exit(), (String)"measureExit.transition").attr("width", w0).attr("height", (Object)height).attr("x", self.reverse ? x0 : Integer.valueOf(0)).attr("y", (Object)y).remove();
                Transition measureUpdate = (Transition)Rave.transition((Selection)measure, (String)"measure.transition").attr("width", w1).attr("height", (Object)height).attr("x", self.reverse ? x1 : Integer.valueOf(0)).attr("y", (Object)y).style("fill", self.rangeShapeColor()).style("stroke", self.rangeShapeColor());
                if (self._stagger && self._transition) {
                    measureUpdate.delay((Object)((double)self._duration * 0.5));
                }
                Selector marker = g.selectAll("line.Marker").data(markerz.toArray());
                marker.enter().append("line").attr("x1", (Object)0).attr("x2", (Object)0).attr("class", (Object)"Marker").style("stroke", self.shapeColor()).style("stroke-width", (Object)"4px");
                Double y1 = self._rangeHeight / 2.0 - 0.5 * (self._rangeHeight * (double)self._bulletMarkerSize / 100.0) * (double)self._bulletSize / 100.0;
                Double y2 = self._rangeHeight / 2.0 + 0.5 * (self._rangeHeight * (double)self._bulletMarkerSize / 100.0) * (double)self._bulletSize / 100.0;
                Rave.transition((Selection)marker.exit(), (String)"markerExit.transition").attr("x1", (ValueFunction)x0).attr("x2", (ValueFunction)x0).attr("y1", (Object)y1).attr("y2", (Object)y2).remove();
                Transition markerUpdate = (Transition)Rave.transition((Selection)marker, (String)"marker.transition").attr("x1", (ValueFunction)x1).attr("x2", (ValueFunction)x1).attr("y1", (Object)y1).attr("y2", (Object)y2).style("stroke", self.shapeColor());
                if (self._stagger && self._transition) {
                    markerUpdate.delay((Object)self._duration);
                }
                Selector axisLine = g.selectAll(".axisLine").data((List)g.data());
                if (self._showAxisLine) {
                    axisLine.enter().append("line").attr("x1", (Object)0).attr("x2", (Object)0).attr("y1", (Object)self._rangeHeight).attr("y2", (Object)self._rangeHeight).attr("class", (Object)"axisLine").style("stroke", self._axisColors.get((Object)"axisLineColor"));
                    Rave.transition((Selection)axisLine, (String)"axisLine.transition").attr("x1", (Object)0).attr("x2", (Object)self._width).attr("y1", (Object)self._rangeHeight).attr("y2", (Object)self._rangeHeight).style("stroke", self._axisColors.get((Object)"axisLineColor"));
                } else {
                    g.selectAll(".axisLine").remove();
                }
                Rave.transition((Selection)axisLine.exit(), (String)"axisLineExit.transition").attr("x1", (Object)0).attr("x2", (Object)0).attr("y1", (Object)self._rangeHeight).attr("y2", (Object)self._rangeHeight).style("opacity", (Object)0).remove();
                ValueFunction valueFunction = format = self._tickFormat == null ? x1.tickFormat.getValue(new Object[]{8}) : self._tickFormat;
                if (self._showTicks || self._showLabels) {
                    Selector tick = g.selectAll("g.tick").data(x1.ticks.getValue(new Object[]{8}).toArray(), (ValueFunction)new ValueFunction<Object, Object>(){

                        public Object getValue(Object context, Object data, int index, int groupIndex) {
                            return format.getValue(context, data, index, groupIndex);
                        }
                    });
                    Selector tickEnter = tick.enter().append("g").attr("class", (Object)"tick").attr("transform", self.bulletTranslate(x0)).style("opacity", (Object)1.0E-6);
                    Transition tickUpdate = (Transition)Rave.transition((Selection)tick, (String)"tick.transition").attr("transform", self.bulletTranslate(x1)).style("opacity", (Object)1);
                    if (self._showTicks) {
                        tickEnter.append("line").attr("class", (Object)"tickLine");
                        if (tick.selectAll(".tickLine").size() == 0) {
                            tick.append("line").attr("class", (Object)"tickLine");
                        }
                        tickUpdate.select((Object)".tickLine").attr("y1", (Object)self._rangeHeight).attr("y2", (Object)(self._rangeHeight * 7.0 / 6.0)).style("stroke", self._axisColors.get((Object)"axisLineColor"));
                    } else {
                        tick.selectAll(".tickLine").remove();
                    }
                    if (self._showLabels) {
                        tickEnter.append("text").attr("class", (Object)"tickText");
                        if (tick.selectAll(".tickText").size() == 0) {
                            tick.append("text").attr("class", (Object)"tickText");
                        }
                        tickUpdate.select((Object)".tickText").attr("text-anchor", (Object)"middle").attr("dy", (Object)"1em").attr("y", (Object)(self._rangeHeight * 7.0 / 6.0)).text(format).style("fill", self._axisColors.get((Object)"labelColor"));
                    } else {
                        tick.selectAll(".tickText").remove();
                    }
                    Rave.transition((Selection)tick.exit(), (String)"tickExit.transition").style("opacity", (Object)1.0E-6).attr("transform", self.bulletTranslate(x1)).remove();
                } else {
                    Rave.selectAll((String)".tick").remove();
                }
            }
        });
    }

    private static String formatOf(String orient) {
        if ("left".equals(orient)) {
            return "left";
        }
        if ("top".equals(orient)) {
            return "top";
        }
        if ("bottom".equals(orient)) {
            return "bottom";
        }
        return "right";
    }

    private void doLabelWrapping(Selector g) {
        this._textFlow.dropTextOnFail(true);
        this._textFlow.wrap(true).truncate(true).textTruncateIndicator("...").extent(this._leftMargin, ObjectConverter.toInt((Object)(this._dependentScale.width() * 0.6 / 2.0))).spacing(1.2);
        g.selectAll(".title").call((RunFunction)this._textFlow, new Object[0]);
        g.selectAll(".subtitle").call((RunFunction)this._textFlow, new Object[0]);
        this._textFlow.extent(40, ObjectConverter.toInt((Object)(this._dependentScale.width() * 0.4 - 1.0)));
    }

    private final ValueFunction<Object, Object> rangeShapeColor() {
        final BulletComponentImpl self = this;
        final boolean usePrimary = this._colorPalette == null;
        return new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object d, int index, int groupIndex) {
                if (usePrimary) {
                    return self._primaryColor;
                }
                return self._colorPalette.getValue((SceneNode)context, (Object)((BulletComponentDataUtilities.RangeStruct)d).label, index, index);
            }
        };
    }

    private final ValueFunction<Object, Object> shapeColor() {
        final BulletComponentImpl self = this;
        final boolean usePrimary = this._colorPalette == null;
        return new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object d, int index, int groupIndex) {
                if (usePrimary) {
                    return self._primaryColor;
                }
                return self._colorPalette.getValue((SceneNode)context, (Object)((String)((SceneNode)context).getAttribute("class")), index, groupIndex);
            }
        };
    }

    private ValueFunction<Object, Double> bulletRangeWidth(LinearScale x) {
        final Double x0 = ObjectConverter.toDouble((Object)x.getValue(null, (Object)0, 0, 0));
        final LinearScale internalX = x;
        return new ValueFunction<Object, Double>(){

            public Double getValue(Object context, Object data, int index, int groupIndex) {
                return Math.abs(ObjectConverter.toDouble((Object)internalX.getValue(context, (Object)((BulletComponentDataUtilities.RangeStruct)data).value, index, groupIndex)) - x0);
            }
        };
    }

    private ValueFunction<Object, Double> bulletRangeWidth1(LinearScale x) {
        final Double x0 = ObjectConverter.toDouble((Object)x.getValue(null, (Object)0, 0, 0));
        final LinearScale internalX = x;
        return new ValueFunction<Object, Double>(){

            public Double getValue(Object context, Object data, int index, int groupIndex) {
                return Math.abs(ObjectConverter.toDouble((Object)internalX.getValue(context, (Object)((BulletComponentDataUtilities.RangeStruct)data).value, index, groupIndex)) - x0);
            }
        };
    }

    private ValueFunction<Object, Double> bulletWidth(LinearScale x) {
        final Double x0 = ObjectConverter.toDouble((Object)x.getValue(null, (Object)0, 0, 0));
        final LinearScale internalX = x;
        return new ValueFunction<Object, Double>(){

            public Double getValue(Object context, Object data, int index, int groupIndex) {
                return Math.abs(ObjectConverter.toDouble((Object)internalX.getValue(context, (Object)((BulletComponentDataUtilities.RangeStruct)data).value, index, groupIndex)) - x0);
            }
        };
    }

    private ValueFunction<Object, Double> bulletWidth1(LinearScale x) {
        final Double x0 = ObjectConverter.toDouble((Object)x.getValue(null, (Object)0, 0, 0));
        final LinearScale internalX = x;
        return new ValueFunction<Object, Double>(){

            public Double getValue(Object context, Object data, int index, int groupIndex) {
                return Math.abs(ObjectConverter.toDouble((Object)internalX.getValue(context, (Object)((BulletComponentDataUtilities.RangeStruct)data).value, index, groupIndex)) - x0);
            }
        };
    }

    private final ValueFunction<SceneNode, ArrayEx<BulletComponentDataUtilities.RangeStruct>> bulletRanges2() {
        final BulletComponentImpl self = this;
        return new ValueFunction<SceneNode, ArrayEx<BulletComponentDataUtilities.RangeStruct>>(){

            public ArrayEx<BulletComponentDataUtilities.RangeStruct> getValue(SceneNode context, Object data, int index, int groupIndex) {
                int lastRangeArrayIndex = self._processedRangesInfoArray.size() - 1;
                return index > lastRangeArrayIndex ? (ArrayEx)self._processedRangesInfoArray.get(lastRangeArrayIndex) : (ArrayEx)self._processedRangesInfoArray.get(index);
            }
        };
    }

    private final ValueFunction<SceneNode, ArrayEx<BulletComponentDataUtilities.RangeStruct>> bulletMeasures2() {
        final BulletComponentImpl self = this;
        return new ValueFunction<SceneNode, ArrayEx<BulletComponentDataUtilities.RangeStruct>>(){

            public ArrayEx<BulletComponentDataUtilities.RangeStruct> getValue(SceneNode context, Object data, int index, int groupIndex) {
                int lastMeasureArrayIndex = self._processedMeasuresInfoArray.size() - 1;
                return index > lastMeasureArrayIndex ? (ArrayEx)self._processedMeasuresInfoArray.get(lastMeasureArrayIndex) : (ArrayEx)self._processedMeasuresInfoArray.get(index);
            }
        };
    }

    private final ValueFunction<SceneNode, ArrayEx<Object>> bulletMarkers() {
        final BulletComponentImpl self = this;
        return new ValueFunction<SceneNode, ArrayEx<Object>>(){

            public ArrayEx<Object> getValue(SceneNode context, Object data, int index, int groupIndex) {
                ArrayEx marker = new ArrayEx();
                return ((ArrayEx)self._markersDataAccessor.getValue(data)).filter((ArrayEx.ArrayValueFunction)new ArrayEx.ArrayValueFunction<Object, Boolean>(){

                    public Boolean getValue(Object currentValue, int index, ArrayEx<Object> array) {
                        return currentValue != null;
                    }
                });
            }
        };
    }

    private final ValueFunction<SceneNode, ArrayEx<Object>> bulletMeasures() {
        final BulletComponentImpl self = this;
        return new ValueFunction<SceneNode, ArrayEx<Object>>(){

            public ArrayEx<Object> getValue(SceneNode context, Object data, int index, int groupIndex) {
                return (ArrayEx)self._measuresDataAccessor.getValue(data);
            }
        };
    }

    private Object bulletTranslate(LinearScale x) {
        final LinearScale internalX = x;
        return new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return "translate(" + internalX.getValue(context, data, index, groupIndex) + ",0)";
            }
        };
    }

    public BulletComponentImpl data(Object[] data) {
        this._data = data;
        return this;
    }

    public BulletComponentImpl width(double w) {
        this._width = w;
        return this;
    }

    public BulletComponentImpl transition(boolean transition) {
        this._transition = transition;
        return this;
    }

    public BulletComponentImpl duration(int dur) {
        this._duration = dur;
        return this;
    }

    public BulletComponentImpl categoryHeight(int catHeight) {
        this._categoryHeight = catHeight;
        return this;
    }

    public BulletComponentImpl bulletSize(int bulletSize) {
        this._bulletSize = bulletSize;
        return this;
    }

    public BulletComponentImpl bulletMarkerSize(int bulletMarkerSize) {
        this._bulletMarkerSize = bulletMarkerSize;
        return this;
    }

    public BulletComponentImpl stagger(boolean stagger) {
        this._stagger = stagger;
        return this;
    }

    public BulletComponentImpl wrapAxisLabels(boolean wrap) {
        this._wrapLabels = wrap;
        return this;
    }

    public BulletComponentImpl axisColors(OMap<String, String> axisColors) {
        this._axisColors = axisColors;
        return this;
    }

    public BulletComponentImpl axisTitleStyles(OMap<String, Object> axisTitleStyles) {
        this._axisTitleStyles = axisTitleStyles;
        return this;
    }

    public BulletComponentImpl showAxisLine(boolean showLine) {
        this._showAxisLine = showLine;
        return this;
    }

    public BulletComponentImpl showTicks(boolean showTick) {
        this._showTicks = showTick;
        return this;
    }

    public BulletComponentImpl showLabel(boolean showLabel) {
        this._showLabels = showLabel;
        return this;
    }

    public BulletComponentImpl height(double h) {
        this._height = h;
        return this;
    }

    public BulletComponentImpl x(double x) {
        this._x = x;
        return this;
    }

    public BulletComponentImpl y(double y) {
        this._y = y;
        return this;
    }

    public BulletComponentImpl titleDataAccessor(SingleValueFunction<Object, Object> titleDataAccessor) {
        this._titleDataAccessor = titleDataAccessor;
        return this;
    }

    public BulletComponentImpl subtitleDataAccessor(SingleValueFunction<Object, Object> subtitleDataAccessor) {
        this._subtitleDataAccessor = subtitleDataAccessor;
        return this;
    }

    public BulletComponentImpl rangesDataAccessor(SingleValueFunction<Object, Object> rangesDataAccessor) {
        this._rangesDataAccessor = rangesDataAccessor;
        return this;
    }

    public BulletComponentImpl markersDataAccessor(SingleValueFunction<Object, Object> markersDataAccessor) {
        this._markersDataAccessor = markersDataAccessor;
        return this;
    }

    public BulletComponentImpl measuresDataAccessor(SingleValueFunction<Object, Object> measuresDataAccessor) {
        this._measuresDataAccessor = measuresDataAccessor;
        return this;
    }

    public BulletComponentImpl dependentScale(CoordinateScaleImpl dependentScale, boolean nice) {
        this._dependentScale = dependentScale;
        if (nice) {
            this._dependentScale.nice();
        }
        return this;
    }

    public BulletComponentImpl colorPalette(Palette colorPalette) {
        this._colorPalette = colorPalette;
        return this;
    }

    public BulletComponentImpl rangesInfo(ArrayEx<ArrayEx<BulletComponentDataUtilities.RangeStruct>> processedRangesInfoArray) {
        this._processedRangesInfoArray = processedRangesInfoArray;
        return this;
    }

    public BulletComponentImpl measuresInfo(ArrayEx<ArrayEx<BulletComponentDataUtilities.RangeStruct>> processedMeasuresInfoArray) {
        this._processedMeasuresInfoArray = processedMeasuresInfoArray;
        return this;
    }
}

