/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.components;

import com.ibm.rave.bundles.component.ChartLayoutComponent;
import com.ibm.rave.bundles.component.ChartLayoutSizable;
import com.ibm.rave.bundles.components.BundleComponentImpl;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.library.framework.internal.CSSConverter;

public class ChartLayoutComponentImpl
extends BundleComponentImpl<ChartLayoutComponentImpl>
implements ChartLayoutComponent {
    public static final double MAX_AXIS_PERCENT = 0.4;
    public static final double MAX_AXIS_PERCENT_SINGLE_PER_ORIENTATION = 0.5;
    public static final double MAX_LEGEND_PERCENT = 0.3;
    public static final double MAX_LEGEND_PERCENT_NO_AXIS = 0.5;
    private Object _padding = 0.0;
    private double _leftPadding = 0.0;
    private double _topPadding = 0.0;
    private double _rightPadding = 0.0;
    private double _bottomPadding = 0.0;
    private Object _legendChartGap = 0.0;
    private Object _topChartPadding = 0.0;
    private Object _leftChartPadding = 0.0;
    private Object _bottomChartPadding = 0.0;
    private Object _rightChartPadding = 0.0;
    private String _legendPosition = "right";
    private ChartLayoutSizable _legendSizable;
    private ArrayEx<ChartLayoutSizable> _axisSizables = new ArrayEx();
    private final RectStruct _overallRect = new RectStruct(0.0, 0.0, 0.0, 0.0);
    private final RectStruct _legendRect = new RectStruct(0.0, 0.0, 0.0, 0.0);
    private final RectStruct _chartRect = new RectStruct(0.0, 0.0, 0.0, 0.0);
    private final RectStruct _topRect = new RectStruct(0.0, 0.0, 0.0, 0.0);
    private final RectStruct _leftRect = new RectStruct(0.0, 0.0, 0.0, 0.0);
    private final RectStruct _bottomRect = new RectStruct(0.0, 0.0, 0.0, 0.0);
    private final RectStruct _rightRect = new RectStruct(0.0, 0.0, 0.0, 0.0);
    private final RectStruct _elementRect = new RectStruct(0.0, 0.0, 0.0, 0.0);
    private boolean _legendChartAlign = true;
    private boolean _preLegendAtMax = false;
    private boolean _preAxesAtZero = false;

    @Override
    protected void execute(Selector g) {
        this.layout();
    }

    public void preLayout(boolean legendAtMax, boolean axesAtZero) {
        this._preLegendAtMax = legendAtMax;
        this._preAxesAtZero = axesAtZero;
        this.layout();
        this._preLegendAtMax = false;
        this._preAxesAtZero = false;
    }

    public void layout() {
        double chartRight;
        double chartBottom;
        double chartLeft;
        double chartTop;
        double legendDynamicSize;
        this.preExecute();
        ChartLayoutComponentImpl.copyRect(this._chartRect, this._overallRect);
        ChartLayoutComponentImpl.copyRect(this._legendRect, this._overallRect);
        double x = this._overallRect.x;
        double y = this._overallRect.y;
        double w = this._overallRect.width;
        double h = this._overallRect.height;
        double maxWH = Math.max(w, h);
        boolean tbLegend = "top".equals(this._legendPosition) || "bottom".equals(this._legendPosition);
        double legendPercent = this._axisSizables.size() == 0 ? 0.5 : 0.3;
        double legendMaxSize = (tbLegend ? this._legendRect.height : this._legendRect.width) * legendPercent;
        double d = this._legendSizable != null ? (this._preLegendAtMax ? maxWH : this._legendSizable.getPreferredSize()) : (legendDynamicSize = 0.0);
        if (legendDynamicSize > legendMaxSize) {
            legendDynamicSize = legendMaxSize;
        }
        boolean isLegendTop = false;
        boolean isLegendBottom = false;
        boolean isLegendLeft = false;
        boolean isLegendRight = false;
        if ("top".equals(this._legendPosition)) {
            this._legendRect.height = legendDynamicSize;
            this._chartRect.height -= this._legendRect.height;
            this._chartRect.y += this._legendRect.height;
            isLegendTop = true;
        } else if ("bottom".equals(this._legendPosition)) {
            this._legendRect.height = legendDynamicSize;
            this._chartRect.height -= this._legendRect.height;
            this._legendRect.y = y + h - this._legendRect.height;
            isLegendBottom = true;
        } else if ("left".equals(this._legendPosition)) {
            this._legendRect.width = legendDynamicSize;
            this._chartRect.width -= this._legendRect.width;
            this._chartRect.x += this._legendRect.width;
            isLegendLeft = true;
        } else {
            this._legendRect.width = legendDynamicSize;
            this._chartRect.width -= this._legendRect.width;
            this._legendRect.x = x + w - this._legendRect.width;
            isLegendRight = true;
        }
        if (this.evaluatePadding(this._padding, w, h)) {
            double lrgap = ChartLayoutComponentImpl.evaluateSize(this._legendChartGap, w);
            double tbgap = ChartLayoutComponentImpl.evaluateSize(this._legendChartGap, h);
            chartTop = isLegendTop && this._legendSizable != null ? tbgap : this._topPadding;
            chartLeft = isLegendLeft && this._legendSizable != null ? lrgap : this._leftPadding;
            chartBottom = isLegendBottom && this._legendSizable != null ? tbgap : this._bottomPadding;
            chartRight = isLegendRight && this._legendSizable != null ? lrgap : this._rightPadding;
            ChartLayoutComponentImpl.inset(this._chartRect, chartTop, chartLeft, chartBottom, chartRight);
        } else {
            double lrpadding = ChartLayoutComponentImpl.evaluateSize(this._padding, w);
            double tbpadding = ChartLayoutComponentImpl.evaluateSize(this._padding, h);
            chartTop = tbpadding + ChartLayoutComponentImpl.evaluateSize(this._topChartPadding, h);
            chartLeft = lrpadding + ChartLayoutComponentImpl.evaluateSize(this._leftChartPadding, w);
            chartBottom = tbpadding + ChartLayoutComponentImpl.evaluateSize(this._bottomChartPadding, h);
            chartRight = lrpadding + ChartLayoutComponentImpl.evaluateSize(this._rightChartPadding, w);
            ChartLayoutComponentImpl.inset(this._chartRect, chartTop, chartLeft, chartBottom, chartRight);
            this._topPadding = tbpadding;
            this._leftPadding = lrpadding;
            this._bottomPadding = tbpadding;
            this._rightPadding = lrpadding;
        }
        if (this._legendSizable != null) {
            if (isLegendRight) {
                this._legendRect.x -= this._rightPadding;
                this._chartRect.width -= this._rightPadding;
                this._legendRect.y += this._topPadding;
                this._legendRect.height -= this._topPadding + this._bottomPadding;
            } else if (isLegendLeft) {
                this._legendRect.x += this._leftPadding;
                this._chartRect.x += this._leftPadding;
                this._chartRect.width -= this._leftPadding;
                this._legendRect.y += this._topPadding;
                this._legendRect.height -= this._topPadding + this._bottomPadding;
            } else if (isLegendTop) {
                this._legendRect.y += this._topPadding;
                this._chartRect.y += this._topPadding;
                this._chartRect.height -= this._topPadding;
                this._legendRect.x += this._leftPadding;
                this._legendRect.width -= this._leftPadding + this._rightPadding;
            } else {
                this._legendRect.y -= this._bottomPadding;
                this._chartRect.height -= this._bottomPadding;
                this._legendRect.x += this._leftPadding;
                this._legendRect.width -= this._leftPadding + this._rightPadding;
            }
        }
        x = this._chartRect.x;
        y = this._chartRect.y;
        w = this._chartRect.width;
        h = this._chartRect.height;
        double bottomH = 0.0;
        double topH = 0.0;
        double leftW = 0.0;
        double rightW = 0.0;
        double tbSO = 0.0;
        double lrSO = 0.0;
        if (!this._preAxesAtZero) {
            String orientation;
            ChartLayoutSizable sizable;
            int i;
            int countHorz = 0;
            int countVert = 0;
            for (i = 0; i < this._axisSizables.size(); ++i) {
                sizable = (ChartLayoutSizable)this._axisSizables.get(i);
                if (sizable == null) continue;
                orientation = sizable.getSizableOrientation();
                if ("top".equals(orientation) || "bottom".equals(orientation)) {
                    ++countHorz;
                    continue;
                }
                ++countVert;
            }
            for (i = 0; i < this._axisSizables.size(); ++i) {
                double axisPercent;
                sizable = (ChartLayoutSizable)this._axisSizables.get(i);
                if (sizable == null) continue;
                orientation = sizable.getSizableOrientation();
                boolean tbAxis = "top".equals(orientation) || "bottom".equals(orientation);
                double axisDynamicSize = sizable.getPreferredSize();
                double spillOver = sizable.getSpillOverSize();
                if (tbAxis) {
                    double d2 = axisPercent = countHorz > 1 ? 0.4 : 0.5;
                    if (axisDynamicSize > this._chartRect.height * axisPercent) {
                        axisDynamicSize = this._chartRect.height * axisPercent;
                    }
                    if ("top".equals(orientation)) {
                        topH = axisDynamicSize;
                    } else {
                        bottomH = axisDynamicSize;
                    }
                    if (!(spillOver > lrSO)) continue;
                    lrSO = spillOver;
                    continue;
                }
                double d3 = axisPercent = countVert > 1 ? 0.4 : 0.5;
                if (axisDynamicSize > this._chartRect.width * axisPercent) {
                    axisDynamicSize = this._chartRect.width * axisPercent;
                }
                if ("left".equals(orientation)) {
                    leftW = axisDynamicSize;
                } else {
                    rightW = axisDynamicSize;
                }
                if (!(spillOver > tbSO)) continue;
                tbSO = spillOver;
            }
        }
        if (lrSO > leftW) {
            leftW = lrSO;
        }
        if (lrSO > rightW) {
            rightW = lrSO;
        }
        if (tbSO > topH) {
            topH = tbSO;
        }
        if (tbSO > bottomH) {
            bottomH = tbSO;
        }
        this._leftRect.x = x;
        this._leftRect.width = leftW;
        this._leftRect.y = y;
        this._leftRect.height = h;
        this._rightRect.x = x + w - rightW;
        this._rightRect.width = rightW;
        this._rightRect.y = y;
        this._rightRect.height = h;
        this._topRect.y = y;
        this._topRect.height = topH;
        this._topRect.x = x;
        this._topRect.width = w;
        this._bottomRect.y = y + h - bottomH;
        this._bottomRect.height = bottomH;
        this._bottomRect.x = x;
        this._bottomRect.width = w;
        this._elementRect.x = x + leftW;
        this._elementRect.y = y + topH;
        this._elementRect.width = w - (leftW + rightW);
        this._elementRect.height = h - (topH + bottomH);
        if (this._legendSizable != null && this._legendChartAlign) {
            if (tbLegend) {
                this._legendRect.x = this._elementRect.x;
                this._legendRect.width = this._elementRect.width;
            } else {
                this._legendRect.y = this._elementRect.y;
                this._legendRect.height = this._elementRect.height;
            }
        }
    }

    private boolean evaluatePadding(Object padding, double horizontalExtent, double verticalExtent) {
        String[] items;
        if (padding == null) {
            return false;
        }
        String paddingString = ObjectConverter.asString((Object)padding) + "";
        if (paddingString.length() == 0) {
            return false;
        }
        this._topPadding = 0.0;
        this._leftPadding = 0.0;
        this._bottomPadding = 0.0;
        this._rightPadding = 0.0;
        for (String item : items = paddingString.split(";")) {
            String[] parts = item.split(":");
            if (items.length == 1 && parts.length != 2) {
                return false;
            }
            if (parts.length != 2) continue;
            if (parts[0].contains("top")) {
                this._topPadding = ChartLayoutComponentImpl.evaluateSize(parts[1], verticalExtent);
                continue;
            }
            if (parts[0].contains("left")) {
                this._leftPadding = ChartLayoutComponentImpl.evaluateSize(parts[1], horizontalExtent);
                continue;
            }
            if (parts[0].contains("bottom")) {
                this._bottomPadding = ChartLayoutComponentImpl.evaluateSize(parts[1], verticalExtent);
                continue;
            }
            if (!parts[0].contains("right")) continue;
            this._rightPadding = ChartLayoutComponentImpl.evaluateSize(parts[1], horizontalExtent);
        }
        return true;
    }

    public RectStruct legendRect() {
        return this._legendRect;
    }

    public RectStruct chartRect() {
        return this._chartRect;
    }

    public RectStruct topRect() {
        return this._topRect;
    }

    public RectStruct leftRect() {
        return this._leftRect;
    }

    public RectStruct bottomRect() {
        return this._bottomRect;
    }

    public RectStruct rightRect() {
        return this._rightRect;
    }

    public RectStruct elementRect() {
        return this._elementRect;
    }

    public final ChartLayoutComponentImpl overall(RectStruct overall) {
        ChartLayoutComponentImpl.copyRect(this._overallRect, overall);
        return this;
    }

    @Override
    public Object padding() {
        return this._padding;
    }

    @Override
    public final boolean legendChartAlign() {
        return this._legendChartAlign;
    }

    @Override
    public final Object legendChartGap() {
        return this._legendChartGap;
    }

    @Override
    public Object topPadding() {
        return this._topChartPadding;
    }

    @Override
    public Object leftPadding() {
        return this._leftChartPadding;
    }

    @Override
    public Object bottomPadding() {
        return this._bottomChartPadding;
    }

    @Override
    public Object rightPadding() {
        return this._rightChartPadding;
    }

    @Override
    public String legendPosition() {
        return this._legendPosition;
    }

    @Override
    public ChartLayoutComponent topPadding(Object padding) {
        this._topChartPadding = padding;
        return this;
    }

    @Override
    public ChartLayoutComponent leftPadding(Object padding) {
        this._leftChartPadding = padding;
        return this;
    }

    @Override
    public ChartLayoutComponent bottomPadding(Object padding) {
        this._bottomChartPadding = padding;
        return this;
    }

    @Override
    public ChartLayoutComponent rightPadding(Object padding) {
        this._rightChartPadding = padding;
        return this;
    }

    @Override
    public String type() {
        return "ChartLayoutComponent";
    }

    @Override
    public ChartLayoutComponent padding(Object value) {
        this._padding = value;
        return this;
    }

    @Override
    public ChartLayoutComponent chartPadding(Object top, Object left, Object bottom, Object right) {
        this._topChartPadding = top;
        this._leftChartPadding = left;
        this._bottomChartPadding = bottom;
        this._rightChartPadding = right;
        return this;
    }

    @Override
    public final ChartLayoutComponent legendChartAlign(boolean legendChartAlign) {
        this._legendChartAlign = legendChartAlign;
        return this;
    }

    @Override
    public final ChartLayoutComponent legendChartGap(Object value) {
        this._legendChartGap = value;
        return this;
    }

    @Override
    public ChartLayoutComponent legendPosition(String position) {
        if ("top".equals(position) || "bottom".equals(position) || "left".equals(position) || "right".equals(position)) {
            this._legendPosition = position;
        }
        return this;
    }

    @Override
    public ChartLayoutComponent legendSize(ChartLayoutSizable sizable) {
        this._legendSizable = sizable;
        return this;
    }

    @Override
    public ChartLayoutComponent removeAxisSizables() {
        this._axisSizables.clear();
        return this;
    }

    @Override
    public ChartLayoutComponent addAxisSizable(ChartLayoutSizable sizable) {
        this._axisSizables.add((Object)sizable);
        return this;
    }

    static final RectStruct copyRect(RectStruct t, RectStruct s) {
        t.x = s.x;
        t.y = s.y;
        t.width = s.width;
        t.height = s.height;
        return t;
    }

    static final RectStruct inset(RectStruct r, double top, double left, double bottom, double right) {
        double ibottom;
        double itop;
        double iright;
        double ileft = Math.max(0.0, left);
        if (ileft + (iright = Math.max(0.0, right)) <= r.width) {
            r.x += ileft;
            r.width -= ileft + iright;
        }
        if ((itop = Math.max(0.0, top)) + (ibottom = Math.max(0.0, bottom)) <= r.height) {
            r.y += itop;
            r.height -= itop + ibottom;
        }
        return r;
    }

    static final double evaluateSize(Object value, double extent) {
        Double v = CSSConverter.convertCSSSizeToPixelNumber((Object)value, (double)extent, (double)10.0);
        double d = v != null ? v : 0.0;
        return Math.max(0.0, Math.min(d, extent));
    }
}

