/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.components;

import com.ibm.rave.bundles.components.KeyedBundleComponentImpl;
import com.ibm.rave.bundles.utilities.FontPropertyParser;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.graphicUtils.Canvas;
import com.ibm.rave.core.graphicUtils.TextMetrics;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.internal.css.CSSUtil;
import com.ibm.rave.core.layout.chord.ChordData;
import com.ibm.rave.core.layout.chord.ChordLayout;
import com.ibm.rave.core.layout.chord.GroupData;
import com.ibm.rave.core.layout.chord.GroupDataStruct;
import com.ibm.rave.core.layout.chord.MatrixDataStruct;
import com.ibm.rave.core.nativeImpl.graphicUtils.RenderingContext;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.svg.Arc;
import com.ibm.rave.core.transition.Transition;
import com.ibm.rave.library.bundleData.ChordBundleChordDatum;
import com.ibm.rave.library.datamodel.DataSet;
import com.ibm.rave.library.palette.Palette;
import java.util.ArrayList;
import java.util.List;

public class ChordComponentImpl
extends KeyedBundleComponentImpl<ChordComponentImpl> {
    private Object[] _chordData = null;
    private Object[] _groupData = null;
    private SingleValueFunction<Object, Object> _groupColorAccessor = null;
    private SingleValueFunction<Object, Object> _groupLabelAccessor = null;
    private SingleValueFunction<Object, Object> _sourceIdAccessor = null;
    private SingleValueFunction<Object, Object> _targetIdAccessor = null;
    private SingleValueFunction<Object, Object> _sourceValueAccessor = null;
    private SingleValueFunction<Object, Object> _targetValueAccessor = null;
    private SingleValueFunction<Object, Object> _chordColorAccessor = null;
    private double _width = 0.0;
    private double _height = 0.0;
    private double _padding = 0.0;
    private double _x = 0.0;
    private double _y = 0.0;
    private int n = 0;
    private int m = 0;
    private List<ChordItem> _sourceItems = new ArrayList<ChordItem>();
    private List<Object> _sources = new ArrayList<Object>();
    private List<ChordItem> _targetItems = new ArrayList<ChordItem>();
    private List<Object> _targets = new ArrayList<Object>();
    private boolean displayTickLines = true;
    private boolean displayTickText = true;
    private Palette _chordsColorPalette;
    private Palette _groupsColorPalette;
    private Double _tickStepAdjuster = 1000.0;
    private Double _tickTextFrequencyAdjuster = 5.0;
    private String _tickSuffixModifier = "";
    private Double _tickValueDivider = 1.0;
    private OMap<String, Object> _tickFontStyle = new OMap();
    private OMap<String, Object> _labelFontStyle = new OMap();
    private ChordLayout chord = Rave.layout.chord();
    private Arc _arc = Rave.svg.arc();
    private boolean chordsShinkingResizeFlag = false;
    private boolean groupsShinkingResizeFlag = false;
    protected boolean ticksShinkingResizeFlag;
    private DataSet _groupDataSet = null;
    private double innerRadius = 0.0;
    private double outerRadius = 0.0;
    private OMap<String, Object> _chordsOriginalStyle = new OMap();
    private OMap<String, Object> _groupsOriginalStyle = new OMap();
    private double maxDataPoint = 0.0;
    private static final int XOFFSET_VALUE = 6;

    public static ChordComponentImpl create() {
        return new ChordComponentImpl();
    }

    @Override
    public String type() {
        return "ChordComponent";
    }

    @Override
    protected void execute(Selector g) {
        if (this._chordData == null || this._sourceIdAccessor == null || this._targetIdAccessor == null || this._sourceValueAccessor == null || this._targetValueAccessor == null) {
            g.selectAll("*").remove();
            return;
        }
        this._sourceItems = new ArrayList<ChordItem>();
        this._sources = new ArrayList<Object>();
        this._targetItems = new ArrayList<ChordItem>();
        this._targets = new ArrayList<Object>();
        this.n = 0;
        this.m = 0;
        ValueFunction<SceneNode, Object> _groupShapeColor = this.groupShapeColor();
        ValueFunction<Object, Object> _chordShapeColor = this.chordShapeColor();
        for (Object d : this._chordData) {
            this.sources(d);
            this.targets(d);
        }
        ArrayEx matrix = new ArrayEx();
        for (int i = 0; i < this.n; ++i) {
            ArrayEx temp = new ArrayEx();
            for (int j = 0; j < this.n; ++j) {
                temp.set(j, (Object)0);
            }
            matrix.add(temp);
        }
        Object sourceLabel = null;
        Object sourceColor = null;
        Object sourceGroupOrigialData = null;
        Object targetLabel = null;
        Object targetColor = null;
        Object targetGroupOriginalData = null;
        for (Object d : this._chordData) {
            sourceLabel = null;
            sourceColor = null;
            targetLabel = null;
            targetColor = null;
            if (this._groupData != null) {
                for (Object groupDatum : this._groupData) {
                    if (ObjectConverter.asString((Object)this._groupLabelAccessor.getValue(groupDatum)).equals(this._sourceIdAccessor.getValue(d))) {
                        sourceLabel = this._groupLabelAccessor.getValue(groupDatum);
                        sourceColor = this._groupColorAccessor.getValue(groupDatum);
                        sourceGroupOrigialData = groupDatum;
                    }
                    if (!ObjectConverter.asString((Object)this._groupLabelAccessor.getValue(groupDatum)).equals(this._targetIdAccessor.getValue(d))) continue;
                    targetLabel = this._groupLabelAccessor.getValue(groupDatum);
                    targetColor = this._groupColorAccessor.getValue(groupDatum);
                    targetGroupOriginalData = groupDatum;
                }
            }
            if (sourceLabel == null) {
                sourceLabel = this._sourceIdAccessor.getValue(d);
            }
            if (targetLabel == null) {
                targetLabel = this._targetIdAccessor.getValue(d);
            }
            MatrixDataStruct sourceToTargetValueStruct = new MatrixDataStruct();
            sourceToTargetValueStruct.sourceID = this._sourceIdAccessor.getValue(d);
            sourceToTargetValueStruct.targetID = this._targetIdAccessor.getValue(d);
            sourceToTargetValueStruct.sourceGroupInfo.label = sourceLabel;
            sourceToTargetValueStruct.sourceGroupInfo.color = sourceColor;
            sourceToTargetValueStruct.sourceGroupInfo.groupOriginalData = sourceGroupOrigialData;
            sourceToTargetValueStruct.targetGroupInfo.label = targetLabel;
            sourceToTargetValueStruct.targetGroupInfo.color = targetColor;
            sourceToTargetValueStruct.targetGroupInfo.groupOriginalData = targetGroupOriginalData;
            sourceToTargetValueStruct.value = ObjectConverter.toDouble((Object)this._sourceValueAccessor.getValue(d));
            sourceToTargetValueStruct.color = this._chordColorAccessor != null ? this._chordColorAccessor.getValue(d) : null;
            sourceToTargetValueStruct.originalData = d;
            ((List)matrix.get(this._sourceItems.get(this._sources.indexOf(this._sourceIdAccessor.getValue(d))).id)).set(this._targetItems.get(this._targets.indexOf(this._targetIdAccessor.getValue(d))).id, sourceToTargetValueStruct);
            MatrixDataStruct targetToSourceValueStruct = new MatrixDataStruct();
            targetToSourceValueStruct.sourceID = this._targetIdAccessor.getValue(d);
            targetToSourceValueStruct.targetID = this._sourceIdAccessor.getValue(d);
            targetToSourceValueStruct.targetGroupInfo.label = sourceLabel;
            targetToSourceValueStruct.targetGroupInfo.color = sourceColor;
            targetToSourceValueStruct.targetGroupInfo.groupOriginalData = sourceGroupOrigialData;
            targetToSourceValueStruct.sourceGroupInfo.label = targetLabel;
            targetToSourceValueStruct.sourceGroupInfo.color = targetColor;
            targetToSourceValueStruct.sourceGroupInfo.groupOriginalData = targetGroupOriginalData;
            targetToSourceValueStruct.color = this._chordColorAccessor != null ? this._chordColorAccessor.getValue(d) : null;
            targetToSourceValueStruct.value = ObjectConverter.toDouble((Object)this._targetValueAccessor.getValue(d));
            targetToSourceValueStruct.originalData = d;
            this.maxDataPoint = targetToSourceValueStruct.value > sourceToTargetValueStruct.value ? targetToSourceValueStruct.value : sourceToTargetValueStruct.value;
            ((List)matrix.get(this._targetItems.get(this._targets.indexOf(this._targetIdAccessor.getValue(d))).id)).set(this._sourceItems.get(this._sources.indexOf(this._sourceIdAccessor.getValue(d))).id, targetToSourceValueStruct);
        }
        this.chord.padding(0.05).sortSubgroups(Rave.descending).matrix((List)matrix).value((SingleValueFunction)new SingleValueFunction<Double, Object>(){

            public Double getValue(Object data) {
                if (!(data instanceof Integer) && data != null) {
                    return ((MatrixDataStruct)data).value;
                }
                return 0.0;
            }
        });
        this.innerRadius = this._padding / 2.0 >= Math.min(this._width, this._height) ? Math.min(this._width, this._height) * 0.41 : Math.min(this._width - this._padding * 2.0, this._height - this._padding * 2.0) * 0.41;
        this.outerRadius = this.innerRadius * 1.1;
        Selector shapes = g.select((Object)"g.group-elements").attr("transform", (Object)("translate(" + (this._width / 2.0 + this._x) + "," + (this._height / 2.0 + this._y) + ")")).selectAll("g.group").data(((ArrayEx)this.chord.groups.getValue(this.chord)).toArray());
        Rave.transition((Selection)shapes.exit()).attr("opacity", (Object)0).remove();
        Selector shapesEnter = shapes.enter().append("g").attr("class", (Object)"group");
        shapesEnter.append("path").style("fill", _groupShapeColor).style("stroke", _groupShapeColor).attr("class", (Object)"groupPath element-shape").attr("opacity", (Object)0);
        final Transition groupTransition = shapes.transition(".groupTransition").select((Object)"path").attr("opacity", this._groupsOriginalStyle.get((Object)"opacity")).style("fill", _groupShapeColor).style("stroke", _groupShapeColor).attr("id", (ValueFunction)new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return "group" + index;
            }
        }).attr("d", (ValueFunction)this._arc.innerRadius(this.innerRadius).outerRadius(this.outerRadius));
        final ChordComponentImpl self = this;
        final int groupsArraySize = shapes.size();
        final int[] counter = new int[]{groupsArraySize};
        groupTransition.delay((ValueFunction)new ValueFunction<SceneNode, Double>(){

            @SwiftMethodOverload(skipParameters={1})
            public Double getValue(SceneNode context, Object data, int index, int GroupIndex) {
                if (self.groupsShinkingResizeFlag) {
                    return (double)index * (groupTransition.duration() * 0.5 / (double)groupsArraySize) + groupTransition.duration() * 0.5;
                }
                return (double)index * (groupTransition.duration() * 0.5 / (double)groupsArraySize);
            }
        });
        groupTransition.each("end", (RunFunction)new RunFunction<SceneNode>(){

            public Object run(SceneNode context, Object ... arg1) {
                counter[0] = counter[0] - 1;
                if (counter[0] == 0) {
                    self.groupsShinkingResizeFlag = false;
                }
                return null;
            }
        });
        groupTransition.each("interrupt", (RunFunction)new RunFunction<SceneNode>(){

            public Object run(SceneNode context, Object ... arg1) {
                counter[0] = counter[0] - 1;
                if (counter[0] == 0) {
                    self.groupsShinkingResizeFlag = false;
                }
                return null;
            }
        });
        shapesEnter.append("text").attr("class", (Object)"element-label").attr("x", (Object)6).attr("dy", (Object)12).append("textPath").attr("xlink:href", (ValueFunction)new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return "#group" + index;
            }
        }).attr("opacity", (Object)0).text((Object)"");
        final Transition groupTextTransition = shapes.transition(".groupsTextTransition").select((Object)"textPath").attr("opacity", (ValueFunction)new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                double arcLength = self.outerRadius * (((GroupData)data).endAngle - ((GroupData)data).startAngle) - 6.0;
                OMap map = ((SceneNode)context).getComputedStyles();
                String font = ObjectConverter.toString((Object)map.get((Object)"font"));
                double fontHeight = ((SceneNode)context).getSizePx(CSSUtil.parseSize((Object)map.get((Object)"font-size")));
                double arcHeight = self.outerRadius - self.innerRadius;
                double w = self.calculateTextWidth((String)((GroupDataStruct)((GroupData)data).datum).label, font);
                return arcLength > w && arcHeight > fontHeight ? 1 : 0;
            }
        }).text((ValueFunction)new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return ((GroupDataStruct)((GroupData)data).datum).label;
            }
        });
        if (this._labelFontStyle != null) {
            shapes.selectAll(".element-label").style(this._labelFontStyle);
        }
        groupTextTransition.delay((ValueFunction)new ValueFunction<SceneNode, Object>(){

            @SwiftMethodOverload(skipParameters={1})
            public Object getValue(SceneNode context, Object data, int index, int arg3) {
                double value = (double)index * (groupTextTransition.duration() * 0.5 / (double)groupsArraySize);
                if (self.groupsShinkingResizeFlag) {
                    return (value + groupTextTransition.duration() * 0.5) / 2.0;
                }
                return value * 2.0;
            }
        });
        List chordsArray = (List)this.chord.chords.getValue(this.chord);
        ArrayList<ChordBundleChordDatum> chordBundleDatums = new ArrayList<ChordBundleChordDatum>();
        for (ChordData chord : chordsArray) {
            ChordBundleChordDatum datum = new ChordBundleChordDatum();
            datum.setChordData(chord);
            datum.setChordOriginalData(chord.originalData);
            chordBundleDatums.add(datum);
        }
        Selector chords = g.select((Object)"g.chord-elements").attr("transform", (Object)("translate(" + (this._width / 2.0 + this._x) + "," + (this._height / 2.0 + this._y) + ")")).selectAll("path").data(chordBundleDatums.toArray());
        Rave.transition((Selection)chords.exit()).attr("opacity", (Object)0).remove();
        chords.enter().append("path").attr("class", (Object)"chord element-shape").style("fill", _chordShapeColor).style("stroke", null).attr("opacity", (Object)0);
        final Transition chordTransition = chords.transition(".chordTransition").attr("d", (ValueFunction)Rave.svg.chord().setDataAccessor((SingleValueFunction)new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return ((ChordBundleChordDatum)data).getChordData();
            }
        }).radius(this.innerRadius - (this.outerRadius - this.innerRadius) / 3.0)).style("fill", _chordShapeColor).style("stroke", null).attr("opacity", this._chordsOriginalStyle.get((Object)"opacity"));
        final int chordsArraySize = chords.size();
        final int[] counter2 = new int[]{chordsArraySize};
        chordTransition.delay((ValueFunction)new ValueFunction<SceneNode, Double>(){

            @SwiftMethodOverload(skipParameters={1})
            public Double getValue(SceneNode arg0, Object data, int index, int groupIndex) {
                if (self.chordsShinkingResizeFlag) {
                    return (double)index * (chordTransition.duration() * 0.5 / (double)chordsArraySize);
                }
                return (double)index * (chordTransition.duration() * 0.5 / (double)chordsArraySize) + chordTransition.duration() * 0.5;
            }
        });
        chordTransition.each("end", (RunFunction)new RunFunction<SceneNode>(){

            public Object run(SceneNode context, Object ... arg1) {
                counter2[0] = counter2[0] - 1;
                if (counter2[0] == 0) {
                    self.chordsShinkingResizeFlag = false;
                }
                return null;
            }
        });
        chordTransition.each("interrupt", (RunFunction)new RunFunction<SceneNode>(){

            public Object run(SceneNode context, Object ... arg1) {
                counter2[0] = counter2[0] - 1;
                if (counter2[0] == 0) {
                    self.chordsShinkingResizeFlag = false;
                }
                return null;
            }
        });
        Selector tickGroups = g.select((Object)"g.tick-elements").attr("transform", (Object)("translate(" + (this._width / 2.0 + this._x) + "," + (this._height / 2.0 + this._y) + ")")).selectAll(".groupTicks").data(((ArrayEx)this.chord.groups.getValue(this.chord)).toArray());
        Rave.transition((Selection)tickGroups.exit()).remove();
        tickGroups.enter().append("g").attr("class", (Object)"groupTicks");
        Selector ticks = tickGroups.selectAll(".tick").data(this.groupTicks());
        Rave.transition((Selection)ticks.exit()).remove();
        Selector ticksEnter = ticks.enter().append("g").attr("class", (Object)"tick");
        int ticksArraySize = ticks.size();
        final int[] counter3 = new int[]{ticksArraySize};
        final Transition ticksTransition = ticks.transition(".tickTransition").attr("transform", (ValueFunction)new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return "rotate(" + (((DataStruct)data).angel * 180.0 / Math.PI - 90.0) + ")translate(" + self.outerRadius + ",0)";
            }
        });
        ticksTransition.delay((ValueFunction)new ValueFunction<SceneNode, Double>(){

            @SwiftMethodOverload(skipParameters={1})
            public Double getValue(SceneNode arg0, Object data, int index, int groupIndex) {
                if (self.ticksShinkingResizeFlag) {
                    return ticksTransition.duration();
                }
                return 0.0;
            }
        });
        ticksTransition.each("end", (RunFunction)new RunFunction<SceneNode>(){

            public Object run(SceneNode context, Object ... arg1) {
                counter3[0] = counter3[0] - 1;
                if (counter3[0] == 0) {
                    self.ticksShinkingResizeFlag = false;
                }
                return null;
            }
        });
        ticksTransition.each("interrupt", (RunFunction)new RunFunction<SceneNode>(){

            public Object run(SceneNode context, Object ... arg1) {
                counter3[0] = counter3[0] - 1;
                if (counter3[0] == 0) {
                    self.ticksShinkingResizeFlag = false;
                }
                return null;
            }
        });
        if (this.displayTickLines) {
            ticksEnter.append("line");
            if (ticks.selectAll("line").size() == 0) {
                ticks.append("line");
            }
            Rave.transition((Selection)ticks).select((Object)"line").attr("x1", (Object)1).attr("y1", (Object)0).attr("x2", (Object)5).attr("y2", (Object)0).style("stroke", (Object)"#000");
        } else {
            ticks.selectAll("line").remove();
        }
        if (this.displayTickText) {
            ticksEnter.append("text");
            if (ticks.selectAll("text").size() == 0) {
                ticks.append("text");
            }
            Rave.transition((Selection)ticks).select((Object)"text").attr("x", (Object)8).attr("dy", (Object)".35em").attr("transform", (ValueFunction)new ValueFunction<Object, Object>(){

                public Object getValue(Object context, Object data, int index, int groupIndex) {
                    return ((DataStruct)data).angel > Math.PI ? "rotate(180)translate(-16)" : null;
                }
            }).style("text-anchor", (ValueFunction)new ValueFunction<Object, Object>(){

                public Object getValue(Object context, Object data, int index, int groupIndex) {
                    return ((DataStruct)data).angel > Math.PI ? "end" : null;
                }
            }).text((ValueFunction)new ValueFunction<Object, Object>(){

                public Object getValue(Object context, Object data, int index, int groupIndex) {
                    return ((DataStruct)data).label;
                }
            });
            if (this._tickFontStyle != null) {
                ticks.selectAll("text").style(this._tickFontStyle);
            }
        } else {
            ticks.selectAll("text").remove();
        }
    }

    private final ValueFunction<Object, Object[]> groupTicks() {
        final ChordComponentImpl self = this;
        return new ValueFunction<Object, Object[]>(){

            public Object[] getValue(Object context, Object data, int index, int groupIndex) {
                Double groupValue = ((GroupData)data).value;
                final Double k = (((GroupData)data).endAngle - ((GroupData)data).startAngle) / groupValue;
                final GroupData data2 = (GroupData)data;
                Double start = 0.0;
                double minStepAdjuster = self.goodNumberRounder(self.maxDataPoint) * 0.1;
                Double step = self._tickStepAdjuster < minStepAdjuster ? (double)Math.round(minStepAdjuster) : self._tickStepAdjuster;
                return Rave.range((Object)start, (Object)groupValue, (Object)step).map((ArrayEx.ArrayValueFunction)new ArrayEx.ArrayValueFunction<Number, DataStruct>(){

                    public DataStruct getValue(Number v, int i, ArrayEx<Number> arg2) {
                        DataStruct struct = new DataStruct();
                        struct.angel = ObjectConverter.toDouble((Object)v) * k + data2.startAngle;
                        struct.label = (double)i % self._tickTextFrequencyAdjuster != 0.0 ? null : ObjectConverter.toDouble((Object)v) / self._tickValueDivider + self._tickSuffixModifier;
                        return struct;
                    }
                }).toArray();
            }
        };
    }

    private double goodNumberRounder(Double aNumber) {
        int inputNumber = aNumber.intValue();
        String numberString = ObjectConverter.toString((Object)inputNumber);
        double length = numberString.length() - 1;
        double divider = Math.pow(10.0, length);
        return Math.ceil((double)inputNumber / divider) * divider;
    }

    public ChordComponentImpl tickStepAdjuster(Double adjuster) {
        this._tickStepAdjuster = adjuster;
        return this;
    }

    public ChordComponentImpl tickTextFrequencyAdjuster(Double adjuster) {
        this._tickTextFrequencyAdjuster = adjuster;
        return this;
    }

    public ChordComponentImpl tickSuffixModifier(String modifier) {
        this._tickSuffixModifier = modifier;
        return this;
    }

    public ChordComponentImpl tickValueDivider(Double divider) {
        this._tickValueDivider = divider;
        return this;
    }

    public ChordComponentImpl chordData(Object[] chordData) {
        this._chordData = chordData;
        return this;
    }

    public ChordComponentImpl groupData(Object[] groupData) {
        this._groupData = groupData;
        return this;
    }

    public ChordComponentImpl groupColorAccessor(SingleValueFunction<Object, Object> groupColorAccessor) {
        this._groupColorAccessor = groupColorAccessor;
        return this;
    }

    public ChordComponentImpl groupLabelAccessor(SingleValueFunction<Object, Object> groupLabelAccessor) {
        this._groupLabelAccessor = groupLabelAccessor;
        return this;
    }

    public ChordComponentImpl setSourceIdAccessor(SingleValueFunction<Object, Object> sourceIdAccessor) {
        this._sourceIdAccessor = sourceIdAccessor;
        return this;
    }

    public ChordComponentImpl setTargetIdAccessor(SingleValueFunction<Object, Object> targetIdAccessor) {
        this._targetIdAccessor = targetIdAccessor;
        return this;
    }

    public ChordComponentImpl setSourceValueAccessor(SingleValueFunction<Object, Object> sourceValueAccessor) {
        this._sourceValueAccessor = sourceValueAccessor;
        return this;
    }

    public ChordComponentImpl setTargetValueAccessor(SingleValueFunction<Object, Object> targetValueAccessor) {
        this._targetValueAccessor = targetValueAccessor;
        return this;
    }

    public ChordComponentImpl setChordColorAccessor(SingleValueFunction<Object, Object> chordColorAccessor) {
        this._chordColorAccessor = chordColorAccessor;
        return this;
    }

    public ChordComponentImpl chordsColorPalette(Palette chordscolorPalette) {
        this._chordsColorPalette = chordscolorPalette;
        return this;
    }

    public ChordComponentImpl groupsColorPalette(Palette groupsColorPalette) {
        this._groupsColorPalette = groupsColorPalette;
        return this;
    }

    public ChordComponentImpl x(double x) {
        this._x = x;
        return this;
    }

    public ChordComponentImpl y(double y) {
        this._y = y;
        return this;
    }

    public ChordComponentImpl padding(double padding) {
        this._padding = padding;
        return this;
    }

    public ChordComponentImpl width(double width) {
        if (width < this._width) {
            this.chordsShinkingResizeFlag = true;
            this.groupsShinkingResizeFlag = true;
            this.ticksShinkingResizeFlag = true;
        }
        this._width = width;
        return this;
    }

    public ChordComponentImpl height(double height) {
        if (height < this._height) {
            this.chordsShinkingResizeFlag = true;
            this.groupsShinkingResizeFlag = true;
            this.ticksShinkingResizeFlag = true;
        }
        this._height = height;
        return this;
    }

    public ChordComponentImpl enableTickLines(boolean enabled) {
        this.displayTickLines = enabled;
        return this;
    }

    public ChordComponentImpl enableTickText(boolean enabled) {
        this.displayTickText = enabled;
        return this;
    }

    private final ValueFunction<SceneNode, Object> groupShapeColor() {
        final ChordComponentImpl self = this;
        return new ValueFunction<SceneNode, Object>(){

            public Object getValue(SceneNode context, Object d, int index, int groupIndex) {
                Object v;
                GroupData groupDatum = (GroupData)d;
                Object object = v = ((GroupDataStruct)groupDatum.datum).groupOriginalData != null ? ((GroupDataStruct)groupDatum.datum).groupOriginalData : ((GroupDataStruct)groupDatum.datum).label;
                if (v == null) {
                    return null;
                }
                return self._groupsColorPalette.getValue(null, v, 0, 0);
            }
        };
    }

    private final ValueFunction<Object, Object> chordShapeColor() {
        final ChordComponentImpl self = this;
        return new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object d, int index, int groupIndex) {
                Object v;
                ChordData data = ((ChordBundleChordDatum)d).getChordData();
                Object object = v = ((MatrixDataStruct)data.source.datum).targetGroupInfo.groupOriginalData != null ? ((MatrixDataStruct)data.source.datum).targetGroupInfo.groupOriginalData : ((MatrixDataStruct)data.source.datum).targetGroupInfo.label;
                if (self._chordColorAccessor != null) {
                    v = ((MatrixDataStruct)data.source.datum).color;
                    return self._chordsColorPalette.getValue(null, v, 0, 0);
                }
                return self._groupsColorPalette.getValue(null, v, 0, 0);
            }
        };
    }

    private ChordItem sources(Object d) {
        if (this._sources.contains(this._sourceIdAccessor.getValue(d))) {
            return this._sourceItems.get(this._sources.indexOf(this._sourceIdAccessor.getValue(d)));
        }
        this._sources.add(this._sourceIdAccessor.getValue(d));
        ChordItem item = new ChordItem();
        item.name = ObjectConverter.toString((Object)this._sourceIdAccessor.getValue(d));
        item.id = this.n++;
        this._sourceItems.add(item);
        return item;
    }

    private ChordItem targets(Object d) {
        if (this._targets.contains(this._targetIdAccessor.getValue(d))) {
            return this._targetItems.get(this._targets.indexOf(this._targetIdAccessor.getValue(d)));
        }
        this._targets.add(this._targetIdAccessor.getValue(d));
        ChordItem item = new ChordItem();
        item.name = ObjectConverter.toString((Object)this._targetIdAccessor.getValue(d));
        item.id = this.m++;
        this._targetItems.add(item);
        return item;
    }

    public ChordComponentImpl groupDataSet(DataSet groupDataSet) {
        this._groupDataSet = groupDataSet;
        return this;
    }

    public ChordComponentImpl chordsOriginalStyle(OMap<String, Object> chordsoriginalstyle) {
        this._chordsOriginalStyle = chordsoriginalstyle;
        return this;
    }

    public ChordComponentImpl groupsOriginalStyle(OMap<String, Object> groupsoriginalstyle) {
        this._groupsOriginalStyle = groupsoriginalstyle;
        return this;
    }

    public ChordComponentImpl tickFont(String fontStyle) {
        this._tickFontStyle = FontPropertyParser.parseCSSFont(fontStyle);
        return this;
    }

    public ChordComponentImpl labelFont(String fontStyle) {
        this._labelFontStyle = FontPropertyParser.parseCSSFont(fontStyle);
        return this;
    }

    private Double calculateTextWidth(String text, String font) {
        Canvas canvas = Rave.canvas.create(200.0, 200.0);
        RenderingContext context = canvas.getContext("2d", new Object[0]);
        context.font = font;
        TextMetrics metrics = context.measureText(text);
        double width = metrics.width;
        return width;
    }

    private static class ChordItem {
        private String name;
        private int id;

        private ChordItem() {
        }
    }

    private static class DataStruct {
        private String label;
        private double angel;

        private DataStruct() {
        }
    }
}

