/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.components;

import com.ibm.rave.core.Rave;
import com.ibm.rave.core.behavior.Zoom;
import com.ibm.rave.core.geom.Dim;
import com.ibm.rave.core.geom.Point;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.scales.LinearScale;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.library.framework.internal.CoordinateScaleImpl;

public final class ComponentConfiguration {
    private ComponentConfiguration() {
    }

    public static Zoom configureZoom(Selection<?> chart, Zoom zoom, CoordinateScaleImpl xScale, CoordinateScaleImpl yScale, CoordinateScaleImpl x2Scale, CoordinateScaleImpl y2Scale, Dim scaleExtent, final RectStruct chartRect, final double[] p, final double[] s, final String zoomOps, final RunFunction<SceneNode> callback) {
        final Zoom z = zoom != null ? zoom : Rave.behavior.zoom();
        final Zoom z1 = (x2Scale != null || y2Scale != null) && zoomOps.equals("all") ? Rave.behavior.zoom() : null;
        LinearScale dummyScale = Rave.scale.linear();
        z.x((AbstractScale)dummyScale);
        z.y((AbstractScale)dummyScale);
        if (xScale != null && zoomOps.equals("x")) {
            z.x(xScale.scale());
            z.scale(s[0]);
            z.translate(new Point(p[0], 0.0));
        }
        if (yScale != null && zoomOps.equals("y")) {
            z.y(yScale.scale());
            z.scale(s[1]);
            z.translate(new Point(0.0, p[1]));
        }
        if (x2Scale != null && zoomOps.equals("x2")) {
            z.x(x2Scale.scale());
            z.scale(s[2]);
            z.translate(new Point(p[2], 0.0));
        }
        if (y2Scale != null && zoomOps.equals("y2")) {
            z.y(y2Scale.scale());
            z.scale(s[3]);
            z.translate(new Point(0.0, p[3]));
        }
        if (zoomOps.equals("all")) {
            if (xScale != null) {
                z.x(xScale.scale());
            }
            if (yScale != null) {
                z.y(yScale.scale());
            }
            z.scale(1.0);
            z.translate(new Point(0.0, 0.0));
            if (z1 != null) {
                if (x2Scale != null) {
                    z1.x(x2Scale.scale());
                }
                if (y2Scale != null) {
                    z1.y(y2Scale.scale());
                }
                z1.scale(1.0);
                z1.translate(new Point(0.0, 0.0));
            }
        }
        z.scaleExtent(scaleExtent != null ? scaleExtent : new Dim(1.0, Double.POSITIVE_INFINITY)).on("zoom.default", (RunFunction)new RunFunction<SceneNode>(){

            public Object run(SceneNode node, Object ... args) {
                Zoom.EventObject event = (Zoom.EventObject)args[3];
                double scale = event.scale;
                double[] translate = event.translate;
                double scaledX = chartRect.x * (scale - 1.0);
                double scaledXExtent = chartRect.width * (1.0 - scale) - scaledX;
                translate[0] = Math.min(-scaledX, Math.max(scaledXExtent, translate[0]));
                double scaledY = chartRect.y * (scale - 1.0);
                double scaledYExtent = chartRect.height * (1.0 - scale) - scaledY;
                translate[1] = Math.min(-scaledY, Math.max(scaledYExtent, translate[1]));
                z.translate(new Point(translate[0], translate[1]));
                if (z1 != null) {
                    z1.translate(new Point(translate[0], translate[1]));
                    z1.scale(scale);
                }
                if (zoomOps.equals("x")) {
                    p[0] = translate[0];
                    s[0] = scale;
                } else if (zoomOps.equals("y")) {
                    p[1] = translate[1];
                    s[1] = scale;
                } else if (zoomOps.equals("x2")) {
                    p[2] = translate[0];
                    s[2] = scale;
                } else if (zoomOps.equals("y2")) {
                    p[3] = translate[1];
                    s[3] = scale;
                } else if (zoomOps.equals("all")) {
                    p[0] = translate[0];
                    p[1] = translate[1];
                    p[2] = translate[0];
                    p[3] = translate[1];
                    s[0] = scale;
                    s[1] = scale;
                    s[2] = scale;
                    s[3] = scale;
                }
                return callback.run((Object)node, args);
            }
        });
        return z;
    }
}

