/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.components;

import com.ibm.rave.bundles.component.DialComponent;
import com.ibm.rave.bundles.components.KeyedBundleComponentImpl;
import com.ibm.rave.bundles.data.DialDatum;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.Point;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.interpolate.Interpolator;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.svg.Arc;
import com.ibm.rave.core.svg.ArcData;
import com.ibm.rave.core.transition.TransitionInterpolatorFactory;
import com.ibm.rave.ext.text.wrap.TextFlow;
import com.ibm.rave.library.palette.Palette;

public class DialComponentImpl
extends KeyedBundleComponentImpl<DialComponentImpl>
implements DialComponent {
    private static final String CENTER_CLASS = "center-circle";
    private static final String CENTER_BACKGROUND_CLASS = "centerbackground-circle";
    private String _currentlyReached = "currently reached";
    private String _reachedOverTarget = "reached over target";
    Selector _chart;
    private DialDatum[] _dialData;
    private SingleValueFunction<Object, Object> _labelAccessor = new SingleValueFunction<Object, Object>(){

        public String getValue(Object d) {
            String label = ((DialDatum)d).label();
            if (label == null) {
                label = ((DialDatum)d).category();
            }
            return label;
        }
    };
    private SingleValueFunction<Object, Object> _valueAccessor = new SingleValueFunction<Object, Object>(){

        public Number getValue(Object d) {
            return ((DialDatum)d).value();
        }
    };
    private SingleValueFunction<Object, Object> _maxValueAccessor = new SingleValueFunction<Object, Object>(){

        public Number getValue(Object d) {
            return ((DialDatum)d).maxValue();
        }
    };
    private ValueFunction<Object, String> _valueFormatter;
    private Palette _colorPalette;
    private RectStruct _bounds;
    private double _startAngle = 0.0;
    private double _transitionDur;
    private double _maxValue = 0.0;
    private boolean _maxFound = false;
    private boolean _categoryDial = false;
    private boolean _showAsPercentage;
    private boolean _roundedEnds = false;
    private String _backRingColor;
    private String _paddingColor;
    private double _dialWidth = 0.0;
    private double _dialPadding;
    private double _valueSize;
    private double _minFontSize = 11.0;
    private String _valueColor;
    private String _valueFont;
    private double _centerRadius;
    private String _centerColor;
    private String _borderColor;
    private String _borderWidth;
    private double _centerPaddingRadius;
    private double _centerBackgroundRadius;
    private boolean _proportionalWidths = true;
    private double _totalRadius = 0.0;
    private double _ringWidth = 0.0;
    private Point _chartCenter;
    private String _valueString = null;
    private String _labelString;
    private Arc _dialArc = new Arc();
    ArrayEx<ArcData> _arcData = new ArrayEx();
    private boolean _labelsDrawn = false;
    private double _adjustedRingWidth;
    private double _adjustedDialPadding;
    private double _adjustedCenterRadius;
    private double _adjustedCenterBackgroundRadius;
    private double _adjustedCenterPaddingRadius;
    private double _totalCenterRadius;
    private double _adjustedPercentageFontSize;
    private double _adjustedOutofFontSize;
    private boolean _useOutofFontSize = false;
    private boolean _firstRender = true;

    public static DialComponentImpl create() {
        return new DialComponentImpl();
    }

    public DialComponentImpl() {
        this.setUXDefaults();
    }

    @Override
    public String type() {
        return "DialComponent";
    }

    public void setUXDefaults() {
        this._dialWidth = 30.0;
        this._dialPadding = 15.0;
        this._centerRadius = 80.0;
        this._centerPaddingRadius = 55.0;
        this._centerBackgroundRadius = 100.0;
        this._valueSize = 0.0;
        this._showAsPercentage = false;
        this._labelString = "currently reached";
        this._valueFont = "Roboto, sans-serif";
        this._centerColor = "#E1E1E1";
        this._paddingColor = "#FFFFFF";
        this._backRingColor = "#E1E1E1";
        this._valueColor = "#FFFFFF";
        this._valueFormatter = null;
        this._borderColor = "#000000";
        this._borderWidth = "0px";
    }

    @Override
    protected void execute(Selector g) {
        if (this._dialData == null) {
            g.selectAll("*").remove();
            return;
        }
        this._chart = g;
        this.analyzeData();
        this.drawBackgrounds(this._chart, this._dialData);
        this.drawDials(this._chart, this._dialData);
        this.drawLabels(this._chart, this._dialData);
        this.drawStartLines(this._chart, this._dialData);
        this._labelString = null;
        this._valueString = null;
        this._categoryDial = false;
    }

    private void analyzeData() {
        double startAng = Math.abs(this._startAngle) % 360.0 * Math.PI / 180.0;
        this._startAngle = this._startAngle < 0.0 ? -startAng : startAng;
        if (!this._categoryDial) {
            this._maxValue = this.calculateMaxValue(this._dialData, this._maxValue);
        } else {
            this._maxFound = true;
        }
        if (this._dialData.length == 1) {
            this.setLabels(this._dialData[0]);
        } else {
            this.setLabels(null);
        }
        this._totalRadius = this._bounds.height < this._bounds.width ? this._bounds.height : this._bounds.width;
        this._totalRadius *= 0.45;
        this._chartCenter = new Point(this._bounds.x + this._bounds.width * 0.5, this._bounds.y + this._bounds.height * 0.5);
        int len = this._dialData.length;
        this._ringWidth = this._dialWidth;
        if (this._ringWidth <= 0.0) {
            this._ringWidth = 10.0;
        }
        if (this._dialPadding < 0.0) {
            this._dialPadding = 0.0;
        }
        double multiplier = 1.0;
        double centerTotal = this._centerBackgroundRadius + this._centerPaddingRadius;
        double estimatedRadius = centerTotal + (this._ringWidth + this._dialPadding) * (double)len;
        if (this._proportionalWidths) {
            if (centerTotal <= 0.0) {
                centerTotal = this._ringWidth * 5.0;
                this.recalculateCenter(centerTotal);
                estimatedRadius = centerTotal + (this._ringWidth + this._dialPadding) * (double)len;
            }
            multiplier = this._totalRadius / estimatedRadius;
        } else {
            boolean rescaleAll = false;
            if (this._centerRadius < 0.0 && this._totalRadius > (estimatedRadius = (this._ringWidth + this._dialPadding) * (double)len)) {
                centerTotal = this._totalRadius - estimatedRadius;
                rescaleAll = this.recalculateCenter(centerTotal);
            }
            if (!rescaleAll && this._totalRadius < estimatedRadius) {
                if (this._totalRadius >= estimatedRadius - this._centerRadius) {
                    centerTotal = this._totalRadius - (estimatedRadius - centerTotal);
                    rescaleAll = this.recalculateCenter(centerTotal);
                } else {
                    rescaleAll = true;
                }
            } else {
                this._totalRadius = estimatedRadius;
            }
            if (rescaleAll) {
                multiplier = this._totalRadius / estimatedRadius;
            }
        }
        this._adjustedCenterPaddingRadius = this._centerPaddingRadius * multiplier;
        this._adjustedRingWidth = this._ringWidth * multiplier;
        this._adjustedDialPadding = this._dialPadding * multiplier;
        this._adjustedCenterRadius = this._centerRadius * multiplier;
        this._adjustedCenterBackgroundRadius = this._centerBackgroundRadius * multiplier;
        this._totalCenterRadius = this._adjustedCenterBackgroundRadius + this._adjustedCenterPaddingRadius;
    }

    public double calculateMaxValue(DialDatum[] dialData, double maxValue) {
        this._maxFound = true;
        this._maxValue = maxValue;
        if (maxValue == 0.0) {
            this._maxFound = false;
            double maxVal = 0.0;
            double maxMax = 0.0;
            for (DialDatum datum : dialData) {
                double val = Math.abs(ObjectConverter.toDouble((Object)this._valueAccessor.getValue((Object)datum)));
                double max = this.getMax(datum);
                if (val > maxVal) {
                    maxVal = val;
                }
                if (max == 0.0 || !(max > maxMax)) continue;
                maxMax = max;
                this._maxFound = true;
            }
            if (this._valueFormatter == null && !this._maxFound) {
                this._maxValue = maxVal;
                this._maxFound = true;
            } else {
                this._maxValue = maxVal > maxMax ? maxVal : maxMax;
                this._maxValue = (double)Math.round(this._maxValue * 100.0) / 100.0;
            }
        }
        return this._maxValue;
    }

    private boolean recalculateCenter(double centerTotal) {
        if (centerTotal >= 100.0) {
            this._centerBackgroundRadius = centerTotal * 0.65;
            this._centerPaddingRadius = centerTotal * 0.35;
            this._centerRadius = centerTotal * 0.5;
            return false;
        }
        return true;
    }

    private void drawBackgrounds(Selector chart, Object[] data) {
        if (data.length == 0) {
            chart.selectAll(".backgrounds").remove();
            return;
        }
        Selector bgrounds = chart.selectAll(".backgrounds").data(new Object[]{0});
        bgrounds.enter().append("g").attr("class", (Object)"backgrounds");
        bgrounds = bgrounds.selectAll("g").data(new Object[]{0});
        bgrounds.enter().append("g").attr("class", (Object)"bg-circle");
        bgrounds.enter().append("g").attr("class", (Object)CENTER_BACKGROUND_CLASS);
        bgrounds.enter().append("g").attr("class", (Object)CENTER_CLASS);
        bgrounds.enter().append("g").attr("class", (Object)"bgrings");
        bgrounds = chart.select((Object)".bg-circle");
        Selector circle = bgrounds.selectAll("circle").data(new Object[]{0});
        circle.enter().append("circle");
        if (this._firstRender) {
            circle.attr("transform", (Object)("translate(" + this._chartCenter.getX() + ", " + this._chartCenter.getY() + ")")).style("fill", (Object)"white").attr("r", (Object)1.0);
        }
        Rave.transition((Selection)circle).attr("transform", (Object)("translate(" + this._chartCenter.getX() + ", " + this._chartCenter.getY() + ")")).style("fill", (Object)this._paddingColor).attr("r", (Object)this._totalRadius);
        Object centerColor = this._centerColor;
        if (data.length == 1) {
            centerColor = this._colorPalette.getValue(null, data[0], 0, 0);
        }
        bgrounds = chart.select((Object)".centerbackground-circle");
        circle = bgrounds.selectAll("circle").data(new Object[]{0});
        circle.enter().append("circle").attr("transform", (Object)("translate(" + this._chartCenter.getX() + ", " + this._chartCenter.getY() + ")")).style("fill", (Object)"white").attr("r", (Object)1.0);
        Rave.transition((Selection)circle).attr("transform", (Object)("translate(" + this._chartCenter.getX() + ", " + this._chartCenter.getY() + ")")).style("fill", centerColor).style("fill-opacity", (Object)0.3).attr("r", (Object)this._adjustedCenterBackgroundRadius);
        bgrounds = chart.select((Object)".center-circle");
        circle = bgrounds.selectAll("circle").data(new Object[]{0});
        circle.enter().append("circle");
        if (this._firstRender) {
            circle.attr("transform", (Object)("translate(" + this._chartCenter.getX() + ", " + this._chartCenter.getY() + ")")).style("fill", (Object)"white").attr("r", (Object)1.0);
        }
        Rave.transition((Selection)circle).attr("transform", (Object)("translate(" + this._chartCenter.getX() + ", " + this._chartCenter.getY() + ")")).style("fill", centerColor).attr("r", (Object)this._adjustedCenterRadius);
        Selector bgRings = chart.select((Object)".bgrings");
        Selector rings = bgRings.selectAll(".bgRing").data(data);
        rings.enter().append("g").attr("class", (Object)"bgRing").append("path").style("fill", (Object)"white").attr("transform", (Object)("translate(" + this._chartCenter.getX() + ", " + this._chartCenter.getY() + ")")).attr("opacity", (Object)0.0);
        Rave.transition((Selection)rings.exit()).attr("opacity", (Object)0).remove();
        Selector paths = bgRings.selectAll("path");
        Rave.transition((Selection)paths).attr("d", (ValueFunction)new Arc().innerRadius(this.innerRadius()).outerRadius(this.outerRadius()).startAngle(0.0).endAngle(Math.PI * 2)).attr("transform", (Object)("translate(" + this._chartCenter.getX() + ", " + this._chartCenter.getY() + ")")).attr("opacity", (Object)1.0).style("fill", (Object)this._backRingColor);
    }

    private void drawDials(Selector chart, Object[] data) {
        final DialComponentImpl self = this;
        Selector dialgroup = chart.selectAll(".dial-group").data(new Object[]{0});
        dialgroup.enter().append("g").attr("class", (Object)"dial-group");
        dialgroup = chart.select((Object)".dial-group");
        Selector dials = dialgroup.selectAll(".element-shape").data(data);
        dials.enter().append("path").attr("class", (Object)"element-shape").attr("transform", (Object)("translate(" + this._chartCenter.getX() + ", " + this._chartCenter.getY() + ")"));
        dials.exit().remove();
        if (this._arcData.length() > data.length) {
            for (int i = data.length; i < this._arcData.length(); ++i) {
                this._arcData.set(i, null);
            }
        }
        Selector paths = dialgroup.selectAll(".element-shape");
        double cornerRadius = this._roundedEnds ? this._adjustedRingWidth / 2.0 : 0.0;
        this._dialArc.cornerRadius(cornerRadius);
        if (this._firstRender) {
            Rave.transition((Selection)paths).attr("transform", (Object)("translate(" + this._chartCenter.getX() + ", " + this._chartCenter.getY() + ")")).style("fill", (ValueFunction)this._colorPalette).style("fill-opacity", (Object)1.0).style("stroke-width", (Object)this._borderWidth).style("stroke", (ValueFunction)new ValueFunction<SceneNode, Object>(){

                public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                    if (context.getProperty("selected") != null) {
                        return Rave.rgb((Object)self._colorPalette.getValue(context, data, index, groupIndex)).darker(0.4);
                    }
                    return self._borderColor;
                }
            });
            paths.transition().duration((Object)this._transitionDur).attrTween("d", this.interpolateDial());
        } else {
            Rave.transition((Selection)paths).attr("d", this.dialTarget()).attr("transform", (Object)("translate(" + this._chartCenter.getX() + ", " + this._chartCenter.getY() + ")")).style("fill", (ValueFunction)this._colorPalette).style("fill-opacity", (Object)1.0).style("stroke-width", (Object)this._borderWidth).style("stroke", (ValueFunction)new ValueFunction<SceneNode, Object>(){

                public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                    if (context.getProperty("selected") != null) {
                        return Rave.rgb((Object)self._colorPalette.getValue(context, data, index, groupIndex)).darker(0.4);
                    }
                    return self._borderColor;
                }
            });
            paths.transition().duration((Object)this._transitionDur).attrTween("d", this.interpolateDial());
        }
        this._firstRender = false;
    }

    private TransitionInterpolatorFactory<SceneNode> interpolateDial() {
        final DialComponentImpl self = this;
        return new TransitionInterpolatorFactory<SceneNode>(){

            public Interpolator<?> create(final SceneNode context, Object data, final int index, Object value) {
                ArcData data1 = null;
                if (self._arcData.length() > index) {
                    data1 = (ArcData)self._arcData.get(index);
                }
                ArcData data2 = new ArcData();
                data2.innerRadius = ObjectConverter.asDouble((Object)self.innerRadius().getValue((Object)context, data, index, 0));
                data2.outerRadius = ObjectConverter.asDouble((Object)self.outerRadius().getValue((Object)context, data, index, 0));
                data2.padAngle = 0.0;
                double val = ObjectConverter.toDouble((Object)self._valueAccessor.getValue(data));
                if (val >= 0.0) {
                    data2.startAngle = (Double)self.startAngle().getValue((Object)context, data, index, 0);
                    data2.endAngle = (Double)self.endAngle().getValue((Object)context, data, index, 0);
                } else {
                    data2.endAngle = (Double)self.endAngle().getValue((Object)context, data, index, 0);
                    data2.startAngle = (Double)self.startAngle().getValue((Object)context, data, index, 0);
                }
                if (data1 == null) {
                    data1 = new ArcData();
                    data1.innerRadius = data2.innerRadius;
                    data1.outerRadius = data2.outerRadius;
                    data1.padAngle = data2.padAngle;
                    if (val >= 0.0) {
                        data1.startAngle = data2.startAngle;
                        data1.endAngle = (Double)self.startAngle().getValue((Object)context, data, index, 0);
                    } else {
                        data1.endAngle = data2.endAngle;
                        data1.startAngle = (Double)self.endAngle().getValue((Object)context, data, index, 0);
                    }
                }
                self._arcData.set(index, (Object)data2);
                final Interpolator i = Rave.interpolate.create((Object)data1, (Object)data2);
                return new Interpolator<String>(){

                    public String interpolate(double t) {
                        return self._dialArc.getValue((Object)context, i.interpolate(t), index, 0);
                    }
                };
            }
        };
    }

    private final ValueFunction<Object, String> dialTarget() {
        final DialComponentImpl self = this;
        return new ValueFunction<Object, String>(){

            public String getValue(Object context, Object data, int index, int groupIndex) {
                ArcData arcData = null;
                if (self._arcData.length() > index) {
                    arcData = (ArcData)self._arcData.get(index);
                }
                if (arcData == null) {
                    arcData = new ArcData();
                    arcData.padAngle = 0.0;
                    arcData.startAngle = arcData.endAngle = ((Double)self.startAngle().getValue(context, data, index, 0)).doubleValue();
                }
                arcData.innerRadius = ObjectConverter.asDouble((Object)self.innerRadius().getValue(context, data, index, 0));
                arcData.outerRadius = ObjectConverter.asDouble((Object)self.outerRadius().getValue(context, data, index, 0));
                return self._dialArc.getValue(context, (Object)arcData, index, 0);
            }
        };
    }

    private void drawLabels(Selector chart, Object[] data) {
        if (data.length == 0) {
            chart.selectAll(".labels").remove();
            return;
        }
        Selector labelgroup = chart.selectAll(".labels").data(new Object[]{0});
        double valueStringY = this._chartCenter.getY();
        double reachedStringY = this._chartCenter.getY() + this._adjustedCenterRadius * 0.5;
        labelgroup.enter().append("g").attr("class", (Object)"labels");
        Selector label = labelgroup.selectAll(".value-label").data(new Object[]{0});
        label.enter().append("text").attr("class", (Object)"value-label").attr("x", (Object)this._chartCenter.getX()).attr("y", (Object)valueStringY).style("font-size", (Object)"1px");
        label = labelgroup.selectAll(".reached-label").data(new Object[]{0});
        label.enter().append("text").attr("class", (Object)"reached-label").attr("x", (Object)this._chartCenter.getX()).attr("y", (Object)reachedStringY).style("font-size", (Object)"1px");
        TextFlow textflow = (TextFlow)Rave.capabilities.extension("textflow");
        textflow.wrap(false).fit(true).minFont((Object)this._minFontSize).dropTextOnFail(true);
        if (this._valueSize != 0.0) {
            Rave.transition((Selection)labelgroup.select((Object)".value-label").attr("x", (Object)this._chartCenter.getX()).attr("y", (Object)valueStringY).attr("width", (Object)(this._adjustedCenterRadius * 1.8)).attr("height", (Object)(this._adjustedCenterRadius * 0.8)).text((Object)this._valueString).style("color", (Object)this._valueColor).style("text-anchor", (Object)"middle").style("fill", (Object)this._valueColor).style("font-family", (Object)this._valueFont).style("font-size", (Object)(this._valueSize + "px")));
        } else {
            Rave.transition((Selection)labelgroup.select((Object)".value-label").attr("x", (Object)this._chartCenter.getX()).attr("y", (Object)valueStringY).attr("width", (Object)(this._adjustedCenterRadius * 1.8)).attr("height", (Object)(this._adjustedCenterRadius * 0.8)).text((Object)this._valueString).style("color", (Object)this._valueColor).style("text-anchor", (Object)"middle").style("fill", (Object)this._valueColor).style("font-family", (Object)this._valueFont).call((RunFunction)textflow, new Object[0]));
        }
        Rave.transition((Selection)labelgroup.select((Object)".reached-label").attr("x", (Object)this._chartCenter.getX()).attr("y", (Object)reachedStringY).attr("width", (Object)(this._adjustedCenterRadius * 1.6)).attr("height", (Object)(this._adjustedCenterRadius * 0.4)).text((Object)this._labelString).style("color", (Object)this._valueColor).style("text-anchor", (Object)"middle").style("fill", (Object)this._valueColor).style("font-family", (Object)this._valueFont).call((RunFunction)textflow, new Object[0]));
        this._labelsDrawn = true;
    }

    private void drawStartLines(Selector chart, Object[] data) {
        if (this._roundedEnds) {
            chart.selectAll(".start-line").remove();
        } else {
            final DialComponentImpl self = this;
            Selector linegroup = chart.selectAll(".start-lines").data(new Object[]{0});
            linegroup.enter().append("g").attr("class", (Object)"start-lines");
            linegroup = chart.select((Object)".start-lines");
            Selector lines = linegroup.selectAll(".start-line").data(data);
            lines.enter().append("line").attr("class", (Object)"start-line").attr("opacity", (Object)0.0);
            lines.exit().remove();
            lines = linegroup.selectAll(".start-line");
            final double xMult = Math.sin(this._startAngle);
            final double yMult = -Math.cos(this._startAngle);
            ValueFunction<Object, Double> innerX = new ValueFunction<Object, Double>(){

                public Double getValue(Object context, Object d, int index, int groupIndex) {
                    return self._chartCenter.getX() + xMult * (self._totalCenterRadius + self._adjustedDialPadding + (self._adjustedRingWidth + self._adjustedDialPadding) * (double)index);
                }
            };
            ValueFunction<Object, Double> outerX = new ValueFunction<Object, Double>(){

                public Double getValue(Object context, Object d, int index, int groupIndex) {
                    return self._chartCenter.getX() + xMult * (self._totalCenterRadius + (self._adjustedRingWidth + self._adjustedDialPadding) * (double)(index + 1));
                }
            };
            ValueFunction<Object, Double> innerY = new ValueFunction<Object, Double>(){

                public Double getValue(Object context, Object d, int index, int groupIndex) {
                    return self._chartCenter.getY() + yMult * (self._totalCenterRadius + self._adjustedDialPadding + (self._adjustedRingWidth + self._adjustedDialPadding) * (double)index);
                }
            };
            ValueFunction<Object, Double> outerY = new ValueFunction<Object, Double>(){

                public Double getValue(Object context, Object d, int index, int groupIndex) {
                    return self._chartCenter.getY() + yMult * (self._totalCenterRadius + (self._adjustedRingWidth + self._adjustedDialPadding) * (double)(index + 1));
                }
            };
            ValueFunction<Object, Boolean> strokeClass = new ValueFunction<Object, Boolean>(){

                public Boolean getValue(Object context, Object d, int index, int groupIndex) {
                    double value;
                    double max = self.getMax(d);
                    if (max == 0.0) {
                        max = self._maxValue;
                    }
                    if (max > 0.0 && (value = ObjectConverter.toDouble((Object)self._valueAccessor.getValue(d))) > max) {
                        return true;
                    }
                    return false;
                }
            };
            lines.classed("overmax", (ValueFunction)strokeClass);
            lines.transition().duration((Object)this._transitionDur).attr("x1", (ValueFunction)innerX).attr("x2", (ValueFunction)outerX).attr("y1", (ValueFunction)innerY).attr("y2", (ValueFunction)outerY).attr("opacity", (Object)1.0);
        }
    }

    @SwiftMethodOverload(skipParameters={1})
    public void setLabels(Object data) {
        double max = 0.0;
        if (data == null) {
            if (this._dialData.length > 1) {
                this._labelString = null;
                this._valueString = null;
            }
        } else {
            max = this.getMax(data);
            if (max == 0.0) {
                max = this._maxValue;
            }
            boolean labelFound = false;
            if (this._labelAccessor != null) {
                this._labelString = ObjectConverter.toString((Object)this._labelAccessor.getValue(data));
                if (this._labelString != null && !this._labelString.equals("null")) {
                    labelFound = true;
                }
            }
            if (!labelFound) {
                this._labelString = this._currentlyReached;
            }
            if (this._valueFormatter == null && this._showAsPercentage && max > 0.0) {
                long percentValue = Math.round(ObjectConverter.toDouble((Object)this._valueAccessor.getValue(data)) / max * 100.0);
                this._valueString = percentValue + "%";
                if (!labelFound && percentValue > 100L) {
                    this._labelString = this._reachedOverTarget;
                }
            } else if (this._valueFormatter != null) {
                if (this._showAsPercentage && max > 0.0) {
                    long percentValue = Math.round(ObjectConverter.toDouble((Object)this._valueAccessor.getValue(data)) / max * 100.0);
                    this._valueString = ObjectConverter.toString((Object)this._valueFormatter.getValue(null, (Object)percentValue, 0, 0));
                } else {
                    this._valueString = ObjectConverter.toString((Object)this._valueFormatter.getValue(null, this._valueAccessor.getValue(data), 0, 0));
                }
                int maxPos = this._valueString.indexOf("$max$");
                if (this._maxFound && max != 0.0 && maxPos > -1) {
                    this._valueString = this._valueString.substring(0, maxPos) + max + this._valueString.substring(maxPos + 5, this._valueString.length());
                }
            } else {
                this._valueString = ObjectConverter.toString((Object)this._valueAccessor.getValue(data));
            }
        }
        if (this._labelsDrawn) {
            TextFlow textflow = (TextFlow)Rave.capabilities.extension("textflow");
            textflow.wrap(false).fit(true).minFont((Object)this._minFontSize).dropTextOnFail(true);
            Selector labelgroup = this._chart.selectAll(".labels");
            Rave.transition((Selection)labelgroup.select((Object)".value-label").text((Object)this._valueString).call((RunFunction)textflow, new Object[0]));
            Rave.transition((Selection)labelgroup.select((Object)".reached-label").text((Object)this._labelString).call((RunFunction)textflow, new Object[0]));
            if (this._dialData.length > 1) {
                this._labelString = null;
                this._valueString = null;
            }
        }
        this.highLightCenter(data);
    }

    private void highLightCenter(Object d) {
        if (this._dialData.length > 1) {
            Object[] data = new Object[]{d != null ? d : Integer.valueOf(0)};
            Object color = d != null ? this._colorPalette : this._centerColor;
            Selector circle = this._chart.select((Object)".centerbackground-circle").selectAll("circle");
            Rave.transition((Selection)circle.data(data)).style("fill", color);
            circle = this._chart.select((Object)".center-circle").selectAll("circle");
            Rave.transition((Selection)circle.data(data)).style("fill", color);
        }
    }

    private final ValueFunction<Object, Double> startAngle() {
        final DialComponentImpl self = this;
        return new ValueFunction<Object, Double>(){

            public Double getValue(Object context, Object data, int index, int groupIndex) {
                double value = ObjectConverter.toDouble((Object)self._valueAccessor.getValue(data));
                if (value >= 0.0) {
                    return self._startAngle;
                }
                double max = self.getMax(data);
                value = max != 0.0 ? (value /= max) : (value /= self._maxValue);
                return self._startAngle + value * 2.0 * Math.PI;
            }
        };
    }

    private final ValueFunction<Object, Double> endAngle() {
        final DialComponentImpl self = this;
        return new ValueFunction<Object, Double>(){

            public Double getValue(Object context, Object data, int index, int groupIndex) {
                double value = ObjectConverter.toDouble((Object)self._valueAccessor.getValue(data));
                double max = self.getMax(data);
                if (value < 0.0) {
                    return self._startAngle;
                }
                value = max != 0.0 ? (value /= max) : (value /= self._maxValue);
                return self._startAngle + value * 2.0 * Math.PI;
            }
        };
    }

    private final ValueFunction<Object, ? extends Number> innerRadius() {
        final DialComponentImpl self = this;
        return new ValueFunction<Object, Double>(){

            public Double getValue(Object context, Object d, int index, int groupIndex) {
                return self._totalCenterRadius + self._adjustedDialPadding + (self._adjustedRingWidth + self._adjustedDialPadding) * (double)index;
            }
        };
    }

    private final ValueFunction<Object, ? extends Number> outerRadius() {
        final DialComponentImpl self = this;
        return new ValueFunction<Object, Double>(){

            public Double getValue(Object context, Object d, int index, int groupIndex) {
                return self._totalCenterRadius + (self._adjustedRingWidth + self._adjustedDialPadding) * (double)(index + 1);
            }
        };
    }

    public DialComponentImpl transitionDur(double transitionDur) {
        this._transitionDur = transitionDur;
        return this;
    }

    public DialComponentImpl colorPalette(Palette colorPalette) {
        this._colorPalette = colorPalette;
        return this;
    }

    public DialComponentImpl bounds(RectStruct bounds) {
        this._bounds = bounds;
        return this;
    }

    public DialComponentImpl dialData(DialDatum[] dialData) {
        this._dialData = dialData;
        return this;
    }

    public DialComponentImpl startAngle(double startAngle) {
        if (!Double.isNaN(startAngle)) {
            this._startAngle = startAngle;
        }
        return this;
    }

    public DialComponentImpl maxValue(double maxValue) {
        if (!Double.isNaN(maxValue)) {
            this._maxValue = maxValue;
        }
        return this;
    }

    public DialComponentImpl paddingColor(String paddingColor) {
        if (paddingColor != null) {
            this._paddingColor = paddingColor;
        }
        return this;
    }

    public DialComponentImpl showAsPercentage(boolean showAsPercentage) {
        this._showAsPercentage = showAsPercentage;
        return this;
    }

    public DialComponentImpl firstRender() {
        this._firstRender = true;
        return this;
    }

    public DialComponentImpl roundedEnds(boolean roundedEnds) {
        if (roundedEnds != this._roundedEnds) {
            this._firstRender = true;
        }
        this._roundedEnds = roundedEnds;
        return this;
    }

    public DialComponentImpl backRingColor(String backRingColor) {
        if (backRingColor != null) {
            this._backRingColor = backRingColor;
        }
        return this;
    }

    public DialComponentImpl dialWidth(double dialWidth) {
        if (!Double.isNaN(dialWidth)) {
            this._dialWidth = dialWidth;
        }
        return this;
    }

    public DialComponentImpl dialPadding(double dialPadding) {
        if (!Double.isNaN(dialPadding)) {
            this._dialPadding = dialPadding;
        }
        return this;
    }

    public DialComponentImpl valueSize(double valueSize) {
        if (!Double.isNaN(valueSize)) {
            this._valueSize = valueSize;
        }
        return this;
    }

    public DialComponentImpl valueColor(String valueColor) {
        if (valueColor != null) {
            this._valueColor = valueColor;
        }
        return this;
    }

    public DialComponentImpl valueFont(String valueFont) {
        if (valueFont != null) {
            this._valueFont = valueFont;
        }
        return this;
    }

    public DialComponentImpl minFontSize(double minFontSize) {
        this._minFontSize = minFontSize;
        return this;
    }

    public DialComponentImpl centerRadius(double centerRadius) {
        if (!Double.isNaN(centerRadius)) {
            this._centerRadius = centerRadius;
        }
        return this;
    }

    public DialComponentImpl centerColor(String centerColor) {
        if (centerColor != null) {
            this._centerColor = centerColor;
        }
        return this;
    }

    public DialComponentImpl centerPaddingRadius(double centerPaddingRadius) {
        if (!Double.isNaN(centerPaddingRadius)) {
            this._centerPaddingRadius = centerPaddingRadius;
        }
        return this;
    }

    public DialComponentImpl borderColor(String borderColor) {
        if (borderColor != null) {
            this._borderColor = borderColor;
        }
        return this;
    }

    public DialComponentImpl borderWidth(String borderWidth) {
        if (borderWidth != null) {
            this._borderWidth = borderWidth;
        }
        return this;
    }

    public DialComponentImpl centerBackgroundRadius(double centerBackgroundRadius) {
        if (!Double.isNaN(centerBackgroundRadius)) {
            this._centerBackgroundRadius = centerBackgroundRadius;
        }
        return this;
    }

    public DialComponentImpl proportionalWidths(boolean proportionalWidths) {
        this._proportionalWidths = proportionalWidths;
        return this;
    }

    public DialComponentImpl currentlyReached(String currentlyReached) {
        if (currentlyReached != null) {
            this._currentlyReached = currentlyReached;
        }
        return this;
    }

    public DialComponentImpl valueCustomFormatter(ValueFunction<Object, String> valueformatter) {
        this._valueFormatter = valueformatter;
        return this;
    }

    public DialComponentImpl categoryDial(boolean catDial) {
        this._categoryDial = catDial;
        return this;
    }

    public DialComponentImpl reachedOverTarget(String reachedOverTarget) {
        if (reachedOverTarget != null) {
            this._reachedOverTarget = reachedOverTarget;
        }
        return this;
    }

    private double getMax(Object datum) {
        Object potentialMax = null;
        if (this._maxValueAccessor != null) {
            potentialMax = this._maxValueAccessor.getValue(datum);
        }
        return potentialMax != null ? Math.abs(ObjectConverter.toDouble(potentialMax)) : 0.0;
    }
}

