/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.components;

import com.ibm.rave.bundles.components.BundleComponentImpl;
import com.ibm.rave.bundles.components.ClipPathComponentImpl;
import com.ibm.rave.core.color.RGB;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.selector.Selector;

public class FilterComponentImpl
extends BundleComponentImpl<ClipPathComponentImpl> {
    private final String _id;
    private double offset_x;
    private double offset_y;
    private double blur_radius;
    private RGB color;

    public FilterComponentImpl(String id) {
        this._id = id;
    }

    public void setDropshadow(String offset_x, String offset_y, String radius, RGB rgb) {
        this.offset_x = this.getValue(offset_x);
        this.offset_y = this.getValue(offset_y);
        this.blur_radius = this.getValue(radius);
        this.color = rgb;
    }

    private double getValue(String s) {
        if (s == null) {
            return 0.0;
        }
        return ObjectConverter.toDouble((Object)s.substring(0, s.length() - 2));
    }

    @Override
    protected void execute(Selector g) {
        Selector s = g.selectAll("#" + this._id).data(new Object[]{0});
        Selector filter = s.enter().append("filter").attr("id", (Object)this._id).attr("height", (Object)"500%").attr("width", (Object)"500%");
        filter.append("feGaussianBlur").attr("in", (Object)"SourceAlpha");
        filter.append("feOffset").attr("result", (Object)"offsetBlur");
        filter.append("feFlood");
        filter.append("feComposite").attr("in2", (Object)"offsetBlur").attr("operator", (Object)"in");
        Selector merge = filter.append("feMerge");
        merge.append("feMergeNode");
        merge.append("feMergeNode").attr("in", (Object)"SourceGraphic");
        s.select((Object)"feGaussianBlur").attr("stdDeviation", (Object)this.blur_radius);
        s.select((Object)"feOffset").attr("dx", (Object)this.offset_x).attr("dy", (Object)this.offset_y);
        s.select((Object)"feFlood").attr("flood-color", (Object)(this.color == null ? "black" : this.color));
    }

    @Override
    public String type() {
        return "FilterComponent";
    }

    public String getId() {
        return this._id;
    }
}

