/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.components;

import com.ibm.rave.bundles.component.GridComponent;
import com.ibm.rave.bundles.components.BundleComponentImpl;
import com.ibm.rave.bundles.components.StyleStructs;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.svg.AbstractTickHandler;
import com.ibm.rave.core.svg.Axis;

public class GridComponentImpl
extends BundleComponentImpl<GridComponentImpl>
implements GridComponent {
    private Axis _axis = null;
    private String _role = null;
    private String _orient = "bottom";
    private RectStruct _bounds = null;
    private boolean _displayGridlines = true;
    private StyleStructs.LineStyle _gridlineStyle = new StyleStructs.LineStyle();
    private boolean _renderedShapes = false;

    @Override
    public String type() {
        return "GridComponent";
    }

    @Override
    public String role() {
        return this._role;
    }

    @Override
    protected void execute(Selector g) {
        this.preExecute();
        if (!this._displayGridlines || this._axis == null || this._bounds == null) {
            g.selectAll("*").remove();
            this._renderedShapes = false;
            return;
        }
        this._renderedShapes = true;
        double size = "bottom".equals(this._orient) || "top".equals(this._orient) ? this._bounds.height : this._bounds.width;
        AbstractTickHandler ticksHandler = (AbstractTickHandler)this._axis.ticksHandler();
        double tickSize = this._axis.tickSize();
        double outerTickSize = this._axis.outerTickSize();
        Object tickFormat = this._axis.tickFormat();
        Axis ax = this._axis.tickSize((Object)(-size), (Object)0).tickFormat((Object)"").ticksHandler(null);
        g.call((RunFunction)ax, new Object[0]);
        this._axis.tickSize((Object)tickSize, (Object)outerTickSize).tickFormat(tickFormat).ticksHandler(ticksHandler);
        g.selectAll("g.tick line").classed("grid-tick", true);
        g.selectAll(".grid-tick").style("stroke", (Object)this._gridlineStyle._stroke).style("stroke-dasharray", (Object)this._gridlineStyle._dashArray);
        g.selectAll("path.domain").remove();
    }

    public GridComponentImpl axis(Axis axis) {
        this._axis = axis;
        return this;
    }

    public GridComponentImpl setRole(String role) {
        this._role = role;
        return this;
    }

    public GridComponentImpl orient(String orient) {
        if ("left".equals(orient) || "right".equals(orient) || "bottom".equals(orient) || "top".equals(orient)) {
            this._orient = orient;
        }
        return this;
    }

    public GridComponentImpl bounds(RectStruct bounds) {
        this._bounds = bounds;
        return this;
    }

    @Override
    public GridComponent displayGridlines(boolean displayGridlines) {
        this._displayGridlines = displayGridlines;
        return this;
    }

    @Override
    public GridComponent gridlineStyle(String gridlineColor, String dashArray) {
        this.gridlineColor(gridlineColor);
        this.dashArray(dashArray);
        return this;
    }

    @Override
    public GridComponent gridlineColor(String gridlineColor) {
        this._gridlineStyle._stroke = gridlineColor != null && gridlineColor.length() > 0 ? gridlineColor : null;
        return this;
    }

    @Override
    public GridComponent dashArray(String dashArray) {
        this._gridlineStyle._dashArray = dashArray != null && dashArray.length() > 0 ? dashArray : null;
        return this;
    }

    public String orient() {
        return this._orient;
    }

    public boolean displayGridlines() {
        return this._displayGridlines;
    }

    public String gridlineColor() {
        return this._gridlineStyle._stroke;
    }

    public String dashArray() {
        return this._gridlineStyle._dashArray;
    }

    boolean renderedShapes() {
        return this._renderedShapes;
    }
}

