/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.components;

import com.ibm.rave.bundles.component.IntervalComponent;
import com.ibm.rave.bundles.components.KeyedBundleComponentImpl;
import com.ibm.rave.bundles.utilities.BundleLabelDropper;
import com.ibm.rave.bundles.utilities.ColorUtil;
import com.ibm.rave.bundles.utilities.LabelStyleUtil;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.transition.Transition;
import com.ibm.rave.ext.text.nativeImpl.FontChecker;
import com.ibm.rave.library.framework.internal.CoordinateScaleImpl;
import com.ibm.rave.library.palette.Palette;

public class IntervalComponentImpl
extends KeyedBundleComponentImpl<IntervalComponentImpl>
implements IntervalComponent {
    private Object[] _data;
    private SingleValueFunction<Object, Object> _keyAccessor;
    private SingleValueFunction<Object, Object> _independent1Accessor;
    private SingleValueFunction<Object, Object> _independent2Accessor;
    private CoordinateScaleImpl _independentScale;
    private SingleValueFunction<Object, Object> _dependent1Accessor;
    private SingleValueFunction<Object, Object> _dependent2Accessor;
    private CoordinateScaleImpl _dependentScale;
    private Palette _colorPalette;
    private SingleValueFunction<Object, Object> _labelAccessor;
    private SingleValueFunction<Object, Object> _valueAccessor;
    private ValueFunction<Object, String> _labelFormatter = null;
    private boolean _transpose;
    private boolean _itemLabel;
    private boolean _itemOverlap = true;
    private final BundleLabelDropper _dropOverlap = new BundleLabelDropper();
    private ValueFunction<Object, Integer> _itemLabelPosition = null;
    private String _borderWidth = null;
    private String _borderColor = null;
    private String _labelLayerClass = ".element-label-group";
    private String _elementLayerClass = ".element-group";
    public static final int LABEL_POSITION_TOP = 0;
    public static final int LABEL_POSITION_CENTER = 1;
    public static final int LABEL_POSITION_BOTTOM = 2;
    private String _specialTransition;
    private ValueFunction<Object, Number> _delay = new ValueFunction<Object, Number>(){

        public Number getValue(Object context, Object data, int index, int groupIndex) {
            return 0;
        }
    };
    private OMap<String, Object> _labelFontStyle = new OMap();
    private RectStruct _bounds = null;
    private boolean _labelContrast = false;
    private boolean _labelShadow = false;
    private LabelStyleUtil _labelStyleUtil = new LabelStyleUtil();

    @Override
    public String type() {
        return "IntervalComponent";
    }

    @Override
    protected void execute(Selector g) {
        Selector shapes;
        Selection t;
        boolean labelsOn;
        this.preExecute();
        Selector elementGroupSelector = g.selectAll(this._elementLayerClass);
        Selector elementLabelGroupSelector = g.selectAll(this._labelLayerClass);
        if (g.classed(this._elementLayerClass) || elementGroupSelector.size() == 0 || elementLabelGroupSelector.size() == 0) {
            elementGroupSelector = g;
            elementLabelGroupSelector = g;
        }
        if (this._data == null || this._independent1Accessor == null || this._independent2Accessor == null || this._independentScale == null || this._dependent1Accessor == null || this._dependent2Accessor == null || this._dependentScale == null) {
            elementGroupSelector.selectAll("*").remove();
            elementLabelGroupSelector.selectAll("*").remove();
            return;
        }
        final IntervalComponentImpl self = this;
        Object labelText = this._labelFormatter == null ? new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                if (Math.max(ObjectConverter.toDouble((Object)self._dependentScale.upper(self._dependent1Accessor.getValue(data))), ObjectConverter.toDouble((Object)self._dependentScale.upper(self._dependent2Accessor.getValue(data)))) - Math.min(ObjectConverter.toDouble((Object)self._dependentScale.lower(self._dependent1Accessor.getValue(data))), ObjectConverter.toDouble((Object)self._dependentScale.lower(self._dependent2Accessor.getValue(data)))) < 0.001) {
                    return null;
                }
                return self._labelAccessor.getValue(data);
            }
        } : new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                Object v = self._labelAccessor.getValue(data);
                return v == null ? null : self._labelFormatter.getValue(context, v, index, groupIndex);
            }
        };
        ValueFunction<Object, Object> keyFunction = this._keyAccessor == null ? null : new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object datum, int ix, int gix) {
                return self._keyAccessor.getValue(datum);
            }
        };
        boolean bl = labelsOn = this._itemLabel && this._labelAccessor != null;
        if (!labelsOn) {
            g.selectAll("text.element-label").remove();
        }
        Selector elementSelector = elementGroupSelector.selectAll(".element").data(this._data, this.getKey() != null ? this.getKey() : keyFunction);
        elementSelector.exit().remove();
        Selector elementEnter = elementSelector.enter().append("g").attr("class", (Object)"element");
        elementEnter.append("rect").attr("class", (Object)"element-shape").attr("x", this._specialTransition == null ? this.rectangleCoord(true, true, true) : this.rectangleCoord(true, false, true)).attr("width", this._specialTransition == null ? this.rectangleSize(true, true, true) : this.rectangleSize(true, false, true)).attr("y", this.rectangleCoord(false, true, true)).attr("height", (Object)0).style("fill", (ValueFunction)this._colorPalette);
        if (labelsOn) {
            Selector elementLabelSelector = elementLabelGroupSelector.selectAll(".element-label").data(this._data, this.getKey() != null ? this.getKey() : keyFunction);
            elementLabelSelector.exit().remove();
            elementLabelSelector.enter().append("text").attr("class", (Object)"element-label");
            this.addLabels(elementLabelSelector).text((ValueFunction)labelText);
        }
        if ((t = Rave.transition((Selection)(shapes = elementSelector.select((Object)".element-shape")))) != shapes && this._delay != null) {
            ((Transition)t).delay(this._delay);
        }
        t.style("fill", (ValueFunction)this._colorPalette);
        this.updateBorder(t, this._borderWidth, this._borderColor);
        FontChecker fontChecker = (FontChecker)Rave.capabilities.extension("fontchecker");
        if (this._specialTransition == null) {
            t.attr("x", this.rectangleCoord(true, false, false)).attr("width", this.rectangleSize(true, false, false)).attr("y", this.rectangleCoord(false, false, false)).attr("height", this.rectangleSize(false, false, false));
        } else if (this.isXYanimation()) {
            t.attr("y", this.rectangleCoord(false, false, false)).attr("height", this.rectangleSize(false, false, false)).transition().attr("x", this.rectangleCoord(true, false, false)).attr("width", this.rectangleSize(true, false, false));
        } else {
            t.attr("x", this.rectangleCoord(true, false, false)).attr("width", this.rectangleSize(true, false, false)).transition().attr("y", this.rectangleCoord(false, false, false)).attr("height", this.rectangleSize(false, false, false));
        }
        if (this._renderCallback != null) {
            t.call(this._renderCallback, new Object[]{"elements"});
        }
        if (labelsOn) {
            Selector labels = g.selectAll(".element-label");
            Selection t2 = Rave.transition((Selection)labels);
            if (fontChecker != null) {
                labels.call((RunFunction)fontChecker, new Object[0]);
            }
            if (t2 != labels && this._delay != null) {
                ((Transition)t2).delay(this._delay);
            }
            t2.attr("x", this.getXPosition()).attr("dx", this.getXOffset()).attr("y", this.getYPosition()).attr("dy", this.getYOffset()).style("text-anchor", this.getAnchor());
            final String labelColor = this.getDefaultLabelColor(this._labelFontStyle);
            this._labelStyleUtil.labelFont(this._labelFontStyle).labelFillColor(this._labelContrast ? this.getLabelFill() : new ValueFunction<SceneNode, String>(){

                public String getValue(SceneNode context, Object data, int index, int groupIndex) {
                    return labelColor;
                }
            }).labelShadow(this._labelShadow);
            labels.call((RunFunction)this._labelStyleUtil, new Object[0]);
            t2.text((ValueFunction)labelText);
            this._dropOverlap.configureForDataLabels(this._bounds);
            t2.call((RunFunction)this._dropOverlap, new Object[]{this._itemOverlap});
        }
    }

    private Selector addLabels(Selector s) {
        return s.selectAll("element-label").attr("x", this.rectangleCenter(true, true, true)).attr("y", this.rectangleCenter(false, true, true)).attr("dy", (Object)".3em").style("text-anchor", (Object)"middle");
    }

    private ValueFunction<Object, String> getAnchor() {
        final IntervalComponentImpl self = this;
        return new ValueFunction<Object, String>(){

            public String getValue(Object context, Object data, int index, int groupIndex) {
                if (!self._transpose || self._itemLabelPosition == null) {
                    return "middle";
                }
                Integer labelPosition = (Integer)self._itemLabelPosition.getValue(context, data, index, groupIndex);
                if (0 == labelPosition) {
                    return "start";
                }
                if (1 == labelPosition) {
                    return "middle";
                }
                return "end";
            }
        };
    }

    private ValueFunction<SceneNode, String> getLabelFill() {
        final IntervalComponentImpl self = this;
        final String labelColor = this.getDefaultLabelColor(this._labelFontStyle);
        return new ValueFunction<SceneNode, String>(){

            public String getValue(SceneNode context, Object data, int index, int groupIndex) {
                if (self._itemLabelPosition == null) {
                    return ColorUtil.getContrastColor(self._colorPalette.getValue(context, data, index, groupIndex), labelColor).toString();
                }
                Integer labelPosition = (Integer)self._itemLabelPosition.getValue((Object)context, data, index, groupIndex);
                if (1 == labelPosition) {
                    return ColorUtil.getContrastColor(self._colorPalette.getValue(context, data, index, groupIndex), labelColor).toString();
                }
                return labelColor;
            }
        };
    }

    private ValueFunction<Object, String> getXOffset() {
        final IntervalComponentImpl self = this;
        return new ValueFunction<Object, String>(){

            public String getValue(Object context, Object data, int index, int groupIndex) {
                if (!self._transpose || self._itemLabelPosition == null) {
                    return "0em";
                }
                Integer labelPosition = (Integer)self._itemLabelPosition.getValue(context, data, index, groupIndex);
                if (0 == labelPosition) {
                    return ".3em";
                }
                if (1 == labelPosition) {
                    return "0em";
                }
                return "-.3em";
            }
        };
    }

    private ValueFunction<Object, String> getYOffset() {
        final IntervalComponentImpl self = this;
        return new ValueFunction<Object, String>(){

            public String getValue(Object context, Object data, int index, int groupIndex) {
                if (self._transpose || self._itemLabelPosition == null) {
                    return ".3em";
                }
                Integer labelPosition = (Integer)self._itemLabelPosition.getValue(context, data, index, groupIndex);
                if (0 == labelPosition) {
                    return "-.3em";
                }
                if (1 == labelPosition) {
                    return ".3em";
                }
                return "1.1em";
            }
        };
    }

    private ValueFunction<Object, Number> getXPosition() {
        final IntervalComponentImpl self = this;
        return new ValueFunction<Object, Number>(){

            public Number getValue(Object context, Object data, int index, int groupIndex) {
                if (!self._transpose || self._itemLabelPosition == null) {
                    return (Number)self.rectangleCenter(true, false, false).getValue(context, data, index, groupIndex);
                }
                Integer labelPosition = (Integer)self._itemLabelPosition.getValue(context, data, index, groupIndex);
                if (0 == labelPosition) {
                    return (Number)self.rectangleCoord(true, false, false, true).getValue(context, data, index, groupIndex);
                }
                if (1 == labelPosition) {
                    return (Number)self.rectangleCenter(true, false, false).getValue(context, data, index, groupIndex);
                }
                return (Number)self.rectangleCoord(true, false, false, false).getValue(context, data, index, groupIndex);
            }
        };
    }

    private ValueFunction<Object, Number> getYPosition() {
        final IntervalComponentImpl self = this;
        return new ValueFunction<Object, Number>(){

            public Number getValue(Object context, Object data, int index, int groupIndex) {
                if (self._transpose || self._itemLabelPosition == null) {
                    return (Number)self.rectangleCenter(false, false, false).getValue(context, data, index, groupIndex);
                }
                Integer labelPosition = (Integer)self._itemLabelPosition.getValue(context, data, index, groupIndex);
                if (0 == labelPosition) {
                    return (Number)self.rectangleCoord(false, false, false, false).getValue(context, data, index, groupIndex);
                }
                if (1 == labelPosition) {
                    return (Number)self.rectangleCenter(false, false, false).getValue(context, data, index, groupIndex);
                }
                return (Number)self.rectangleCoord(false, false, false, true).getValue(context, data, index, groupIndex);
            }
        };
    }

    private ValueFunction<Object, Number> rectangleCoord(boolean xdim, boolean fromBase, boolean enter) {
        return this.rectangleCoord(xdim, fromBase, enter, false);
    }

    private ValueFunction<Object, Number> rectangleCoord(boolean xdim, boolean fromBase, boolean enter, final boolean useMax) {
        SingleValueFunction<Object, Object> a2;
        CoordinateScaleImpl scale;
        boolean useDependent = xdim == this._transpose;
        CoordinateScaleImpl coordinateScaleImpl = scale = useDependent ? this._dependentScale : this._independentScale;
        if (fromBase && useDependent && this._dependentScale.isLinear()) {
            final Number value = scale.lower((Object)0.0);
            return new ValueFunction<Object, Number>(){

                public Number getValue(Object context, Object data, int index, int groupIndex) {
                    return value;
                }
            };
        }
        final SingleValueFunction<Object, Object> a1 = useDependent ? this._dependent1Accessor : this._independent1Accessor;
        SingleValueFunction<Object, Object> singleValueFunction = a2 = useDependent ? this._dependent2Accessor : this._independent2Accessor;
        if (enter && this.isCTShandling()) {
            return new ValueFunction<Object, Number>(){

                public Number getValue(Object context, Object data, int index, int groupIndex) {
                    return scale.center(a1.getValue(data));
                }
            };
        }
        return new ValueFunction<Object, Number>(){

            public Number getValue(Object context, Object data, int index, int groupIndex) {
                if (useMax) {
                    return Math.max(ObjectConverter.toDouble((Object)scale.upper(a1.getValue(data))), ObjectConverter.toDouble((Object)scale.upper(a2.getValue(data))));
                }
                return Math.min(ObjectConverter.toDouble((Object)scale.lower(a1.getValue(data))), ObjectConverter.toDouble((Object)scale.lower(a2.getValue(data))));
            }
        };
    }

    private ValueFunction<Object, Number> rectangleSize(boolean xdim, boolean fromBase, boolean enter) {
        CoordinateScaleImpl scale;
        boolean useDependent = xdim == this._transpose;
        CoordinateScaleImpl coordinateScaleImpl = scale = useDependent ? this._dependentScale : this._independentScale;
        if (fromBase && useDependent && this._dependentScale.isLinear() || enter && this.isCTShandling()) {
            return new ValueFunction<Object, Number>(){

                public Number getValue(Object context, Object data, int index, int groupIndex) {
                    return 0.001;
                }
            };
        }
        final SingleValueFunction<Object, Object> a1 = useDependent ? this._dependent1Accessor : this._independent1Accessor;
        final SingleValueFunction<Object, Object> a2 = useDependent ? this._dependent2Accessor : this._independent2Accessor;
        return new ValueFunction<Object, Number>(){

            public Number getValue(Object context, Object data, int index, int groupIndex) {
                return Math.max(0.001, Math.max(ObjectConverter.toDouble((Object)scale.upper(a1.getValue(data))), ObjectConverter.toDouble((Object)scale.upper(a2.getValue(data)))) - Math.min(ObjectConverter.toDouble((Object)scale.lower(a1.getValue(data))), ObjectConverter.toDouble((Object)scale.lower(a2.getValue(data)))));
            }
        };
    }

    private final boolean isXYanimation() {
        return "XY_CTS".equals(this._specialTransition) || "XY_STC".equals(this._specialTransition);
    }

    private final boolean isCTShandling() {
        return "XY_CTS".equals(this._specialTransition) || "YX_CTS".equals(this._specialTransition);
    }

    private ValueFunction<Object, Number> rectangleCenter(boolean xdim, boolean fromBase, boolean enter) {
        SingleValueFunction<Object, Object> a2;
        CoordinateScaleImpl scale;
        boolean useDependent = xdim == this._transpose;
        CoordinateScaleImpl coordinateScaleImpl = scale = useDependent ? this._dependentScale : this._independentScale;
        if (fromBase && useDependent && this._dependentScale.isLinear()) {
            final Number value = scale.lower((Object)0.0);
            return new ValueFunction<Object, Number>(){

                public Number getValue(Object context, Object data, int index, int groupIndex) {
                    return value;
                }
            };
        }
        final SingleValueFunction<Object, Object> a1 = useDependent ? this._dependent1Accessor : this._independent1Accessor;
        SingleValueFunction<Object, Object> singleValueFunction = a2 = useDependent ? this._dependent2Accessor : this._independent2Accessor;
        if (enter && this.isCTShandling()) {
            return new ValueFunction<Object, Number>(){

                public Number getValue(Object context, Object data, int index, int groupIndex) {
                    return ObjectConverter.toDouble((Object)scale.center(a1.getValue(data)));
                }
            };
        }
        return new ValueFunction<Object, Number>(){

            public Number getValue(Object context, Object data, int index, int groupIndex) {
                double val = (Math.max(ObjectConverter.toDouble((Object)scale.upper(a1.getValue(data))), ObjectConverter.toDouble((Object)scale.upper(a2.getValue(data)))) + Math.min(ObjectConverter.toDouble((Object)scale.lower(a1.getValue(data))), ObjectConverter.toDouble((Object)scale.lower(a2.getValue(data))))) / 2.0;
                if (Double.isNaN(val)) {
                    val = 0.0;
                }
                return val;
            }
        };
    }

    public IntervalComponentImpl data(Object[] data) {
        this._data = data;
        return this;
    }

    public IntervalComponentImpl keyAccessor(SingleValueFunction<Object, Object> keyAccessor) {
        this._keyAccessor = keyAccessor;
        return this;
    }

    public IntervalComponentImpl independent1Accessor(SingleValueFunction<Object, Object> independent1Accessor) {
        this._independent1Accessor = independent1Accessor;
        return this;
    }

    public IntervalComponentImpl independent2Accessor(SingleValueFunction<Object, Object> independent2Accessor) {
        this._independent2Accessor = independent2Accessor;
        return this;
    }

    public IntervalComponentImpl independentScale(CoordinateScaleImpl independentScale) {
        this._independentScale = independentScale;
        return this;
    }

    public IntervalComponentImpl dependent1Accessor(SingleValueFunction<Object, Object> dependent1Accessor) {
        this._dependent1Accessor = dependent1Accessor;
        return this;
    }

    public IntervalComponentImpl dependent2Accessor(SingleValueFunction<Object, Object> dependent2Accessor) {
        this._dependent2Accessor = dependent2Accessor;
        return this;
    }

    public IntervalComponentImpl dependentScale(CoordinateScaleImpl dependentScale) {
        this._dependentScale = dependentScale;
        return this;
    }

    public IntervalComponentImpl colorPalette(Palette colorPalette) {
        this._colorPalette = colorPalette;
        return this;
    }

    public IntervalComponentImpl labelAccessor(SingleValueFunction<Object, Object> labelAccessor) {
        this._labelAccessor = labelAccessor;
        return this;
    }

    public IntervalComponentImpl labelFormatter(ValueFunction<Object, String> labelFormatter) {
        this._labelFormatter = labelFormatter;
        return this;
    }

    public IntervalComponentImpl transpose(boolean transpose) {
        this._transpose = transpose;
        return this;
    }

    @Override
    public IntervalComponent itemLabel(boolean itemLabel) {
        this._itemLabel = itemLabel;
        return this;
    }

    @Override
    public IntervalComponent itemLabelPosition(ValueFunction<Object, Integer> labelPosition) {
        this._itemLabelPosition = labelPosition;
        return this;
    }

    @Override
    public IntervalComponent itemOverlap(boolean _itemOverlap) {
        this._itemOverlap = _itemOverlap;
        return this;
    }

    public IntervalComponentImpl valueAccessor(SingleValueFunction<Object, Object> valueAccessor) {
        this._valueAccessor = valueAccessor;
        return this;
    }

    public IntervalComponentImpl specialTransition(String specialTransition) {
        this._specialTransition = specialTransition;
        return this;
    }

    public IntervalComponentImpl delay(ValueFunction<Object, Number> delayFunction) {
        this._delay = delayFunction;
        return this;
    }

    @Override
    public IntervalComponent borderWidth(String width) {
        this._borderWidth = width;
        return this;
    }

    @Override
    public IntervalComponent borderColor(String color) {
        this._borderColor = color;
        return this;
    }

    public IntervalComponentImpl labelFont(OMap<String, Object> labelFontStyle) {
        this._labelFontStyle = labelFontStyle;
        return this;
    }

    @Override
    public IntervalComponentImpl bounds(RectStruct bounds) {
        this._bounds = bounds;
        return this;
    }

    @Override
    public IntervalComponentImpl labelLayerClassName(String className) {
        this._labelLayerClass = className;
        return this;
    }

    @Override
    public IntervalComponentImpl elementLayerClassName(String className) {
        this._elementLayerClass = className;
        return this;
    }

    public IntervalComponentImpl labelContrast(boolean labelContrast) {
        this._labelContrast = labelContrast;
        return this;
    }

    public IntervalComponentImpl labelShadow(boolean labelShadow) {
        this._labelShadow = labelShadow;
        return this;
    }
}

