/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.components;

import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.internal.collections.OSet;
import com.ibm.rave.core.internal.nativeImpl.NumberFormatHelper;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.library.framework.internal.BundleDatum;
import java.util.ArrayList;
import java.util.List;

public class IntervalDataUtilities {
    public static final SingleValueFunction<Object, Object> CALLOUT_DEPENDENT_ACCESSOR = new SingleValueFunction<Object, Object>(){

        public Object getValue(Object data) {
            return ((IntervalData)data).cdep;
        }
    };
    public static final SingleValueFunction<Object, Object> CALLOUT_INDEPENDENT_ACCESSOR = new SingleValueFunction<Object, Object>(){

        public Object getValue(Object data) {
            return ((IntervalData)data).cind;
        }
    };
    public static final SingleValueFunction<Object, Object> VALUE_ACCESSOR = new SingleValueFunction<Object, Object>(){

        public Object getValue(Object data) {
            return ((IntervalData)data).value;
        }
    };
    public static final SingleValueFunction<Object, Object> PERCENT_OF_CATEGORY_ACCESSOR = new SingleValueFunction<Object, Object>(){

        public Object getValue(Object data) {
            double percent = ((IntervalData)data).valueAsPercentOfCategory;
            return Double.isNaN(percent) ? "" : NumberFormatHelper.toFixed((double)percent, (int)1) + "%";
        }
    };
    public static final SingleValueFunction<Object, Object> PERCENT_OF_COLOR_ACCESSOR = new SingleValueFunction<Object, Object>(){

        public Object getValue(Object data) {
            double percent = ((IntervalData)data).valueAsPercentOfColor;
            return Double.isNaN(percent) ? "" : NumberFormatHelper.toFixed((double)percent, (int)1) + "%";
        }
    };

    public static ArrayEx<IntervalData> simpleBars(ArrayEx<Object> data, final SingleValueFunction<Object, Object> x, final SingleValueFunction<Object, Object> xScale, final SingleValueFunction<Object, Object> y, final SingleValueFunction<Object, Object> yStart, final SingleValueFunction<Object, Object> color, final SingleValueFunction<Object, Object> label) {
        double value;
        IntervalData iData;
        int i;
        final ArrayEx result = new ArrayEx();
        if (data == null || data.size() == 0 || x == null || y == null) {
            return result;
        }
        data.forEach((ArrayEx.ArrayValueFunction)new ArrayEx.ArrayValueFunction<Object, Object>(){

            public Object getValue(Object d, int ix, ArrayEx<Object> list) {
                Object xv = x.getValue(d);
                if (xv != null && (xScale == null || xScale.getValue(xv) != null)) {
                    Integer yvStart;
                    Object yv = y.getValue(d);
                    Integer n = yvStart = yStart == null ? Integer.valueOf(0) : yStart.getValue(d);
                    if (yv != null && yvStart != null) {
                        IntervalData r = new IntervalData();
                        r.key = ix;
                        r.ind2 = r.ind1 = xv;
                        r.cind = r.ind1;
                        r.dep1 = yvStart;
                        r.cdep = r.dep2 = yv;
                        r.color = color != null ? color.getValue(d) : null;
                        r.label = label != null ? label.getValue(d) : null;
                        r.value = r.dep2;
                        r._originalData = d;
                        r.valueAsPercentOfCategory = 100.0;
                        result.add((Object)r);
                    }
                }
                return null;
            }
        });
        double sum = 0.0;
        for (i = 0; i < result.size(); ++i) {
            iData = (IntervalData)result.get(i);
            value = ObjectConverter.toDouble((Object)iData.value);
            sum += Math.abs(value);
        }
        if (sum != 0.0) {
            for (i = 0; i < result.size(); ++i) {
                iData = (IntervalData)result.get(i);
                value = ObjectConverter.toDouble((Object)iData.value);
                iData.valueAsPercentOfColor = value / sum * 100.0;
            }
        }
        return result;
    }

    public static ArrayEx<IntervalData> clusteredBars(ArrayEx<Object> data, final ArrayEx<SingleValueFunction<Object, Object>> x, final ArrayEx<SingleValueFunction<Object, Object>> xScale, final SingleValueFunction<Object, Object> y, final SingleValueFunction<Object, Object> yStart, final SingleValueFunction<Object, Object> color, final SingleValueFunction<Object, Object> label) {
        double value;
        IntervalData iData;
        int i;
        double sum;
        String s;
        final ArrayEx result = new ArrayEx();
        if (data == null || data.size() == 0 || x == null || x.size() == 0 || y == null) {
            return result;
        }
        final int len = x.size();
        final OSet categories = new OSet();
        final OSet colors = new OSet();
        data.forEach((ArrayEx.ArrayValueFunction)new ArrayEx.ArrayValueFunction<Object, Object>(){

            public Object getValue(Object d, int ix, ArrayEx<Object> list) {
                Integer depStart;
                boolean OK = true;
                ArrayList<Object> ind = new ArrayList<Object>();
                for (int i = 0; i < len; ++i) {
                    Object xv = ((SingleValueFunction)x.get(i)).getValue(d);
                    if (xv == null || xScale.get(i) != null && ((SingleValueFunction)xScale.get(i)).getValue(xv) == null) {
                        OK = false;
                        break;
                    }
                    ind.add(xv);
                    if (i == 0) {
                        if (categories.contains(xv)) continue;
                        categories.add((Object)ObjectConverter.toString((Object)xv));
                        continue;
                    }
                    if (colors.contains(xv)) continue;
                    colors.add((Object)ObjectConverter.toString((Object)xv));
                }
                Object dep = y.getValue(d);
                Integer n = depStart = yStart == null ? Integer.valueOf(0) : yStart.getValue(d);
                if (OK && dep != null && depStart != null) {
                    IntervalData r = new IntervalData();
                    r.key = ix;
                    r.ind1 = ind;
                    r.ind2 = ind;
                    r.cind = ind;
                    r.dep1 = depStart;
                    r.cdep = r.dep2 = dep;
                    r.color = color != null ? color.getValue(d) : null;
                    r.label = label != null ? label.getValue(d) : null;
                    r.value = r.dep2;
                    r._originalData = d;
                    result.add((Object)r);
                }
                return null;
            }
        });
        for (Object o : categories.toArray()) {
            s = ObjectConverter.toString((Object)o);
            sum = 0.0;
            for (i = 0; i < result.size(); ++i) {
                iData = (IntervalData)result.get(i);
                if (!s.equals(((ArrayList)iData.ind1).get(0))) continue;
                value = ObjectConverter.toDouble((Object)iData.value);
                sum += Math.abs(value);
            }
            if (sum == 0.0) continue;
            for (i = 0; i < result.size(); ++i) {
                iData = (IntervalData)result.get(i);
                if (!s.equals(((ArrayList)iData.ind1).get(0))) continue;
                value = ObjectConverter.toDouble((Object)iData.value);
                iData.valueAsPercentOfCategory = value / sum * 100.0;
            }
        }
        for (Object o : colors.toArray()) {
            s = ObjectConverter.toString((Object)o);
            sum = 0.0;
            for (i = 0; i < result.size(); ++i) {
                iData = (IntervalData)result.get(i);
                if (!s.equals(iData.color)) continue;
                value = ObjectConverter.toDouble((Object)iData.value);
                sum += Math.abs(value);
            }
            if (sum == 0.0) continue;
            for (i = 0; i < result.size(); ++i) {
                iData = (IntervalData)result.get(i);
                if (!s.equals(iData.color)) continue;
                value = ObjectConverter.toDouble((Object)iData.value);
                iData.valueAsPercentOfColor = value / sum * 100.0;
            }
        }
        return result;
    }

    public static ArrayEx<IntervalData> stackedBars(ArrayEx<Object> data, final SingleValueFunction<Object, Object> x, final SingleValueFunction<Object, Object> xScale, final SingleValueFunction<Object, Object> y, final SingleValueFunction<Object, Object> color, final SingleValueFunction<Object, Object> label, final boolean percent) {
        double value;
        IntervalData iData;
        int i;
        double sum;
        String s;
        final ArrayEx result = new ArrayEx();
        if (data == null || data.size() == 0 || x == null || y == null) {
            return result;
        }
        final OMap stacks = new OMap();
        final OSet categories = new OSet();
        final OSet colors = new OSet();
        data.forEach((ArrayEx.ArrayValueFunction)new ArrayEx.ArrayValueFunction<Object, Object>(){

            public Object getValue(Object d, int ix, ArrayEx<Object> list) {
                Object yv;
                Object xv = x.getValue(d);
                if (xv != null && (xScale == null || xScale.getValue(xv) != null) && (yv = y.getValue(d)) != null) {
                    Object o;
                    Stack stack = (Stack)stacks.get(xv);
                    if (stack == null) {
                        stack = new Stack();
                        stacks.put(xv, (Object)stack);
                    }
                    double dVal = ObjectConverter.toDouble((Object)yv);
                    if (!percent) {
                        IntervalData r = new IntervalData();
                        r.key = ix;
                        r.ind1 = xv;
                        r.ind2 = xv;
                        r.cind = xv;
                        double sum = dVal < 0.0 ? stack.negativeSum : stack.positiveSum;
                        r.dep1 = sum;
                        r.cdep = r.dep2 = Double.valueOf(sum + dVal);
                        r.color = color != null ? color.getValue(d) : null;
                        r.label = label != null ? label.getValue(d) : null;
                        r.value = dVal;
                        r._originalData = d;
                        result.add((Object)r);
                    }
                    if (dVal < 0.0) {
                        stack.negativeSum += dVal;
                    } else {
                        ++stack.positiveCount;
                        stack.positiveSum += dVal;
                    }
                    if (!categories.contains(xv)) {
                        categories.add((Object)ObjectConverter.toString((Object)xv));
                    }
                    if (color != null && (o = color.getValue(d)) != null && !colors.contains(o)) {
                        colors.add((Object)ObjectConverter.toString((Object)o));
                    }
                }
                return null;
            }
        });
        if (percent) {
            data.forEach((ArrayEx.ArrayValueFunction)new ArrayEx.ArrayValueFunction<Object, Object>(){

                public Object getValue(Object d, int ix, ArrayEx<Object> list) {
                    Object yv;
                    Object xv = x.getValue(d);
                    if (xv != null && (xScale == null || xScale.getValue(xv) != null) && (yv = y.getValue(d)) != null) {
                        Stack stack = (Stack)stacks.get(xv);
                        double dVal = ObjectConverter.toDouble((Object)yv);
                        double percent = dVal < 0.0 ? -100.0 * dVal / stack.negativeSum : (stack.positiveSum > 0.0 ? 100.0 * dVal / stack.positiveSum : 100.0 / (double)stack.positiveCount);
                        IntervalData r = new IntervalData();
                        r.key = ix;
                        r.ind1 = xv;
                        r.ind2 = xv;
                        r.cind = xv;
                        double sum = dVal < 0.0 ? stack.negativePercent : stack.positivePercent;
                        r.dep1 = sum;
                        r.cdep = r.dep2 = Double.valueOf(sum + percent);
                        r.color = color != null ? color.getValue(d) : null;
                        r.label = label != null ? label.getValue(d) : null;
                        r.value = dVal;
                        r.valueAsPercentOfCategory = percent;
                        r._originalData = d;
                        result.add((Object)r);
                        if (dVal < 0.0) {
                            stack.negativePercent += percent;
                        } else {
                            stack.positivePercent += percent;
                        }
                    }
                    return null;
                }
            });
        } else {
            for (Object o : categories.toArray()) {
                s = ObjectConverter.toString((Object)o);
                sum = 0.0;
                for (i = 0; i < result.size(); ++i) {
                    iData = (IntervalData)result.get(i);
                    if (!s.equals(iData.ind1)) continue;
                    value = ObjectConverter.toDouble((Object)iData.value);
                    sum += Math.abs(value);
                }
                if (sum == 0.0) continue;
                for (i = 0; i < result.size(); ++i) {
                    iData = (IntervalData)result.get(i);
                    if (!s.equals(iData.ind1)) continue;
                    value = ObjectConverter.toDouble((Object)iData.value);
                    iData.valueAsPercentOfCategory = value / sum * 100.0;
                }
            }
        }
        for (Object o : colors.toArray()) {
            s = ObjectConverter.toString((Object)o);
            sum = 0.0;
            for (i = 0; i < result.size(); ++i) {
                iData = (IntervalData)result.get(i);
                if (!s.equals(iData.color)) continue;
                value = ObjectConverter.toDouble((Object)iData.value);
                sum += Math.abs(value);
            }
            if (sum == 0.0) continue;
            for (i = 0; i < result.size(); ++i) {
                iData = (IntervalData)result.get(i);
                if (!s.equals(iData.color)) continue;
                value = ObjectConverter.toDouble((Object)iData.value);
                iData.valueAsPercentOfColor = value / sum * 100.0;
            }
        }
        return result;
    }

    private static class Stack {
        int positiveCount = 0;
        double positiveSum = 0.0;
        double negativeSum = 0.0;
        double positivePercent = 0.0;
        double negativePercent = 0.0;
    }

    public static class IntervalData
    implements BundleDatum {
        public Object key;
        public Object ind1;
        public Object ind2;
        public Object dep1;
        public Object dep2;
        public Object value;
        public double valueAsPercentOfCategory = Double.NaN;
        public double valueAsPercentOfColor = Double.NaN;
        public Object color;
        public Object label;
        public Object cind;
        public Object cdep;
        public Object _originalData;

        public Object originalData() {
            return this._originalData;
        }

        public List<Object> originalDataList() {
            ArrayEx list = new ArrayEx();
            list.add(this._originalData);
            return list;
        }
    }
}

