/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.components;

import com.ibm.rave.bundles.component.LabelCollisionComponent;
import com.ibm.rave.bundles.components.BundleComponentImpl;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.geom.Point;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.CallbackFunction;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.ext.position.RavePosition;
import com.ibm.rave.ext.position.drop.DropOverlap;
import com.ibm.rave.ext.position.place.AnchorPoint;
import com.ibm.rave.ext.position.place.LabelBox;
import com.ibm.rave.ext.position.place.LabelPositioning;
import java.util.ArrayList;

public class LabelCollisionComponentImpl
extends BundleComponentImpl<LabelCollisionComponentImpl>
implements LabelCollisionComponent {
    @InlineStringConstant
    public static final String MOVE_LABELS = "Move Labels";
    @InlineStringConstant
    public static final String DROP_LABELS = "Drop Labels";
    @InlineStringConstant
    public static final String NONE = "none";
    private String _labelClass = ".element-label";
    private String _handleLabelCollisions;
    private LabelPositioning _labelPositioning = null;
    private RectStruct _bounds;
    private int _numberOfSweeps = 1000;

    @Override
    protected void execute(Selector chart) {
        Selector labels = chart.selectAll(this._labelClass);
        if (this._handleLabelCollisions.equals(MOVE_LABELS)) {
            this.resolveLabelCollisions(labels);
        } else if (this._handleLabelCollisions.equals(DROP_LABELS)) {
            this.dropLabels(labels);
        } else {
            this.resetLabels(labels);
        }
    }

    @Override
    public String type() {
        return "LabelCollisionComponent";
    }

    private void resetLabels(Selector labels) {
        RavePosition position = (RavePosition)Rave.capabilities.extension("position");
        position.drop().reset((Selection)labels);
    }

    private void dropLabels(Selector labels) {
        RavePosition position = (RavePosition)Rave.capabilities.extension("position");
        DropOverlap drop = position.drop();
        if (this._bounds != null) {
            Point[] ex = new Point[]{new Point(this._bounds.x, this._bounds.y), new Point(this._bounds.x + this._bounds.width, this._bounds.y + this._bounds.height)};
            drop.extent(ex);
        }
        drop.remove(false);
        drop.noClipping();
        drop.dropOverlap((Selection)labels);
    }

    private void resolveLabelCollisions(final Selector labels) {
        final LabelCollisionComponentImpl self = this;
        final ArrayList labelBoxes = new ArrayList();
        final ArrayList anchorPoints = new ArrayList();
        labels.each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode context, Object data, int index, int groupIndex) {
                LabelBox labelBox = new LabelBox();
                labelBox.x = ObjectConverter.toDouble((Object)context.getAttribute("x"));
                labelBox.y = ObjectConverter.toDouble((Object)context.getAttribute("y"));
                labelBox.width = ObjectConverter.toDouble((double)context.getBBox().width);
                labelBox.height = ObjectConverter.toDouble((double)context.getBBox().height);
                labelBoxes.add(labelBox);
                AnchorPoint anchorPoint = new AnchorPoint();
                anchorPoint.x = labelBox.x;
                anchorPoint.y = labelBox.y;
                anchorPoint.r = 5.0;
                anchorPoints.add(anchorPoint);
            }
        });
        labels.data(labelBoxes.toArray());
        RavePosition position = (RavePosition)Rave.capabilities.extension("position");
        RunFunction<LabelPositioning.EventObject> repositionLabels = new RunFunction<LabelPositioning.EventObject>(){

            public Object run(LabelPositioning.EventObject context, Object ... args) {
                if (self._handleLabelCollisions.equals(LabelCollisionComponentImpl.MOVE_LABELS)) {
                    labels.transition().duration((Object)110).attr("x", (ValueFunction)new ValueFunction<Object, Object>(){

                        public Object getValue(Object context, Object data, int index, int groupIndex) {
                            return ((LabelBox)data).x;
                        }
                    }).attr("y", (ValueFunction)new ValueFunction<Object, Object>(){

                        public Object getValue(Object context, Object data, int index, int groupIndex) {
                            return ((LabelBox)data).y;
                        }
                    });
                }
                return context;
            }
        };
        this._labelPositioning = position.place().label(labelBoxes);
        this._labelPositioning.anchor(anchorPoints).width(this._bounds.width).height(this._bounds.height).numberOfSweeps(this._numberOfSweeps).start().on("tick", (RunFunction)repositionLabels);
    }

    public LabelCollisionComponentImpl labelClassName(String className) {
        this._labelClass = className;
        return this;
    }

    public LabelCollisionComponentImpl labelResolution(String resolve) {
        this._handleLabelCollisions = resolve;
        if (this._labelPositioning != null && this._handleLabelCollisions != null) {
            this._labelPositioning.stop();
        }
        return this;
    }

    public LabelCollisionComponentImpl bounds(RectStruct bounds) {
        this._bounds = bounds;
        return this;
    }

    public LabelCollisionComponentImpl numberOfSweeps(int numberOfSweeps) {
        this._numberOfSweeps = numberOfSweeps;
        return this;
    }
}

