/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.components;

import com.ibm.rave.bundles.component.LegendComponent;
import com.ibm.rave.bundles.components.BundleComponentImpl;
import com.ibm.rave.bundles.utilities.FontPropertyParser;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.geom.Dim;
import com.ibm.rave.core.geom.Insets;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.ext.legend.AbstractLegend;
import com.ibm.rave.ext.legend.RaveLegend;
import com.ibm.rave.ext.legend.continuous.ContinuousLegend;
import com.ibm.rave.ext.legend.swatch.SwatchLegend;
import com.ibm.rave.ext.text.nativeImpl.FontChecker;
import com.ibm.rave.library.palette.Palette;
import java.util.List;

public class LegendComponentImpl
extends BundleComponentImpl<LegendComponentImpl>
implements LegendComponent {
    private boolean _visible = true;
    private Dim _size = null;
    private Palette _colorPalette = null;
    private String _orient = "horizontal";
    private double _swatchSize = 256.0;
    private ValueFunction<Object, Object> _swatchSizeFunc = null;
    private AbstractScale<?, ?> _scale = null;
    private String _shape = "square";
    private String _title = null;
    private OMap<String, Object> _titleStyle = new OMap();
    private OMap<String, Object> _entryStyle = new OMap();
    private ValueFunction<Object, String> _labelFormat = null;
    private SwatchLegend _swatchLegend = null;
    private ContinuousLegend _continuousLegend = null;
    private String _legendType = null;
    @InlineStringConstant
    static final String HORIZONTAL = "horizontal";
    @InlineStringConstant
    static final String VERTICAL = "vertical";
    public static final String TOP = "top";
    public static final String BOTTOM = "bottom";
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final double ADJUSTABLE = -1.0;
    private static final double BAR_THINKNESS = 16.0;
    private static final double SWATCH_SIZE = 16.0;

    @Override
    public String type() {
        return "LegendComponent";
    }

    @Override
    protected void execute(Selector g) {
        if (this._colorPalette != null) {
            if ("continuous".equals(this._colorPalette.getType())) {
                if (this._continuousLegend == null) {
                    this._continuousLegend = ((RaveLegend)Rave.capabilities.extension("legend")).continuous();
                }
                this._legendType = "ContinuousLegend";
            } else {
                if (this._swatchLegend == null) {
                    this._swatchLegend = ((RaveLegend)Rave.capabilities.extension("legend")).swatch();
                }
                this._legendType = "SwatchLegend";
            }
        } else if (this._swatchSizeFunc != null) {
            if (this._swatchLegend == null) {
                this._swatchLegend = ((RaveLegend)Rave.capabilities.extension("legend")).swatch();
            }
            this._legendType = "SwatchLegend";
        } else {
            this._legendType = null;
        }
        this.preExecute();
        if (!this._visible || this._colorPalette == null && this._swatchSizeFunc == null || this._size == null || this._size.getWidth() <= 0.0 || this._size.getHeight() <= 0.0) {
            g.selectAll("*").remove();
            return;
        }
        FontChecker fontChecker = (FontChecker)Rave.capabilities.extension("fontchecker");
        if (this._colorPalette != null && "continuous".equals(this._colorPalette.getType())) {
            ((ContinuousLegend)((ContinuousLegend)((ContinuousLegend)((ContinuousLegend)((ContinuousLegend)((ContinuousLegend)((ContinuousLegend)((ContinuousLegend)this._continuousLegend.shapeRectSize(HORIZONTAL.equals(this._orient) ? new Dim(-1.0, 16.0) : new Dim(16.0, -1.0)).size(this._size)).scale(this._colorPalette.getScale())).orient(this._orient)).title(this._title)).titleFill((String)this._titleStyle.get((Object)"fill"))).titleFontSize((String)this._titleStyle.get((Object)"font-size"))).titleFontFamily((String)this._titleStyle.get((Object)"font-Family"))).titleAlignment("start")).labelFormat(this._labelFormat);
            Selector legend = g.call((RunFunction)this._continuousLegend, new Object[0]);
            if (this._entryStyle != null) {
                legend.selectAll(".legendLabel").style(this._entryStyle);
            }
            if (this._titleStyle != null) {
                legend.selectAll(".legendTitle").style(this._titleStyle);
            }
            if (fontChecker != null) {
                legend.selectAll(".legendLabel").call((RunFunction)fontChecker, new Object[0]);
                legend.selectAll(".legendTitle").call((RunFunction)fontChecker, new Object[0]);
            }
        } else {
            Insets insets = new Insets();
            insets.bottom = 5;
            ValueFunction<Object, Object> swatchSize = Double.valueOf(this._swatchSize);
            AbstractScale<?, ?> scale = null;
            ValueFunction labelFormatter = this._labelFormat;
            if (this._swatchSizeFunc != null && this._scale != null) {
                swatchSize = this._swatchSizeFunc;
                scale = this._scale;
            }
            if (this._colorPalette != null) {
                scale = this._colorPalette.getScale();
                List originalDomain = this._colorPalette.originalDomain();
                if (originalDomain != null) {
                    scale.domain(originalDomain);
                    final ValueFunction f = this._colorPalette.originalDomainLabelAccessor();
                    if (this._labelFormat != null) {
                        final LegendComponentImpl self = this;
                        labelFormatter = new ValueFunction<Object, String>(){

                            @SwiftMethodOverload(skipParameters={1})
                            public String getValue(Object context, Object data, int index, int groupIndex) {
                                return (String)self._labelFormat.getValue(context, f.getValue(context, data, index, groupIndex), index, groupIndex);
                            }
                        };
                    } else {
                        labelFormatter = f;
                    }
                }
            }
            ((SwatchLegend)((SwatchLegend)((SwatchLegend)((SwatchLegend)((SwatchLegend)((SwatchLegend)((SwatchLegend)((SwatchLegend)((SwatchLegend)((SwatchLegend)this._swatchLegend.labelPadding((Object)8)).size(this._size)).scale(scale)).orient(this._orient)).swatchSize(swatchSize).shape((Object)this._shape).title(this._title)).titleFill((String)this._titleStyle.get((Object)"fill"))).titleFontSize((String)this._titleStyle.get((Object)"font-size"))).titleFontFamily((String)this._titleStyle.get((Object)"font-family"))).titleAlignment("start")).labelFormat(labelFormatter)).titleInsets(insets);
            Selector legend = g.call((RunFunction)this._swatchLegend, new Object[0]);
            if (this._entryStyle != null) {
                legend.selectAll(".legendLabel").style(this._entryStyle);
            }
            if (this._titleStyle != null) {
                legend.selectAll(".legendTitle").style(this._titleStyle);
            }
            if (fontChecker != null) {
                legend.selectAll(".legendLabel").call((RunFunction)fontChecker, new Object[0]);
                legend.selectAll(".legendTitle").call((RunFunction)fontChecker, new Object[0]);
            }
        }
    }

    @Override
    public final AbstractLegend<?> legend() {
        if ("ContinuousLegend".equals(this._legendType)) {
            return this._continuousLegend;
        }
        if ("SwatchLegend".equals(this._legendType)) {
            return this._swatchLegend;
        }
        return null;
    }

    @Override
    public final String legendType() {
        return this._legendType;
    }

    public LegendComponentImpl visible(boolean visible) {
        this._visible = visible;
        return this;
    }

    public final boolean isVisible() {
        return this._visible;
    }

    public LegendComponentImpl size(Dim size) {
        this._size = size;
        return this;
    }

    public LegendComponentImpl colorPalette(Palette colorPalette) {
        this._colorPalette = colorPalette;
        return this;
    }

    public final LegendComponentImpl orient(String orient) {
        if (HORIZONTAL.equals(orient) || VERTICAL.equals(orient)) {
            this._orient = orient;
        }
        return this;
    }

    public LegendComponentImpl position(String position) {
        return this.orient(LegendComponentImpl.orientationOf(position));
    }

    public static String orientationOf(String position) {
        if (TOP.equals(position) || BOTTOM.equals(position)) {
            return HORIZONTAL;
        }
        return VERTICAL;
    }

    @Override
    public final LegendComponent swatchSize(double swatchSize) {
        if (swatchSize >= 0.0 && Double.valueOf(swatchSize) != null) {
            this._swatchSize = swatchSize;
        }
        return this;
    }

    @Override
    public LegendComponent scale(AbstractScale<?, ?> scale) {
        this._scale = scale;
        return this;
    }

    @Override
    public final LegendComponent swatchSize(ValueFunction<Object, Object> swatchSize) {
        if (swatchSize != null) {
            this._swatchSizeFunc = swatchSize;
        }
        return this;
    }

    @Override
    public final LegendComponent shape(String shape) {
        this._shape = shape;
        return this;
    }

    @Override
    public LegendComponent title(String title) {
        this._title = title != null && title.length() > 0 ? title : null;
        return this;
    }

    @Override
    public LegendComponent titleFill(String titleFill) {
        this._titleStyle.put((Object)"fill", (Object)titleFill);
        return this;
    }

    @Override
    public LegendComponent titleFontSize(String titleFontSize) {
        this._titleStyle.put((Object)"font-size", (Object)titleFontSize);
        return this;
    }

    @Override
    public LegendComponent titleFontFamily(String titleFontFamily) {
        this._titleStyle.put((Object)"font-family", (Object)titleFontFamily);
        return this;
    }

    @Override
    public LegendComponent labelFormat(ValueFunction<Object, String> labelFormat) {
        this._labelFormat = labelFormat;
        return this;
    }

    @Override
    public LegendComponent titleFont(String titleFontStyle) {
        this._titleStyle = FontPropertyParser.parseCSSFont(titleFontStyle);
        return this;
    }

    @Override
    public LegendComponent entryFont(String entryFontStyle) {
        this._entryStyle = FontPropertyParser.parseCSSFont(entryFontStyle);
        return this;
    }

    public double getSpaceUsed() {
        if (this._colorPalette != null && "continuous".equals(this._colorPalette.getType())) {
            return this._continuousLegend.getUsedSize() + 2.0;
        }
        return this._swatchLegend.getUsedSize() + 2.0;
    }
}

