/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.components;

import com.ibm.rave.bundles.component.ChartLayoutSizable;
import com.ibm.rave.bundles.components.ChartLayoutComponentImpl;
import com.ibm.rave.bundles.components.LegendComponentImpl;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.geom.Dim;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.library.datamodel.DataSlotEntry;
import com.ibm.rave.library.framework.ComponentCallback;
import com.ibm.rave.library.framework.internal.AbstractView;
import com.ibm.rave.library.framework.internal.BundleContext;
import com.ibm.rave.library.palette.Palette;

public class LegendsManager
implements ChartLayoutSizable {
    private final BundleContext _context;
    private final int _numLegends;
    private final LegendComponentImpl _comp;
    private boolean[] _visible;
    private RectStruct _rectangle;
    private String _orient;
    private boolean _doTransition;
    private int _duration;
    private ComponentCallback _preExecute;
    private final Selector[] _selectors;
    private final Palette[] _palettes;
    private final AbstractScale<?, ?>[] _scale;
    private final ValueFunction<Object, Object>[] _swatchSizes;
    private final String[] _shapes;
    private final String[] _titles;
    private final String[] _titleFonts;
    private final String[] _titleFills;
    private final String[] _titleFontSizes;
    private final String[] _titleFontFamilies;
    private final String[] _entryFonts;
    private ValueFunction<Object, String>[] _formatters;
    private final boolean[] _lastVisible;
    private DataSlotEntry[] _dataSlotEntries;
    private double _spaceUsed;

    public LegendsManager(BundleContext context, int numLegends) {
        this._context = context;
        this._numLegends = numLegends;
        this._comp = new LegendComponentImpl();
        this._rectangle = new RectStruct(0.0, 0.0, 0.0, 0.0);
        this._orient = "vertical";
        this._preExecute = null;
        this._selectors = new Selector[this._numLegends];
        this._palettes = new Palette[this._numLegends];
        this._scale = new AbstractScale[this._numLegends];
        this._swatchSizes = new ValueFunction[this._numLegends];
        this._shapes = new String[this._numLegends];
        this._titles = new String[this._numLegends];
        this._titleFonts = new String[this._numLegends];
        this._titleFills = new String[this._numLegends];
        this._titleFontSizes = new String[this._numLegends];
        this._titleFontFamilies = new String[this._numLegends];
        this._entryFonts = new String[this._numLegends];
        this._formatters = new ValueFunction[this._numLegends];
        this._lastVisible = new boolean[this._numLegends];
        this._visible = new boolean[this._numLegends];
        this._dataSlotEntries = new DataSlotEntry[this._numLegends];
        for (int i = 0; i < this._numLegends; ++i) {
            this._selectors[i] = null;
            this._palettes[i] = null;
            this._swatchSizes[i] = null;
            this._shapes[i] = null;
            this._titles[i] = null;
            this._formatters[i] = null;
            this._lastVisible[i] = false;
            this._visible[i] = true;
        }
    }

    LegendComponentImpl getLegendComponent() {
        return this._comp;
    }

    public final LegendsManager visible(int legendIndex, boolean visible) {
        if (legendIndex < this._visible.length) {
            this._visible[legendIndex] = visible;
        }
        return this;
    }

    public final LegendsManager visible(boolean visible) {
        for (int i = 0; i < this._visible.length; ++i) {
            this._visible[i] = visible;
        }
        return this;
    }

    public final LegendsManager rectangle(RectStruct rect) {
        if (rect != null) {
            this._rectangle = new RectStruct(rect.x, rect.y, rect.width, rect.height);
        }
        return this;
    }

    public final LegendsManager orient(String orient) {
        if ("horizontal".equals(orient) || "vertical".equals(orient)) {
            this._orient = orient;
        }
        return this;
    }

    public final LegendsManager position(String position) {
        return this.orient(LegendComponentImpl.orientationOf(position));
    }

    public final LegendsManager transition(boolean doTransition, int duration) {
        this._doTransition = doTransition;
        this._duration = duration >= 0 ? duration : 0;
        return this;
    }

    public final LegendsManager setPreExecute(ComponentCallback callback) {
        this._preExecute = callback;
        return this;
    }

    public final LegendsManager selector(int index, Selector selector) {
        if (index >= 0 && index < this._numLegends) {
            this._selectors[index] = selector;
        }
        return this;
    }

    public final LegendsManager palette(int index, Palette palette) {
        if (index >= 0 && index < this._numLegends) {
            this._palettes[index] = palette;
        }
        return this;
    }

    public final LegendsManager shape(int index, String shape) {
        if (index >= 0 && index < this._numLegends) {
            this._shapes[index] = shape;
        }
        return this;
    }

    public final LegendsManager title(int index, String title) {
        if (index >= 0 && index < this._numLegends) {
            this._titles[index] = title;
        }
        return this;
    }

    public final LegendsManager titleFont(int index, String titleFont) {
        if (index >= 0 && index < this._numLegends) {
            this._titleFonts[index] = titleFont;
        }
        return this;
    }

    public final LegendsManager entryFont(int index, String entryFont) {
        if (index >= 0 && index < this._numLegends) {
            this._entryFonts[index] = entryFont;
        }
        return this;
    }

    public final LegendsManager titleFill(int index, String titleFill) {
        if (index >= 0 && index < this._numLegends) {
            this._titleFills[index] = titleFill;
        }
        return this;
    }

    public final LegendsManager titleFontSize(int index, String titleFontSize) {
        if (index >= 0 && index < this._numLegends) {
            this._titleFontSizes[index] = titleFontSize;
        }
        return this;
    }

    public final LegendsManager titleFontFamily(int index, String titleFontFamily) {
        if (index >= 0 && index < this._numLegends) {
            this._titleFontFamilies[index] = titleFontFamily;
        }
        return this;
    }

    public final LegendsManager scale(int index, AbstractScale<?, ?> scale) {
        if (index >= 0 && index < this._numLegends) {
            this._scale[index] = scale;
        }
        return this;
    }

    public final LegendsManager swatchSize(int index, ValueFunction<Object, Object> swatchSize) {
        if (index >= 0 && index < this._numLegends) {
            this._swatchSizes[index] = swatchSize;
        }
        return this;
    }

    public final LegendsManager formatterList(int index, ArrayEx<DataSlotEntry> entries, String format, ValueFunction<Object, String> defaultFunction) {
        if (index >= 0 && index < this._numLegends) {
            this._formatters[index] = this._context.getCustomFormatterWithFlag(new String[]{"legend", "all"}, BundleContext.makeCustomFormatInfo((String)"legend-label", (String)"ROLE_NONE", (String)format, entries), defaultFunction, false);
        }
        return this;
    }

    public final LegendsManager formatter(int index, DataSlotEntry entry) {
        ArrayEx entries = new ArrayEx();
        if (entry != null) {
            entries.add((Object)entry);
        }
        return this.formatterList(index, (ArrayEx<DataSlotEntry>)entries, "none", null);
    }

    public final boolean anyVisible() {
        for (int i = 0; i < this._numLegends; ++i) {
            if (!this._visible[i] || this._palettes[i] == null && this._swatchSizes[i] == null) continue;
            return true;
        }
        return false;
    }

    public final LegendsManager setDataSlot(int index, DataSlotEntry entry) {
        if (index >= 0 && index < this._numLegends) {
            this._dataSlotEntries[index] = entry;
        }
        return this.formatter(index, entry);
    }

    public LegendsManager preLayout(ChartLayoutComponentImpl layoutComponent) {
        this.preLayout(layoutComponent, true);
        return this;
    }

    public LegendsManager preLayout(ChartLayoutComponentImpl layoutComponent, boolean axesBeforeLegend) {
        int i;
        boolean layoutTransition = this._doTransition;
        int layoutDuration = this._duration;
        this._doTransition = false;
        this._duration = 0;
        String[] children = new String[this._numLegends];
        for (int i2 = 0; i2 < this._numLegends; ++i2) {
            children[i2] = "g.layoutLegend-" + i2;
        }
        AbstractView.createGroupStructure((Selector)this._context.node.select((Object)"g.legends-layout"), (String[])children);
        Selector[] layoutSelectors = new Selector[this._numLegends];
        boolean[] layoutLastVisible = new boolean[this._numLegends];
        for (i = 0; i < this._numLegends; ++i) {
            layoutSelectors[i] = this._selectors[i];
            layoutLastVisible[i] = this._lastVisible[i];
            this._lastVisible[i] = false;
            if (this._selectors[i] == null) continue;
            this._selectors[i] = this._context.node.select((Object)("g.layoutLegend-" + i));
        }
        layoutComponent.preLayout(true, !axesBeforeLegend);
        this.rectangle(layoutComponent.legendRect());
        this.draw();
        this._doTransition = layoutTransition;
        this._duration = layoutDuration;
        this._context.node.select((Object)"g.legends-layout").selectAll("*").remove();
        for (i = 0; i < this._numLegends; ++i) {
            this._lastVisible[i] = layoutLastVisible[i];
            this._selectors[i] = layoutSelectors[i];
        }
        return this;
    }

    public final LegendsManager draw() {
        Dim size;
        double dy;
        double dx;
        int nVisible = 0;
        for (int i = 0; i < this._numLegends; ++i) {
            if (this._swatchSizes[i] == null && this._palettes[i] == null || !this._visible[i]) continue;
            ++nVisible;
        }
        double x = this._rectangle.x;
        double y = this._rectangle.y;
        if (nVisible == 0) {
            dx = 0.0;
            dy = 0.0;
            size = new Dim(this._rectangle.width, this._rectangle.height);
        } else if ("horizontal".equals(this._orient)) {
            dx = this._rectangle.width / (double)nVisible;
            dy = 0.0;
            size = new Dim(dx, this._rectangle.height);
        } else {
            dx = 0.0;
            dy = this._rectangle.height / (double)nVisible;
            size = new Dim(this._rectangle.width, dy);
        }
        this._comp.orient(this._orient).size(size);
        this._spaceUsed = 0.0;
        for (int i = 0; i < this._numLegends; ++i) {
            if (this._selectors[i] != null) {
                boolean visible = this._visible[i] && (this._palettes[i] != null || this._swatchSizes[i] != null);
                ((LegendComponentImpl)this._comp.visible(visible).colorPalette(this._palettes[i]).orient(this._orient).setPreExecute(this._preExecute)).shape(this._shapes[i] != null ? this._shapes[i] : "square").title(this._titles[i]).titleFill(this._titleFills[i]).titleFontSize(this._titleFontSizes[i]).titleFontFamily(this._titleFontFamilies[i]).labelFormat(this._formatters[i]).swatchSize(this._swatchSizes[i]).scale(this._scale[i]);
                String fontStyle = (String)this._context.getPropertyValue("legend.titlestyle.font");
                if (this._titleFonts[i] != null && !this._titleFonts[i].equals("")) {
                    this._comp.titleFont(this._titleFonts[i]);
                } else if (fontStyle != null && !fontStyle.equals("")) {
                    this._comp.titleFont((String)this._context.getPropertyValue("legend.titlestyle.font"));
                }
                fontStyle = (String)this._context.getPropertyValue("legend.entrystyle.font");
                if (this._entryFonts[i] != null) {
                    this._comp.entryFont(this._entryFonts[i]);
                } else if (fontStyle != null && !fontStyle.equals("")) {
                    this._comp.entryFont((String)this._context.getPropertyValue("legend.entrystyle.font"));
                }
                Selector s = this._doTransition && this._lastVisible[i] ? this._selectors[i].transition("transition").duration((Object)this._duration) : this._selectors[i];
                s.attr("transform", (Object)("translate(" + x + "," + y + ")")).call((RunFunction)this._comp, new Object[0]);
                ArrayEx dataSlotEntries = new ArrayEx();
                if (this._dataSlotEntries[i] != null) {
                    dataSlotEntries.push((Object[])new DataSlotEntry[]{this._dataSlotEntries[i]});
                }
                this._selectors[i].selectAll(".legendTitle").property("dataSlots", (Object)dataSlotEntries);
                if (visible) {
                    x += dx;
                    y += dy;
                    if (this._comp.getSpaceUsed() > this._spaceUsed) {
                        this._spaceUsed = this._comp.getSpaceUsed();
                    }
                }
                this._lastVisible[i] = visible;
                continue;
            }
            this._lastVisible[i] = false;
        }
        return this;
    }

    @Override
    public int getSizableType() {
        return 2;
    }

    @Override
    public String getSizableOrientation() {
        return this._orient;
    }

    @Override
    public double getPreferredSize() {
        return this._spaceUsed;
    }

    @Override
    public double getSpillOverSize() {
        return 0.0;
    }
}

