/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.components;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.bundles.components.KeyedBundleComponentImpl;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.color.RGB;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geo.BasicProjection;
import com.ibm.rave.core.geo.GeoPathGenerator;
import com.ibm.rave.core.geo.Projection;
import com.ibm.rave.core.geom.Dim;
import com.ibm.rave.core.geom.Point;
import com.ibm.rave.core.geom.RaveRect;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.EventQueue;
import com.ibm.rave.core.nativeImpl.arrays.ES6Map;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.util.Runnable;
import com.ibm.rave.ext.position.RavePosition;
import com.ibm.rave.ext.position.drop.DropOverlap;
import com.ibm.rave.ext.position.place.LabelPositioning;
import com.ibm.rave.library.palette.Palette;
import java.util.List;

public class MapComponentImpl
extends KeyedBundleComponentImpl<MapComponentImpl> {
    public static final String albersUsa = "albersUsa";
    public static final String albers = "albers";
    public static final String azimuthalEqualArea = "azimuthalEqualArea";
    public static final String azimuthalEquidistant = "azimuthalEquidistant";
    public static final String conicConformal = "conicConformal";
    public static final String conicEqualArea = "conicEqualArea";
    public static final String conicEquidistant = "conicEquidistant";
    public static final String equirectangular = "equirectangular";
    public static final String gnomonic = "gnomonic";
    public static final String mercator = "mercator";
    public static final String orthographic = "orthographic";
    public static final String stereoGraphic = "stereoGraphic";
    public static final String transverseMercator = "transverseMercator";
    public static final String winkelTriple = "winkelTriple";
    private static final String MAP_COMPONENT = "MapComponent";
    Selector _chart;
    private String _geoJSONfeatureIdLookup;
    String[] _featureIdFieldArray;
    private double _scale;
    private double _minScale;
    private final Dim _translation;
    private JSONObject _geoJSONObject;
    private RectStruct _bounds;
    private boolean _featureLabel = true;
    private boolean _prevFeatureLabel = true;
    private ValueFunction<Object, String> _labelFormatter = null;
    private String _projectionType;
    private String _handleLabelCollisions;
    private boolean _isAlbersUsa = false;
    private final LabelPositioning _labelPositioning = null;
    private DropOverlap _labelDropper = null;
    private boolean _dropLabels = false;
    private double _rotationLongitude = 0.0;
    private double _rotationLatitude = 0.0;
    private Projection _projection = null;
    private boolean _projectionChanged = true;
    private boolean _boundsChanged = true;
    private boolean _dataChanged = true;
    private double _baseScale;
    private boolean _panZoom;
    private boolean _panY;
    private boolean _panX;
    private boolean _defaultPanZoom;
    private Dim _zoomExtent;
    private String _borderWidth;
    private String _borderColor;
    private String _bubbleBorderWidth;
    private String _bubbleBorderColor;
    private Object[] _regionsAndBubblesData;
    private SingleValueFunction<Object, Object> _featureId;
    private SingleValueFunction<Object, Object> _bubbleColor;
    private SingleValueFunction<Object, Object> _bubbleSize;
    private SingleValueFunction<Object, Object> _featureLbl;
    private AbstractScale<?, ?> _bubbleScale;
    private double _defaultBubbleSize;
    private Palette _bubblePalette;
    private Palette _regionPalette;
    private String _nullColor;
    private final double LABEL_PADDING = 2.0;
    private OMap<String, ArrayEx<Double>> _centroidCache = new OMap();
    private OMap<String, JSONArray> _coordinateCache = new OMap();
    private double[] _mapPan;
    private final ES6Map<String, String> _regionFillCache;
    private final ES6Map<String, Boolean> _darkCache;
    private GeoPathGenerator _cachedPathGenerator;
    private Number _regionAnimationDuration;
    private Number _bubbleAnimationDuration;
    private Number _flashDuration;
    private Boolean _flash;
    private Boolean _regionAnimationNeeded;
    private ES6Map<String, Double> dataChangedRegions;
    private Selector _features;
    private ES6Map<String, Object> _dataMap;
    private Selector bubbleLabelRegionSelector;
    private OMap<String, RaveRect> textBBoxCache;
    private Boolean _regionAnimationEnabled;
    private Boolean _bubbleAnimationEnabled;

    public boolean is_defaultPanZoom() {
        return this._defaultPanZoom;
    }

    public boolean is_GraphicalPan() {
        return this._panZoom;
    }

    public boolean panX() {
        return this._panX;
    }

    public boolean panY() {
        return this._panY;
    }

    public double baseScale() {
        return this._baseScale;
    }

    public void baseScale(double bScale) {
        double _bScale = bScale;
        if (_bScale < 0.0) {
            _bScale = 0.0;
        }
        this._baseScale = _bScale;
        this.projectionChanged(true);
    }

    public static MapComponentImpl create() {
        return new MapComponentImpl();
    }

    public MapComponentImpl() {
        this._scale = Double.NaN;
        this._regionFillCache = ES6Map.create();
        this._darkCache = ES6Map.create();
        this._labelDropper = ((RavePosition)Rave.capabilities.extension("position")).drop();
        this._mapPan = new double[2];
        this._mapPan[1] = 0.0;
        this._mapPan[0] = 0.0;
        this._translation = new Dim(0.0, 0.0);
        this._regionAnimationNeeded = true;
        this._borderWidth = null;
        this._borderColor = null;
        this._bubbleBorderWidth = null;
        this._bubbleBorderColor = null;
    }

    @Override
    public String type() {
        return MAP_COMPONENT;
    }

    @Override
    protected void execute(Selector g) {
        this._chart = g;
        if (this._dataChanged || this._projectionChanged || this._boundsChanged || Double.isNaN(this._scale)) {
            this._mapPan[1] = 0.0;
            this._mapPan[0] = 0.0;
            this.textBBoxCache = new OMap();
            this._coordinateCache = new OMap();
            this._featureIdFieldArray = this._geoJSONfeatureIdLookup.split("\\.");
            this._dataMap = this.prepareData((JSONArray)this._geoJSONObject.get((Object)"features"));
            this.dataChangedRegions = ES6Map.create();
            this._bubbleAnimationDuration = this._bubbleAnimationEnabled != false ? (Number)this._bubbleAnimationDuration : (Number)0;
            this._regionAnimationDuration = this._regionAnimationEnabled != false ? (Number)this._regionAnimationDuration : (Number)0;
            this.addFeatures();
            this.removeFeatures();
            this._projection = this.centerProjection();
            this._chart.attr("transform", (Object)"translate(0, 0)");
            this.recalculateCentroidsOnAction();
        }
        this.updateFeatures();
        this._regionAnimationNeeded = true;
        this.projectionChanged(false);
        this._boundsChanged = false;
        this._dataChanged = false;
    }

    private Projection centerProjection() {
        double[] center = Rave.geo.centroid(this._geoJSONObject);
        this._projection = this.createProjection();
        if (Double.isNaN(this._scale)) {
            GeoPathGenerator pathGen;
            this._projection.scale((Object)1.0).translate(new ArrayEx((Object[])new Double[]{0.0, 0.0}));
            if (!this._isAlbersUsa) {
                this._projection.center(new ArrayEx((Object[])new Double[]{center[0], center[1]}));
            }
            this._cachedPathGenerator = pathGen = Rave.geo.path().projection((BasicProjection)this._projection);
            double[][] geoBounds = pathGen.bounds(this._geoJSONObject);
            double geoWidth = Math.abs(geoBounds[1][0] - geoBounds[0][0]);
            double geoHeight = Math.abs(geoBounds[1][1] - geoBounds[0][1]);
            this._scale = 0.95 / Math.max(geoWidth / this._bounds.width, geoHeight / this._bounds.height);
            this._translation.setWidth(this._bounds.x + (this._bounds.width - this._scale * (geoBounds[1][0] + geoBounds[0][0])) / 2.0);
            this._translation.setHeight(this._bounds.y + (this._bounds.height - this._scale * (geoBounds[1][1] + geoBounds[0][1])) / 2.0);
        }
        this._projection.scale((Object)this._scale).translate(new ArrayEx((Object[])new Double[]{this._translation.getWidth(), this._translation.getHeight()}));
        if (!this._isAlbersUsa) {
            this._projection.center(new ArrayEx((Object[])new Double[]{center[0], center[1]}));
        }
        this._zoomExtent.setHeight(this._zoomExtent.getHeight() * this._scale);
        this._zoomExtent.setWidth(this._zoomExtent.getWidth() * this._scale);
        this._minScale = this._baseScale = this._scale;
        return this._projection;
    }

    private void addFeatures() {
        final MapComponentImpl self = this;
        this._features = this._chart.selectAll("g.element-shape").data((List)((JSONArray)this._geoJSONObject.get((Object)"features")));
        this._features.enter().append("g").attr("class", (ValueFunction)new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                String classes = "element-shape ";
                String featureId = self.findGeoJSONId((JSONObject)data);
                classes = classes + self.classFromFeatureId(featureId);
                return classes;
            }
        }).append("path").attr("class", (Object)"element-shape-path").style("opacity", (Object)0);
        this.bubbleLabelRegionSelector = this._chart.selectAll(".region").data(this._dataMap.values(), (ValueFunction)new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return self._featureId.getValue(data);
            }
        });
        Selector gEnter = this.bubbleLabelRegionSelector.enter().append("g").attr("class", (Object)"region");
        gEnter.append("circle").attr("cx", (Object)0).attr("cy", (Object)0).attr("r", (Object)0).attr("class", (ValueFunction)new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                String featureId = ObjectConverter.toString((Object)self._featureId.getValue(data));
                self.dataChangedRegions.set((Object)featureId, (Object)0.0);
                return "bubble " + self.classFromFeatureId(featureId);
            }
        });
        if (this._featureLabel) {
            this.createLabels(gEnter);
        }
        Selector paths = this._features.select((Object)"path");
        final int[] count = new int[]{paths.size()};
        Number animationDuration = this._regionAnimationNeeded != false ? (Number)this._regionAnimationDuration : (Number)0;
        paths.transition("Path_Elements").duration((Object)animationDuration).style("opacity", (Object)1).each("end", (RunFunction)new RunFunction<SceneNode>(){

            public Object run(SceneNode context, Object ... args) {
                count[0] = count[0] - 1;
                if (count[0] == 0 && self._flash.booleanValue() && self._flashDuration.intValue() > 0) {
                    self.flashRegionsAndBubble();
                }
                return null;
            }
        });
        this._features.select((Object)"path").classed("flash", false).attr("fill", (ValueFunction)new ValueFunction<SceneNode, Object>(){

            public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                String featureId = self.findGeoJSONId((JSONObject)context.getParentNode().getData());
                Object d = self._dataMap.get((Object)featureId);
                if (d != null) {
                    return self._regionPalette.getValue(context, d, index, groupIndex);
                }
                return self._nullColor;
            }
        }).style("stroke", (Object)this._borderColor).style("stroke-width", (Object)this._borderWidth);
        this.bubbleLabelRegionSelector.select((Object)"circle").classed("flash", false).attr("fill", (ValueFunction)new ValueFunction<SceneNode, Object>(){

            public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                return self._bubblePalette == null ? null : self._bubblePalette.getValue(context, data, index, groupIndex);
            }
        }).style("stroke", (Object)this._bubbleBorderColor).style("stroke-width", (Object)this._bubbleBorderWidth).transition("BUBBLES_TRANSITION").duration((Object)this._bubbleAnimationDuration).ease("bounce", new Object[0]).attr("r", (ValueFunction)new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                double result = self.getFinalRadius(data);
                String featureId = ObjectConverter.toString((Object)self._featureId.getValue(data));
                if (self.dataChangedRegions.has((Object)featureId) && (Double)self.dataChangedRegions.get((Object)featureId) == 0.0) {
                    return result;
                }
                if (ObjectConverter.toDouble((Object)((SceneNode)context).getAttribute("r")) != result && !self.dataChangedRegions.has((Object)featureId)) {
                    self.dataChangedRegions.set((Object)featureId, (Object)result);
                }
                return result;
            }
        });
    }

    private void createLabels(Selector bubbleSelector) {
        final MapComponentImpl self = this;
        Object labelText = null;
        if (this._featureLbl != null) {
            labelText = this._labelFormatter == null ? new ValueFunction<Object, Object>(){

                public Object getValue(Object context, Object data, int index, int groupIndex) {
                    return self._featureLbl.getValue(data);
                }
            } : new ValueFunction<Object, Object>(){

                public Object getValue(Object context, Object data, int index, int groupIndex) {
                    Object v = self._featureLbl.getValue(data);
                    return v == null ? null : self._labelFormatter.getValue(context, v, index, groupIndex);
                }
            };
        }
        bubbleSelector.append("text").attr("x", (Object)"0").attr("y", (Object)"0").text((ValueFunction)labelText).attr("class", (ValueFunction)new ValueFunction<SceneNode, String>(){

            public String getValue(SceneNode context, Object data, int index, int groupIndex) {
                String featureId = ObjectConverter.toString((Object)self._featureId.getValue(data));
                String c = "label " + self.classFromFeatureId(featureId);
                c = c + (self.isDarkBackground(featureId) ? " light-label" : " dark-label");
                return c;
            }
        }).style("opacity", (Object)0);
    }

    private void updateFeatures() {
        final GeoPathGenerator pathGenerator = this._cachedPathGenerator != null ? this._cachedPathGenerator : Rave.geo.path().projection((BasicProjection)this._projection);
        final MapComponentImpl self = this;
        this._features.select((Object)"path").attr("d", (ValueFunction)pathGenerator);
        this.bubbleLabelRegionSelector.select((Object)"circle").attr("transform", (ValueFunction)new ValueFunction<SceneNode, Object>(){

            public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                ArrayEx center = self.getCentroidLargestPolygon(ObjectConverter.toString((Object)self._featureId.getValue(data)), pathGenerator);
                if (center == null) {
                    return "translate(-1000,-1000)";
                }
                return "translate(" + ObjectConverter.toDouble((Object)center.get(0)) + ", " + ObjectConverter.toDouble((Object)center.get(1)) + ")";
            }
        });
        if (this._featureLabel && !this._prevFeatureLabel) {
            this.createLabels(this._chart.selectAll(".region"));
        }
        if (this._featureLabel) {
            this.bubbleLabelRegionSelector.selectAll("text").attr("transform", (ValueFunction)new ValueFunction<SceneNode, Object>(){

                public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                    String featureId = ObjectConverter.toString((Object)self._featureId.getValue(data));
                    ArrayEx center = self.getTextCenter(featureId, context, pathGenerator, self.getFinalRadius(data));
                    if (center == null) {
                        return "translate(-1000,-1000)";
                    }
                    return "translate(" + center.get(0) + ", " + center.get(1) + ")";
                }
            }).attr("visibility", null).transition().duration((Object)this._bubbleAnimationDuration).style("opacity", (Object)1);
            if (this._dropLabels) {
                this._labelDropper.dropOverlap((Selection)this._chart.selectAll("text.label"));
            }
        } else {
            this.bubbleLabelRegionSelector.selectAll("text").remove();
        }
        this._prevFeatureLabel = this._featureLabel;
    }

    private void removeFeatures() {
        Number animationDuration = this._regionAnimationNeeded != false ? (Number)this._regionAnimationDuration : (Number)0;
        this._features.exit().select((Object)"path").transition().duration((Object)animationDuration).style("opacity", (Object)0);
        this._features.exit().transition().duration((Object)animationDuration).remove();
        this.bubbleLabelRegionSelector.exit().selectAll("circle").transition().duration((Object)this._bubbleAnimationDuration).attr("r", (Object)0);
        this.bubbleLabelRegionSelector.exit().selectAll("text").transition().duration((Object)this._bubbleAnimationDuration).style("opacity", (Object)0);
        this.bubbleLabelRegionSelector.exit().transition().duration((Object)this._bubbleAnimationDuration).remove();
    }

    private void flashRegionsAndBubble() {
        final MapComponentImpl self = this;
        final ArrayEx valid = new ArrayEx();
        for (String key : this.dataChangedRegions.keys()) {
            if (!((Double)this.dataChangedRegions.get((Object)key) > 0.0)) continue;
            valid.add((Object)key);
        }
        if (valid.size() == 0) {
            return;
        }
        EventQueue.setTimeout((Runnable)new Runnable(){

            public void run() {
                self._chart.selectAll("path").classed("flash", (ValueFunction)new ValueFunction<SceneNode, Boolean>(){

                    public Boolean getValue(SceneNode context, Object data, int index, int groupIndex) {
                        Selector parent = Rave.select((SceneNode)context.getParentNode());
                        String featureId = self.findGeoJSONId((JSONObject)parent.datum());
                        return valid.contains((Object)featureId);
                    }
                });
                self._chart.selectAll("circle").classed("flash", (ValueFunction)new ValueFunction<SceneNode, Boolean>(){

                    public Boolean getValue(SceneNode context, Object data, int index, int groupIndex) {
                        String featureId = ObjectConverter.toString((Object)self._featureId.getValue(data));
                        return valid.contains((Object)featureId);
                    }
                });
                String[] selStr = new String[]{"path.flash", "circle.flash"};
                String[] width = new String[]{self._borderWidth, self._bubbleBorderWidth};
                String[] color = new String[]{self._borderColor, self._bubbleBorderColor};
                for (int i = 0; i < 2; ++i) {
                    final Selector flash = self._chart.selectAll(selStr[i]);
                    final String strokeWidth = width[i];
                    final String strokeColor = color[i];
                    final int[] count = new int[]{flash.size()};
                    flash.style("stroke-width", (Object)"2px").style("stroke", null).transition().duration((Object)self._flashDuration).style("stroke-width", (Object)strokeWidth).style("stroke", (Object)strokeColor).each("end", (RunFunction)new RunFunction<SceneNode>(){

                        public Object run(SceneNode context, Object ... args) {
                            count[0] = count[0] - 1;
                            if (count[0] == 0) {
                                flash.style("stroke-width", (Object)"2px").style("stroke", null).transition().duration((Object)self._flashDuration).style("stroke-width", (Object)strokeWidth).style("stroke", (Object)strokeColor);
                            }
                            return null;
                        }
                    });
                }
            }
        }, (int)ObjectConverter.toInt((Object)this._bubbleAnimationDuration));
    }

    private double getFinalRadius(Object data) {
        if (this._bubbleScale != null && this._bubbleSize != null) {
            Object v = this._bubbleSize.getValue(data);
            return v != null ? ObjectConverter.toDouble((Object)this._bubbleScale.getValue(null, v, 0, 0)) : 0.0;
        }
        if (this._bubbleColor != null) {
            return this._defaultBubbleSize;
        }
        return 0.0;
    }

    private ES6Map<String, Object> prepareData(JSONArray geoRegions) {
        ArrayEx regionIds = new ArrayEx();
        for (Object region : geoRegions) {
            regionIds.add((Object)this.findGeoJSONId((JSONObject)region));
        }
        ES6Map dataMap = ES6Map.create();
        for (int i = 0; i < this._regionsAndBubblesData.length; ++i) {
            Object d = this._regionsAndBubblesData[i];
            String id = ObjectConverter.toString((Object)this._featureId.getValue(d));
            if (!regionIds.contains((Object)id)) continue;
            dataMap.set((Object)id, d);
        }
        return dataMap;
    }

    private boolean isDarkBackground(String featureId) {
        Boolean dark;
        String color = (String)this._regionFillCache.get((Object)featureId);
        if (color == null) {
            Selector feature = this._chart.select((Object)("." + this.classFromFeatureId(featureId) + " > path"));
            color = ObjectConverter.toString((Object)feature.attr("fill"));
            this._regionFillCache.set((Object)featureId, (Object)color);
        }
        if ((dark = (Boolean)this._darkCache.get((Object)color)) == null) {
            Double DARK_THRESHOLD = 127.5;
            RGB rgb = Rave.rgb((Object)color);
            Double brightness = (double)rgb.getR() * 0.299 + (double)rgb.getG() * 0.587 + (double)rgb.getB() * 0.114;
            dark = brightness <= DARK_THRESHOLD;
            this._darkCache.set((Object)color, (Object)dark);
        }
        return dark;
    }

    private ArrayEx<Double> getTextCenter(String featureId, SceneNode context, GeoPathGenerator pathGenerator, double radius) {
        ArrayEx<Double> centroid;
        RaveRect textBBox = (RaveRect)this.textBBoxCache.get((Object)featureId);
        if (textBBox == null) {
            textBBox = context.getBBox();
            this.textBBoxCache.put((Object)featureId, (Object)textBBox);
        }
        if ((centroid = this.getCentroidLargestPolygon(featureId, pathGenerator)) == null) {
            return null;
        }
        ArrayEx textCenter = new ArrayEx((Object[])new Double[]{textBBox.width, textBBox.height});
        ArrayEx center = new ArrayEx();
        double localRadius = radius;
        if (localRadius > 0.0) {
            localRadius += 2.0;
        }
        center.add(0, (Object)((Double)centroid.get(0) - (Double)textCenter.get(0) / 2.0));
        center.add(1, (Object)((Double)centroid.get(1) + (Double)textCenter.get(1) / 2.0 + localRadius));
        return center;
    }

    public Projection createProjection() {
        this._isAlbersUsa = false;
        this._cachedPathGenerator = null;
        this._projection = null;
        if (this._projectionType != null) {
            if (albersUsa.equals(this._projectionType)) {
                this._isAlbersUsa = true;
                this._projection = Rave.geo.albersUsa();
            } else if (albers.equals(this._projectionType)) {
                this._projection = Rave.geo.albers();
            } else if (azimuthalEqualArea.equals(this._projectionType)) {
                this._projection = Rave.geo.azimuthalEqualArea.create();
            } else if (azimuthalEquidistant.equals(this._projectionType)) {
                this._projection = Rave.geo.azimuthalEquidistant.create();
            } else if (conicConformal.equals(this._projectionType)) {
                this._projection = Rave.geo.conicConformal.create();
            } else if (conicEqualArea.equals(this._projectionType)) {
                this._projection = Rave.geo.conicEqualArea.create();
            } else if (conicEquidistant.equals(this._projectionType)) {
                this._projection = Rave.geo.conicEquidistant.create();
            } else if (equirectangular.equals(this._projectionType)) {
                this._projection = Rave.geo.equirectangular.create();
            } else if (gnomonic.equals(this._projectionType)) {
                this._projection = Rave.geo.gnomonic.create();
            } else if (mercator.equals(this._projectionType)) {
                this._projection = Rave.geo.mercator.create();
            } else if (orthographic.equals(this._projectionType)) {
                this._projection = Rave.geo.orthographic.create();
            } else if (stereoGraphic.equals(this._projectionType)) {
                this._projection = Rave.geo.stereographic.create().clipAngle((Object)160);
            } else if (transverseMercator.equals(this._projectionType)) {
                this._projection = Rave.geo.transverseMercator.create();
            } else if (winkelTriple.equals(this._projectionType)) {
                this._projection = Rave.geo.winkel3.create();
            }
        }
        if (this._projection == null) {
            this._projection = Rave.geo.mercator.create();
        }
        if (!this._isAlbersUsa) {
            this._projection.rotate(new ArrayEx((Object[])new Double[]{this._rotationLongitude, this._rotationLatitude, 0.0}));
        }
        return this._projection;
    }

    private String classFromFeatureId(String featureId) {
        String fid = "id" + featureId;
        fid = fid.replaceAll("\\W+", "");
        return fid;
    }

    private final String findGeoJSONId(JSONObject jsonFeature) {
        int i;
        JSONObject _jsonFeature = jsonFeature;
        for (i = 0; i < this._featureIdFieldArray.length - 1; ++i) {
            _jsonFeature = (JSONObject)_jsonFeature.get((Object)this._featureIdFieldArray[i]);
        }
        return ObjectConverter.toString((Object)_jsonFeature.get((Object)this._featureIdFieldArray[i]));
    }

    private final ArrayEx<Double> getCentroidLargestPolygon(String featureId, GeoPathGenerator pathGenerator) {
        ArrayEx<Double> centroid = (ArrayEx<Double>)this._centroidCache.get((Object)featureId);
        if (centroid != null) {
            return centroid;
        }
        JSONArray coord = this.getCoordinateForFeature(featureId);
        centroid = this.polygonCentroid(coord, pathGenerator);
        this._centroidCache.put((Object)featureId, centroid);
        return centroid;
    }

    private JSONArray getCoordinateForFeature(String featureId) {
        JSONArray coord = (JSONArray)this._coordinateCache.get((Object)featureId);
        if (coord == null) {
            JSONArray features = (JSONArray)this._geoJSONObject.get((Object)"features");
            JSONObject feature = null;
            for (int i = 0; i < features.size() && !featureId.equals(this.findGeoJSONId(feature = (JSONObject)features.get(i))); ++i) {
            }
            if (feature == null) {
                return null;
            }
            JSONObject geometry = (JSONObject)feature.get((Object)"geometry");
            JSONArray coordinates = (JSONArray)geometry.get((Object)"coordinates");
            String type = ObjectConverter.toString((Object)geometry.get((Object)"type"));
            if (type.equals("Polygon")) {
                coord = (JSONArray)coordinates.get(0);
            } else if (type.equals("MultiPolygon")) {
                Double largestArea = 0.0;
                for (int i = 0; i < coordinates.size(); ++i) {
                    JSONArray p = (JSONArray)coordinates.get(i);
                    JSONArray testCoord = (JSONArray)p.get(0);
                    double area = this.calculatePolyArea(testCoord);
                    if (!(area > largestArea)) continue;
                    largestArea = area;
                    coord = testCoord;
                }
            }
            this._coordinateCache.put((Object)featureId, (Object)coord);
        }
        return coord;
    }

    private double calculatePolyArea(JSONArray poly) {
        double area = 0.0;
        for (int i = 0; i < poly.size() - 1; ++i) {
            JSONArray point_i = (JSONArray)poly.get(i);
            JSONArray point_i_1 = (JSONArray)poly.get(i + 1);
            area += ObjectConverter.toDouble((Object)point_i.get(0)) * ObjectConverter.toDouble((Object)point_i_1.get(1)) - ObjectConverter.toDouble((Object)point_i_1.get(0)) * ObjectConverter.toDouble((Object)point_i.get(1));
        }
        return Math.abs(area) / 2.0;
    }

    private ArrayEx<Double> polygonCentroid(JSONArray polygon, GeoPathGenerator pathGenerator) {
        ArrayEx centroid = new ArrayEx();
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < polygon.size(); ++i) {
            JSONArray point = (JSONArray)polygon.get(i);
            x += ObjectConverter.toDouble((Object)point.get(0));
            y += ObjectConverter.toDouble((Object)point.get(1));
        }
        centroid.add((Object)(x / (double)polygon.size()));
        centroid.add((Object)(y / (double)polygon.size()));
        centroid = pathGenerator.projection().project(centroid);
        return centroid;
    }

    public MapComponentImpl featureId(SingleValueFunction<Object, Object> accessor) {
        this._featureId = accessor;
        return this;
    }

    public MapComponentImpl bubbleColor(SingleValueFunction<Object, Object> accessor) {
        this._bubbleColor = accessor;
        return this;
    }

    public MapComponentImpl bubbleSize(SingleValueFunction<Object, Object> accessor) {
        this._bubbleSize = accessor;
        return this;
    }

    public MapComponentImpl featureLbl(SingleValueFunction<Object, Object> accessor) {
        this._featureLbl = accessor;
        return this;
    }

    public MapComponentImpl labelFormatter(ValueFunction<Object, String> labelFormatter) {
        this._labelFormatter = labelFormatter;
        return this;
    }

    public MapComponentImpl bubbleScale(AbstractScale<?, ?> scale) {
        this._bubbleScale = scale;
        return this;
    }

    public MapComponentImpl defaultBubbleSize(double size) {
        this._defaultBubbleSize = size;
        return this;
    }

    public MapComponentImpl regionAnimationDuration(Number duration) {
        this._regionAnimationDuration = duration;
        return this;
    }

    public MapComponentImpl regionAnimation(Boolean doTransition) {
        this._regionAnimationEnabled = doTransition;
        return this;
    }

    public MapComponentImpl bubbleAnimationDuration(Number duration) {
        this._bubbleAnimationDuration = duration;
        return this;
    }

    public MapComponentImpl bubbleAnimation(Boolean doTransition) {
        this._bubbleAnimationEnabled = doTransition;
        return this;
    }

    public MapComponentImpl flashDuration(Number duration) {
        this._flashDuration = duration;
        return this;
    }

    public MapComponentImpl flash(Boolean flash) {
        this._flash = flash;
        return this;
    }

    public MapComponentImpl bubblePalette(Palette palette) {
        this._bubblePalette = palette;
        return this;
    }

    public MapComponentImpl regionPalette(Palette palette) {
        this._regionPalette = palette;
        return this;
    }

    public MapComponentImpl nullColor(String c) {
        this._nullColor = c;
        return this;
    }

    public MapComponentImpl geoJSONObject(JSONObject geoJSONObject) {
        if (this._geoJSONObject != null && this._geoJSONObject != geoJSONObject) {
            this._scale = Double.NaN;
        }
        this._dataChanged = true;
        this._geoJSONObject = geoJSONObject;
        return this;
    }

    public MapComponentImpl bounds(RectStruct bounds) {
        boolean bl = this._boundsChanged = this._bounds == null || bounds.x != this._bounds.x || bounds.y != this._bounds.y || bounds.width != this._bounds.width || bounds.height != this._bounds.height;
        if (this._boundsChanged) {
            this._bounds = new RectStruct(bounds.x, bounds.y, bounds.width, bounds.height);
            this._translation.setWidth(bounds.x + bounds.width / 2.0);
            this._translation.setHeight(bounds.y + bounds.height / 2.0);
            this._scale = Double.NaN;
        }
        return this;
    }

    public MapComponentImpl geoJSONfeatureIdLookup(String geoJSONfeatureIdLookup) {
        this._geoJSONfeatureIdLookup = geoJSONfeatureIdLookup;
        return this;
    }

    public MapComponentImpl featureLabel(boolean featureLabel) {
        this._prevFeatureLabel = this._featureLabel;
        this._featureLabel = featureLabel;
        return this;
    }

    public MapComponentImpl projectionType(String projectionType) {
        this._projectionChanged = this._projectionType != null && !this._projectionType.equals(projectionType);
        this._projectionType = projectionType;
        return this;
    }

    public MapComponentImpl rotation(double longitude, double latitude) {
        this._rotationLongitude = longitude;
        this._rotationLatitude = latitude;
        this._scale = Double.NaN;
        return this;
    }

    public MapComponentImpl regionsAndBubblesData(Object[] data) {
        this._regionsAndBubblesData = data;
        return this;
    }

    public void projectionChanged(boolean prochange) {
        this._projectionChanged = prochange;
    }

    public MapComponentImpl panX(boolean panOnX) {
        this._panX = panOnX;
        return this;
    }

    public MapComponentImpl panY(boolean panOnY) {
        this._panY = panOnY;
        return this;
    }

    public MapComponentImpl labelResolution(String resolve) {
        this._handleLabelCollisions = resolve;
        return this;
    }

    public MapComponentImpl defaultPanZoom(boolean defaultBehavior) {
        this._defaultPanZoom = defaultBehavior;
        return this;
    }

    public MapComponentImpl setZoomExtent(double min, double max) {
        double _min = min;
        if (_min < 0.0) {
            _min = 0.0;
        }
        this._zoomExtent = new Dim(_min, max);
        return this;
    }

    public Dim getZoomExtent() {
        return this._zoomExtent;
    }

    public MapComponentImpl dropLabels(boolean dropLabels) {
        this._dropLabels = dropLabels;
        return this;
    }

    public MapComponentImpl borderWidth(String borderWidth) {
        this._borderWidth = borderWidth;
        return this;
    }

    public MapComponentImpl borderColor(String borderColor) {
        this._borderColor = borderColor;
        return this;
    }

    public MapComponentImpl bubbleBorderWidth(String borderWidth) {
        this._bubbleBorderWidth = borderWidth;
        return this;
    }

    public MapComponentImpl bubbleBorderColor(String borderColor) {
        this._bubbleBorderColor = borderColor;
        return this;
    }

    public void panMap(double dx, double dy) {
        double[] maxTrans = this.maxTranslations();
        this._mapPan[1] = this._mapPan[1] + dy;
        this._mapPan[1] = Math.max(-maxTrans[1], Math.min(maxTrans[1], this._mapPan[1]));
        if (this._isAlbersUsa) {
            this._mapPan[0] = this._mapPan[0] + dx;
            this._mapPan[0] = Math.max(-maxTrans[0], Math.min(maxTrans[0], this._mapPan[0]));
        }
        this._chart.attr("transform", (Object)("translate(" + this._mapPan[0] + "," + this._mapPan[1] + ")"));
        if (!this._isAlbersUsa) {
            ArrayEx rotation = this._projection.rotate();
            rotation.set(0, (Object)((Double)rotation.get(0) + dx / (Math.PI / 180) / this.scaleProjection()));
            this._projection.rotate(rotation);
        }
        this.recalculateCentroidsOnAction();
    }

    public void zoomMap(double scale) {
        double[] maxTrans = this.maxTranslations();
        this._mapPan[0] = Math.min(maxTrans[0], Math.max(-maxTrans[0], this._mapPan[0]));
        this._mapPan[1] = Math.min(maxTrans[1], Math.max(-maxTrans[1], this._mapPan[1]));
        this._chart.attr("transform", (Object)("translate(" + this._mapPan[0] + "," + this._mapPan[1] + ")"));
        this._projection.scale((Object)scale);
        this.recalculateCentroidsOnAction();
    }

    private double[] maxTranslations() {
        double zoomLevel = this._projection.scale() / this._minScale - 1.0;
        double[] maxTrans = new double[]{this._bounds.width * 0.5 * zoomLevel, this._bounds.height * 0.5 * zoomLevel};
        return maxTrans;
    }

    private void recalculateCentroidsOnAction() {
        this._regionAnimationNeeded = false;
        this._centroidCache = new OMap();
    }

    public MapComponentImpl scaleProjection(double scale) {
        this._projection.scale((Object)scale);
        this.recalculateCentroidsOnAction();
        return this;
    }

    public double scaleProjection() {
        return this._projection.scale();
    }

    public Point translateProjection() {
        ArrayEx trans = this._projection.translate();
        return new Point(((Double)trans.get(0)).doubleValue(), ((Double)trans.get(1)).doubleValue());
    }

    public double[] mapTranslate() {
        return this._mapPan;
    }
}

