/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.components;

import com.ibm.rave.bundles.component.PackedBubbleComponent;
import com.ibm.rave.bundles.components.KeyedBundleComponentImpl;
import com.ibm.rave.bundles.utilities.ColorUtil;
import com.ibm.rave.bundles.utilities.FontPropertyParser;
import com.ibm.rave.bundles.utilities.LabelStyleUtil;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.Point3;
import com.ibm.rave.core.geom.RaveRect;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.interpolate.Interpolator;
import com.ibm.rave.core.layout.PackNode;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.CallbackFunction;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.svg.Symbol;
import com.ibm.rave.core.transition.Tween;
import com.ibm.rave.ext.text.nativeImpl.FontChecker;
import com.ibm.rave.library.palette.Palette;

public class PackedBubbleComponentImpl
extends KeyedBundleComponentImpl<PackedBubbleComponentImpl>
implements PackedBubbleComponent {
    private ArrayEx<?> _data = null;
    private Palette _colorPalette = null;
    private int _dur = 1000;
    private boolean _itemLabel = true;
    private boolean _clipItemLabel = false;
    private boolean _hideRoot;
    private RectStruct _bounds;
    private ValueFunction<Object, Object> _labelAccessor = null;
    private ValueFunction<Object, String> _labelFormatter;
    private SingleValueFunction<PackNode, Object> _packNodeAccessor = DEFAULT_PACKNODE_ACCESSOR;
    private SingleValueFunction<Object, Object> _sizeAccessor = null;
    private Point3 _view;
    private Selector _g = null;
    private ValueFunction<Object, String> _shapeTypeFn;
    private String _borderWidth = null;
    private String _borderColor = null;
    private OMap<String, Object> _labelFontStyle = new OMap();
    private String _labelLayerClass = ".element-label-group";
    private String _elementLayerClass = ".element-group";
    private boolean _labelContrast = false;
    private boolean _labelShadow;
    private LabelStyleUtil _labelStyleUtil;
    private ArrayEx<ArrayEx<LabelInfo>> _labelInfos = new ArrayEx();
    private static final SingleValueFunction<PackNode, Object> DEFAULT_PACKNODE_ACCESSOR = new SingleValueFunction<PackNode, Object>(){

        public PackNode getValue(Object data) {
            return (PackNode)data;
        }
    };

    public PackedBubbleComponentImpl() {
        this._shapeTypeFn = new ShapeTypeValueFunction(null);
        this._labelStyleUtil = new LabelStyleUtil();
    }

    public PackedBubbleComponentImpl sizeAccessor(SingleValueFunction<Object, Object> sizeAccessor) {
        this._sizeAccessor = sizeAccessor;
        return this;
    }

    @Override
    public String type() {
        return "PackedBubbleComponent";
    }

    public PackedBubbleComponentImpl labelFont(String labelFont) {
        this._labelFontStyle = FontPropertyParser.parseCSSFont(labelFont);
        return this;
    }

    @Override
    protected void execute(Selector g) {
        this.preExecute();
        this._g = g;
        Selector elementGroupSelector = g.selectAll(this._elementLayerClass);
        Selector labelGroupSelector = g.selectAll(this._labelLayerClass);
        if (this._data.size() == 0) {
            elementGroupSelector.selectAll("*").remove();
            labelGroupSelector.selectAll("*").remove();
            return;
        }
        this._labelInfos.clear();
        PackNode node0 = (PackNode)this._packNodeAccessor.getValue(this._data.get(0));
        this._view = new Point3(node0.x, node0.y, node0.r * 2.0);
        Selector elements = elementGroupSelector.selectAll("g.element").data(this._data.toArray(), this.getKey());
        final PackedBubbleComponentImpl self = this;
        ValueFunction<Object, String> oldShapeTypeFn = this._shapeTypeFn;
        this._shapeTypeFn = new ShapeTypeValueFunction(this._sizeAccessor);
        this.switchShapes(elements);
        Selector elementEnter = elements.enter().append("g").attr("class", (Object)"element").attr("transform", (Object)("translate (" + (this._bounds.x + this._bounds.width / 2.0) + "," + (this._bounds.y + this._bounds.height / 2.0) + ")"));
        elementEnter.append("path").attr("class", this.bubbleClass()).classed("element-shape", true).attr("d", (ValueFunction)Rave.svg.symbol().type(this._shapeTypeFn).size(0.0)).style("fill-opacity", this.bubbleOpacity()).style("stroke-opacity", this.bubbleStrokeOpacity());
        Selector labels = labelGroupSelector.selectAll(".packed-element-label").data(this._data, this.getKey());
        labels.enter().append("text").attr("dy", (Object)".3em").attr("class", (Object)"packed-element-label").style("text-anchor", (Object)"middle").style("fill-opacity", (Object)1.0E-6).attr("transform", (Object)("translate (" + (this._bounds.x + this._bounds.width / 2.0) + "," + (this._bounds.y + this._bounds.height / 2.0) + ")"));
        Selector rest = !self._clipItemLabel ? null : labels.text(this.labelText()).filter((ValueFunction)new ValueFunction<SceneNode, Boolean>(){

            public Boolean getValue(SceneNode context, Object data, int index, int groupIndex) {
                boolean textFits;
                if (groupIndex >= self._labelInfos.length()) {
                    self._labelInfos.set(groupIndex, (Object)new ArrayEx());
                }
                PackNode d = (PackNode)self._packNodeAccessor.getValue(data);
                if (d.data == null || d.children != null) {
                    return false;
                }
                RaveRect bbox = context.getBBox();
                double maxWidth = Math.max(d.r * 2.0 - bbox.height, 0.0);
                String text = context.getText();
                int textLen = text.length();
                int len = textLen == 0 ? 0 : (int)Math.floor((double)textLen * (maxWidth / bbox.width));
                boolean bl = textFits = len >= textLen;
                if (!textFits) {
                    --len;
                }
                ((ArrayEx)self._labelInfos.get(groupIndex)).set(index, (Object)new LabelInfo(text, len, maxWidth, textFits));
                return !textFits;
            }
        });
        ValueFunction<SceneNode, Boolean> localOptimizer = new ValueFunction<SceneNode, Boolean>(){

            public Boolean getValue(SceneNode context, Object data, int index, int groupIndex) {
                LabelInfo info = (LabelInfo)((ArrayEx)self._labelInfos.get(groupIndex)).get(index);
                if (info == null || info.done) {
                    return false;
                }
                double maxWidth = info.maxWidth;
                double width = context.getBBox().width;
                if (maxWidth == 0.0 || width == maxWidth) {
                    info.done = true;
                    return false;
                }
                switch (info.delta) {
                    case 0: {
                        info.delta = width < maxWidth ? 1 : -1;
                        break;
                    }
                    case 1: {
                        if (!(width > maxWidth)) break;
                        --info.len;
                        info.done = true;
                        return false;
                    }
                    case -1: {
                        if (!(width < maxWidth)) break;
                        info.done = true;
                        return false;
                    }
                }
                if (info.len <= 0 && info.delta == -1) {
                    info.done = true;
                    return false;
                }
                info.len += info.delta;
                return true;
            }
        };
        while (rest != null && !rest.empty()) {
            rest = labels.text(this.truncateLabelText(1.0)).filter((ValueFunction)localOptimizer);
        }
        FontChecker fontChecker = (FontChecker)Rave.capabilities.extension("fontchecker");
        if (fontChecker != null) {
            labels.call((RunFunction)fontChecker, new Object[0]);
        }
        labels.text(this.truncateLabelText(1.0));
        Rave.transition((Selection)elements).attr("transform", this.getTransform());
        Rave.transition((Selection)labels).style("fill-opacity", (Object)(this._itemLabel ? 1.0 : 1.0E-6)).attr("transform", this.getTransform());
        Selection s = Rave.transition((Selection)elements.select((Object)"path"));
        s.attr("d", (ValueFunction)this.sizeShapes(1.0)).style("fill", (ValueFunction)this._colorPalette);
        this.updateBorder(s, this._borderWidth, this._borderColor);
        Rave.transition((Selection)elements.exit().select((Object)"path")).style("fill-opacity", (Object)1.0E-6).attr("d", (ValueFunction)Rave.svg.symbol().type(oldShapeTypeFn).size(0.0));
        Rave.transition((Selection)labels.exit().select((Object)"text")).style("fill-opacity", (Object)1.0E-6);
        Rave.transition((Selection)elements.exit()).remove();
        Rave.transition((Selection)labels.exit()).remove();
        final String labelColor = this.getDefaultLabelColor(this._labelFontStyle);
        this._labelStyleUtil.labelFont(this._labelFontStyle).labelFillColor(this._labelContrast ? this.getLabelFill() : new ValueFunction<SceneNode, String>(){

            public String getValue(SceneNode context, Object data, int index, int groupIndex) {
                return labelColor;
            }
        }).labelShadow(this._labelShadow);
        labels.call((RunFunction)this._labelStyleUtil, new Object[0]);
        if (fontChecker != null) {
            labels.call((RunFunction)fontChecker, new Object[0]);
        }
    }

    private void switchShapes(Selector elements) {
        final PackedBubbleComponentImpl self = this;
        Selector paths = elements.select((Object)"path");
        final ArrayEx sizes = new ArrayEx();
        paths.each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode context, Object data, int index, int groupIndex) {
                RaveRect bBox = context.getBBox();
                sizes.add((Object)(Math.pow(Math.min(bBox.width, bBox.height) / 2.0, 2.0) * Math.PI));
            }
        }).each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode context, Object data, int index, int groupIndex) {
                Selector node = Rave.select((SceneNode)context);
                node.attr("d", (ValueFunction)Rave.svg.symbol().type(self._shapeTypeFn).size(((Double)sizes.shift()).doubleValue()));
            }
        });
    }

    private ValueFunction<Object, Object> bubbleClass() {
        final PackedBubbleComponentImpl self = this;
        return new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                PackNode node = (PackNode)self._packNodeAccessor.getValue(data);
                return node.children == null ? "packed-bubble-child" : "packed-bubble-parent";
            }
        };
    }

    private ValueFunction<? super SceneNode, ?> bubbleOpacity() {
        final PackedBubbleComponentImpl self = this;
        if (this._hideRoot) {
            return new ValueFunction<Object, Object>(){

                public Object getValue(Object context, Object data, int index, int groupIndex) {
                    return index == 0 ? 0.0 : (((PackNode)((PackedBubbleComponentImpl)self)._packNodeAccessor.getValue((Object)data)).children == null ? 1.0 : 0.25);
                }
            };
        }
        return new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return ((PackNode)((PackedBubbleComponentImpl)self)._packNodeAccessor.getValue((Object)data)).children == null ? 1.0 : 0.25;
            }
        };
    }

    private ValueFunction<? super SceneNode, ?> bubbleStrokeOpacity() {
        if (this._hideRoot) {
            return new ValueFunction<Object, Object>(){

                public Object getValue(Object context, Object data, int index, int groupIndex) {
                    return index == 0 ? 0.0 : 1.0;
                }
            };
        }
        return new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return 1.0;
            }
        };
    }

    private ValueFunction<Object, Object> getTransform() {
        final PackedBubbleComponentImpl self = this;
        return new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                PackNode node = (PackNode)self._packNodeAccessor.getValue(data);
                return "translate (" + (((PackedBubbleComponentImpl)self)._bounds.x + node.x) + "," + (((PackedBubbleComponentImpl)self)._bounds.y + node.y) + ")";
            }
        };
    }

    private ValueFunction<Object, Object> labelText() {
        final PackedBubbleComponentImpl self = this;
        return !this._itemLabel || this._labelAccessor == null ? null : (this._labelFormatter == null ? this._labelAccessor : new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                Object v = self._labelAccessor.getValue(context, data, index, groupIndex);
                return v == null ? null : self._labelFormatter.getValue(context, v, index, groupIndex);
            }
        });
    }

    private ValueFunction<Object, Object> truncateLabelText(final double zoomFactor) {
        final PackedBubbleComponentImpl self = this;
        return !self._clipItemLabel ? this.labelText() : new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                LabelInfo info = (LabelInfo)((ArrayEx)self._labelInfos.get(groupIndex)).get(index);
                if (info == null || info.len <= 0) {
                    return "";
                }
                if ((double)info.text.length() <= (double)info.len * zoomFactor) {
                    return info.text;
                }
                return info.text.substring(0, (int)Math.round((double)info.len * zoomFactor)) + "...";
            }
        };
    }

    private ValueFunction<SceneNode, String> getLabelFill() {
        final PackedBubbleComponentImpl self = this;
        final String labelColor = this.getDefaultLabelColor(this._labelFontStyle);
        return new ValueFunction<SceneNode, String>(){

            public String getValue(SceneNode context, Object data, int index, int groupIndex) {
                if (self._colorPalette == null) {
                    return labelColor;
                }
                Object elementColor = self._colorPalette.getValue(context, data, index, groupIndex);
                if (elementColor != null) {
                    return ColorUtil.getContrastColor(elementColor, labelColor).toString();
                }
                return labelColor;
            }
        };
    }

    private Symbol sizeShapes(final double k) {
        final PackedBubbleComponentImpl self = this;
        return Rave.svg.symbol().type(this._shapeTypeFn).size((ValueFunction)new ValueFunction<Object, Double>(){

            public Double getValue(Object context, Object data, int index, int groupIndex) {
                return Math.pow(ObjectConverter.toDouble((double)(((PackNode)((PackedBubbleComponentImpl)self)._packNodeAccessor.getValue((Object)data)).r * k)), 2.0) * Math.PI;
            }
        });
    }

    public PackedBubbleComponentImpl data(ArrayEx<? extends Object> data) {
        this._data = data;
        return this;
    }

    public PackedBubbleComponentImpl colorPalette(Palette colorPalette) {
        this._colorPalette = colorPalette;
        return this;
    }

    public PackedBubbleComponentImpl duration(int _dur) {
        this._dur = _dur;
        return this;
    }

    @Override
    public PackedBubbleComponentImpl itemLabel(boolean itemLabel) {
        this._itemLabel = itemLabel;
        return this;
    }

    public PackedBubbleComponentImpl clipItemLabels(boolean _clip) {
        this._clipItemLabel = _clip;
        return this;
    }

    public PackedBubbleComponentImpl hideRoot(boolean hideRoot) {
        this._hideRoot = hideRoot;
        return this;
    }

    public PackedBubbleComponentImpl bounds(RectStruct bounds) {
        this._bounds = bounds;
        return this;
    }

    public PackedBubbleComponentImpl labelAccessor(ValueFunction<Object, Object> _labelAccessor) {
        this._labelAccessor = _labelAccessor;
        return this;
    }

    public PackedBubbleComponentImpl labelFormatter(ValueFunction<Object, String> labelFormatter) {
        this._labelFormatter = labelFormatter;
        return this;
    }

    public PackedBubbleComponentImpl labelContrast(boolean labelContrast) {
        this._labelContrast = labelContrast;
        return this;
    }

    public PackedBubbleComponentImpl labelShadow(boolean labelShadow) {
        this._labelShadow = labelShadow;
        return this;
    }

    public PackedBubbleComponentImpl packNodeAccessor(SingleValueFunction<PackNode, Object> accessor) {
        this._packNodeAccessor = accessor;
        return this;
    }

    @SwiftMethodOverload(skipParameters={1})
    public void clickAction(Object data) {
        Rave.transition().duration((Object)this._dur).tween("zoom", this.getZoomTween(data));
    }

    private ValueFunction<SceneNode, Tween<SceneNode>> getZoomTween(Object data) {
        final PackedBubbleComponentImpl self = this;
        final PackNode node = (PackNode)this._packNodeAccessor.getValue(data);
        return new ValueFunction<SceneNode, Tween<SceneNode>>(){

            public Tween<SceneNode> getValue(SceneNode context, Object data, int index, int groupIndex) {
                final Interpolator i = Rave.interpolateZoom.create((Object)self._view, (Object)new Point3(node.x, node.y, node.r * 2.0));
                return new Tween<SceneNode>(){

                    public void tween(SceneNode context, double t) {
                        Point3 v = (Point3)i.interpolate(t);
                        double k = Math.min(((PackedBubbleComponentImpl)self)._bounds.width, ((PackedBubbleComponentImpl)self)._bounds.height) / v.getZ();
                        self._view = v;
                        Selector node = self._g.selectAll(".element").attr("transform", self.getZoomTransform(k, v));
                        self._g.selectAll(".packed-element-label").attr("transform", self.getZoomTransform(k, v));
                        self._g.selectAll(".packed-element-label").text(self.truncateLabelText(k));
                        node.select((Object)"path").attr("d", (ValueFunction)self.sizeShapes(k));
                    }
                };
            }
        };
    }

    private ValueFunction<? super SceneNode, ?> getZoomTransform(final double k, final Point3 v) {
        final PackedBubbleComponentImpl self = this;
        return new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                PackNode node = (PackNode)self._packNodeAccessor.getValue(data);
                double x = ((PackedBubbleComponentImpl)self)._bounds.x + ((PackedBubbleComponentImpl)self)._bounds.width / 2.0 - (v.getX() - node.x) * k;
                double y = ((PackedBubbleComponentImpl)self)._bounds.y + ((PackedBubbleComponentImpl)self)._bounds.height / 2.0 - (v.getY() - node.y) * k;
                return "translate(" + x + "," + y + ")";
            }
        };
    }

    @Override
    public PackedBubbleComponent borderWidth(String borderWidth) {
        this._borderWidth = borderWidth;
        return this;
    }

    @Override
    public PackedBubbleComponent borderColor(String borderColor) {
        this._borderColor = borderColor;
        return this;
    }

    @Override
    public PackedBubbleComponent labelLayerClassName(String className) {
        this._labelLayerClass = className;
        return this;
    }

    @Override
    public PackedBubbleComponent elementLayerClassName(String className) {
        this._elementLayerClass = className;
        return this;
    }

    private class LabelInfo {
        public final String text;
        public final double maxWidth;
        public int len;
        public int delta;
        public boolean done;

        public LabelInfo(String _text, int _len, double _maxWidth, boolean _done) {
            this.text = _text;
            this.len = _len;
            this.maxWidth = _maxWidth;
            this.done = _done;
            this.delta = 0;
        }
    }

    private static class ShapeTypeValueFunction
    implements ValueFunction<Object, String> {
        private final SingleValueFunction<Object, Object> _sizeAccessor;

        ShapeTypeValueFunction(SingleValueFunction<Object, Object> sizeAccessor) {
            this._sizeAccessor = sizeAccessor;
        }

        @SwiftMethodOverload(skipParameters={1})
        public String getValue(Object context, Object data, int index, int groupIndex) {
            if (this._sizeAccessor == null) {
                return "circle";
            }
            Double size = ObjectConverter.asDouble((Object)this._sizeAccessor.getValue(data));
            if (size == null) {
                return "circle";
            }
            double val = size;
            if (val > 0.0) {
                return "circle";
            }
            if (val == 0.0) {
                return "donutPlus";
            }
            return "donut-thin";
        }
    }
}

