/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.components;

import com.ibm.rave.bundles.component.PieComponent;
import com.ibm.rave.bundles.components.KeyedBundleComponentImpl;
import com.ibm.rave.bundles.utilities.ColorUtil;
import com.ibm.rave.bundles.utilities.LabelStyleUtil;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.Point;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.interpolate.Interpolator;
import com.ibm.rave.core.layout.PieLayout;
import com.ibm.rave.core.layout.SliceData;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.CallbackFunction;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.SelectorGroup;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.svg.Arc;
import com.ibm.rave.core.svg.ArcData;
import com.ibm.rave.core.transition.Transition;
import com.ibm.rave.core.transition.TransitionInterpolatorFactory;
import com.ibm.rave.ext.text.nativeImpl.FontChecker;
import com.ibm.rave.ext.text.wrap.TextFlow;
import com.ibm.rave.library.palette.Palette;
import java.util.List;

public class PieComponentImpl
extends KeyedBundleComponentImpl<PieComponentImpl>
implements PieComponent {
    private ArrayEx<Object> _data = null;
    private ValueFunction<Object, Object> _valueAccessor = null;
    private SingleValueFunction<Object, Object> _colorAccessor = null;
    private ValueFunction<Object, Object> _labelAccessor = null;
    private ValueFunction<Object, String> _labelFormatter = null;
    private SingleValueFunction<SliceData, Object> _sliceAccessor = DEFAULT_SLICE_DATA_ACCESSOR;
    private Palette _colorPalette = null;
    private final int LABEL_SPACE = 20;
    private RectStruct _bounds = null;
    private String _labelLocation = "callout";
    private boolean _hideTruncatedLabels;
    private Object currentSliceData;
    private Arc arc = null;
    private Arc outerArc = null;
    private double radius;
    private double[] lastLabelPos = null;
    private String _borderWidth = null;
    private String _borderColor = null;
    private int _currentLevel = 0;
    private int _maxLevel = 1;
    private double _donutRadius = 1.0;
    private double[] _arcRadius = new double[2];
    private OMap<String, Object> _labelFontStyle = null;
    private boolean _labelContrast = false;
    private boolean _labelShadow = false;
    private LabelStyleUtil _labelStyleUtil = new LabelStyleUtil();
    private static final SingleValueFunction<SliceData, Object> DEFAULT_SLICE_DATA_ACCESSOR = new SingleValueFunction<SliceData, Object>(){

        public SliceData getValue(Object data) {
            return (SliceData)data;
        }
    };

    @Override
    public String type() {
        return "PieComponent";
    }

    public PieLayout buildLayout() {
        return Rave.layout.pie().sort(null).value(this._valueAccessor);
    }

    @Override
    protected void execute(Selector g) {
        this.preExecute();
        if (this._data == null || this._data.size() == 0 || this._bounds == null && this._valueAccessor == null) {
            g.selectAll("*").remove();
            return;
        }
        final PieComponentImpl self = this;
        this.radius = this._bounds == null ? 0.0 : Math.min(this._bounds.width, this._bounds.height) / 2.0;
        g.attr("transform", (Object)("translate(" + (this._bounds.x + this._bounds.width / 2.0) + "," + (this._bounds.y + this._bounds.height / 2.0) + ")"));
        this.arc = Rave.svg.arc();
        this.outerArc = Rave.svg.arc();
        Selector slices = g.selectAll(".slice").data(this._data.toArray(), this.getKey());
        slices.enter().append("path").attr("class", (Object)"slice").classed("element-shape", true);
        slices.style("fill", (ValueFunction)new ValueFunction<SceneNode, Object>(){

            public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                return self._colorPalette.getValue(context, self._sliceAccessor.getValue(data), index, groupIndex);
            }
        });
        ((Transition)Rave.transition((Selection)slices)).attrTween("d", this.interpolate("slice"));
        this.updateBorder((Selection<?>)slices, this._borderWidth, this._borderColor);
        slices.exit().remove();
        Object labelText = this._labelFormatter == null ? new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return self._labelAccessor.getValue(context, self._sliceAccessor.getValue(data), index, groupIndex);
            }
        } : new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                Object v = self._labelAccessor.getValue(context, self._sliceAccessor.getValue(data), index, groupIndex);
                return v == null ? null : self._labelFormatter.getValue(context, v, index, groupIndex);
            }
        };
        final String labelColor = this.getDefaultLabelColor(this._labelFontStyle);
        ValueFunction<SceneNode, String> labelFill = new ValueFunction<SceneNode, String>(){

            public String getValue(SceneNode context, Object data, int index, int groupIndex) {
                Object elementColor;
                if (self._colorPalette == null) {
                    return labelColor;
                }
                if ((self._labelLocation.equals("center") || self._labelLocation.equals("centerHorizontal")) && (elementColor = self._colorPalette.getValue(context, self._sliceAccessor.getValue(data), index, groupIndex)) != null) {
                    return ColorUtil.getContrastColor(elementColor, labelColor).toString();
                }
                return labelColor;
            }
        };
        double maxLabelWidth = this.radius * (0.25 - (double)this._currentLevel * 0.18 / (double)this._maxLevel);
        double padding = this.radius * 0.02;
        double radiusPerLevelIncrement = this.radius / (double)(this._maxLevel + 1);
        double outerRadius = this.radius - radiusPerLevelIncrement * (double)(this._maxLevel - (this._currentLevel + 1));
        double innerRadius = this.radius - radiusPerLevelIncrement * (double)(this._maxLevel - this._currentLevel);
        if (this._currentLevel == 0) {
            innerRadius = outerRadius * (1.0 - this._donutRadius);
        }
        this.arc.outerRadius(outerRadius).innerRadius(innerRadius);
        this._arcRadius[0] = innerRadius;
        this._arcRadius[1] = outerRadius;
        if (!this._labelLocation.equals("none")) {
            TextFlow textflow = (TextFlow)Rave.capabilities.extension("textflow");
            textflow.wrap(false).fit(false).truncate(true);
            Selector labels = g.selectAll(".label").data(this._data.toArray(), this.getKey());
            labels.enter().append("text").attr("class", (Object)"label").attr("y", (Object)".35em");
            labels.text((ValueFunction)labelText);
            FontChecker fontChecker = (FontChecker)Rave.capabilities.extension("fontchecker");
            if (fontChecker != null) {
                labels.call((RunFunction)fontChecker, new Object[0]);
            }
            if (this._labelLocation.equals("callout")) {
                if (this.radius < 40.0) {
                    g.selectAll(".label").remove();
                    g.selectAll(".polyline").remove();
                } else {
                    Selector polylines = g.selectAll(".polyline").data(this._data.toArray(), this.getKey());
                    polylines.enter().append("polyline").attr("class", (Object)"polyline");
                    if (this._maxLevel == 1) {
                        maxLabelWidth = 0.0;
                        padding = 20.0;
                        for (int i = 0; i < ((SelectorGroup)labels.get(0)).size(); ++i) {
                            double labelWidth = ((SceneNode)((SelectorGroup)labels.get((int)0)).get((int)i)).getBBox().width;
                            if (!(labelWidth > maxLabelWidth)) continue;
                            maxLabelWidth = labelWidth;
                        }
                        if ((maxLabelWidth += 20.0) > this.radius / 2.0) {
                            maxLabelWidth = this.radius / 2.0;
                        }
                        this.radius = this.radius - maxLabelWidth - padding;
                    } else {
                        this.radius -= this.radius * 0.5 / (double)this._maxLevel;
                    }
                    this.outerArc.outerRadius(this.radius + maxLabelWidth).innerRadius(this.radius + padding);
                    labels.attr("width", (Object)(maxLabelWidth + "px")).attr("height", null);
                    ((Transition)Rave.transition((Selection)labels)).styleTween("text-anchor", this.interpolate("labelAnchor"));
                    polylines.style("stroke-opacity", this.polylineOpacity());
                    ((Transition)Rave.transition((Selection)polylines)).attrTween("points", this.interpolate("polyline"));
                    polylines.exit().remove();
                }
                radiusPerLevelIncrement = this.radius / (double)(this._maxLevel + 1);
                outerRadius = this.radius - radiusPerLevelIncrement * (double)(this._maxLevel - (this._currentLevel + 1));
                innerRadius = this.radius - radiusPerLevelIncrement * (double)(this._maxLevel - this._currentLevel);
                if (this._currentLevel == 0) {
                    innerRadius = outerRadius * (1.0 - this._donutRadius);
                }
                this.arc.outerRadius(outerRadius).innerRadius(innerRadius);
                this._arcRadius[0] = innerRadius;
                this._arcRadius[1] = outerRadius;
            }
            if (this._labelLocation.equals("center")) {
                g.selectAll(".polyline").remove();
                labels.attr("width", (Object)(outerRadius - innerRadius)).attr("height", this.sliceHeight());
                labels.style("text-anchor", (Object)"middle");
            } else if (this._labelLocation.equals("centerHorizontal")) {
                g.selectAll(".polyline").remove();
                labels.attr("width", this.sliceWidth()).attr("height", null);
                labels.style("text-anchor", (Object)"middle");
            }
            this._labelStyleUtil.labelFont(this._labelFontStyle).labelFillColor(this._labelContrast ? labelFill : new ValueFunction<SceneNode, String>(){

                public String getValue(SceneNode context, Object data, int index, int groupIndex) {
                    return labelColor;
                }
            }).labelShadow(this._labelShadow);
            labels.call((RunFunction)textflow, new Object[0]);
            labels.call((RunFunction)this._labelStyleUtil, new Object[0]);
            if (this._hideTruncatedLabels && !this._labelLocation.equals("callout")) {
                labels.each((CallbackFunction)new CallbackFunction<SceneNode>(){

                    public void run(SceneNode context, Object obj, int group, int index) {
                        String text = context.getText();
                        if (text.length() >= 3 && text.lastIndexOf("...", text.length() - 3) > -1) {
                            context.setText("");
                        }
                    }
                });
            }
            ((Transition)Rave.transition((Selection)labels)).attrTween("transform", this.interpolate("labelTransform"));
            labels.exit().remove();
        } else {
            g.selectAll(".label").remove();
            g.selectAll(".polyline").remove();
        }
    }

    private ValueFunction<? super SceneNode, ?> sliceWidth() {
        final PieComponentImpl self = this;
        return new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object d, int index, int groupIndex) {
                SliceData sd = (SliceData)self._sliceAccessor.getValue(d);
                Point pos = self.getLabelHorzPosition(sd.startAngle, sd.endAngle);
                double[] intersects = new double[6];
                intersects[0] = self.intersect(sd.startAngle, pos.getY());
                intersects[1] = self.intersect(sd.endAngle, pos.getY());
                double[] arcIntersects = self.intersect(sd.startAngle, sd.endAngle, pos.getY(), true);
                intersects[2] = arcIntersects[0];
                intersects[3] = arcIntersects[1];
                arcIntersects = self.intersect(sd.startAngle, sd.endAngle, pos.getY(), false);
                intersects[4] = arcIntersects[0];
                intersects[5] = arcIntersects[1];
                double xIntersect0 = Double.NaN;
                double xIntersect1 = Double.NaN;
                for (double intersect : intersects) {
                    if (Double.isNaN(intersect)) continue;
                    if (Double.isNaN(xIntersect0)) {
                        xIntersect0 = intersect;
                        continue;
                    }
                    xIntersect1 = intersect;
                }
                double space0 = Math.abs(pos.getX() - xIntersect0);
                double space1 = Math.abs(pos.getX() - xIntersect1);
                return Math.min(space0, space1) * 2.0;
            }
        };
    }

    private Point getLabelHorzPosition(double startAngle, double endAngle) {
        double midAngle = startAngle + (endAngle - startAngle) / 2.0;
        double midAngleCAST = 1.5707963267948966 - midAngle;
        double scaler = this._arcRadius[0] == 0.0 ? 0.67 : 0.5;
        double r = this._arcRadius[0] + (this._arcRadius[1] - this._arcRadius[0]) * scaler;
        return new Point(r * Math.cos(midAngleCAST), -r * Math.sin(midAngleCAST));
    }

    private double intersect(double angle, double y) {
        double angleCAST = 1.5707963267948966 - angle;
        double yCAST = -y;
        double r0 = this._arcRadius[0];
        double y0 = Math.sin(angleCAST) * r0;
        double r1 = this._arcRadius[1];
        double y1 = Math.sin(angleCAST) * r1;
        if (yCAST >= y0 && yCAST < y1 || yCAST >= y1 && yCAST < y0) {
            double x0 = Math.cos(angleCAST) * r0;
            double x1 = Math.cos(angleCAST) * r1;
            double x = x0 + (x1 - x0) / (y1 - y0) * (yCAST - y0);
            return x;
        }
        return Double.NaN;
    }

    private double[] intersect(double startAngle, double endAngle, double y, boolean isInner) {
        double[] intersects = new double[]{Double.NaN, Double.NaN};
        double r = this._arcRadius[isInner ? 0 : 1];
        if (Math.abs(y) < r) {
            double yCAST = -y;
            double x = Math.sqrt(r * r - yCAST * yCAST);
            double angle0 = Math.atan2(yCAST, x);
            double angle1 = Math.atan2(yCAST, -x);
            angle0 = 1.5707963267948966 - angle0;
            angle1 = 1.5707963267948966 - angle1;
            if (angle0 < 0.0) {
                angle0 += Math.PI * 2;
            }
            if (angle1 < 0.0) {
                angle1 += Math.PI * 2;
            }
            if (angle0 >= startAngle && angle0 < endAngle) {
                intersects[0] = x;
            }
            if (angle1 >= startAngle && angle1 < endAngle) {
                intersects[1] = -x;
            }
        }
        return intersects;
    }

    private ValueFunction<? super SceneNode, ?> sliceHeight() {
        final PieComponentImpl self = this;
        return new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object d, int index, int groupIndex) {
                SliceData d1 = (SliceData)self._sliceAccessor.getValue(d);
                return Math.abs(d1.endAngle - d1.startAngle) * (self._arcRadius[0] + self._arcRadius[1]) / 2.0;
            }
        };
    }

    private ValueFunction<? super SceneNode, ?> polylineOpacity() {
        final PieComponentImpl self = this;
        return new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                SliceData d = (SliceData)self._sliceAccessor.getValue(data);
                Object v = self._colorAccessor.getValue((Object)d);
                return self._labelLocation.equals("callout") && v != null ? 1.0 : 1.0E-6;
            }
        };
    }

    private TransitionInterpolatorFactory<SceneNode> interpolate(final String type) {
        final PieComponentImpl self = this;
        return new TransitionInterpolatorFactory<SceneNode>(){

            public Interpolator<?> create(final SceneNode context, Object data, final int index, Object value) {
                Object current;
                SliceData d = (SliceData)self._sliceAccessor.getValue(data);
                ArcData arcData = new ArcData();
                arcData.startAngle = d.startAngle;
                arcData.endAngle = d.endAngle;
                arcData.innerRadius = d.innerRadius;
                arcData.outerRadius = d.outerRadius;
                if (self.currentSliceData == null) {
                    self.currentSliceData = arcData;
                }
                if ((current = context.getProperty("currentSlice")) == null) {
                    current = self.currentSliceData;
                }
                final Interpolator i = Rave.interpolate.create(current, (Object)arcData);
                current = i.interpolate(0.0);
                context.setProperty("currentSlice", current);
                self.currentSliceData = current;
                return new Interpolator<String>(){

                    public String interpolate(double t) {
                        if (type.equals("slice")) {
                            return self.arc.getValue((Object)context, i.interpolate(t), index, 0);
                        }
                        if (type.equals("polyline")) {
                            return self.interpolatePolyline((ArcData)i.interpolate(t), index, t);
                        }
                        if (type.equals("labelAnchor")) {
                            return self.interpolateLabelAnchor((ArcData)i.interpolate(t));
                        }
                        return self.interpolateLabelTransform((ArcData)i.interpolate(t), index, t);
                    }
                };
            }
        };
    }

    private String interpolateLabelAnchor(ArcData d2) {
        double midAngle = d2.startAngle + (d2.endAngle - d2.startAngle) / 2.0;
        return midAngle < Math.PI ? "start" : "end";
    }

    private String interpolateLabelTransform(ArcData d2, int index, double t) {
        PieComponentImpl self = this;
        double midAngle = d2.startAngle + (d2.endAngle - d2.startAngle) / 2.0;
        if (self._labelLocation.equals("center")) {
            double[] pos = self.arc.centroid((Object)d2, index, 0);
            double rotate = midAngle < Math.PI ? 270.0 : 90.0;
            return "translate(" + pos[0] + "," + pos[1] + ")rotate(" + (midAngle * 180.0 / Math.PI + rotate) + ")";
        }
        if (self._labelLocation.equals("centerHorizontal")) {
            Point pos = self.getLabelHorzPosition(d2.startAngle, d2.endAngle);
            return "translate(" + pos.getX() + "," + pos.getY() + ")";
        }
        double[] pos = self.getCalloutLabelPosition(index, d2, midAngle, t);
        return "translate(" + pos[0] + "," + pos[1] + ")";
    }

    private String interpolatePolyline(ArcData d2, int index, double t) {
        PieComponentImpl self = this;
        double labelArcInnerRadius = ObjectConverter.toDouble((Object)self.outerArc.innerRadius().getValue((Object)self.outerArc, (Object)d2, index, 0));
        double midAngle = d2.startAngle + (d2.endAngle - d2.startAngle) / 2.0;
        double[] pos0 = new double[2];
        double[] pos1 = new double[2];
        pos0[0] = self._arcRadius[1] * Math.sin(midAngle);
        pos0[1] = -1.0 * self._arcRadius[1] * Math.cos(midAngle);
        pos1[0] = pos0[0] + (labelArcInnerRadius - self._arcRadius[1]) * Math.sin(midAngle);
        pos1[1] = pos0[1] - (labelArcInnerRadius - self._arcRadius[1]) * Math.cos(midAngle);
        double[] adjusted = self.getCalloutLabelPosition(index, d2, midAngle, t);
        double offset = 2 * (midAngle < Math.PI ? 1 : -1);
        return pos0[0] + "," + pos0[1] + "," + pos1[0] + "," + adjusted[1] + "," + (adjusted[0] - offset) + "," + adjusted[1];
    }

    private double[] getCalloutLabelPosition(int index, ArcData d2, double midAngle, double t) {
        PieComponentImpl self = this;
        double labelArcInnerRadius = ObjectConverter.toDouble((Object)self.outerArc.innerRadius().getValue((Object)self.outerArc, (Object)d2, index, 0));
        double posx = self._maxLevel == 1 ? (double)(midAngle < Math.PI ? 1 : -1) * labelArcInnerRadius : (double)(midAngle < Math.PI ? 1 : -1) * (labelArcInnerRadius + (double)((self._currentLevel + 1) * 20));
        double pieOuterRadius = ObjectConverter.toDouble((Object)self.arc.outerRadius().getValue((Object)self.arc, (Object)d2, index, 0));
        double posy = -1.0 * pieOuterRadius * Math.cos(midAngle);
        posy -= (labelArcInnerRadius - pieOuterRadius) * Math.cos(midAngle);
        if (t > 0.8) {
            if (this.lastLabelPos == null) {
                this.lastLabelPos = new double[]{posx, posy, posy};
            } else if (posx == this.lastLabelPos[0] && (Math.abs(posy - this.lastLabelPos[1]) < 20.0 || Math.abs(posy - this.lastLabelPos[2]) < 20.0)) {
                this.lastLabelPos[0] = posx;
                this.lastLabelPos[2] = posy;
                posy = midAngle > 1.5707963267948966 && midAngle < 4.71238898038469 ? Math.max(posy, this.lastLabelPos[1] + 20.0) : Math.min(posy, this.lastLabelPos[1] - 20.0);
                posy = Math.max(posy, -this._bounds.height / 2.0);
                this.lastLabelPos[1] = posy = Math.min(posy, this._bounds.height / 2.0);
            } else {
                this.lastLabelPos[0] = posx;
                this.lastLabelPos[1] = posy;
                this.lastLabelPos[2] = posy;
            }
        }
        return new double[]{posx, posy};
    }

    public PieComponentImpl data(List<? extends Object> data) {
        this._data = ObjectConverter.listToArray(data);
        return this;
    }

    public PieComponentImpl valueAccessor(ValueFunction<Object, Object> valueAccessor) {
        this._valueAccessor = valueAccessor;
        return this;
    }

    public PieComponentImpl labelAccessor(ValueFunction<Object, Object> labelAccessor) {
        this._labelAccessor = labelAccessor;
        return this;
    }

    public PieComponentImpl labelHideTruncated(boolean hideTruncated) {
        this._hideTruncatedLabels = hideTruncated;
        return this;
    }

    public PieComponentImpl labelFormatter(ValueFunction<Object, String> labelFormatter) {
        this._labelFormatter = labelFormatter;
        return this;
    }

    public PieComponentImpl colorAccessor(SingleValueFunction<Object, Object> colorAccessor) {
        this._colorAccessor = colorAccessor;
        return this;
    }

    public PieComponentImpl colorPalette(Palette colorPalette) {
        this._colorPalette = colorPalette;
        return this;
    }

    public Palette colorPalette() {
        return this._colorPalette;
    }

    public PieComponentImpl bounds(RectStruct bounds) {
        this._bounds = bounds;
        return this;
    }

    @Override
    public PieComponent labelLocation(String labelLocation) {
        this._labelLocation = labelLocation;
        return this;
    }

    public PieComponentImpl donutRadius(double r) {
        this._donutRadius = r;
        return this;
    }

    public PieComponentImpl currentLevel(int _currentLevel) {
        this._currentLevel = _currentLevel;
        return this;
    }

    public PieComponentImpl maxLevel(int _maxLevel) {
        this._maxLevel = _maxLevel;
        return this;
    }

    public PieComponentImpl sliceAccessor(SingleValueFunction<SliceData, Object> accessor) {
        this._sliceAccessor = accessor;
        return this;
    }

    @Override
    public PieComponent borderWidth(String borderWidth) {
        this._borderWidth = borderWidth;
        return this;
    }

    @Override
    public PieComponent borderColor(String borderColor) {
        this._borderColor = borderColor;
        return this;
    }

    public PieComponentImpl labelFont(OMap<String, Object> _labelFontStyle) {
        this._labelFontStyle = _labelFontStyle;
        return this;
    }

    public PieComponentImpl labelContrast(boolean labelContrast) {
        this._labelContrast = labelContrast;
        return this;
    }

    public PieComponentImpl labelShadow(boolean labelShadow) {
        this._labelShadow = labelShadow;
        return this;
    }
}

