/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.components;

import com.ibm.rave.bundles.component.PointComponent;
import com.ibm.rave.bundles.components.KeyedBundleComponentImpl;
import com.ibm.rave.bundles.utilities.BundleLabelDropper;
import com.ibm.rave.bundles.utilities.ColorUtil;
import com.ibm.rave.bundles.utilities.LabelStyleUtil;
import com.ibm.rave.bundles.utilities.PathUtils;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.svg.Symbol;
import com.ibm.rave.ext.text.nativeImpl.FontChecker;
import com.ibm.rave.library.framework.internal.CSSConverter;
import com.ibm.rave.library.framework.internal.CoordinateScaleImpl;
import com.ibm.rave.library.palette.Palette;
import com.ibm.rave.library.property.CommonPropertyConstants;

public class PointComponentImpl
extends KeyedBundleComponentImpl<PointComponentImpl>
implements PointComponent {
    public static final String SECONDARY_ELEMENT = "element-shape-secondary";
    private Object[] _data = null;
    private SingleValueFunction<Object, Object> _independentAccessor = null;
    private CoordinateScaleImpl _independentScale = null;
    private SingleValueFunction<Object, Object> _dependentAccessor = null;
    private CoordinateScaleImpl _dependentScale = null;
    private Palette _colorPalette = null;
    private SingleValueFunction<Object, Object> _sizeAccessor = null;
    private AbstractScale<?, ?> _sizeScale = null;
    private SingleValueFunction<Object, Object> _labelAccessor = null;
    private ValueFunction<Object, String> _labelFormatter = null;
    private OMap<String, Object> _labelFontStyle = new OMap();
    private RectStruct _bounds = null;
    private boolean _transpose = false;
    private double _defaultSize = 400.0;
    private String _symbol = null;
    private String _prevSymbol = null;
    private boolean _itemLabel = true;
    private boolean _itemOverlap = true;
    private final BundleLabelDropper _dropOverlap = new BundleLabelDropper();
    private String _effect = null;
    private String _borderWidth = null;
    private String _borderColor = null;
    private String _labelLayerClass = ".element-label-group";
    private String _elementLayerClass = ".element-group";
    private ValueFunction<Object, Integer> _itemLabelPosition = null;
    private boolean _labelContrast = false;
    private boolean _labelShadow = false;
    private LabelStyleUtil _labelStyleUtil = new LabelStyleUtil();
    public static final int LABEL_POSITION_TOP = 0;
    public static final int LABEL_POSITION_CENTER = 1;
    public static final int LABEL_POSITION_BOTTOM = 2;
    public static final int LABEL_POSITION_LEFT = 3;
    public static final int LABEL_POSITION_RIGHT = 4;
    public static final int LABEL_POSITION_TOP_RIGHT = 5;

    public PointComponentImpl() {
        if (!Rave.svg.symbolTypes.contains("donutPlus")) {
            Rave.svg.symbolCreator("donutPlus", CommonPropertyConstants.DONUT_PLUS);
        }
        if (!Rave.svg.symbolTypes.contains("donut-thin")) {
            Rave.svg.symbolCreator("donut-thin", CommonPropertyConstants.DONUT_THIN);
        }
    }

    @Override
    public String type() {
        return "PointComponent";
    }

    @Override
    protected void execute(Selector g) {
        Symbol s;
        this.preExecute();
        Selector elementGroupSelector = g.selectAll(this._elementLayerClass);
        Selector labelGroupSelector = g.selectAll(this._labelLayerClass);
        if (g.classed(this._elementLayerClass) || elementGroupSelector.size() == 0 || labelGroupSelector.size() == 0) {
            elementGroupSelector = g;
            labelGroupSelector = g;
        }
        if (this._data == null || this._bounds == null && (this._independentAccessor == null || this._independentScale == null || this._dependentAccessor == null || this._dependentScale == null)) {
            elementGroupSelector.selectAll("*").remove();
            labelGroupSelector.selectAll("*").remove();
            return;
        }
        elementGroupSelector.selectAll("*").remove();
        labelGroupSelector.selectAll("*").remove();
        final PointComponentImpl self = this;
        ValueFunction<Object, String> enterTransform = this.pointTransform(true);
        ValueFunction<Object, String> finalTransform = this.pointTransform(false);
        ArrayEx symbols = new ArrayEx();
        if (this._symbol == null) {
            elementGroupSelector.selectAll("*").remove();
        } else if (this._symbol.equals("donutPlus")) {
            s = new Symbol().type("circle");
            symbols.add(s);
            s = new Symbol().type("donut-thin");
            symbols.add(s);
        } else {
            s = new Symbol().type(this._symbol);
            symbols.add(s);
            elementGroupSelector.selectAll(".element-shape-secondary").remove();
        }
        for (int i = 0; i < symbols.size(); ++i) {
            String type = i == 0 ? "element-shape" : SECONDARY_ELEMENT;
            Selector shapes = elementGroupSelector.selectAll("." + type).data(this._data, this.getKey());
            shapes.exit().remove();
            Symbol symbol = (Symbol)symbols.get(i);
            ValueFunction<Object, Object> fillStyle = this.symbolFill(type);
            shapes.enter().append("path").attr("class", (Object)type).attr("transform", enterTransform).attr("d", (ValueFunction)symbol.size(this.enterSize(this._defaultSize, type))).style("fill", fillStyle).style("stroke", fillStyle).style("stroke-width", (Object)"0px");
            Selection s2 = Rave.transition((Selection)shapes).attr("transform", finalTransform).style("fill", fillStyle);
            this.updateBorder(s2, this._borderWidth, this._borderColor);
            symbol.size(this.finalSize(this._defaultSize, type));
            if (this._prevSymbol != null && !this._prevSymbol.equals(this._symbol)) {
                PathUtils.fadeOutIn(s2, (ValueFunction<Object, String>)symbol);
                continue;
            }
            s2.attr("d", (ValueFunction)symbol);
        }
        if (this._itemLabel && this._labelAccessor != null) {
            Selector elementLabelGroupSelector = g.selectAll(this._labelLayerClass);
            if (elementLabelGroupSelector.size() == 0) {
                elementLabelGroupSelector = g;
            }
            Selector labels = elementLabelGroupSelector.selectAll("element-label").data(this._data, this.getKey());
            labels.exit().remove();
            Object labelText = this._labelFormatter == null ? new ValueFunction<Object, Object>(){

                public Object getValue(Object context, Object data, int index, int groupIndex) {
                    return self._labelAccessor.getValue(data);
                }
            } : new ValueFunction<Object, Object>(){

                public Object getValue(Object context, Object data, int index, int groupIndex) {
                    Object v = self._labelAccessor.getValue(data);
                    return v == null ? null : self._labelFormatter.getValue(context, v, index, groupIndex);
                }
            };
            FontChecker fontChecker = (FontChecker)Rave.capabilities.extension("fontchecker");
            labels.enter().append("text").attr("class", (Object)"element-label").attr("x", this.positionX(true)).attr("y", this.positionY(true)).attr("dx", this.getXOffset()).attr("dy", this.getYOffset()).style("text-anchor", this.getAnchor()).text((ValueFunction)labelText);
            final String labelColor = this.getDefaultLabelColor(this._labelFontStyle);
            this._labelStyleUtil.labelFont(this._labelFontStyle).labelFillColor(this._labelContrast ? this.getLabelFill() : new ValueFunction<SceneNode, String>(){

                public String getValue(SceneNode context, Object data, int index, int groupIndex) {
                    return labelColor;
                }
            }).labelShadow(this._labelShadow);
            labels.call((RunFunction)this._labelStyleUtil, new Object[0]);
            if (fontChecker != null) {
                labels.call((RunFunction)fontChecker, new Object[0]);
            }
            Selection labelTransition = Rave.transition((Selection)labels).attr("x", this.positionX(false)).attr("y", this.positionY(false)).attr("dx", this.getXOffset()).attr("dy", this.getYOffset()).style("text-anchor", this.getAnchor()).text((ValueFunction)labelText);
            this._dropOverlap.configureForDataLabels(this._bounds);
            labelTransition.call((RunFunction)this._dropOverlap, new Object[]{this._itemOverlap});
        } else {
            Selector elementLabelGroupSelector = g.selectAll(this._labelLayerClass);
            if (elementLabelGroupSelector.size() == 0) {
                elementLabelGroupSelector = g;
            }
            elementLabelGroupSelector.selectAll("text.element-label").remove();
        }
    }

    private final ValueFunction<Object, Object> symbolFill(final String type) {
        final PointComponentImpl self = this;
        return new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object d, int index, int groupIndex) {
                if (self._symbol.equals("donutPlus") && type.equals(PointComponentImpl.SECONDARY_ELEMENT)) {
                    return "white";
                }
                return self._colorPalette == null ? null : self._colorPalette.getValue(null, d, 0, 0);
            }
        };
    }

    private final ValueFunction<Object, String> pointTransform(boolean enter) {
        boolean useDependentZero = enter && ("fromBase".equals(this._effect) || "growfromBase".equals(this._effect));
        final ValueFunction<Object, Number> dependent = useDependentZero ? this.dependentZero() : this.dependent();
        final ValueFunction<Object, Number> independent = this.independent();
        if (this._transpose) {
            return new ValueFunction<Object, String>(){

                public String getValue(Object context, Object data, int index, int groupIndex) {
                    return "translate(" + dependent.getValue(context, data, index, groupIndex) + "," + independent.getValue(context, data, index, groupIndex) + ")";
                }
            };
        }
        return new ValueFunction<Object, String>(){

            public String getValue(Object context, Object data, int index, int groupIndex) {
                return "translate(" + independent.getValue(context, data, index, groupIndex) + "," + dependent.getValue(context, data, index, groupIndex) + ")";
            }
        };
    }

    private final ValueFunction<Object, Number> positionX(boolean enter) {
        boolean useDependentZero = enter && ("fromBase".equals(this._effect) || "growfromBase".equals(this._effect));
        final ValueFunction<Object, Number> dependent = useDependentZero ? this.dependentZero() : this.dependent();
        final ValueFunction<Object, Number> independent = this.independent();
        if (this._transpose) {
            return new ValueFunction<Object, Number>(){

                public Number getValue(Object context, Object data, int index, int groupIndex) {
                    return (Number)dependent.getValue(context, data, index, groupIndex);
                }
            };
        }
        return new ValueFunction<Object, Number>(){

            public Number getValue(Object context, Object data, int index, int groupIndex) {
                return (Number)independent.getValue(context, data, index, groupIndex);
            }
        };
    }

    private final ValueFunction<Object, Number> positionY(boolean enter) {
        boolean useDependentZero = enter && ("fromBase".equals(this._effect) || "growfromBase".equals(this._effect));
        final ValueFunction<Object, Number> dependent = useDependentZero ? this.dependentZero() : this.dependent();
        final ValueFunction<Object, Number> independent = this.independent();
        if (this._transpose) {
            return new ValueFunction<Object, Number>(){

                public Number getValue(Object context, Object data, int index, int groupIndex) {
                    return (Number)independent.getValue(context, data, index, groupIndex);
                }
            };
        }
        return new ValueFunction<Object, Number>(){

            public Number getValue(Object context, Object data, int index, int groupIndex) {
                return (Number)dependent.getValue(context, data, index, groupIndex);
            }
        };
    }

    private final ValueFunction<Object, Number> independent() {
        if (this._independentAccessor != null && this._independentScale != null) {
            final PointComponentImpl self = this;
            return new ValueFunction<Object, Number>(){

                public Number getValue(Object context, Object data, int index, int groupIndex) {
                    return self._independentScale.center(self._independentAccessor.getValue(data));
                }
            };
        }
        final Double midpoint = this._transpose ? this._bounds.y + this._bounds.height / 2.0 : this._bounds.x + this._bounds.width / 2.0;
        return new ValueFunction<Object, Number>(){

            public Number getValue(Object context, Object data, int index, int groupIndex) {
                return midpoint;
            }
        };
    }

    private final ValueFunction<Object, Number> dependent() {
        if (this._dependentAccessor != null && this._dependentScale != null) {
            final PointComponentImpl self = this;
            return new ValueFunction<Object, Number>(){

                public Number getValue(Object context, Object data, int index, int groupIndex) {
                    return self._dependentScale.center(self._dependentAccessor.getValue(data));
                }
            };
        }
        final Double midpoint = this._transpose ? this._bounds.x + this._bounds.width / 2.0 : this._bounds.y + this._bounds.height / 2.0;
        return new ValueFunction<Object, Number>(){

            public Number getValue(Object context, Object data, int index, int groupIndex) {
                return midpoint;
            }
        };
    }

    private final ValueFunction<Object, Number> dependentZero() {
        if (this._dependentScale == null || !this._dependentScale.isLinear()) {
            return this.dependent();
        }
        final PointComponentImpl self = this;
        return new ValueFunction<Object, Number>(){

            public Number getValue(Object context, Object data, int index, int groupIndex) {
                return self._dependentScale.center((Object)0.0);
            }
        };
    }

    private final ValueFunction<Object, Double> enterSize(double size, String type) {
        if ("grow".equals(this._effect) || "growfromBase".equals(this._effect)) {
            return new ValueFunction<Object, Double>(){

                public Double getValue(Object context, Object data, int index, int groupIndex) {
                    return 0.0;
                }
            };
        }
        return this.finalSize(size, type);
    }

    private final ValueFunction<Object, Double> finalSize(final double size, String type) {
        double ratio;
        final PointComponentImpl self = this;
        double d = ratio = self._symbol.equals("donutPlus") && type.equals(SECONDARY_ELEMENT) ? 0.6 : 1.0;
        if (this._sizeAccessor != null && this._sizeScale != null) {
            return new ValueFunction<Object, Double>(){

                public Double getValue(Object context, Object d, int index, int groupIndex) {
                    Object v = self._sizeAccessor.getValue(d);
                    return v != null ? ObjectConverter.toDouble((Object)self._sizeScale.getValue(null, v, 0, 0)) * ratio : size * ratio;
                }
            };
        }
        return new ValueFunction<Object, Double>(){

            public Double getValue(Object context, Object d, int index, int groupIndex) {
                return size * ratio;
            }
        };
    }

    private ValueFunction<Object, String> getAnchor() {
        final PointComponentImpl self = this;
        return new ValueFunction<Object, String>(){

            public String getValue(Object context, Object data, int index, int groupIndex) {
                if (self._itemLabelPosition == null) {
                    return "middle";
                }
                Integer labelPosition = (Integer)self._itemLabelPosition.getValue(context, data, index, groupIndex);
                if (0 == labelPosition || 2 == labelPosition || 1 == labelPosition) {
                    return "middle";
                }
                if (3 == labelPosition) {
                    return "end";
                }
                if (4 == labelPosition || 5 == labelPosition) {
                    return "start";
                }
                return "middle";
            }
        };
    }

    private ValueFunction<SceneNode, String> getLabelFill() {
        final PointComponentImpl self = this;
        final String labelColor = this.getDefaultLabelColor(this._labelFontStyle);
        return new ValueFunction<SceneNode, String>(){

            public String getValue(SceneNode context, Object data, int index, int groupIndex) {
                Object elementColor;
                if (self._colorPalette == null || self._itemLabelPosition == null) {
                    return labelColor;
                }
                Integer labelPosition = (Integer)self._itemLabelPosition.getValue((Object)context, data, index, groupIndex);
                if (1 == labelPosition && (elementColor = self._colorPalette.getValue(context, data, index, groupIndex)) != null) {
                    return ColorUtil.getContrastColor(elementColor, labelColor).toString();
                }
                return labelColor;
            }
        };
    }

    private ValueFunction<Object, String> getXOffset() {
        final PointComponentImpl self = this;
        return new ValueFunction<Object, String>(){

            public String getValue(Object context, Object data, int index, int groupIndex) {
                double padding = 5.0;
                if (self._itemLabelPosition == null) {
                    return "0em";
                }
                Integer labelPosition = (Integer)self._itemLabelPosition.getValue(context, data, index, groupIndex);
                if (3 == labelPosition) {
                    return "-" + (Math.sqrt((Double)self.finalSize(self._defaultSize, self._symbol).getValue(context, data, index, groupIndex)) / 2.0 + padding) + "px";
                }
                if (4 == labelPosition) {
                    return "" + (Math.sqrt((Double)self.finalSize(self._defaultSize, self._symbol).getValue(context, data, index, groupIndex)) / 2.0 + padding) + "px";
                }
                if (5 == labelPosition) {
                    return "" + Math.sqrt((Double)self.finalSize(self._defaultSize, self._symbol).getValue(context, data, index, groupIndex)) / 2.0 + "px";
                }
                return "0em";
            }
        };
    }

    private ValueFunction<Object, String> getYOffset() {
        final PointComponentImpl self = this;
        return new ValueFunction<Object, String>(){

            public String getValue(Object context, Object data, int index, int groupIndex) {
                double padding = 5.0;
                if (self._itemLabelPosition == null) {
                    return "0.3em";
                }
                Integer labelPosition = (Integer)self._itemLabelPosition.getValue(context, data, index, groupIndex);
                if (0 == labelPosition) {
                    return "-" + (Math.sqrt((Double)self.finalSize(self._defaultSize, self._symbol).getValue(context, data, index, groupIndex)) / 2.0 + padding) + "px";
                }
                if (2 == labelPosition) {
                    double fontHeight = CSSConverter.convertCSSSizeToPixelNumber((Object)"1em", (double)100.0, (double)10.0);
                    return "" + (Math.sqrt((Double)self.finalSize(self._defaultSize, self._symbol).getValue(context, data, index, groupIndex)) / 2.0 + fontHeight + padding) + "px";
                }
                if (5 == labelPosition) {
                    return "-" + Math.sqrt((Double)self.finalSize(self._defaultSize, self._symbol).getValue(context, data, index, groupIndex)) / 2.0 + "px";
                }
                return "0.3em";
            }
        };
    }

    public PointComponentImpl data(Object[] data) {
        this._data = data;
        return this;
    }

    public PointComponentImpl independentAccessor(SingleValueFunction<Object, Object> independentAccessor) {
        this._independentAccessor = independentAccessor;
        return this;
    }

    public PointComponentImpl independentScale(CoordinateScaleImpl independentScale) {
        this._independentScale = independentScale;
        return this;
    }

    public PointComponentImpl dependentAccessor(SingleValueFunction<Object, Object> dependentAccessor) {
        this._dependentAccessor = dependentAccessor;
        return this;
    }

    public PointComponentImpl dependentScale(CoordinateScaleImpl dependentScale) {
        this._dependentScale = dependentScale;
        return this;
    }

    public PointComponentImpl colorPalette(Palette colorPalette) {
        this._colorPalette = colorPalette;
        return this;
    }

    public PointComponentImpl sizeAccessor(SingleValueFunction<Object, Object> sizeAccessor) {
        this._sizeAccessor = sizeAccessor;
        return this;
    }

    public PointComponentImpl sizeScale(AbstractScale<?, ?> sizeScale) {
        this._sizeScale = sizeScale;
        return this;
    }

    public PointComponentImpl labelAccessor(SingleValueFunction<Object, Object> labelAccessor) {
        this._labelAccessor = labelAccessor;
        return this;
    }

    public PointComponentImpl labelFormatter(ValueFunction<Object, String> labelFormatter) {
        this._labelFormatter = labelFormatter;
        return this;
    }

    @Override
    public PointComponentImpl itemLabelPosition(ValueFunction<Object, Integer> labelPosition) {
        this._itemLabelPosition = labelPosition;
        return this;
    }

    public PointComponentImpl bounds(RectStruct bounds) {
        this._bounds = bounds;
        return this;
    }

    public PointComponentImpl transpose(boolean transpose) {
        this._transpose = transpose;
        return this;
    }

    @Override
    public PointComponent defaultSize(double defaultSize) {
        this._defaultSize = defaultSize;
        return this;
    }

    @Override
    public PointComponent itemLabel(boolean itemLabel) {
        this._itemLabel = itemLabel;
        return this;
    }

    public PointComponentImpl labelFont(OMap<String, Object> labelFont) {
        this._labelFontStyle = labelFont;
        return this;
    }

    @Override
    public PointComponent itemOverlap(boolean itemOverlap) {
        this._itemOverlap = itemOverlap;
        return this;
    }

    @Override
    public PointComponent symbol(String symbol) {
        this._prevSymbol = this._symbol;
        this._symbol = symbol;
        return this;
    }

    public PointComponentImpl effect(String effect) {
        this._effect = effect;
        return this;
    }

    @Override
    public PointComponent borderWidth(String borderWidth) {
        this._borderWidth = borderWidth;
        return this;
    }

    @Override
    public PointComponent borderColor(String borderColor) {
        this._borderColor = borderColor;
        return this;
    }

    @Override
    public PointComponent labelLayerClassName(String className) {
        this._labelLayerClass = className;
        return this;
    }

    @Override
    public PointComponent elementLayerClassName(String className) {
        this._elementLayerClass = className;
        return this;
    }

    public PointComponentImpl labelContrast(boolean labelContrast) {
        this._labelContrast = labelContrast;
        return this;
    }

    public PointComponentImpl labelShadow(boolean labelShadow) {
        this._labelShadow = labelShadow;
        return this;
    }
}

