/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.components;

import com.ibm.rave.bundles.components.BackgroundComponentImpl;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.ext.text.nativeImpl.FontChecker;
import com.ibm.rave.ext.text.wrap.TextFlow;

public class RadarBackgroundComponentImpl
extends BackgroundComponentImpl {
    private Object[] _ticks;
    private RectStruct _bounds;
    private Object[] _spokeData;
    private double _radius;
    private double _zoomScale = 1.0;
    private static int _tickSize = 10;

    @Override
    protected void execute(Selector g) {
        if (this._spokeData == null || this._spokeData.length == 0) {
            g.selectAll("*").remove();
            return;
        }
        g.attr("transform", (Object)("translate(" + (this._bounds.x + this._bounds.width / 2.0) + "," + (this._bounds.y + this._bounds.height / 2.0) + ")"));
        this._radius = Math.min(this._bounds.width / 2.0, this._bounds.height / 2.0) * 0.85 * this._zoomScale;
        Selector gridline = g.selectAll(".gridline").data(this._ticks);
        final int tickSize = this._ticks.length;
        Selector enter = gridline.enter().append("g").attr("class", (Object)"gridline").classed("axis", (ValueFunction)new ValueFunction<SceneNode, Boolean>(){

            @SwiftMethodOverload(skipParameters={1})
            public Boolean getValue(SceneNode context, Object data, int index, int groupIndex) {
                return index == tickSize - 1;
            }
        }).classed("grid", (ValueFunction)new ValueFunction<SceneNode, Boolean>(){

            @SwiftMethodOverload(skipParameters={1})
            public Boolean getValue(SceneNode context, Object data, int index, int groupIndex) {
                return index != tickSize - 1;
            }
        });
        enter.append("path").attr("class", (Object)"grid").attr("d", this.getGridlinePos(true));
        enter.append("text").attr("class", (Object)"tick").attr("x", (Object)0).attr("y", (Object)0);
        enter.append("line").attr("class", (Object)"grid-tick-line").attr("x1", (Object)0).attr("y1", (Object)0).attr("x2", (Object)0).attr("y2", (Object)0);
        FontChecker fontChecker = (FontChecker)Rave.capabilities.extension("fontchecker");
        Rave.transition((Selection)gridline.select((Object)".grid")).attr("d", this.getGridlinePos(false));
        Selector tickLabels = gridline.select((Object)".tick").text(this.getLabel());
        if (fontChecker != null) {
            tickLabels.call((RunFunction)fontChecker, new Object[0]);
        }
        Rave.transition((Selection)tickLabels).attr("x", this.getTickPos("x", true)).attr("y", this.getTickPos("y", false));
        Rave.transition((Selection)gridline.select((Object)".grid-tick-line")).attr("x1", this.getTickPos("x", false)).attr("y1", this.getTickPos("y", false)).attr("x2", this.getTickPos("x", true)).attr("y2", this.getTickPos("y", false));
        gridline.exit().remove();
        Selector spoke = g.selectAll(".spoke").data(this._spokeData);
        Selector spokeEnter = spoke.enter().append("g").attr("class", (Object)"spoke").classed("axis", (ValueFunction)new ValueFunction<SceneNode, Boolean>(){

            @SwiftMethodOverload(skipParameters={1})
            public Boolean getValue(SceneNode context, Object data, int index, int groupIndex) {
                return index == 0;
            }
        }).classed("grid", (ValueFunction)new ValueFunction<SceneNode, Boolean>(){

            @SwiftMethodOverload(skipParameters={1})
            public Boolean getValue(SceneNode context, Object data, int index, int groupIndex) {
                return index != 0;
            }
        });
        spokeEnter.append("line").attr("class", (Object)"spoke-line").attr("x1", (Object)0).attr("y1", (Object)0).attr("x2", (Object)0).attr("y2", (Object)0);
        spokeEnter.append("line").attr("class", (Object)"spoke-tick-line").attr("x1", (Object)0).attr("y1", (Object)0).attr("x2", (Object)0).attr("y2", (Object)0);
        spokeEnter.append("text").attr("class", (Object)"spoke-label").attr("x", (Object)0).attr("y", (Object)0);
        Rave.transition((Selection)spoke.select((Object)".spoke-line")).attr("x2", this.getSpokePos("x2", false)).attr("y2", this.getSpokePos("y2", false));
        Rave.transition((Selection)spoke.select((Object)".spoke-tick-line")).attr("x1", this.getSpokePos("x2", false)).attr("y1", this.getSpokePos("y2", false)).attr("x2", this.getSpokePos("x2", true)).attr("y2", this.getSpokePos("y2", true));
        Selector spokeLabels = spoke.select((Object)".spoke-label").text(this.getLabel());
        if (fontChecker != null) {
            spokeLabels.call((RunFunction)fontChecker, new Object[0]);
        }
        final RadarBackgroundComponentImpl self = this;
        spokeLabels.attr("width", (ValueFunction)new ValueFunction<SceneNode, Object>(){

            public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                double theta = Math.PI * 2 * (double)index / (double)self._spokeData.length;
                double sinValue = Math.sin(theta) * (double)(theta < Math.PI ? 1 : -1);
                double maxWidth = ((RadarBackgroundComponentImpl)self)._bounds.width / 2.0 - self._radius * sinValue;
                return (maxWidth /= 1.1) + "px";
            }
        });
        TextFlow textflow = (TextFlow)Rave.capabilities.extension("textflow");
        textflow.wrap(false).fit(false).truncate(true);
        spokeLabels.call((RunFunction)textflow, new Object[0]);
        Rave.transition((Selection)spokeLabels).attr("transform", this.getSpokeLabelPosAsTranslate()).style("text-anchor", this.getSpokeLabelAnchor());
        spoke.exit().remove();
    }

    private ValueFunction<? super SceneNode, ?> getGridlinePos(final boolean entrance) {
        final double factor = this._radius / (double)this._ticks.length;
        final int count = this._spokeData.length;
        return new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object d, int index, int groupIndex) {
                String result = "M";
                for (int j = 0; j <= count; ++j) {
                    if (j > 0) {
                        result = result + "L";
                    }
                    result = entrance ? result + "0 ,  0" : result + -1.0 * factor * (double)(index + 1) * Math.sin((double)(2 * j) * Math.PI / (double)count) + "," + -1.0 * factor * (double)(index + 1) * Math.cos((double)(2 * j) * Math.PI / (double)count);
                }
                return result + "Z";
            }
        };
    }

    private ValueFunction<? super SceneNode, ?> getSpokePos(final String type, final boolean ticks) {
        final RadarBackgroundComponentImpl self = this;
        final double factor = Math.PI * 2 / (double)self._spokeData.length;
        return new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object d, int index, int groupIndex) {
                if (type.equals("x2")) {
                    if (ticks) {
                        double value = -1.0 * (self._radius + (double)_tickSize) * Math.sin((double)index * factor);
                        return value;
                    }
                    double value = -1.0 * self._radius * Math.sin((double)index * factor);
                    return value;
                }
                if (ticks) {
                    double value = -1.0 * (self._radius + (double)_tickSize) * Math.cos((double)index * factor);
                    return value;
                }
                double value = -1.0 * self._radius * Math.cos((double)index * factor);
                return value;
            }
        };
    }

    private ValueFunction<? super SceneNode, ?> getSpokeLabelPosAsTranslate() {
        final RadarBackgroundComponentImpl self = this;
        final double factor = Math.PI * 2 / (double)this._spokeData.length;
        return new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object d, int index, int groupIndex) {
                double x = -1.1 * self._radius * Math.sin((double)index * factor);
                double y = -1.1 * self._radius * Math.cos((double)index * factor);
                return "translate(" + x + "," + y + ")";
            }
        };
    }

    private ValueFunction<? super SceneNode, ?> getSpokeLabelAnchor() {
        final double factor = Math.PI * 2 / (double)this._spokeData.length;
        return new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object d, int index, int groupIndex) {
                double angle = (double)index * factor;
                if (angle == 0.0 || angle == Math.PI) {
                    return "middle";
                }
                return angle < Math.PI ? "end" : "start";
            }
        };
    }

    private ValueFunction<? super SceneNode, ?> getTickPos(final String type, final boolean ticks) {
        final double factor = this._radius / (double)this._ticks.length;
        return new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object d, int index, int groupIndex) {
                if (type.equals("x")) {
                    if (ticks) {
                        return _tickSize;
                    }
                    return 0;
                }
                double value = -1.0 * factor * (double)(index + 1) * Math.cos(0.0);
                if (ticks) {
                    return value + (double)_tickSize;
                }
                return value;
            }
        };
    }

    private ValueFunction<? super SceneNode, ?> getLabel() {
        return new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object d, int index, int groupIndex) {
                return d;
            }
        };
    }

    @Override
    public String type() {
        return "RadarBackgroundComponent";
    }

    public RadarBackgroundComponentImpl ticks(Object[] ticks) {
        this._ticks = ticks;
        return this;
    }

    public RadarBackgroundComponentImpl bounds(RectStruct bounds) {
        this._bounds = bounds;
        return this;
    }

    public RadarBackgroundComponentImpl spokeData(Object[] data) {
        this._spokeData = data;
        return this;
    }

    public RadarBackgroundComponentImpl zoomScale(double scale) {
        this._zoomScale = scale;
        return this;
    }
}

