/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.components;

import com.ibm.rave.bundles.component.RadarComponent;
import com.ibm.rave.bundles.components.KeyedBundleComponentImpl;
import com.ibm.rave.bundles.data.LineDataUtilities;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.svg.LineRadial;
import com.ibm.rave.library.palette.Palette;

public class RadarComponentImpl
extends KeyedBundleComponentImpl<RadarComponentImpl>
implements RadarComponent {
    private ArrayEx<Object> _pointData;
    private ArrayEx<LineDataUtilities.LineDatum> pathdata;
    private SingleValueFunction<Object, Object> _xAccessor;
    private SingleValueFunction<Object, Object> _yAccessor;
    private AbstractScale _valueScale;
    private AbstractScale _categoryScale;
    private Palette _pointColorPalette;
    private Palette _pathColorPalette;
    private RectStruct _bounds;
    private double _radius;
    private double _zoomScale = 1.0;
    private LineRadial.RadialLinePathGenerator _pathGenerator;

    @Override
    protected void execute(Selector g) {
        if (this.pathdata == null || this.pathdata.size() == 0) {
            g.selectAll("*").remove();
            return;
        }
        this._radius = Math.min(this._bounds.width / 2.0, this._bounds.height / 2.0) * 0.85 * this._zoomScale;
        g.attr("transform", (Object)("translate(" + (this._bounds.x + this._bounds.width / 2.0) + "," + (this._bounds.y + this._bounds.height / 2.0) + ")"));
        this._pathGenerator = Rave.svg.line.radial();
        Selector path = g.selectAll(".element-path").data(this.pathdata.toArray());
        path.enter().append("path").attr("class", (Object)"element-path element-shape").attr("d", this.getPath(true));
        path.style("stroke", (ValueFunction)this._pathColorPalette);
        Rave.transition((Selection)path).attr("d", this.getPath(false));
        path.exit().remove();
        Selector points = g.selectAll(".element-point").data(this._pointData);
        points.enter().append("circle").attr("class", (Object)"element-point element-shape").attr("r", (Object)4).attr("cx", (Object)0).attr("cy", (Object)0);
        points.style("fill", (ValueFunction)this._pointColorPalette);
        Rave.transition((Selection)points).attr("cx", this.getPointPos("cx")).attr("cy", this.getPointPos("cy"));
        points.exit().remove();
    }

    private ValueFunction<? super SceneNode, ?> getPath(final boolean entrance) {
        final RadarComponentImpl self = this;
        return new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                ArrayEx<ArrayEx<Object>> points = ((LineDataUtilities.LineDatum)data).points;
                self._pathGenerator.angle(self.getAngle());
                if (entrance) {
                    self._pathGenerator.radius(0.0);
                } else {
                    self._pathGenerator.radius(self.getRadius());
                }
                return self._pathGenerator.getValue(context, points, index, groupIndex) + "Z";
            }
        };
    }

    private ValueFunction<Object, Object> getRadius() {
        final RadarComponentImpl self = this;
        return new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return ObjectConverter.toDouble((Object)self._valueScale.getValue(context, ((ArrayEx)data).get(1), index, groupIndex)) * self._radius;
            }
        };
    }

    private ValueFunction<Object, Object> getAngle() {
        final RadarComponentImpl self = this;
        return new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return ObjectConverter.toDouble((Object)self._categoryScale.getValue(context, ((ArrayEx)data).get(0), index, groupIndex)) * -1.0;
            }
        };
    }

    private ValueFunction<? super SceneNode, ?> getPointPos(final String type) {
        final RadarComponentImpl self = this;
        return new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object d, int index, int groupIndex) {
                double v1 = ObjectConverter.toDouble((Object)self._categoryScale.getValue(context, self._xAccessor.getValue(d), index, groupIndex));
                double v2 = ObjectConverter.toDouble((Object)self._valueScale.getValue(context, self._yAccessor.getValue(d), index, groupIndex));
                if (type.equals("cx")) {
                    double value = -1.0 * self._radius * v2 * Math.sin(v1);
                    return value;
                }
                double value = -1.0 * self._radius * v2 * Math.cos(v1);
                return value;
            }
        };
    }

    @Override
    public String type() {
        return "RadarComponent";
    }

    public RadarComponentImpl pointData(ArrayEx<Object> data) {
        this._pointData = data;
        return this;
    }

    public RadarComponentImpl xAccessor(SingleValueFunction<Object, Object> xAccessor) {
        this._xAccessor = xAccessor;
        return this;
    }

    public RadarComponentImpl yAccessor(SingleValueFunction<Object, Object> xAccessor) {
        this._yAccessor = xAccessor;
        return this;
    }

    public RadarComponentImpl valueScale(AbstractScale scale) {
        this._valueScale = scale;
        return this;
    }

    public RadarComponentImpl categoryScale(AbstractScale scale) {
        this._categoryScale = scale;
        return this;
    }

    public RadarComponentImpl pointColorPalette(Palette colorPalette) {
        this._pointColorPalette = colorPalette;
        return this;
    }

    public RadarComponentImpl pathColorPalette(Palette colorPalette) {
        this._pathColorPalette = colorPalette;
        return this;
    }

    public RadarComponentImpl bounds(RectStruct bounds) {
        this._bounds = bounds;
        return this;
    }

    public RadarComponentImpl pathData(ArrayEx<LineDataUtilities.LineDatum> data) {
        this.pathdata = data;
        return this;
    }

    public RadarComponentImpl zoomScale(double scale) {
        this._zoomScale = scale;
        return this;
    }
}

