/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.components;

import com.ibm.rave.bundles.component.TreemapComponent;
import com.ibm.rave.bundles.components.KeyedBundleComponentImpl;
import com.ibm.rave.bundles.treemapBundle.IndexedTreemapNode;
import com.ibm.rave.bundles.utilities.ColorUtil;
import com.ibm.rave.bundles.utilities.FontPropertyParser;
import com.ibm.rave.bundles.utilities.LabelStyleUtil;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.Insets;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.layout.hierarchy.HierarchyBase;
import com.ibm.rave.core.layout.treemap.Treemap;
import com.ibm.rave.core.layout.treemap.TreemapNode;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.util.Comparator;
import com.ibm.rave.ext.text.nativeImpl.FontChecker;
import com.ibm.rave.ext.text.wrap.TextFlow;
import com.ibm.rave.library.framework.internal.CSSConverter;
import com.ibm.rave.library.palette.Palette;
import java.util.List;

public class TreemapComponentImpl
extends KeyedBundleComponentImpl<TreemapComponentImpl>
implements TreemapComponent {
    public static final String SIZEBY_SIZE = "size";
    public static final String SIZEBY_COUNT = "count";
    public static final String MODE_SQUARIFY = "squarify";
    public static final String MODE_SLICE = "slice";
    public static final String MODE_DICE = "dice";
    public static final String MODE_SLICE_DICE = "slice-dice";
    public static final String SORT_NONE = "none";
    public static final String SORT_ASCENDING = "ascending";
    public static final String SORT_DESCENDING = "descending";
    public static final Insets TEXT_PADDING = TreemapComponentImpl.getPadding();
    private ArrayEx<?> _data;
    private Palette _colorPalette = null;
    private ValueFunction<Object, Object> _labelAccessor = null;
    private ValueFunction<Object, String> _labelFormatter = null;
    private String _sizeBy = "count";
    private RectStruct _bounds = null;
    private String _mode = "squarify";
    private ValueFunction<Object, Object> _titleAccessor;
    private boolean _itemLabel = true;
    private boolean _leadLabel = false;
    private String _sort = "none";
    private int _borderWidth = 1;
    private String _borderColor = null;
    private int _maxLevel;
    private OMap<String, Object> _labelStyle;
    private SingleValueFunction<TreemapNode, Object> _treemapNodeAccessor = DEFAULT_TREEMAPNODE_ACCESSOR;
    private int _previousDataSize = 1;
    private ArrayEx<?> _labelData;
    private SingleValueFunction<Object, Object> _sizeAccessor;
    private int _itemLabelLevel = 1;
    private boolean _labelContrast = false;
    private boolean _labelShadow = false;
    private LabelStyleUtil _labelStyleUtil;
    private static ValueFunction<Object, Object> defaultKeyFunction = new ValueFunction<Object, Object>(){

        public Object getValue(Object context, Object data, int index, int groupIndex) {
            return index;
        }
    };
    private static final SingleValueFunction<TreemapNode, Object> DEFAULT_TREEMAPNODE_ACCESSOR = new SingleValueFunction<TreemapNode, Object>(){

        public TreemapNode getValue(Object data) {
            return (TreemapNode)data;
        }
    };

    public TreemapComponentImpl() {
        this._labelStyle = new OMap();
        this._labelStyleUtil = new LabelStyleUtil();
    }

    @Override
    public String type() {
        return "TreemapComponent";
    }

    private static Insets getPadding() {
        Insets p = new Insets();
        p.left = 3;
        p.top = 5;
        p.bottom = 1;
        p.right = 0;
        return p;
    }

    public Treemap buildLayout() {
        final TreemapComponentImpl self = this;
        Treemap treemap = Rave.layout.treemap().size((List)new ArrayEx((Object[])new Integer[]{ObjectConverter.toInt((Object)this._bounds.width), ObjectConverter.toInt((Object)this._bounds.height)})).sticky(true).mode(this._mode).padding(0.0);
        treemap.value((HierarchyBase.GetNodeValue)new HierarchyBase.GetNodeValue<TreemapNode, Treemap>(){

            public Object get(Treemap hierarchy, TreemapNode node, int depth) {
                return TreemapComponentImpl.SIZEBY_SIZE.equals(self._sizeBy) ? self._sizeAccessor.getValue(node.data) : Integer.valueOf(1);
            }
        });
        treemap.sort((Comparator)(this._sort.equals(SORT_NONE) ? new Comparator<TreemapNode>(){

            public int compare(TreemapNode a, TreemapNode b) {
                int val = ((IndexedTreemapNode)a)._index - ((IndexedTreemapNode)b)._index;
                return val == 0 ? 0 : (val < 0 ? 1 : -1);
            }
        } : new Comparator<TreemapNode>(){

            public int compare(TreemapNode a, TreemapNode b) {
                double val = a.value - b.value;
                if (self._sort.equals(TreemapComponentImpl.SORT_DESCENDING)) {
                    return val == 0.0 ? 0 : (val > 0.0 ? 1 : -1);
                }
                return val == 0.0 ? 0 : (val < 0.0 ? 1 : -1);
            }
        }));
        return treemap;
    }

    @Override
    protected void execute(Selector g) {
        this.preExecute();
        if (this._data == null || this._data.size() == 0) {
            g.selectAll("*").remove();
            return;
        }
        boolean cleared = this.preprocessForLargeData(g);
        String initialTranslate = "translate(0," + this._bounds.height / 2.0 + ")";
        Selector node = g.selectAll(".nodes").data(new Object[]{0});
        node.enter().append("g").attr("class", (Object)"nodes");
        Selector cell = node.selectAll(".cell").data(this._data.toArray(), this.getKey() != null ? this.getKey() : defaultKeyFunction);
        Selector cellEnter = cell.enter().insert("g").attr("class", (Object)"cell").classed("element-shape", true);
        cellEnter.append("rect").attr("transform", (Object)initialTranslate).attr("width", (Object)0).attr("height", (Object)0);
        if (!cleared) {
            cell.order();
        }
        this._maxLevel = 1;
        for (Object o : this._data) {
            this._maxLevel = Math.max(this._maxLevel, ((TreemapNode)this._treemapNodeAccessor.getValue(o)).depth);
        }
        final TreemapComponentImpl self = this;
        cell.select((Object)"rect").attr("class", this.nodeClass());
        cell.select((Object)".empty").attr("width", (Object)0).attr("height", (Object)0);
        Rave.transition((Selection)cell.select((Object)".valid")).style("fill", this.nodeColor()).style("stroke", (Object)this._borderColor).style("stroke-width", (ValueFunction)new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return (self._maxLevel - ((TreemapNode)((TreemapComponentImpl)self)._treemapNodeAccessor.getValue((Object)data)).depth) * 2 + self._borderWidth + "px";
            }
        }).attr("transform", this.translate()).attr("width", (ValueFunction)new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return ((TreemapNode)((TreemapComponentImpl)self)._treemapNodeAccessor.getValue((Object)data)).dx;
            }
        }).attr("height", (ValueFunction)new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return ((TreemapNode)((TreemapComponentImpl)self)._treemapNodeAccessor.getValue((Object)data)).dy;
            }
        });
        Rave.transition((Selection)cell.exit().select((Object)".rect")).attr("width", (Object)0).attr("height", (Object)0).remove();
        Rave.transition((Selection)cell.exit()).remove();
        Selector labels = g.selectAll(".labels").data(new Object[]{1});
        labels.enter().append("g").attr("class", (Object)"labels");
        if (!this._itemLabel) {
            labels.selectAll("*").remove();
        } else {
            this.drawLabels(labels);
        }
    }

    private void drawLabels(Selector labels) {
        final TreemapComponentImpl self = this;
        Selector label = labels.selectAll("g").data(this._labelData != null ? this._labelData.toArray() : this._data.toArray(), this.getKey() != null ? this.getKey() : defaultKeyFunction);
        String initialTranslate = "translate(0," + this._bounds.height / 2.0 + ")";
        if (this._itemLabelLevel > this._maxLevel) {
            this._itemLabelLevel = this._maxLevel;
        }
        Selector labelEnter = label.enter().append("g").attr("transform", (Object)initialTranslate);
        labelEnter.append("text").style("font-size", (Object)"1px");
        label.attr("class", this.labelClass());
        Selector emptyLabels = labels.selectAll(".empty");
        emptyLabels.select((Object)"text").text((Object)"");
        ValueFunction<Object, Object> labelText = this._labelFormatter == null ? this._labelAccessor : new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                Object v = self._labelAccessor == null ? null : self._labelAccessor.getValue(context, data, index, groupIndex);
                return v == null ? null : self._labelFormatter.getValue(context, v, index, groupIndex);
            }
        };
        FontChecker fontChecker = (FontChecker)Rave.capabilities.extension("fontchecker");
        Selector validLabel = labels.selectAll(".label");
        Rave.transition((Selection)validLabel).attr("transform", this.translate());
        Selector text = validLabel.select((Object)"text");
        final String labelColor = this.getDefaultLabelColor(this._labelStyle);
        text.text((ValueFunction)labelText).attr("width", (ValueFunction)new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return Math.max(0.0, ((TreemapNode)((TreemapComponentImpl)self)._treemapNodeAccessor.getValue((Object)data)).dx - (double)(TreemapComponentImpl.TEXT_PADDING.left + TreemapComponentImpl.TEXT_PADDING.right));
            }
        }).attr("height", (ValueFunction)new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return Math.max(0.0, ((TreemapNode)((TreemapComponentImpl)self)._treemapNodeAccessor.getValue((Object)data)).dy - (double)(TreemapComponentImpl.TEXT_PADDING.top + TreemapComponentImpl.TEXT_PADDING.bottom));
            }
        }).attr("y", (ValueFunction)new ValueFunction<Object, String>(){

            public String getValue(Object context, Object data, int index, int groupIndex) {
                TreemapNode node = (TreemapNode)self._treemapNodeAccessor.getValue(data);
                if (self._leadLabel) {
                    if (node.depth == 1) {
                        return (self._maxLevel - node.depth) * 2 + self._borderWidth + 14 + "px";
                    }
                    if (node.depth == 2 || node.depth == self._itemLabelLevel - 1) {
                        return Math.round(node.dy - 10.0) + "px";
                    }
                    if (node.depth == self._itemLabelLevel) {
                        return Math.round(node.dy / 2.0) + "px";
                    }
                }
                return (self._maxLevel - node.depth) * 2 + self._borderWidth + 14 + "px";
            }
        }).attr("x", (ValueFunction)new ValueFunction<Object, String>(){

            public String getValue(Object context, Object data, int index, int groupIndex) {
                TreemapNode node = (TreemapNode)self._treemapNodeAccessor.getValue(data);
                int borderwidth = (self._maxLevel - node.depth) * 2 + self._borderWidth;
                if (self._leadLabel) {
                    if (node.depth == self._itemLabelLevel && self._itemLabelLevel > 2 && self._leadLabel) {
                        return Math.round(node.dx - (double)borderwidth - 2.0) + "px";
                    }
                    return borderwidth + 2 + "px";
                }
                return borderwidth + 2 + "px";
            }
        }).attr("text-anchor", (ValueFunction)new ValueFunction<Object, String>(){

            public String getValue(Object context, Object data, int index, int groupIndex) {
                if (self._leadLabel) {
                    TreemapNode node = (TreemapNode)self._treemapNodeAccessor.getValue(data);
                    if (node.depth == self._itemLabelLevel && self._itemLabelLevel > 2 && self._leadLabel) {
                        return "end";
                    }
                }
                return "start";
            }
        });
        text.call((RunFunction)fontChecker, new Object[0]);
        TextFlow textflow = (TextFlow)Rave.capabilities.extension("textflow");
        textflow.wrap(false).fit(false).padding(0, 0, 0, 0).truncate(true).alignment("left");
        text.call((RunFunction)textflow, new Object[0]);
        this._labelStyleUtil.labelFont(this._labelStyle).labelFontSize(new ValueFunction<SceneNode, String>(){

            public String getValue(SceneNode context, Object data, int index, int groupIndex) {
                String fontPixel;
                String string = fontPixel = self._labelStyle != null && self._labelStyle.get((Object)"font-size") != null ? ObjectConverter.asString((Object)self._labelStyle.get((Object)"font-size")) : "14px";
                if (self._leadLabel && self._itemLabelLevel > 1) {
                    int fontsize = CSSConverter.convertCSSSizeToPixelNumber((Object)fontPixel, (double)100.0, (double)10.0).intValue();
                    TreemapNode node = (TreemapNode)self._treemapNodeAccessor.getValue(data);
                    if (node.depth == self._itemLabelLevel && self._itemLabelLevel > 2) {
                        return fontsize - 4 <= 0 ? fontPixel : fontsize - 4 + "px";
                    }
                    if (node.depth == 1) {
                        return fontPixel;
                    }
                    return fontsize - 2 <= 0 ? fontPixel : fontsize - 2 + "px";
                }
                return fontPixel;
            }
        }).labelFillColor(this._labelContrast ? new ValueFunction<SceneNode, String>(){

            public String getValue(SceneNode context, Object data, int index, int groupIndex) {
                if (self._colorPalette == null) {
                    return labelColor;
                }
                return ColorUtil.getContrastColor(self._colorPalette.getValue(null, data, index, groupIndex), labelColor).toString();
            }
        } : new ValueFunction<SceneNode, String>(){

            public String getValue(SceneNode context, Object data, int index, int groupIndex) {
                return labelColor;
            }
        }).labelShadow(this._labelShadow);
        text.call((RunFunction)this._labelStyleUtil, new Object[0]);
        Rave.transition((Selection)label.exit().select((Object)"text")).style("fill-opacity", (Object)1.0E-6).remove();
        Rave.transition((Selection)label.exit()).remove();
    }

    private boolean preprocessForLargeData(Selector g) {
        boolean cleared = false;
        if (Math.min(this._previousDataSize, this._data.size()) >= 3000) {
            if (Math.max(this._previousDataSize, this._data.size()) / Math.min(this._previousDataSize, this._data.size()) >= 2) {
                g.selectAll("*").remove();
                cleared = true;
            }
        } else if (Math.max(this._previousDataSize, this._data.size()) >= 10000 && Math.max(this._previousDataSize, this._data.size()) / Math.min(this._previousDataSize, this._data.size()) >= 5) {
            g.selectAll("*").remove();
            cleared = true;
        }
        this._previousDataSize = this._data.size();
        return cleared;
    }

    private final ValueFunction<Object, Object> labelClass() {
        final TreemapComponentImpl self = this;
        return new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object d, int index, int groupIndex) {
                if (self._labelAccessor == null) {
                    return "empty";
                }
                String v = ObjectConverter.asString((Object)self._labelAccessor.getValue(null, d, 0, 0));
                if (v == null || v.trim().length() == 0) {
                    return "empty";
                }
                if (((TreemapNode)((TreemapComponentImpl)self)._treemapNodeAccessor.getValue((Object)d)).dx < (double)(5 + TreemapComponentImpl.TEXT_PADDING.left + TreemapComponentImpl.TEXT_PADDING.right)) {
                    return "empty";
                }
                if (((TreemapNode)((TreemapComponentImpl)self)._treemapNodeAccessor.getValue((Object)d)).dy < (double)(5 + TreemapComponentImpl.TEXT_PADDING.top + TreemapComponentImpl.TEXT_PADDING.bottom)) {
                    return "empty";
                }
                return "label";
            }
        };
    }

    private final ValueFunction<Object, Object> nodeClass() {
        final TreemapComponentImpl self = this;
        return new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object d, int index, int groupIndex) {
                if (self.outsideBounds(d)) {
                    return "empty rect";
                }
                return self._mode.equals(TreemapComponentImpl.MODE_SQUARIFY) ? "valid rect squarify" : "valid rect";
            }
        };
    }

    private final ValueFunction<Object, Object> nodeColor() {
        final TreemapComponentImpl self = this;
        return new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object d, int index, int groupIndex) {
                Object v = self._colorPalette.getValue(null, d, 0, 0);
                if (((TreemapNode)((TreemapComponentImpl)self)._treemapNodeAccessor.getValue((Object)d)).children != null) {
                    return "transparent";
                }
                return v != null ? v : "transparent";
            }
        };
    }

    private boolean outsideBounds(Object d) {
        TreemapNode node = (TreemapNode)this._treemapNodeAccessor.getValue(d);
        return node.x + this._bounds.x < 0.0 || node.x > this._bounds.width || node.y + this._bounds.y < 0.0 || node.y > this._bounds.height;
    }

    private Object translate() {
        final TreemapComponentImpl self = this;
        return new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                TreemapNode node = (TreemapNode)self._treemapNodeAccessor.getValue(data);
                return "translate(" + (node.x + ((TreemapComponentImpl)self)._bounds.x) + "," + (node.y + ((TreemapComponentImpl)self)._bounds.y) + ")";
            }
        };
    }

    public TreemapComponentImpl data(ArrayEx<?> data) {
        this._data = data;
        return this;
    }

    public TreemapComponentImpl colorPalette(Palette colorPalette) {
        this._colorPalette = colorPalette;
        return this;
    }

    public TreemapComponentImpl squareSizeBy(String sizeBy) {
        this._sizeBy = sizeBy;
        return this;
    }

    public TreemapComponentImpl labelAccessor(ValueFunction<Object, Object> labelAccessor) {
        this._labelAccessor = labelAccessor;
        return this;
    }

    public TreemapComponentImpl labelFormatter(ValueFunction<Object, String> labelFormatter) {
        this._labelFormatter = labelFormatter;
        return this;
    }

    public TreemapComponentImpl bounds(RectStruct bounds) {
        this._bounds = bounds;
        return this;
    }

    public TreemapComponentImpl mode(String mode) {
        this._mode = mode;
        return this;
    }

    @Override
    public TreemapComponent itemLabel(boolean itemLabel) {
        this._itemLabel = itemLabel;
        return this;
    }

    @Override
    public TreemapComponent itemLabelLevel(int labelLevel) {
        this._itemLabelLevel = labelLevel;
        return this;
    }

    @Override
    public TreemapComponent leadLabel(boolean leadLabel) {
        this._leadLabel = leadLabel;
        return this;
    }

    @Override
    public TreemapComponentImpl labelFont(String fontStyle) {
        this._labelStyle = FontPropertyParser.parseCSSFont(fontStyle);
        return this;
    }

    public TreemapComponentImpl titleAccessor(ValueFunction<Object, Object> titleAccessor) {
        this._titleAccessor = titleAccessor;
        return this;
    }

    public TreemapComponentImpl sort(String order) {
        this._sort = order;
        return this;
    }

    public TreemapComponentImpl treemapNodeAccessor(SingleValueFunction<TreemapNode, Object> accessor) {
        this._treemapNodeAccessor = accessor;
        return this;
    }

    public TreemapComponentImpl labelData(ArrayEx<?> labelData) {
        this._labelData = labelData;
        return this;
    }

    public TreemapComponentImpl sizeAccessor(SingleValueFunction<Object, Object> sizeAccessor) {
        this._sizeAccessor = sizeAccessor;
        return this;
    }

    public TreemapComponentImpl borderWidth(int _borderWidth) {
        this._borderWidth = _borderWidth;
        return this;
    }

    public TreemapComponentImpl borderColor(String borderColor) {
        this._borderColor = borderColor;
        return this;
    }

    public TreemapComponentImpl labelContrast(boolean labelContrast) {
        this._labelContrast = labelContrast;
        return this;
    }

    public TreemapComponentImpl labelShadow(boolean labelShadow) {
        this._labelShadow = labelShadow;
        return this;
    }
}

