/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.components.network;

import com.ibm.json.java.JSONObject;
import com.ibm.rave.bundles.components.BundleComponentImpl;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.event.Event;
import com.ibm.rave.core.geom.Dim;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.layout.force.Force;
import com.ibm.rave.core.layout.force.ForceLink;
import com.ibm.rave.core.layout.force.ForceNode;
import com.ibm.rave.core.math.Random;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.LinearScale;
import com.ibm.rave.core.scales.PowScale;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.SelectorEventListener;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.ext.text.nativeImpl.FontChecker;
import com.ibm.rave.library.palette.Palette;
import java.util.List;

public class NetworkComponentImpl
extends BundleComponentImpl<NetworkComponentImpl> {
    private static final String NODE_ID = "id";
    private static final String NODE_WEIGHT = "weight";
    private Force _force;
    private ArrayEx<ForceNode> _nodes = new ArrayEx();
    private ArrayEx<ForceLink> _links = new ArrayEx();
    private RectStruct _chartRect = new RectStruct(0.0, 0.0, 0.0, 0.0);
    private String _effect = "none";
    private int _duration;
    private Palette _colorPalette = null;
    private int _maxBubble;
    private int _minBubble;
    private int _layoutPadding;
    private String _linkColor;
    private String _valueFontColor = null;
    private String _valueLabelFont = "Ariel";
    private String _fontColor = null;
    private String _labelFont = "Ariel";
    private boolean _showFontShadow = false;
    private String _valueShadowFontColor = null;
    protected String _symbolOutLineColor = "";
    private Selector _selectionShapes;
    private ValueFunction<Object, Object> _radiusFunction;
    private ValueFunction<SceneNode, Number> _x1;
    private ValueFunction<SceneNode, Number> _y1;
    private ValueFunction<SceneNode, Number> _x2;
    private ValueFunction<SceneNode, Number> _y2;
    private ValueFunction<SceneNode, Number> _cx;
    private ValueFunction<SceneNode, Number> _cy;
    private SelectorEventListener<Event> _selectionEvent;
    private SelectorEventListener<Event> _unselectionEvent;
    private SelectorEventListener<Event> _highlightEvent;
    private SelectorEventListener<Event> _unhighlightEvent;

    public NetworkComponentImpl() {
        final NetworkComponentImpl self = this;
        this._x1 = new ValueFunction<SceneNode, Number>(){

            public Number getValue(SceneNode context, Object data, int index, int groupIndex) {
                ForceLink link = (ForceLink)data;
                return link.source.x;
            }
        };
        this._y1 = new ValueFunction<SceneNode, Number>(){

            public Number getValue(SceneNode context, Object data, int index, int groupIndex) {
                ForceLink link = (ForceLink)data;
                return link.source.y;
            }
        };
        this._x2 = new ValueFunction<SceneNode, Number>(){

            public Number getValue(SceneNode context, Object data, int index, int groupIndex) {
                ForceLink link = (ForceLink)data;
                return link.target.x;
            }
        };
        this._y2 = new ValueFunction<SceneNode, Number>(){

            public Number getValue(SceneNode context, Object data, int index, int groupIndex) {
                ForceLink link = (ForceLink)data;
                return link.target.y;
            }
        };
        this._cx = new ValueFunction<SceneNode, Number>(){

            public Number getValue(SceneNode context, Object data, int index, int groupIndex) {
                double radius = ObjectConverter.toDouble((Object)self._radiusFunction.getValue((Object)context, data, index, groupIndex));
                double minX = (double)self._layoutPadding + radius;
                double maxX = ((NetworkComponentImpl)self)._chartRect.width - (double)self._layoutPadding - radius;
                ((ForceNode)data).x = Math.max(minX, Math.min(maxX, ((ForceNode)data).x));
                return ((ForceNode)data).x;
            }
        };
        this._cy = new ValueFunction<SceneNode, Number>(){

            public Number getValue(SceneNode context, Object data, int index, int groupIndex) {
                double radius = ObjectConverter.toDouble((Object)self._radiusFunction.getValue((Object)context, data, index, groupIndex));
                double minY = (double)self._layoutPadding + radius;
                double maxY = ((NetworkComponentImpl)self)._chartRect.height - (double)self._layoutPadding - radius;
                ((ForceNode)data).y = Math.max(minY, Math.min(maxY, ((ForceNode)data).y));
                return ((ForceNode)data).y;
            }
        };
        this._selectionEvent = new SelectorEventListener<Event>(){

            public void onEvent(SceneNode node, Object data, int index, int groupIndex, Event event) {
                if (node.containsClass("selected")) {
                    self.getUnSelectEvent().onEvent(node, data, index, groupIndex, event);
                } else {
                    Rave.select((SceneNode)node.getParentNode()).selectAll(".node").classed("selected", false);
                    node.removeClass("dim");
                    node.addClass("selected");
                    self._selectionShapes.remove();
                    double size = ObjectConverter.toDouble((Object)node.getAttribute("r"));
                    size += size * 0.2;
                    Object[] nodeData = new Object[]{node.getData()};
                    self._selectionShapes = Rave.select((SceneNode)node.getParentNode()).selectAll(".outlinenode").data(nodeData).enter().insert("circle", ".node").style("fill-opacity", (Object)"0.3").attr("cx", self._cx).attr("cy", self._cy).attr("r", (Object)size).style("fill", (Object)ObjectConverter.toString((Object)node.getStyle("fill")));
                }
            }
        };
        this._unselectionEvent = new SelectorEventListener<Event>(){

            public void onEvent(SceneNode node, Object data, int index, int groupIndex, Event event) {
                Rave.select((SceneNode)node.getParentNode()).selectAll(".node").classed("selected", false);
                self._selectionShapes.remove();
            }
        };
        this._highlightEvent = new SelectorEventListener<Event>(){

            public void onEvent(SceneNode node, Object data, int index, int groupIndex, Event event) {
                node.addClass("highlight");
                Rave.select((SceneNode)node.getParentNode()).selectAll(".node").classed("dim", true);
                node.removeClass("dim");
            }
        };
        this._unhighlightEvent = new SelectorEventListener<Event>(){

            public void onEvent(SceneNode node, Object data, int index, int groupIndex, Event event) {
                node.removeClass("highlight");
                Rave.select((SceneNode)node.getParentNode()).selectAll(".node").classed("dim", false);
            }
        };
    }

    @Override
    public String type() {
        return "NetworkComponent";
    }

    @Override
    protected void execute(Selector g) {
        final LinearScale nodeSize = Rave.scale.linear().domain((List)new ArrayEx(new Object[]{0, 100})).range((List)new ArrayEx(new Object[]{this._minBubble, this._maxBubble})).clamp(true);
        this._radiusFunction = new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                ForceNode node = (ForceNode)data;
                return nodeSize.getValue(context, ((JSONObject)node.data).get((Object)NetworkComponentImpl.NODE_WEIGHT), index, groupIndex);
            }
        };
        this.configureLayout();
        g.selectAll("line").remove();
        final Selector linkShapes = this.createLinkShapes(g);
        final Selector nodeShapes = this.createNodeShapes(g);
        final Selector labelShapes = this.createLabelShapes(g);
        this.createSelectionShapes(g);
        this.shapesExit(linkShapes, nodeShapes, labelShapes);
        this.linkShapesEnter(linkShapes);
        this.nodeShapesEnter(nodeShapes);
        this.labelShapesEnter(labelShapes);
        this.linkShapesUpdate(linkShapes);
        this.nodeShapesUpdate(nodeShapes);
        final NetworkComponentImpl self = this;
        RunFunction<Force.EventObject> drawFunction = new RunFunction<Force.EventObject>(){

            public Object run(Force.EventObject context, Object ... args) {
                linkShapes.attr("x1", self._x1).attr("y1", self._y1).attr("x2", self._x2).attr("y2", self._y2);
                nodeShapes.attr("cx", self._cx).attr("cy", self._cy);
                labelShapes.attr("x", self._cx).attr("y", self._cy);
                self._selectionShapes.attr("cx", self._cx).attr("cy", self._cy);
                return null;
            }
        };
        if (!"none".equals(this._effect)) {
            this._force.on("tick", (RunFunction)drawFunction).on("end", null);
        } else {
            this._force.on("tick", null).on("end", (RunFunction)drawFunction);
        }
        this._force.start();
    }

    private void shapesExit(Selector linkShapes, Selector nodeShapes, Selector labelShapes) {
        linkShapes.exit().remove();
        if (!"none".equals(this._effect)) {
            final NetworkComponentImpl self = this;
            final Random.Randomizer random = Rave.random.normal();
            ValueFunction<Object, Object> nodeExitXTransition = new ValueFunction<Object, Object>(){

                public Object getValue(Object context, Object data, int index, int groupIndex) {
                    double randX = random.randomize() * ((NetworkComponentImpl)self)._chartRect.width;
                    randX = randX < ((NetworkComponentImpl)self)._chartRect.width / 2.0 ? (randX -= ((NetworkComponentImpl)self)._chartRect.width + 100.0) : (randX += ((NetworkComponentImpl)self)._chartRect.width + 100.0);
                    return randX;
                }
            };
            ValueFunction<Object, Object> nodeExitYTransition = new ValueFunction<Object, Object>(){

                public Object getValue(Object context, Object data, int index, int groupIndex) {
                    double randY = random.randomize() * ((NetworkComponentImpl)self)._chartRect.height;
                    randY = randY < ((NetworkComponentImpl)self)._chartRect.height / 2.0 ? (randY -= ((NetworkComponentImpl)self)._chartRect.height + 100.0) : (randY += ((NetworkComponentImpl)self)._chartRect.height + 100.0);
                    return randY;
                }
            };
            nodeShapes.exit().transition("exit").duration((Object)this._duration).style("opacity", (Object)0).attr("cx", (ValueFunction)nodeExitXTransition).attr("cy", (ValueFunction)nodeExitYTransition).remove();
            labelShapes.exit().transition("exit").duration((Object)this._duration).style("opacity", (Object)0).attr("cx", (ValueFunction)nodeExitXTransition).attr("cy", (ValueFunction)nodeExitYTransition).remove();
        } else {
            nodeShapes.exit().remove();
            labelShapes.exit().remove();
        }
    }

    private void linkShapesEnter(Selector linkShapes) {
        linkShapes.enter().insert("line", ".node").attr("class", (Object)"link");
    }

    private void nodeShapesEnter(Selector nodeShapes) {
        nodeShapes.enter().append("circle").attr("class", (Object)"node").attr("stroke", (Object)this._symbolOutLineColor);
    }

    private void labelShapesEnter(Selector labelShapes) {
        labelShapes.enter().append("text").attr("class", (Object)"label");
    }

    private void linkShapesUpdate(Selector linkShapes) {
        Double minWeight = ObjectConverter.toDouble((Object)Rave.min((List)this._links.map((ArrayEx.ArrayValueFunction)new ArrayEx.ArrayValueFunction<ForceLink, Object>(){

            public Object getValue(ForceLink currentValue, int index, ArrayEx<ForceLink> array) {
                return currentValue.data;
            }
        })));
        Double maxWeight = ObjectConverter.toDouble((Object)Rave.max((List)this._links.map((ArrayEx.ArrayValueFunction)new ArrayEx.ArrayValueFunction<ForceLink, Object>(){

            public Object getValue(ForceLink currentValue, int index, ArrayEx<ForceLink> array) {
                return currentValue.data;
            }
        })));
        ArrayEx domain = new ArrayEx();
        ArrayEx range = new ArrayEx();
        domain.add((Object)minWeight);
        if (minWeight < 0.0) {
            domain.add((Object)0);
            range.add((Object)3);
        }
        domain.add((Object)maxWeight);
        range.add((Object)1);
        range.add((Object)3);
        final PowScale edgeWidth = Rave.scale.pow().exponent((Number)8).domain((List)domain).range((List)range).clamp(true);
        linkShapes.style("stroke", (Object)this._linkColor).style("stroke-width", (ValueFunction)new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                Object weight = ((ForceLink)data).data;
                return weight != null ? edgeWidth.getValue(context, weight, index, groupIndex) : Integer.valueOf(2);
            }
        }).style("stroke-dasharray", (ValueFunction)new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                double weight = ObjectConverter.toDouble((Object)((ForceLink)data).data);
                return weight < 0.0 ? "3, 5" : null;
            }
        });
    }

    private void nodeShapesUpdate(Selector nodeShapes) {
        nodeShapes.style("fill", (ValueFunction)this._colorPalette).attr("r", this._radiusFunction);
    }

    private void labelShapesUpdate(Selector labelShapes) {
        final NetworkComponentImpl self = this;
        FontChecker fontChecker = (FontChecker)Rave.capabilities.extension("fontchecker");
        labelShapes.style("text-anchor", (Object)"middle").style("outline", (Object)"#000000 solid thin").style("font-family", (Object)this._labelFont).style("font-size", (Object)"14px").style("font-weight", (Object)"300").style("fill", (Object)this._fontColor).attr("width", (ValueFunction)new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return ObjectConverter.toDouble((Object)self._radiusFunction.getValue(context, data, index, groupIndex)) * 2.0;
            }
        }).text((ValueFunction)new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return ((JSONObject)((ForceNode)data).data).get((Object)NetworkComponentImpl.NODE_ID);
            }
        }).call((RunFunction)fontChecker, new Object[0]);
    }

    private Selector createLinkShapes(Selector g) {
        return g.selectAll("line").data(this._links.toArray());
    }

    private Selector createNodeShapes(Selector g) {
        Selector nodeShapes = g.selectAll(".node").data(this._nodes.toArray());
        nodeShapes.classed("selected", false);
        nodeShapes.classed("highlighted", false);
        nodeShapes.classed("dim", false);
        return nodeShapes;
    }

    private Selector createLabelShapes(Selector g) {
        return g.selectAll("text").data(this._nodes.toArray());
    }

    private void createSelectionShapes(Selector g) {
        if (this._selectionShapes != null) {
            this._selectionShapes.remove();
        }
        this._selectionShapes = g.selectAll(".outlinenode");
    }

    private void configureLayout() {
        final NetworkComponentImpl self = this;
        this._force = Rave.layout.force().linkDistance((Object)new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                ForceNode source = ((ForceLink)data).source;
                ForceNode target = ((ForceLink)data).target;
                int sourceSize = ObjectConverter.toInt((Object)self._radiusFunction.getValue(context, (Object)source, index, groupIndex));
                int targetSize = ObjectConverter.toInt((Object)self._radiusFunction.getValue(context, (Object)target, index, groupIndex));
                return Math.max(sourceSize, targetSize) * 5;
            }
        }).charge((Object)new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return ObjectConverter.toInt((Object)self._radiusFunction.getValue(context, data, index, groupIndex)) * -50;
            }
        }).size(new Dim(this._chartRect.width, this._chartRect.height)).nodes(this._nodes).links((ForceLink[])this._links.toArray((Object[])new ForceLink[this._links.size()]));
    }

    public NetworkComponentImpl nodes(List<ForceNode> nodes) {
        this._nodes = ObjectConverter.listToArray(nodes);
        return this;
    }

    public NetworkComponentImpl links(List<ForceLink> links) {
        this._links = ObjectConverter.listToArray(links);
        return this;
    }

    public NetworkComponentImpl size(RectStruct chartRect) {
        this._chartRect = chartRect;
        return this;
    }

    public NetworkComponentImpl colorPalette(Palette colorPalette) {
        this._colorPalette = colorPalette;
        return this;
    }

    public NetworkComponentImpl effect(String effect) {
        this._effect = effect;
        return this;
    }

    public NetworkComponentImpl bubbleMax(int maxSize) {
        this._maxBubble = maxSize;
        return this;
    }

    public NetworkComponentImpl bubbleMin(int minSize) {
        this._minBubble = minSize;
        return this;
    }

    public NetworkComponentImpl layoutPadding(int padding) {
        this._layoutPadding = padding;
        return this;
    }

    public NetworkComponentImpl linkColor(String linkColor) {
        this._linkColor = linkColor;
        return this;
    }

    public NetworkComponentImpl duration(int durationTime) {
        this._duration = durationTime;
        return this;
    }

    public NetworkComponentImpl valueFontColor(String color) {
        this._valueFontColor = color;
        return this;
    }

    public NetworkComponentImpl fontColor(String color) {
        this._fontColor = color;
        return this;
    }

    public NetworkComponentImpl valueShadowFontColor(String color) {
        this._valueShadowFontColor = color;
        return this;
    }

    public NetworkComponentImpl showFontShadow(boolean show) {
        this._showFontShadow = show;
        return this;
    }

    public NetworkComponentImpl valueLabelFont(String font) {
        this._valueLabelFont = font;
        return this;
    }

    public NetworkComponentImpl labelFont(String font) {
        this._labelFont = font;
        return this;
    }

    public NetworkComponentImpl symbolOutlineColor(String color) {
        this._symbolOutLineColor = color;
        return this;
    }

    public SelectorEventListener<Event> getSelectEvent() {
        return this._selectionEvent;
    }

    public SelectorEventListener<Event> getUnSelectEvent() {
        return this._unselectionEvent;
    }

    public SelectorEventListener<Event> getHightlightEvent() {
        return this._highlightEvent;
    }

    public SelectorEventListener<Event> getUnHighlightEvent() {
        return this._unhighlightEvent;
    }
}

