/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.components.network;

import com.ibm.rave.bundles.components.BundleComponentImpl;
import com.ibm.rave.bundles.utilities.BundleSymbolComponent;
import com.ibm.rave.bundles.utilities.FontPropertyParser;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.Dim;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.layout.force.Force;
import com.ibm.rave.core.layout.force.ForceLink;
import com.ibm.rave.core.layout.force.ForceNode;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.LinearScale;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.ext.text.nativeImpl.FontChecker;
import java.util.List;

public class NodeLinkForceComponent
extends BundleComponentImpl<NodeLinkForceComponent> {
    private static final double DEFAULT_SIZE = 64.0;
    public static final double DEFAULT_STROKE_WIDTH = 2.0;
    private static final String LINK_TYPE_LINE = "line";
    private static final String LINK_TYPE_ARC = "arc";
    private final Force _force = Rave.layout.force();
    private final OMap<String, ValueFunction<SceneNode, Object>> _linkPathGenerators = this.buildLinkPathGenerators();
    private ArrayEx<Object> _nodes = new ArrayEx();
    private ArrayEx<Object> _links = new ArrayEx();
    private ArrayEx<ForceNode> _derivedForceNodes = new ArrayEx();
    private ArrayEx<ForceLink> _derivedForceLinks = new ArrayEx();
    private SingleValueFunction<ForceNode, Object> _forceNodeAccessor = DEFAULT_FORCE_NODE_ACCESSOR;
    private SingleValueFunction<ForceLink, Object> _forceLinkAccessor = DEFAULT_FORCE_LINK_ACCESSOR;
    private SingleValueFunction<Object, Object> _nodeSizeAccessor = DEFAULT_SIZE_ACCESSOR;
    private SingleValueFunction<Object, Object> _nodeLabelAccessor = NOOP_ACCESSOR;
    private SingleValueFunction<Object, Object> _linkWeightAccessor = NOOP_ACCESSOR;
    private ValueFunction<Object, Object> _nodeKey = DEFAULT_KEY;
    private ValueFunction<Object, Object> _linkKey = DEFAULT_KEY;
    private ValueFunction<SceneNode, Object> _nodeColorPalette;
    private ArrayEx<Object> _nodeSizeExtent = new ArrayEx(new Object[]{100.0, 500.0});
    private String _nodeSymbolType = "circle";
    private String _linkType = "line";
    private Object _linkStrokeStyle;
    private double _strokeWidth = 2.0;
    private Dim _layoutSize = new Dim(400.0, 400.0);
    private BundleSymbolComponent s = new BundleSymbolComponent();
    private ValueFunction<SceneNode, Object> _nodeTransform;
    private ValueFunction<SceneNode, Object> _linkStrokeDash;
    private OMap<String, Object> _nodeLabelFontStyle = new OMap();
    private static final SingleValueFunction<ForceNode, Object> DEFAULT_FORCE_NODE_ACCESSOR = new SingleValueFunction<ForceNode, Object>(){

        public ForceNode getValue(Object data) {
            ForceNode n = new ForceNode();
            n.data = data;
            return n;
        }
    };
    private static final SingleValueFunction<ForceLink, Object> DEFAULT_FORCE_LINK_ACCESSOR = new SingleValueFunction<ForceLink, Object>(){

        public ForceLink getValue(Object data) {
            ForceLink l = new ForceLink();
            l.data = data;
            return l;
        }
    };
    private static final SingleValueFunction<Object, Object> NOOP_ACCESSOR = new SingleValueFunction<Object, Object>(){

        public Object getValue(Object data) {
            return null;
        }
    };
    private static final SingleValueFunction<Object, Object> DEFAULT_SIZE_ACCESSOR = new SingleValueFunction<Object, Object>(){

        public Object getValue(Object data) {
            return 64.0;
        }
    };
    private static final SingleValueFunction<Object, Object> DEFAULT_LINK_WEIGHT_ACCESSOR = new SingleValueFunction<Object, Object>(){

        public Object getValue(Object data) {
            return 0;
        }
    };
    private static final ValueFunction<Object, Object> DEFAULT_KEY = new ValueFunction<Object, Object>(){

        @SwiftMethodOverload(skipParameters={1})
        public Object getValue(Object context, Object data, int index, int groupIndex) {
            return index;
        }
    };

    public NodeLinkForceComponent() {
        final NodeLinkForceComponent self = this;
        this._nodeTransform = new ValueFunction<SceneNode, Object>(){

            @SwiftMethodOverload(skipParameters={1})
            public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                return "translate(" + ((ForceNode)((NodeLinkForceComponent)self)._forceNodeAccessor.getValue((Object)data)).x + "," + ((ForceNode)((NodeLinkForceComponent)self)._forceNodeAccessor.getValue((Object)data)).y + ")";
            }
        };
        this._linkStrokeDash = new ValueFunction<SceneNode, Object>(){

            public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                if (data == null) {
                    return null;
                }
                double weight = ObjectConverter.toDouble((Object)self._linkWeightAccessor.getValue(data));
                return weight < 0.0 ? "3, 5" : null;
            }
        };
    }

    @Override
    public String type() {
        return "NodeLinkComponent";
    }

    @Override
    protected void execute(Selector g) {
        final NodeLinkForceComponent self = this;
        final LinearScale nodeSize = Rave.scale.linear().domain(Rave.extent((Object[])this._nodes.toArray(), (ValueFunction)new ValueFunction<Object[], Object>(){

            @SwiftMethodOverload(skipParameters={1})
            public Object getValue(Object[] context, Object data, int index, int groupIndex) {
                double rawSize = ((Number)self._nodeSizeAccessor.getValue(data)).doubleValue();
                return Math.abs(rawSize);
            }
        })).range(this._nodeSizeExtent);
        Selector linksGroup = g.selectAll(".links").data(new Object[]{0});
        linksGroup.enter().append("g").classed("links", true);
        Selector nodesGroup = g.selectAll(".nodes").data(new Object[]{0});
        nodesGroup.enter().append("g").classed("nodes", true);
        Selector labelsGroup = g.selectAll(".labels").data(new Object[]{0});
        labelsGroup.enter().append("g").classed("labels", true);
        final Selector links = linksGroup.selectAll(".element-shape.link").data(this._links, this._linkKey);
        links.enter().append("path").classed("element-shape", true).classed("link", true).attr("d", this.getLinkPath(this._linkType)).style("opacity", (Object)0).style("fill", (Object)"transparent").style("stroke", this._linkStrokeStyle).style("stroke-dasharray", this._linkStrokeDash);
        Rave.transition((Selection)links.exit()).style("opacity", (Object)0).remove();
        Rave.transition((Selection)links.style("stroke-dasharray", this._linkStrokeDash)).style("opacity", (Object)1).style("stroke", this._linkStrokeStyle);
        final Selector nodes = nodesGroup.selectAll(".element-shape.node").data(this._nodes, this._nodeKey);
        nodes.enter().append("g").classed("element-shape", true).classed("node", true).attr("transform", this._nodeTransform).style("opacity", (Object)0);
        Rave.transition((Selection)nodes.exit()).style("opacity", (Object)0).remove();
        nodes.call((RunFunction)this.s.symbolType(this._nodeSymbolType).strokeWidth(this._strokeWidth).useFill(new ValueFunction<Object, Object>(){

            @SwiftMethodOverload(skipParameters={1})
            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return ((Number)self._nodeSizeAccessor.getValue(data)).doubleValue() > 0.0;
            }
        }).color(this._nodeColorPalette).size(new ValueFunction<Object, Object>(){

            @SwiftMethodOverload(skipParameters={1})
            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return nodeSize.getValue(context, (Object)Math.abs(((Number)self._nodeSizeAccessor.getValue(data)).doubleValue()), index, groupIndex);
            }
        }), new Object[0]);
        Rave.transition((Selection)nodes).style("opacity", (Object)1);
        FontChecker fontChecker = (FontChecker)Rave.capabilities.extension("fontchecker");
        final Selector labels = labelsGroup.selectAll(".element-label").data(this._nodes, this._nodeKey);
        labels.enter().append("text").classed("element-label", true).attr("dy", (Object)".3em").style("opacity", (Object)0);
        Rave.transition((Selection)labels.exit()).style("opacity", (Object)0).remove();
        labels.text((ValueFunction)new ValueFunction<SceneNode, Object>(){

            @SwiftMethodOverload(skipParameters={1})
            public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                return self._nodeLabelAccessor.getValue(data);
            }
        }).call((RunFunction)fontChecker, new Object[0]);
        Rave.transition((Selection)labels).style("opacity", (Object)1);
        if (this._nodeLabelFontStyle != null) {
            labels.style(this._nodeLabelFontStyle);
        }
        this._force.nodes(this._derivedForceNodes).links((ForceLink[])this._derivedForceLinks.toArray((Object[])new ForceLink[this._derivedForceLinks.size()])).size(this._layoutSize).charge((Object)-300).linkDistance((Object)40).friction((Object)0.8).on("tick", (RunFunction)new RunFunction<Force.EventObject>(){

            public Object run(Force.EventObject context, Object ... args) {
                links.attr("d", self.getLinkPath(self._linkType));
                nodes.attr("transform", self._nodeTransform);
                labels.attr("transform", self._nodeTransform);
                return null;
            }
        }).start();
    }

    public NodeLinkForceComponent nodes(List<? extends Object> nodes) {
        this._nodes = ObjectConverter.listToArray(nodes);
        this.updateForceNodes();
        return this;
    }

    public ArrayEx<Object> nodes() {
        return this._nodes;
    }

    public NodeLinkForceComponent links(List<? extends Object> links) {
        this._links = ObjectConverter.listToArray(links);
        this.updateForceLinks();
        return this;
    }

    public ArrayEx<Object> links() {
        return this._links;
    }

    public NodeLinkForceComponent forceNodeAccessor(SingleValueFunction<ForceNode, Object> accessor) {
        this._forceNodeAccessor = accessor;
        this.updateForceNodes();
        return this;
    }

    public NodeLinkForceComponent forceLinkAccessor(SingleValueFunction<ForceLink, Object> accessor) {
        this._forceLinkAccessor = accessor;
        this.updateForceLinks();
        return this;
    }

    public NodeLinkForceComponent nodeSizeAccessor(SingleValueFunction<Object, Object> accessor) {
        this._nodeSizeAccessor = accessor != null ? accessor : DEFAULT_SIZE_ACCESSOR;
        return this;
    }

    public NodeLinkForceComponent nodeLabelAccessor(SingleValueFunction<Object, Object> accessor) {
        this._nodeLabelAccessor = accessor != null ? accessor : NOOP_ACCESSOR;
        return this;
    }

    public NodeLinkForceComponent nodeLabelFont(String labelFont) {
        this._nodeLabelFontStyle = FontPropertyParser.parseCSSFont(labelFont);
        return this;
    }

    public NodeLinkForceComponent linkWeightAccessor(SingleValueFunction<Object, Object> accessor) {
        this._linkWeightAccessor = accessor != null ? accessor : DEFAULT_LINK_WEIGHT_ACCESSOR;
        return this;
    }

    public NodeLinkForceComponent layoutSize(Dim size) {
        this._layoutSize = size;
        return this;
    }

    public NodeLinkForceComponent nodeColorAccessor(ValueFunction<SceneNode, Object> p) {
        this._nodeColorPalette = p;
        return this;
    }

    public NodeLinkForceComponent keyNodes(ValueFunction<Object, Object> key) {
        this._nodeKey = key;
        return this;
    }

    public NodeLinkForceComponent keyLinks(ValueFunction<Object, Object> key) {
        this._linkKey = key;
        return this;
    }

    public NodeLinkForceComponent nodeSizeExtent(ArrayEx<Object> extent) {
        this._nodeSizeExtent = extent;
        return this;
    }

    public NodeLinkForceComponent nodeSymbolType(String type) {
        this._nodeSymbolType = type;
        return this;
    }

    public NodeLinkForceComponent linkStyleStroke(Object strokeStyle) {
        this._linkStrokeStyle = strokeStyle;
        return this;
    }

    public NodeLinkForceComponent strokeWidth(double strokeWidth) {
        this._strokeWidth = strokeWidth;
        return this;
    }

    public NodeLinkForceComponent linkType(String type) {
        this._linkType = type;
        return this;
    }

    private void updateForceNodes() {
        final NodeLinkForceComponent self = this;
        this._derivedForceNodes = this._nodes.map((ArrayEx.ArrayValueFunction)new ArrayEx.ArrayValueFunction<Object, ForceNode>(){

            public ForceNode getValue(Object currentValue, int index, ArrayEx<Object> array) {
                return (ForceNode)self._forceNodeAccessor.getValue(currentValue);
            }
        });
    }

    private void updateForceLinks() {
        final NodeLinkForceComponent self = this;
        this._derivedForceLinks = this._links.map((ArrayEx.ArrayValueFunction)new ArrayEx.ArrayValueFunction<Object, ForceLink>(){

            public ForceLink getValue(Object currentValue, int index, ArrayEx<Object> array) {
                return (ForceLink)self._forceLinkAccessor.getValue(currentValue);
            }
        });
    }

    private ValueFunction<SceneNode, Object> getLinkPath(String linkStyleName) {
        ValueFunction f = (ValueFunction)this._linkPathGenerators.get((Object)linkStyleName);
        if (f == null) {
            f = (ValueFunction)this._linkPathGenerators.get((Object)LINK_TYPE_LINE);
        }
        return f;
    }

    private OMap<String, ValueFunction<SceneNode, Object>> buildLinkPathGenerators() {
        final NodeLinkForceComponent self = this;
        OMap m = new OMap();
        m.put((Object)LINK_TYPE_LINE, (Object)new ValueFunction<SceneNode, Object>(){

            @SwiftMethodOverload(skipParameters={1})
            public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                if (data == null) {
                    return null;
                }
                double x1 = ((ForceLink)((NodeLinkForceComponent)self)._forceLinkAccessor.getValue((Object)data)).source.x;
                double y1 = ((ForceLink)((NodeLinkForceComponent)self)._forceLinkAccessor.getValue((Object)data)).source.y;
                double x2 = ((ForceLink)((NodeLinkForceComponent)self)._forceLinkAccessor.getValue((Object)data)).target.x;
                double y2 = ((ForceLink)((NodeLinkForceComponent)self)._forceLinkAccessor.getValue((Object)data)).target.y;
                return "M" + x1 + "," + y1 + "L" + x2 + "," + y2;
            }
        });
        m.put((Object)LINK_TYPE_ARC, (Object)new ValueFunction<SceneNode, Object>(){

            @SwiftMethodOverload(skipParameters={1})
            public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                if (data == null) {
                    return null;
                }
                double x1 = ((ForceLink)((NodeLinkForceComponent)self)._forceLinkAccessor.getValue((Object)data)).source.x;
                double y1 = ((ForceLink)((NodeLinkForceComponent)self)._forceLinkAccessor.getValue((Object)data)).source.y;
                double x2 = ((ForceLink)((NodeLinkForceComponent)self)._forceLinkAccessor.getValue((Object)data)).target.x;
                double y2 = ((ForceLink)((NodeLinkForceComponent)self)._forceLinkAccessor.getValue((Object)data)).target.y;
                double dx = x2 - x1;
                double dy = y2 - y1;
                double dr = Math.sqrt(dx * dx + dy * dy);
                return "M" + x1 + "," + y1 + "A" + dr + "," + dr + " 0 0,1 " + x2 + "," + y2;
            }
        });
        return m;
    }
}

