/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.components.wordcloud;

import com.ibm.rave.bundles.component.WordCloudComponent;
import com.ibm.rave.bundles.components.KeyedBundleComponentImpl;
import com.ibm.rave.bundles.components.wordcloud.WordCloudDataNode;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.ext.text.nativeImpl.FontChecker;
import com.ibm.rave.library.palette.Palette;

public class WordCloudComponentImpl
extends KeyedBundleComponentImpl<WordCloudComponentImpl>
implements WordCloudComponent {
    public static final String EFFECT_TWO_STEP = "2steptransition";
    private ArrayEx<Object> _data = null;
    private Palette _colorPalette = null;
    private String _effect = null;
    private RectStruct _size;
    private double _scale = 1.0;
    private double _tx = 0.0;
    private double _ty = 0.0;
    private int _duration;
    private OMap<String, Object> _font = null;
    private ValueFunction<Object, String> _wordAccessor;
    private ValueFunction<Object, Object> _fontSizeAccessor;
    private ValueFunction<Object, Object> _transformFunction;
    private ValueFunction<Object, Object> _exitTransformFunction;
    private SingleValueFunction<WordCloudDataNode, Object> _cloudNodeAccessor;

    public WordCloudComponentImpl() {
        final WordCloudComponentImpl self = this;
        this._cloudNodeAccessor = new SingleValueFunction<WordCloudDataNode, Object>(){

            public WordCloudDataNode getValue(Object data) {
                return (WordCloudDataNode)((Object)data);
            }
        };
        this._wordAccessor = new ValueFunction<Object, String>(){

            public String getValue(Object context, Object data, int index, int groupIndex) {
                return ((WordCloudDataNode)((Object)((WordCloudComponentImpl)self)._cloudNodeAccessor.getValue((Object)data))).text;
            }
        };
        this._fontSizeAccessor = new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return ((WordCloudDataNode)((Object)((WordCloudComponentImpl)self)._cloudNodeAccessor.getValue((Object)data))).size + "px";
            }
        };
        this._transformFunction = new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                WordCloudDataNode d = (WordCloudDataNode)((Object)self._cloudNodeAccessor.getValue(data));
                return "translate(" + d.x + "," + d.y + ")rotate(" + d.rotate + ")";
            }
        };
        this._exitTransformFunction = new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                WordCloudDataNode d = (WordCloudDataNode)((Object)self._cloudNodeAccessor.getValue(data));
                return "translate(" + d.x + "," + (((WordCloudComponentImpl)self)._size.height + 100.0) + ")";
            }
        };
    }

    @Override
    public String type() {
        return "WordCloudComponent";
    }

    @Override
    protected void execute(Selector g) {
        this.preExecute();
        this.setTransform(g);
        Selector shapes = this.createShapes(this._data, g);
        this.shapesExit(shapes);
        this.shapesEnter(shapes);
        this.shapesUpdate(shapes);
    }

    private void setTransform(Selector g) {
        int scaleStartIndex;
        String translate;
        String transform = translate = "translate(" + this._tx + "," + this._ty + ")";
        String oldTransform = ObjectConverter.toString((Object)g.attr("transform"));
        if (oldTransform != null && (scaleStartIndex = oldTransform.indexOf("scale(")) > -1) {
            transform = transform + oldTransform.substring(scaleStartIndex, oldTransform.length());
        }
        if (!"none".equals(this._effect)) {
            g.attr("transform", (Object)transform).transition("scale").delay((Object)(EFFECT_TWO_STEP.equals(this._effect) ? this._duration / 2 : 0)).duration((Object)(EFFECT_TWO_STEP.equals(this._effect) ? this._duration / 2 : this._duration)).attr("transform", (Object)(translate + " scale(" + this._scale + ")"));
        } else {
            g.attr("transform", (Object)(translate + " scale(" + this._scale + ")"));
        }
    }

    private Selector createShapes(ArrayEx<Object> words, Selector g) {
        Selector shapes = g.selectAll("text").data(words.toArray(), this.getKey());
        return shapes;
    }

    private void shapesEnter(Selector shapes) {
        shapes.enter().append("text").attr("text-anchor", (Object)"middle").attr("class", (Object)"word").classed("element-shape", true).style("fill", (ValueFunction)this._colorPalette);
    }

    private void shapesUpdate(Selector shapes) {
        FontChecker fontChecker = (FontChecker)Rave.capabilities.extension("fontchecker");
        shapes.text(this._wordAccessor).style(this._font);
        if (fontChecker != null) {
            shapes.call((RunFunction)fontChecker, new Object[0]);
        }
        if (!"none".equals(this._effect)) {
            shapes.transition("update").duration((Object)(EFFECT_TWO_STEP.equals(this._effect) ? this._duration / 2 : this._duration)).style("fill", (ValueFunction)this._colorPalette).style("font-size", this._fontSizeAccessor).attr("transform", this._transformFunction);
        } else {
            shapes.style("fill", (ValueFunction)this._colorPalette).style("font-size", this._fontSizeAccessor).attr("transform", this._transformFunction);
        }
    }

    private void shapesExit(Selector shapes) {
        if (!"none".equals(this._effect)) {
            shapes.exit().transition("update").duration((Object)this._duration).attr("transform", this._exitTransformFunction).remove();
        } else {
            shapes.exit().remove();
        }
    }

    public WordCloudComponentImpl data(ArrayEx<? extends Object> data) {
        this._data = data;
        return this;
    }

    public WordCloudComponentImpl colorPalette(Palette colorPalette) {
        this._colorPalette = colorPalette;
        return this;
    }

    public WordCloudComponentImpl effect(String effect) {
        this._effect = effect;
        return this;
    }

    public WordCloudComponentImpl size(RectStruct size) {
        this._size = size;
        return this;
    }

    public WordCloudComponentImpl font(OMap<String, Object> font) {
        this._font = font;
        return this;
    }

    public WordCloudComponentImpl cloudNodeAccessor(SingleValueFunction<WordCloudDataNode, Object> accessor) {
        this._cloudNodeAccessor = accessor;
        return this;
    }

    public WordCloudComponentImpl scale(double scale) {
        this._scale = scale;
        return this;
    }

    public WordCloudComponentImpl translate(double tx, double ty) {
        this._tx = tx;
        this._ty = ty;
        return this;
    }

    public WordCloudComponentImpl duration(int duration) {
        this._duration = duration;
        return this;
    }
}

