/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.compositeBundle;

import com.ibm.rave.bundles.components.AlignAxisTicksComponent;
import com.ibm.rave.bundles.components.AxesManager;
import com.ibm.rave.bundles.components.ComponentConfiguration;
import com.ibm.rave.bundles.components.IntervalComponentImpl;
import com.ibm.rave.bundles.components.IntervalDataUtilities;
import com.ibm.rave.bundles.components.LabelCollisionComponentImpl;
import com.ibm.rave.bundles.components.LineComponentImpl;
import com.ibm.rave.bundles.components.PointComponentImpl;
import com.ibm.rave.bundles.data.LineDataUtilities;
import com.ibm.rave.bundles.data.PointDataUtilities;
import com.ibm.rave.bundles.views.AbstractColumnView;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.behavior.Zoom;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.event.Event;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.EventQueue;
import com.ibm.rave.core.nativeImpl.arrays.ES6Map;
import com.ibm.rave.core.nativeImpl.timer.TimerEvent;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.SelectorEventListener;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.util.Runnable;
import com.ibm.rave.library.Library;
import com.ibm.rave.library.action.BundleUtils;
import com.ibm.rave.library.action.internal.ActionImpl;
import com.ibm.rave.library.datamodel.DataSet;
import com.ibm.rave.library.datamodel.DataSlotEntry;
import com.ibm.rave.library.framework.CoordinateScale;
import com.ibm.rave.library.framework.internal.BundleContext;
import com.ibm.rave.library.framework.internal.ClusteredCoordinateScale;
import com.ibm.rave.library.framework.internal.CoordinateScaleImpl;
import com.ibm.rave.library.framework.internal.LinearCoordinateScale;
import com.ibm.rave.library.framework.internal.OrdinalCoordinateScale;
import com.ibm.rave.library.framework.internal.OrdinalCoordinateScaleDatum;
import com.ibm.rave.library.framework.internal.ScaleManager;
import com.ibm.rave.library.framework.internal.TimeCoordinateScale;
import com.ibm.rave.library.palette.Palette;
import java.util.List;

public final class CompositeView
extends AbstractColumnView {
    private LineComponentImpl _lineComponent;
    private PointComponentImpl _pointComponent;
    private boolean _transpose;
    private ArrayEx<IntervalDataUtilities.IntervalData> _intervalData;
    private ArrayEx<LineDataUtilities.LineDatum> _lineData;
    private List<PointDataUtilities.PointDatum> _pointData;
    private List<PointDataUtilities.PointDatum> _pointNPNData;
    CoordinateScaleImpl _independentScale;
    CoordinateScaleImpl _intervalDependentScale;
    CoordinateScaleImpl _lineDependentScale;
    private Object zoomendedTimer;
    SingleValueFunction<Object, Object> _columnColorAccessor;
    private AbstractScale<?, ?> indepScale;
    private AbstractScale<?, ?> intervalScale;
    private AbstractScale<?, ?> lineScale;
    private static final double SCALE_PADDING = 2.0;
    protected LabelCollisionComponentImpl _labelCollisionComponent;
    private boolean _pendingLabelTimer;
    private int _cancelLabelTimers;
    @InlineStringConstant
    private static final String DATASET_COLUMNDATA = "column";
    @InlineStringConstant
    private static final String DATASET_LINEDATA = "line";
    @InlineStringConstant
    private static final String DATASLOT_GROUP = "color";
    @InlineStringConstant
    private static final String DATASLOT_KEY = "key";
    @InlineStringConstant
    private static final String ELEMENT_SHAPE_CLASSES = "element-shape";
    @InlineStringConstant
    private static final String LINE_WITH_POINTS_SYMBOL = "lineWithPoints.symbol";
    @InlineStringConstant
    private static final String LINE_OR_POINTS_DISPLAY = "lineWithPoints.display";
    @InlineStringConstant
    private static final String LINE_DISPLAY = "line";
    @InlineStringConstant
    private static final String POINTS_DISPLAY = "points";
    @InlineStringConstant
    private static final String LINE_WITH_POINTS_DISPLAY = "line_points";
    @InlineStringConstant
    private static final String COLUMN_BORDER_WIDTH = "column.border.width";
    @InlineStringConstant
    private static final String COLUMN_BORDER_COLOR = "column.border.color";
    @InlineStringConstant
    private static final String LINE_WITH_POINTS_SIZE = "lineWithPoints.size";
    @InlineStringConstant
    private static final String COLOR_PALLETTE_COLUMN = "color.palette.column";
    @InlineStringConstant
    private static final String COLOR_PALLETTE_LINE = "color.palette.line";
    @InlineStringConstant
    private static final String AXIS_LINE_COLUMN_SWAP = "swapLineColumn";
    @InlineStringConstant
    public static final String GRID_ALIGN_DEPENDENT_AXES = "alignAxes";
    @InlineStringConstant
    private static final String LINE_INTERPOLATE_PROPERTY = "lineWithPoints.interpolate";
    @InlineStringConstant
    private static final String LINE_MISSING_AS_GAP_PROPERTY = "lineWithPoints.showMissingAsGap";
    @InlineStringConstant
    private static final String LEGEND_LINE_DISPLAY = "legend.line.display";
    @InlineStringConstant
    private static final String LEGEND_LINE_TITLE = "legend.line.title";
    @InlineStringConstant
    private static final String LEGEND_LINE_TITLESTYLE_FONT = "legend.line.titlestyle.font";
    @InlineStringConstant
    private static final String LEGEND_LINE_ENTRYSTYLE_FONT = "legend.line.entrystyle.font";
    @InlineStringConstant
    private static final String LEGEND_LINE_TITLESTYLE_FILL = "legend.line.titlestyle.fill";
    @InlineStringConstant
    private static final String LEGEND_LINE_TITLESTYLE_FONTSIZE = "legend.line.titlestyle.fontsize";
    @InlineStringConstant
    private static final String LEGEND_LINE_TITLESTYLE_FONTFAMILY = "legend.line.titlestyle.fontfamily";
    @InlineStringConstant
    private static final String LEGEND_COLUMN_DISPLAY = "legend.column.display";
    @InlineStringConstant
    private static final String LEGEND_COLUMN_TITLE = "legend.column.title";
    @InlineStringConstant
    private static final String LEGEND_COLUMN_TITLESTYLE_FONT = "legend.column.titlestyle.font";
    @InlineStringConstant
    private static final String LEGEND_COLUMN_ENTRYSTYLE_FONT = "legend.column.entrystyle.font";
    @InlineStringConstant
    private static final String LEGEND_COLUMN_TITLESTYLE_FILL = "legend.column.titlestyle.fill";
    @InlineStringConstant
    private static final String LEGEND_COLUMN_TITLESTYLE_FONTSIZE = "legend.column.titlestyle.fontsize";
    @InlineStringConstant
    private static final String LEGEND_COLUMN_TITLESTYLE_FONTFAMILY = "legend.column.titlestyle.fontfamily";
    private static final Object DATAMODEL_SIMPLE = "simple";
    private static final String DATASET_COMPOSITE = "composite";

    protected CompositeView(BundleContext context) {
        super(context);
        this.datasetId = DATASET_COLUMNDATA;
        this._columnColorAccessor = new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return ((IntervalDataUtilities.IntervalData)data).color;
            }
        };
    }

    @Override
    protected int getLegendCount() {
        return 2;
    }

    @Override
    protected boolean isAxesManagerRequired() {
        return true;
    }

    @Override
    public void setup() {
        super.setup();
        this._pendingLabelTimer = false;
        this._cancelLabelTimers = 0;
        this._labelCollisionComponent = new LabelCollisionComponentImpl();
        BundleUtils.setupDefaultActions((BundleContext)this.context, (String)".chart .element-shape", null);
        this._lineComponent = new LineComponentImpl();
        this._lineComponent.pointsAccessor(new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return ((LineDataUtilities.LineDatum)data).points;
            }
        }).groupAccessor(LineDataUtilities.GROUP_ACCESSOR);
        this._pointComponent = new PointComponentImpl();
        this._pointComponent.independentAccessor(PointDataUtilities.X_ACCESSOR).dependentAccessor(PointDataUtilities.Y_ACCESSOR);
    }

    public void draw() {
        DataSet lineDataSet;
        DataSet columnDataSet;
        if (this.isUpdateNothing()) {
            return;
        }
        this.preDraw("g.vizlibrary-composite");
        this.dataModel = this.context.dataModel();
        this.datasetId = this.dataModel.getDescriptor().id().equals(DATAMODEL_SIMPLE) ? DATASET_COMPOSITE : DATASET_COLUMNDATA;
        if (!this.validateDataModel("g.element-group", "g.grid", "g.axis")) {
            return;
        }
        this.setActionsWithBorder();
        this.stopLabelCollisions();
        if (this.dataModel.getDescriptor().id().equals(DATAMODEL_SIMPLE)) {
            columnDataSet = this.dataModel.dataset(DATASET_COMPOSITE);
            lineDataSet = this.dataModel.dataset(DATASET_COMPOSITE);
        } else {
            columnDataSet = this.dataModel.dataset(this.datasetId);
            lineDataSet = this.dataModel.dataset("line");
        }
        if (!this.compatibleDomains(columnDataSet, lineDataSet)) {
            this._chart.selectAll("g.element-group").selectAll("*").remove();
            this._chart.selectAll("g.element-label-group").selectAll("*").remove();
            this._chart.selectAll("g.grid").selectAll("*").remove();
            this._chart.selectAll("g.axis").selectAll("*").remove();
            this._legends.visible(false).draw();
        }
        String effect = this.getStringProperty("effect.name");
        int duration = this.getEffectDuration(effect);
        this._transpose = this.getBooleanProperty("transpose");
        ArrayEx columnData = ObjectConverter.listToArray((List)((List)columnDataSet.data()));
        ArrayEx lineModelData = ObjectConverter.listToArray((List)((List)lineDataSet.data()));
        boolean useLineLegend = this.getBooleanProperty(LEGEND_LINE_DISPLAY);
        boolean useColumnLegend = this.getBooleanProperty(LEGEND_COLUMN_DISPLAY);
        String legendPosition = this.getLegendPosition();
        DataSlotEntry columnXDataSlotEntry = columnDataSet.slot("x").entry();
        DataSlotEntry columnYDataSlotEntry = columnDataSet.slot("y").entry();
        DataSlotEntry columnColorDataSlotEntry = columnDataSet.slot(DATASLOT_GROUP).entry();
        if (columnColorDataSlotEntry == null && columnYDataSlotEntry != null) {
            columnDataSet.slot(DATASLOT_GROUP).overrideLabel(columnYDataSlotEntry.label());
        }
        DataSlotEntry lineXDataSlotEntry = lineDataSet.slot("x").entry();
        String lineYSlotName = "y";
        String lineColorSlotName = DATASLOT_GROUP;
        if (this.dataModel.getDescriptor().id().equals(DATAMODEL_SIMPLE)) {
            lineYSlotName = lineYSlotName + "Line";
            lineColorSlotName = lineColorSlotName + "Line";
        }
        DataSlotEntry lineYDataSlotEntry = lineDataSet.slot(lineYSlotName).entry();
        DataSlotEntry lineColorDataSlotEntry = lineDataSet.slot(lineColorSlotName).entry();
        if (lineColorDataSlotEntry == null && lineYDataSlotEntry != null) {
            lineDataSet.slot(lineColorSlotName).overrideLabel(lineYDataSlotEntry.label());
        }
        if (this.updateType == 0) {
            this._intervalData = this.makeData(this.dataModel, (ArrayEx<Object>)columnData);
            this._lineData = LineDataUtilities.buildLines((ArrayEx<Object>)lineModelData, (SingleValueFunction<Object, Object>)CompositeView.accessorOf((DataSlotEntry)lineXDataSlotEntry), (SingleValueFunction<Object, Object>)CompositeView.domainCheckerOf((List)lineModelData, (DataSlotEntry)lineXDataSlotEntry), (SingleValueFunction<Object, Object>)CompositeView.accessorOf((DataSlotEntry)lineYDataSlotEntry), (SingleValueFunction<Object, Object>)CompositeView.accessorOf((DataSlotEntry)lineColorDataSlotEntry));
            this.context.actions.action("deselectAll").call(new Object[]{this.context.node.selectAll(".element-shape")});
        }
        Palette columnColorPalette = this.getPalette(COLOR_PALLETTE_COLUMN);
        columnColorPalette.setData(columnDataSet, DATASLOT_GROUP);
        columnColorPalette.setAccessor(this._columnColorAccessor);
        columnColorPalette.setNullColor(this.getStringProperty("color.null"));
        boolean swap = this.getBooleanProperty(AXIS_LINE_COLUMN_SWAP);
        Palette lineColorPalette = this.getPalette(COLOR_PALLETTE_LINE);
        lineColorPalette.setData(lineDataSet, lineColorSlotName);
        lineColorPalette.setAccessor(LineDataUtilities.GROUP_ACCESSOR);
        String drawLineOrPoints = this.getStringProperty(LINE_OR_POINTS_DISPLAY);
        boolean drawPoints = LINE_WITH_POINTS_DISPLAY.equals(drawLineOrPoints) || POINTS_DISPLAY.equals(drawLineOrPoints);
        boolean drawLine = LINE_WITH_POINTS_DISPLAY.equals(drawLineOrPoints) || "line".equals(drawLineOrPoints);
        this.configureLegends(effect, duration, useLineLegend, useColumnLegend, legendPosition, columnColorDataSlotEntry, lineColorDataSlotEntry, columnColorPalette, lineColorPalette, drawPoints);
        this.doLayout(columnDataSet, lineDataSet, duration, (ArrayEx<Object>)lineModelData, columnXDataSlotEntry, columnYDataSlotEntry, lineXDataSlotEntry, lineYDataSlotEntry, swap);
        if (this.updateType == 0 && this._independentScale != null && this.getBooleanProperty("sortX")) {
            LineDataUtilities.sortLines(this._lineData, this._independentScale);
        }
        if (this.updateType == 0) {
            this._pointData = LineDataUtilities.getLineWithPoints(this._lineData);
            this._pointNPNData = LineDataUtilities.getNPNPoints(this._lineData);
        }
        RectStruct elementRect = this._layoutComponent.elementRect();
        this._clip.clipRect(elementRect).applyTo(this._chart.select((Object)".content1")).run((Selection<?>)this.context.node.select((Object)"defs"), new Object[0]);
        this._clip.clipRect(elementRect).applyTo(this._chart.select((Object)".content2")).run((Selection<?>)this.context.node.select((Object)"defs"), new Object[0]);
        this._chart.select((Object)"rect.background.elements").attr("x", (Object)elementRect.x).attr("y", (Object)elementRect.y).attr("width", (Object)elementRect.width).attr("height", (Object)elementRect.height);
        this._legends.rectangle(this._layoutComponent.legendRect());
        this.setBackgroundProperties(elementRect, duration);
        this.configureDataLabels(columnDataSet, columnColorDataSlotEntry);
        this.drawLinesAndPoints(columnDataSet, lineDataSet, effect, duration, lineColorDataSlotEntry, lineColorSlotName, columnColorPalette, lineColorPalette, drawPoints, drawLine, elementRect);
        this.drawAxes(duration, columnXDataSlotEntry, columnYDataSlotEntry, lineYDataSlotEntry);
        this._legends.draw();
        this.zoom(swap, elementRect);
        this.runLabelCollisions(this._chart, elementRect, duration, this.delayFunction(duration, this._independentScale));
        this.resetUpdate();
        this._chart.selectAll(".element-shape").classed("bundle-shape", true);
        this._chart.selectAll(".legendShape").classed("bundle-shape", true);
    }

    private void drawAxes(int duration, DataSlotEntry columnXDataSlotEntry, DataSlotEntry columnYDataSlotEntry, DataSlotEntry lineYDataSlotEntry) {
        boolean stacked100 = "Stacked100".equals(this.getStringProperty("data.handling"));
        Number subDomainDivisionColumn = columnYDataSlotEntry.subDomainDivision();
        Double scaleDivisionColumn = subDomainDivisionColumn == null ? null : Double.valueOf(ObjectConverter.toDouble((Object)subDomainDivisionColumn));
        Number subDomainDivisionLine = lineYDataSlotEntry.subDomainDivision();
        Double scaleDivisionLine = subDomainDivisionLine == null ? null : Double.valueOf(ObjectConverter.toDouble((Object)subDomainDivisionLine));
        this._axes.visible(true).duration(duration).useDefaultSelectors().useDefaultX1Properties(true).useDefaultY1Properties(true).useDefaultY2Properties(true).scaleTickMagnitude(2, scaleDivisionColumn).scaleTickMagnitude(3, scaleDivisionLine).setTickFormatterList(0, (ArrayEx<DataSlotEntry>)new ArrayEx((Object[])new DataSlotEntry[]{columnXDataSlotEntry, columnYDataSlotEntry}), "none", null).setTickFormatterList(2, (ArrayEx<DataSlotEntry>)new ArrayEx((Object[])new DataSlotEntry[]{columnYDataSlotEntry}), stacked100 ? "percent" : "none", stacked100 ? AxesManager.percentFormat(0) : null).setTickFormatter(3, lineYDataSlotEntry);
        this._axes.draw();
    }

    private void doLayout(DataSet columnDataSet, DataSet lineDataSet, int duration, ArrayEx<Object> lineModelData, DataSlotEntry columnXDataSlotEntry, DataSlotEntry columnYDataSlotEntry, DataSlotEntry lineXDataSlotEntry, DataSlotEntry lineYDataSlotEntry, boolean swap) {
        if (this.updateType <= 1) {
            boolean isLineOnly;
            boolean isLegendLeftOrRight;
            this._independentScale = this.makeIndependentScale(columnDataSet, lineDataSet);
            this._intervalDependentScale = this.makeIntervalDependentScale(columnDataSet.slot("y").entry(), (List<IntervalDataUtilities.IntervalData>)this._intervalData);
            this._lineDependentScale = ScaleManager.makeCoordinateScale(lineModelData, (DataSlotEntry)lineYDataSlotEntry);
            Number subDomainDivisionColumn = columnYDataSlotEntry.subDomainDivision();
            Double scaleDivisionColumn = subDomainDivisionColumn == null ? null : Double.valueOf(ObjectConverter.toDouble((Object)subDomainDivisionColumn));
            Number subDomainDivisionLine = lineYDataSlotEntry.subDomainDivision();
            Double scaleDivisionLine = subDomainDivisionLine == null ? null : Double.valueOf(ObjectConverter.toDouble((Object)subDomainDivisionLine));
            this._axes.visible(true).duration(duration).transpose(this._transpose).swapY(swap ^ this._transpose).scale(0, this._independentScale).scale(2, this._intervalDependentScale).scale(3, this._lineDependentScale).scaleTickMagnitude(2, scaleDivisionColumn).scaleTickMagnitude(3, scaleDivisionLine).setDataSlot(0, (List<DataSlotEntry>)new ArrayEx((Object[])new DataSlotEntry[]{columnXDataSlotEntry, lineXDataSlotEntry})).setDataSlot(2, columnYDataSlotEntry).setDataSlot(3, lineYDataSlotEntry).useDefaultSelectors().useDefaultX1Properties(true).useDefaultY1Properties(true).useDefaultY2Properties(true);
            this.prepareLayoutComponent();
            this.prepareLayoutSizables(this._layoutComponent, false, true, true, true, this._legends.anyVisible());
            String legendPosition = this._layoutComponent.legendPosition();
            boolean bl = isLegendLeftOrRight = "left".equals(legendPosition) || "right".equals(legendPosition);
            if (isLegendLeftOrRight) {
                this._legends.preLayout(this._layoutComponent, false);
                this._axes.preLayout(this._layoutComponent, false, 0.1, 0.05, 0, 0.1, 0.0, 0);
            } else {
                this._axes.preLayout(this._layoutComponent, true, 0.1, 0.05, 0, 0.1, 0.0, 0);
                this._legends.preLayout(this._layoutComponent, true);
            }
            this._layoutComponent.layout();
            this._legends.position(legendPosition);
            this._axes.useBoundsFromLayout(this._layoutComponent).setIndependentScaleRanges(0.1, 0.05, 0).setDependentScaleRanges(0.1, 0.0, 0);
            if (this._independentScale != null) {
                double csize = this.getCSSSizeToPixelNumber("column.size");
                this._independentScale.setWidth(csize);
                this._independentScale.applyWidth(this.getBooleanProperty("column.applysize"));
                this._independentScale.expandZeroExtent(false);
                this._independentScale.expandPixels(csize / 2.0 + 1.0, false);
                if (this.getBooleanProperty("axis.x.scale.nice")) {
                    this._independentScale.nice();
                }
                if (this.getBooleanProperty("axis.x.scale.includeZero")) {
                    this._independentScale.includeZero();
                }
                this.indepScale = this._independentScale.scale().copy();
            }
            double intervalDomainmax = 0.0;
            if (this._intervalDependentScale != null) {
                intervalDomainmax = ObjectConverter.toDouble(this._intervalDependentScale.scale().domain().get(1));
                if (this.getBooleanProperty("axis.y.scale.includeZero")) {
                    this._intervalDependentScale.includeZero();
                }
                this._intervalDependentScale.expandZeroExtent(true);
                if (this.getBooleanProperty("axis.y.scale.nice")) {
                    this._intervalDependentScale.nice((Number)scaleDivisionColumn);
                }
            }
            double lineDomainmax = 0.0;
            if (this._lineDependentScale != null) {
                lineDomainmax = ObjectConverter.toDouble(this._lineDependentScale.scale().domain().get(1));
                if (this.getBooleanProperty("axis.y2.scale.includeZero")) {
                    this._lineDependentScale.includeZero();
                }
                this._lineDependentScale.expandZeroExtent(true);
                if (this.getBooleanProperty("axis.y2.scale.nice")) {
                    this._lineDependentScale.nice((Number)scaleDivisionLine);
                }
            }
            double linePadding = (isLineOnly = "line".equals(this.getStringProperty(LINE_OR_POINTS_DISPLAY))) ? 2.0 : Math.max(2.0, 2.0 + Math.sqrt(this.getCSSSizeToPixelNumber(LINE_WITH_POINTS_SIZE)));
            double intervalPadding = 2.0;
            if (this.getBooleanProperty("data.label.display")) {
                boolean isStacked;
                if (this._lineDependentScale != null) {
                    List lineNiceScaleDomain = this._lineDependentScale.scale().domain();
                    List lineRange = this._lineDependentScale.scale().range();
                    double pixelPerUnit = Math.abs(ObjectConverter.toDouble(lineRange.get(1)) - ObjectConverter.toDouble(lineRange.get(0))) / Math.abs(ObjectConverter.toDouble(lineNiceScaleDomain.get(1)) - ObjectConverter.toDouble(lineNiceScaleDomain.get(0)));
                    linePadding = 20.0 - Math.abs(ObjectConverter.toDouble(lineNiceScaleDomain.get(1)) - lineDomainmax) * pixelPerUnit;
                }
                DataSlotEntry columnColorDataSlotEntry = columnDataSet.slot(DATASLOT_GROUP).entry();
                String dataHandling = this.getStringProperty("data.handling");
                boolean bl2 = isStacked = columnColorDataSlotEntry != null && ("Stacked".equals(dataHandling) || "Stacked100".equals(dataHandling));
                if (this._intervalDependentScale != null && !isStacked) {
                    List intervalNiceScaleDomain = this._intervalDependentScale.scale().domain();
                    List intervalRange = this._intervalDependentScale.scale().range();
                    double dependentScaleLengthPx = Math.abs(ObjectConverter.toDouble(intervalRange.get(1)) - ObjectConverter.toDouble(intervalRange.get(0)));
                    double intervalPixelPerUnit = dependentScaleLengthPx / Math.abs(ObjectConverter.toDouble(intervalNiceScaleDomain.get(1)) - ObjectConverter.toDouble(intervalNiceScaleDomain.get(0)));
                    int paddingNeeded = 20;
                    if (this._transpose && (double)(ObjectConverter.toString((Object)intervalDomainmax).length() * 12) < dependentScaleLengthPx / 4.0) {
                        paddingNeeded = ObjectConverter.toString((Object)intervalDomainmax).length() * 12;
                    }
                    intervalPadding = (double)paddingNeeded - Math.abs(ObjectConverter.toDouble(intervalNiceScaleDomain.get(1)) - intervalDomainmax) * intervalPixelPerUnit;
                }
            }
            if (this._intervalDependentScale != null && this._lineDependentScale != null && this.getBooleanProperty(GRID_ALIGN_DEPENDENT_AXES)) {
                AlignAxisTicksComponent.alignAxisScales(this._intervalDependentScale, this._lineDependentScale);
            }
            if (this.isSameDomain() || this.getBooleanProperty(GRID_ALIGN_DEPENDENT_AXES)) {
                this._intervalDependentScale.expandPixels(Math.max(linePadding, intervalPadding), true);
                this._lineDependentScale.expandPixels(Math.max(linePadding, intervalPadding), true);
            } else {
                if (this._intervalDependentScale != null) {
                    this._intervalDependentScale.expandPixels(intervalPadding, true);
                }
                if (this._lineDependentScale != null) {
                    this._lineDependentScale.expandPixels(linePadding, true);
                }
            }
            if (this._intervalDependentScale != null) {
                this.intervalScale = this._intervalDependentScale.scale().copy();
            }
            if (this._lineDependentScale != null) {
                this.lineScale = this._lineDependentScale.scale().copy();
            }
            this.resetZoom();
        }
    }

    private boolean isSameDomain() {
        if (this._intervalDependentScale == null || this._lineDependentScale == null) {
            return false;
        }
        List y1Domain = this._intervalDependentScale.scale().domain();
        double y1Min = Math.floor(ObjectConverter.toDouble(y1Domain.get(0)));
        double y1Max = Math.ceil(ObjectConverter.toDouble(y1Domain.get(1)));
        List y2Domain = this._lineDependentScale.scale().domain();
        double y2Min = Math.floor(ObjectConverter.toDouble(y2Domain.get(0)));
        double y2Max = Math.ceil(ObjectConverter.toDouble(y2Domain.get(1)));
        boolean minDifferent = y1Min < y2Min || y1Min > y2Min;
        boolean maxDifferent = y1Max < y2Max || y1Max > y2Max;
        return !minDifferent && !maxDifferent;
    }

    private void zoom(boolean swap, RectStruct elementRect) {
        if (this.updateType <= 2) {
            CoordinateScaleImpl x2Scale;
            CoordinateScaleImpl xScale;
            String ops = this.getStringProperty("zoom");
            if (this._independentScale != null && (ops.equals("all") || ops.equals("x"))) {
                this._independentScale.scale().domain(this.indepScale.domain());
            }
            if (this._intervalDependentScale != null && (ops.equals("all") || ops.equals("y"))) {
                this._intervalDependentScale.scale().domain(this.intervalScale.domain());
            }
            if (this._lineDependentScale != null && (ops.equals("all") || ops.equals("y2"))) {
                this._lineDependentScale.scale().domain(this.lineScale.domain());
            }
            CoordinateScaleImpl coordinateScaleImpl = this._transpose ? (swap ? this._lineDependentScale : this._intervalDependentScale) : (xScale = this._independentScale);
            CoordinateScaleImpl coordinateScaleImpl2 = this._transpose ? (swap ? this._intervalDependentScale : this._lineDependentScale) : (x2Scale = null);
            CoordinateScaleImpl yScale = this._transpose ? this._independentScale : (swap ? this._lineDependentScale : this._intervalDependentScale);
            CoordinateScaleImpl y2Scale = this._transpose ? null : this._lineDependentScale;
            final CompositeView self = this;
            Zoom zoom = (Zoom)this.context.actions.action("zoom").get("zoom");
            ComponentConfiguration.configureZoom(this._chart, zoom, xScale, yScale, x2Scale, y2Scale, null, elementRect, this._zoomP, this._zoomS, this.convertZoomOps(swap), new RunFunction<SceneNode>(){

                public Object run(SceneNode context1, Object ... args) {
                    self._chart.selectAll("g.element-column").call((RunFunction)self._intervalComponent, new Object[0]);
                    self._chart.selectAll("g.element-line").call((RunFunction)self._lineComponent, new Object[0]);
                    if (self._pointComponent != null) {
                        self._chart.selectAll("g.element-point").call((RunFunction)self._pointComponent, new Object[0]);
                    }
                    self._axes.redraw(true);
                    self._chart.call((RunFunction)self._labelCollisionComponent, new Object[0]);
                    return self._chart;
                }
            });
            zoom.on("zoomend.hideLabels", (RunFunction)new RunFunction<SceneNode>(){

                public Object run(SceneNode context, Object ... args) {
                    if (self._axes.hideAnyPanZoom()) {
                        if (self.zoomendedTimer != null) {
                            EventQueue.clearTimeout((Object)self.zoomendedTimer);
                        }
                        self.zoomendedTimer = EventQueue.setTimeout((Runnable)new Runnable(){

                            public void run() {
                                self.zoomendedTimer = null;
                                self._axes.redraw(false);
                                self._chart.call((RunFunction)self._labelCollisionComponent, new Object[0]);
                            }
                        }, (int)300);
                    }
                    return null;
                }
            });
        }
    }

    private void drawLinesAndPoints(DataSet columnDataSet, DataSet lineDataSet, String effect, int duration, DataSlotEntry lineColorDataSlotEntry, String lineColorSlotName, Palette columnColorPalette, Palette lineColorPalette, boolean drawPoints, boolean drawLine, RectStruct elementRect) {
        ((IntervalComponentImpl)((IntervalComponentImpl)this._intervalComponent.data(this._intervalData.toArray()).key((SingleValueFunction<Object, Object>)CompositeView.originalDatumAccessor((SingleValueFunction)CompositeView.accessorOf((DataSlotEntry)columnDataSet.slot(DATASLOT_KEY).entry())))).independentScale(this._independentScale).dependentScale(this._intervalDependentScale).transpose(this._transpose).colorPalette(columnColorPalette).delay(this.delayFunction(duration, this._independentScale)).setPreExecute(this.context.getPreExecute())).borderWidth(this.context.convertCSSSizeToPixels(this.context.getPropertyValue("column.borderWidth"))).borderColor(ObjectConverter.asString((Object)this.context.getPropertyValue("column.borderColor"))).bounds(this._layoutComponent.elementRect());
        this._chart.selectAll("g.element-column").transition("transition").duration((Object)duration).call((RunFunction)this._intervalComponent, new Object[0]);
        DataSlotEntry lineKeyDataSlotEntry = lineDataSet.slot(DATASLOT_KEY).entry();
        if (drawLine) {
            this._lineComponent.data(this._lineData.toArray());
        } else {
            this._lineComponent.data(null);
        }
        boolean showMissingAsGap = this.getBooleanProperty(LINE_MISSING_AS_GAP_PROPERTY);
        ((LineComponentImpl)((LineComponentImpl)this._lineComponent.key((SingleValueFunction<Object, Object>)CompositeView.originalDatumAccessor((SingleValueFunction)CompositeView.accessorOf((DataSlotEntry)lineKeyDataSlotEntry)))).independentScale(this._independentScale).dependentScale(this._lineDependentScale).transpose(this._transpose).colorPalette(lineColorPalette).effect(effect).showMissingAsGap(showMissingAsGap).setPreExecute(this.context.getPreExecute())).interpolate(this.getStringProperty(LINE_INTERPOLATE_PROPERTY));
        this._chart.selectAll("g.element-line").transition("transition").duration((Object)duration).call((RunFunction)this._lineComponent, new Object[0]);
        if (drawPoints || this.isShowDataLabels()) {
            this._pointComponent.data(this._pointData.toArray());
        } else {
            this._pointComponent.data(showMissingAsGap ? this._pointNPNData.toArray() : null);
        }
        this.configureLineDataLabels(lineDataSet);
        Palette pointsColorPalette = this.getPalette(COLOR_PALLETTE_LINE);
        pointsColorPalette.setData(lineDataSet, lineColorSlotName);
        pointsColorPalette.setAccessor(CompositeView.originalDatumAccessor((SingleValueFunction)CompositeView.accessorOf((DataSlotEntry)lineColorDataSlotEntry)));
        ((PointComponentImpl)((PointComponentImpl)this._pointComponent.key((SingleValueFunction<Object, Object>)CompositeView.originalDatumAccessor((SingleValueFunction)CompositeView.accessorOf((DataSlotEntry)lineKeyDataSlotEntry)))).bounds(elementRect).independentScale(this._independentScale).dependentScale(this._lineDependentScale).colorPalette(pointsColorPalette).labelContrast(this.getBooleanProperty("contrast.label.color")).labelShadow(this.getBooleanProperty("label.shadow")).transpose(this._transpose).effect(effect).setPreExecute(this.context.getPreExecute())).defaultSize(this.getCSSSizeToPixelNumber(LINE_WITH_POINTS_SIZE)).symbol(drawPoints ? this.getStringProperty(LINE_WITH_POINTS_SYMBOL) : null).itemOverlap(false);
        this._chart.selectAll("g.element-point").transition("transition").duration((Object)duration).call((RunFunction)this._pointComponent, new Object[0]);
    }

    private void configureLegends(String effect, int duration, boolean useLineLegend, boolean useColumnLegend, String legendPosition, DataSlotEntry columnColorDataSlotEntry, DataSlotEntry lineColorDataSlotEntry, Palette columnColorPalette, Palette lineColorPalette, boolean drawPoints) {
        String columnEntryString;
        String columnTitleString;
        String lineEntryString;
        String lineTitleString = ObjectConverter.asString((Object)this.context.getPropertyValue(LEGEND_LINE_TITLESTYLE_FONT));
        if (lineTitleString != null) {
            this._legends.titleFont(0, lineTitleString);
        }
        if ((lineEntryString = ObjectConverter.asString((Object)this.context.getPropertyValue(LEGEND_LINE_ENTRYSTYLE_FONT))) != null) {
            this._legends.entryFont(0, lineEntryString);
        }
        if ((columnTitleString = ObjectConverter.asString((Object)this.context.getPropertyValue(LEGEND_COLUMN_TITLESTYLE_FONT))) != null) {
            this._legends.titleFont(1, columnTitleString);
        }
        if ((columnEntryString = ObjectConverter.asString((Object)this.context.getPropertyValue(LEGEND_COLUMN_ENTRYSTYLE_FONT))) != null) {
            this._legends.entryFont(1, columnEntryString);
        }
        this._legends.position(legendPosition).transition(!"none".equals(effect), duration).setPreExecute(this.context.getPreExecute()).visible(0, useLineLegend).selector(0, this.context.node.selectAll("g.legend.line")).palette(0, lineColorPalette).shape(0, drawPoints ? this.getStringProperty(LINE_WITH_POINTS_SYMBOL) : "compositeViewLegendLineSymbol").title(0, this.context.getDataSlotLabel(LEGEND_LINE_TITLE, lineColorDataSlotEntry)).titleFill(0, ObjectConverter.asString((Object)this.context.getPropertyValue(LEGEND_LINE_TITLESTYLE_FILL))).titleFontSize(0, ObjectConverter.asString((Object)this.context.getPropertyValue(LEGEND_LINE_TITLESTYLE_FONTSIZE))).titleFontFamily(0, ObjectConverter.asString((Object)this.context.getPropertyValue(LEGEND_LINE_TITLESTYLE_FONTFAMILY))).setDataSlot(0, lineColorDataSlotEntry).visible(1, useColumnLegend).selector(1, this.context.node.selectAll("g.legend.column")).palette(1, columnColorPalette).shape(1, "square").title(1, this.context.getDataSlotLabel(LEGEND_COLUMN_TITLE, columnColorDataSlotEntry)).titleFill(1, ObjectConverter.asString((Object)this.context.getPropertyValue(LEGEND_COLUMN_TITLESTYLE_FILL))).titleFontSize(1, ObjectConverter.asString((Object)this.context.getPropertyValue(LEGEND_COLUMN_TITLESTYLE_FONTSIZE))).titleFontFamily(1, ObjectConverter.asString((Object)this.context.getPropertyValue(LEGEND_COLUMN_TITLESTYLE_FONTFAMILY))).setDataSlot(1, columnColorDataSlotEntry);
    }

    private boolean compatibleDomains(DataSet columnDataSet, DataSet lineDataSet) {
        DataSlotEntry columnDataSlotEntry = columnDataSet.slot("x").entry();
        DataSlotEntry lineDataSlotEntry = lineDataSet.slot("x").entry();
        if (columnDataSlotEntry != null && lineDataSlotEntry != null && !columnDataSlotEntry.type().equals(lineDataSlotEntry.type())) {
            Library.logError((int)101, (String)"The column bundle X accessors must be the same type");
            return false;
        }
        return true;
    }

    private CoordinateScaleImpl makeIndependentScale(DataSet columnDataSet, DataSet lineDataSet) {
        ArrayEx columnData = ObjectConverter.listToArray((List)((List)columnDataSet.data()));
        ArrayEx lineData = ObjectConverter.listToArray((List)((List)lineDataSet.data()));
        DataSlotEntry columnXAccessor = columnDataSet.slot("x").entry();
        DataSlotEntry lineXAccessor = lineDataSet.slot("x").entry();
        if (columnXAccessor == null || lineXAccessor == null) {
            return null;
        }
        CoordinateScaleImpl columnScale = ScaleManager.makeCoordinateScale((List)columnData, (DataSlotEntry)columnXAccessor);
        CoordinateScaleImpl lineScale = ScaleManager.makeCoordinateScale((List)lineData, (DataSlotEntry)lineXAccessor);
        boolean isClustered = "Clustered".equals(this.getStringProperty("data.handling"));
        if (isClustered || "string".equals(columnXAccessor.type())) {
            OrdinalCoordinateScaleDatum datum;
            Object key;
            OrdinalCoordinateScaleDatum datum2;
            ArrayEx intervalDomain = ObjectConverter.listToArray((List)ScaleManager.ordinalDomain((List)columnData, (DataSlotEntry)columnXAccessor));
            ArrayEx lineDomain = ObjectConverter.listToArray((List)ScaleManager.ordinalDomain((List)lineData, (DataSlotEntry)lineXAccessor));
            ArrayEx uniqueValues = new ArrayEx();
            ES6Map originalDomainMap = ES6Map.create();
            if (intervalDomain != null) {
                for (Object v : intervalDomain) {
                    if (v == null || (datum2 = (OrdinalCoordinateScaleDatum)originalDomainMap.get(v)) != null) continue;
                    uniqueValues.add(v);
                    datum2 = (OrdinalCoordinateScaleDatum)originalDomainMap.set(v, (Object)new OrdinalCoordinateScaleDatum(v));
                }
            }
            if (lineDomain != null) {
                for (Object v : lineDomain) {
                    if (v == null || (datum2 = (OrdinalCoordinateScaleDatum)originalDomainMap.get(v)) != null) continue;
                    uniqueValues.add(v);
                    datum2 = (OrdinalCoordinateScaleDatum)originalDomainMap.set(v, (Object)new OrdinalCoordinateScaleDatum(v));
                }
            }
            for (Object o : columnData) {
                key = columnXAccessor.getValue(o);
                datum = (OrdinalCoordinateScaleDatum)originalDomainMap.get(key);
                if (datum == null) continue;
                datum.push(o);
            }
            for (Object o : lineData) {
                key = lineXAccessor.getValue(o);
                datum = (OrdinalCoordinateScaleDatum)originalDomainMap.get(key);
                if (datum == null) continue;
                datum.push(o);
            }
            ArrayEx originalDomain = new ArrayEx();
            for (Object d : uniqueValues) {
                originalDomain.add(originalDomainMap.get(d));
            }
            if (isClustered) {
                DataSlotEntry colorAccessor = columnDataSet.slot(DATASLOT_GROUP).entry();
                ArrayEx domains = new ArrayEx();
                domains.add((Object)uniqueValues);
                domains.add((Object)ScaleManager.ordinalDomain((List)columnData, (DataSlotEntry)colorAccessor));
                columnScale = ClusteredCoordinateScale.create((List)domains, (List)originalDomain);
            } else {
                columnScale = OrdinalCoordinateScale.create((List)uniqueValues, (List)originalDomain);
            }
        } else {
            List intervalDomain = columnScale.scale().domain();
            List lineDomain = lineScale.scale().domain();
            if (intervalDomain.size() == 0 && lineDomain == null) {
                return null;
            }
            ArrayEx domain = intervalDomain.size() == 0 && lineDomain != null ? ObjectConverter.listToArray((List)lineDomain) : (lineDomain == null && intervalDomain.size() > 0 ? ObjectConverter.listToArray((List)intervalDomain) : new ArrayEx(new Object[]{Rave.min((List)new ArrayEx(new Object[]{intervalDomain.get(0), lineDomain.get(0)})), Rave.max((List)new ArrayEx(new Object[]{intervalDomain.get(1), lineDomain.get(1)}))}));
            String type = lineXAccessor.type();
            columnScale = "numeric".equals(type) ? LinearCoordinateScale.create((List)domain) : TimeCoordinateScale.create((List)domain);
        }
        if (columnScale != null) {
            columnScale.originalDomainLabelAccessor((ValueFunction)new ValueFunction<Object, String>(){

                @SwiftMethodOverload(skipParameters={1})
                public String getValue(Object context, Object data, int index, int groupIndex) {
                    Object key = ((OrdinalCoordinateScaleDatum)data).key();
                    return ObjectConverter.toString((Object)key);
                }
            });
        }
        return columnScale;
    }

    private CoordinateScaleImpl makeIntervalDependentScale(DataSlotEntry columnYDataSlotEntry, List<IntervalDataUtilities.IntervalData> data) {
        List domain = columnYDataSlotEntry.domain();
        if (domain != null) {
            return LinearCoordinateScale.create((List)domain);
        }
        Object omax = Rave.max(data, (ValueFunction)new ValueFunction<List<?>, Number>(){

            public Number getValue(List<?> ctxt, Object data, int ix, int gix) {
                double dep1 = ObjectConverter.toDouble((Object)((IntervalDataUtilities.IntervalData)data).dep1);
                double dep2 = ObjectConverter.toDouble((Object)((IntervalDataUtilities.IntervalData)data).dep2);
                return dep1 != 0.0 ? Math.max(dep1, dep2) : dep2;
            }
        });
        if (omax == null) {
            return null;
        }
        Object omin = Rave.min(data, (ValueFunction)new ValueFunction<List<?>, Number>(){

            public Number getValue(List<?> ctxt, Object data, int ix, int gix) {
                double dep1 = ObjectConverter.toDouble((Object)((IntervalDataUtilities.IntervalData)data).dep1);
                double dep2 = ObjectConverter.toDouble((Object)((IntervalDataUtilities.IntervalData)data).dep2);
                return dep1 != 0.0 ? Math.min(dep1, dep2) : dep2;
            }
        });
        CoordinateScaleImpl scale = LinearCoordinateScale.create((List)new ArrayEx(new Object[]{omin, omax}));
        return scale;
    }

    public CoordinateScale getCoordinateScale(String role) {
        if ("ROLE_X1".equals(role)) {
            return this._independentScale;
        }
        if ("ROLE_Y1".equals(role)) {
            return this._intervalDependentScale;
        }
        if ("ROLE_Y2".equals(role)) {
            return this._lineDependentScale;
        }
        return null;
    }

    private String convertZoomOps(boolean swap) {
        String zoom = this.getStringProperty("zoom");
        if (this._transpose) {
            if ("x".equals(zoom)) {
                zoom = "y";
            } else if ("y".equals(zoom)) {
                zoom = swap ? "x2" : "x";
            } else if ("y2".equals(zoom)) {
                zoom = swap ? "x" : "x2";
            }
        }
        return zoom;
    }

    private ValueFunction<Object, Number> delayFunction(int duration, final CoordinateScaleImpl independentScale) {
        double rmax;
        double rmin;
        List range;
        if (duration > 0 && independentScale != null && this.getBooleanProperty("effect.delay") && (range = independentScale.scale().range()) != null && range.size() > 1 && (rmin = ObjectConverter.toDouble(range.get(0))) != (rmax = ObjectConverter.toDouble(range.get(range.size() - 1)))) {
            final double scaling = (double)duration / (rmax - rmin);
            return new ValueFunction<Object, Number>(){

                public Number getValue(Object context, Object data, int index, int groupIndex) {
                    return (ObjectConverter.toDouble((Object)independentScale.center(((IntervalDataUtilities.IntervalData)data).ind1)) - rmin) * scaling;
                }
            };
        }
        return null;
    }

    protected int requireUpdate(String property) {
        if (property.equals("axis.y2.title.text") && !this.getBooleanProperty("axis.y2.title.display")) {
            return 4;
        }
        if (property.equals("legend.title.column") && !this.isShowLegend()) {
            return 4;
        }
        if (property.equals("legend.title.line") && !this.isShowLegend()) {
            return 4;
        }
        if (property.equals(AXIS_LINE_COLUMN_SWAP)) {
            return 1;
        }
        return super.requireUpdate(property);
    }

    protected void setActionsWithBorder() {
        final CompositeView self = this;
        String borderWidth = this.context.convertCSSSizeToPixels(this.context.getPropertyValue("column.borderWidth"));
        Object v = this.getProperty("column.borderColor");
        String borderColor = v == null ? null : ObjectConverter.toString((Object)v);
        final OMap style = new OMap();
        style.put((Object)"stroke-width", (Object)borderWidth);
        style.put((Object)"stroke", (Object)borderColor);
        final ActionImpl highlightAction = this.context.actions.action("highlight");
        ActionImpl unhighlightAction = this.context.actions.action("unhighlight");
        ActionImpl deselectAllAction = this.context.actions.action("deselectAll");
        SelectorEventListener<Event> lineHighlightEventListener = new SelectorEventListener<Event>(){

            public void onEvent(SceneNode context1, Object data, int index, int groupIndex, Event event) {
                if (context1.getParentNode().containsClass("element-line") && context1.containsClass(CompositeView.ELEMENT_SHAPE_CLASSES)) {
                    Rave.select((SceneNode)context1).style("stroke-width", (Object)4);
                } else {
                    highlightAction.call(new Object[]{Rave.select((SceneNode)context1)});
                }
            }
        };
        highlightAction.setBindFn(BundleUtils.bindOrUnbindActionFunctionCreater((BundleContext)this.context, (String)".element-point .element-shape, .element-line .element-shape, .element-column .element-shape", (String[])new String[]{"mouseenter.default"}, (SelectorEventListener)lineHighlightEventListener));
        SelectorEventListener<Event> unhighlightEventListener = new SelectorEventListener<Event>(){

            public void onEvent(SceneNode context1, Object data, int index, int groupIndex, Event event) {
                if (context1.getParentNode().containsClass("element-line") && context1.containsClass(CompositeView.ELEMENT_SHAPE_CLASSES)) {
                    Rave.select((SceneNode)context1).style("stroke-width", (Object)2);
                } else if (context1.getParentNode().containsClass("element-point") && context1.containsClass(CompositeView.ELEMENT_SHAPE_CLASSES)) {
                    Rave.select((SceneNode)context1).style("stroke-width", (Object)0);
                } else if (context1.getParentNode().getParentNode().containsClass("element-column") && context1.containsClass(CompositeView.ELEMENT_SHAPE_CLASSES)) {
                    highlightAction.call(new Object[]{Rave.select((SceneNode)context1), style});
                }
            }
        };
        unhighlightAction.setBindFn(BundleUtils.bindOrUnbindActionFunctionCreater((BundleContext)this.context, (String)".element-point .element-shape, .element-line .element-shape, .element-column .element-shape", (String[])new String[]{"mouseout.default"}, (SelectorEventListener)unhighlightEventListener));
        SelectorEventListener<Event> deselectAllEventListener = new SelectorEventListener<Event>(){

            public void onEvent(SceneNode context1, Object data, int index, int groupIndex, Event event) {
                self.context.node.selectAll(".element-point .element-shape").style("stroke-width", (Object)0).style("opacity", (Object)1).property("selected", null);
                self.context.node.selectAll(".element-line .element-shape").style("stroke-width", (Object)2).style("opacity", (Object)1).property("selected", null);
                ((Selector)self.context.node.selectAll(".element-column .element-shape").style(style)).style("opacity", (Object)1).property("selected", null);
            }
        };
        deselectAllAction.setBindFn(BundleUtils.bindOrUnbindActionFunctionCreater((BundleContext)this.context, (String)".background", (String[])new String[]{"click.default", "touchstart.default"}, (SelectorEventListener)deselectAllEventListener));
    }

    protected void configureLineDataLabels(DataSet dataSet) {
        if (!this.isShowDataLabels()) {
            this._pointComponent.itemLabel(false);
            this._pointComponent.itemLabelPosition((ValueFunction)null);
            this._pointComponent.labelFont(null);
            this._pointComponent.labelAccessor(null);
            this._pointComponent.labelFormatter(null);
            return;
        }
        final CompositeView self = this;
        ValueFunction<Object, Integer> dataLabelPosition = new ValueFunction<Object, Integer>(){

            public Integer getValue(Object context, Object data, int index, int groupIndex) {
                PointDataUtilities.PointDatum nextData;
                PointDataUtilities.PointDatum currentData = (PointDataUtilities.PointDatum)data;
                PointDataUtilities.PointDatum prevData = index == 0 ? null : (PointDataUtilities.PointDatum)self._pointData.get(index - 1);
                PointDataUtilities.PointDatum pointDatum = nextData = index == self._pointData.size() - 1 ? null : (PointDataUtilities.PointDatum)self._pointData.get(index + 1);
                if (prevData == null || nextData == null) {
                    return 0;
                }
                double angleWithPreviousPoint = Math.atan2(self._lineDependentScale.center(prevData._y).doubleValue() - self._lineDependentScale.center(currentData._y).doubleValue(), self._independentScale.center(prevData._x).doubleValue() - self._independentScale.center(currentData._x).doubleValue());
                double angleWithNextPoint = Math.atan2(self._lineDependentScale.center(nextData._y).doubleValue() - self._lineDependentScale.center(currentData._y).doubleValue(), self._independentScale.center(nextData._x).doubleValue() - self._independentScale.center(currentData._x).doubleValue());
                if (angleWithNextPoint <= 0.0 && angleWithPreviousPoint <= 0.0) {
                    return 2;
                }
                if (angleWithNextPoint >= 0.0 && angleWithPreviousPoint >= 0.0 || 180.0 - Math.abs(angleWithPreviousPoint * 57.29577951308232) < 30.0 && Math.abs(angleWithNextPoint * 57.29577951308232) < 30.0) {
                    return 0;
                }
                if (180.0 - Math.abs(angleWithPreviousPoint * 57.29577951308232) > 30.0) {
                    return 3;
                }
                return 4;
            }
        };
        SingleValueFunction<Object, Object> labelAccessor = this.getlDataLabelAccessor(dataSet, "label", false);
        DataSlotEntry labelEntry = this.getEntryForDataLabelFormatter(dataSet, "label", "y");
        this._pointComponent.itemLabel(true);
        this._pointComponent.labelFont(this.getBackgroundConstrastLabelStyle());
        this._pointComponent.labelFormatter((ValueFunction<Object, String>)this.context.getCustomFormatterForElementLabels(labelEntry, dataSet.slot("label").entry() != null ? "ROLE_NONE" : "ROLE_Y2"));
        this._pointComponent.labelAccessor(labelAccessor);
        this._pointComponent.itemLabelPosition((ValueFunction)dataLabelPosition);
    }

    protected void runLabelCollisions(final Selector chart, final RectStruct chartRect, double duration, Object delayFunction) {
        if (!this.isShowDataLabels()) {
            return;
        }
        final CompositeView self = this;
        boolean staggeredTransitions = delayFunction != null;
        this._pendingLabelTimer = true;
        TimerEvent labelCollideCallback = new TimerEvent(){

            public boolean run(double elapsed) {
                if (self._cancelLabelTimers > 0) {
                    self._cancelLabelTimers--;
                    return true;
                }
                self._labelCollisionComponent.bounds(chartRect).numberOfSweeps(1000).labelResolution("Drop Labels");
                chart.call((RunFunction)self._labelCollisionComponent, new Object[0]);
                self._pendingLabelTimer = false;
                return true;
            }
        };
        if (staggeredTransitions) {
            Rave.timer.addEvent(labelCollideCallback, duration * 2.0);
        } else {
            Rave.timer.addEvent(labelCollideCallback, duration);
        }
    }

    protected void stopLabelCollisions() {
        this._labelCollisionComponent.labelResolution("none");
        if (this._pendingLabelTimer) {
            ++this._cancelLabelTimers;
        }
    }

    @Override
    protected String[] getGroupStructure() {
        return new String[]{"defs", "g.vizlibrary vizlibrary-composite", "(", "rect.background chart", "g.chart", "(", "rect.background elements", "g.gridlines", "(", "g.grid left", "g.grid right", "g.grid top", "g.grid bottom", ")", "g.content1", "(", "g.element-column", "(", "g.element-group", "g.element-label-group", ")", ")", "g.axes", "(", "g.axes-layout", "g.axisTransform left", "g.axisTransform right", "g.axisTransform top", "g.axisTransform bottom", ")", "g.content2", "(", "g.elements2", "(", "g.element-group element-line", "g.element-point", "(", "g.element-group", "g.element-label-group", ")", ")", ")", "g.axis-callout", ")", "g.legends", "(", "g.legends-layout", "g.legend line", "g.legend column", ")", ")"};
    }
}

