/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.data;

import com.ibm.rave.bundles.data.BoxplotDatum;
import com.ibm.rave.bundles.data.PointDataUtilities;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.util.Comparator;
import com.ibm.rave.library.framework.internal.CoordinateScaleImpl;
import java.util.List;

public class BoxplotDataUtilities {
    public static ArrayEx<BoxplotDatum> makeData(List<Object> data, CoordinateScaleImpl dataScale, boolean isClustered, SingleValueFunction<Object, Object> x, SingleValueFunction<Object, Object> y, SingleValueFunction<Object, Object> c) {
        ArrayEx result = new ArrayEx();
        if (dataScale == null) {
            return result;
        }
        boolean clustered = isClustered && c != null;
        SingleValueFunction<Object, Object> keyFunc = c == null ? x : new SingleValueFunction<Object, Object>((SingleValueFunction)x, c){
            final /* synthetic */ SingleValueFunction val$x;
            final /* synthetic */ SingleValueFunction val$c;
            {
                this.val$x = singleValueFunction;
                this.val$c = singleValueFunction2;
            }

            public Object getValue(Object d) {
                Object xv = this.val$x.getValue(d);
                Object cv = this.val$c.getValue(d);
                return xv != null && cv != null ? new ArrayEx(new Object[]{xv, cv}) : null;
            }
        };
        OMap dataMap = new OMap();
        OMap xMap = new OMap();
        for (Object d : data) {
            Number xc;
            Object key = keyFunc.getValue(d);
            Object yv = y.getValue(d);
            if (key == null || yv == null || (xc = dataScale.center(key)) == null) continue;
            ArrayEx v = (ArrayEx)dataMap.get((Object)xc);
            if (v == null) {
                v = new ArrayEx();
                dataMap.put((Object)xc, (Object)v);
                xMap.put((Object)xc, clustered ? key : x.getValue(d));
            }
            v.add(d);
        }
        for (Number xv : dataMap.keySet()) {
            result.add((Object)BoxplotDataUtilities.create(xMap.get((Object)xv), xv, (List)dataMap.get((Object)xv), y));
        }
        return result;
    }

    private static BoxplotDatum create(Object xValue, Object keyValue, List<Object> data, SingleValueFunction<Object, Object> y) {
        int len = data.size();
        if (len == 1) {
            double m = ObjectConverter.toDouble((Object)y.getValue(data.get(0)));
            return new BoxplotDatum(xValue, keyValue, m, m, m, m, m, m, (List<PointDataUtilities.PointDatum>)new ArrayEx(), data);
        }
        ArrayEx sorted = new ArrayEx();
        double mean = 0.0;
        for (int i = 0; i < len; ++i) {
            Double v = ObjectConverter.asDouble((Object)y.getValue(data.get(i)));
            sorted.add((Object)v);
            mean += v.doubleValue();
        }
        mean /= (double)len;
        sorted.sort((Comparator)new Comparator<Number>(){

            public int compare(Number obj1, Number obj2) {
                double v = obj1.doubleValue() - obj2.doubleValue();
                return v < 0.0 ? -1 : (v > 0.0 ? 1 : 0);
            }
        });
        double[] values = new double[len];
        for (int i = 0; i < len; ++i) {
            values[i] = ((Number)sorted.get(i)).doubleValue();
        }
        double median = BoxplotDataUtilities.quantile(values, 0.5);
        double upperHinge = BoxplotDataUtilities.quantile(values, 0.75);
        double lowerHinge = BoxplotDataUtilities.quantile(values, 0.25);
        double del = 1.5 * (upperHinge - lowerHinge);
        double lowerFence = lowerHinge - del;
        double upperFence = upperHinge + del;
        ArrayEx outliers = new ArrayEx();
        for (int i = 0; i < len; ++i) {
            Object datum = data.get(i);
            Object yv = y.getValue(datum);
            double v = ObjectConverter.toDouble((Object)yv);
            if (!(v < lowerFence) && !(v > upperFence)) continue;
            PointDataUtilities.PointDatum d = new PointDataUtilities.PointDatum();
            d._x = xValue;
            d._y = yv;
            d._originalData = datum;
            outliers.add((Object)d);
        }
        return new BoxplotDatum(xValue, keyValue, mean, values[0], lowerHinge, median, upperHinge, values[len - 1], (List<PointDataUtilities.PointDatum>)outliers, data);
    }

    private static double quantile(double[] values, double q) {
        double f = (double)(values.length - 1) * q + 1.0;
        int i = (int)Math.floor(f);
        double v = values[i - 1];
        double r = f - (double)i;
        return r != 0.0 ? v + r * (values[i] - v) : v;
    }
}

