/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.data;

import com.ibm.rave.bundles.data.PointDataUtilities;
import com.ibm.rave.library.framework.internal.BundleDatum;
import java.util.List;

public class BoxplotDatum
implements BundleDatum {
    private final Object _x;
    private final Object _key;
    private final double _mean;
    private final double _min;
    private final double _lowerHinge;
    private final double _median;
    private final double _upperHinge;
    private final double _max;
    private final List<PointDataUtilities.PointDatum> _outliers;
    private final List<Object> _data;

    BoxplotDatum(Object x, Object key, double mean, double min, double lowerHinge, double median, double upperHinge, double max, List<PointDataUtilities.PointDatum> outliers, List<Object> data) {
        this._x = x;
        this._key = key;
        this._mean = mean;
        this._min = min;
        this._lowerHinge = lowerHinge;
        this._median = median;
        this._upperHinge = upperHinge;
        this._max = max;
        this._outliers = outliers;
        this._data = data;
    }

    public final Object x() {
        return this._x;
    }

    public final Object key() {
        return this._key;
    }

    public final double mean() {
        return this._mean;
    }

    public final double min() {
        return this._min;
    }

    public final double lowerExtreme() {
        return Math.max(this._min, this._lowerHinge - 3.0 * (this._upperHinge - this._lowerHinge));
    }

    public final double lowerFence() {
        return Math.max(this._min, this._lowerHinge - 1.5 * (this._upperHinge - this._lowerHinge));
    }

    public final double lowerHinge() {
        return this._lowerHinge;
    }

    public final double median() {
        return this._median;
    }

    public final double upperHinge() {
        return this._upperHinge;
    }

    public final double upperFence() {
        return Math.min(this._max, this._upperHinge + 1.5 * (this._upperHinge - this._lowerHinge));
    }

    public final double upperExtremum() {
        return Math.min(this._max, this._upperHinge + 3.0 * (this._upperHinge - this._lowerHinge));
    }

    public final double max() {
        return this._max;
    }

    public final List<PointDataUtilities.PointDatum> outliers() {
        return this._outliers;
    }

    public final Object originalData() {
        return this._data;
    }

    public final List<Object> originalDataList() {
        return this._data;
    }
}

