/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.data;

import com.ibm.rave.bundles.data.PointDataUtilities;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.arrays.Entry;
import com.ibm.rave.core.arrays.Nest;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.internal.collections.OSet;
import com.ibm.rave.core.internal.nativeImpl.Lang;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.util.Comparator;
import com.ibm.rave.library.framework.internal.BundleDatum;
import com.ibm.rave.library.framework.internal.CoordinateScaleImpl;
import java.util.List;

public class LineDataUtilities {
    public static final SingleValueFunction<Object, Object> GROUP_ACCESSOR = new SingleValueFunction<Object, Object>(){

        public Object getValue(Object d) {
            return ((LineDatum)d).group;
        }
    };
    public static final SingleValueFunction<Object, Object> POINTS_ACCESSOR = new SingleValueFunction<Object, Object>(){

        public Object getValue(Object d) {
            return ((LineDatum)d).points;
        }
    };

    public static ArrayEx<LineDatum> buildLines(ArrayEx<Object> data, SingleValueFunction<Object, Object> xAccessor, SingleValueFunction<Object, Object> xScale, SingleValueFunction<Object, Object> yAccessor, SingleValueFunction<Object, Object> groupAccessor) {
        ArrayEx result = new ArrayEx();
        if (data == null || data.size() == 0) {
            return result;
        }
        OSet categories = new OSet();
        LineDatum noGroup = null;
        OMap lines = new OMap();
        for (Object datum : data) {
            LineDatum line;
            String group;
            Object xValue;
            if (datum == null || (xValue = xAccessor.getValue(datum)) == null || xScale != null && xScale.getValue(xValue) == null) continue;
            if (!categories.contains(xValue)) {
                categories.add((Object)ObjectConverter.toString((Object)xValue));
            }
            String string = group = groupAccessor != null ? ObjectConverter.asString((Object)groupAccessor.getValue(datum)) : null;
            if (group == null) {
                if (noGroup == null) {
                    noGroup = new LineDatum(null);
                    result.add((Object)noGroup);
                }
                line = noGroup;
            } else {
                line = (LineDatum)lines.get((Object)group);
                if (line == null) {
                    line = new LineDatum(group);
                    lines.put((Object)group, (Object)line);
                    result.add((Object)line);
                }
            }
            line.addPoint(datum, xValue, yAccessor.getValue(datum));
        }
        for (Object o : categories.toArray()) {
            double value;
            PointDataUtilities.PointDatum pointDatum;
            int j;
            LineDatum lineDatum;
            int i;
            String s = ObjectConverter.toString((Object)o);
            double sum = 0.0;
            for (i = 0; i < result.size(); ++i) {
                lineDatum = (LineDatum)result.get(i);
                for (j = 0; j < lineDatum._pointData.size(); ++j) {
                    pointDatum = (PointDataUtilities.PointDatum)lineDatum._pointData.get(j);
                    if (!s.equals(pointDatum._x)) continue;
                    pointDatum._yAsPercentOfCategory = Double.NaN;
                    value = ObjectConverter.toDouble((Object)pointDatum._y);
                    sum += Math.abs(value);
                }
            }
            if (sum == 0.0) continue;
            for (i = 0; i < result.size(); ++i) {
                lineDatum = (LineDatum)result.get(i);
                for (j = 0; j < lineDatum._pointData.size(); ++j) {
                    pointDatum = (PointDataUtilities.PointDatum)lineDatum._pointData.get(j);
                    if (!s.equals(pointDatum._x)) continue;
                    value = ObjectConverter.toDouble((Object)pointDatum._y);
                    pointDatum._yAsPercentOfCategory = value / sum * 100.0;
                }
            }
        }
        for (int i = 0; i < result.size(); ++i) {
            double value;
            int j;
            double sum = 0.0;
            LineDatum lineDatum = (LineDatum)result.get(i);
            for (j = 0; j < lineDatum._pointData.size(); ++j) {
                PointDataUtilities.PointDatum pointDatum = (PointDataUtilities.PointDatum)lineDatum._pointData.get(j);
                pointDatum._yAsPercentOfColor = Double.NaN;
                value = ObjectConverter.toDouble((Object)pointDatum._y);
                sum += Math.abs(value);
            }
            if (sum == 0.0) continue;
            for (j = 0; j < lineDatum._pointData.size(); ++j) {
                PointDataUtilities.PointDatum pointDatum = (PointDataUtilities.PointDatum)lineDatum._pointData.get(j);
                value = ObjectConverter.toDouble((Object)pointDatum._y);
                pointDatum._yAsPercentOfColor = value / sum * 100.0;
            }
        }
        return result;
    }

    private static Entry get(String val, ArrayEx<Entry> data) {
        for (int i = 0; i < data.size(); ++i) {
            Entry entry = (Entry)data.get(i);
            if (!Lang.isEqual((Object)entry.key, (Object)val)) continue;
            return entry;
        }
        return null;
    }

    public static ArrayEx<LineDatum> buildLinesForStacking(ArrayEx<Object> data, final SingleValueFunction<Object, Object> xAccessor, final SingleValueFunction<Object, Object> yAccessor, final SingleValueFunction<Object, Object> groupAccessor) {
        if (data == null || data.size() == 0) {
            return new ArrayEx();
        }
        final OMap keyToOriginalValue = new OMap();
        final ArrayEx stacks = new ArrayEx();
        Nest nest = Rave.nest();
        nest.key(new Nest.KeyFunction(){

            public Object getKey(Object d) {
                Object keyValue = xAccessor.getValue(d);
                String strKeyValue = ObjectConverter.asString((Object)keyValue);
                keyToOriginalValue.put((Object)strKeyValue, keyValue);
                return strKeyValue;
            }
        });
        nest.key(new Nest.KeyFunction(){

            public Object getKey(Object d) {
                String stack = groupAccessor.getValue(d).toString();
                if (!stacks.contains((Object)stack)) {
                    stacks.add((Object)stack);
                }
                return stack;
            }
        });
        final ArrayEx result = nest.entries(data);
        final Integer missingValue = new Integer(0);
        ArrayEx stackData = stacks.map((ArrayEx.ArrayValueFunction)new ArrayEx.ArrayValueFunction<String, LineDatum>(){

            public LineDatum getValue(String name, int index, ArrayEx<String> array) {
                final LineDatum line = new LineDatum(((String)array.get(index)).toString());
                result.forEach((ArrayEx.ArrayValueFunction)new ArrayEx.ArrayValueFunction<Entry, Object>(){

                    public Object getValue(Entry currentValue, int index, ArrayEx<Entry> array) {
                        ArrayEx values = (ArrayEx)currentValue.values;
                        Entry currentElement = LineDataUtilities.get(line.group, (ArrayEx<Entry>)values);
                        Object datum = null;
                        Object yValue = null;
                        if (currentElement == null) {
                            yValue = missingValue;
                        } else {
                            datum = ((ArrayEx)currentElement.values).get(0);
                            yValue = yAccessor.getValue(datum);
                            if (yValue == null) {
                                yValue = missingValue;
                            }
                        }
                        line.addPoint(datum, keyToOriginalValue.get(currentValue.key), yValue);
                        return null;
                    }
                });
                return line;
            }
        });
        return stackData;
    }

    public static void sortLines(ArrayEx<LineDatum> lines, final CoordinateScaleImpl scale) {
        Comparator<PointDataUtilities.PointDatum> comp = new Comparator<PointDataUtilities.PointDatum>(){

            public int compare(PointDataUtilities.PointDatum a, PointDataUtilities.PointDatum b) {
                Number av = scale.center(a._x);
                if (av == null) {
                    return 1;
                }
                Number bv = scale.center(b._x);
                if (bv == null) {
                    return -1;
                }
                double v = av.doubleValue() - bv.doubleValue();
                return v < 0.0 ? -1 : (v > 0.0 ? 1 : 0);
            }
        };
        for (LineDatum line : lines) {
            line.sort(comp);
        }
    }

    public static ArrayEx<PointDataUtilities.PointDatum> getLineWithPoints(ArrayEx<LineDatum> lines) {
        ArrayEx result = new ArrayEx();
        for (LineDatum line : lines) {
            line.getLineWithPoints((ArrayEx<PointDataUtilities.PointDatum>)result);
        }
        return result;
    }

    public static ArrayEx<PointDataUtilities.PointDatum> getNPNPoints(ArrayEx<LineDatum> lines) {
        ArrayEx result = new ArrayEx();
        for (LineDatum line : lines) {
            line.getNPNPoints((ArrayEx<PointDataUtilities.PointDatum>)result);
        }
        return result;
    }

    public static class LineDatum
    implements BundleDatum {
        public final String group;
        public final ArrayEx<ArrayEx<Object>> points;
        private final ArrayEx<PointDataUtilities.PointDatum> _pointData;
        private final ArrayEx<Object> _originalData;

        LineDatum(String group) {
            this.group = group;
            this.points = new ArrayEx();
            this._pointData = new ArrayEx();
            this._originalData = new ArrayEx();
        }

        public Object originalData() {
            return this._originalData;
        }

        public List<Object> originalDataList() {
            return this._originalData;
        }

        void addPoint(Object originalData, Object x, Object y) {
            PointDataUtilities.PointDatum point = new PointDataUtilities.PointDatum();
            point._x = x;
            point._y = y;
            point._originalData = originalData;
            this.points.add((Object)new ArrayEx(new Object[]{x, y}));
            this._pointData.add((Object)point);
            this._originalData.add(originalData);
        }

        void sort(Comparator<PointDataUtilities.PointDatum> comp) {
            this._pointData.sort(comp);
            int N = this._pointData.size();
            for (int i = 0; i < N; ++i) {
                PointDataUtilities.PointDatum d = (PointDataUtilities.PointDatum)this._pointData.get(i);
                ArrayEx p = (ArrayEx)this.points.get(i);
                p.set(0, d._x);
                p.set(1, d._y);
                this._originalData.set(i, d._originalData);
            }
        }

        void getLineWithPoints(ArrayEx<PointDataUtilities.PointDatum> result) {
            for (PointDataUtilities.PointDatum point : this._pointData) {
                if (point._y == null) continue;
                result.add((Object)point);
            }
        }

        void getNPNPoints(ArrayEx<PointDataUtilities.PointDatum> result) {
            int N = this._pointData.size();
            Object lastY = null;
            for (int i = 0; i < N; ++i) {
                PointDataUtilities.PointDatum point = (PointDataUtilities.PointDatum)this._pointData.get(i);
                if (point._y != null) {
                    Object nextY;
                    Object object = nextY = i < N - 1 ? ((PointDataUtilities.PointDatum)this._pointData.get((int)(i + 1)))._y : null;
                    if (lastY == null && nextY == null) {
                        result.add((Object)point);
                    }
                }
                lastY = point._y;
            }
        }
    }
}

