/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.data;

import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.internal.nativeImpl.NumberFormatHelper;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.library.framework.internal.BundleDatum;
import java.util.List;

public class PointDataUtilities {
    public static final SingleValueFunction<Object, Object> X_ACCESSOR = new SingleValueFunction<Object, Object>(){

        public Object getValue(Object d) {
            return ((PointDatum)d)._x;
        }
    };
    public static final SingleValueFunction<Object, Object> Y_ACCESSOR = new SingleValueFunction<Object, Object>(){

        public Object getValue(Object d) {
            return ((PointDatum)d)._y;
        }
    };
    public static final SingleValueFunction<Object, Object> PERCENT_OF_CATEGORY_ACCESSOR = new SingleValueFunction<Object, Object>(){

        public Object getValue(Object d) {
            double percent = ObjectConverter.toDouble((Object)((PointDatum)d)._yAsPercentOfCategory);
            return Double.isNaN(percent) ? "" : NumberFormatHelper.toFixed((double)percent, (int)1) + "%";
        }
    };
    public static final SingleValueFunction<Object, Object> PERCENT_OF_COLOR_ACCESSOR = new SingleValueFunction<Object, Object>(){

        public Object getValue(Object d) {
            double percent = ObjectConverter.toDouble((Object)((PointDatum)d)._yAsPercentOfColor);
            return Double.isNaN(percent) ? "" : NumberFormatHelper.toFixed((double)percent, (int)1) + "%";
        }
    };

    public static List<PointDatum> buildPoints(List<Object> data, SingleValueFunction<Object, Object> xAccessor, SingleValueFunction<Object, Object> xScale, SingleValueFunction<Object, Object> yAccessor, SingleValueFunction<Object, Object> yScale) {
        ArrayEx result = new ArrayEx();
        if (data != null) {
            for (Object o : data) {
                if (o == null) continue;
                Object xv = null;
                if (xAccessor != null && ((xv = xAccessor.getValue(o)) == null || xScale != null && xScale.getValue(xv) == null)) continue;
                Object yv = null;
                if (yAccessor != null && ((yv = yAccessor.getValue(o)) == null || yScale != null && yScale.getValue(yv) == null)) continue;
                PointDatum datum = new PointDatum();
                datum._x = xv;
                datum._y = yv;
                datum._originalData = o;
                result.add((Object)datum);
            }
        }
        return result;
    }

    public static class PointDatum
    implements BundleDatum {
        public Object _x;
        public Object _y;
        public Object _yAsPercentOfCategory;
        public Object _yAsPercentOfColor;
        public Object _originalData;

        public Object originalData() {
            return this._originalData;
        }

        public List<Object> originalDataList() {
            ArrayEx list = new ArrayEx();
            list.add(this._originalData);
            return list;
        }
    }
}

