/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.dialBundle;

import com.ibm.rave.bundles.components.DialComponentImpl;
import com.ibm.rave.bundles.data.DialDatum;
import com.ibm.rave.bundles.views.BundleView;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.event.Event;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.SelectorEventListener;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.library.action.BundleUtils;
import com.ibm.rave.library.action.internal.ActionImpl;
import com.ibm.rave.library.datamodel.DataSet;
import com.ibm.rave.library.datamodel.DataSlot;
import com.ibm.rave.library.datamodel.DataSlotEntry;
import com.ibm.rave.library.framework.internal.BundleContext;
import com.ibm.rave.library.palette.Palette;
import java.util.Iterator;
import java.util.List;

public class DialView
extends BundleView {
    private static final String DATASET_DIAL = "data";
    private static final String DATASLOT_COLOR = "color";
    private static final String LASTCHART_NONE = "none";
    private static final String LASTCHART_ONE = "one";
    private static final String LASTCHART_MULTI = "multi";
    private DialComponentImpl[] _dialComponents;
    String[] categories;
    OMap<String, Integer> categoryIndMap;
    private DataSlotEntry categorySlot;
    private DataSlotEntry labelSlot;
    private DataSlotEntry colorSlot;
    private DataSlotEntry valueSlot;
    private DataSlotEntry maxValueSlot;
    private DataSlotEntry keySlot;
    private SingleValueFunction<Object, Object> colorAccessor;
    private SingleValueFunction<Object, Object> categoryAccessor;
    private ArrayEx<Object> _data;
    private RectStruct chartRect;
    private RectStruct legendRect;
    private String lastChart = "none";

    DialView(BundleContext context) {
        super(context);
    }

    @Override
    public void setup() {
        super.setup();
        BundleUtils.setupDefaultActions((BundleContext)this.context, (String)".chart .element-shape", null);
    }

    @Override
    protected boolean isZoomSupported() {
        return false;
    }

    public void draw() {
        boolean legendVisibilityChanged;
        if (this.isUpdateNothing()) {
            return;
        }
        this.preDraw("g.vizlibrary-dial");
        if (!this.validateDataModel(new String[0])) {
            return;
        }
        this.setActionsWithBorder();
        String effect = this.getStringProperty("effect.name");
        int transitionDur = this.getEffectDuration(effect);
        DataSet dataSet = this.dataModel.dataset(DATASET_DIAL);
        DataSlot color = dataSet.slot(DATASLOT_COLOR);
        if (this.updateType == 0) {
            this.categorySlot = dataSet.slot("category").entry();
            this.labelSlot = dataSet.slot("label").entry();
            this.colorSlot = color.entry();
            this.valueSlot = dataSet.slot("value").entry();
            this.maxValueSlot = dataSet.slot("maxValue").entry();
            this.keySlot = dataSet.slot("key").entry();
            if (this.labelSlot == null && this.categorySlot == null || this.valueSlot == null) {
                return;
            }
            if (this.colorSlot == null && this.valueSlot != null) {
                color.overrideLabel(this.valueSlot.label());
            }
            this._data = ObjectConverter.listToArray((List)((List)dataSet.data()));
            this.context.actions.action("deselectAll").call(new Object[]{this.context.node.selectAll(".element-shape")});
            this.colorAccessor = this.colorSlot != null ? new SingleValueFunction<Object, Object>(){

                public Object getValue(Object data) {
                    return ((DialDatum)data).color();
                }
            } : null;
            this.categoryAccessor = this.categorySlot != null ? new SingleValueFunction<Object, Object>(){

                public Object getValue(Object data) {
                    return ((DialDatum)data).category();
                }
            } : null;
        }
        Palette colorPalette = this.getPalette();
        colorPalette.setData(dataSet, DATASLOT_COLOR);
        colorPalette.setAccessor(this.colorAccessor);
        colorPalette.setNullColor(this.getStringProperty("color.null"));
        boolean showLegend = this.isShowLegend();
        String legendPosition = this.getLegendPosition();
        this._legends.visible(showLegend).position(legendPosition).transition(!LASTCHART_NONE.equals(effect), transitionDur).setPreExecute(this.context.getPreExecute()).selector(0, this.context.node.selectAll("g.legend")).palette(0, colorPalette).shape(0, "square").title(0, this.context.getDataSlotLabel("legend.title", this.colorSlot)).titleFill(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fill"))).titleFontSize(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontsize"))).titleFontFamily(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontfamily"))).setDataSlot(0, this.colorSlot);
        boolean bl = legendVisibilityChanged = this._legends.anyVisible() != showLegend;
        if (legendVisibilityChanged) {
            this.updateType = 1;
        }
        if (this.updateType <= 1) {
            this.prepareLayoutComponent();
            this.prepareLayoutSizables(this._layoutComponent, false, false, false, false, showLegend);
            this._legends.preLayout(this._layoutComponent);
            this._layoutComponent.layout();
            legendPosition = this._layoutComponent.legendPosition();
            this._legends.position(legendPosition);
            this.chartRect = this._layoutComponent.elementRect();
            this.legendRect = this._layoutComponent.legendRect();
            this._clip.clipRect(this.chartRect).applyTo(this._chart.select((Object)".cliparea")).run((Selection<?>)this.context.node.select((Object)"defs"), new Object[0]);
        }
        this._legends.rectangle(this.legendRect).draw();
        ValueFunction labelCustomFormatter = this.context.getCustomFormatterForElementLabels(this.labelSlot);
        if (this.labelSlot == null) {
            this.context.getCustomFormatterForElementLabels(this.categorySlot);
        }
        String currentlyReached = this.context.message("currently.reached", "currently reached");
        String reachedOverTarget = this.context.message("reached.over.target", "reached over target");
        Object[] dataArray = this._data.toArray();
        OMap categoryMap = new OMap();
        if (this.categorySlot != null) {
            OMap catIndMap = new OMap();
            if (LASTCHART_ONE.equals(this.lastChart)) {
                this._chart.selectAll("g.element-group").selectAll("*").transition().duration((Object)transitionDur).attr("opacity", (Object)0).remove();
                this._dialComponents[0].firstRender();
            }
            this.lastChart = LASTCHART_MULTI;
            int numCategories = 0;
            for (Object datum : dataArray) {
                ArrayEx categoryData;
                Object key = this.categorySlot.getValue(datum);
                if (!categoryMap.containsKey(key)) {
                    catIndMap.put((Object)((String)key), (Object)numCategories++);
                    categoryData = new ArrayEx();
                    categoryData.add(datum);
                    categoryMap.put(key, (Object)categoryData);
                    continue;
                }
                categoryData = (ArrayEx)categoryMap.get(key);
                categoryData.add(datum);
            }
            this.categories = new String[numCategories];
            Iterator iterator = catIndMap.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                this.categories[((Integer)catIndMap.get((Object)key)).intValue()] = key = (String)iterator.next();
            }
            this.resizeDialComponents(numCategories, this.categories, this.categoryIndMap, (OMap<String, Integer>)catIndMap);
            if (this._dialComponents.length > 0) {
                this.categoryIndMap = catIndMap;
                RectStruct[] subChartRects = this.subdivideChartRect(this.chartRect, numCategories);
                Selector categoryCharts = this._chart.selectAll("g.element-group").selectAll(".category").data((Object[])this.categories);
                final DialView self = this;
                categoryCharts.enter().append("g").attr("class", (ValueFunction)new ValueFunction<SceneNode, String>(){

                    public String getValue(SceneNode context, Object data, int index, int groupIndex) {
                        return "category cat-" + self.categoryIndMap.get((Object)((String)data));
                    }
                });
                Rave.transition((Selection)categoryCharts.exit()).attr("opacity", (Object)0).remove();
                double maxValue = ObjectConverter.toDouble((Object)this.context.getPropertyValue("maxValue"));
                maxValue = this._dialComponents[0].calculateMaxValue(this.makeDatum(dataArray), maxValue);
                int i = 0;
                for (String category : this.categories) {
                    Object[] categoryDataArray = ((ArrayEx)categoryMap.get((Object)category)).toArray();
                    this._dialComponents[i].dialData(this.makeDatum(categoryDataArray)).bounds(subChartRects[i]).colorPalette(colorPalette).currentlyReached(currentlyReached).reachedOverTarget(reachedOverTarget).valueCustomFormatter((ValueFunction<Object, String>)labelCustomFormatter).transitionDur(transitionDur).minFontSize(this.getCSSSizeToPixelNumber("minFontSize")).showAsPercentage(this.getBooleanProperty("showAsPercentage")).roundedEnds(this.getBooleanProperty("roundedEnds")).startAngle(ObjectConverter.toDouble((Object)this.context.getPropertyValue("startAngle"))).maxValue(maxValue).categoryDial(true).paddingColor(this.getStringProperty("paddingColor")).backRingColor(this.getStringProperty("backRingColor")).dialWidth(this.getCSSSizeToPixelNumber("dialWidth")).dialPadding(this.getCSSSizeToPixelNumber("dialPadding")).valueColor(this.getStringProperty("valueColor")).valueSize(this.getCSSSizeToPixelNumber("valueSize")).valueFont(this.getStringProperty("valueFont")).centerRadius(this.getCSSSizeToPixelNumber("centerRadius")).centerPaddingRadius(this.getCSSSizeToPixelNumber("centerPaddingRadius")).centerBackgroundRadius(this.getCSSSizeToPixelNumber("centerBackgroundRadius")).proportionalWidths(this.getBooleanProperty("proportionalWidths")).borderWidth(this.context.convertCSSSizeToPixels(this.context.getPropertyValue("borderWidth"))).borderColor(ObjectConverter.asString((Object)this.context.getPropertyValue("borderColor"))).centerColor(this.getStringProperty("centerColor"));
                    this._chart.selectAll("g.cat-" + i).transition().duration((Object)transitionDur).call((RunFunction)this._dialComponents[i++], new Object[0]);
                }
            }
        } else {
            this.categories = null;
            this.categoryIndMap = null;
            this.resizeDialComponents(1, null, null, null);
            if (this._dialComponents.length > 0) {
                if (LASTCHART_MULTI.equals(this.lastChart)) {
                    this._chart.selectAll("g.element-group").selectAll(".category").remove();
                    this._dialComponents[0].firstRender();
                }
                this.lastChart = LASTCHART_ONE;
                this._dialComponents[0].dialData(this.makeDatum(dataArray)).bounds(this.chartRect).colorPalette(colorPalette).currentlyReached(currentlyReached).reachedOverTarget(reachedOverTarget).valueCustomFormatter((ValueFunction<Object, String>)labelCustomFormatter).transitionDur(transitionDur).minFontSize(this.getCSSSizeToPixelNumber("minFontSize")).showAsPercentage(this.getBooleanProperty("showAsPercentage")).roundedEnds(this.getBooleanProperty("roundedEnds")).startAngle(ObjectConverter.toDouble((Object)this.context.getPropertyValue("startAngle"))).maxValue(ObjectConverter.toDouble((Object)this.context.getPropertyValue("maxValue"))).paddingColor(this.getStringProperty("paddingColor")).backRingColor(this.getStringProperty("backRingColor")).dialWidth(this.getCSSSizeToPixelNumber("dialWidth")).dialPadding(this.getCSSSizeToPixelNumber("dialPadding")).valueColor(this.getStringProperty("valueColor")).valueSize(this.getCSSSizeToPixelNumber("valueSize")).valueFont(this.getStringProperty("valueFont")).centerRadius(this.getCSSSizeToPixelNumber("centerRadius")).centerPaddingRadius(this.getCSSSizeToPixelNumber("centerPaddingRadius")).centerBackgroundRadius(this.getCSSSizeToPixelNumber("centerBackgroundRadius")).proportionalWidths(this.getBooleanProperty("proportionalWidths")).borderWidth(this.context.convertCSSSizeToPixels(this.context.getPropertyValue("borderWidth"))).borderColor(ObjectConverter.asString((Object)this.context.getPropertyValue("borderColor"))).centerColor(this.getStringProperty("centerColor"));
                this._chart.selectAll("g.element-group").transition().duration((Object)transitionDur).call((RunFunction)this._dialComponents[0], new Object[0]);
            }
        }
        this.resetUpdate();
        if (this._dialComponents.length == 0) {
            this._chart.selectAll("g.element-group").selectAll("*").remove();
        }
        this._chart.selectAll(".element-shape").classed("bundle-shape", true);
        this._chart.selectAll(".legendShape").classed("bundle-shape", true);
        this.setBackgroundProperties(this.chartRect, transitionDur);
    }

    DialDatum[] makeDatum(Object[] dataArray) {
        ArrayEx dialData = new ArrayEx();
        for (int i = 0; i < dataArray.length; ++i) {
            String category = this.categorySlot != null ? (String)this.categorySlot.getValue(dataArray[i]) : null;
            String label = this.labelSlot != null ? (String)this.labelSlot.getValue(dataArray[i]) : null;
            Object color = this.colorSlot != null ? this.colorSlot.getValue(dataArray[i]) : null;
            Number value = (Number)this.valueSlot.getValue(dataArray[i]);
            Number maxValue = this.maxValueSlot != null ? (Number)((Number)this.maxValueSlot.getValue(dataArray[i])) : (Number)null;
            Object key = this.keySlot != null ? this.keySlot.getValue(dataArray[i]) : null;
            DialDatum datum = new DialDatum(dataArray[i], category, label, color, value, maxValue, key);
            dialData.add((Object)datum);
        }
        Object[] dialDatums = new DialDatum[dataArray.length];
        return (DialDatum[])dialData.toArray(dialDatums);
    }

    private void resizeDialComponents(int size, String[] categories, OMap<String, Integer> oldCatMap, OMap<String, Integer> newCatMap) {
        if (this._dialComponents == null) {
            this._dialComponents = new DialComponentImpl[size];
            for (int i = 0; i < size; ++i) {
                this._dialComponents[i] = new DialComponentImpl();
            }
        } else if (size != this._dialComponents.length) {
            DialComponentImpl[] newDials = new DialComponentImpl[size];
            if (size == 1 && categories == null) {
                newDials[0] = this._dialComponents[0] != null ? this._dialComponents[0] : new DialComponentImpl();
            } else {
                int i;
                if (oldCatMap == null) {
                    if (this._dialComponents[0] != null) {
                        newDials[0] = this._dialComponents[0];
                    }
                } else {
                    for (i = 0; i < size; ++i) {
                        if (!oldCatMap.containsKey((Object)categories[i])) continue;
                        newDials[((Integer)newCatMap.get((Object)categories[i])).intValue()] = this._dialComponents[(Integer)oldCatMap.get((Object)categories[i])];
                    }
                }
                for (i = 0; i < size; ++i) {
                    if (newDials[i] != null) continue;
                    newDials[i] = new DialComponentImpl();
                }
            }
            this._dialComponents = newDials;
        }
    }

    protected void setActionsWithBorder() {
        final DialView self = this;
        String borderWidth = this.context.convertCSSSizeToPixels(this.context.getPropertyValue("borderWidth"));
        Object v = this.getProperty("borderColor");
        String borderColor = v == null ? null : ObjectConverter.toString((Object)v);
        final OMap style = new OMap();
        style.put((Object)"stroke-width", (Object)borderWidth);
        style.put((Object)"stroke", (Object)borderColor);
        final ActionImpl highlightAction = this.context.actions.action("highlight");
        final ActionImpl unhighlightAction = this.context.actions.action("unhighlight");
        ActionImpl deselectAllAction = this.context.actions.action("deselectAll");
        SelectorEventListener<Event> highlightEventListener = new SelectorEventListener<Event>(){

            public void onEvent(SceneNode context1, Object data, int index, int groupIndex, Event event) {
                highlightAction.call(new Object[]{Rave.select((SceneNode)context1)});
                if (self.categoryIndMap != null) {
                    String category = (String)self.categoryAccessor.getValue(data);
                    int catIndex = (Integer)self.categoryIndMap.get((Object)category);
                    self._dialComponents[catIndex].setLabels(data);
                } else {
                    self._dialComponents[0].setLabels(data);
                }
            }
        };
        highlightAction.setBindFn(BundleUtils.bindOrUnbindActionFunctionCreater((BundleContext)this.context, (String)".chart .element-shape", (String[])new String[]{"mouseenter.default"}, (SelectorEventListener)highlightEventListener));
        highlightAction.setUnbindFn(BundleUtils.bindOrUnbindActionFunctionCreater((BundleContext)this.context, (String)".chart .element-shape", (String[])new String[]{"mouseenter.default"}, null));
        SelectorEventListener<Event> unhighlightEventListener = new SelectorEventListener<Event>(){

            public void onEvent(SceneNode context1, Object data, int index, int groupIndex, Event event) {
                unhighlightAction.call(new Object[]{Rave.select((SceneNode)context1), style});
                if (self.categoryIndMap != null) {
                    String category = (String)self.categoryAccessor.getValue(data);
                    int catIndex = (Integer)self.categoryIndMap.get((Object)category);
                    self._dialComponents[catIndex].setLabels(null);
                } else {
                    self._dialComponents[0].setLabels(null);
                }
            }
        };
        unhighlightAction.setBindFn(BundleUtils.bindOrUnbindActionFunctionCreater((BundleContext)this.context, (String)".dial-group .element-shape", (String[])new String[]{"mouseout.default"}, (SelectorEventListener)unhighlightEventListener));
        unhighlightAction.setUnbindFn(BundleUtils.bindOrUnbindActionFunctionCreater((BundleContext)this.context, (String)".dial-group .element-shape", (String[])new String[]{"mouseout.default"}, null));
        SelectorEventListener<Event> deselectAllEventListener = new SelectorEventListener<Event>(){

            public void onEvent(SceneNode context1, Object data, int index, int groupIndex, Event event) {
                ((Selector)self.context.node.selectAll(".element-shape").style(style)).style("opacity", (Object)1).property("selected", null);
            }
        };
        deselectAllAction.setBindFn(BundleUtils.bindOrUnbindActionFunctionCreater((BundleContext)this.context, (String)".backgrounds, .background", (String[])new String[]{"click.default", "touchstart.default"}, (SelectorEventListener)deselectAllEventListener));
        deselectAllAction.setUnbindFn(BundleUtils.bindOrUnbindActionFunctionCreater((BundleContext)this.context, (String)".backgrounds, .background", (String[])new String[]{"click.default", "touchstart.default"}, null));
    }

    private RectStruct[] subdivideChartRect(RectStruct currentRect, int numDivisions) {
        double width = currentRect.width;
        double height = currentRect.height;
        int tileSize = DialView.getTileSize(width, height, numDivisions);
        int horizCount = (int)(width / (double)tileSize);
        int vertCount = (int)(height / (double)tileSize);
        boolean adjustTiling = true;
        double subWidth = currentRect.width / (double)horizCount;
        double subHeight = currentRect.height / (double)vertCount;
        while (adjustTiling) {
            if (subWidth < subHeight) {
                if (horizCount * (vertCount - 1) >= numDivisions) {
                    subHeight = currentRect.height / (double)(--vertCount);
                    continue;
                }
                adjustTiling = false;
                continue;
            }
            if ((horizCount - 1) * vertCount >= numDivisions) {
                subWidth = currentRect.width / (double)(--horizCount);
                continue;
            }
            adjustTiling = false;
        }
        ArrayEx newChartRects = new ArrayEx();
        double y = currentRect.y;
        for (int i = 0; i < vertCount; ++i) {
            double x = currentRect.x;
            for (int j = 0; j < horizCount; ++j) {
                RectStruct newRect = new RectStruct(x, y, subWidth, subHeight);
                newChartRects.add((Object)newRect);
                x += subWidth;
            }
            y += subHeight;
        }
        Object[] subRects = new RectStruct[numDivisions];
        return (RectStruct[])newChartRects.toArray(subRects);
    }

    private static int getTileSize(double width, double height, int tileCount) {
        int ySize;
        double aspect = height / width;
        double xf = Math.sqrt((double)tileCount / aspect);
        double yf = xf * aspect;
        int xCount = (int)Math.max(1.0, Math.floor(xf));
        int yCount = (int)Math.max(1.0, Math.floor(yf));
        int xSize = (int)Math.floor(width / (double)xCount);
        int tileSize = Math.min(xSize, ySize = (int)Math.floor(height / (double)yCount));
        if ((xCount = (int)Math.floor(width / (double)tileSize)) * (yCount = (int)Math.floor(height / (double)tileSize)) < tileCount) {
            if ((xCount + 1) * yCount < tileCount && xCount * (yCount + 1) < tileCount) {
                xSize = (int)Math.floor(width / (double)(xCount + 1));
                ySize = (int)Math.floor(height / (double)(yCount + 1));
                tileSize = Math.min(xSize, ySize);
            } else {
                int testX = (int)Math.ceil((double)tileCount / (double)yCount);
                int testY = (int)Math.ceil((double)tileCount / (double)xCount);
                xSize = (int)Math.min(Math.floor(width / (double)testX), Math.floor(height / (double)yCount));
                ySize = (int)Math.min(Math.floor(width / (double)xCount), Math.floor(height / (double)testY));
                tileSize = Math.max(xSize, ySize);
            }
        }
        return tileSize;
    }

    @Override
    protected String[] getGroupStructure() {
        return new String[]{"defs", "g.vizlibrary vizlibrary-dial", "(", "rect.background chart", "g.chart", "(", "g.content", "(", "g.gridlines", "(", "g.grid left", "g.grid bottom", ")", "rect.background elements", "g.elements", "(", "g.element-group", ")", ")", ")", "g.legends", "(", "g.legends-layout", "g.legend", ")", ")"};
    }
}

