/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.heatmapBundle;

import com.ibm.rave.bundles.components.ComponentConfiguration;
import com.ibm.rave.bundles.components.IntervalComponentImpl;
import com.ibm.rave.bundles.data.PointDataUtilities;
import com.ibm.rave.bundles.utilities.FontPropertyParser;
import com.ibm.rave.bundles.views.BundleView;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.core.behavior.Zoom;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.Dim;
import com.ibm.rave.core.geom.Point;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.EventQueue;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.util.Runnable;
import com.ibm.rave.library.action.BundleUtils;
import com.ibm.rave.library.datamodel.DataSet;
import com.ibm.rave.library.datamodel.DataSlotEntry;
import com.ibm.rave.library.framework.CoordinateScale;
import com.ibm.rave.library.framework.internal.BundleContext;
import com.ibm.rave.library.framework.internal.CoordinateScaleImpl;
import com.ibm.rave.library.framework.internal.ScaleManager;
import com.ibm.rave.library.palette.Palette;
import java.util.List;

public class HeatmapView
extends BundleView {
    private static final String DATASLOT_COLOR = "color";
    private static final String Y_AXIS_PROPERTIES = "axis.y.alignment";
    private static final String X_AXIS_PROPERTIES = "axis.x.alignment";
    @InlineStringConstant
    private static final String LABEL_FONTSTYLE = "labelstyle.font";
    @InlineStringConstant
    private double MAX_CELL_SIZE;
    @InlineStringConstant
    private double MIN_CELL_SIZE;
    private IntervalComponentImpl _intervalComponent;
    private CoordinateScaleImpl _independentScale;
    private CoordinateScaleImpl _dependentScale;
    private DataSlotEntry xDataAccessor;
    private DataSlotEntry yDataAccessor;
    private DataSlotEntry colorDataAccessor;
    private DataSlotEntry key = null;
    private List<PointDataUtilities.PointDatum> _data;
    private AbstractScale<?, ?> zoomXScale;
    private AbstractScale<?, ?> zoomYScale;
    private double minCellDim;
    private Object zoomendedTimer;

    HeatmapView(BundleContext context) {
        super(context);
    }

    @Override
    protected boolean isAxesManagerRequired() {
        return true;
    }

    @Override
    public void setup() {
        super.setup();
        this._intervalComponent = new IntervalComponentImpl();
        this._intervalComponent.independent1Accessor(PointDataUtilities.X_ACCESSOR).independent2Accessor(PointDataUtilities.X_ACCESSOR).dependent1Accessor(PointDataUtilities.Y_ACCESSOR).dependent2Accessor(PointDataUtilities.Y_ACCESSOR);
        OMap style = new OMap();
        style.put((Object)"stroke-width", (Object)"1px");
        style.put((Object)"stroke", (Object)"white");
        BundleUtils.setupDefaultActions((BundleContext)this.context, (String)".chart .element-shape", (OMap)style);
    }

    public void draw() {
        boolean legendVisibilityChanged;
        if (this.isUpdateNothing()) {
            return;
        }
        this.preDraw("g.vizlibrary-heatmap");
        if (!this.validateDataModel("g.element-group", "g.axis")) {
            return;
        }
        this.setBorder("cell.borderWidth", "cell.borderColor");
        String effect = this.getStringProperty("effect.name");
        int duration = this.getEffectDuration(effect);
        DataSet dataSet = this.dataModel.dataset("data");
        List originalData = (List)dataSet.data();
        if (this.updateType == 0) {
            this.xDataAccessor = dataSet.slot("x").entry();
            this.yDataAccessor = dataSet.slot("y").entry();
            this.key = dataSet.slot("key").entry();
            this.colorDataAccessor = dataSet.slot(DATASLOT_COLOR).entry();
            this._data = PointDataUtilities.buildPoints(originalData, (SingleValueFunction<Object, Object>)this.xDataAccessor.accessor(), (SingleValueFunction<Object, Object>)HeatmapView.domainCheckerOf((List)originalData, (DataSlotEntry)this.xDataAccessor), (SingleValueFunction<Object, Object>)this.yDataAccessor.accessor(), (SingleValueFunction<Object, Object>)HeatmapView.domainCheckerOf((List)originalData, (DataSlotEntry)this.yDataAccessor));
            this.context.actions.action("deselectAll").call(new Object[]{this.context.node.selectAll(".element-shape")});
        }
        Palette colorPalette = this.getDynamicPalette();
        colorPalette.setData(dataSet, DATASLOT_COLOR);
        colorPalette.setAccessor(HeatmapView.originalDatumAccessor((SingleValueFunction)this.colorDataAccessor));
        colorPalette.setNullColor(this.getStringProperty("color.null"));
        boolean showLegend = this.isShowLegend();
        boolean bl = legendVisibilityChanged = this._legends.anyVisible() != showLegend;
        if (legendVisibilityChanged) {
            this.updateType = 1;
        }
        String legendPosition = this.getLegendPosition();
        this._legends.visible(showLegend).position(legendPosition).transition(!"none".equals(effect), duration).setPreExecute(this.context.getPreExecute()).selector(0, this.context.node.selectAll("g.legend")).palette(0, colorPalette).shape(0, "square").title(0, this.context.getDataSlotLabel("legend.title", dataSet.slot(DATASLOT_COLOR).entry())).titleFill(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fill"))).titleFontSize(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontsize"))).titleFontFamily(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontfamily"))).setDataSlot(0, dataSet.slot(DATASLOT_COLOR).entry());
        this.MAX_CELL_SIZE = Math.max(10.0, this.getCSSSizeToPixelNumber("maxCellSize"));
        this.MIN_CELL_SIZE = Math.max(10.0, Math.min(this.MAX_CELL_SIZE, this.getCSSSizeToPixelNumber("minCellSize")));
        if (this.updateType <= 1) {
            this._independentScale = ScaleManager.makeCoordinateScale((List)originalData, (DataSlotEntry)this.xDataAccessor);
            this._dependentScale = ScaleManager.makeCoordinateScale((List)originalData, (DataSlotEntry)this.yDataAccessor);
            boolean useLeftAxis = "left".equals(this.getStringProperty(Y_AXIS_PROPERTIES));
            boolean useBottomAxis = "bottom".equals(this.getStringProperty(X_AXIS_PROPERTIES));
            this._axes.visible(true).duration(duration).swapX(!useBottomAxis).swapY(!useLeftAxis).scale(0, this._independentScale).scale(2, this._dependentScale).setDataSlot(0, this.xDataAccessor).setDataSlot(2, this.yDataAccessor).useDefaultSelectors().useDefaultX1Properties(false).useDefaultY1Properties(false).setTickFormatter(0, this.xDataAccessor).setTickFormatter(2, this.yDataAccessor);
            this.prepareLayoutComponent();
            this.prepareLayoutSizables(this._layoutComponent, false, true, true, false, this._legends.anyVisible());
            boolean isLegendLeftOrRight = "left".equals(legendPosition) || "right".equals(legendPosition);
            boolean isUniform = ObjectConverter.toBoolean((Object)this.context.getPropertyValue("cell.uniform"));
            this._axes.preventStaggerRotate45(isUniform);
            if (!isUniform && isLegendLeftOrRight) {
                this._legends.preLayout(this._layoutComponent, false);
                this._axes.preLayout(this._layoutComponent, false, 0.1, 0.05, 0, 0.1, 0.05, 0);
            } else {
                this._axes.preLayout(this._layoutComponent, true, 0.1, 0.05, 0, 0.1, 0.05, 0);
                this._legends.preLayout(this._layoutComponent, true);
            }
            this._layoutComponent.layout();
            legendPosition = this._layoutComponent.legendPosition();
            this._legends.position(legendPosition);
            RectStruct elementRect = this._layoutComponent.elementRect();
            int hCount = this._independentScale.scale().domain().size();
            int vCount = this._dependentScale.scale().domain().size();
            double cellWidth = elementRect.width / (double)hCount;
            double cellHeight = elementRect.height / (double)vCount;
            this.minCellDim = Math.min(cellWidth, cellHeight);
            if (ObjectConverter.toBoolean((Object)this.context.getPropertyValue("cell.uniform"))) {
                if (this.minCellDim > this.MAX_CELL_SIZE) {
                    double dxNeeded = this.MAX_CELL_SIZE * (double)hCount;
                    double dyNeeded = this.MAX_CELL_SIZE * (double)vCount;
                    this.cutCenterWidth(elementRect.width - dxNeeded);
                    this.cutCenterHeight(elementRect.height - dyNeeded);
                } else if (this.minCellDim < this.MIN_CELL_SIZE) {
                    double dxNeeded = this.MIN_CELL_SIZE * (double)hCount;
                    double dyNeeded = this.MIN_CELL_SIZE * (double)vCount;
                    this.growCenterWidth(dxNeeded - elementRect.width);
                    this.growCenterHeight(dyNeeded - elementRect.height);
                } else if (cellWidth > cellHeight) {
                    double dxNeeded = this.minCellDim * (double)hCount;
                    this.cutCenterWidth(elementRect.width - dxNeeded);
                } else if (cellHeight > cellWidth) {
                    double dyNeeded = this.minCellDim * (double)vCount;
                    this.cutCenterHeight(elementRect.height - dyNeeded);
                }
            } else {
                double dyNeeded;
                double dxNeeded;
                if (cellWidth > this.MAX_CELL_SIZE) {
                    dxNeeded = this.MAX_CELL_SIZE * (double)hCount;
                    this.cutCenterWidth(elementRect.width - dxNeeded);
                }
                if (cellWidth < this.MIN_CELL_SIZE) {
                    dxNeeded = this.MIN_CELL_SIZE * (double)hCount;
                    this.growCenterWidth(dxNeeded - elementRect.width);
                }
                if (cellHeight > this.MAX_CELL_SIZE) {
                    dyNeeded = this.MAX_CELL_SIZE * (double)vCount;
                    this.cutCenterHeight(elementRect.height - dyNeeded);
                }
                if (cellHeight < this.MIN_CELL_SIZE) {
                    dyNeeded = this.MIN_CELL_SIZE * (double)vCount;
                    this.growCenterHeight(dyNeeded - elementRect.height);
                }
            }
            this._axes.useBoundsFromLayout(this._layoutComponent).setScaleRanges(0.0, 0.0, 1);
            this.zoomXScale = this._independentScale.scale().copy();
            this.zoomYScale = this._dependentScale.scale().copy();
            this.resetZoom();
        }
        RectStruct elementRect = this._layoutComponent.elementRect();
        this._legends.rectangle(this._layoutComponent.legendRect());
        this.setBackgroundProperties(elementRect, duration);
        Object z = null;
        String ops = this.getStringProperty("zoom");
        if (this.updateType <= 2) {
            if (ops.equals("all") || ops.equals("x")) {
                this._independentScale.scale().domain(this.zoomXScale.domain());
            }
            if (ops.equals("all") || ops.equals("y")) {
                this._dependentScale.scale().domain(this.zoomYScale.domain());
            }
            Dim scaleExtent = null;
            if (this.minCellDim < this.MIN_CELL_SIZE) {
                scaleExtent = new Dim(this.MIN_CELL_SIZE / this.minCellDim, Math.max(5.0, 2.0 * this.MIN_CELL_SIZE / this.minCellDim));
            }
            final HeatmapView self = this;
            final Zoom zoom = (Zoom)this.context.actions.action("zoom").get("zoom");
            ComponentConfiguration.configureZoom(this._chart, zoom, this._independentScale, this._dependentScale, null, null, scaleExtent, elementRect, this._zoomP, this._zoomS, ops, new RunFunction<SceneNode>(){

                public Object run(SceneNode context, Object ... args) {
                    self._chart.selectAll("g.elements").call((RunFunction)self._intervalComponent, new Object[0]);
                    self._axes.redraw(true);
                    zoom.on("zoomend.hideLabels", (RunFunction)new RunFunction<SceneNode>(){

                        public Object run(SceneNode context, Object ... args) {
                            if (self._axes.hideAnyPanZoom()) {
                                if (self.zoomendedTimer != null) {
                                    EventQueue.clearTimeout((Object)self.zoomendedTimer);
                                }
                                self.zoomendedTimer = EventQueue.setTimeout((Runnable)new Runnable(){

                                    public void run() {
                                        self.zoomendedTimer = null;
                                        self._axes.redraw(false);
                                    }
                                }, (int)300);
                            }
                            return null;
                        }
                    });
                    return self._chart;
                }
            });
        }
        if (this.minCellDim < this.MIN_CELL_SIZE && z != null && ops.equals("all")) {
            double r = this.MIN_CELL_SIZE / this.minCellDim;
            z.scale(r);
            z.translate(new Point(elementRect.x * (1.0 - r), elementRect.y * (1.0 - r)));
            this._zoomP[0] = elementRect.x * (1.0 - r);
            this._zoomP[1] = elementRect.y * (1.0 - r);
            this._zoomS[0] = r;
            this._zoomS[1] = r;
        }
        ((IntervalComponentImpl)((IntervalComponentImpl)this._intervalComponent.data(this._data.toArray()).key((SingleValueFunction<Object, Object>)HeatmapView.originalDatumAccessor(this.key != null ? this.key.accessor() : null))).independentScale(this._independentScale).dependentScale(this._dependentScale).colorPalette(colorPalette).labelAccessor((SingleValueFunction<Object, Object>)HeatmapView.originalDatumAccessor((SingleValueFunction)this.colorDataAccessor.accessor())).labelFont(FontPropertyParser.parseCSSFont(this.getStringProperty(LABEL_FONTSTYLE))).labelContrast(this.getBooleanProperty("contrast.label.color")).labelShadow(this.getBooleanProperty("label.shadow")).valueAccessor((SingleValueFunction<Object, Object>)HeatmapView.originalDatumAccessor(this.valueAccessor())).setPreExecute(this.context.getPreExecute())).labelFormatter((ValueFunction<Object, String>)this.context.getCustomFormatterForElementLabels(this.colorDataAccessor)).itemLabel(this.getBooleanProperty("itemLabel")).borderWidth(this.context.convertCSSSizeToPixels(this.context.getPropertyValue("cell.borderWidth"))).borderColor(ObjectConverter.asString((Object)this.context.getPropertyValue("cell.borderColor"))).bounds(this._layoutComponent.elementRect());
        this._chart.selectAll("g.elements").transition().duration((Object)duration).call((RunFunction)this._intervalComponent, new Object[0]);
        this._clip.clipRect(elementRect).applyTo(this._chart.select((Object)".content")).run((Selection<?>)this.context.node.select((Object)"defs").transition().duration((Object)duration), new Object[0]);
        this._axes.visible(true).duration(duration).useDefaultSelectors().useDefaultX1Properties(false).useDefaultY1Properties(false).setTickFormatter(0, this.xDataAccessor).setTickFormatter(2, this.yDataAccessor);
        this._axes.draw();
        this._legends.draw();
        this.resetUpdate();
        this._chart.selectAll(".element-shape").classed("bundle-shape", true);
        this._chart.selectAll(".legendShape").classed("bundle-shape", true);
    }

    public CoordinateScale getCoordinateScale(String role) {
        if ("ROLE_X1".equals(role)) {
            return this._independentScale;
        }
        if ("ROLE_Y1".equals(role)) {
            return this._dependentScale;
        }
        return null;
    }

    private SingleValueFunction<Object, Object> valueAccessor() {
        final HeatmapView self = this;
        return new SingleValueFunction<Object, Object>(){

            public Object getValue(Object d) {
                return self.xDataAccessor.getValue(d) + ", " + self.yDataAccessor.getValue(d);
            }
        };
    }

    private void cutCenterWidth(double dx) {
        if (dx <= 0.0) {
            return;
        }
        this._layoutComponent.chartRect().width -= dx;
        this._layoutComponent.elementRect().width -= dx;
        this._layoutComponent.topRect().width -= dx;
        this._layoutComponent.bottomRect().width -= dx;
        this._layoutComponent.rightRect().x -= dx;
        if (this._legends.anyVisible()) {
            String lp = this._layoutComponent.legendPosition();
            if (lp.equals("top") || lp.equals("bottom")) {
                this._layoutComponent.legendRect().width -= dx;
            } else if (lp.equals("right")) {
                this._layoutComponent.legendRect().x -= dx;
            }
        }
    }

    private void cutCenterHeight(double dy) {
        if (dy <= 0.0) {
            return;
        }
        this._layoutComponent.chartRect().height -= dy;
        this._layoutComponent.elementRect().height -= dy;
        this._layoutComponent.leftRect().height -= dy;
        this._layoutComponent.rightRect().height -= dy;
        this._layoutComponent.bottomRect().y -= dy;
        if (this._legends.anyVisible()) {
            String lp = this._layoutComponent.legendPosition();
            if (lp.equals("left") || lp.equals("right")) {
                this._layoutComponent.legendRect().height -= dy;
            } else if (lp.equals("bottom")) {
                this._layoutComponent.legendRect().y -= dy;
            }
        }
    }

    private void growCenterWidth(double dx) {
        if (dx <= 0.0) {
            return;
        }
        this._layoutComponent.chartRect().width += dx;
        this._layoutComponent.elementRect().width += dx;
        this._layoutComponent.topRect().width += dx;
        this._layoutComponent.bottomRect().width += dx;
        this._layoutComponent.rightRect().x += dx;
        if (this._legends.anyVisible()) {
            String lp = this._layoutComponent.legendPosition();
            if (lp.equals("top") || lp.equals("bottom")) {
                this._layoutComponent.legendRect().width += dx;
            } else if (lp.equals("right")) {
                this._layoutComponent.legendRect().x += dx;
            }
        }
    }

    private void growCenterHeight(double dy) {
        if (dy <= 0.0) {
            return;
        }
        this._layoutComponent.chartRect().height += dy;
        this._layoutComponent.elementRect().height += dy;
        this._layoutComponent.leftRect().height += dy;
        this._layoutComponent.rightRect().height += dy;
        this._layoutComponent.bottomRect().y += dy;
        if (this._legends.anyVisible()) {
            String lp = this._layoutComponent.legendPosition();
            if (lp.equals("left") || lp.equals("right")) {
                this._layoutComponent.legendRect().height += dy;
            } else if (lp.equals("bottom")) {
                this._layoutComponent.legendRect().y += dy;
            }
        }
    }

    @Override
    protected String[] getGroupStructure() {
        return new String[]{"defs", "g.vizlibrary vizlibrary-heatmap", "(", "rect.background chart", "g.chart", "(", "g.content", "(", "rect.background elements", "g.elements", "(", "g.element-group", "g.element-label-group", ")", ")", "g.axes", "(", "g.axes-layout", "g.axisTransform top", "g.axisTransform right", "g.axisTransform bottom", "g.axisTransform left", ")", ")", "g.legends", "(", "g.legends-layout", "g.legend", ")", ")"};
    }
}

