/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.lineBundle;

import com.ibm.rave.bundles.components.ComponentConfiguration;
import com.ibm.rave.bundles.components.LineComponentImpl;
import com.ibm.rave.bundles.components.PointComponentImpl;
import com.ibm.rave.bundles.data.LineDataUtilities;
import com.ibm.rave.bundles.data.PointDataUtilities;
import com.ibm.rave.bundles.utilities.FontPropertyParser;
import com.ibm.rave.bundles.views.BundleView;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.behavior.Zoom;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.event.Event;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.EventQueue;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.SelectorEventListener;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.util.Runnable;
import com.ibm.rave.library.action.BundleUtils;
import com.ibm.rave.library.action.internal.ActionImpl;
import com.ibm.rave.library.datamodel.DataSet;
import com.ibm.rave.library.datamodel.DataSlotEntry;
import com.ibm.rave.library.framework.CoordinateScale;
import com.ibm.rave.library.framework.internal.BundleContext;
import com.ibm.rave.library.framework.internal.CoordinateScaleImpl;
import com.ibm.rave.library.framework.internal.ScaleManager;
import com.ibm.rave.library.palette.Palette;
import java.util.List;

public class LineView
extends BundleView {
    @InlineStringConstant
    private static final String DATASET_DATA = "data";
    @InlineStringConstant
    private static final String DATASLOT_X = "x";
    @InlineStringConstant
    private static final String DATASLOT_Y = "y";
    @InlineStringConstant
    private static final String DATASLOT_GROUP = "color";
    @InlineStringConstant
    private static final String DATASLOT_LABEL = "label";
    @InlineStringConstant
    private static final String DATASLOT_KEY = "key";
    @InlineStringConstant
    private static final String LINE_WITH_POINTS_SYMBOL = "lineWithPoints.symbol";
    @InlineStringConstant
    private static final String LINE_WITH_POINTS_DISPLAY = "lineWithPoints.display";
    @InlineStringConstant
    private static final String LINE_INTERPOLATE_PROPERTY = "lineWithPoints.interpolate";
    @InlineStringConstant
    private static final String LINE_MISSING_AS_GAP_PROPERTY = "lineWithPoints.showMissingAsGap";
    private LineComponentImpl _lineComponent = null;
    private PointComponentImpl _pointComponent;
    private CoordinateScaleImpl _dependentScale;
    private CoordinateScaleImpl _independentScale;
    private ArrayEx<LineDataUtilities.LineDatum> _lineData = null;
    private List<PointDataUtilities.PointDatum> _pointData = null;
    private List<PointDataUtilities.PointDatum> _pointNPNData = null;
    private AbstractScale<?, ?> zoomXScale;
    private AbstractScale<?, ?> zoomYScale;
    private Object zoomendedTimer;

    public LineView(BundleContext context) {
        super(context);
    }

    @Override
    protected boolean isAxesManagerRequired() {
        return true;
    }

    @Override
    public void setup() {
        super.setup();
        BundleUtils.setupDefaultActions((BundleContext)this.context, (String)".chart .element-shape", null);
        final ActionImpl highlightAction = this.context.actions.action("highlight");
        final ActionImpl unhighlightAction = this.context.actions.action("unhighlight");
        final LineView self = this;
        highlightAction.setBindFn(new BundleUtils.BindingOperation(){

            public void call() {
                self.context.node.selectAll(".element-line .element-shape").on("mouseenter.default", (SelectorEventListener)new SelectorEventListener<Event>(){

                    public void onEvent(SceneNode context1, Object data, int index, int groupIndex, Event event) {
                        OMap attributes = new OMap();
                        attributes.put((Object)"stroke-width", (Object)"4px");
                        highlightAction.call(new Object[]{Rave.select((SceneNode)context1), attributes});
                    }
                });
                self.context.node.selectAll(".element-point .element-shape").on("mouseenter.default", (SelectorEventListener)new SelectorEventListener<Event>(){

                    public void onEvent(SceneNode context1, Object data, int index, int groupIndex, Event event) {
                        highlightAction.call(new Object[]{Rave.select((SceneNode)context1)});
                    }
                });
            }
        });
        highlightAction.setUnbindFn(new BundleUtils.BindingOperation(){

            public void call() {
                self.context.node.selectAll(".element-shape").on("mouseenter.default", null);
            }
        });
        unhighlightAction.setBindFn(new BundleUtils.BindingOperation(){

            public void call() {
                self.context.node.selectAll(".element-line .element-shape").on("mouseout.default", (SelectorEventListener)new SelectorEventListener<Event>(){

                    public void onEvent(SceneNode context1, Object data, int index, int groupIndex, Event event) {
                        OMap attributes = new OMap();
                        attributes.put((Object)"stroke-width", (Object)"2px");
                        unhighlightAction.call(new Object[]{Rave.select((SceneNode)context1), attributes});
                    }
                });
                self.context.node.selectAll(".element-point .element-shape").on("mouseout.default", (SelectorEventListener)new SelectorEventListener<Event>(){

                    public void onEvent(SceneNode context1, Object data, int index, int groupIndex, Event event) {
                        OMap attributes = new OMap();
                        attributes.put((Object)"stroke-width", (Object)"0px");
                        unhighlightAction.call(new Object[]{Rave.select((SceneNode)context1), attributes});
                    }
                });
            }
        });
        unhighlightAction.setUnbindFn(new BundleUtils.BindingOperation(){

            public void call() {
                self.context.node.selectAll(".element-shape").on("mouseout.default", null);
            }
        });
        ActionImpl deselectAllAction = this.context.actions.action("deselectAll");
        SelectorEventListener<Event> deselectAllEventListener = new SelectorEventListener<Event>(){

            public void onEvent(SceneNode context1, Object data, int index, int groupIndex, Event event) {
                self.context.node.selectAll(".element-shape").style("stroke-width", (Object)0).style("opacity", (Object)1).property("selected", null);
                self.context.node.selectAll(".element-line .element-shape").style("stroke-width", (Object)2);
            }
        };
        deselectAllAction.setBindFn(BundleUtils.bindOrUnbindActionFunctionCreater((BundleContext)this.context, (String)".background", (String[])new String[]{"click.default", "touchstart.default"}, (SelectorEventListener)deselectAllEventListener));
        this._lineComponent = new LineComponentImpl();
        this._lineComponent.pointsAccessor(LineDataUtilities.POINTS_ACCESSOR).groupAccessor(LineDataUtilities.GROUP_ACCESSOR);
        this._pointComponent = new PointComponentImpl();
        this._pointComponent.independentAccessor(PointDataUtilities.X_ACCESSOR).dependentAccessor(PointDataUtilities.Y_ACCESSOR);
    }

    public void draw() {
        if (this.isUpdateNothing()) {
            return;
        }
        this.preDraw("g.vizlibrary-line");
        if (!this.validateDataModel("g.element-group", "g.grid", "g.axis")) {
            return;
        }
        String effect = this.getStringProperty("effect.name");
        int duration = this.getEffectDuration(effect);
        DataSet dataSet = this.dataModel.dataset(DATASET_DATA);
        DataSlotEntry yDataSlotEntry = dataSet.slot(DATASLOT_Y).entry();
        DataSlotEntry colorDataSlotEntry = dataSet.slot(DATASLOT_GROUP).entry();
        if (colorDataSlotEntry == null && yDataSlotEntry != null) {
            dataSet.slot(DATASLOT_GROUP).overrideLabel(yDataSlotEntry.label());
        }
        ArrayEx data = ObjectConverter.listToArray((List)((List)dataSet.data()));
        boolean transpose = this.getBooleanProperty("transpose");
        Palette colorPalette = this.getPalette();
        colorPalette.setData(dataSet, DATASLOT_GROUP);
        colorPalette.setAccessor(LineDataUtilities.GROUP_ACCESSOR);
        String legendPosition = this.getLegendPosition();
        String drawOptions = this.getStringProperty(LINE_WITH_POINTS_DISPLAY);
        this._legends.visible(this.isShowLegend()).position(legendPosition).transition(!"none".equals(effect), duration).setPreExecute(this.context.getPreExecute()).selector(0, this.context.node.selectAll("g.legend")).palette(0, colorPalette).shape(0, !drawOptions.equals("line") ? this.getStringProperty(LINE_WITH_POINTS_SYMBOL) : "compositeViewLegendLineSymbol").title(0, this.context.getDataSlotLabel("legend.title", dataSet.slot(DATASLOT_GROUP).entry())).titleFill(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fill"))).titleFontSize(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontsize"))).titleFontFamily(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontfamily"))).setDataSlot(0, dataSet.slot(DATASLOT_GROUP).entry());
        if (this.updateType == 0) {
            DataSlotEntry xEntry = dataSet.slot(DATASLOT_X).entry();
            this._lineData = LineDataUtilities.buildLines((ArrayEx<Object>)data, (SingleValueFunction<Object, Object>)LineView.accessorOf((DataSlotEntry)xEntry), (SingleValueFunction<Object, Object>)LineView.domainCheckerOf((List)data, (DataSlotEntry)xEntry), (SingleValueFunction<Object, Object>)LineView.accessorOf((DataSlotEntry)dataSet.slot(DATASLOT_Y).entry()), (SingleValueFunction<Object, Object>)LineView.accessorOf((DataSlotEntry)dataSet.slot(DATASLOT_GROUP).entry()));
            this.context.actions.action("deselectAll").call(new Object[]{this.context.node.selectAll(".element-point .element-shape")});
        }
        if (this.updateType <= 1) {
            boolean isLegendLeftOrRight;
            this._independentScale = ScaleManager.makeCoordinateScale((List)data, (DataSlotEntry)dataSet.slot(DATASLOT_X).entry());
            this._dependentScale = ScaleManager.makeCoordinateScale((List)data, (DataSlotEntry)dataSet.slot(DATASLOT_Y).entry());
            Number subDomainDivisionY = yDataSlotEntry.subDomainDivision();
            Double scaleDivisionY = subDomainDivisionY == null ? null : Double.valueOf(ObjectConverter.toDouble((Object)subDomainDivisionY));
            this._axes.visible(true).duration(duration).transpose(transpose).scale(0, this._independentScale).scale(2, this._dependentScale).setDataSlot(0, dataSet.slot(DATASLOT_X).entry()).setDataSlot(2, dataSet.slot(DATASLOT_Y).entry()).scaleTickMagnitude(2, scaleDivisionY).useDefaultSelectors().useDefaultX1Properties(true).useDefaultY1Properties(true).setTickFormatter(0, dataSet.slot(DATASLOT_X).entry()).setTickFormatter(2, dataSet.slot(DATASLOT_Y).entry());
            this.prepareLayoutComponent();
            this.prepareLayoutSizables(this._layoutComponent, false, true, true, false, this._legends.anyVisible());
            legendPosition = this._layoutComponent.legendPosition();
            boolean bl = isLegendLeftOrRight = "left".equals(legendPosition) || "right".equals(legendPosition);
            if (isLegendLeftOrRight) {
                this._legends.preLayout(this._layoutComponent, false);
                this._axes.preLayout(this._layoutComponent, false, 0.1, 0.05, 0, 0.1, 0.05, 0);
            } else {
                this._axes.preLayout(this._layoutComponent, true, 0.1, 0.05, 0, 0.1, 0.05, 0);
                this._legends.preLayout(this._layoutComponent, true);
            }
            this._layoutComponent.layout();
            this._legends.position(legendPosition);
            this._axes.useBoundsFromLayout(this._layoutComponent).setScaleRanges(0.1, 0.0, 0);
            if (this._dependentScale != null) {
                if (this.getBooleanProperty("axis.y.scale.includeZero")) {
                    this._dependentScale.includeZero();
                }
                this._dependentScale.expandZeroExtent(false);
                if (this.getBooleanProperty("axis.y.scale.nice")) {
                    this._dependentScale.nice((Number)scaleDivisionY);
                }
                double pixels = 2.0 + Math.sqrt(this.getCSSSizeToPixelNumber("lineWithPoints.size"));
                this._dependentScale.expandPixels(pixels, true);
                if (transpose) {
                    this.zoomXScale = this._dependentScale.scale().copy();
                } else {
                    this.zoomYScale = this._dependentScale.scale().copy();
                }
            }
            if (this._independentScale != null) {
                this._independentScale.expandZeroExtent(false);
                if (this.getBooleanProperty("axis.x.scale.nice")) {
                    this._independentScale.nice();
                }
                if (this.getBooleanProperty("axis.x.scale.includeZero")) {
                    this._independentScale.includeZero();
                }
                if (transpose) {
                    this.zoomYScale = this._independentScale.scale().copy();
                } else {
                    this.zoomXScale = this._independentScale.scale().copy();
                }
            }
            this.resetZoom();
        }
        if (this.updateType == 0 && this._independentScale != null && this.getBooleanProperty("sortX")) {
            LineDataUtilities.sortLines(this._lineData, this._independentScale);
        }
        if (this.updateType == 0) {
            this._pointData = LineDataUtilities.getLineWithPoints(this._lineData);
            this._pointNPNData = LineDataUtilities.getNPNPoints(this._lineData);
        }
        RectStruct chartRect = this._layoutComponent.elementRect();
        this._clip.clipRect(chartRect).applyTo(this._chart.select((Object)".content")).run((Selection<?>)this.context.node.select((Object)"defs").transition().duration((Object)duration), new Object[0]);
        this._chart.select((Object)"rect.background.elements").attr(DATASLOT_X, (Object)chartRect.x).attr(DATASLOT_Y, (Object)chartRect.y).attr("width", (Object)chartRect.width).attr("height", (Object)chartRect.height);
        this._legends.rectangle(this._layoutComponent.legendRect());
        CoordinateScaleImpl xScale = transpose ? this._dependentScale : this._independentScale;
        CoordinateScaleImpl yScale = transpose ? this._independentScale : this._dependentScale;
        this.setBackgroundProperties(chartRect, duration);
        boolean showMissingAsGap = this.getBooleanProperty(LINE_MISSING_AS_GAP_PROPERTY);
        ((LineComponentImpl)this._lineComponent.data(!drawOptions.equals("points") ? this._lineData.toArray() : null).independentScale(this._independentScale).dependentScale(this._dependentScale).transpose(transpose).colorPalette(colorPalette).effect(effect).showMissingAsGap(showMissingAsGap).setPreExecute(this.context.getPreExecute())).interpolate(this.getStringProperty(LINE_INTERPOLATE_PROPERTY));
        this._chart.selectAll("g.element-line").transition().duration((Object)duration).call((RunFunction)this._lineComponent, new Object[0]);
        if (drawOptions.equals("line_points") || drawOptions.equals("points") || this.isShowDataLabels()) {
            this._pointComponent.data(this._pointData.toArray());
        } else {
            this._pointComponent.data(showMissingAsGap ? this._pointNPNData.toArray() : null);
        }
        Palette pointsColorPalette = this.getPalette();
        pointsColorPalette.setData(dataSet, DATASLOT_GROUP);
        pointsColorPalette.setAccessor(LineView.originalDatumAccessor((SingleValueFunction)LineView.accessorOf((DataSlotEntry)dataSet.slot(DATASLOT_GROUP).entry())));
        this.configureDataLabels(dataSet);
        ((PointComponentImpl)((PointComponentImpl)this._pointComponent.bounds(chartRect).independentScale(this._independentScale).dependentScale(this._dependentScale).transpose(transpose).colorPalette(pointsColorPalette).labelFont(this.getBackgroundConstrastLabelStyle()).labelContrast(this.getBooleanProperty("contrast.label.color")).labelShadow(this.getBooleanProperty("label.shadow")).effect(effect).key((SingleValueFunction<Object, Object>)LineView.originalDatumAccessor((SingleValueFunction)LineView.accessorOf((DataSlotEntry)dataSet.slot(DATASLOT_KEY).entry())))).setPreExecute(this.context.getPreExecute())).defaultSize(this.getCSSSizeToPixelNumber("lineWithPoints.size")).symbol(drawOptions.equals("line_points") || drawOptions.equals("points") ? this.getStringProperty(LINE_WITH_POINTS_SYMBOL) : null);
        this._chart.selectAll("g.element-point").transition().duration((Object)duration).call((RunFunction)this._pointComponent, new Object[0]);
        this._axes.visible(true).duration(duration).useDefaultSelectors().useDefaultX1Properties(true).useDefaultY1Properties(true).setTickFormatter(0, dataSet.slot(DATASLOT_X).entry()).setTickFormatter(2, dataSet.slot(DATASLOT_Y).entry());
        this._axes.draw();
        this._legends.draw();
        if (this.updateType <= 2) {
            String ops = this.getStringProperty("zoom");
            if (xScale != null && (ops.equals("all") || ops.equals(DATASLOT_X))) {
                xScale.scale().domain(this.zoomXScale.domain());
            }
            if (yScale != null && (ops.equals("all") || ops.equals(DATASLOT_Y))) {
                yScale.scale().domain(this.zoomYScale.domain());
            }
            final LineView self = this;
            Zoom zoom = (Zoom)this.context.actions.action("zoom").get("zoom");
            ComponentConfiguration.configureZoom(this._chart, zoom, xScale, yScale, null, null, null, chartRect, this._zoomP, this._zoomS, this.getStringProperty("zoom"), new RunFunction<SceneNode>(){

                public Object run(SceneNode context1, Object ... args) {
                    self._chart.selectAll("g.element-line").call((RunFunction)self._lineComponent, new Object[0]);
                    if (self._pointComponent != null) {
                        self._chart.selectAll("g.element-point").call((RunFunction)self._pointComponent, new Object[0]);
                    }
                    self._axes.redraw(true);
                    return self._chart;
                }
            });
            zoom.on("zoomend.hideLabels", (RunFunction)new RunFunction<SceneNode>(){

                public Object run(SceneNode context, Object ... args) {
                    if (self._axes.hideAnyPanZoom()) {
                        if (self.zoomendedTimer != null) {
                            EventQueue.clearTimeout((Object)self.zoomendedTimer);
                        }
                        self.zoomendedTimer = EventQueue.setTimeout((Runnable)new Runnable(){

                            public void run() {
                                self.zoomendedTimer = null;
                                self._axes.redraw(false);
                            }
                        }, (int)300);
                    }
                    return null;
                }
            });
        }
        this.resetUpdate();
        this._chart.selectAll(".element-shape").classed("bundle-shape", true);
        this._chart.selectAll(".legendShape").classed("bundle-shape", true);
    }

    public CoordinateScale getCoordinateScale(String role) {
        if ("ROLE_X1".equals(role)) {
            return this._independentScale;
        }
        if ("ROLE_Y1".equals(role)) {
            return this._dependentScale;
        }
        return null;
    }

    protected int requireUpdate(String property) {
        if (property.equals("lineWithPoints.nullpointnull") && this.getStringProperty(LINE_WITH_POINTS_DISPLAY).equals("line_points")) {
            return 4;
        }
        return super.requireUpdate(property);
    }

    protected void configureDataLabels(DataSet dataSet) {
        if (!this.isShowDataLabels()) {
            this._pointComponent.itemLabel(false);
            this._pointComponent.itemLabelPosition((ValueFunction)null);
            this._pointComponent.labelFont(null);
            this._pointComponent.labelAccessor(null);
            this._pointComponent.labelFormatter(null);
            return;
        }
        final LineView self = this;
        ValueFunction<Object, Integer> dataLabelPosition = new ValueFunction<Object, Integer>(){

            public Integer getValue(Object context, Object data, int index, int groupIndex) {
                PointDataUtilities.PointDatum nextData;
                PointDataUtilities.PointDatum currentData = (PointDataUtilities.PointDatum)data;
                PointDataUtilities.PointDatum prevData = index == 0 ? null : (PointDataUtilities.PointDatum)self._pointData.get(index - 1);
                PointDataUtilities.PointDatum pointDatum = nextData = index == self._pointData.size() - 1 ? null : (PointDataUtilities.PointDatum)self._pointData.get(index + 1);
                if (prevData == null || nextData == null) {
                    return 0;
                }
                double angleWithPreviousPoint = Math.atan2(self._dependentScale.center(prevData._y).doubleValue() - self._dependentScale.center(currentData._y).doubleValue(), self._independentScale.center(prevData._x).doubleValue() - self._independentScale.center(currentData._x).doubleValue());
                double angleWithNextPoint = Math.atan2(self._dependentScale.center(nextData._y).doubleValue() - self._dependentScale.center(currentData._y).doubleValue(), self._independentScale.center(nextData._x).doubleValue() - self._independentScale.center(currentData._x).doubleValue());
                if (angleWithNextPoint <= 0.0 && angleWithPreviousPoint <= 0.0) {
                    return 2;
                }
                if (angleWithNextPoint >= 0.0 && angleWithPreviousPoint >= 0.0 || 180.0 - Math.abs(angleWithPreviousPoint * 57.29577951308232) < 30.0 && Math.abs(angleWithNextPoint * 57.29577951308232) < 30.0) {
                    return 0;
                }
                if (180.0 - Math.abs(angleWithPreviousPoint * 57.29577951308232) > 30.0) {
                    return 3;
                }
                return 4;
            }
        };
        SingleValueFunction<Object, Object> labelAccessor = this.getlDataLabelAccessor(dataSet, DATASLOT_LABEL, false);
        DataSlotEntry labelEntry = this.getEntryForDataLabelFormatter(dataSet, DATASLOT_LABEL, DATASLOT_Y);
        this._pointComponent.itemLabel(true);
        this._pointComponent.labelFont(FontPropertyParser.parseCSSFont(this.getStringProperty("labelstyle.font")));
        this._pointComponent.labelFormatter((ValueFunction<Object, String>)this.context.getCustomFormatterForElementLabels(labelEntry));
        this._pointComponent.labelAccessor(labelAccessor);
        this._pointComponent.itemLabelPosition((ValueFunction)dataLabelPosition);
    }

    @Override
    protected String[] getGroupStructure() {
        return new String[]{"defs", "g.vizlibrary vizlibrary-line", "(", "rect.background chart", "g.chart", "(", "rect.background elements", "g.gridlines", "(", "g.grid left", "g.grid bottom", ")", "g.axes", "(", "g.axes-layout", "g.axisTransform left", "g.axisTransform bottom", ")", "g.content", "(", "g.elements", "(", "g.element-group element-line", "g.element-point", "(", "g.element-group", "g.element-label-group", ")", ")", ")", "g.axis-callout", ")", "g.legends", "(", "g.legends-layout", "g.legend", ")", ")"};
    }
}

