/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.mapBundle;

import com.ibm.json.java.JSONObject;
import com.ibm.rave.bundles.components.MapComponentImpl;
import com.ibm.rave.bundles.views.BundleView;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.codegenerator.annotations.SwiftWeak;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.behavior.Drag;
import com.ibm.rave.core.behavior.Zoom;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.event.Event;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.Dim;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.SelectorGroup;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.library.action.ActionOperation;
import com.ibm.rave.library.action.BundleUtils;
import com.ibm.rave.library.action.internal.ActionImpl;
import com.ibm.rave.library.datamodel.DataSet;
import com.ibm.rave.library.datamodel.DataSlotEntry;
import com.ibm.rave.library.framework.internal.BundleContext;
import com.ibm.rave.library.framework.internal.ScaleManager;
import com.ibm.rave.library.palette.Palette;
import java.util.List;

public class MapView
extends BundleView {
    private MapComponentImpl _mapComponent;
    private static AbstractScale<?, ?> bubbleScale = null;
    private static final ValueFunction<Object, Object> SWATCH_SIZE_FUNC = new ValueFunction<Object, Object>(){

        public Object getValue(Object context, Object _data, int index, int groupIndex) {
            return Math.PI * Math.pow(ObjectConverter.toDouble((Object)bubbleScale.getValue(null, _data, index, groupIndex)), 2.0);
        }
    };
    private double scale;
    private final int transitionDur = 0;
    private Drag _drag;
    private Zoom _zoom;
    private RectStruct chartRect;
    private final double[] currentZoomScale = new double[]{1.0};
    @InlineStringConstant
    private static final String LEGEND_MAPCOLOR_DISPLAY = "legend.map.display";
    @InlineStringConstant
    private static final String LEGEND_MAPCOLOR_TITLE = "legend.map.title";
    @InlineStringConstant
    private static final String LEGEND_MAPCOLOR_TITLESTYLE_FILL = "legend.map.titlestyle.fill";
    @InlineStringConstant
    private static final String LEGEND_MAPCOLOR_TITLESTYLE_FONTSIZE = "legend.map.titlestyle.fontsize";
    @InlineStringConstant
    private static final String LEGEND_MAPCOLOR_TITLESTYLE_FONTFAMILY = "legend.map.titlestyle.fontfamily";
    @InlineStringConstant
    private static final String LEGEND_BUBBLECOLOR_DISPLAY = "legend.bubble.display";
    @InlineStringConstant
    private static final String LEGEND_BUBBLECOLOR_TITLE = "legend.bubble.title";
    @InlineStringConstant
    private static final String LEGEND_BUBBLECOLOR_TITLESTYLE_FILL = "legend.bubble.titlestyle.fill";
    @InlineStringConstant
    private static final String LEGEND_BUBBLECOLOR_TITLESTYLE_FONTSIZE = "legend.bubble.titlestyle.fontsize";
    @InlineStringConstant
    private static final String LEGEND_BUBBLECOLOR_TITLESTYLE_FONTFAMILY = "legend.bubble.titlestyle.fontfamily";
    @InlineStringConstant
    private static final String LEGEND_BUBBLESIZE_DISPLAY = "legend.size.display";
    @InlineStringConstant
    private static final String LEGEND_BUBBLESIZE_TITLE = "legend.size.title";
    @InlineStringConstant
    private static final String LEGEND_BUBBLESIZE_TITLESTYLE_FILL = "legend.size.titlestyle.fill";
    @InlineStringConstant
    private static final String LEGEND_BUBBLESIZE_TITLESTYLE_FONTSIZE = "legend.size.titlestyle.fontsize";
    @InlineStringConstant
    private static final String LEGEND_BUBBLESIZE_TITLESTYLE_FONTFAMILY = "legend.size.titlestyle.fontfamily";
    @InlineStringConstant
    private static final String REGION_ANIMATION = "regionAnimation";
    @InlineStringConstant
    private static final String BUBBLE_ANIMATION = "bubbleAnimation";
    @InlineStringConstant
    private static final String LEGEND_ANIMATION = "legendAnimation";

    MapView(BundleContext context) {
        super(context);
    }

    @Override
    public void setup() {
        super.setup();
        this._mapComponent = new MapComponentImpl();
        this.setupHighlighting();
        this.setupPanZoom();
    }

    @Override
    protected int getLegendCount() {
        return 3;
    }

    @Override
    protected boolean isZoomSupported() {
        return false;
    }

    public void draw() {
        if (this.isUpdateNothing()) {
            return;
        }
        this.preDraw("g.vizlibrary-map");
        if (!this.validateDataModel(new String[0])) {
            return;
        }
        this.setBorder("border.width", "border.color");
        if (this.updateType == 0) {
            this.context.actions.action("deselectAll").call(new Object[]{this.context.node.selectAll(".chart .element-shape-path")});
        }
        this.context.node.selectAll(".mapzoom").attr("transform", null);
        if (this.context.getPropertyValue("scale") != null && !this.getStringProperty("scale").isEmpty()) {
            this.scale = ObjectConverter.toDouble((Object)this.context.getPropertyValue("scale"));
            this._mapComponent.baseScale(this.scale);
        } else {
            this.scale = Double.NaN;
        }
        this.renderRegionsAndBubbles();
        this.resetUpdate();
    }

    private void renderRegionsAndBubbles() {
        DataSet ds;
        JSONObject geoJsonObject = (JSONObject)this.context.getPropertyValue("geoJSONObject");
        if (geoJsonObject == null) {
            // empty if block
        }
        if ((ds = this.dataModel.dataset("data")).data() == null) {
            ds.data((Object)new ArrayEx());
        }
        double bubbleMinSize = Math.abs(this.getCSSSizeToPixelNumber("minBubbleSize"));
        double bubbleMaxSize = Math.abs(this.getCSSSizeToPixelNumber("maxBubbleSize"));
        double defaultBubbleSize = Math.abs(this.getCSSSizeToPixelNumber("bubbleSize"));
        boolean useMapColorLegend = this.getBooleanProperty(LEGEND_MAPCOLOR_DISPLAY);
        boolean useBubbleColorLegend = this.getBooleanProperty(LEGEND_BUBBLECOLOR_DISPLAY);
        boolean useBubbleSizeLegend = this.getBooleanProperty(LEGEND_BUBBLESIZE_DISPLAY);
        DataSlotEntry bubbleSizeAccessor = ds.slot("bubbleSize").entry();
        if (bubbleSizeAccessor != null) {
            List domain = ScaleManager.numericDomain((List)((List)ds.data()), (DataSlotEntry)bubbleSizeAccessor);
            if (domain == null) {
                useBubbleSizeLegend = false;
                domain = new ArrayEx(new Object[]{0.0, 1.0});
            }
            bubbleScale = Rave.scale.linear().domain(domain).range((List)new ArrayEx(new Object[]{bubbleMinSize, bubbleMaxSize}));
        } else {
            useBubbleSizeLegend = false;
            bubbleScale = null;
        }
        Palette bubblePalette = null;
        DataSlotEntry bubbleColorAccessor = ds.slot("bubbleColor").entry();
        if (bubbleColorAccessor != null) {
            bubblePalette = this.getDynamicPalette("color.pointPalette", "color.pointDynamicPalette.min", "color.pointDynamicPalette.mid", "color.pointDynamicPalette.max");
            bubblePalette.setData(ds, "bubbleColor");
            bubblePalette.setAccessor((SingleValueFunction)bubbleColorAccessor);
            bubblePalette.setNullColor(this.getStringProperty("color.null"));
        } else {
            useBubbleColorLegend = false;
        }
        Palette regionPalette = null;
        DataSlotEntry regionColorAccessor = ds.slot("featureColor").entry();
        if (regionColorAccessor != null) {
            regionPalette = this.getDynamicPalette("color.featurePalette", "color.featureDynamicPalette.min", "color.featureDynamicPalette.mid", "color.featureDynamicPalette.max");
            regionPalette.setData(ds, "featureColor");
            regionPalette.setAccessor((SingleValueFunction)regionColorAccessor);
            regionPalette.setNullColor(this.getStringProperty("color.null"));
        } else {
            useMapColorLegend = false;
        }
        int duration = ObjectConverter.toInt((Object)this.context.getPropertyValue("legendAnimationDuration"));
        String legendPosition = this.getLegendPosition();
        this._legends.visible(useMapColorLegend || useBubbleColorLegend || useBubbleSizeLegend).position(legendPosition).transition(!"none".equals(this.context.getPropertyValue(LEGEND_ANIMATION)), duration).setPreExecute(this.context.getPreExecute()).visible(0, useMapColorLegend).selector(0, this.context.node.selectAll("g.legend.feature")).palette(0, regionPalette).shape(0, "circle").title(0, this.context.getDataSlotLabel(LEGEND_MAPCOLOR_TITLE, regionColorAccessor)).titleFill(0, ObjectConverter.asString((Object)this.context.getPropertyValue(LEGEND_MAPCOLOR_TITLESTYLE_FILL))).titleFontSize(0, ObjectConverter.asString((Object)this.context.getPropertyValue(LEGEND_MAPCOLOR_TITLESTYLE_FONTSIZE))).titleFontFamily(0, ObjectConverter.asString((Object)this.context.getPropertyValue(LEGEND_MAPCOLOR_TITLESTYLE_FONTFAMILY))).setDataSlot(0, regionColorAccessor).visible(1, useBubbleColorLegend).selector(1, this.context.node.selectAll("g.legend.point")).palette(1, bubblePalette).shape(1, "circle").title(1, this.context.getDataSlotLabel(LEGEND_BUBBLECOLOR_TITLE, bubbleColorAccessor)).titleFill(1, ObjectConverter.asString((Object)this.context.getPropertyValue(LEGEND_BUBBLECOLOR_TITLESTYLE_FILL))).titleFontSize(1, ObjectConverter.asString((Object)this.context.getPropertyValue(LEGEND_BUBBLECOLOR_TITLESTYLE_FONTSIZE))).titleFontFamily(1, ObjectConverter.asString((Object)this.context.getPropertyValue(LEGEND_BUBBLECOLOR_TITLESTYLE_FONTFAMILY))).setDataSlot(1, bubbleColorAccessor).visible(2, useBubbleSizeLegend).selector(2, this.context.node.selectAll("g.legend.size")).scale(2, bubbleScale).swatchSize(2, bubbleScale == null ? null : SWATCH_SIZE_FUNC).shape(2, "circle").title(2, this.context.getDataSlotLabel(LEGEND_BUBBLESIZE_TITLE, bubbleSizeAccessor)).titleFill(2, ObjectConverter.asString((Object)this.context.getPropertyValue(LEGEND_BUBBLESIZE_TITLESTYLE_FILL))).titleFontSize(2, ObjectConverter.asString((Object)this.context.getPropertyValue(LEGEND_BUBBLESIZE_TITLESTYLE_FONTSIZE))).titleFontFamily(2, ObjectConverter.asString((Object)this.context.getPropertyValue(LEGEND_BUBBLESIZE_TITLESTYLE_FONTFAMILY))).setDataSlot(2, bubbleSizeAccessor);
        if (this.updateType <= 1) {
            this.prepareLayoutComponent();
            this.prepareLayoutSizables(this._layoutComponent, false, false, false, false, this._legends.anyVisible());
            this._legends.preLayout(this._layoutComponent);
            this._layoutComponent.layout();
            legendPosition = this._layoutComponent.legendPosition();
            this.chartRect = this._layoutComponent.elementRect();
            RectStruct legendRect = this._layoutComponent.legendRect();
            this._legends.position(legendPosition).rectangle(legendRect);
            this._clip.clipRect(this.chartRect).applyTo(this.context.node.select((Object)".content")).run((Selection<?>)this.context.node.select((Object)"defs").transition().duration((Object)duration), new Object[0]);
            this._legends.rectangle(legendRect);
        }
        this._mapComponent.geoJSONObject(geoJsonObject).borderWidth(this.context.convertCSSSizeToPixels(this.context.getPropertyValue("border.width"))).borderColor(ObjectConverter.asString((Object)this.context.getPropertyValue("border.color"))).bubbleBorderWidth(this.context.convertCSSSizeToPixels(this.context.getPropertyValue("bubbleBorder.width"))).bubbleBorderColor(ObjectConverter.asString((Object)this.context.getPropertyValue("bubbleBorder.color"))).geoJSONfeatureIdLookup(this.getStringProperty("idLookup")).regionsAndBubblesData(((List)ds.data()).toArray()).featureId((SingleValueFunction<Object, Object>)ds.slot("featureId").entry()).bubbleColor((SingleValueFunction<Object, Object>)bubbleColorAccessor).bubbleSize((SingleValueFunction<Object, Object>)bubbleSizeAccessor).featureLbl((SingleValueFunction<Object, Object>)ds.slot("featureLabel").entry()).labelFormatter((ValueFunction<Object, String>)this.context.getCustomFormatterForElementLabels(ds.slot("featureLabel").entry())).bubblePalette(bubblePalette).regionPalette(regionPalette).nullColor(this.getStringProperty("color.null")).bubbleScale(bubbleScale).defaultBubbleSize(defaultBubbleSize).bounds(this.chartRect).setZoomExtent(ObjectConverter.toDouble((Object)this.context.getPropertyValue("minZoom")) / 100.0, ObjectConverter.toDouble((Object)this.context.getPropertyValue("maxZoom")) / 100.0).featureLabel(this.getBooleanProperty("showLabels")).dropLabels(this.getBooleanProperty("dropLabels")).projectionType(this.getStringProperty("mapProjection")).rotation(this.getDoubleProperty("mapRotationLongitude"), this.getDoubleProperty("mapRotationLatitude")).regionAnimationDuration(ObjectConverter.toDouble((Object)this.context.getPropertyValue("regionAnimationDuration"))).regionAnimation(!"none".equals(this.context.getPropertyValue(REGION_ANIMATION))).bubbleAnimationDuration(ObjectConverter.toDouble((Object)this.context.getPropertyValue("bubbleAnimationDuration"))).bubbleAnimation(!"none".equals(this.context.getPropertyValue(BUBBLE_ANIMATION))).flashDuration(ObjectConverter.toDouble((Object)this.context.getPropertyValue("flashDuration"))).flash(this.getBooleanProperty("flash"));
        this.setBackgroundProperties(this.chartRect, duration);
        this._legends.draw();
        this.context.node.selectAll("g.element-group").transition().duration((Object)0).call((RunFunction)this._mapComponent, new Object[0]);
        this.bindPanZoom();
    }

    protected int requireUpdate(String property) {
        if ((property.equals("pointLabelFont") || property.equals("pointLabelColor") || property.equals("pointLabelSize")) && !this.getBooleanProperty("showLabels")) {
            return 4;
        }
        if ((property.equals("featureLabelFont") || property.equals("featureLabelColor") || property.equals("featureLabelSize")) && !this.getBooleanProperty("showLabels")) {
            return 4;
        }
        if ((property.equals("graticuleColor") || property.equals("graticuleStrokeThickness")) && !this.getBooleanProperty("displayGraticule")) {
            return 4;
        }
        return super.requireUpdate(property);
    }

    private void setupHighlighting() {
        OMap originalStyle = new OMap();
        originalStyle.put((Object)"stroke-width", null);
        originalStyle.put((Object)"stroke", null);
        BundleUtils.setupDefaultActions((BundleContext)this.context, (String)".chart .element-shape-path", (OMap)originalStyle);
        ActionImpl action = this.context.actions.action("highlight");
        action.setOperation((ActionOperation)new MapHighlightOperation(action.getOperation()));
    }

    private void setupPanZoom() {
        final MapView self = this;
        this._drag = Rave.behavior.drag().on("drag.mapview", (RunFunction)new RunFunction<SceneNode>(){

            public Object run(SceneNode node, Object ... args) {
                Drag.EventObject d = (Drag.EventObject)Rave.event.get();
                self._mapComponent.panMap(d.dx, d.dy);
                self.context.node.selectAll("g.element-group").call((RunFunction)self._mapComponent, new Object[0]);
                return null;
            }
        });
        this._zoom = Rave.behavior.zoom().on("zoom.mapview", (RunFunction)new RunFunction<SceneNode>(){

            public Object run(SceneNode node, Object ... args) {
                Zoom.EventObject d = (Zoom.EventObject)Rave.event.get();
                if (self.currentZoomScale[0] != d.scale) {
                    if (d.sourceEvent != null) {
                        ((Event)d.sourceEvent).stopImmediatePropagation();
                    }
                    ((MapView)self).currentZoomScale[0] = d.scale;
                    self._mapComponent.zoomMap(d.scale);
                    self.context.node.selectAll("g.element-group").call((RunFunction)self._mapComponent, new Object[0]);
                }
                return null;
            }
        });
    }

    private void bindPanZoom() {
        double minScale = this._mapComponent.scaleProjection();
        this._zoom.scale(this._mapComponent.scaleProjection());
        this._zoom.scaleExtent(new Dim(minScale, minScale * 15.0));
        this.context.node.selectAll("rect.background").call((RunFunction)this._drag, new Object[0]).call((RunFunction)this._zoom, new Object[0]);
        this.context.node.selectAll("g.mapzoom").call((RunFunction)this._drag, new Object[0]).call((RunFunction)this._zoom, new Object[0]);
    }

    @Override
    protected String[] getGroupStructure() {
        return new String[]{"defs", "g.vizlibrary vizlibrary-map", "(", "rect.background chart", "g.chart", "(", "g.content", "(", "rect.background elements", "g.gridlines", "(", "g.grid left", "g.grid bottom", ")", "g.mapzoom", "(", "g.elements", "(", "g.element-group", ")", ")", ")", ")", "g.legends", "(", "g.legends-layout", "g.legend feature", "g.legend point", "g.legend size", ")", ")"};
    }

    private static class MapHighlightOperation
    extends ActionOperation {
        @SwiftWeak(value=false)
        private ActionOperation _defOp;

        public MapHighlightOperation(ActionOperation defOp) {
            this._defOp = defOp;
        }

        private void adjustNodesZOrder(Selector selected) {
            SceneNode node = selected.node();
            SceneNode parentG = node.getParentNode();
            SceneNode grandParentG = parentG.getParentNode();
            List childList = grandParentG.getChildNodes();
            SceneNode[] children = new SceneNode[childList.size()];
            for (int i = 0; i < childList.size(); ++i) {
                children[i] = (SceneNode)childList.get(i);
            }
            Selector regions = Rave.select((SceneNode)grandParentG).selectAll("g.region");
            SceneNode firstBubbleNode = regions.size() > 0 ? (SceneNode)((SelectorGroup)regions.get(0)).get(0) : null;
            boolean move = false;
            for (SceneNode child : children) {
                if (child == parentG) {
                    move = true;
                    continue;
                }
                if (child == firstBubbleNode) {
                    move = false;
                    continue;
                }
                if (!move) continue;
                grandParentG.removeChild(child);
                grandParentG.insertBefore(child, parentG);
            }
        }

        public void call(Object ... args) {
            this.adjustNodesZOrder((Selector)args[0]);
            this._defOp.call(args);
        }
    }
}

