/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.nativeImpl;

import com.ibm.rave.bundles.RaveBundle;
import com.ibm.rave.bundles.areaBundle.AreaBundle;
import com.ibm.rave.bundles.boxplotBundle.BoxplotBundle;
import com.ibm.rave.bundles.bubbleBundle.BubbleBundle;
import com.ibm.rave.bundles.bulletBundle.BulletBundle;
import com.ibm.rave.bundles.categoricalplotBundle.CategoricalplotBundle;
import com.ibm.rave.bundles.chordBundle.ChordBundle;
import com.ibm.rave.bundles.columnBundle.ColumnBundle;
import com.ibm.rave.bundles.compositeBundle.CompositeBundle;
import com.ibm.rave.bundles.dialBundle.DialBundle;
import com.ibm.rave.bundles.heatmapBundle.HeatmapBundle;
import com.ibm.rave.bundles.lineBundle.LineBundle;
import com.ibm.rave.bundles.mapBundle.MapBundle;
import com.ibm.rave.bundles.networkBundle.NetworkBundle;
import com.ibm.rave.bundles.pieBundle.PieBundle;
import com.ibm.rave.bundles.radarBundle.RadarBundle;
import com.ibm.rave.bundles.tiledmapBundle.TiledmapBundle;
import com.ibm.rave.bundles.tiledmapV2Bundle.TiledmapV2Bundle;
import com.ibm.rave.bundles.tornadoBundle.TornadoBundle;
import com.ibm.rave.bundles.treemapBundle.TreemapBundle;
import com.ibm.rave.bundles.waterfallBundle.WaterfallBundle;
import com.ibm.rave.bundles.wordCloudBundle.WordCloudBundle;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.library.Library;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;

public class BundleLookup {
    private static final HashMap<String, String> ClassLookup = BundleLookup.buildClassLookup();
    private static final HashMap<String, BundleID> Lookup = BundleLookup.buildLookup();

    private static HashMap<String, String> buildClassLookup() {
        HashMap<String, String> lookup = new HashMap<String, String>();
        return lookup;
    }

    private static HashMap<String, BundleID> buildLookup() {
        HashMap<String, BundleID> lookup = new HashMap<String, BundleID>();
        lookup.put("rave-library-area", BundleID.AREA_BUNDLE);
        lookup.put("rave-library-boxplot", BundleID.BOXPLOT_BUNDLE);
        lookup.put("rave-library-bubble", BundleID.BUBBLE_BUNDLE);
        lookup.put("rave-library-bullet", BundleID.BULLET_BUNDLE);
        lookup.put("rave-library-chord", BundleID.CHORD_BUNDLE);
        lookup.put("rave-library-column", BundleID.COLUMN_BUNDLE);
        lookup.put("rave-library-composite", BundleID.COMPOSITE_BUNDLE);
        lookup.put("rave-library-dial", BundleID.DIAL_BUNDLE);
        lookup.put("rave-library-heatmap", BundleID.HEATMAP_BUNDLE);
        lookup.put("rave-library-line", BundleID.LINE_BUNDLE);
        lookup.put("rave-library-map", BundleID.MAP_BUNDLE);
        lookup.put("rave-library-network", BundleID.NETWORK_BUNDLE);
        lookup.put("rave-library-pie", BundleID.PIE_BUNDLE);
        lookup.put("rave-library-radar", BundleID.RADAR_BUNDLE);
        lookup.put("rave-library-treemap", BundleID.TREEMAP_BUNDLE);
        lookup.put("rave-library-tornado", BundleID.TORNADO_BUNDLE);
        lookup.put("rave-library-waterfall", BundleID.WATERFALL_BUNDLE);
        lookup.put("rave-library-wordcloud", BundleID.WORDCLOUD_BUNDLE);
        lookup.put("rave-library-tiledmap", BundleID.TILEDMAP_BUNDLE);
        lookup.put("rave-library-tiledmapV2", BundleID.TILEDMAPV2_BUNDLE);
        lookup.put("rave-library-categoricalplot", BundleID.CATEGORICALPLOT_BUNDLE);
        return lookup;
    }

    public static RaveBundle getBundle(String bundleId) {
        BundleID id = Lookup.get(bundleId);
        if (id == null) {
            id = BundleID.CUSTOMER_BUNDLE;
        }
        switch (id) {
            case AREA_BUNDLE: {
                return (RaveBundle)((Object)Library.bundle.extension(AreaBundle.init()));
            }
            case BOXPLOT_BUNDLE: {
                return (RaveBundle)((Object)Library.bundle.extension(BoxplotBundle.init()));
            }
            case BUBBLE_BUNDLE: {
                return (RaveBundle)((Object)Library.bundle.extension(BubbleBundle.init()));
            }
            case BULLET_BUNDLE: {
                return (RaveBundle)((Object)Library.bundle.extension(BulletBundle.init()));
            }
            case CHORD_BUNDLE: {
                return (RaveBundle)((Object)Library.bundle.extension(ChordBundle.init()));
            }
            case COLUMN_BUNDLE: {
                return (RaveBundle)((Object)Library.bundle.extension(ColumnBundle.init()));
            }
            case COMPOSITE_BUNDLE: {
                return (RaveBundle)((Object)Library.bundle.extension(CompositeBundle.init()));
            }
            case DIAL_BUNDLE: {
                return (RaveBundle)((Object)Library.bundle.extension(DialBundle.init()));
            }
            case HEATMAP_BUNDLE: {
                return (RaveBundle)((Object)Library.bundle.extension(HeatmapBundle.init()));
            }
            case LINE_BUNDLE: {
                return (RaveBundle)((Object)Library.bundle.extension(LineBundle.init()));
            }
            case MAP_BUNDLE: {
                return (RaveBundle)((Object)Library.bundle.extension(MapBundle.init()));
            }
            case NETWORK_BUNDLE: {
                return (RaveBundle)((Object)Library.bundle.extension(NetworkBundle.init()));
            }
            case PIE_BUNDLE: {
                return (RaveBundle)((Object)Library.bundle.extension(PieBundle.init()));
            }
            case RADAR_BUNDLE: {
                return (RaveBundle)((Object)Library.bundle.extension(RadarBundle.init()));
            }
            case TORNADO_BUNDLE: {
                return (RaveBundle)((Object)Library.bundle.extension(TornadoBundle.init()));
            }
            case TREEMAP_BUNDLE: {
                return (RaveBundle)((Object)Library.bundle.extension(TreemapBundle.init()));
            }
            case WATERFALL_BUNDLE: {
                return (RaveBundle)((Object)Library.bundle.extension(WaterfallBundle.init()));
            }
            case WORDCLOUD_BUNDLE: {
                return (RaveBundle)((Object)Library.bundle.extension(WordCloudBundle.init()));
            }
            case TILEDMAP_BUNDLE: {
                return (RaveBundle)((Object)Library.bundle.extension(TiledmapBundle.init()));
            }
            case TILEDMAPV2_BUNDLE: {
                return (RaveBundle)((Object)Library.bundle.extension(TiledmapV2Bundle.init()));
            }
            case CATEGORICALPLOT_BUNDLE: {
                return (RaveBundle)((Object)Library.bundle.extension(CategoricalplotBundle.init()));
            }
        }
        return BundleLookup.getBundleReflection(bundleId);
    }

    public static List<String> getBundleIds() {
        ArrayEx result = new ArrayEx();
        result.addAll(Lookup.keySet());
        return result.sort();
    }

    static RaveBundle getBundleReflection(String bundleId) {
        String className = ClassLookup.get(bundleId);
        try {
            Class<?> bundleClass = Class.forName(className);
            Method init = bundleClass.getMethod("init", null);
            String nameStr = (String)init.invoke(null, (Object[])null);
            return (RaveBundle)((Object)Library.bundle.extension(nameStr));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static enum BundleID {
        AREA_BUNDLE,
        BOXPLOT_BUNDLE,
        BUBBLE_BUNDLE,
        BULLET_BUNDLE,
        CHORD_BUNDLE,
        COLUMN_BUNDLE,
        COMPOSITE_BUNDLE,
        DIAL_BUNDLE,
        HEATMAP_BUNDLE,
        LINE_BUNDLE,
        MAP_BUNDLE,
        NETWORK_BUNDLE,
        PIE_BUNDLE,
        RADAR_BUNDLE,
        TORNADO_BUNDLE,
        TREEMAP_BUNDLE,
        WATERFALL_BUNDLE,
        WORDCLOUD_BUNDLE,
        CATEGORICALPLOT_BUNDLE,
        CUSTOMER_BUNDLE,
        TILEDMAP_BUNDLE,
        TILEDMAPV2_BUNDLE;

    }
}

