/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.networkBundle;

import com.ibm.rave.bundles.components.network.NodeLinkForceComponent;
import com.ibm.rave.bundles.data.NetworkLinkDatum;
import com.ibm.rave.bundles.data.NetworkNodeDatum;
import com.ibm.rave.bundles.views.BundleView;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.Dim;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.internal.nativeImpl.Lang;
import com.ibm.rave.core.layout.force.ForceLink;
import com.ibm.rave.core.layout.force.ForceNode;
import com.ibm.rave.core.nativeImpl.arrays.ES6Map;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.svg.SymbolCreator;
import com.ibm.rave.library.action.ActionOperation;
import com.ibm.rave.library.action.BundleUtils;
import com.ibm.rave.library.action.SelectionManager;
import com.ibm.rave.library.action.internal.ActionImpl;
import com.ibm.rave.library.datamodel.DataSet;
import com.ibm.rave.library.datamodel.DataSlotEntry;
import com.ibm.rave.library.framework.internal.BundleContext;
import com.ibm.rave.library.palette.Palette;
import java.util.List;

public class NetworkView
extends BundleView {
    private static final String DATASLOT_COLOR_GROUP = "color";
    private static final String DATASET_LINKS = "link";
    private static final String DATASET_NODES = "node";
    private static final String LINK_LINE_SYMBOL = "linkLine";
    private static final String LINK_DASHLINE_SYMBOL = "linkDashLine";
    private static final String ELEMENT_SHAPE_NODE_SELECTOR = ".element-shape.node";
    @InlineStringConstant
    private static final String LEGEND_LINKS_DISPLAY = "legend.links.display";
    @InlineStringConstant
    private static final String LEGEND_LINKS_TITLE = "legend.links.title";
    @InlineStringConstant
    private static final String LEGEND_LINKS_TITLESTYLE_FONT = "legend.links.titlestyle.font";
    @InlineStringConstant
    private static final String LEGEND_LINKS_TITLESTYLE_FILL = "legend.links.titlestyle.fill";
    @InlineStringConstant
    private static final String LEGEND_LINKS_TITLESTYLE_FONTSIZE = "legend.links.titlestyle.fontsize";
    @InlineStringConstant
    private static final String LEGEND_LINKS_TITLESTYLE_FONTFAMILY = "legend.links.titlestyle.fontfamily";
    @InlineStringConstant
    private static final String LEGEND_NODES_DISPLAY = "legend.nodes.display";
    @InlineStringConstant
    private static final String LEGEND_NODES_TITLE = "legend.nodes.title";
    @InlineStringConstant
    private static final String LEGEND_NODES_TITLESTYLE_FONT = "legend.nodes.titlestyle.font";
    @InlineStringConstant
    private static final String LEGEND_NODES_TITLESTYLE_FILL = "legend.nodes.titlestyle.fill";
    @InlineStringConstant
    private static final String LEGEND_NODES_TITLESTYLE_FONTSIZE = "legend.nodes.titlestyle.fontsize";
    @InlineStringConstant
    private static final String LEGEND_NODES_TITLESTYLE_FONTFAMILY = "legend.nodes.titlestyle.fontfamily";
    @InlineStringConstant
    private static final String LEGEND_NODES_ENTRYSTYLE_FONT = "legend.nodes.entrystyle.font";
    private ES6Map<String, NetworkNodeDatum> _nodeMap = ES6Map.create();
    private Palette colorPalette;
    private final NodeLinkForceComponent _nodeLinkForce = new NodeLinkForceComponent();
    private final SelectionManager _selectionManager = new SelectionManager();

    public NetworkView(BundleContext context) {
        super(context);
        NetworkView.registerNetowkrBundleSymbols();
    }

    @Override
    protected int getLegendCount() {
        return 2;
    }

    @Override
    protected boolean isZoomSupported() {
        return false;
    }

    @Override
    public void setup() {
        final NetworkView self = this;
        this._selectionManager.onStateChange(new RunFunction<Selection<?>>(){

            public Object run(Selection<?> context, Object ... args) {
                context.style("opacity", (Object)"1.0").selectAll("element-shape.node").filter(BundleUtils.notExit).selectAll(".symbolShape.symbol_0").style("stroke", (ValueFunction)new ValueFunction<SceneNode, Object>(){

                    public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                        return Rave.rgb((Object)self.colorPalette.getValue(context, context.getParentNode().getData(), index, groupIndex));
                    }
                }).style("stroke-width", (Object)"2.0px");
                context.filter(".highlighted").selectAll(".symbolShape.symbol_0").style("stroke", (ValueFunction)new ValueFunction<SceneNode, Object>(){

                    public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                        return Rave.rgb((Object)self.colorPalette.getValue(context, context.getParentNode().getData(), index, groupIndex)).darker(0.3);
                    }
                }).style("stroke-width", (Object)"4.0px");
                context.filter(".selected").selectAll(".symbolShape.symbol_0").style("stroke", (ValueFunction)new ValueFunction<SceneNode, Object>(){

                    public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                        return Rave.rgb((Object)self.colorPalette.getValue(context, context.getParentNode().getData(), index, groupIndex)).darker(0.3);
                    }
                }).style("stroke-width", (Object)"4.0px");
                context.filter(".deemphasized").style("opacity", (Object)"0.3");
                return null;
            }
        });
        ActionImpl action = this.context.actions.action("highlight");
        action.setBindFn(BundleUtils.bindAction((BundleContext)this.context, (String)ELEMENT_SHAPE_NODE_SELECTOR, (ActionImpl)action, (String[])new String[]{"mouseenter.default"}));
        action.setOperation(new ActionOperation(){

            public void call(Object ... args) {
                self._selectionManager.highlight((Selection)((Selector)args[0]));
            }
        });
        action = this.context.actions.action("unhighlight");
        action.setBindFn(BundleUtils.bindAction((BundleContext)this.context, (String)ELEMENT_SHAPE_NODE_SELECTOR, (ActionImpl)action, (String[])new String[]{"mouseout.default"}));
        action.setOperation(new ActionOperation(){

            public void call(Object ... args) {
                self._selectionManager.unHighlight((Selection)((Selector)args[0]));
            }
        });
        action = this.context.actions.action("toggleSelect");
        action.setBindFn(BundleUtils.bindAction((BundleContext)this.context, (String)ELEMENT_SHAPE_NODE_SELECTOR, (ActionImpl)action, (String[])new String[]{"click.default", "touchstart.default"}));
        action.setOperation(new ActionOperation(){

            public void call(Object ... args) {
                self._selectionManager.toggleSelect((Selection)((Selector)args[0]));
            }
        });
        action = this.context.actions.action("deselectAll");
        action.setBindFn(BundleUtils.bindAction((BundleContext)this.context, (String)".background", (ActionImpl)action, (String[])new String[]{"click.default", "touchstart.default"}));
        action.setOperation(new ActionOperation(){

            public void call(Object ... args) {
                self._selectionManager.deSelect((Selection)self.context.node.selectAll(NetworkView.ELEMENT_SHAPE_NODE_SELECTOR));
            }
        });
        super.setup();
    }

    public void draw() {
        String nodeEntryString;
        if (this.isUpdateNothing()) {
            return;
        }
        this.preDraw("g.vizlibrary-network");
        if (!this.validateDataModel(new String[0])) {
            return;
        }
        DataSet nodesDataSet = this.dataModel.dataset(DATASET_NODES);
        DataSet linksDataSet = this.dataModel.dataset(DATASET_LINKS);
        final DataSlotEntry nodeSlotID = nodesDataSet.slot("id").entry();
        final DataSlotEntry nodeSlotSize = nodesDataSet.slot("size").entry();
        final DataSlotEntry nodeSlotGroup = nodesDataSet.slot(DATASLOT_COLOR_GROUP).entry();
        final DataSlotEntry nodeSlotKey = nodesDataSet.slot("key").entry();
        final DataSlotEntry linkSlotSource = linksDataSet.slot("source").entry();
        final DataSlotEntry linkSlotTarget = linksDataSet.slot("target").entry();
        final DataSlotEntry linkSlotWeight = linksDataSet.slot("weight").entry();
        final DataSlotEntry linkSlotKey = linksDataSet.slot("key").entry();
        SingleValueFunction<ForceNode, Object> forceNodeAccessor = new SingleValueFunction<ForceNode, Object>(){

            public ForceNode getValue(Object data) {
                return ((NetworkNodeDatum)data)._forceNode;
            }
        };
        SingleValueFunction<ForceLink, Object> forceLinkAccessor = new SingleValueFunction<ForceLink, Object>(){

            public ForceLink getValue(Object data) {
                return ((NetworkLinkDatum)data)._forceLink;
            }
        };
        SingleValueFunction<Object, Object> nodeSizeAccessor = nodeSlotSize != null ? new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return nodeSlotSize.getValue(((NetworkNodeDatum)data).originalData());
            }
        } : null;
        SingleValueFunction<Object, Object> nodeLabelAccessor = new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return nodeSlotID.getValue(((NetworkNodeDatum)data).originalData());
            }
        };
        SingleValueFunction<Object, Object> linkWeightAccessor = linkSlotWeight != null ? new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return linkSlotWeight.getValue(((NetworkLinkDatum)data).originalData());
            }
        } : null;
        Object nodeKeyAccessor = nodeSlotKey != null ? new ValueFunction<Object, Object>(){

            @SwiftMethodOverload(skipParameters={1})
            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return nodeSlotKey.getValue(((NetworkNodeDatum)data).originalData());
            }
        } : new ValueFunction<Object, Object>(){

            @SwiftMethodOverload(skipParameters={1})
            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return nodeSlotID.getValue(((NetworkNodeDatum)data).originalData());
            }
        };
        Object linkKeyAccessor = linkSlotKey != null ? new ValueFunction<Object, Object>(){

            @SwiftMethodOverload(skipParameters={1})
            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return linkSlotKey.getValue(((NetworkLinkDatum)data).originalData());
            }
        } : new ValueFunction<Object, Object>(){

            @SwiftMethodOverload(skipParameters={1})
            public Object getValue(Object context, Object data, int index, int groupIndex) {
                if (data == null) {
                    return null;
                }
                return ObjectConverter.toString((Object)nodeSlotID.getValue(((NetworkLinkDatum)data).source.originalData())) + ObjectConverter.toString((Object)nodeSlotID.getValue(((NetworkLinkDatum)data).target.originalData()));
            }
        };
        this.colorPalette = this.getDynamicPalette();
        this.colorPalette.setData(nodesDataSet, DATASLOT_COLOR_GROUP);
        this.colorPalette.setAccessor((SingleValueFunction)new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return nodeSlotGroup.getValue(((NetworkNodeDatum)data).originalData());
            }
        });
        String effect = this.getStringProperty("effect.name");
        int duration = this.getEffectDuration(effect);
        boolean useLinksLegend = this.getBooleanProperty(LEGEND_LINKS_DISPLAY);
        boolean useNodesLegend = this.getBooleanProperty(LEGEND_NODES_DISPLAY);
        String legendPosition = this.getLegendPosition();
        String nodeTitleString = ObjectConverter.asString((Object)this.context.getPropertyValue(LEGEND_NODES_TITLESTYLE_FONT));
        if (nodeTitleString != null) {
            this._legends.titleFont(0, nodeTitleString);
        }
        if ((nodeEntryString = ObjectConverter.asString((Object)this.context.getPropertyValue(LEGEND_NODES_ENTRYSTYLE_FONT))) != null) {
            this._legends.entryFont(0, nodeEntryString);
        }
        this._legends.visible(useLinksLegend || useNodesLegend).position(legendPosition).transition(!"none".equals(effect), duration).setPreExecute(this.context.getPreExecute()).selector(0, this.context.node.selectAll("g.legend.nodes")).palette(0, this.colorPalette).shape(0, "square").title(0, this.context.getDataSlotLabel(LEGEND_NODES_TITLE, nodesDataSet.slot(DATASLOT_COLOR_GROUP).entry())).titleFill(0, ObjectConverter.asString((Object)this.context.getPropertyValue(LEGEND_NODES_TITLESTYLE_FILL))).titleFontSize(0, ObjectConverter.asString((Object)this.context.getPropertyValue(LEGEND_NODES_TITLESTYLE_FONTSIZE))).titleFontFamily(0, ObjectConverter.asString((Object)this.context.getPropertyValue(LEGEND_NODES_TITLESTYLE_FONTFAMILY))).setDataSlot(0, nodesDataSet.slot(DATASLOT_COLOR_GROUP).entry());
        boolean useLegend = this._legends.anyVisible();
        this.prepareLayoutComponent();
        this.prepareLayoutSizables(this._layoutComponent, false, false, false, false, useLegend);
        this._legends.preLayout(this._layoutComponent);
        this._layoutComponent.layout();
        legendPosition = this._layoutComponent.legendPosition();
        RectStruct chartRect = this._layoutComponent.elementRect();
        RectStruct legendRect = this._layoutComponent.legendRect();
        this._legends.position(legendPosition).rectangle(legendRect);
        this._clip.clipRect(chartRect).applyTo(this._chart.select((Object)"content")).run((Selection<?>)this.context.node.select((Object)"defs"), new Object[0]);
        this.setBackgroundProperties(chartRect, duration);
        this._legends.draw();
        final NetworkView self = this;
        final Dim layoutSize = new Dim(chartRect.width, chartRect.height);
        ArrayEx nodeArray = ObjectConverter.listToArray((List)(nodesDataSet.data() instanceof List ? (List)nodesDataSet.data() : Lang.toList((Object[])((Object[])nodesDataSet.data()))));
        ArrayEx linkArray = ObjectConverter.listToArray((List)(linksDataSet.data() instanceof List ? (List)linksDataSet.data() : Lang.toList((Object[])((Object[])linksDataSet.data()))));
        final ES6Map incomingNodeMap = ES6Map.create();
        nodeArray.forEach((ArrayEx.ArrayValueFunction)new ArrayEx.ArrayValueFunction<Object, Object>(){

            public Object getValue(Object currentValue, int index, ArrayEx<Object> array) {
                String id = ObjectConverter.toString((Object)nodeSlotID.getValue(currentValue));
                NetworkNodeDatum n = (NetworkNodeDatum)self._nodeMap.get((Object)id);
                if (n == null) {
                    n = new NetworkNodeDatum();
                    n._forceNode = new ForceNode();
                    double theta = (double)index * 0.7853981633974483;
                    n._forceNode.x = layoutSize.getWidth() / 2.0 + (double)(5 * index) * Math.cos(theta);
                    n._forceNode.y = layoutSize.getHeight() / 2.0 + (double)(5 * index) * Math.sin(theta);
                }
                n._forceNode.data = currentValue;
                incomingNodeMap.set((Object)id, (Object)n);
                return null;
            }
        });
        this._nodeMap = incomingNodeMap;
        ArrayEx mappedNodes = ObjectConverter.listToArray((List)this._nodeMap.values());
        ArrayEx mappedLinks = linkArray.map((ArrayEx.ArrayValueFunction)new ArrayEx.ArrayValueFunction<Object, NetworkLinkDatum>(){

            public NetworkLinkDatum getValue(Object currentValue, int index, ArrayEx<Object> array) {
                NetworkNodeDatum source = (NetworkNodeDatum)self._nodeMap.get((Object)ObjectConverter.toString((Object)linkSlotSource.getValue(currentValue)));
                if (source == null) {
                    return null;
                }
                NetworkNodeDatum target = (NetworkNodeDatum)self._nodeMap.get((Object)ObjectConverter.toString((Object)linkSlotTarget.getValue(currentValue)));
                if (target == null) {
                    return null;
                }
                ForceLink l = new ForceLink();
                l.source = source._forceNode;
                l.target = target._forceNode;
                l.data = currentValue;
                NetworkLinkDatum d = new NetworkLinkDatum();
                d._forceLink = l;
                d.source = source;
                d.target = target;
                return d;
            }
        });
        Selector existingNodes = this.context.node.selectAll(ELEMENT_SHAPE_NODE_SELECTOR);
        if (existingNodes.size() > 0) {
            this._selectionManager.deSelect((Selection)existingNodes);
        }
        final ValueFunction labelFormatter = this.context.getCustomFormatterForElementLabels(nodeSlotID);
        this._nodeLinkForce.nodes((List<? extends Object>)mappedNodes).links((List<? extends Object>)mappedLinks).forceNodeAccessor(forceNodeAccessor).forceLinkAccessor(forceLinkAccessor).nodeSizeAccessor(nodeSizeAccessor).nodeLabelAccessor(nodeLabelAccessor != null && labelFormatter != null ? new SingleValueFunction<Object, Object>((SingleValueFunction)nodeLabelAccessor){
            final /* synthetic */ SingleValueFunction val$nodeLabelAccessor;
            {
                this.val$nodeLabelAccessor = singleValueFunction;
            }

            public Object getValue(Object data) {
                return labelFormatter.getValue(null, this.val$nodeLabelAccessor.getValue(data), 0, 0);
            }
        } : nodeLabelAccessor).nodeLabelFont(ObjectConverter.toString((Object)this.context.getPropertyValue("nodeLabel.font"))).linkWeightAccessor(linkWeightAccessor).keyNodes((ValueFunction<Object, Object>)nodeKeyAccessor).keyLinks((ValueFunction<Object, Object>)linkKeyAccessor).nodeColorAccessor((ValueFunction<SceneNode, Object>)this.colorPalette).layoutSize(layoutSize).nodeSymbolType(ObjectConverter.toString((Object)this.context.getPropertyValue("nodeSymbol"))).linkType(ObjectConverter.toString((Object)this.context.getPropertyValue("linkType"))).nodeSizeExtent((ArrayEx<Object>)new ArrayEx(new Object[]{ObjectConverter.toInt((Object)this.context.getPropertyValue("nodeSize.min")), ObjectConverter.toInt((Object)this.context.getPropertyValue("nodeSize.max"))})).linkStyleStroke(this.getStringProperty("color.networkLinkColor"));
        Selector elementGroup = this._chart.select((Object)"g.element-group");
        elementGroup.transition().duration((Object)duration).call((RunFunction)this._nodeLinkForce, new Object[0]);
        this._selectionManager.updateContext((Selection)elementGroup.selectAll(ELEMENT_SHAPE_NODE_SELECTOR));
        elementGroup.selectAll(".element-label").style("visibility", (Object)(ObjectConverter.toBoolean((Object)this.context.getPropertyValue("nodeLabel.show")) ? null : "hidden"));
        this._chart.selectAll(".element-shape").classed("bundle-shape", true);
        this._chart.selectAll(".legendShape").classed("bundle-shape", true);
    }

    protected static void registerNetowkrBundleSymbols() {
        Rave.svg.symbolCreator(LINK_LINE_SYMBOL, new SymbolCreator(){

            public String create(double size) {
                double len = Math.sqrt(size) / 2.0;
                return "M" + -len + "," + -1.5 + "L" + len + "," + -1.5 + " " + len + "," + 1.5 + " " + -len + "," + 1.5 + "Z";
            }
        });
        Rave.svg.symbolCreator(LINK_DASHLINE_SYMBOL, new SymbolCreator(){

            public String create(double size) {
                double len = Math.sqrt(size) / 2.0;
                return "M" + -len + "," + 0 + "L" + len + "," + 0 + "Z";
            }
        });
    }

    @Override
    protected String[] getGroupStructure() {
        return new String[]{"defs", "g.vizlibrary vizlibrary-network", "(", "rect.background chart", "g.chart", "(", "g.content", "(", "rect.background elements", "g.elements", "(", "g.element-group", ")", ")", "g.legends", "(", "g.legends-layout", "g.legend nodes", "g.legend links", ")", ")", ")"};
    }
}

