/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.pieBundle;

import com.ibm.rave.bundles.components.PieComponentImpl;
import com.ibm.rave.bundles.data.SliceBundleDatum;
import com.ibm.rave.bundles.utilities.FontPropertyParser;
import com.ibm.rave.bundles.views.BundleView;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.internal.nativeImpl.Lang;
import com.ibm.rave.core.internal.nativeImpl.NumberFormatHelper;
import com.ibm.rave.core.layout.SliceData;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.util.Comparator;
import com.ibm.rave.library.action.BundleUtils;
import com.ibm.rave.library.datamodel.DataSet;
import com.ibm.rave.library.datamodel.DataSlot;
import com.ibm.rave.library.datamodel.DataSlotEntry;
import com.ibm.rave.library.framework.internal.BundleContext;
import com.ibm.rave.library.framework.internal.ScaleManager;
import com.ibm.rave.library.palette.Palette;
import java.util.List;

public class PieView
extends BundleView {
    private static final OMap<Object, Comparator<Object>> SORT_PROPERTY_OPTIONS = PieView.initSortOptions();
    public static final int MAX_NUMBER_OF_PIES = 8;
    private ArrayEx<PieComponentImpl> _pieComponents = null;
    private RectStruct _chartRect;
    private RectStruct _legendRect;
    private ArrayEx<ArrayEx<Object>> _pieData;
    private List<Object> _colorDomain = null;
    private OMap<String, Object> _labelFontStyle = null;
    @InlineStringConstant
    private static final String DATAMODEL_TABULAR = "tabular";
    @InlineStringConstant
    private static final String DATASET_DATA = "data";
    @InlineStringConstant
    private static final String DATASLOT_VALUE = "value";
    @InlineStringConstant
    private static final String DATASLOT_LABEL = "color";
    @InlineStringConstant
    private static final String DATASLOT_CHILDREN = "children";
    @InlineStringConstant
    private static final String DATASLOT_KEY = "key";
    private static final String LABEL_FIELD = "labelField";
    private static final String LABEL_LOCATION = "labelLocation";
    private static final ValueFunction<Object, Object> pieSliceValueAccessor = new ValueFunction<Object, Object>(){

        public Object getValue(Object context, Object data, int index, int groupIndex) {
            return ((PieSlice)data).value;
        }
    };
    private static final ValueFunction<Object, Object> sliceDataLabelAccessor = new ValueFunction<Object, Object>(){

        public Object getValue(Object context, Object data, int index, int groupIndex) {
            return ((PieSlice)((SliceData)data).data).label;
        }
    };
    private static final SingleValueFunction<Object, Object> sliceDataGroupAccessor = new SingleValueFunction<Object, Object>(){

        public Object getValue(Object data) {
            return ((PieSlice)((SliceData)data).data).group;
        }
    };
    private static final ValueFunction<Object, Object> sliceDataValueAccessor = new ValueFunction<Object, Object>(){

        public Object getValue(Object context, Object data, int index, int groupIndex) {
            return ObjectConverter.toString((Object)((PieSlice)((SliceData)data).data).value);
        }
    };
    private static final ValueFunction<Object, Object> sliceDataValuePercentAccessor = new ValueFunction<Object, Object>(){

        public Object getValue(Object context, Object data, int index, int groupIndex) {
            double percent = ((PieSlice)((SliceData)data).data).percent;
            return Double.isNaN(percent) ? "" : NumberFormatHelper.toFixed((double)(percent * 100.0), (int)1) + "%";
        }
    };

    private static OMap<Object, Comparator<Object>> initSortOptions() {
        OMap map = new OMap();
        map.put((Object)"none", (Object)new Comparator<Object>(){

            public int compare(Object one, Object two) {
                PieSlice a = (PieSlice)one;
                PieSlice b = (PieSlice)two;
                return PieView.compareSlicesByIndex(a, b);
            }
        });
        map.put((Object)"ascending", (Object)new Comparator<Object>(){

            public int compare(Object one, Object two) {
                PieSlice a = (PieSlice)one;
                PieSlice b = (PieSlice)two;
                return PieView.compareSlices(a, b, true);
            }
        });
        map.put((Object)"descending", (Object)new Comparator<Object>(){

            public int compare(Object one, Object two) {
                PieSlice a = (PieSlice)one;
                PieSlice b = (PieSlice)two;
                return PieView.compareSlices(a, b, false);
            }
        });
        return map;
    }

    public PieView(BundleContext context) {
        super(context);
    }

    @Override
    protected boolean isZoomSupported() {
        return false;
    }

    @Override
    public void setup() {
        super.setup();
        this._pieComponents = new ArrayEx();
        for (int i = 0; i < 8; ++i) {
            PieComponentImpl pie = new PieComponentImpl();
            pie.valueAccessor(pieSliceValueAccessor);
            this._pieComponents.add((Object)pie);
        }
        OMap style = new OMap();
        style.put((Object)"stroke", (Object)"white");
        style.put((Object)"stroke-width", (Object)"1px");
        BundleUtils.setupDefaultActions((BundleContext)this.context, (String)".chart .element-shape", (OMap)style);
    }

    public void draw() {
        if (this.isUpdateNothing()) {
            return;
        }
        this.preDraw("g.vizlibrary-pie");
        if (!this.validateDataModel("g.elements")) {
            return;
        }
        this.setBorder("border.width", "border.color");
        String effect = this.getStringProperty("effect.name");
        int duration = this.getEffectDuration(effect);
        boolean doTransition = duration != 0;
        DataSet dataSet = this.dataModel.dataset(DATASET_DATA);
        if (this.updateType == 0) {
            this.context.actions.action("deselectAll").call(new Object[]{this.context.node.selectAll(".chart .element-shape")});
            this._pieData = new ArrayEx();
            if (DATAMODEL_TABULAR.equals(this.dataModel.getDescriptor().id())) {
                this._pieData.set(0, this.readTableData(dataSet));
            } else {
                OMap<String, ArrayEx<Object>> data = this.readHierarchyData(dataSet);
                for (int i = 0; i < data.keySet().size(); ++i) {
                    this._pieData.set(i, data.get((Object)("pieData" + i)));
                }
            }
            for (ArrayEx data : this._pieData) {
                int i;
                double sum = 0.0;
                for (i = 0; i < data.size(); ++i) {
                    ((PieSlice)data.get((int)i)).index = i;
                    ((PieSlice)data.get((int)i)).percent = Double.NaN;
                    sum += Math.abs(((PieSlice)data.get((int)i)).value.doubleValue());
                }
                if (sum == 0.0) continue;
                for (i = 0; i < data.size(); ++i) {
                    ((PieSlice)data.get((int)i)).percent = ((PieSlice)data.get((int)i)).value.doubleValue() / sum;
                }
            }
            DataSlotEntry colorDataSlotEntry = dataSet.slot(DATASLOT_LABEL).entry();
            if (colorDataSlotEntry != null) {
                this._colorDomain = colorDataSlotEntry.domain();
            }
            if (this._colorDomain == null) {
                this._colorDomain = ScaleManager.ordinalDomainWithValueFunction((List)((List)this._pieData.get(0)), (String)"string", (SingleValueFunction)new SingleValueFunction<Object, Object>(){

                    public Object getValue(Object d) {
                        return ((PieSlice)d).group;
                    }
                }, (boolean)false);
            }
        }
        Palette colorPalette = this.getPalette();
        colorPalette.setData(this._colorDomain, dataSet, DATASLOT_LABEL);
        colorPalette.setAccessor(sliceDataGroupAccessor);
        String legendPosition = this.getLegendPosition();
        this._legends.visible(this.isShowLegend()).position(legendPosition).transition(doTransition, duration).setPreExecute(this.context.getPreExecute()).selector(0, this.context.node.selectAll("g.legend")).palette(0, colorPalette).shape(0, "square").title(0, this.context.getDataSlotLabel("legend.title", dataSet.slot(DATASLOT_LABEL).entry())).titleFill(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fill"))).titleFontSize(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontsize"))).titleFontFamily(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontfamily"))).setDataSlot(0, dataSet.slot(DATASLOT_LABEL).entry());
        if (this.updateType <= 1) {
            this.prepareLayoutComponent();
            this.prepareLayoutSizables(this._layoutComponent, false, false, false, false, this._legends.anyVisible());
            this._legends.preLayout(this._layoutComponent);
            this._layoutComponent.layout();
            legendPosition = this._layoutComponent.legendPosition();
            this._chartRect = this._layoutComponent.elementRect();
            this._legendRect = this._layoutComponent.legendRect();
            this._legends.position(legendPosition).rectangle(this._legendRect);
        }
        double donutRadius = ObjectConverter.toDouble((Object)this.context.getPropertyValue("donutRadius"));
        donutRadius = Math.max(0.0, donutRadius);
        donutRadius = Math.min(1.0, donutRadius);
        this.setBackgroundProperties(this._chartRect, duration);
        this._labelFontStyle = FontPropertyParser.parseCSSFont(this.getStringProperty("labelstyle.font"));
        if (this.getStringProperty(LABEL_LOCATION).equals("callout")) {
            this._labelFontStyle = this.getBackgroundConstrastLabelStyle();
        }
        this.drawPies(this._chart, this._chartRect, duration, donutRadius, colorPalette);
        this._legends.draw();
        this.resetUpdate();
        this._chart.selectAll(".element-shape").classed("bundle-shape", true);
        this._chart.selectAll(".legendShape").classed("bundle-shape", true);
    }

    private void drawPies(Selector chart, RectStruct chartRect, int duration, double donutRadius, Palette colorPalette) {
        int i;
        int numPies = this._pieData.size();
        for (i = numPies - 1; i >= 0; --i) {
            this.drawPie(i, donutRadius, chart.selectAll("g.element-group" + (8 - i)), (ArrayEx<Object>)((ArrayEx)this._pieData.get(i)), colorPalette, chartRect, duration);
        }
        for (i = numPies; i < 8; ++i) {
            this.drawPie(i, donutRadius, chart.selectAll("g.element-group" + (8 - i)), null, null, null, 0);
        }
    }

    private boolean drawPie(int i, double _donutRadius, Selector g, ArrayEx<Object> data, Palette colorPalette, RectStruct chartRect, int duration) {
        if (data == null || data.size() == 0) {
            g.selectAll("*").remove();
            return false;
        }
        PieComponentImpl pie = (PieComponentImpl)this._pieComponents.get(i);
        if (this.updateType <= 1) {
            pie.colorAccessor(sliceDataGroupAccessor);
            Comparator sort = (Comparator)SORT_PROPERTY_OPTIONS.get((Object)this.getStringProperty("sort"));
            data.sort(sort);
            Object[] pieData = pie.buildLayout().pie(data);
            ArrayEx mappedNodes = Lang.toArray((Object[])pieData).filter((ArrayEx.ArrayValueFunction)new ArrayEx.ArrayValueFunction<SliceData, Boolean>(){

                public Boolean getValue(SliceData currentValue, int index, ArrayEx<SliceData> array) {
                    return ((PieSlice)currentValue.data)._originalData != null;
                }
            }).map((ArrayEx.ArrayValueFunction)new ArrayEx.ArrayValueFunction<SliceData, SliceBundleDatum>(){

                public SliceBundleDatum getValue(SliceData currentValue, int index, ArrayEx<SliceData> array) {
                    SliceBundleDatum d = new SliceBundleDatum();
                    d._sliceData = currentValue;
                    return d;
                }
            });
            pie.data((List<? extends Object>)mappedNodes);
        }
        DataSlot keyDataSlot = this.dataModel.dataset(DATASET_DATA).slot(DATASLOT_KEY);
        final SingleValueFunction keyAccessor = PieView.accessorOf((DataSlotEntry)keyDataSlot.entry());
        SingleValueFunction<Object, Object> keyFunc = new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return keyAccessor.getValue(((SliceBundleDatum)data).originalData());
            }
        };
        boolean useLabel = "category".equals(this.getStringProperty(LABEL_FIELD));
        boolean useValue = DATASLOT_VALUE.equals(this.getStringProperty(LABEL_FIELD));
        ValueFunction<Object, Object> labelAccessor = useLabel ? sliceDataLabelAccessor : (useValue ? sliceDataValueAccessor : sliceDataValuePercentAccessor);
        DataSlotEntry labelEntry = this.dataModel.dataset(DATASET_DATA).slot(useLabel ? DATASLOT_LABEL : DATASLOT_VALUE).entry();
        ((PieComponentImpl)((PieComponentImpl)pie.colorPalette(colorPalette).bounds(chartRect).key((SingleValueFunction<Object, Object>)(keyAccessor != null ? keyFunc : null))).labelAccessor(labelAccessor).labelFormatter((ValueFunction<Object, String>)this.context.getCustomFormatterForElementLabels(labelEntry)).labelHideTruncated(!useLabel).labelFont(this._labelFontStyle).labelContrast(this.getBooleanProperty("contrast.label.color")).labelShadow(this.getBooleanProperty("label.shadow")).sliceAccessor(new SingleValueFunction<SliceData, Object>(){

            public SliceData getValue(Object data) {
                return ((SliceBundleDatum)data)._sliceData;
            }
        }).donutRadius(_donutRadius).currentLevel(i).maxLevel(this._pieData.size()).setPreExecute(this.context.getPreExecute())).labelLocation(this.getStringProperty(LABEL_LOCATION)).borderWidth(this.context.convertCSSSizeToPixels(this.context.getPropertyValue("border.width"))).borderColor(ObjectConverter.asString((Object)this.context.getPropertyValue("border.color")));
        g.transition().duration((Object)(this.updateType == 0 ? duration : 0)).call((RunFunction)pie, new Object[0]);
        return true;
    }

    private ArrayEx<Object> readTableData(DataSet dataSet) {
        ArrayEx result = new ArrayEx();
        ArrayEx data = ObjectConverter.listToArray((List)((List)dataSet.data()));
        if (data == null || data.size() == 0) {
            return result;
        }
        SingleValueFunction labelAccessor = PieView.accessorOf((DataSlotEntry)dataSet.slot(DATASLOT_LABEL).entry());
        SingleValueFunction valueAccessor = PieView.accessorOf((DataSlotEntry)dataSet.slot(DATASLOT_VALUE).entry());
        for (Object datum : data) {
            Double v;
            if (datum == null || (v = Double.valueOf(ObjectConverter.toDouble((Object)valueAccessor.getValue(datum)))) == null) continue;
            PieSlice r = new PieSlice();
            r.value = v;
            r.group = r.label = ObjectConverter.toString((Object)labelAccessor.getValue(datum));
            r._originalData = datum;
            result.add((Object)r);
        }
        return result;
    }

    private OMap<String, ArrayEx<Object>> readHierarchyData(DataSet dataSet) {
        SingleValueFunction childrenAccessor = PieView.accessorOf((DataSlotEntry)dataSet.slot(DATASLOT_CHILDREN).entry());
        SingleValueFunction nameAccessor = PieView.accessorOf((DataSlotEntry)dataSet.slot(DATASLOT_LABEL).entry());
        SingleValueFunction vAccessor = PieView.accessorOf((DataSlotEntry)dataSet.slot(DATASLOT_VALUE).entry());
        Object data = dataSet.data();
        ArrayEx nodes = ObjectConverter.listToArray((List)((List)childrenAccessor.getValue(data)));
        OMap pieData = new OMap();
        this.getPieData((OMap<String, ArrayEx<Object>>)pieData, (ArrayEx<Object>)nodes, 0, null, null, (SingleValueFunction<Object, Object>)childrenAccessor, (SingleValueFunction<Object, Object>)nameAccessor, (SingleValueFunction<Object, Object>)vAccessor);
        for (int i = 1; i < 8; ++i) {
            this.checkLevel((OMap<String, ArrayEx<Object>>)pieData, i);
        }
        return pieData;
    }

    private void checkLevel(OMap<String, ArrayEx<Object>> pieData, int level) {
        ArrayEx<Object> data = this.getPieDataForLevel(pieData, level);
        for (Object d : data) {
            if (((PieSlice)d).group == null) continue;
            return;
        }
        pieData.remove((Object)("pieData" + level));
    }

    private void getPieData(OMap<String, ArrayEx<Object>> pieData, ArrayEx<Object> nodes, int currentLevel, List<Number> parentV, String group, SingleValueFunction<Object, Object> childrenAccessor, SingleValueFunction<Object, Object> nameAccessor, SingleValueFunction<Object, Object> vAccessor) {
        ArrayEx<Object> data = this.getPieDataForLevel(pieData, currentLevel);
        for (Object node : nodes) {
            PieSlice r = new PieSlice();
            r.label = ObjectConverter.toString((Object)nameAccessor.getValue(node));
            if (currentLevel > 0) {
                r.parentsValue = parentV;
            }
            r.group = currentLevel == 0 ? r.label : group;
            ArrayEx children = childrenAccessor.getValue(node) == null ? null : ObjectConverter.listToArray((List)((List)childrenAccessor.getValue(node)));
            ArrayEx pv = new ArrayEx();
            for (Number n : r.parentsValue) {
                pv.add(n);
            }
            if (children == null) {
                r.value = ObjectConverter.toDouble((Object)vAccessor.getValue(node));
                pv.add(r.value);
                for (int j = currentLevel + 1; j < 8; ++j) {
                    this.addFakeSliceToLevel(pieData, j, ObjectConverter.toDouble((Object)r.value), (List<Number>)pv);
                }
            } else {
                double sum = 0.0;
                for (Object child : children) {
                    double v = this.getSliceValue(child, childrenAccessor, vAccessor);
                    sum += v;
                }
                r.value = sum;
                pv.add(r.value);
                this.getPieData(pieData, (ArrayEx<Object>)children, currentLevel + 1, (List<Number>)pv, r.group, childrenAccessor, nameAccessor, vAccessor);
            }
            r._originalData = node;
            data.add(r);
        }
    }

    private void addFakeSliceToLevel(OMap<String, ArrayEx<Object>> pieData, int level, double v, List<Number> pv) {
        ArrayEx<Object> d = this.getPieDataForLevel(pieData, level);
        PieSlice c = new PieSlice();
        c.group = null;
        c.label = null;
        c.value = v;
        c.parentsValue = pv;
        c._originalData = null;
        d.add(c);
    }

    private ArrayEx<Object> getPieDataForLevel(OMap<String, ArrayEx<Object>> pieData, int currentLevel) {
        ArrayEx data = (ArrayEx)pieData.get((Object)("pieData" + currentLevel));
        if (data == null) {
            data = new ArrayEx();
            pieData.put((Object)("pieData" + currentLevel), (Object)data);
        }
        return data;
    }

    private double getSliceValue(Object node, SingleValueFunction<Object, Object> childrenAccessor, SingleValueFunction<Object, Object> vAccessor) {
        if (childrenAccessor.getValue(node) == null) {
            return ObjectConverter.toDouble((Object)vAccessor.getValue(node));
        }
        double result = 0.0;
        ArrayEx children = ObjectConverter.listToArray((List)((List)childrenAccessor.getValue(node)));
        for (Object child : children) {
            result += this.getSliceValue(child, childrenAccessor, vAccessor);
        }
        return result;
    }

    protected int requireUpdate(String property) {
        if (property.equals(LABEL_FIELD) && this.getStringProperty(LABEL_LOCATION).equals("none")) {
            return 4;
        }
        return super.requireUpdate(property);
    }

    private static int compareSlices(PieSlice a, PieSlice b, boolean ascending) {
        int sa = a.parentsValue.size();
        int sb = b.parentsValue.size();
        for (int i = 0; i < Math.max(sa, sb); ++i) {
            double v = ObjectConverter.toDouble((Object)a.parentsValue.get(Math.min(i, sa - 1))) - ObjectConverter.toDouble((Object)b.parentsValue.get(Math.min(i, sb - 1)));
            if (v < 0.0) {
                return ascending ? -1 : 1;
            }
            if (!(v > 0.0)) continue;
            return ascending ? 1 : -1;
        }
        if (Math.min(sa, sb) > 0 && a.group != null && b.group != null && a.group.compareTo(b.group) != 0) {
            return a.group.compareTo(b.group);
        }
        double val = ObjectConverter.toDouble((Object)a.value) - ObjectConverter.toDouble((Object)b.value);
        if (ascending) {
            return val == 0.0 ? 0 : (val < 0.0 ? -1 : 1);
        }
        return val == 0.0 ? 0 : (val > 0.0 ? -1 : 1);
    }

    private static int compareSlicesByIndex(PieSlice a, PieSlice b) {
        int v = a.index - b.index;
        return v < 0 ? -1 : 1;
    }

    @Override
    protected String[] getGroupStructure() {
        return new String[]{"defs", "g.vizlibrary vizlibrary-pie", "(", "rect.background chart", "g.chart", "(", "g.content", "(", "rect.background elements", "g.elements", "(", "g.element-group1", "g.element-group2", "g.element-group3", "g.element-group4", "g.element-group5", "g.element-group6", "g.element-group7", "g.element-group8", ")", ")", ")", "g.legends", "(", "g.legends-layout", "g.legend", ")", ")"};
    }

    public static class PieSlice {
        public String label;
        public Number value;
        public double percent;
        public String group;
        public List<Number> parentsValue = new ArrayEx();
        public int index;
        public Object _originalData;
    }
}

