/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.radarBundle;

import com.ibm.rave.bundles.components.LineComponentImpl;
import com.ibm.rave.bundles.components.PointComponentImpl;
import com.ibm.rave.bundles.components.RadarBackgroundComponentImpl;
import com.ibm.rave.bundles.data.LineDataUtilities;
import com.ibm.rave.bundles.data.PointDataUtilities;
import com.ibm.rave.bundles.utilities.FontPropertyParser;
import com.ibm.rave.bundles.views.BundleView;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.event.Event;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.LinearScale;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.SelectorEventListener;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.ext.text.nativeImpl.FontChecker;
import com.ibm.rave.library.action.BundleUtils;
import com.ibm.rave.library.action.internal.ActionImpl;
import com.ibm.rave.library.datamodel.DataSet;
import com.ibm.rave.library.datamodel.DataSlotEntry;
import com.ibm.rave.library.framework.CoordinateScale;
import com.ibm.rave.library.framework.internal.BundleContext;
import com.ibm.rave.library.framework.internal.CoordinateScaleImpl;
import com.ibm.rave.library.framework.internal.LinearCoordinateScale;
import com.ibm.rave.library.framework.internal.ScaleManager;
import com.ibm.rave.library.palette.Palette;
import java.util.List;

public class RadarView
extends BundleView {
    @InlineStringConstant
    private static final String DATASET_DATA = "data";
    @InlineStringConstant
    private static final String DATASLOT_X = "x";
    @InlineStringConstant
    private static final String DATASLOT_Y = "y";
    @InlineStringConstant
    private static final String DATASLOT_GROUP = "color";
    @InlineStringConstant
    private static final String DATASLOT_KEY = "key";
    @InlineStringConstant
    private static final String LINE_WITH_POINTS_SYMBOL = "lineWithPoints.symbol";
    @InlineStringConstant
    private static final String LINE_OR_POINTS_DISPLAY = "lineWithPoints.display";
    @InlineStringConstant
    private static final String LINE_DISPLAY = "line";
    @InlineStringConstant
    private static final String POINTS_DISPLAY = "points";
    @InlineStringConstant
    private static final String LINE_WITH_POINTS_DISPLAY = "lineWithPoints.display";
    @InlineStringConstant
    private static final String LINE_WITH_POINTS_SIZE = "lineWithPoints.size";
    @InlineStringConstant
    private static final String COLOR_PALLETTE_LINE = "color.palette.line";
    @InlineStringConstant
    private static final String LINE_INTERPOLATE_PROPERTY = "lineWithPoints.interpolate";
    @InlineStringConstant
    private static final String FILL_RADAR = "lineWithPoints.fillradar";
    private RadarBackgroundComponentImpl _radarBackgroundComponent;
    private CoordinateScaleImpl _categoryScale;
    private CoordinateScaleImpl _valueScale;
    List<Object> ticks;
    private RectStruct chartRect;
    private RectStruct legendRect;
    private double zoomScale = 1.0;
    private PointComponentImpl _pointComponent;
    SingleValueFunction<Object, Object> xAccessor;
    SingleValueFunction<Object, Object> yAccessor;
    private LineComponentImpl _lineComponent;
    double _radius;
    private List<PointDataUtilities.PointDatum> _pointData;
    private List<PointDataUtilities.PointDatum> _pointNPNData;

    public RadarView(BundleContext context) {
        super(context);
    }

    @Override
    protected boolean isZoomSupported() {
        return false;
    }

    @Override
    public void setup() {
        super.setup();
        BundleUtils.setupDefaultActions((BundleContext)this.context, (String)".chart .element-shape", null);
        final ActionImpl highlightAction = this.context.actions.action("highlight");
        final ActionImpl unhighlightAction = this.context.actions.action("unhighlight");
        final RadarView self = this;
        highlightAction.setBindFn(new BundleUtils.BindingOperation(){

            public void call() {
                self.context.node.selectAll(".element-path .element-shape").on("mouseenter.default", (SelectorEventListener)new SelectorEventListener<Event>(){

                    public void onEvent(SceneNode context1, Object data, int index, int groupIndex, Event event) {
                        OMap attributes = new OMap();
                        attributes.put((Object)"stroke-width", (Object)"4px");
                        highlightAction.call(new Object[]{Rave.select((SceneNode)context1), attributes});
                    }
                });
                self.context.node.selectAll(".element-group .element-shape").on("mouseenter.default", (SelectorEventListener)new SelectorEventListener<Event>(){

                    public void onEvent(SceneNode context1, Object data, int index, int groupIndex, Event event) {
                        highlightAction.call(new Object[]{Rave.select((SceneNode)context1)});
                    }
                });
            }
        });
        highlightAction.setUnbindFn(new BundleUtils.BindingOperation(){

            public void call() {
                self.context.node.selectAll(".element-shape").on("mouseenter.default", null);
            }
        });
        unhighlightAction.setBindFn(new BundleUtils.BindingOperation(){

            public void call() {
                self.context.node.selectAll(".element-path .element-shape").on("mouseout.default", (SelectorEventListener)new SelectorEventListener<Event>(){

                    public void onEvent(SceneNode context1, Object data, int index, int groupIndex, Event event) {
                        OMap attributes = new OMap();
                        attributes.put((Object)"stroke-width", (Object)"2px");
                        unhighlightAction.call(new Object[]{Rave.select((SceneNode)context1), attributes});
                    }
                });
                self.context.node.selectAll(".element-group .element-shape").on("mouseout.default", (SelectorEventListener)new SelectorEventListener<Event>(){

                    public void onEvent(SceneNode context1, Object data, int index, int groupIndex, Event event) {
                        OMap attributes = new OMap();
                        attributes.put((Object)"stroke-width", (Object)"0px");
                        unhighlightAction.call(new Object[]{Rave.select((SceneNode)context1), attributes});
                    }
                });
            }
        });
        unhighlightAction.setUnbindFn(new BundleUtils.BindingOperation(){

            public void call() {
                self.context.node.selectAll(".element-shape").on("mouseout.default", null);
            }
        });
        ActionImpl deselectAllAction = this.context.actions.action("deselectAll");
        SelectorEventListener<Event> deselectAllEventListener = new SelectorEventListener<Event>(){

            public void onEvent(SceneNode context1, Object data, int index, int groupIndex, Event event) {
                self.context.node.selectAll(".element-shape").style("stroke-width", (Object)0).style("opacity", (Object)1).property("selected", null);
                self.context.node.selectAll(".element-path .element-shape").style("stroke-width", (Object)2);
            }
        };
        deselectAllAction.setBindFn(BundleUtils.bindOrUnbindActionFunctionCreater((BundleContext)this.context, (String)".background", (String[])new String[]{"click.default", "touchstart.default"}, (SelectorEventListener)deselectAllEventListener));
        this._pointComponent = new PointComponentImpl();
        this._pointComponent.independentAccessor(PointDataUtilities.X_ACCESSOR).dependentAccessor(PointDataUtilities.Y_ACCESSOR);
        this._lineComponent = new LineComponentImpl();
        this._lineComponent.pointsAccessor(LineDataUtilities.POINTS_ACCESSOR).groupAccessor(LineDataUtilities.GROUP_ACCESSOR);
        this._radarBackgroundComponent = new RadarBackgroundComponentImpl();
    }

    public void draw() {
        if (this.isUpdateNothing()) {
            return;
        }
        this.preDraw("g.vizlibrary-radar");
        if (!this.validateDataModel("g.radarbackground", "g.element-group")) {
            return;
        }
        String effect = this.getStringProperty("effect.name");
        int duration = this.getEffectDuration(effect);
        boolean doTransition = duration != 0;
        DataSet dataSet = this.dataModel.dataset(DATASET_DATA);
        DataSlotEntry yDataSlotEntry = dataSet.slot(DATASLOT_Y).entry();
        DataSlotEntry colorDataSlotEntry = dataSet.slot(DATASLOT_GROUP).entry();
        if (colorDataSlotEntry == null && yDataSlotEntry != null) {
            dataSet.slot(DATASLOT_GROUP).overrideLabel(yDataSlotEntry.label());
        }
        ArrayEx data = ObjectConverter.listToArray((List)((List)dataSet.data()));
        DataSlotEntry xEntry = dataSet.slot(DATASLOT_X).entry();
        this.xAccessor = RadarView.accessorOf((DataSlotEntry)xEntry);
        this.yAccessor = RadarView.accessorOf((DataSlotEntry)dataSet.slot(DATASLOT_Y).entry());
        this._pointData = PointDataUtilities.buildPoints((List<Object>)data, this.xAccessor, (SingleValueFunction<Object, Object>)RadarView.domainCheckerOf((List)data, (DataSlotEntry)xEntry), this.yAccessor, (SingleValueFunction<Object, Object>)RadarView.domainCheckerOf((List)data, (DataSlotEntry)dataSet.slot(DATASLOT_Y).entry()));
        SingleValueFunction groupAccessor = RadarView.accessorOf((DataSlotEntry)dataSet.slot(DATASLOT_GROUP).entry());
        Palette pointColorPalette = this.getPalette();
        pointColorPalette.setData(dataSet, DATASLOT_GROUP);
        pointColorPalette.setAccessor(RadarView.originalDatumAccessor((SingleValueFunction)groupAccessor));
        Palette pathColorPalette = this.getPalette();
        pathColorPalette.setData(dataSet, DATASLOT_GROUP);
        pathColorPalette.setAccessor(LineDataUtilities.GROUP_ACCESSOR);
        boolean useLegend = this.isShowLegend();
        String legendPosition = this.getLegendPosition();
        this._legends.visible(useLegend).position(legendPosition).transition(doTransition, duration).setPreExecute(this.context.getPreExecute()).selector(0, this.context.node.selectAll("g.legend")).palette(0, pointColorPalette).shape(0, "square").title(0, this.context.getDataSlotLabel("legend.title", dataSet.slot(DATASLOT_GROUP).entry())).titleFill(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fill"))).titleFontSize(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontsize"))).titleFontFamily(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontfamily"))).setDataSlot(0, dataSet.slot(DATASLOT_GROUP).entry());
        if (this.updateType <= 1) {
            String drawOptions;
            this.prepareLayoutComponent();
            this.prepareLayoutSizables(this._layoutComponent, false, false, false, false, useLegend);
            this._legends.preLayout(this._layoutComponent);
            this._layoutComponent.layout();
            legendPosition = this._layoutComponent.legendPosition();
            this.chartRect = this._layoutComponent.elementRect();
            this.legendRect = this._layoutComponent.legendRect();
            this._clip.clipRect(this.chartRect).applyTo(this._chart.select((Object)".content")).run((Selection<?>)this.context.node.select((Object)"defs"), new Object[0]);
            this._valueScale = ScaleManager.makeCoordinateScale((List)data, (DataSlotEntry)dataSet.slot(DATASLOT_Y).entry());
            if (this._valueScale != null) {
                if (this.getBooleanProperty("axis.y.scale.includeZero")) {
                    this._valueScale.includeZero();
                }
                this._valueScale.range(0.0, 1.0, Double.valueOf(0.0), Double.valueOf(0.0));
                LinearScale scale = ((LinearScale)this._valueScale.scale()).nice((Number)5);
                this.ticks = scale.getTicksInRange() != null ? scale.getTicksInRange().ticksInRange(new Object[0]) : (scale.getTicks() != null ? scale.getTicks().getValue(null) : scale.domain());
                if (this.ticks.size() > 0) {
                    this.ticks.remove(0);
                }
            }
            this._categoryScale = ScaleManager.makeCoordinateScale((List)data, (DataSlotEntry)dataSet.slot(DATASLOT_X).entry());
            if (this._categoryScale != null) {
                this._categoryScale.range(0.0, Math.PI * 2, Double.valueOf(0.0), Double.valueOf(0.0));
            }
            if ((drawOptions = this.getStringProperty("lineWithPoints.display")).equals("line_points") || drawOptions.equals(POINTS_DISPLAY)) {
                this._pointComponent.data(this._pointData.toArray());
            }
            final RadarView self = this;
            this._radius = Math.min(this.chartRect.width / 2.0, this.chartRect.height / 2.0) * 0.85;
            CoordinateScaleImpl identityScale = LinearCoordinateScale.create((List)new ArrayEx(new Object[]{0, 1})).range(0.0, 1.0, Double.valueOf(0.0), Double.valueOf(0.0));
            ((PointComponentImpl)this._pointComponent.bounds(this.chartRect).independentScale(identityScale).dependentScale(identityScale).colorPalette(pointColorPalette).independentAccessor(new SingleValueFunction<Object, Object>(){

                public Object getValue(Object data) {
                    Object d = ((PointDataUtilities.PointDatum)data).originalData();
                    double v1 = ObjectConverter.toDouble((Object)self._categoryScale.scale().getValue(null, self.xAccessor.getValue(d), 0, 0));
                    double v2 = ObjectConverter.toDouble((Object)self._valueScale.scale().getValue(null, self.yAccessor.getValue(d), 0, 0));
                    double value = -1.0 * self._radius * v2 * Math.sin(v1);
                    return value;
                }
            }).dependentAccessor(new SingleValueFunction<Object, Object>(){

                public Object getValue(Object data) {
                    Object d = ((PointDataUtilities.PointDatum)data).originalData();
                    double v1 = ObjectConverter.toDouble((Object)self._categoryScale.scale().getValue(null, self.xAccessor.getValue(d), 0, 0));
                    double v2 = ObjectConverter.toDouble((Object)self._valueScale.scale().getValue(null, self.yAccessor.getValue(d), 0, 0));
                    double value = -1.0 * self._radius * v2 * Math.cos(v1);
                    return value;
                }
            }).setPreExecute(this.context.getPreExecute())).defaultSize(ObjectConverter.toDouble((Object)this.context.getPropertyValue(LINE_WITH_POINTS_SIZE))).symbol(this.getStringProperty(LINE_WITH_POINTS_SYMBOL));
            this._chart.select((Object)"g.element-group").transition("transition").duration((Object)duration).call((RunFunction)this._pointComponent, new Object[0]).attr("transform", (Object)("translate(" + (this.chartRect.x + this.chartRect.width / 2.0) + "," + (this.chartRect.y + this.chartRect.height / 2.0) + ")"));
            ArrayEx<LineDataUtilities.LineDatum> _lineData = LineDataUtilities.buildLines((ArrayEx<Object>)data, this.xAccessor, (SingleValueFunction<Object, Object>)RadarView.domainCheckerOf((List)data, (DataSlotEntry)xEntry), this.yAccessor, (SingleValueFunction<Object, Object>)RadarView.accessorOf((DataSlotEntry)dataSet.slot(DATASLOT_GROUP).entry()));
            LineDataUtilities.sortLines(_lineData, self._categoryScale);
            if (drawOptions.equals("line_points") || drawOptions.equals(LINE_DISPLAY)) {
                this._lineComponent.data(_lineData.toArray());
            } else {
                this._lineComponent.data(null);
            }
            this._pointNPNData = LineDataUtilities.getNPNPoints(_lineData);
            this._pointComponent.data(this._pointNPNData.toArray());
            this._lineComponent.pointsAccessor(LineDataUtilities.POINTS_ACCESSOR).groupAccessor(LineDataUtilities.GROUP_ACCESSOR);
            ((LineComponentImpl)this._lineComponent.independentScale(identityScale).dependentScale(identityScale).colorPalette(pathColorPalette).independentAccessor(new SingleValueFunction<Object, Object>(){

                public Object getValue(Object data) {
                    ArrayEx d = (ArrayEx)data;
                    double v1 = ObjectConverter.toDouble((Object)self._categoryScale.scale().getValue(null, d.get(0), 0, 0));
                    Object obj = d.get(1);
                    double v2 = obj == null ? 0.0 : ObjectConverter.toDouble((Object)self._valueScale.scale().getValue(null, obj, 0, 0));
                    return -1.0 * self._radius * v2 * Math.sin(v1);
                }
            }).dependentAccessor(new SingleValueFunction<Object, Object>(){

                public Object getValue(Object data) {
                    ArrayEx d = (ArrayEx)data;
                    double v1 = ObjectConverter.toDouble((Object)self._categoryScale.scale().getValue(null, d.get(0), 0, 0));
                    Object obj = d.get(1);
                    double v2 = obj == null ? 0.0 : ObjectConverter.toDouble((Object)self._valueScale.scale().getValue(null, obj, 0, 0));
                    return -1.0 * self._radius * v2 * Math.cos(v1);
                }
            }).setPreExecute(this.context.getPreExecute())).effect(effect).interpolate(this.getStringProperty(LINE_INTERPOLATE_PROPERTY));
            this._chart.selectAll("g.element-path").transition().duration((Object)duration).call((RunFunction)this._lineComponent, new Object[0]).attr("transform", (Object)("translate(" + (this.chartRect.x + this.chartRect.width / 2.0) + "," + (this.chartRect.y + this.chartRect.height / 2.0) + ")"));
            Selector lines = this._chart.select((Object)"g.element-path").selectAll("path");
            if (this.getBooleanProperty(FILL_RADAR)) {
                lines.style("fill", (ValueFunction)pathColorPalette).style("fill-opacity", (Object)0.5);
            } else {
                lines.style("fill", (Object)"transparent");
            }
        }
        this._chart.select((Object)"rect.background.elements").attr(DATASLOT_X, (Object)this.chartRect.x).attr(DATASLOT_Y, (Object)this.chartRect.y).attr("width", (Object)this.chartRect.width).attr("height", (Object)this.chartRect.height);
        this.setBackgroundProperties(this.chartRect, duration);
        List spokeDomain = null;
        if (this._categoryScale != null && (spokeDomain = this._categoryScale.originalDomain()) == null) {
            this._categoryScale.scale().domain();
        }
        this._radarBackgroundComponent.ticks(this.ticks.toArray()).bounds(this.chartRect).zoomScale(this.zoomScale).spokeData(spokeDomain == null ? null : spokeDomain.toArray());
        this._chart.select((Object)"g.radarbackground").transition("transition").duration((Object)duration).call((RunFunction)this._radarBackgroundComponent, new Object[0]);
        this.styleAxis();
        this._legends.rectangle(this.legendRect).draw();
        this.resetUpdate();
        this._chart.selectAll(".element-shape").classed("bundle-shape", true);
        this._chart.selectAll(".legendShape").classed("bundle-shape", true);
    }

    public CoordinateScale getCoordinateScale(String role) {
        if ("ROLE_X1".equals(role)) {
            return this._categoryScale;
        }
        if ("ROLE_Y1".equals(role)) {
            return this._valueScale;
        }
        return null;
    }

    private void styleAxis() {
        ValueFunction fmt;
        OMap<String, Object> _labelStyle;
        String labelString;
        if (this.getBooleanProperty("axis.y.line.display")) {
            this._chart.selectAll(".spoke.axis").select((Object)LINE_DISPLAY).style("stroke", this.context.getPropertyValue("axis.y.line.style.stroke")).style("visibility", (Object)"visible");
        } else {
            this._chart.selectAll(".spoke.axis").select((Object)LINE_DISPLAY).style("visibility", (Object)"hidden");
        }
        FontChecker fontChecker = (FontChecker)Rave.capabilities.extension("fontchecker");
        if (this.getBooleanProperty("axis.y.labels.display")) {
            labelString = ObjectConverter.asString((Object)this.context.getPropertyValue("axis.y.labels.style.font"));
            _labelStyle = null;
            if (labelString != null && labelString.length() > 0) {
                _labelStyle = FontPropertyParser.parseCSSFont(labelString);
            }
            Selector yLabels = this._chart.selectAll(".gridline").select((Object)"text").style("visibility", (Object)"visible");
            if (_labelStyle != null) {
                yLabels.style(_labelStyle);
            } else {
                yLabels.style("fill", this.context.getPropertyValue("axis.y.labels.style.fill")).style("font-family", this.context.getPropertyValue("axis.y.labels.style.font-family")).style("font-size", this.context.getPropertyValue("axis.y.labels.style.font-size")).call((RunFunction)fontChecker, new Object[0]);
            }
        } else {
            this._chart.selectAll(".gridline").select((Object)"text").style("visibility", (Object)"hidden");
        }
        if (this.getBooleanProperty("axis.y.ticks.display")) {
            this._chart.selectAll(".grid-tick-line").style("stroke", this.context.getPropertyValue("axis.y.ticks.style.stroke")).style("visibility", (Object)"visible");
        } else {
            this._chart.selectAll(".grid-tick-line").style("visibility", (Object)"hidden");
        }
        if (this.getBooleanProperty("axis.y.gridlines.display")) {
            this._chart.selectAll(".spoke.grid").select((Object)LINE_DISPLAY).style("stroke", this.context.getPropertyValue("axis.y.gridlines.style.stroke")).style("stroke-dasharray", this.context.getPropertyValue("axis.y.gridlines.style.stroke-dasharray")).style("visibility", (Object)"visible");
        } else {
            this._chart.selectAll(".spoke.grid").select((Object)LINE_DISPLAY).style("visibility", (Object)"hidden");
        }
        if (this.getBooleanProperty("axis.x.line.display")) {
            this._chart.selectAll(".gridline.axis").select((Object)"path").style("stroke", this.context.getPropertyValue("axis.x.line.style.stroke")).style("visibility", (Object)"visible");
        } else {
            this._chart.selectAll(".gridline.axis").select((Object)"path").style("stroke", this.context.getPropertyValue("axis.x.line.style.stroke")).style("visibility", (Object)"hidden");
        }
        if (this.getBooleanProperty("axis.x.labels.display")) {
            labelString = ObjectConverter.asString((Object)this.context.getPropertyValue("axis.x.labels.style.font"));
            _labelStyle = null;
            if (labelString != null && labelString.length() > 0) {
                _labelStyle = FontPropertyParser.parseCSSFont(labelString);
            }
            Selector xLabels = this._chart.selectAll(".spoke").select((Object)"text").style("visibility", (Object)"visible");
            if (_labelStyle != null) {
                xLabels.style(_labelStyle);
            } else {
                xLabels.style("fill", this.context.getPropertyValue("axis.x.labels.style.fill")).style("font-family", this.context.getPropertyValue("axis.x.labels.style.font-family")).style("font-size", this.context.getPropertyValue("axis.x.labels.style.font-size")).call((RunFunction)fontChecker, new Object[0]);
            }
        } else {
            this._chart.selectAll(".spoke").select((Object)"text").style("visibility", (Object)"hidden");
        }
        if (this.getBooleanProperty("axis.x.ticks.display")) {
            this._chart.selectAll(".spoke-tick-line").style("stroke", this.context.getPropertyValue("axis.x.ticks.style.stroke")).style("visibility", (Object)"visible");
        } else {
            this._chart.selectAll(".spoke-tick-line").style("visibility", (Object)"hidden");
        }
        if (this.getBooleanProperty("axis.x.gridlines.display")) {
            this._chart.selectAll(".gridline.grid").select((Object)"path").style("stroke", this.context.getPropertyValue("axis.x.gridlines.style.stroke")).style("stroke-dasharray", this.context.getPropertyValue("axis.x.gridlines.style.stroke-dasharray")).style("visibility", (Object)"visible");
        } else {
            this._chart.selectAll(".gridline.grid").select((Object)"path").style("visibility", (Object)"hidden");
        }
        DataSet dataSet = this.dataModel.dataset(DATASET_DATA);
        DataSlotEntry yEntry = dataSet.slot(DATASLOT_Y).entry();
        ArrayEx entries = new ArrayEx();
        if (yEntry != null) {
            entries.add((Object)yEntry);
        }
        if ((fmt = this.context.getCustomFormatterWithFlag(new String[]{"ROLE_Y1", "left", "axis", "all"}, BundleContext.makeCustomFormatInfo((String)"axis-label", (String)"ROLE_Y1", (String)"none", (ArrayEx)entries), null, false)) != null) {
            this._chart.selectAll(".gridline").select((Object)"text").text((ValueFunction)new ValueFunction<SceneNode, Object>(){

                public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                    return fmt.getValue((Object)context, data, index, groupIndex);
                }
            });
        }
    }

    @Override
    protected String[] getGroupStructure() {
        return new String[]{"defs", "g.vizlibrary vizlibrary-radar", "(", "rect.background chart", "g.chart", "(", "g.content", "(", "rect.background elements", "g.radarbackground", "g.elements", "(", "g.element-group", "g.element-path", ")", ")", ")", "g.legends", "(", "g.legends-layout", "g.legend", ")", ")"};
    }
}

