/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.tiledmapBundle;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.bundles.nativeImpl.components.TiledmapNativeSubComponentImpl;
import com.ibm.rave.bundles.views.BundleView;
import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.NodeRect;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.arrays.ES6Map;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.scales.LinearScale;
import com.ibm.rave.core.scales.OrdinalScale;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.library.Library;
import com.ibm.rave.library.action.ActionOperation;
import com.ibm.rave.library.action.BundleUtils;
import com.ibm.rave.library.action.SelectionManager;
import com.ibm.rave.library.action.internal.ActionImpl;
import com.ibm.rave.library.datamodel.DataSet;
import com.ibm.rave.library.datamodel.DataSlotEntry;
import com.ibm.rave.library.framework.Controller;
import com.ibm.rave.library.framework.TiledmapNativeSubComponent;
import com.ibm.rave.library.framework.internal.BundleContext;
import com.ibm.rave.library.framework.internal.BundleDatum;
import com.ibm.rave.library.framework.internal.CSSConverter;
import com.ibm.rave.library.palette.Palette;
import java.util.List;

public class TiledmapView
extends BundleView {
    @InlineStringConstant
    private static final String DATASET_DATA = "data";
    @InlineStringConstant
    private static final String TILEDMAP_TOKEN = "tiledmap.token";
    @InlineStringConstant
    private static final String TILEDMAP_STYLE = "tiledmap.style";
    @InlineStringConstant
    private static final String DATASLOT_FEATUREID = "featureId";
    @InlineStringConstant
    private static final String DATASLOT_FEATUREID_REFINEMENT = "featureIdRefinement";
    @InlineStringConstant
    private static final String DATASLOT_VALUE = "value";
    @InlineStringConstant
    private static final String DATASLOT_POINTSIZE = "pointSize";
    @InlineStringConstant
    private static final String DATASLOT_POINTCOLOR = "pointColor";
    @InlineStringConstant
    private static final String PROP_MINSIZE = "minPointSize";
    @InlineStringConstant
    private static final String PROP_MAXSIZE = "maxPointSize";
    @InlineStringConstant
    private static final String PROP_REGIONTRANS = "color.regionTransparency";
    @InlineStringConstant
    private static final String PROP_POINTTRANS = "color.pointTransparency";
    @InlineStringConstant
    private static final String ELEMENT_SHAPE_SELECTOR = ".element-shape";
    private static final double[][] BASE_BOUNDS = new double[][]{{-180.0, -85.05112}, {180.0, 85.05112}};
    private TiledmapNativeSubComponentImpl _mapComponent;
    private boolean _mapInitialized;
    private TiledmapNativeSubComponent.TiledMapEventCallback _mapInitializedCallback;
    private SingleValueFunction<Object, Object> _featureIDAccessor;
    private SingleValueFunction<Object, Object> _featureIdRefinementAccessor;
    private SingleValueFunction<Object, Object> _pointColorAccessor;
    private SingleValueFunction<Object, Object> _pointSizeAccessor;
    private SelectionManager _selectionManager = new SelectionManager();
    private TiledmapNativeSubComponent.TiledMapEventCallback _updateProjectionCallback;
    private TiledmapNativeSubComponent.TiledMapEventCallback _dragStart;
    private TiledmapNativeSubComponent.TiledMapEventCallback _moveEnd;
    private String _paletteID;
    private Palette _featurePalette;
    private Palette _featureHighlightPalette;
    private Palette _pointPalette;
    private Palette _pointStrokePalette;
    protected LinearScale _pointSizeScale;
    private double _min;
    private double _max;

    protected TiledmapView(BundleContext context) {
        super(context);
    }

    @Override
    public void setup() {
        super.setup();
        final TiledmapView self = this;
        this._selectionManager.onStateChange(new RunFunction<Selection<?>>(){

            public Object run(Selection<?> context, Object ... args) {
                context.filter(BundleUtils.notExit).style("stroke-opacity", (Object)0).style("fill-opacity", (Object)0);
                context.filter(".highlighted").style("stroke-opacity", (Object)1);
                context.filter(".selected").style("stroke-opacity", (Object)1);
                context.filter(".deemphasized").style("fill-opacity", (Object)0.3);
                return null;
            }
        });
        ActionImpl action = this.context.actions.action("highlight");
        action.setOperation(new ActionOperation(){

            public void call(Object ... args) {
                if (self._mapComponent != null) {
                    self._mapComponent.highlightAction((ArrayEx)args[0]);
                }
            }
        });
        action = this.context.actions.action("select");
        action.setOperation(new ActionOperation(){

            public void call(Object ... args) {
                if (self._mapComponent != null) {
                    self._mapComponent.selectAction((ArrayEx)args[0]);
                }
            }
        });
        action = this.context.actions.action("deselect");
        action.setOperation(new ActionOperation(){

            public void call(Object ... args) {
                if (self._mapComponent != null) {
                    self._mapComponent.deselectAction((ArrayEx)args[0]);
                }
            }
        });
        action = this.context.actions.action("deselectAll");
        action.setOperation(new ActionOperation(){

            public void call(Object ... args) {
                if (self._mapComponent != null) {
                    self._mapComponent.deselectAllAction();
                }
            }
        });
    }

    public void on(String eventName, final Controller.BundleEventCallback callback) {
        super.on(eventName, callback);
        this._mapComponent.on(eventName, new TiledmapNativeSubComponent.TiledMapEventCallback(){

            public void onEvent(OMap<String, Object> e) {
                callback.onEvent(e);
            }
        });
    }

    public void draw() {
        LinearScale pointSizeScale;
        String currentPaletteId;
        String accessToken = this.getStringProperty(TILEDMAP_TOKEN);
        if (accessToken == null || accessToken.equals("")) {
            return;
        }
        final TiledmapView self = this;
        this.preDraw("g.vizlibrary-tiledmap");
        this.context.node.selectAll("g.legends").style("pointer-events", (Object)"all");
        if (!this.validateDataModel("*")) {
            return;
        }
        final JSONObject geo = (JSONObject)this.context.getPropertyValue("tiledmap.geoJson");
        final JSONObject featureMeta = (JSONObject)this.context.getPropertyValue("tiledmap.geoJson");
        DataSet dataSet = this.dataModel.dataset(DATASET_DATA);
        DataSlotEntry featureIDDataSlotEntry = dataSet.slot(DATASLOT_FEATUREID).entry();
        DataSlotEntry featureIdRefinementSlotEntry = dataSet.slot(DATASLOT_FEATUREID_REFINEMENT).entry();
        DataSlotEntry pointColorSlotEntry = dataSet.slot(DATASLOT_FEATUREID).entry();
        DataSlotEntry pointSizeSlotEntry = dataSet.slot(DATASLOT_FEATUREID_REFINEMENT).entry();
        final DataSlotEntry valueDataSlotEntry = dataSet.slot(DATASLOT_VALUE).entry();
        final DataSlotEntry pointSizeDataSlotEntry = dataSet.slot(DATASLOT_POINTSIZE).entry();
        DataSlotEntry pointColorDataSlotEntry = dataSet.slot(DATASLOT_POINTCOLOR).entry();
        final ArrayEx data = ObjectConverter.listToArray((List)((List)dataSet.data()));
        ES6Map dataMap = ES6Map.create();
        if (featureIDDataSlotEntry != null) {
            for (int i = 0; i < data.length(); ++i) {
                Object d = data.get(i);
                String id = ObjectConverter.toString((Object)featureIDDataSlotEntry.getValue(d));
                dataMap.set((Object)id, d);
            }
        }
        this._featureIDAccessor = TiledmapView.accessorOf((DataSlotEntry)featureIDDataSlotEntry);
        this._featureIdRefinementAccessor = TiledmapView.accessorOf((DataSlotEntry)featureIdRefinementSlotEntry);
        this._pointColorAccessor = TiledmapView.accessorOf((DataSlotEntry)pointColorDataSlotEntry);
        this._pointSizeAccessor = TiledmapView.accessorOf((DataSlotEntry)pointSizeDataSlotEntry);
        Selector g = this.context.node.select((Object)"g.chart");
        Selector gMap = g.select((Object)"g.map");
        Selector gOverlay = g.select((Object)"g.mapOverlay");
        Selector gPoints = g.select((Object)"g.points");
        final List valueExtent = valueDataSlotEntry != null ? (valueDataSlotEntry.domain() != null ? valueDataSlotEntry.domain() : Rave.extent((Object[])data.toArray(), (ValueFunction)new ValueFunction<Object[], Object>(){

            @SwiftMethodOverload(skipParameters={1})
            public Object getValue(Object[] context, Object data, int index, int groupIndex) {
                return valueDataSlotEntry.getValue(data);
            }
        })) : new ArrayEx(new Object[]{0, 0});
        Object pointSizeDomain = new ArrayEx(new Object[]{0, 0});
        if (pointSizeDataSlotEntry != null) {
            pointSizeDomain = pointSizeDataSlotEntry.domain() != null ? pointSizeDataSlotEntry.domain() : Rave.extent((Object[])data.toArray(), (ValueFunction)new ValueFunction<Object[], Object>(){

                @SwiftMethodOverload(skipParameters={1})
                public Object getValue(Object[] context, Object data, int index, int groupIndex) {
                    return pointSizeDataSlotEntry.getValue(data);
                }
            });
        }
        this._paletteID = currentPaletteId = this.getStringProperty("color.palette");
        this._featurePalette = Library.palettes.getPalette(currentPaletteId);
        this._featurePalette.setData(dataSet, DATASLOT_VALUE);
        this._pointPalette = Library.palettes.getAdjustedColorPalette(this._paletteID, 0.0);
        this._pointPalette.setData(dataSet, DATASLOT_POINTCOLOR);
        NodeRect bb = this._chart.node().getParentNode().getParentNode().getBoundingClientRect();
        this._min = this.evaluateSize(this.getStringProperty(PROP_MINSIZE), bb.width, 10.0);
        this._max = this.evaluateSize(this.getStringProperty(PROP_MAXSIZE), bb.width, 10.0);
        this._pointSizeScale = pointSizeScale = Rave.scale.linear().domain((List)pointSizeDomain).range((List)new ArrayEx(new Object[]{this._min, this._max}));
        ValueFunction<SceneNode, Object> pointSize = new ValueFunction<SceneNode, Object>(){

            @SwiftMethodOverload(skipParameters={1})
            public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                return pointSizeScale.getValue((Object)context, (Object)((TiledMapDatum)data).pointSize, index, groupIndex);
            }
        };
        OrdinalScale nullColorPalette = null;
        if (pointSizeScale != null) {
            Object minValue = pointSizeScale.domain().get(0);
            Object maxValue = pointSizeScale.domain().get(1);
            String nullColor = ObjectConverter.asString((Object)this.context.getPropertyValue("color.null"));
            nullColorPalette = Rave.scale.ordinal().domain((List)new ArrayEx(new Object[]{minValue, maxValue})).range((List)new ArrayEx(new Object[]{nullColor}));
        }
        boolean showLegend = this.isShowLegend();
        String legendPosition = this.getLegendPosition();
        this._legends.visible(showLegend).position(legendPosition).transition(false, 0).setPreExecute(this.context.getPreExecute());
        this._legends.visible(0, showLegend && ObjectConverter.toBoolean((Object)pointSizeDataSlotEntry)).selector(0, this.context.node.selectAll("g.legend.size")).scale(0, (AbstractScale<?, ?>)nullColorPalette).shape(0, "circle").swatchSize(0, new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object _data, int index, int groupIndex) {
                return Math.PI * Math.pow(ObjectConverter.toDouble((double)ObjectConverter.toDouble((Object)pointSizeScale.getValue(null, _data, index, groupIndex))), 2.0);
            }
        }).title(0, this.context.getDataSlotLabel("legend.pointsize.title", pointSizeDataSlotEntry)).titleFill(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fill"))).titleFontSize(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontsize"))).titleFontFamily(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontfamily"))).setDataSlot(0, pointSizeDataSlotEntry);
        this._legends.visible(1, showLegend && ObjectConverter.toBoolean((Object)pointColorDataSlotEntry)).selector(1, this.context.node.selectAll("g.legend.point")).palette(1, this._pointPalette).shape(1, "square").title(1, this.context.getDataSlotLabel("legend.pointcolor.title", pointColorDataSlotEntry)).titleFill(1, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fill"))).titleFontSize(1, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontsize"))).titleFontFamily(1, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontfamily"))).setDataSlot(1, pointColorDataSlotEntry);
        this._legends.visible(2, showLegend && ObjectConverter.toBoolean((Object)valueDataSlotEntry)).selector(2, this.context.node.selectAll("g.legend.region")).palette(2, this._featurePalette).shape(2, "square").title(2, this.context.getDataSlotLabel("legend.regioncolor.title", valueDataSlotEntry)).titleFill(2, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fill"))).titleFontSize(2, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontsize"))).titleFontFamily(2, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontfamily"))).setDataSlot(2, valueDataSlotEntry);
        if (this.updateType <= 1) {
            this.prepareLayoutComponent();
            this.prepareLayoutSizables(this._layoutComponent, false, false, false, false, this._legends.anyVisible());
            this._legends.preLayout(this._layoutComponent);
            this._layoutComponent.layout();
        }
        final RectStruct chartRect = this._layoutComponent.elementRect();
        this._legends.rectangle(this._layoutComponent.legendRect());
        this._legends.draw();
        g.attr("transform", (Object)("translate(" + chartRect.x + "," + chartRect.y + ")"));
        this._clip.clipRect(new RectStruct(1.0, 1.0, chartRect.width - 2.0, chartRect.height - 2.0)).applyTo(g).run((Selection<?>)this.context.node.select((Object)"defs"), new Object[0]);
        final JSONObject jsonPalette = Library.palettes.getJSONPalette(this.getStringProperty("color.palette"));
        final FunctionWrapper updateMapComponent = new FunctionWrapper(){

            @Override
            public void function() {
                self._mapComponent.setContainerRect(chartRect);
                self._mapComponent.setup(self.context.node);
                self._mapComponent.valueAccessor(valueDataSlotEntry);
                self._mapComponent.featureIdAccessor(self._featureIDAccessor);
                self._mapComponent.featureIdRefinementAccessor(self._featureIdRefinementAccessor);
                self._mapComponent.pointColorAccessor(self._pointColorAccessor);
                self._mapComponent.pointSizeAccessor(self._pointSizeAccessor);
                self._mapComponent.setPaletteDef(jsonPalette);
                self._mapComponent.setPalette(self._featurePalette);
                self._mapComponent.setPointPalette(self._pointPalette);
                self._mapComponent.setPointSizeScale(self._pointSizeScale);
                String nullColor = self.getStringProperty("color.null");
                String nullColorDefault = ObjectConverter.toString((Object)self.getPropertyDefault("color.null"));
                self._mapComponent.setNullColor(nullColor.equals("") ? nullColorDefault : nullColor);
                self._mapComponent.setDefaultPointSize(self._min + self._max / 2.0);
                self._mapComponent.setGeoJson(geo);
                self._mapComponent.setFeatureMeta(featureMeta);
                self._mapComponent.setRegionTransparency(20);
                self._mapComponent.setPointTransparency(self.getIntProperty(TiledmapView.PROP_POINTTRANS));
                if (self.updateType == 0) {
                    self._mapComponent.setMapData(data);
                    self._mapComponent.minimumValue(ObjectConverter.toDouble(valueExtent.get(0)));
                    self._mapComponent.maximumValue(ObjectConverter.toDouble(valueExtent.get(1)));
                    self._mapComponent.fire("style.load");
                }
                if (self.updateType <= 1) {
                    self._mapComponent.mapStyle(self.getStringProperty(TiledmapView.TILEDMAP_STYLE));
                }
            }
        };
        if (this._mapComponent == null) {
            gMap.selectAll("*").remove();
            this._mapComponent = new TiledmapNativeSubComponentImpl();
            this._mapComponent.accessToken(accessToken);
            this._mapComponent.setContainerRect(chartRect);
            this._mapComponent.setup(this.context.node);
            this._mapComponent.valueAccessor(valueDataSlotEntry);
            this._mapComponent.featureIdAccessor(this._featureIDAccessor);
            this._mapComponent.featureIdRefinementAccessor(this._featureIdRefinementAccessor);
            this._mapComponent.pointColorAccessor(self._pointColorAccessor);
            this._mapComponent.pointSizeAccessor(self._pointSizeAccessor);
            this._mapComponent.setMapData(data);
            this._mapComponent.minimumValue(ObjectConverter.toDouble(valueExtent.get(0)));
            this._mapComponent.maximumValue(ObjectConverter.toDouble(valueExtent.get(1)));
            this._mapComponent.setGeoJson(geo);
            this._mapComponent.setFeatureMeta(featureMeta);
            this._mapComponent.setPaletteDef(jsonPalette);
            this._mapComponent.setPalette(self._featurePalette);
            this._mapComponent.setPointPalette(self._pointPalette);
            this._mapComponent.setPointSizeScale(self._pointSizeScale);
            String nullColor = this.getStringProperty("color.null");
            String nullColorDefault = ObjectConverter.toString((Object)this.getPropertyDefault("color.null"));
            this._mapComponent.setNullColor(nullColor.equals("") ? nullColorDefault : nullColor);
            this._mapComponent.setDefaultPointSize((this._min + this._max) / 2.0);
            this._mapComponent.setRegionTransparency(20);
            this._mapComponent.setPointTransparency(this.getIntProperty(PROP_POINTTRANS));
            this._mapComponent.draw(gMap);
            this._mapComponent.mapStyle(this.getStringProperty(TILEDMAP_STYLE));
            this._mapComponent.setMaxBounds(BASE_BOUNDS);
            this._mapInitializedCallback = new TiledmapNativeSubComponent.TiledMapEventCallback(){

                public void onEvent(OMap<String, Object> e) {
                    self._mapInitialized = true;
                    self._mapComponent.off("style.load", self._mapInitializedCallback);
                    updateMapComponent.function();
                }
            };
            this._mapComponent.on("style.load", this._mapInitializedCallback);
        } else if (this._mapInitialized) {
            updateMapComponent.function();
        }
        JSONArray features = new JSONArray();
        ArrayEx filteredFeatures = new ArrayEx();
        for (int i = 0; i < features.size(); ++i) {
            String id;
            Object datum;
            JSONObject feature = (JSONObject)features.get(i);
            JSONObject featureProperties = (JSONObject)feature.get((Object)"properties");
            Object name = featureProperties.get((Object)"name");
            if (name == null) {
                name = featureProperties.get((Object)"NAME");
            }
            if ((datum = dataMap.get((Object)(id = ObjectConverter.asString((Object)name)))) == null) continue;
            filteredFeatures.push((Object[])new TiledMapDatum[]{new TiledMapDatum(feature, datum, id, valueDataSlotEntry != null ? ObjectConverter.toDouble((Object)valueDataSlotEntry.getValue(datum)) : 0.0, pointColorDataSlotEntry != null ? ObjectConverter.toDouble((Object)pointColorDataSlotEntry.getValue(datum)) : 0.0, pointSizeDataSlotEntry != null ? ObjectConverter.toDouble((Object)pointSizeDataSlotEntry.getValue(datum)) : 0.0)});
        }
        this.resetUpdate();
    }

    private double evaluateSize(Object value, double extent, double defValue) {
        Double v = CSSConverter.convertCSSSizeToPixelNumber((Object)value, (double)extent, (double)10.0);
        double d = v != null ? v : defValue;
        return Math.max(0.0, Math.min(d, extent));
    }

    @Override
    protected int getLegendCount() {
        return 3;
    }

    @Override
    protected String[] getGroupStructure() {
        return new String[]{"defs", "g.vizlibrary vizlibrary-tiledmap", "(", "rect.background chart", "g.chart", "(", "g.mapOverlay", "g.points", "g.map", ")", "g.legends", "(", "g.legends-layout", "g.legend size", "g.legend point", "g.legend region", ")", ")"};
    }

    @FunctionClass(value="function")
    private static interface FunctionWrapper {
        public void function();
    }

    private static final class TiledMapDatum
    implements BundleDatum {
        public Object data;
        public JSONObject feature;
        public String id;
        public Double value;
        public Double pointColor;
        public Double pointSize;
        public double[] centroid;

        public TiledMapDatum(JSONObject feature, Object data, String id, Double value, Double pointColor, Double pointSize) {
            this.data = data;
            this.feature = feature;
            this.id = id;
            this.value = value;
            this.pointColor = pointColor;
            this.pointSize = pointSize;
            this.centroid = Rave.geo.centroid(feature);
        }

        public Object originalData() {
            return this.data;
        }

        public List<Object> originalDataList() {
            return new ArrayEx(new Object[]{this.data});
        }
    }
}

