/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.tiledmapV2Bundle;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.bundles.RaveBundle;
import com.ibm.rave.bundles.tiledmapV2Bundle.TiledmapV2View;
import com.ibm.rave.core.ExtensionFactory;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.nativeImpl.xhr.Xhr;
import com.ibm.rave.core.nativeImpl.xhr.XhrResult;
import com.ibm.rave.library.Library;
import com.ibm.rave.library.framework.Bundle;
import com.ibm.rave.library.framework.Controller;
import com.ibm.rave.library.framework.internal.AbstractView;
import com.ibm.rave.library.framework.internal.BundleContext;
import com.ibm.rave.library.framework.meta.PropertyMeta;
import com.ibm.rave.library.i18n.Messages;
import com.ibm.rave.library.i18n.MessagesRegistry;
import com.ibm.rave.library.property.StringPropertyOption;

public class TiledmapV2Bundle
extends RaveBundle {
    private static final String BUNDLE_NAME = "tiledmapV2Bundle";
    private String mapboxSecretToken = null;
    private String mapboxAccoutName = null;
    private String mapboxtoken = "";

    private TiledmapV2Bundle() {
    }

    public static String init() {
        if (!Library.bundle.isRegistered(BUNDLE_NAME)) {
            final TiledmapV2Bundle[] bundle = new TiledmapV2Bundle[1];
            Library.bundle.extension(BUNDLE_NAME, (ExtensionFactory)new ExtensionFactory<TiledmapV2Bundle>(){

                public TiledmapV2Bundle create() {
                    if (bundle[0] == null) {
                        bundle[0] = new TiledmapV2Bundle();
                        bundle[0].loadResources();
                        bundle[0].loader.requireCSS("./mapbox-gl.css");
                        bundle[0].loader.requireCSS("./vizlibrary-tiledmap.css");
                    }
                    return bundle[0];
                }
            });
        }
        return BUNDLE_NAME;
    }

    protected String getName() {
        return BUNDLE_NAME;
    }

    protected AbstractView createView(BundleContext ctx) {
        ctx.properties.property("tiledmap.token").value((Object)this.mapboxtoken);
        return new TiledmapV2View(ctx);
    }

    protected void _doConfigure(JSONObject configurations, final Controller.Callback userCallback, final Bundle bundle) {
        if (configurations != null) {
            this.mapboxSecretToken = (String)configurations.get((Object)"Mapbox.secretToken");
            this.mapboxAccoutName = (String)configurations.get((Object)"Mapbox.accountName");
            this.mapboxtoken = (String)configurations.get((Object)"Mapbox.token");
        }
        if (this.mapboxSecretToken != null && this.mapboxAccoutName != null) {
            String requestURL = "https://api.mapbox.com/styles/v1/" + this.mapboxAccoutName + "?access_token=" + this.mapboxSecretToken;
            final TiledmapV2Bundle self = this;
            Rave.json.create(requestURL, (Xhr.Callback)new Xhr.Callback<JSONArtifact>(){

                public void callback(XhrResult error, final JSONArtifact response) {
                    if (response != null) {
                        ArrayEx properties = bundle.info().properties();
                        properties.forEach((ArrayEx.ArrayValueFunction)new ArrayEx.ArrayValueFunction<PropertyMeta, Object>(){

                            public Object getValue(PropertyMeta currentValue, int index, ArrayEx<PropertyMeta> array) {
                                if (currentValue.simpleId().equals("style")) {
                                    JSONArray responseArray = (JSONArray)response;
                                    for (Object obj : responseArray) {
                                        JSONObject style = (JSONObject)obj;
                                        String styleID = ObjectConverter.toString((Object)style.get((Object)"id"));
                                        String styleName = ObjectConverter.toString((Object)style.get((Object)"name"));
                                        String value = "mapbox://style/" + self.mapboxAccoutName + "/" + styleID;
                                        JSONObject catalogEntry = new JSONObject();
                                        MessagesRegistry messages = new MessagesRegistry();
                                        Messages catalog = null;
                                        StringPropertyOption newOption = null;
                                        catalogEntry.put((Object)styleID, (Object)styleName);
                                        catalog = Messages.createFromCatalog((JSONObject)catalogEntry, (String)bundle.locale());
                                        messages.add(bundle.locale(), catalog);
                                        newOption = new StringPropertyOption(value, ObjectConverter.toString((Object)style.get((Object)"id")), messages);
                                        currentValue.options().add(newOption);
                                        if (!styleName.equals("Default")) continue;
                                        currentValue.setDefaultValue((Object)value);
                                    }
                                }
                                return currentValue;
                            }
                        });
                    }
                    if (userCallback != null) {
                        userCallback.callback();
                    }
                }
            });
        } else if (userCallback != null) {
            userCallback.callback();
        }
    }
}

