/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.tiledmapV2Bundle;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.bundles.nativeImpl.components.TiledmapV2DataLayerImpl;
import com.ibm.rave.bundles.nativeImpl.components.TiledmapV2NativeSubComponentImpl;
import com.ibm.rave.bundles.nativeImpl.components.TiledmapV2PointTypeDataImpl;
import com.ibm.rave.bundles.nativeImpl.components.TiledmapV2RegionTypeDataImpl;
import com.ibm.rave.bundles.views.BundleView;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.NodeRect;
import com.ibm.rave.core.geom.Point;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.scales.LinearScale;
import com.ibm.rave.core.scales.OrdinalScale;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.library.Library;
import com.ibm.rave.library.action.ActionOperation;
import com.ibm.rave.library.action.internal.ActionImpl;
import com.ibm.rave.library.datamodel.DataSet;
import com.ibm.rave.library.datamodel.DataSlotEntry;
import com.ibm.rave.library.framework.Controller;
import com.ibm.rave.library.framework.TiledmapV2DataLayer;
import com.ibm.rave.library.framework.TiledmapV2Locator;
import com.ibm.rave.library.framework.TiledmapV2NativeSubComponent;
import com.ibm.rave.library.framework.TiledmapV2State;
import com.ibm.rave.library.framework.internal.BundleContext;
import com.ibm.rave.library.framework.internal.CSSConverter;
import com.ibm.rave.library.palette.Palette;
import java.util.ArrayList;
import java.util.List;

public class TiledmapV2View
extends BundleView {
    @InlineStringConstant
    private static final String DATASET_DATA = "data";
    @InlineStringConstant
    private static final String DATASET_DATA_REGION = "data.region";
    @InlineStringConstant
    private static final String DATASET_DATA_POINT = "data.point";
    @InlineStringConstant
    private static final String DATASET_DATA_LATLONG = "data.latlong";
    @InlineStringConstant
    private static final String TILEDMAP_TOKEN = "tiledmap.token";
    @InlineStringConstant
    private static final String TILEDMAP_STYLE = "tiledmap.style";
    @InlineStringConstant
    private static final String TILEDMAP_GEOJSON = "tiledmap.geoJson";
    @InlineStringConstant
    private static final String TILEDMAP_MAXZOOM = "tiledmap.maxZoom";
    @InlineStringConstant
    private static final String TILEDMAP_MAPLOCALE = "tiledmap.mapLocale";
    @InlineStringConstant
    private static final String TILEDMAP_AUTOZOOM = "tiledmap.autoZoom";
    @InlineStringConstant
    private static final String DATASLOT_FEATURE_LVL1 = "featureLvl1";
    @InlineStringConstant
    private static final String DATASLOT_FEATURE_LVL2 = "featureLvl2";
    @InlineStringConstant
    private static final String DATASLOT_FEATURE_LVL3 = "featureLvl3";
    @InlineStringConstant
    private static final String DATASLOT_LATITUDE = "latitude";
    @InlineStringConstant
    private static final String DATASLOT_LONGITUDE = "longitude";
    @InlineStringConstant
    private static final String DATASLOT_LABEL = "label";
    @InlineStringConstant
    private static final String DATASLOT_VALUE = "value";
    @InlineStringConstant
    private static final String DATASLOT_FILL = "fill";
    @InlineStringConstant
    private static final String DATASLOT_POINTSIZE = "pointSize";
    @InlineStringConstant
    private static final String DATASLOT_POINTCOLOR = "pointColor";
    @InlineStringConstant
    private static final String DATASLOT_LATLONG_POINTSIZE = "latlongSize";
    @InlineStringConstant
    private static final String DATASLOT_LATLONG_POINTCOLOR = "latlongColor";
    @InlineStringConstant
    private static final String PROP_MINSIZE = "minPointSize";
    @InlineStringConstant
    private static final String PROP_MAXSIZE = "maxPointSize";
    @InlineStringConstant
    private static final String PROP_STATICZEROVALUEPOINTSIZE = "staticZeroValuePointSize";
    @InlineStringConstant
    private static final String PROP_FILLTRANS = "color.fillTransparency";
    @InlineStringConstant
    private static final String PROP_POINTTRANS = "color.pointTransparency";
    @InlineStringConstant
    private static final String PROP_REGION_PALETTE = "region.palette";
    @InlineStringConstant
    private static final String PROP_REGION_TRANSPARENCY = "region.transparency";
    @InlineStringConstant
    private static final String PROP_REGION_MAPDATA = "region.mapData";
    @InlineStringConstant
    private static final String PROP_REGION_CUSTOM_MAPID = "region.custom.mapId";
    @InlineStringConstant
    private static final String PROP_REGION_CUSTOM_LAYERNAME = "region.custom.layerName";
    @InlineStringConstant
    private static final String PROP_REGION_CUSTOM_PROPERTYNAME = "region.custom.propertyName";
    @InlineStringConstant
    private static final String PROP_POINT_PALETTE = "point.palette";
    @InlineStringConstant
    private static final String PROP_POINT_TRANSPARENCY = "point.transparency";
    @InlineStringConstant
    private static final String PROP_POINT_MAPDATA = "point.mapData";
    @InlineStringConstant
    private static final String PROP_POINT_MINSIZE = "point.minSize";
    @InlineStringConstant
    private static final String PROP_POINT_MAXSIZE = "point.maxSize";
    @InlineStringConstant
    private static final String PROP_POINT_DEFAULTSIZE = "point.defaultSize";
    @InlineStringConstant
    private static final String PROP_POINT_STATICZEROVALUESIZE = "point.staticZeroValueSize";
    @InlineStringConstant
    private static final String PROP_POINT_CUSTOM_MAPID = "point.custom.mapId";
    @InlineStringConstant
    private static final String PROP_POINT_CUSTOM_LAYERNAME = "point.custom.layerName";
    @InlineStringConstant
    private static final String PROP_POINT_CUSTOM_PROPERTYNAME = "point.custom.propertyName";
    @InlineStringConstant
    private static final String PROP_POINT_LEGEND_SIZE_TITLE = "legend.pointsize.title";
    @InlineStringConstant
    private static final String PROP_POINT_LEGEND_COLOR_TITLE = "legend.pointcolor.title";
    @InlineStringConstant
    private static final String SELECTOR_POINTSIZE_LEGEND = "g.legend.size";
    @InlineStringConstant
    private static final String SELECTOR_POINTCOLOR_LEGEND = "g.legend.point";
    @InlineStringConstant
    private static final String PROP_LATLONG_PALETTE = "latlong.palette";
    @InlineStringConstant
    private static final String PROP_LATLONG_TRANSPARENCY = "latlong.transparency";
    @InlineStringConstant
    private static final String PROP_LATLONG_MINSIZE = "latlong.minSize";
    @InlineStringConstant
    private static final String PROP_LATLONG_MAXSIZE = "latlong.maxSize";
    @InlineStringConstant
    private static final String PROP_LATLONG_DEFAULTSIZE = "latlong.defaultSize";
    @InlineStringConstant
    private static final String PROP_LATLONG_STATICZEROVALUESIZE = "latlong.staticZeroValueSize";
    @InlineStringConstant
    private static final String PROP_LATLONG_LEGEND_SIZE_TITLE = "legend.latlong.pointsize.title";
    @InlineStringConstant
    private static final String PROP_LATLONG_LEGEND_COLOR_TITLE = "legend.latlong.pointcolor.title";
    @InlineStringConstant
    private static final String SELECTOR_LATLONG_POINTSIZE_LEGEND = "g.legend.latlongSize";
    @InlineStringConstant
    private static final String SELECTOR_LATLONG_POINTCOLOR_LEGEND = "g.legend.latlongPoint";
    @InlineStringConstant
    private static final String ELEMENT_SHAPE_SELECTOR = ".element-shape";
    @InlineStringConstant
    private static final String NORM_DATASLOT_FEATURE_LVL1 = "featureLvl1";
    @InlineStringConstant
    private static final String NORM_DATASLOT_FEATURE_LVL2 = "featureLvl2";
    @InlineStringConstant
    private static final String NORM_DATASLOT_FEATURE_LVL3 = "featureLvl3";
    @InlineStringConstant
    private static final String NORM_DATASLOT_FILL = "fill";
    @InlineStringConstant
    private static final String NORM_DATASLOT_POINTSIZE = "pointSize";
    @InlineStringConstant
    private static final String NORM_DATASLOT_POINTCOLOR = "pointColor";
    @InlineStringConstant
    private static final String NORM_PROP_REGION_PALETTE = "region.palette";
    @InlineStringConstant
    private static final String NORM_PROP_REGION_ALT_PALETTE = "region.alt.palette";
    @InlineStringConstant
    private static final String NORM_PROP_REGION_TRANSPARENCY = "region.transparency";
    @InlineStringConstant
    private static final String NORM_PROP_REGION_MAPDATA = "region.mapData";
    @InlineStringConstant
    private static final String NORM_PROP_REGION_CUSTOM_MAPID = "region.custom.mapId";
    @InlineStringConstant
    private static final String NORM_PROP_REGION_CUSTOM_LAYERNAME = "region.custom.layerName";
    @InlineStringConstant
    private static final String NORM_PROP_REGION_CUSTOM_PROPERTYNAME = "region.custom.propertyName";
    @InlineStringConstant
    private static final String NORM_PROP_POINT_PALETTE = "point.palette";
    @InlineStringConstant
    private static final String NORM_PROP_POINT_ALT_PALETTE = "point.alt.palette";
    @InlineStringConstant
    private static final String NORM_PROP_POINT_TRANSPARENCY = "point.transparency";
    @InlineStringConstant
    private static final String NORM_PROP_POINT_MAPDATA = "point.mapData";
    @InlineStringConstant
    private static final String NORM_PROP_POINT_MINSIZE = "point.minSize";
    @InlineStringConstant
    private static final String NORM_PROP_POINT_MAXSIZE = "point.maxSize";
    @InlineStringConstant
    private static final String NORM_PROP_POINT_DEFAULTSIZE = "point.defaultSize";
    @InlineStringConstant
    private static final String NORM_PROP_POINT_STATICZEROVALUESIZE = "point.staticZeroValueSize";
    @InlineStringConstant
    private static final String NORM_PROP_POINT_CUSTOM_MAPID = "point.custom.mapId";
    @InlineStringConstant
    private static final String NORM_PROP_POINT_CUSTOM_LAYERNAME = "point.custom.layerName";
    @InlineStringConstant
    private static final String NORM_PROP_POINT_CUSTOM_PROPERTYNAME = "point.custom.propertyName";
    @InlineStringConstant
    private static final String NORM_PROP_LEGEND_SIZE_TITLE = "legend.pointsize.title";
    @InlineStringConstant
    private static final String NORM_PROP_LEGEND_COLOR_TITLE = "legend.pointcolor.title";
    @InlineStringConstant
    private static final String NORM_LEGEND_POINTSIZE = "pointSize";
    @InlineStringConstant
    private static final String NORM_LEGEND_POINTCOLOR = "pointColor";
    @InlineStringConstant
    private static final String NORM_SELECTOR_POINTSIZE_LEGEND = "sizeLegend";
    @InlineStringConstant
    private static final String NORM_SELECTOR_POINTCOLOR_LEGEND = "colorLegend";
    @InlineStringConstant
    private static final String TYPE_REGION = "region";
    @InlineStringConstant
    private static final String TYPE_POINT = "point";
    private static final double[][] BASE_BOUNDS = new double[][]{{-180.0, -85.05112}, {180.0, 85.05112}};
    private static final int LEGEND_POINTSIZE = 0;
    private static final int LEGEND_POINTCOLOR = 1;
    private static final int LEGEND_LATLONG_POINTSIZE = 2;
    private static final int LEGEND_LATLONG_POINTCOLOR = 3;
    private static final int LEGEND_REGIONCOLOR = 4;
    private TiledmapV2NativeSubComponentImpl _mapComponent;
    private boolean _mapInitialized;
    private TiledmapV2NativeSubComponent.TiledMapEventCallback _mapInitializedCallback;
    private Integer _maxZoom;
    private String _mapLocale;
    private String _mapStyle;
    private ArrayEx<EventHandler> _registeredEventHandlers;
    private RectStruct _lastChartRect;
    private OMap<String, String> _combinedLayerMapping;
    private OMap<String, String> _regionLayerMapping;
    private OMap<String, String> _pointLayerMapping;
    private OMap<String, String> _latlongLayerMapping;
    private OMap<String, Integer> _combinedLegendMapping;
    private OMap<String, Integer> _pointLegendMapping;
    private OMap<String, Integer> _latlongLegendMapping;
    private DelayedInit _delayedInit;

    protected TiledmapV2View(BundleContext context) {
        super(context);
    }

    @Override
    public void setup() {
        super.setup();
        final TiledmapV2View self = this;
        ActionImpl action = this.context.actions.action("highlight");
        action.setOperation(new ActionOperation(){

            public void call(Object ... args) {
                if (self._mapComponent != null) {
                    self._mapComponent.highlightAction((ArrayEx)args[0]);
                }
            }
        });
        action = this.context.actions.action("select");
        action.setOperation(new ActionOperation(){

            public void call(Object ... args) {
                if (self._mapComponent != null) {
                    self._mapComponent.selectAction((ArrayEx)args[0]);
                }
            }
        });
        action = this.context.actions.action("deselect");
        action.setOperation(new ActionOperation(){

            public void call(Object ... args) {
                if (self._mapComponent != null) {
                    self._mapComponent.deselectAction((ArrayEx)args[0]);
                }
            }
        });
        action = this.context.actions.action("deselectAll");
        action.setOperation(new ActionOperation(){

            public void call(Object ... args) {
                if (self._mapComponent != null) {
                    self._mapComponent.deselectAllAction();
                }
            }
        });
        action = this.context.actions.action("locate");
        action.setOperation(new ActionOperation(){

            public TiledmapV2Locator get(String _id) {
                if (_id.equals("locator")) {
                    return new TiledmapV2Locator(){

                        public ArrayEx getItemsAtPoint(Point _point) {
                            if (self._mapComponent != null) {
                                return self._mapComponent.getItemsAtPoint(_point);
                            }
                            return new ArrayEx();
                        }

                        public ArrayEx getItemsInRect(Point[] _points) {
                            if (self._mapComponent != null) {
                                return self._mapComponent.getItemsInRect(_points);
                            }
                            return new ArrayEx();
                        }
                    };
                }
                return null;
            }

            public void call(Object ... args) {
            }
        });
        action = this.context.actions.action("zoom");
        action.setOperation(new ActionOperation(){

            public TiledmapV2State get(String _id) {
                if (_id.equals("state")) {
                    return new TiledmapV2State(){

                        public Point[] getBoundingBox() {
                            if (self._mapComponent != null) {
                                return self._mapComponent.getBoundingBox();
                            }
                            return null;
                        }

                        public void setBoundingBox(Point[] _bbox) {
                            if (self._mapComponent != null) {
                                self._mapComponent.setBoundingBox(_bbox);
                            }
                        }
                    };
                }
                return null;
            }

            public void call(Object ... args) {
            }
        });
        this._combinedLayerMapping = new OMap();
        this._combinedLayerMapping.put((Object)"featureLvl1", (Object)"featureLvl1");
        this._combinedLayerMapping.put((Object)"featureLvl2", (Object)"featureLvl2");
        this._combinedLayerMapping.put((Object)"featureLvl3", (Object)"featureLvl3");
        this._combinedLayerMapping.put((Object)"fill", (Object)DATASLOT_VALUE);
        this._combinedLayerMapping.put((Object)"pointSize", (Object)"pointSize");
        this._combinedLayerMapping.put((Object)"pointColor", (Object)"pointColor");
        this._combinedLayerMapping.put((Object)"region.palette", (Object)"color.palette");
        this._combinedLayerMapping.put((Object)NORM_PROP_REGION_ALT_PALETTE, (Object)"region.palette");
        this._combinedLayerMapping.put((Object)"region.transparency", (Object)PROP_FILLTRANS);
        this._combinedLayerMapping.put((Object)"region.mapData", (Object)"region.mapData");
        this._combinedLayerMapping.put((Object)"region.custom.mapId", (Object)"region.custom.mapId");
        this._combinedLayerMapping.put((Object)"region.custom.layerName", (Object)"region.custom.layerName");
        this._combinedLayerMapping.put((Object)"region.custom.propertyName", (Object)"region.custom.propertyName");
        this._combinedLayerMapping.put((Object)"point.palette", (Object)"color.palette");
        this._combinedLayerMapping.put((Object)NORM_PROP_POINT_ALT_PALETTE, (Object)"point.palette");
        this._combinedLayerMapping.put((Object)"point.transparency", (Object)PROP_POINTTRANS);
        this._combinedLayerMapping.put((Object)"point.mapData", (Object)"point.mapData");
        this._combinedLayerMapping.put((Object)"point.minSize", (Object)PROP_MINSIZE);
        this._combinedLayerMapping.put((Object)"point.maxSize", (Object)PROP_MAXSIZE);
        this._combinedLayerMapping.put((Object)"point.defaultSize", (Object)"point.defaultSize");
        this._combinedLayerMapping.put((Object)"point.staticZeroValueSize", (Object)PROP_STATICZEROVALUEPOINTSIZE);
        this._combinedLayerMapping.put((Object)"point.custom.mapId", (Object)"point.custom.mapId");
        this._combinedLayerMapping.put((Object)"point.custom.layerName", (Object)"point.custom.layerName");
        this._combinedLayerMapping.put((Object)"point.custom.propertyName", (Object)"point.custom.propertyName");
        this._combinedLayerMapping.put((Object)"legend.pointsize.title", (Object)"legend.pointsize.title");
        this._combinedLayerMapping.put((Object)"legend.pointcolor.title", (Object)"legend.pointcolor.title");
        this._combinedLegendMapping = new OMap();
        this._combinedLegendMapping.put((Object)"pointSize", (Object)0);
        this._combinedLegendMapping.put((Object)"pointColor", (Object)1);
        this._regionLayerMapping = new OMap();
        this._regionLayerMapping.put((Object)"featureLvl1", (Object)"featureLvl1");
        this._regionLayerMapping.put((Object)"featureLvl2", (Object)"featureLvl2");
        this._regionLayerMapping.put((Object)"featureLvl3", (Object)"featureLvl3");
        this._regionLayerMapping.put((Object)"fill", (Object)"fill");
        this._regionLayerMapping.put((Object)"region.palette", (Object)"region.palette");
        this._regionLayerMapping.put((Object)NORM_PROP_REGION_ALT_PALETTE, (Object)"region.palette");
        this._regionLayerMapping.put((Object)"region.transparency", (Object)"region.transparency");
        this._regionLayerMapping.put((Object)"region.mapData", (Object)"region.mapData");
        this._regionLayerMapping.put((Object)"region.custom.mapId", (Object)"region.custom.mapId");
        this._regionLayerMapping.put((Object)"region.custom.layerName", (Object)"region.custom.layerName");
        this._regionLayerMapping.put((Object)"region.custom.propertyName", (Object)"region.custom.propertyName");
        this._pointLayerMapping = new OMap();
        this._pointLayerMapping.put((Object)"featureLvl1", (Object)"featureLvl1");
        this._pointLayerMapping.put((Object)"featureLvl2", (Object)"featureLvl2");
        this._pointLayerMapping.put((Object)"featureLvl3", (Object)"featureLvl3");
        this._pointLayerMapping.put((Object)"pointSize", (Object)"pointSize");
        this._pointLayerMapping.put((Object)"pointColor", (Object)"pointColor");
        this._pointLayerMapping.put((Object)"point.palette", (Object)"point.palette");
        this._pointLayerMapping.put((Object)NORM_PROP_POINT_ALT_PALETTE, (Object)"point.palette");
        this._pointLayerMapping.put((Object)"point.transparency", (Object)"point.transparency");
        this._pointLayerMapping.put((Object)"point.mapData", (Object)"point.mapData");
        this._pointLayerMapping.put((Object)"point.minSize", (Object)"point.minSize");
        this._pointLayerMapping.put((Object)"point.maxSize", (Object)"point.maxSize");
        this._pointLayerMapping.put((Object)"point.defaultSize", (Object)"point.defaultSize");
        this._pointLayerMapping.put((Object)"point.staticZeroValueSize", (Object)"point.staticZeroValueSize");
        this._pointLayerMapping.put((Object)"point.custom.mapId", (Object)"point.custom.mapId");
        this._pointLayerMapping.put((Object)"point.custom.layerName", (Object)"point.custom.layerName");
        this._pointLayerMapping.put((Object)"point.custom.propertyName", (Object)"point.custom.propertyName");
        this._pointLayerMapping.put((Object)"legend.pointsize.title", (Object)"legend.pointsize.title");
        this._pointLayerMapping.put((Object)"legend.pointcolor.title", (Object)"legend.pointcolor.title");
        this._pointLayerMapping.put((Object)NORM_SELECTOR_POINTSIZE_LEGEND, (Object)SELECTOR_POINTSIZE_LEGEND);
        this._pointLayerMapping.put((Object)NORM_SELECTOR_POINTCOLOR_LEGEND, (Object)SELECTOR_POINTCOLOR_LEGEND);
        this._pointLegendMapping = new OMap();
        this._pointLegendMapping.put((Object)"pointSize", (Object)0);
        this._pointLegendMapping.put((Object)"pointColor", (Object)1);
        this._latlongLayerMapping = new OMap();
        this._latlongLayerMapping.put((Object)"pointSize", (Object)DATASLOT_LATLONG_POINTSIZE);
        this._latlongLayerMapping.put((Object)"pointColor", (Object)DATASLOT_LATLONG_POINTCOLOR);
        this._latlongLayerMapping.put((Object)"point.palette", (Object)PROP_LATLONG_PALETTE);
        this._latlongLayerMapping.put((Object)NORM_PROP_POINT_ALT_PALETTE, (Object)PROP_LATLONG_PALETTE);
        this._latlongLayerMapping.put((Object)"point.transparency", (Object)PROP_LATLONG_TRANSPARENCY);
        this._latlongLayerMapping.put((Object)"point.minSize", (Object)PROP_LATLONG_MINSIZE);
        this._latlongLayerMapping.put((Object)"point.maxSize", (Object)PROP_LATLONG_MAXSIZE);
        this._latlongLayerMapping.put((Object)"point.defaultSize", (Object)PROP_LATLONG_DEFAULTSIZE);
        this._latlongLayerMapping.put((Object)"point.staticZeroValueSize", (Object)PROP_LATLONG_STATICZEROVALUESIZE);
        this._latlongLayerMapping.put((Object)"legend.pointsize.title", (Object)PROP_LATLONG_LEGEND_SIZE_TITLE);
        this._latlongLayerMapping.put((Object)"legend.pointcolor.title", (Object)PROP_LATLONG_LEGEND_COLOR_TITLE);
        this._latlongLayerMapping.put((Object)NORM_SELECTOR_POINTSIZE_LEGEND, (Object)SELECTOR_LATLONG_POINTSIZE_LEGEND);
        this._latlongLayerMapping.put((Object)NORM_SELECTOR_POINTCOLOR_LEGEND, (Object)SELECTOR_LATLONG_POINTCOLOR_LEGEND);
        this._latlongLegendMapping = new OMap();
        this._latlongLegendMapping.put((Object)"pointSize", (Object)2);
        this._latlongLegendMapping.put((Object)"pointColor", (Object)3);
        this._registeredEventHandlers = new ArrayEx();
        this._delayedInit = null;
    }

    public void dispose() {
        if (this._mapComponent != null) {
            this._mapComponent.dispose();
        }
    }

    public void on(String _eventName, final Controller.BundleEventCallback _callback) {
        super.on(_eventName, _callback);
        if (this._mapComponent != null) {
            this._mapComponent.on(_eventName, new TiledmapV2NativeSubComponent.TiledMapEventCallback(){

                public void onEvent(OMap<String, Object> _e) {
                    _callback.onEvent(_e);
                }
            });
        }
        this._registeredEventHandlers.add((Object)new EventHandler(_eventName, _callback));
    }

    public void draw() {
        DataSlotEntry dseFeatureLvl3;
        DataSlotEntry dseFeatureLvl2;
        DataSlotEntry dseFeatureLvl1;
        String accessToken = this.getStringProperty(TILEDMAP_TOKEN);
        if (accessToken == null || accessToken.equals("")) {
            return;
        }
        final TiledmapV2View self = this;
        this.preDraw("g.vizlibrary-tiledmap");
        this.context.node.selectAll("g.legends").style("pointer-events", (Object)"all");
        if (!this.validateDataModel("*")) {
            return;
        }
        String legendPosition = this.getLegendPosition();
        boolean showLegend = this.isShowLegend();
        this._legends.visible(showLegend).position(legendPosition).transition(false, 0).setPreExecute(this.context.getPreExecute());
        Integer maxZoom = (Integer)this.getProperty(TILEDMAP_MAXZOOM);
        String mapLocale = this.getStringPropertyEmptyAsNull(TILEDMAP_MAPLOCALE);
        if (mapLocale == null) {
            mapLocale = this.context.locale();
        }
        String mapStyle = this.getStringProperty(TILEDMAP_STYLE);
        boolean combinedLayers = false;
        ArrayEx dataLayers = new ArrayEx();
        if (this.dataModel.getDescriptor().id().equals("tabular")) {
            combinedLayers = true;
            DataSet combinedDataSet = this.dataModel.dataset(DATASET_DATA);
            ArrayEx data = ObjectConverter.listToArray((List)((List)combinedDataSet.data()));
            Object geoJson = this.getProperty(TILEDMAP_GEOJSON);
            JSONArray mapData = null;
            if (geoJson != null) {
                mapData = geoJson instanceof JSONArray ? (JSONArray)geoJson : (JSONArray)((JSONObject)geoJson).get((Object)"mapboxData");
            }
            TiledmapV2DataLayerImpl dataLayer = new TiledmapV2DataLayerImpl(DATASET_DATA);
            dataLayers.add((Object)dataLayer);
            dataLayer.setData(data);
            dataLayer.setMapData(mapData);
            dseFeatureLvl1 = combinedDataSet.slot((String)this._combinedLayerMapping.get((Object)"featureLvl1")).entry();
            dseFeatureLvl2 = combinedDataSet.slot((String)this._combinedLayerMapping.get((Object)"featureLvl2")).entry();
            dseFeatureLvl3 = combinedDataSet.slot((String)this._combinedLayerMapping.get((Object)"featureLvl3")).entry();
            DataSlotEntry dsePointSize = combinedDataSet.slot((String)this._combinedLayerMapping.get((Object)"pointSize")).entry();
            DataSlotEntry dsePointColor = combinedDataSet.slot((String)this._combinedLayerMapping.get((Object)"pointColor")).entry();
            ArrayList<SingleValueFunction> featureAccessors = new ArrayList<SingleValueFunction>();
            featureAccessors.add(TiledmapV2View.accessorOf((DataSlotEntry)dseFeatureLvl1));
            featureAccessors.add(TiledmapV2View.accessorOf((DataSlotEntry)dseFeatureLvl2));
            featureAccessors.add(TiledmapV2View.accessorOf((DataSlotEntry)dseFeatureLvl3));
            dataLayer.setFeatureAccessors((ArrayEx<Object>)((ArrayEx)featureAccessors));
            if (dseFeatureLvl1 != null) {
                this._setupRegionDataLayer(dataLayer, combinedDataSet, (ArrayEx<Object>)data, this._combinedLayerMapping, false, showLegend);
            } else {
                this._legends.visible(4, false);
            }
            if (dseFeatureLvl1 != null && (dsePointSize != null || dsePointColor != null)) {
                this._setupPointDataLayer(dataLayer, combinedDataSet, (ArrayEx<Object>)data, this._combinedLayerMapping, this._pointLegendMapping, false, showLegend);
            } else {
                this._legends.visible(0, false);
                this._legends.visible(1, false);
            }
            this._legends.visible(2, false);
            this._legends.visible(3, false);
        } else if (this.dataModel.getDescriptor().id().equals("multiTable")) {
            ArrayList<Object> featureAccessors;
            boolean hasGeo;
            ArrayEx data;
            DataSet regionDataSet = this.dataModel.dataset(DATASET_DATA_REGION);
            DataSet pointDataSet = this.dataModel.dataset(DATASET_DATA_POINT);
            DataSet latlongDataSet = this.dataModel.dataset(DATASET_DATA_LATLONG);
            if (regionDataSet.data() != null) {
                data = ObjectConverter.listToArray((List)((List)regionDataSet.data()));
                TiledmapV2DataLayerImpl regionLayer = new TiledmapV2DataLayerImpl(DATASET_DATA_REGION);
                dataLayers.add((Object)regionLayer);
                regionLayer.setData(data);
                regionLayer.setMapData((JSONArray)this.getProperty((String)this._regionLayerMapping.get((Object)"region.mapData")));
                dseFeatureLvl1 = regionDataSet.slot((String)this._regionLayerMapping.get((Object)"featureLvl1")).entry();
                dseFeatureLvl2 = regionDataSet.slot((String)this._regionLayerMapping.get((Object)"featureLvl2")).entry();
                dseFeatureLvl3 = regionDataSet.slot((String)this._regionLayerMapping.get((Object)"featureLvl3")).entry();
                hasGeo = dseFeatureLvl1 != null && this.getStringProperty((String)this._regionLayerMapping.get((Object)"region.custom.mapId")).length() > 0 && this.getStringProperty((String)this._regionLayerMapping.get((Object)"region.custom.layerName")).length() > 0 && this.getStringProperty((String)this._regionLayerMapping.get((Object)"region.custom.propertyName")).length() > 0;
                featureAccessors = new ArrayList<Object>();
                if (hasGeo) {
                    featureAccessors.add(this._createGeoDataAccessor(null, null, null, dseFeatureLvl1));
                } else {
                    featureAccessors.add(TiledmapV2View.accessorOf((DataSlotEntry)dseFeatureLvl1));
                    featureAccessors.add(TiledmapV2View.accessorOf((DataSlotEntry)dseFeatureLvl2));
                    featureAccessors.add(TiledmapV2View.accessorOf((DataSlotEntry)dseFeatureLvl3));
                }
                regionLayer.setFeatureAccessors((ArrayEx<Object>)((ArrayEx)featureAccessors));
                this._setupRegionDataLayer(regionLayer, regionDataSet, (ArrayEx<Object>)data, this._regionLayerMapping, hasGeo, showLegend);
            } else {
                this._legends.visible(4, false);
            }
            if (pointDataSet.data() != null) {
                data = ObjectConverter.listToArray((List)((List)pointDataSet.data()));
                TiledmapV2DataLayerImpl pointLayer = new TiledmapV2DataLayerImpl(DATASET_DATA_POINT);
                dataLayers.add((Object)pointLayer);
                pointLayer.setData(data);
                pointLayer.setMapData((JSONArray)this.getProperty((String)this._pointLayerMapping.get((Object)"point.mapData")));
                dseFeatureLvl1 = pointDataSet.slot((String)this._pointLayerMapping.get((Object)"featureLvl1")).entry();
                dseFeatureLvl2 = pointDataSet.slot((String)this._pointLayerMapping.get((Object)"featureLvl2")).entry();
                dseFeatureLvl3 = pointDataSet.slot((String)this._pointLayerMapping.get((Object)"featureLvl3")).entry();
                hasGeo = dseFeatureLvl1 != null && this.getStringProperty((String)this._pointLayerMapping.get((Object)"point.custom.mapId")).length() > 0 && this.getStringProperty((String)this._pointLayerMapping.get((Object)"point.custom.layerName")).length() > 0 && this.getStringProperty((String)this._pointLayerMapping.get((Object)"point.custom.propertyName")).length() > 0;
                featureAccessors = new ArrayList();
                if (hasGeo) {
                    featureAccessors.add(this._createGeoDataAccessor(null, null, null, dseFeatureLvl1));
                } else {
                    featureAccessors.add(TiledmapV2View.accessorOf((DataSlotEntry)dseFeatureLvl1));
                    featureAccessors.add(TiledmapV2View.accessorOf((DataSlotEntry)dseFeatureLvl2));
                    featureAccessors.add(TiledmapV2View.accessorOf((DataSlotEntry)dseFeatureLvl3));
                }
                pointLayer.setFeatureAccessors((ArrayEx<Object>)((ArrayEx)featureAccessors));
                this._setupPointDataLayer(pointLayer, pointDataSet, (ArrayEx<Object>)data, this._pointLayerMapping, this._pointLegendMapping, hasGeo, showLegend);
            } else {
                this._legends.visible(0, false);
                this._legends.visible(1, false);
            }
            if (latlongDataSet.data() != null) {
                boolean hasGeo2;
                DataSlotEntry dseLatitude = latlongDataSet.slot(DATASLOT_LATITUDE).entry();
                DataSlotEntry dseLongitude = latlongDataSet.slot(DATASLOT_LONGITUDE).entry();
                DataSlotEntry dseLabel = latlongDataSet.slot(DATASLOT_LABEL).entry();
                boolean bl = hasGeo2 = dseLatitude != null || dseLongitude != null;
                if (hasGeo2) {
                    ArrayList<Object> featureAccessors2 = new ArrayList<Object>();
                    if (dseLatitude != null && dseLatitude.type() == "object") {
                        featureAccessors2.add(TiledmapV2View.accessorOf((DataSlotEntry)dseLatitude));
                    } else if (dseLongitude != null && dseLongitude.type() == "object") {
                        featureAccessors2.add(TiledmapV2View.accessorOf((DataSlotEntry)dseLongitude));
                    } else if (dseLabel != null && dseLabel.type() == "object") {
                        featureAccessors2.add(TiledmapV2View.accessorOf((DataSlotEntry)dseLabel));
                    } else if (dseLatitude != null && dseLongitude != null) {
                        featureAccessors2.add(this._createGeoDataAccessor(dseLabel, dseLatitude, dseLongitude, null));
                    }
                    if (featureAccessors2.size() > 0) {
                        ArrayEx data2 = ObjectConverter.listToArray((List)((List)latlongDataSet.data()));
                        TiledmapV2DataLayerImpl latlongLayer = new TiledmapV2DataLayerImpl(DATASET_DATA_LATLONG);
                        dataLayers.add((Object)latlongLayer);
                        latlongLayer.setData(data2);
                        latlongLayer.setFeatureAccessors((ArrayEx<Object>)((ArrayEx)featureAccessors2));
                        this._setupPointDataLayer(latlongLayer, latlongDataSet, (ArrayEx<Object>)data2, this._latlongLayerMapping, this._latlongLegendMapping, hasGeo2, showLegend);
                    }
                }
            } else {
                this._legends.visible(2, false);
                this._legends.visible(3, false);
            }
        }
        if (this.updateType <= 1) {
            this.prepareLayoutComponent();
            this.prepareLayoutSizables(this._layoutComponent, false, false, false, false, this._legends.anyVisible());
            this._legends.preLayout(this._layoutComponent);
            this._layoutComponent.layout();
        }
        RectStruct chartRect = this._layoutComponent.elementRect();
        this._legends.rectangle(this._layoutComponent.legendRect());
        this._legends.draw();
        double maxPointSize = this.evaluateSize(this.getStringProperty("point.maxSize"), chartRect.width, 10.0);
        boolean autoZoom = this.getBooleanProperty(TILEDMAP_AUTOZOOM);
        if (this._mapComponent == null) {
            this._mapComponent = new TiledmapV2NativeSubComponentImpl();
            this._mapComponent.accessToken(accessToken);
            this._mapComponent.setContainerRect(chartRect);
            this._mapComponent.setup(this.context.node, this.getNLS());
            this._mapComponent.setDataLayers((ArrayEx<TiledmapV2DataLayer>)dataLayers, true, combinedLayers);
            this._mapComponent.draw(this.context.node);
            this._mapComponent.mapStyle(mapStyle);
            this._mapComponent.setMaxBounds(BASE_BOUNDS);
            if (maxZoom != this._maxZoom) {
                this._mapComponent.setMaxZoom(maxZoom);
            }
            this._mapComponent.setMapLocale(mapLocale);
            this._mapComponent.setMaxPointSize(maxPointSize);
            this._mapComponent.setAutoZoom(autoZoom);
            if (this._registeredEventHandlers.size() > 0) {
                int size = this._registeredEventHandlers.size();
                for (int idx = 0; idx < size; ++idx) {
                    EventHandler evt = (EventHandler)this._registeredEventHandlers.get(idx);
                    this._mapComponent.on(evt.eventName, new EventCallback(evt.callback));
                }
            }
            this._mapInitializedCallback = new TiledmapV2NativeSubComponent.TiledMapEventCallback(){

                public void onEvent(OMap<String, Object> e) {
                    self._mapInitialized = true;
                    if (self._delayedInit != null) {
                        if (((TiledmapV2View)self)._delayedInit.chartRect != null) {
                            self._mapComponent.setContainerRect(((TiledmapV2View)self)._delayedInit.chartRect);
                        }
                        self._mapComponent.setDataLayers(((TiledmapV2View)self)._delayedInit.dataLayers, ((TiledmapV2View)self)._delayedInit.resetData, ((TiledmapV2View)self)._delayedInit.combinedLayers);
                        if (((TiledmapV2View)self)._delayedInit.maxZoom != null) {
                            self._mapComponent.setMaxZoom(((TiledmapV2View)self)._delayedInit.maxZoom);
                        }
                        if (((TiledmapV2View)self)._delayedInit.mapLocale != null) {
                            self._mapComponent.setMapLocale(((TiledmapV2View)self)._delayedInit.mapLocale);
                        }
                        if (((TiledmapV2View)self)._delayedInit.mapStyle != null) {
                            self._mapComponent.mapStyle(((TiledmapV2View)self)._delayedInit.mapStyle);
                        }
                        if (((TiledmapV2View)self)._delayedInit.maxPointSize != null) {
                            self._mapComponent.setMaxPointSize(((TiledmapV2View)self)._delayedInit.maxPointSize);
                        }
                        self._mapComponent.setAutoZoom(((TiledmapV2View)self)._delayedInit.autoZoom);
                    }
                    self._mapComponent.off("style.load", self._mapInitializedCallback);
                }
            };
            this._mapComponent.on("style.load", this._mapInitializedCallback);
        } else if (this._mapInitialized) {
            boolean resetData;
            boolean bl = resetData = this.updateType == 0;
            if (!this._isRectEqual(this._lastChartRect, chartRect)) {
                this._mapComponent.setContainerRect(chartRect);
            }
            this._mapComponent.setDataLayers((ArrayEx<TiledmapV2DataLayer>)dataLayers, resetData, combinedLayers);
            if (this.updateType <= 1) {
                if (maxZoom != this._maxZoom) {
                    this._mapComponent.setMaxZoom(maxZoom);
                }
                if (!mapLocale.equals(this._mapLocale)) {
                    this._mapComponent.setMapLocale(mapLocale);
                }
                if (!mapStyle.equals(this._mapStyle)) {
                    this._mapComponent.mapStyle(mapStyle);
                }
                this._mapComponent.setMaxPointSize(maxPointSize);
                this._mapComponent.setAutoZoom(autoZoom);
            }
            if (resetData || this.updateType <= 1 && mapStyle.equals(this._mapStyle)) {
                this._mapComponent.fire("style.load");
            }
        } else {
            boolean resetData;
            boolean bl = resetData = this.updateType == 0;
            if (this._delayedInit == null) {
                this._delayedInit = new DelayedInit();
            }
            if (!this._isRectEqual(this._lastChartRect, chartRect)) {
                this._delayedInit.setChartRect(chartRect);
            }
            this._delayedInit.setDataLayers((ArrayEx<TiledmapV2DataLayer>)dataLayers, resetData, combinedLayers);
            if (maxZoom != this._maxZoom) {
                this._delayedInit.setMaxZoom(maxZoom);
            }
            if (!mapLocale.equals(this._mapLocale)) {
                this._delayedInit.setMapLocale(mapLocale);
            }
            if (!mapStyle.equals(this._mapStyle)) {
                this._delayedInit.setMapStyle(mapStyle);
            }
            this._delayedInit.setMaxPointSize(maxPointSize);
            this._delayedInit.setAutoZoom(autoZoom);
        }
        this._maxZoom = maxZoom;
        this._mapLocale = mapLocale;
        this._mapStyle = mapStyle;
        this._lastChartRect = this._cloneRect(chartRect);
        this.resetUpdate();
    }

    private SingleValueFunction<Object, Object> _createGeoDataAccessor(DataSlotEntry _captionEntry, DataSlotEntry _latEntry, DataSlotEntry _longEntry, DataSlotEntry _featureIdEntry) {
        return new GeoDataAccessor((SingleValueFunction<Object, Object>)TiledmapV2View.accessorOf((DataSlotEntry)_captionEntry), (SingleValueFunction<Object, Object>)TiledmapV2View.accessorOf((DataSlotEntry)_latEntry), (SingleValueFunction<Object, Object>)TiledmapV2View.accessorOf((DataSlotEntry)_longEntry), (SingleValueFunction<Object, Object>)TiledmapV2View.accessorOf((DataSlotEntry)_featureIdEntry)).getAccessor();
    }

    private double evaluateSize(Object value, double extent, double defValue) {
        Double v = CSSConverter.convertCSSSizeToPixelNumber((Object)value, (double)extent, (double)10.0);
        double d = v != null ? v : defValue;
        return Math.max(0.0, Math.min(d, extent));
    }

    @Override
    protected int getLegendCount() {
        return 5;
    }

    @Override
    protected String[] getGroupStructure() {
        return new String[]{"defs", "g.vizlibrary vizlibrary-tiledmap", "(", "rect.background chart", "g.chart", "g.legends", "(", "g.legends-layout", "g.legend size", "g.legend point", "g.legend latlongSize", "g.legend latlongPoint", "g.legend region", ")", ")"};
    }

    private void _setupRegionDataLayer(TiledmapV2DataLayerImpl _dataLayer, DataSet _dataSet, ArrayEx<Object> _data, OMap<String, String> _layerMap, boolean _geoData, boolean _showLegend) {
        TiledmapV2RegionTypeDataImpl regionTypeData = new TiledmapV2RegionTypeDataImpl();
        String nullColor = this.getStringProperty("color.null");
        String nullColorDefault = ObjectConverter.toString((Object)this.getPropertyDefault("color.null"));
        String currentPaletteId = this.getStringProperty((String)_layerMap.get((Object)NORM_PROP_REGION_ALT_PALETTE));
        if (ObjectConverter.toString((Object)this.getPropertyDefault((String)_layerMap.get((Object)NORM_PROP_REGION_ALT_PALETTE))).equals(currentPaletteId)) {
            currentPaletteId = this.getStringProperty((String)_layerMap.get((Object)"region.palette"));
        }
        JSONObject jsonPalette = Library.palettes.getJSONPalette(currentPaletteId);
        final DataSlotEntry dseValue = _dataSet.slot((String)_layerMap.get((Object)"fill")).entry();
        regionTypeData.setValueAccessor(TiledmapV2View.accessorOf((DataSlotEntry)dseValue));
        Object valueExtent = new ArrayEx(new Object[]{0, 0});
        if (dseValue != null) {
            if (dseValue.domain() != null) {
                valueExtent = dseValue.domain();
            } else {
                Rave.extent((Object[])_data.toArray(), (ValueFunction)new ValueFunction<Object[], Object>(){

                    @SwiftMethodOverload(skipParameters={1})
                    public Object getValue(Object[] context, Object data, int index, int groupIndex) {
                        return dseValue.getValue(data);
                    }
                });
            }
        }
        regionTypeData.minimumValue(ObjectConverter.toDouble(valueExtent.get(0)));
        regionTypeData.maximumValue(ObjectConverter.toDouble(valueExtent.get(1)));
        Palette featurePalette = Library.palettes.getPalette(currentPaletteId);
        featurePalette.setData(_dataSet, (String)_layerMap.get((Object)"fill"));
        regionTypeData.setPaletteDef(jsonPalette);
        regionTypeData.setPalette(featurePalette);
        regionTypeData.setNullColor(nullColor.equals("") ? nullColorDefault : nullColor);
        regionTypeData.setHasGeoData(_geoData);
        regionTypeData.setTransparency(this.getIntProperty((String)_layerMap.get((Object)"region.transparency")));
        regionTypeData.setCustomPolygon(this.getStringProperty((String)_layerMap.get((Object)"region.custom.mapId")), this.getStringProperty((String)_layerMap.get((Object)"region.custom.layerName")), this.getStringProperty((String)_layerMap.get((Object)"region.custom.propertyName")));
        _dataLayer.setTypeData(TYPE_REGION, regionTypeData);
        if (_showLegend) {
            this._legends.visible(4, ObjectConverter.toBoolean((Object)dseValue)).selector(4, this.context.node.selectAll("g.legend.region")).palette(4, featurePalette).shape(4, "square").title(4, this.context.getDataSlotLabel("legend.regioncolor.title", dseValue)).titleFill(4, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fill"))).titleFontSize(4, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontsize"))).titleFontFamily(4, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontfamily"))).setDataSlot(4, dseValue);
        }
    }

    private void _setupPointDataLayer(TiledmapV2DataLayerImpl _dataLayer, DataSet _dataSet, ArrayEx<Object> _data, OMap<String, String> _layerMap, OMap<String, Integer> _legendMap, boolean _geoData, boolean _showLegend) {
        TiledmapV2PointTypeDataImpl pointTypeData = new TiledmapV2PointTypeDataImpl();
        String nullColor = this.getStringProperty("color.null");
        String nullColorDefault = ObjectConverter.toString((Object)this.getPropertyDefault("color.null"));
        String currentPaletteId = this.getStringProperty((String)_layerMap.get((Object)NORM_PROP_POINT_ALT_PALETTE));
        if (ObjectConverter.toString((Object)this.getPropertyDefault((String)_layerMap.get((Object)NORM_PROP_POINT_ALT_PALETTE))).equals(currentPaletteId)) {
            currentPaletteId = this.getStringProperty((String)_layerMap.get((Object)"point.palette"));
        }
        DataSlotEntry dsePointColor = _dataSet.slot((String)_layerMap.get((Object)"pointColor")).entry();
        final DataSlotEntry dsePointSize = _dataSet.slot((String)_layerMap.get((Object)"pointSize")).entry();
        pointTypeData.setPointColorAccessor(TiledmapV2View.accessorOf((DataSlotEntry)dsePointColor));
        pointTypeData.setPointSizeAccessor(TiledmapV2View.accessorOf((DataSlotEntry)dsePointSize));
        pointTypeData.setHasGeoData(_geoData);
        pointTypeData.setCustomPolygon(this.getStringProperty((String)_layerMap.get((Object)"point.custom.mapId")), this.getStringProperty((String)_layerMap.get((Object)"point.custom.layerName")), this.getStringProperty((String)_layerMap.get((Object)"point.custom.propertyName")));
        Object pointSizeDomain = new ArrayEx(new Object[]{0, 0});
        if (dsePointSize != null) {
            pointSizeDomain = dsePointSize.domain() != null ? dsePointSize.domain() : Rave.extent((Object[])_data.toArray(), (ValueFunction)new ValueFunction<Object[], Object>(){

                @SwiftMethodOverload(skipParameters={1})
                public Object getValue(Object[] context, Object data, int index, int groupIndex) {
                    return dsePointSize.getValue(data);
                }
            });
        }
        Palette pointPalette = Library.palettes.getPalette(currentPaletteId);
        pointPalette.setData(_dataSet, (String)_layerMap.get((Object)"pointColor"));
        pointTypeData.setPalette(pointPalette);
        NodeRect bb = this._chart.node().getParentNode().getParentNode().getBoundingClientRect();
        double min = this.evaluateSize(this.getStringProperty((String)_layerMap.get((Object)"point.minSize")), bb.width, 10.0);
        double max = this.evaluateSize(this.getStringProperty((String)_layerMap.get((Object)"point.maxSize")), bb.width, 10.0);
        double defaultSize = this.evaluateSize(this.getStringProperty((String)_layerMap.get((Object)"point.defaultSize")), bb.width, min + max / 2.0);
        final LinearScale pointSizeScale = Rave.scale.linear().domain((List)pointSizeDomain).range((List)new ArrayEx(new Object[]{min, max}));
        pointTypeData.setPointSizeScale(pointSizeScale);
        pointTypeData.setDefaultPointSize(defaultSize);
        OrdinalScale nullColorPalette = null;
        if (pointSizeScale != null) {
            Object minValue = pointSizeScale.domain().get(0);
            Object maxValue = pointSizeScale.domain().get(1);
            nullColorPalette = Rave.scale.ordinal().domain((List)new ArrayEx(new Object[]{minValue, maxValue})).range((List)new ArrayEx(new Object[]{nullColor}));
        }
        pointTypeData.setNullColor(nullColor.equals("") ? nullColorDefault : nullColor);
        pointTypeData.setTransparency(this.getIntProperty((String)_layerMap.get((Object)"point.transparency")));
        String staticZeroValueSize = this.getStringProperty((String)_layerMap.get((Object)"point.staticZeroValueSize"));
        if (staticZeroValueSize == null || staticZeroValueSize.length() == 0) {
            pointTypeData.setStaticZeroValuePointSize(null);
        } else {
            pointTypeData.setStaticZeroValuePointSize(this.evaluateSize(staticZeroValueSize, bb.width, 10.0));
        }
        _dataLayer.setTypeData(TYPE_POINT, pointTypeData);
        if (_showLegend) {
            int legendIndex = (Integer)_legendMap.get((Object)"pointSize");
            this._legends.visible(legendIndex, ObjectConverter.toBoolean((Object)dsePointSize)).selector(legendIndex, this.context.node.selectAll((String)_layerMap.get((Object)NORM_SELECTOR_POINTSIZE_LEGEND))).scale(legendIndex, (AbstractScale<?, ?>)nullColorPalette).shape(legendIndex, "circle").swatchSize(legendIndex, new ValueFunction<Object, Object>(){

                public Object getValue(Object context, Object _data, int index, int groupIndex) {
                    return Math.PI * Math.pow(ObjectConverter.toDouble((double)ObjectConverter.toDouble((Object)pointSizeScale.getValue(null, _data, index, groupIndex))), 2.0);
                }
            }).title(legendIndex, this.context.getDataSlotLabel((String)_layerMap.get((Object)"legend.pointsize.title"), dsePointSize)).titleFill(legendIndex, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fill"))).titleFontSize(legendIndex, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontsize"))).titleFontFamily(legendIndex, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontfamily"))).setDataSlot(legendIndex, dsePointSize);
            legendIndex = (Integer)_legendMap.get((Object)"pointColor");
            this._legends.visible(legendIndex, ObjectConverter.toBoolean((Object)dsePointColor)).selector(legendIndex, this.context.node.selectAll((String)_layerMap.get((Object)NORM_SELECTOR_POINTCOLOR_LEGEND))).palette(legendIndex, pointPalette).shape(legendIndex, "square").title(legendIndex, this.context.getDataSlotLabel((String)_layerMap.get((Object)"legend.pointcolor.title"), dsePointColor)).titleFill(legendIndex, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fill"))).titleFontSize(legendIndex, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontsize"))).titleFontFamily(legendIndex, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontfamily"))).setDataSlot(legendIndex, dsePointColor);
        }
    }

    private RectStruct _cloneRect(RectStruct _rect) {
        return new RectStruct(_rect.x, _rect.y, _rect.width, _rect.height);
    }

    private boolean _isRectEqual(RectStruct _rectA, RectStruct _rectB) {
        return _rectA.x == _rectB.x && _rectA.y == _rectB.y && _rectA.width == _rectB.width && _rectA.height == _rectB.height;
    }

    private SingleValueFunction<String, String> getNLS() {
        final TiledmapV2View self = this;
        return new SingleValueFunction<String, String>(){

            public String getValue(String _key) {
                return self.message(_key, null);
            }
        };
    }

    private class GeoDataAccessor {
        private SingleValueFunction<Object, Object> captionAccessor;
        private SingleValueFunction<Object, Object> latitudeAccessor;
        private SingleValueFunction<Object, Object> longitudeAccessor;
        private SingleValueFunction<Object, Object> featureIdAccessor;

        public GeoDataAccessor(SingleValueFunction<Object, Object> _caption, SingleValueFunction<Object, Object> _latitude, SingleValueFunction<Object, Object> _longitude, SingleValueFunction<Object, Object> _featureId) {
            this.captionAccessor = _caption;
            this.latitudeAccessor = _latitude;
            this.longitudeAccessor = _longitude;
            this.featureIdAccessor = _featureId;
        }

        public SingleValueFunction<Object, Object> getAccessor() {
            final GeoDataAccessor self = this;
            return new SingleValueFunction<Object, Object>(){

                public Object getValue(Object _data) {
                    return new GeoData(self.captionAccessor != null ? (String)self.captionAccessor.getValue(_data) : null, self.latitudeAccessor != null ? (Double)self.latitudeAccessor.getValue(_data) : 0.0, self.longitudeAccessor != null ? (Double)self.longitudeAccessor.getValue(_data) : 0.0, self.featureIdAccessor != null ? (String)self.featureIdAccessor.getValue(_data) : null);
                }
            };
        }
    }

    private class GeoData {
        public String caption;
        public double latitude;
        public double longitude;
        public String featureId;
        public boolean invalidLatLong;

        public GeoData(String _caption, Double _latitude, Double _longitude, String _featureId) {
            this.caption = _caption;
            if (this.isValidLatLong(_latitude, _longitude)) {
                this.latitude = _latitude;
                this.longitude = this.normalizeLongitude(_longitude);
                this.invalidLatLong = false;
            } else {
                this.latitude = 0.0;
                this.longitude = 0.0;
                this.invalidLatLong = true;
            }
            this.featureId = _featureId;
        }

        private boolean isValidLatLong(Double _latitude, Double _longitude) {
            if (_latitude == null || _latitude >= 90.0 || _latitude <= -90.0) {
                return false;
            }
            return _longitude != null;
        }

        private double normalizeLongitude(Double _longitude) {
            double longitude;
            double correction;
            double d = correction = _longitude < 0.0 ? 360.0 : -360.0;
            for (longitude = _longitude.doubleValue(); longitude < -180.0 || longitude > 180.0; longitude += correction) {
            }
            return longitude;
        }
    }

    private class EventCallback
    implements TiledmapV2NativeSubComponent.TiledMapEventCallback {
        private final Controller.BundleEventCallback callback;

        public EventCallback(Controller.BundleEventCallback _callback) {
            this.callback = _callback;
        }

        public void onEvent(OMap<String, Object> _e) {
            this.callback.onEvent(_e);
        }
    }

    private class DelayedInit {
        public RectStruct chartRect = null;
        public ArrayEx<TiledmapV2DataLayer> dataLayers = null;
        public boolean resetData;
        public boolean combinedLayers;
        public Integer maxZoom = null;
        public String mapLocale = null;
        public String mapStyle = null;
        public Double maxPointSize = null;
        public boolean autoZoom;

        public void setChartRect(RectStruct _chartRect) {
            this.chartRect = _chartRect;
        }

        public void setDataLayers(ArrayEx<TiledmapV2DataLayer> _dataLayers, boolean _resetData, boolean _combinedLayers) {
            this.dataLayers = _dataLayers;
            this.resetData = _resetData;
            this.combinedLayers = _combinedLayers;
        }

        public void setMaxZoom(Integer _maxZoom) {
            this.maxZoom = _maxZoom;
        }

        public void setMapLocale(String _mapLocale) {
            this.mapLocale = _mapLocale;
        }

        public void setMapStyle(String _mapStyle) {
            this.mapStyle = _mapStyle;
        }

        public void setMaxPointSize(Double _size) {
            this.maxPointSize = _size;
        }

        public void setAutoZoom(boolean _autoZoom) {
            this.autoZoom = _autoZoom;
        }
    }

    private class EventHandler {
        public final String eventName;
        public final Controller.BundleEventCallback callback;

        public EventHandler(String _eventName, Controller.BundleEventCallback _callback) {
            this.eventName = _eventName;
            this.callback = _callback;
        }
    }
}

