/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.tornadoBundle;

import com.ibm.rave.bundles.components.AxesManager;
import com.ibm.rave.bundles.components.ChartLayoutComponentImpl;
import com.ibm.rave.bundles.components.ClipPathComponentImpl;
import com.ibm.rave.bundles.components.ComponentConfiguration;
import com.ibm.rave.bundles.components.IntervalComponentImpl;
import com.ibm.rave.bundles.components.IntervalDataUtilities;
import com.ibm.rave.bundles.views.BundleView;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.behavior.Zoom;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.EventQueue;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.scales.LinearScale;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.CallbackFunction;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.util.Runnable;
import com.ibm.rave.library.action.BundleUtils;
import com.ibm.rave.library.datamodel.DataSet;
import com.ibm.rave.library.datamodel.DataSlotEntry;
import com.ibm.rave.library.framework.CoordinateScale;
import com.ibm.rave.library.framework.internal.BundleContext;
import com.ibm.rave.library.framework.internal.CoordinateScaleImpl;
import com.ibm.rave.library.framework.internal.LinearCoordinateScale;
import com.ibm.rave.library.framework.internal.ScaleManager;
import com.ibm.rave.library.palette.Palette;
import java.util.List;

public class TornadoView
extends BundleView {
    @InlineStringConstant
    private static final String DATASET_DATA = "data";
    @InlineStringConstant
    private static final String DATASLOT_X = "x";
    @InlineStringConstant
    private static final String DATASLOT_Y = "y";
    @InlineStringConstant
    private static final String DATASLOT_COLOR = "color";
    SingleValueFunction<Object, Object> _colorAccessor;
    private ArrayEx<IntervalDataUtilities.IntervalData> _intervalData;
    private ArrayEx<IntervalDataUtilities.IntervalData> _intervalData2;
    private ArrayEx<IntervalDataUtilities.IntervalData> _intervalData3;
    private CoordinateScaleImpl _independentScale;
    private CoordinateScaleImpl _dependentScale;
    private CoordinateScaleImpl _dependentScale2;
    private CoordinateScaleImpl _dependentScale3;
    private ChartLayoutComponentImpl _layoutComponent2;
    private ChartLayoutComponentImpl _layoutComponent3;
    protected IntervalComponentImpl _intervalComponent;
    protected IntervalComponentImpl _intervalComponent3;
    private AxesManager _axes3;
    private ClipPathComponentImpl _clip3;
    private AbstractScale<?, ?> zoomXScale;
    private AbstractScale<?, ?> zoomYScale;
    private AbstractScale<?, ?> zoomX2Scale;
    private Object zoomendedTimer;
    private String labelLocation;

    public TornadoView(BundleContext context) {
        super(context);
    }

    @Override
    protected boolean isAxesManagerRequired() {
        return true;
    }

    @Override
    public void setup() {
        super.setup();
        OMap style = new OMap();
        style.put((Object)"stroke-width", (Object)"0px");
        BundleUtils.setupDefaultActions((BundleContext)this.context, (String)".chart .element-shape", (OMap)style);
        this._colorAccessor = new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return ((IntervalDataUtilities.IntervalData)data).color;
            }
        };
        this._intervalComponent = new IntervalComponentImpl();
        this._intervalComponent3 = new IntervalComponentImpl();
        this.setAccessor(this._intervalComponent);
        this.setAccessor(this._intervalComponent3);
        this._layoutComponent2 = new ChartLayoutComponentImpl();
        this._layoutComponent3 = new ChartLayoutComponentImpl();
        this._axes3 = new AxesManager(this.context);
        this._clip3 = new ClipPathComponentImpl(this.context.instanceId() + "clipViewport2");
    }

    private void setAccessor(IntervalComponentImpl comp) {
        comp.keyAccessor(new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return ((IntervalDataUtilities.IntervalData)data).key;
            }
        }).independent1Accessor(new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return ((IntervalDataUtilities.IntervalData)data).ind1;
            }
        }).independent2Accessor(new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return ((IntervalDataUtilities.IntervalData)data).ind2;
            }
        }).dependent1Accessor(new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return ((IntervalDataUtilities.IntervalData)data).dep1;
            }
        }).dependent2Accessor(new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return ((IntervalDataUtilities.IntervalData)data).dep2;
            }
        });
    }

    public void draw() {
        boolean legendVisibilityChanged;
        if (this.isUpdateNothing()) {
            return;
        }
        this.preDraw("g.vizlibrary-tornado");
        if (!this.validateDataModel("g.element-group", "g.element-group3")) {
            return;
        }
        this.setBorder("border.width", "border.color");
        String effect = this.getStringProperty("effect.name");
        int duration = this.getEffectDuration(effect);
        boolean doTransition = duration != 0;
        this.labelLocation = this.getStringProperty("labelLocation");
        DataSet dataSet = this.dataModel.dataset(DATASET_DATA);
        ArrayEx data = ObjectConverter.listToArray((List)((List)dataSet.data()));
        Palette colorPalette = this.getPalette();
        colorPalette.setData(dataSet, DATASLOT_COLOR);
        colorPalette.setAccessor(this._colorAccessor);
        List colorDomain = ScaleManager.ordinalDomain((List)((List)dataSet.data()), (DataSlotEntry)dataSet.slot(DATASLOT_COLOR).entry(), (boolean)false);
        SingleValueFunction xAccessor = TornadoView.accessorOf((DataSlotEntry)dataSet.slot(DATASLOT_X).entry());
        SingleValueFunction yAccessor = TornadoView.accessorOf((DataSlotEntry)dataSet.slot(DATASLOT_Y).entry());
        SingleValueFunction groupAccessor = TornadoView.accessorOf((DataSlotEntry)dataSet.slot(DATASLOT_COLOR).entry());
        if (this.updateType == 0) {
            if (data == null || data.size() == 0) {
                this._intervalData = new ArrayEx();
                this._intervalData2 = new ArrayEx();
                this._intervalData3 = new ArrayEx();
            } else {
                this._intervalData = this.createData((ArrayEx<Object>)data, (SingleValueFunction<Object, Object>)xAccessor, (SingleValueFunction<Object, Object>)TornadoView.domainCheckerOf((List)data, (DataSlotEntry)dataSet.slot(DATASLOT_X).entry()), (SingleValueFunction<Object, Object>)yAccessor, (SingleValueFunction<Object, Object>)groupAccessor, ObjectConverter.toString(colorDomain.get(0)));
                if (colorDomain.size() == 1) {
                    this._intervalData2 = this._intervalData;
                    this._intervalData3 = this.mirror(this._intervalData2);
                } else {
                    this._intervalData2 = this.getGroupData(ObjectConverter.toString(colorDomain.get(0)));
                    this._intervalData3 = this.getGroupData(ObjectConverter.toString(colorDomain.get(1)));
                }
            }
            this.context.actions.action("deselectAll").call(new Object[]{this.context.node.selectAll(".chart .element-shape")});
        }
        boolean showLegend = this.isShowLegend();
        boolean bl = legendVisibilityChanged = this._legends.anyVisible() != showLegend;
        if (legendVisibilityChanged) {
            this.updateType = 1;
        }
        String legendPosition = this.getLegendPosition();
        this._legends.visible(showLegend).position(legendPosition).transition(doTransition, duration).setPreExecute(this.context.getPreExecute()).selector(0, this.context.node.selectAll("g.legend")).palette(0, colorPalette).shape(0, "square").title(0, this.context.getDataSlotLabel("legend.title", dataSet.slot(DATASLOT_COLOR).entry())).titleFill(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fill"))).titleFontSize(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontsize"))).titleFontFamily(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontfamily")));
        if (this.updateType <= 1) {
            this._independentScale = ScaleManager.makeCoordinateScale((List)data, (DataSlotEntry)dataSet.slot(DATASLOT_X).entry());
            this.setScale(this._independentScale, "axis.x.scale.nice");
            if (this._independentScale != null) {
                this.zoomYScale = this._independentScale.scale().copy();
            }
            if (this.labelLocation.equals("left")) {
                this.layoutSingleChart();
            } else {
                this.layoutTwoCharts();
            }
            this.resetZoom();
        }
        RectStruct chartRect = this._layoutComponent.elementRect();
        this._chart.select((Object)"rect.background.elements").attr(DATASLOT_X, (Object)chartRect.x).attr(DATASLOT_Y, (Object)chartRect.y).attr("width", (Object)chartRect.width).attr("height", (Object)chartRect.height);
        this.setBackgroundProperties(chartRect, duration);
        this._legends.rectangle(this._layoutComponent.legendRect());
        this._legends.draw();
        ((IntervalComponentImpl)((IntervalComponentImpl)this._intervalComponent.key((SingleValueFunction<Object, Object>)TornadoView.originalDatumAccessor(null))).transpose(true).independentScale(this._independentScale).colorPalette(colorPalette).setPreExecute(this.context.getPreExecute())).borderWidth(this.context.convertCSSSizeToPixels(this.context.getPropertyValue("border.width"))).borderColor(ObjectConverter.asString((Object)this.context.getPropertyValue("border.color")));
        if (this.labelLocation.equals("left")) {
            this.drawSingleChart(duration, colorPalette);
        } else {
            this.drawTwoCharts(duration, colorPalette);
        }
        this.processTickLabels();
        this.setupZoom();
        this.resetUpdate();
        this._chart.selectAll(".element-shape").classed("bundle-shape", true);
        this._chart.selectAll(".legendShape").classed("bundle-shape", true);
    }

    public CoordinateScale getCoordinateScale(String role) {
        if ("ROLE_X1".equals(role)) {
            return this._independentScale;
        }
        if ("ROLE_Y1".equals(role)) {
            return "left".equals(this.labelLocation) ? this._dependentScale : this._dependentScale2;
        }
        if ("ROLE_Y2".equals(role)) {
            return "left".equals(this.labelLocation) ? null : this._dependentScale3;
        }
        return null;
    }

    private void processTickLabels() {
        if (this.labelLocation.equals("left")) {
            Selector ticks = this._chart.selectAll(".axisTransform.bottom").selectAll(".axis-label");
            ticks.each((CallbackFunction)new CallbackFunction<SceneNode>(){

                public void run(SceneNode context, Object data, int index, int groupIndex) {
                    String text = context.getText();
                    if (text.startsWith("-")) {
                        context.setText(text.substring(1));
                    }
                }
            });
        } else {
            Selector ticks = this._chart.selectAll(".axisTransform.bottom3").selectAll(".axis-label");
            ticks.each((CallbackFunction)new CallbackFunction<SceneNode>(){

                public void run(SceneNode context, Object data, int index, int groupIndex) {
                    String text = context.getText();
                    if (text.startsWith("-")) {
                        context.setText(text.substring(1));
                    } else if (ObjectConverter.toDouble((Object)text) != 0.0) {
                        context.setText("-" + text);
                    }
                }
            });
        }
    }

    private void drawSingleChart(int duration, Palette colorPalette) {
        this._intervalComponent.data(this._intervalData.toArray()).dependentScale(this._dependentScale);
        this._chart.selectAll("g.element-group").transition().duration((Object)duration).call((RunFunction)this._intervalComponent, new Object[0]);
        this._axes.useDefaultX1Properties(true).useDefaultY1Properties(true).duration(duration).draw();
        this._intervalComponent3.data(null);
        this._chart.selectAll("g.element-group3").transition().duration((Object)duration).call((RunFunction)this._intervalComponent3, new Object[0]);
        this._axes3.visible(false).draw();
    }

    private void drawTwoCharts(int duration, Palette colorPalette) {
        this._intervalComponent.data(this._intervalData2.toArray()).dependentScale(this._dependentScale2);
        this._chart.selectAll("g.element-group").transition().duration((Object)duration).call((RunFunction)this._intervalComponent, new Object[0]);
        this._axes.useDefaultX1Properties(true).useDefaultY1Properties(true).duration(duration).draw();
        ((IntervalComponentImpl)((IntervalComponentImpl)this._intervalComponent3.data(this._intervalData3.toArray()).dependentScale(this._dependentScale3).key((SingleValueFunction<Object, Object>)TornadoView.originalDatumAccessor(null))).transpose(true).independentScale(this._independentScale).colorPalette(colorPalette).setPreExecute(this.context.getPreExecute())).borderWidth(this.context.convertCSSSizeToPixels(this.context.getPropertyValue("border.width"))).borderColor(ObjectConverter.asString((Object)this.context.getPropertyValue("border.color")));
        this._chart.selectAll("g.element-group3").transition().duration((Object)duration).call((RunFunction)this._intervalComponent3, new Object[0]);
        this._axes3.visible(true).swapX(true).useDefaultX1Properties(true).useDefaultY1Properties(true).duration(duration);
        this._axes3.axisComponent(0).axisTitle(null).displayTickLabels(false);
        this._axes3.draw();
    }

    private void layoutSingleChart() {
        this._dependentScale = this.makeDependentScale(this.dataModel.dataset(DATASET_DATA), (List<IntervalDataUtilities.IntervalData>)this._intervalData);
        this.setScale(this._dependentScale, "axis.y.scale.nice");
        if (this._dependentScale != null) {
            this.zoomXScale = this._dependentScale.scale().copy();
        }
        this._axes.transpose(true).scale(0, this._independentScale).scale(2, this._dependentScale).useDefaultX1Properties(true).useDefaultY1Properties(true).setDataSlot(0, this.dataModel.dataset(DATASET_DATA).slot(DATASLOT_X).entry()).setDataSlot(2, this.dataModel.dataset(DATASET_DATA).slot(DATASLOT_Y).entry()).useDefaultSelectors();
        this.prepareLayoutComponent();
        this.prepareLayoutSizables(this._layoutComponent, false, true, true, false, this._legends.anyVisible());
        this._axes.preLayout(this._layoutComponent, true, 0.1, 0.05, 0, 0.1, 0.05, 0);
        this._legends.preLayout(this._layoutComponent);
        this._layoutComponent.layout();
        this._axes.useBoundsFromLayout(this._layoutComponent).setScaleRanges(0.1, 0.05, 0);
        this._clip.clipRect(this._layoutComponent.elementRect()).applyTo(this._chart.select((Object)".element-group")).run((Selection<?>)this.context.node.select((Object)"defs"), new Object[0]);
    }

    private void layoutTwoCharts() {
        DataSet dataSet = this.dataModel.dataset(DATASET_DATA);
        this._dependentScale2 = this.makeDependentScale(dataSet, (List<IntervalDataUtilities.IntervalData>)this._intervalData2);
        this._dependentScale3 = this.makeDependentScale(dataSet, (List<IntervalDataUtilities.IntervalData>)this._intervalData3);
        this.setScale(this._dependentScale2, "axis.y.scale.nice");
        this.setScale(this._dependentScale3, "axis.y.scale.nice");
        if (this._dependentScale2 != null) {
            this.zoomXScale = this._dependentScale2.scale().copy();
        }
        if (this._dependentScale3 != null) {
            this.zoomX2Scale = this._dependentScale3.scale().copy();
        }
        this._axes.transpose(true).scale(0, this._independentScale).scale(2, this._dependentScale2).useDefaultX1Properties(true).useDefaultY1Properties(true).setDataSlot(0, this.dataModel.dataset(DATASET_DATA).slot(DATASLOT_X).entry()).setDataSlot(2, this.dataModel.dataset(DATASET_DATA).slot(DATASLOT_Y).entry());
        this.prepareLayoutComponent();
        this.prepareLayoutSizables(this._layoutComponent, false, false, true, false, this._legends.anyVisible());
        this._axes.preLayout(this._layoutComponent, true, 0.1, 0.05, 0, 0.1, 0.05, 0);
        this._layoutComponent.layout();
        double extraPaddingXAxis = 12.0;
        double ratio = this.computeRatio(this._layoutComponent.leftRect().width + extraPaddingXAxis);
        this.prepareLayoutSizables(this._layoutComponent, false, false, false, false, this._legends.anyVisible());
        this._legends.preLayout(this._layoutComponent);
        this._layoutComponent.layout();
        double xLeft = this._layoutComponent.chartRect().x + this._layoutComponent.chartRect().width * ratio + extraPaddingXAxis;
        double yTop = this._layoutComponent.chartRect().y;
        double width = this._layoutComponent.chartRect().width * (1.0 - ratio) - extraPaddingXAxis;
        double height = this._layoutComponent.chartRect().height;
        this.prepareLayoutSizables(this._layoutComponent2, false, true, true, false, false);
        ((ChartLayoutComponentImpl)this._layoutComponent2.setPreExecute(this.context.getPreExecute())).overall(new RectStruct(xLeft, yTop, width, height));
        this._axes.preLayout(this._layoutComponent2, true, 0.1, 0.05, 0, 0.1, 0.05, 0);
        this._layoutComponent2.layout();
        this._axes3.transpose(true).scale(2, this._dependentScale3).scale(0, this._independentScale).useDefaultX1Properties(true).useDefaultY1Properties(true).axisSelector(3, this.context.node.select((Object)"g.axisTransform.right3")).axisSelector(0, this.context.node.select((Object)"g.axisTransform.bottom3")).gridSelector(0, this.context.node.select((Object)"g.grid.bottom3")).gridSelector(3, this.context.node.select((Object)"g.grid.right3"));
        xLeft = this._layoutComponent.chartRect().x;
        width = this._layoutComponent.chartRect().width * ratio;
        this.prepareLayoutSizables(this._layoutComponent3, false, true, false, false, false);
        ((ChartLayoutComponentImpl)this._layoutComponent3.setPreExecute(this.context.getPreExecute())).overall(new RectStruct(xLeft, yTop, width, height));
        this._axes3.preLayout(this._layoutComponent3, true, 0.1, 0.05, 0, 0.1, 0.05, 0);
        this._layoutComponent3.layout();
        this._axes.useBoundsFromLayout(this._layoutComponent2).setScaleRanges(0.1, 0.05, 0);
        this._axes3.useBoundsFromLayout(this._layoutComponent3).setScaleRanges(0.1, 0.05, 0);
        this._clip.clipRect(this._layoutComponent2.elementRect()).applyTo(this._chart.select((Object)".element-group")).run((Selection<?>)this.context.node.select((Object)"defs"), new Object[0]);
        this._clip3.clipRect(this._layoutComponent3.elementRect()).applyTo(this._chart.select((Object)".element-group3")).run((Selection<?>)this.context.node.select((Object)"defs"), new Object[0]);
    }

    private void setupZoom() {
        CoordinateScaleImpl yScale = this._independentScale;
        CoordinateScaleImpl xScale = this.labelLocation.equals("left") ? this._dependentScale : this._dependentScale2;
        CoordinateScaleImpl x2Scale = this._dependentScale3;
        RectStruct chartRect = this._layoutComponent.elementRect();
        if (this.updateType <= 2) {
            String ops = this.getZoomOption();
            if (xScale != null && (ops.equals("all") || ops.equals(DATASLOT_X))) {
                xScale.scale().domain(this.zoomXScale.domain());
            }
            if (x2Scale != null && (ops.equals("all") || ops.equals("x2"))) {
                x2Scale.scale().domain(this.zoomX2Scale.domain());
            }
            if (yScale != null && (ops.equals("all") || ops.equals(DATASLOT_Y))) {
                yScale.scale().domain(this.zoomYScale.domain());
            }
            final TornadoView self = this;
            Zoom zoom = (Zoom)this.context.actions.action("zoom").get("zoom");
            ComponentConfiguration.configureZoom(this._chart, zoom, xScale, yScale, x2Scale, null, null, chartRect, this._zoomP, this._zoomS, ops, new RunFunction<SceneNode>(){

                public Object run(SceneNode node, Object ... args) {
                    self._chart.selectAll("g.element-group").call((RunFunction)self._intervalComponent, new Object[0]);
                    self._axes.redraw(true);
                    if (self.labelLocation.equals("center")) {
                        self._chart.selectAll("g.element-group3").call((RunFunction)self._intervalComponent3, new Object[0]);
                        self._axes3.redraw(true);
                    }
                    self.processTickLabels();
                    return self._chart;
                }
            });
            zoom.on("zoomend.hideLabels", (RunFunction)new RunFunction<SceneNode>(){

                public Object run(SceneNode context, Object ... args) {
                    if (self._axes.hideAnyPanZoom() || self._axes3.hideAnyPanZoom()) {
                        if (self.zoomendedTimer != null) {
                            EventQueue.clearTimeout((Object)self.zoomendedTimer);
                        }
                        self.zoomendedTimer = EventQueue.setTimeout((Runnable)new Runnable(){

                            public void run() {
                                self.zoomendedTimer = null;
                                self._axes.redraw(false);
                                if (self.labelLocation.equals("center")) {
                                    self._axes3.redraw(false);
                                }
                            }
                        }, (int)300);
                    }
                    return null;
                }
            });
        }
    }

    private String getZoomOption() {
        String result = this.getStringProperty("zoom");
        if (result.equals(DATASLOT_X)) {
            return DATASLOT_Y;
        }
        if (result.equals(DATASLOT_Y)) {
            return DATASLOT_X;
        }
        if (result.equals("y2")) {
            return "x2";
        }
        return result;
    }

    private void setScale(CoordinateScaleImpl scale, String property) {
        if (scale != null) {
            scale.expandZeroExtent(false);
            scale.expandPixels(2.0, false);
            if (this.getBooleanProperty(property)) {
                scale.nice();
            }
        }
    }

    private double computeRatio(double axisWidth) {
        if (this._dependentScale2 == null || this._dependentScale3 == null) {
            return 0.0;
        }
        ArrayEx domain1 = ((LinearScale)this._dependentScale2.scale()).domain();
        double r1 = Math.abs(ObjectConverter.toDouble((Object)domain1.get(0)) - ObjectConverter.toDouble((Object)domain1.get(1)));
        ArrayEx domain2 = ((LinearScale)this._dependentScale3.scale()).domain();
        double r2 = Math.abs(ObjectConverter.toDouble((Object)domain2.get(0)) - ObjectConverter.toDouble((Object)domain2.get(1)));
        double w = this._layoutComponent.chartRect().width - axisWidth;
        return w / this._layoutComponent.chartRect().width * (r2 / (r1 + r2));
    }

    private ArrayEx<IntervalDataUtilities.IntervalData> getGroupData(String group) {
        ArrayEx result = new ArrayEx();
        for (IntervalDataUtilities.IntervalData d : this._intervalData) {
            if (!ObjectConverter.toString((Object)d.color).equals(group)) continue;
            result.add((Object)d);
        }
        return result;
    }

    private ArrayEx<IntervalDataUtilities.IntervalData> createData(ArrayEx<Object> data, final SingleValueFunction<Object, Object> independent, final SingleValueFunction<Object, Object> xScale, final SingleValueFunction<Object, Object> dependent, final SingleValueFunction<Object, Object> color, final String firstGroup) {
        final ArrayEx result = new ArrayEx();
        if (data == null || data.size() == 0 || independent == null || dependent == null) {
            return result;
        }
        data.forEach((ArrayEx.ArrayValueFunction)new ArrayEx.ArrayValueFunction<Object, Object>(){

            public Object getValue(Object d, int ix, ArrayEx<Object> list) {
                Object ind = independent.getValue(d);
                Object dep = dependent.getValue(d);
                if (ind != null && (xScale == null || xScale.getValue(ind) != null) && dep != null) {
                    IntervalDataUtilities.IntervalData r = new IntervalDataUtilities.IntervalData();
                    r.key = ix;
                    r.color = color != null ? color.getValue(d) : null;
                    r.ind2 = r.ind1 = ind;
                    r.cind = r.ind1;
                    r.dep1 = 0;
                    r.cdep = r.dep2 = ObjectConverter.toString((Object)r.color).equals(firstGroup) ? dep : Double.valueOf(-1.0 * ObjectConverter.toDouble((Object)dep));
                    r.value = r.dep2;
                    r._originalData = d;
                    result.add((Object)r);
                }
                return null;
            }
        });
        return result;
    }

    private ArrayEx<IntervalDataUtilities.IntervalData> mirror(ArrayEx<IntervalDataUtilities.IntervalData> intervalData) {
        ArrayEx result = new ArrayEx();
        for (IntervalDataUtilities.IntervalData d : intervalData) {
            IntervalDataUtilities.IntervalData r = new IntervalDataUtilities.IntervalData();
            r.key = d.key;
            r.color = d.color;
            r.ind1 = d.ind1;
            r.ind2 = d.ind2;
            r.cind = d.cind;
            r.dep1 = d.dep1;
            r.dep2 = -1.0 * ObjectConverter.toDouble((Object)d.dep2);
            r.cdep = d.cdep;
            r.value = d.value;
            r._originalData = d._originalData;
            result.add((Object)r);
        }
        return result;
    }

    private CoordinateScaleImpl makeDependentScale(DataSet dataSet, List<IntervalDataUtilities.IntervalData> data) {
        List domain = dataSet.slot(DATASLOT_Y).entry().domain();
        if (domain != null) {
            return LinearCoordinateScale.create((List)domain);
        }
        Object omax = Rave.max(data, (ValueFunction)new ValueFunction<List<?>, Number>(){

            public Number getValue(List<?> ctxt, Object data, int ix, int gix) {
                return Math.max(ObjectConverter.toDouble((Object)((IntervalDataUtilities.IntervalData)data).dep1), ObjectConverter.toDouble((Object)((IntervalDataUtilities.IntervalData)data).dep2));
            }
        });
        Object omin = Rave.min(data, (ValueFunction)new ValueFunction<List<?>, Number>(){

            public Number getValue(List<?> ctxt, Object data, int ix, int gix) {
                return Math.min(ObjectConverter.toDouble((Object)((IntervalDataUtilities.IntervalData)data).dep1), ObjectConverter.toDouble((Object)((IntervalDataUtilities.IntervalData)data).dep2));
            }
        });
        if (omax == null || omin == null) {
            return null;
        }
        CoordinateScaleImpl scale = LinearCoordinateScale.create((List)new ArrayEx(new Object[]{omin, omax}));
        scale.includeZero();
        return scale;
    }

    @Override
    protected String[] getGroupStructure() {
        return new String[]{"defs", "g.vizlibrary vizlibrary-tornado", "(", "rect.background chart", "g.chart", "(", "g.content", "(", "rect.background elements", "g.gridlines", "(", "g.grid left", "g.grid bottom", "g.grid right3", "g.grid bottom3", ")", "g.elements", "(", "g.element-group", "g.element-group3", ")", ")", "g.axes", "(", "g.axes-layout", "g.axisTransform left", "g.axisTransform bottom", "g.axisTransform right3", "g.axisTransform bottom3", ")", ")", "g.legends", "(", "g.legends-layout", "g.legend", ")", ")"};
    }
}

