/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.treemapBundle;

import com.ibm.rave.bundles.components.BreadcrumbComponentImpl;
import com.ibm.rave.bundles.components.ChartLayoutComponentImpl;
import com.ibm.rave.bundles.components.TreemapComponentImpl;
import com.ibm.rave.bundles.data.HierarchyBundleDatum;
import com.ibm.rave.bundles.treemapBundle.IndexedTreemapNode;
import com.ibm.rave.bundles.views.BundleView;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.event.Event;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.layout.treemap.Treemap;
import com.ibm.rave.core.layout.treemap.TreemapNode;
import com.ibm.rave.core.nativeImpl.EventQueue;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.SelectorEventListener;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.util.Runnable;
import com.ibm.rave.library.action.ActionOperation;
import com.ibm.rave.library.action.BundleUtils;
import com.ibm.rave.library.action.internal.ActionImpl;
import com.ibm.rave.library.action.internal.OperationsUtil;
import com.ibm.rave.library.datamodel.DataSet;
import com.ibm.rave.library.datamodel.DataSlotEntry;
import com.ibm.rave.library.framework.internal.BundleContext;
import com.ibm.rave.library.framework.internal.CSSConverter;
import com.ibm.rave.library.framework.internal.HierarchyUtility;
import com.ibm.rave.library.framework.internal.ScaleManager;
import com.ibm.rave.library.palette.Palette;
import java.util.List;

public class TreemapView
extends BundleView {
    private TreemapComponentImpl _treemapComponent;
    private BreadcrumbComponentImpl _breadcrumbComponent;
    private RectStruct chartRect;
    private RectStruct legendRect;
    private RectStruct breadcrumbRect;
    private HierarchyUtility.HUResult _hierarchyData;
    private ArrayEx<HierarchyBundleDatum<TreemapNode>> _mappedNodes;
    private ArrayEx<Object> _labelNodes;
    private int _previousLabelLevel;
    private int _index;
    private int _maxLevel;
    private int currentDrillLevel;
    private TreemapNode drillTargetNode;
    private boolean clicked = false;
    private Object handle;
    private ArrayEx<String> _breadcrumbData;
    private int _borderWidth;
    private static String SHOW_BREADCRUMB = "breadcrumbDisplay";
    @InlineStringConstant
    private static final String DATASET_DATA = "data";
    @InlineStringConstant
    private static final String DATASLOT_SIZE = "size";
    @InlineStringConstant
    private static final String DATASLOT_COLOR = "color";
    @InlineStringConstant
    private static final String DATASLOT_LABEL = "label";
    @InlineStringConstant
    private static final String DATASLOT_CHILDREN = "children";
    @InlineStringConstant
    private static final String DATASLOT_KEY = "key";
    @InlineStringConstant
    private static final String ITEM_LABEL_PROPERTY_ID = "itemLabel";
    @InlineStringConstant
    private static final String LEAD_LABEL_DISPLAY = "leadLabel.display";
    @InlineStringConstant
    private static final String LABELSTYLE_FONT = "labelstyle.font";
    @InlineStringConstant
    private static final String SIZE_OR_COUNT_PROPERTY_ID = "sizeOrCount";
    @InlineStringConstant
    private static final String MODE_ID = "mode";
    @InlineStringConstant
    private static final String ITEM_COLOR_ID = "itemColor";
    private static final String COLOR = "color";

    public TreemapView(BundleContext context) {
        super(context);
        this._layoutComponent = new ChartLayoutComponentImpl();
    }

    @Override
    protected boolean isZoomSupported() {
        return false;
    }

    @Override
    public void setup() {
        super.setup();
        this._treemapComponent = new TreemapComponentImpl();
        this._breadcrumbComponent = new BreadcrumbComponentImpl();
        this._breadcrumbData = new ArrayEx();
        this.currentDrillLevel = 0;
        BundleUtils.setupDefaultActions((BundleContext)this.context, (String)".rect", null);
        this.context.actions.action("toggleSelect").setOperation(OperationsUtil.toggleSelection(null));
        final TreemapView self = this;
        final ActionImpl toggleSelectionAction = this.context.actions.action("toggleSelect");
        SelectorEventListener<Event> toggleSelectionListener = new SelectorEventListener<Event>(){

            public void onEvent(SceneNode context1, Object data, int index, int groupIndex, Event event) {
                final OMap primaryStyle = self.getNodeStyle((HierarchyBundleDatum)data);
                primaryStyle.put((Object)"opacity", (Object)1.0);
                final SceneNode selected = context1;
                if (self.clicked) {
                    self.clicked = false;
                    EventQueue.clearTimeout((Object)self.handle);
                } else {
                    self.clicked = true;
                    self.handle = EventQueue.setTimeout((Runnable)new Runnable(){

                        public void run() {
                            self.clicked = false;
                            toggleSelectionAction.call(new Object[]{Rave.select((SceneNode)selected), self.context.node.selectAll(".rect"), primaryStyle, null});
                        }
                    }, (int)300);
                }
            }
        };
        toggleSelectionAction.setBindFn(new BundleUtils.BindingOperation((SelectorEventListener)toggleSelectionListener){
            final /* synthetic */ SelectorEventListener val$toggleSelectionListener;
            {
                this.val$toggleSelectionListener = selectorEventListener;
            }

            public void call() {
                self.context.node.selectAll(".rect").on("click.default", this.val$toggleSelectionListener).on("touchstart.default", this.val$toggleSelectionListener);
            }
        });
        final ActionImpl drillDownAction = (ActionImpl)self.context.actions.action("drillDown").setOperation(new ActionOperation(){

            public void call(Object ... args) {
                self.drillIntoChildren(args[0]);
            }
        });
        drillDownAction.setBindFn(new BundleUtils.BindingOperation(){

            public void call() {
                self.context.node.selectAll(".rect").on("dblclick.default", (SelectorEventListener)new SelectorEventListener<Event>(){

                    public void onEvent(SceneNode context1, Object data, int index, int groupIndex, Event event) {
                        drillDownAction.call(new Object[]{data});
                    }
                });
            }
        });
        drillDownAction.setUnbindFn(new BundleUtils.BindingOperation(){

            public void call() {
                self.context.node.selectAll(".rect").on("dbclick.default", null);
            }
        });
        BundleUtils.setupBreadcrumbDefaultActions((BundleContext)this.context, (String)".indicator");
        ActionImpl breadcrumbSelectAction = self.context.actions.action("breadcrumbSelect");
        breadcrumbSelectAction.setOperation(new ActionOperation(){

            public void call(Object ... args) {
                self.breadcrumbSelect(args[0]);
            }
        });
    }

    private void breadcrumbSelect(Object data) {
        String title = ObjectConverter.asString((Object)data);
        int index = 0;
        for (int i = 0; i < this._breadcrumbData.size(); ++i) {
            if (!title.equals(this._breadcrumbData.get(i))) continue;
            index = i;
            break;
        }
        if (this.currentDrillLevel != index / 2) {
            this.currentDrillLevel = index / 2;
            this.drillTargetNode = this.getParentAtLevel(this.drillTargetNode, this.currentDrillLevel);
            if (this.drillTargetNode != null) {
                this.drawDrilledTreemap();
                this._breadcrumbData.setLength(Math.max(1, index + 1));
                this.context.node.selectAll("g.breadcrumb").call((RunFunction)this._breadcrumbComponent, new Object[0]);
                this.context.actions.applyBindings();
            }
        }
    }

    private void drillIntoChildren(Object data) {
        this.drillTargetNode = this.getParentAtLevel((TreemapNode)((HierarchyBundleDatum)data)._hierarchyNode, this.currentDrillLevel + 1);
        if (this.drillTargetNode != null && this.drillTargetNode.children != null) {
            ++this.currentDrillLevel;
            this.drawDrilledTreemap();
            this._breadcrumbData.add((Object)">");
            this._breadcrumbData.add((Object)this.getBreadscrumLabel(this.drillTargetNode));
            this.context.node.selectAll("g.breadcrumb").call((RunFunction)this._breadcrumbComponent, new Object[0]);
            this.context.actions.applyBindings();
        }
    }

    private void drawDrilledTreemap() {
        double[] drillScales = new double[2];
        double[] drillTranslate = new double[2];
        drillScales[0] = this.chartRect.width / this.drillTargetNode.dx;
        drillScales[1] = this.chartRect.height / this.drillTargetNode.dy;
        drillTranslate[0] = this.drillTargetNode.x;
        drillTranslate[1] = this.drillTargetNode.y;
        for (Object o : this._mappedNodes) {
            TreemapNode d = (TreemapNode)((HierarchyBundleDatum)o)._hierarchyNode;
            d.x = (d.x - drillTranslate[0]) * drillScales[0];
            d.y = (d.y - drillTranslate[1]) * drillScales[1];
            d.dx *= drillScales[0];
            d.dy *= drillScales[1];
        }
        int labelLevel = this.getIntProperty(ITEM_LABEL_PROPERTY_ID);
        this._labelNodes = this.getLabelData(Math.max(labelLevel, this.currentDrillLevel + 1));
        this._treemapComponent.labelData(this._labelNodes);
        String effect = this.getStringProperty("effect.name");
        int duration = this.getEffectDuration(effect);
        this.context.node.selectAll("g.element-group").transition().duration((Object)duration).call((RunFunction)this._treemapComponent, new Object[0]);
    }

    private String getBreadscrumLabel(TreemapNode node) {
        DataSet dataSet = this.dataModel.dataset(DATASET_DATA);
        SingleValueFunction labelAccessor = TreemapView.accessorOf((DataSlotEntry)dataSet.slot(DATASLOT_LABEL).entry());
        String result = labelAccessor == null ? null : ObjectConverter.asString((Object)labelAccessor.getValue(node.data));
        return result != null ? result : "Level" + (node.depth + 1);
    }

    private TreemapNode getParentAtLevel(TreemapNode node, int level) {
        if (node.depth == level) {
            return node;
        }
        if (node.depth < level) {
            return null;
        }
        return this.getParentAtLevel((TreemapNode)node.parent, level);
    }

    public void draw() {
        boolean legendVisibilityChanged;
        String colorField;
        if (this.isUpdateNothing()) {
            return;
        }
        this.preDraw("g.vizlibrary-treemap");
        if (!this.validateDataModel("g.element-group")) {
            return;
        }
        String effect = this.getStringProperty("effect.name");
        int duration = this.getEffectDuration(effect);
        boolean doTransition = duration != 0;
        String legendPosition = this.getLegendPosition();
        boolean showLegend = this.isShowLegend();
        Palette colorPalette = this.getDynamicPalette();
        DataSet dataSet = this.dataModel.dataset(DATASET_DATA);
        DataSlotEntry sizeDataSlotEntry = dataSet.slot(DATASLOT_SIZE).entry();
        if (this.updateType == 0) {
            this.context.actions.action("deselectAll").call(new Object[]{this.context.node.selectAll(".rect")});
            HierarchyUtility builder = new HierarchyUtility((HierarchyUtility.HUFactory)new HierarchyUtility.HUFactory<TreemapNode>(){

                public TreemapNode make() {
                    return new IndexedTreemapNode();
                }
            });
            this._hierarchyData = builder.buildHierarchy(dataSet.data(), TreemapView.accessorOf((DataSlotEntry)dataSet.slot(DATASLOT_CHILDREN).entry()), TreemapView.accessorOf((DataSlotEntry)sizeDataSlotEntry), 0.0);
            this._index = 0;
            this.setIndex((ArrayEx<TreemapNode>)((TreemapNode)this._hierarchyData._root).children);
            this.currentDrillLevel = 0;
            this.drillTargetNode = null;
            this._breadcrumbData.clear();
            if (((TreemapNode)this._hierarchyData._root).children != null) {
                this._breadcrumbData.add((Object)this.getBreadscrumLabel((TreemapNode)this._hierarchyData._nodes.get(0)));
            }
        }
        String colorSlot = "color".equals(colorField = this.getStringProperty(ITEM_COLOR_ID)) ? "color" : DATASLOT_LABEL;
        DataSlotEntry colorDataAccessor = dataSet.slot(colorSlot).entry();
        colorPalette.setNullColor(ObjectConverter.asString((Object)this.context.getPropertyValue("color.null")));
        boolean bl = legendVisibilityChanged = this._legends.anyVisible() != showLegend;
        if (legendVisibilityChanged) {
            this.updateType = 1;
        }
        this._legends.visible(showLegend).position(legendPosition).transition(doTransition, duration).setPreExecute(this.context.getPreExecute()).selector(0, this.context.node.selectAll("g.legend")).palette(0, colorPalette).shape(0, "square").title(0, this.context.getDataSlotLabel("legend.title", colorDataAccessor)).titleFill(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fill"))).titleFontSize(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontsize"))).titleFontFamily(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontfamily"))).setDataSlot(0, colorDataAccessor);
        List domain = null;
        if (colorDataAccessor != null && (domain = colorDataAccessor.domain()) == null) {
            String dataType = colorDataAccessor.type();
            domain = "numeric".equals(dataType) ? ScaleManager.ordinalDomainWithValueFunction((List)this._hierarchyData._nodes, (String)"numeric", this.colorAccessor(colorField, (SingleValueFunction<Object, Object>)colorDataAccessor, false), (boolean)true) : ScaleManager.ordinalDomainWithValueFunction((List)this._hierarchyData._nodes, (String)"string", this.colorAccessor(colorField, (SingleValueFunction<Object, Object>)colorDataAccessor, false), (boolean)false);
        }
        colorPalette.setData(domain, dataSet, colorSlot);
        colorPalette.setAccessor(this.colorAccessor(colorField, (SingleValueFunction<Object, Object>)colorDataAccessor, true));
        if (this.updateType <= 1) {
            this.prepareLayoutComponent();
            this.prepareLayoutSizables(this._layoutComponent, false, false, false, false, this._legends.anyVisible());
            this._legends.preLayout(this._layoutComponent);
            this._layoutComponent.layout();
            legendPosition = this._layoutComponent.legendPosition();
            this._legends.position(legendPosition);
            this.chartRect = this._layoutComponent.elementRect();
            this.legendRect = this._layoutComponent.legendRect();
            boolean showBreadCrumb = ObjectConverter.toBoolean((Object)this.context.getPropertyValue(SHOW_BREADCRUMB));
            this.breadcrumbRect = new RectStruct(this.chartRect.x, this.chartRect.y, this.chartRect.width, 15.0);
            if (showBreadCrumb) {
                this.chartRect.y += this.breadcrumbRect.height + 16.0;
                this.chartRect.height -= this.breadcrumbRect.height + 16.0;
                this.context.node.select((Object)".indicator").attr("visibility", (Object)"visible");
            } else {
                this.context.node.select((Object)".indicator").attr("visibility", (Object)"hidden");
            }
            if (legendPosition.equals("left") || legendPosition.equals("right")) {
                this.legendRect.y = this.chartRect.y;
                this.legendRect.height = this.chartRect.height;
            }
            this._legends.rectangle(this.legendRect);
        }
        this._clip.clipRect(this.chartRect).applyTo(this._chart.select((Object)".content")).run((Selection<?>)this.context.node.select((Object)"defs").transition().duration((Object)duration), new Object[0]);
        SingleValueFunction labelAccessor = TreemapView.accessorOf((DataSlotEntry)dataSet.slot(DATASLOT_LABEL).entry());
        SingleValueFunction<Object, Object> key = TreemapView.originalDatumAccessor((SingleValueFunction)TreemapView.accessorOf((DataSlotEntry)dataSet.slot(DATASLOT_KEY).entry()));
        ((TreemapComponentImpl)((TreemapComponentImpl)this._treemapComponent.key(key != null ? key : this.keyAccessor((SingleValueFunction<Object, Object>)labelAccessor))).bounds(this.chartRect).sort(this.getStringProperty("sort")).squareSizeBy(this.getStringProperty(SIZE_OR_COUNT_PROPERTY_ID)).mode(this.getStringProperty(MODE_ID)).colorPalette(colorPalette).labelAccessor(this.labelAccessor((SingleValueFunction<Object, Object>)labelAccessor)).labelFormatter((ValueFunction<Object, String>)this.context.getCustomFormatterForElementLabels(dataSet.slot(DATASLOT_LABEL).entry())).labelContrast(this.getBooleanProperty("contrast.label.color")).labelShadow(this.getBooleanProperty("label.shadow")).titleAccessor(this.titleAccessor((SingleValueFunction<Object, Object>)labelAccessor, (SingleValueFunction<Object, Object>)TreemapView.accessorOf((DataSlotEntry)dataSet.slot("color").entry()))).treemapNodeAccessor(new SingleValueFunction<TreemapNode, Object>(){

            public TreemapNode getValue(Object data) {
                return (TreemapNode)((HierarchyBundleDatum)data)._hierarchyNode;
            }
        }).setPreExecute(this.context.getPreExecute())).sizeAccessor((SingleValueFunction<Object, Object>)TreemapView.accessorOf((DataSlotEntry)sizeDataSlotEntry)).borderWidth(this._borderWidth).borderColor(ObjectConverter.asString((Object)this.context.getPropertyValue("border.color"))).itemLabel(this.getBooleanProperty("labelDisplay")).itemLabelLevel(this.getIntProperty(ITEM_LABEL_PROPERTY_ID)).labelFont(ObjectConverter.asString((Object)this.context.getPropertyValue(LABELSTYLE_FONT))).leadLabel(this.getBooleanProperty(LEAD_LABEL_DISPLAY));
        if (this.updateType <= 1) {
            Treemap treemap = this._treemapComponent.buildLayout();
            this._mappedNodes = ((TreemapNode)this._hierarchyData._root).children == null ? null : treemap.create((TreemapNode)this._hierarchyData._root).map((ArrayEx.ArrayValueFunction)new ArrayEx.ArrayValueFunction<TreemapNode, HierarchyBundleDatum<TreemapNode>>(){

                public HierarchyBundleDatum<TreemapNode> getValue(TreemapNode currentValue, int index, ArrayEx<TreemapNode> array) {
                    HierarchyBundleDatum<TreemapNode> d = new HierarchyBundleDatum<TreemapNode>();
                    d._hierarchyNode = currentValue;
                    return d;
                }
            });
        }
        int totalLevels = 0;
        if (this._mappedNodes != null) {
            for (Object o : this._mappedNodes) {
                totalLevels = Math.max(totalLevels, ((TreemapNode)((HierarchyBundleDatum)o)._hierarchyNode).depth);
            }
        }
        this._maxLevel = totalLevels;
        final TreemapView self = this;
        final ActionImpl unhighlightAction = this.context.actions.action("unhighlight");
        unhighlightAction.setBindFn(new BundleUtils.BindingOperation(){

            public void call() {
                self.context.node.selectAll(".rect").on("mouseout.default", (SelectorEventListener)new SelectorEventListener<Event>(){

                    public void onEvent(SceneNode context1, Object data, int index, int groupIndex, Event event) {
                        OMap attributes = self.getNodeStyle((HierarchyBundleDatum)data);
                        unhighlightAction.call(new Object[]{Rave.select((SceneNode)context1), attributes});
                    }
                });
            }
        });
        ActionImpl deselectAllAction = this.context.actions.action("deselectAll");
        this._borderWidth = CSSConverter.convertCSSSizeToPixelNumber((Object)this.context.getPropertyValue("border.width"), (double)100.0, (double)10.0).intValue();
        SelectorEventListener<Event> deselectAllEventListener = new SelectorEventListener<Event>(){

            public void onEvent(SceneNode context1, Object data, int index, int groupIndex, Event event) {
                self.context.node.selectAll(".rect").style("stroke-width", (ValueFunction)new ValueFunction<Object, Object>(){

                    public Object getValue(Object context2, Object data, int index, int groupIndex) {
                        return (self._maxLevel - ((TreemapNode)((HierarchyBundleDatum)data)._hierarchyNode).depth) * 2 + self._borderWidth + "px";
                    }
                }).style("stroke", (Object)ObjectConverter.asString((Object)self.context.getPropertyValue("border.color"))).style("opacity", (Object)1.0).property("selected", null);
            }
        };
        deselectAllAction.setBindFn(BundleUtils.bindOrUnbindActionFunctionCreater((BundleContext)this.context, (String)".background", (String[])new String[]{"click.default", "touchstart.default"}, (SelectorEventListener)deselectAllEventListener));
        int labelLevel = this.getIntProperty(ITEM_LABEL_PROPERTY_ID);
        if (labelLevel > this._maxLevel) {
            labelLevel = this._maxLevel;
        }
        if (this.updateType >= 1 && this.drillTargetNode != null) {
            labelLevel = Math.max(labelLevel, this.currentDrillLevel + 1);
        }
        if (this.updateType == 0 || labelLevel != this._previousLabelLevel) {
            this._labelNodes = this.getLabelData(labelLevel);
        }
        this._previousLabelLevel = labelLevel;
        this._treemapComponent.data(this._mappedNodes).labelData(this._labelNodes);
        this._treemapComponent.itemLabelLevel(labelLevel);
        ((BreadcrumbComponentImpl)this._breadcrumbComponent.setPreExecute(this.context.getPreExecute())).data(this._breadcrumbData).bounds(this.breadcrumbRect);
        this.setBackgroundProperties(this.chartRect, duration);
        if (this.updateType == 1 && this.drillTargetNode != null) {
            this.drawDrilledTreemap();
        } else {
            this._chart.selectAll("g.element-group").transition().duration((Object)duration).call((RunFunction)this._treemapComponent, new Object[0]);
        }
        this.context.node.selectAll("g.breadcrumb").transition().duration((Object)duration).call((RunFunction)this._breadcrumbComponent, new Object[0]);
        this._legends.draw();
        this.resetUpdate();
        this._chart.selectAll(".element-shape").classed("bundle-shape", true);
        this._chart.selectAll(".legendShape").classed("bundle-shape", true);
    }

    private void setIndex(ArrayEx<TreemapNode> nodes) {
        if (nodes != null) {
            for (TreemapNode n : nodes) {
                IndexedTreemapNode o = (IndexedTreemapNode)n;
                ++this._index;
                o._index = o._index;
                this.setIndex((ArrayEx<TreemapNode>)o.children);
            }
        }
    }

    private final ValueFunction<Object, Object> titleAccessor(final SingleValueFunction<Object, Object> labelAccessor, final SingleValueFunction<Object, Object> colorAccessor) {
        if (labelAccessor == null) {
            return null;
        }
        return new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                TreemapNode d = (TreemapNode)((HierarchyBundleDatum)data)._hierarchyNode;
                String title = "size : " + d.value;
                String color = ObjectConverter.asString((Object)colorAccessor.getValue(d.data));
                if (color != null) {
                    title = title + "\ncolor : " + color;
                }
                while (d.parent != null) {
                    String label = ObjectConverter.asString((Object)labelAccessor.getValue(d.data));
                    if (label == null) {
                        label = "(no label)";
                    }
                    title = label + "\n" + title;
                    d = (TreemapNode)d.parent;
                }
                return title;
            }
        };
    }

    private final SingleValueFunction<Object, Object> keyAccessor(final SingleValueFunction<Object, Object> labelAccessor) {
        if (labelAccessor == null) {
            return null;
        }
        return new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                TreemapNode d = (TreemapNode)((HierarchyBundleDatum)data)._hierarchyNode;
                String key = "";
                while (d.parent != null) {
                    String label = ObjectConverter.asString((Object)labelAccessor.getValue(d.data));
                    if (label != null) {
                        key = key + label;
                    }
                    d = (TreemapNode)d.parent;
                }
                return key;
            }
        };
    }

    private ValueFunction<Object, Object> labelAccessor(final SingleValueFunction<Object, Object> labelAccessor) {
        if (labelAccessor == null) {
            return null;
        }
        return new ValueFunction<Object, Object>(){

            public Object getValue(Object ctxt, Object data, int index, int groupIndex) {
                TreemapNode d = (TreemapNode)((HierarchyBundleDatum)data)._hierarchyNode;
                return labelAccessor.getValue(d.data);
            }
        };
    }

    private ArrayEx<Object> getLabelData(int labelLevel) {
        if (this._mappedNodes != null) {
            ArrayEx result = new ArrayEx();
            for (Object o : this._mappedNodes) {
                TreemapNode d = (TreemapNode)((HierarchyBundleDatum)o)._hierarchyNode;
                if (d.data == null || d.depth != labelLevel && (d.depth >= labelLevel || d.children != null) && (!this.getBooleanProperty(LEAD_LABEL_DISPLAY) || d.depth != 1 && (d.depth != labelLevel - 1 || labelLevel <= 1)) || this.outsideBounds(d)) continue;
                result.add(o);
            }
            return result;
        }
        return null;
    }

    private boolean outsideBounds(TreemapNode node) {
        boolean vertex;
        double precision = 1.0;
        boolean bl = vertex = node.x + this.chartRect.x < -precision || node.x > this.chartRect.width + precision || node.y + this.chartRect.y < -precision || node.y > this.chartRect.height + precision;
        if (vertex) {
            return true;
        }
        return node.x + this.chartRect.x + node.dx < -precision || node.x + node.dx > this.chartRect.width + precision || node.y + this.chartRect.y + node.dy < -precision || node.y + node.dy > this.chartRect.height + precision;
    }

    private SingleValueFunction<Object, Object> colorAccessor(String colorSlot, final SingleValueFunction<Object, Object> colorAccessor, final boolean sortedData) {
        if (colorAccessor == null) {
            return null;
        }
        if (!"color".equals(colorSlot)) {
            final int level = Integer.parseInt(colorSlot.substring(5));
            return new SingleValueFunction<Object, Object>(){

                public Object getValue(Object data) {
                    TreemapNode d;
                    TreemapNode treemapNode = d = sortedData ? (TreemapNode)((HierarchyBundleDatum)data)._hierarchyNode : (TreemapNode)data;
                    if (d.data == null) {
                        return null;
                    }
                    if (d.depth == level || d.depth < level && d.children == null) {
                        return colorAccessor.getValue(d.data);
                    }
                    if (d.depth > level) {
                        TreemapNode p = this.findParent(d, level);
                        return colorAccessor.getValue(p.data);
                    }
                    return null;
                }

                private TreemapNode findParent(TreemapNode d, int level2) {
                    if (d.depth == level2) {
                        return d;
                    }
                    return this.findParent((TreemapNode)d.parent, level2);
                }
            };
        }
        return new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                TreemapNode d = sortedData ? (TreemapNode)((HierarchyBundleDatum)data)._hierarchyNode : (TreemapNode)data;
                return d.data != null && d.children == null ? colorAccessor.getValue(d.data) : null;
            }
        };
    }

    protected int requireUpdate(String property) {
        if ((property.equals(ITEM_LABEL_PROPERTY_ID) || property.equals(LEAD_LABEL_DISPLAY)) && !this.getBooleanProperty("labelDisplay")) {
            return 4;
        }
        return super.requireUpdate(property);
    }

    private OMap<String, Object> getNodeStyle(HierarchyBundleDatum<TreemapNode> data) {
        String borderColor = ObjectConverter.asString((Object)this.context.getPropertyValue("border.color"));
        String width = (this._maxLevel - ((TreemapNode)data._hierarchyNode).depth) * 2 + this._borderWidth + "px";
        OMap attributes = new OMap();
        attributes.put((Object)"stroke-width", (Object)width);
        attributes.put((Object)"stroke", (Object)borderColor);
        return attributes;
    }

    @Override
    protected String[] getGroupStructure() {
        return new String[]{"defs", "g.vizlibrary vizlibrary-treemap", "(", "rect.background chart", "g.breadcrumb", "g.chart", "(", "g.content", "(", "rect.background elements", "g.elements", "(", "g.element-group", ")", ")", ")", "g.legends", "(", "g.legends-layout", "g.legend", ")", ")"};
    }
}

